# Procedura di sincronizzazione file vs TSE Cloud AI

## Prerequisiti

Versione Microsoft PowerShell 7.5.x
TSE Cloud: Abilitazione impianto all'utilizzo servizi web (licenzaa 4520)

## Parametri file di configurazione

Il file di configurazione `config.json` deve contenere i seguenti parametri:
### Autenticazione
- `username`: Il nome utente per l'autenticazione.
- `grant_type`: Il tipo di grant per l'autenticazione.
- `scope`: Lo scope per l'autenticazione.
- `token`: Il token per l'autenticazione.
- `webapi_base_url`: L'URL base dell'API web.
### Gestione file
- `log_to_file`: Booleano che indica se il log deve essere scritto su file.
- `backup_folder`: La cartella di backup per i file caricati.
- `upload_folder`: La cartella da cui caricare i file.
- `download_folder`: La cartella in cui scaricare i file.
- `file_extension_regex`: L'espressione regolare per filtrare i file da caricare.
- `fixed_path_type`: Il tipo di percorso fisso per l'API (UserFileTemp).
- `upload_relative_path`: Il percorso relativo per l'upload dei file.
- `download_relative_path`: Il percorso relativo per il download dei file.
- `delete_after_download`: Booleano che indica se i file devono essere eliminati dopo il download.

Esempio di file `config.json`:
```json
{
  "username": "admin_webap1",
  "grant_type": "token",
  "scope": "webapi1_alywebapi1",
  "token": "xxxxxxxxxxxxxxxxxxxxxxxxxxxx",
  "webapi_base_url": "https://webapi1.teamsystem.io",
  "log_to_file": true,
  "backup_folder": "C:/Users/Ghost\Desktop/imp-exp/backup",
  "upload_folder": "C:/Users/Ghost/Desktop/imp-exp/upload",
  "download_folder": "C:/Users/Ghost/Desktop/imp-exp/download",
  "file_extension_regex": "^imp-exp.*\\.(xls|csv|txt)$",
  "fixed_path_type": "UserFileTemp",
  "upload_relative_path": "export",
  "download_relative_path": "import",
  "delete_after_download": true
}
```

## Eseguire lo script PowerShell
Naviga alla directory contenente il file `sync-file.ps1` usando il comando:
```sh
cd /Users/Ghost/Desktop/Dev/quickstart/ps-impexp
```
Esegui il file PowerShell con il comando:
```sh
pwsh ./sync-file.ps1
```

### Su Windows:
1. Apri PowerShell: Puoi farlo cercando "PowerShell" nel menu Start e cliccando sull'icona.
2. Naviga alla directory del file: Usa il comando `cd` per spostarti nella directory dove si trova il file `.ps1`. Ad esempio:
    ```sh
    cd C:\Percorso\Al\Tuo\File
    ```
3. Esegui il file: Una volta nella directory corretta, esegui il file digitando:
    ```sh
    .\sync-file.ps1
    ```

## Schedulazione script PowerShell

Per la schedulazione seguire i seguenti passaggi:
- Utilizzare un utente con privilegi di amministrazione.
- Nelle azioni indicare l'eseguibile PowerShell (min v7.5) es. "C:\Program Files\PowerShell\7\pwsh.exe".
- Negli argomenti specificare il nome del file `.ps1` es. `C:\imp-exp\main\sync-file.ps1`.
- Nello start in, indicare la cartella dove viene eseguito il task es. `C:\imp-exp\main`.

## Log

Il file `output.log` viene utilizzato per registrare i messaggi di log generati durante l'esecuzione dello script PowerShell. Questo file contiene informazioni utili per il debug e il monitoraggio delle operazioni eseguite dallo script.

### Implementazione

Il file `output.log` viene gestito dalla funzione `Log-Output` definita nel file `logging.ps1`. Questa funzione accetta due parametri:
- `message`: Il messaggio da registrare.
- `logToFile`: Un booleano che indica se il messaggio deve essere scritto su file.

### Funzionamento

La funzione `Log-Output` esegue le seguenti operazioni:
1. Genera un timestamp per il messaggio di log.
2. Crea il messaggio di log combinando il timestamp e il messaggio fornito.
3. Scrive il messaggio di log sulla console.
4. Se il parametro `logToFile` è `true`, aggiunge il messaggio di log al file `output.log`.

### Esempio di contenuto del file `output.log`

```log
[2025-03-12 16:51:42] Token URL: https://webapi1.teamsystem.io/api/auth/token
[2025-03-12 16:51:43] Token di accesso ricevuto!
[2025-03-12 16:51:43] Numero di file da caricare: 0
[2025-03-12 16:51:43] Get files: 
[2025-03-12 16:51:43] Lista file scaricata in files.json
[2025-03-12 16:51:43] HTTP Status Code: 
[2025-03-12 16:51:43] Numero di file da scaricare: 0
[2025-03-12 16:51:43] Numero totale di file scaricati con successo: 0
```
