'use strict';


/**
 * Get new
 * Get an empty object of type corresponding
 *
 * _op String The value must be 'new'
 * param String Specify optional parameters that will be used during entity creation
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns DocumentoTestataMGDTO
 **/
exports.apiV1EnvironmentMGDocumentoGET = function(_op,param,environment,authorizationScope,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "totaliDocumento" : {
    "totalePagare" : 7.691531173686691,
    "scimpmerce" : 2.1184454156145116,
    "totspbolli" : 0.907335931343648,
    "acconto" : 2.7105647837031563,
    "ivaomag" : 8.776709848030322,
    "totaleCosto" : 9.660013839736129,
    "abbuono" : 5.799021278474435,
    "marginedocumento" : 9.576768325858186,
    "imponibomag" : 1.5673210879004595,
    "scimpcassa" : 5.473133728634785,
    "scpercassa2" : 3.93938484566677,
    "scpermerce3" : 9.616627406338315,
    "totdocumento" : 2.376630828418186,
    "scpercassa1" : 6.434791978928281,
    "scpermerce2" : 8.65952233326453,
    "scpermerce1" : 2.162514338057849,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "totimponibile" : 5.898513389775777,
    "totiva" : 2.4062866311545816,
    "totspinc" : 6.232321224432258
  },
  "callOptions" : {
    "flgLockOnDocExist" : false,
    "enableAdditionalValidations" : false,
    "flgSpincasForceZero" : false,
    "esclusioneAgentiMultipli" : false,
    "esclusioneSpeseTestiCliFor" : false,
    "flgSpbolliForceZero" : false,
    "disableLetterOfIntent" : false,
    "esclusioneIvaTestata" : false,
    "flgDisableItemControl" : false
  },
  "valutaCg08" : "valutaCg08",
  "flgSpbolli" : 1,
  "numdocorig" : "numdocorig",
  "codIva" : {
    "flgSospimp" : 1.633699845078339,
    "indNatura" : 8,
    "flgAgri" : 6.090696483578148,
    "tipologia" : 4.778706604314481,
    "percindet" : 6.389489858092311,
    "mossperc" : 5.305668385940959,
    "natureEsCO" : {
      "descr" : "descr",
      "codice" : "codice",
      "datainival" : "2000-01-23T04:56:07.000+00:00",
      "natureAssCO" : [ null, null ],
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "id" : 3,
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "verslynfa" : "verslynfa",
    "idExtendedAttributeEntity" : 0,
    "annotazioni" : "annotazioni",
    "rowVersion" : "",
    "indNatassoswCg2n" : 7,
    "perciva" : 5.201737367852583,
    "percforf" : 6.541917087228235,
    "codice" : "codice",
    "impostamonofasersm" : 4.851239691941878,
    "codiceOss" : "codiceOss",
    "extensionData" : [ null, null ],
    "stdcodivarifCg28" : "stdcodivarifCg28",
    "flgMossgest" : 3,
    "flgAutoue" : 1.2880645475702646,
    "flgIndet" : 2.9790233918904585,
    "codPlafond" : 7.239590766928185,
    "note" : "note",
    "flgAssport398" : 6.677419970877656,
    "flgMossrid" : 0,
    "indStaper" : 3.474156394106027,
    "flgAllclifor" : 9.852147203726787,
    "codiceagr" : "codiceagr",
    "flgImpostadibollo" : 4,
    "flgCorrVent" : 1.822577900073098,
    "aliqivavent" : 2.6736395633233356,
    "flgNotvar" : 7.224413148959403,
    "percmonofasersm" : 6.614319261836819,
    "idprov" : 0.42286244411048224,
    "idExtendedAttributeSubEntity" : 3,
    "natureAssCO" : {
      "descr" : "descr",
      "idCg2m" : 3,
      "idassosw" : 5,
      "codice" : "codice",
      "datainival" : "2000-01-23T04:56:07.000+00:00",
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "flgMonofasersm" : 2.6249013358703053,
    "mosscodCg07" : 6.711221582652969,
    "descrizione" : "descrizione",
    "flgEscludiblacklist" : 5.083590215108117,
    "flgIvaedit" : 9.693372334146686,
    "indtipopart" : 6.008900790410507
  },
  "bancaCg12" : 5.637376656633329,
  "ditta" : 2.027123023002322,
  "anagraficaDocumentoDitta" : {
    "indStaperMg36" : 6.027456183070403,
    "codDocumMg36" : "codDocumMg36",
    "dittaCg18" : 0.8008281904610115,
    "sezdefault" : "sezdefault",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    }
  },
  "testoletint" : "testoletint",
  "indfattpa" : 1,
  "sezautof" : "sezautof",
  "cliforfatt" : 9.301444243932576,
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "customerSupplierMG" : {
    "statoAttualeCO" : {
      "statiDisponibili" : [ null, null ],
      "statoCorrente" : {
        "indTipoStato" : 8,
        "idStato" : 2,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "seq" : 2
      },
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "contratto" : "contratto",
    "idCliFor" : 8,
    "idmediaCg99" : 7.740351818741173,
    "blackListGeneralMasterData" : {
      "datavalid" : "2000-01-23T04:56:07.000+00:00",
      "ragsofiscex" : "ragsofiscex",
      "addresses" : [ {
        "indirizzocomp2" : "indirizzocomp2",
        "addressesType" : [ {
          "tipo" : 6,
          "idCG1J" : 6,
          "pluginData" : {
            "key" : ""
          },
          "id" : 2,
          "additionalData" : {
            "key" : ""
          }
        }, {
          "tipo" : 6,
          "idCG1J" : 6,
          "pluginData" : {
            "key" : ""
          },
          "id" : 2,
          "additionalData" : {
            "key" : ""
          }
        } ],
        "risstato" : "risstato",
        "riszip" : "riszip",
        "pv" : "pv",
        "precisione" : "precisione",
        "codlinguaMg52" : "codlinguaMg52",
        "frazione" : "frazione",
        "emailPec" : "emailPec",
        "tipologia" : "tipologia",
        "via" : "via",
        "idTeamportal" : 6,
        "numciv" : "numciv",
        "cap" : "cap",
        "latitudine" : 3.5571952270680973,
        "statoCg07" : 1.284659006116532,
        "presso" : "presso",
        "federalStateViewCO" : {
          "descr" : "descr",
          "iso3166statofed" : "iso3166statofed",
          "a2iso3166Cg07" : "a2iso3166Cg07",
          "pluginData" : {
            "key" : ""
          },
          "codiceCg07" : 5.944895607614016,
          "additionalData" : {
            "key" : ""
          },
          "statofed" : "statofed"
        },
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "fax" : "fax",
        "statofed" : "statofed",
        "telefono" : "telefono",
        "datamod" : "2000-01-23T04:56:07.000+00:00",
        "email" : "email",
        "citta" : "citta",
        "ragsoc" : "ragsoc",
        "cellnum" : "cellnum",
        "comanaCg01" : "comanaCg01",
        "codiceCg16" : 8,
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "ragsocex" : "ragsocex",
        "rifindirizzo" : "rifindirizzo",
        "codicesfed" : "codicesfed",
        "contea" : "contea",
        "indirizzocomp" : "indirizzocomp",
        "riswarning" : "riswarning",
        "indirizzoex" : "indirizzoex",
        "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
        "risregione" : "risregione",
        "edificio" : "edificio",
        "statoEst" : {
          "codSian" : 3.353193347011243,
          "crtpiva" : "crtpiva",
          "leniban" : 6,
          "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
          "desiso3166" : "desiso3166",
          "idmediaCg99" : 0.8851374739011653,
          "codice" : 6.704019297950036,
          "numiso3166" : "numiso3166",
          "codiceCg08" : "codiceCg08",
          "currencyCO" : {
            "sigla" : "sigla",
            "dataattuem" : "2000-01-23T04:56:07.000+00:00",
            "numdec" : 7.04836565559697,
            "exchangeRateCO" : [ {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            }, {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            } ],
            "idmediaCg99" : 8.969578798196912,
            "codice" : "codice",
            "indCertoincerto" : 7,
            "cambiofisso" : 0.10263654006109402,
            "descr" : "descr",
            "flgValuem" : 4.652396432933246,
            "indValuem" : 3.0576100241049344,
            "indSepmigl" : 3.0205796992916243,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "descr" : "descr",
          "flgIban" : 3,
          "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
          "codIso" : "codIso",
          "a3iso3166" : "a3iso3166",
          "indTipostato" : 7.058770351582356,
          "a2iso3166" : "a2iso3166",
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "datacee" : "2000-01-23T04:56:07.000+00:00",
          "flgSepa" : 7
        },
        "longitudine" : 6.965117697638846,
        "indweb" : "indweb"
      }, {
        "indirizzocomp2" : "indirizzocomp2",
        "addressesType" : [ {
          "tipo" : 6,
          "idCG1J" : 6,
          "pluginData" : {
            "key" : ""
          },
          "id" : 2,
          "additionalData" : {
            "key" : ""
          }
        }, {
          "tipo" : 6,
          "idCG1J" : 6,
          "pluginData" : {
            "key" : ""
          },
          "id" : 2,
          "additionalData" : {
            "key" : ""
          }
        } ],
        "risstato" : "risstato",
        "riszip" : "riszip",
        "pv" : "pv",
        "precisione" : "precisione",
        "codlinguaMg52" : "codlinguaMg52",
        "frazione" : "frazione",
        "emailPec" : "emailPec",
        "tipologia" : "tipologia",
        "via" : "via",
        "idTeamportal" : 6,
        "numciv" : "numciv",
        "cap" : "cap",
        "latitudine" : 3.5571952270680973,
        "statoCg07" : 1.284659006116532,
        "presso" : "presso",
        "federalStateViewCO" : {
          "descr" : "descr",
          "iso3166statofed" : "iso3166statofed",
          "a2iso3166Cg07" : "a2iso3166Cg07",
          "pluginData" : {
            "key" : ""
          },
          "codiceCg07" : 5.944895607614016,
          "additionalData" : {
            "key" : ""
          },
          "statofed" : "statofed"
        },
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "fax" : "fax",
        "statofed" : "statofed",
        "telefono" : "telefono",
        "datamod" : "2000-01-23T04:56:07.000+00:00",
        "email" : "email",
        "citta" : "citta",
        "ragsoc" : "ragsoc",
        "cellnum" : "cellnum",
        "comanaCg01" : "comanaCg01",
        "codiceCg16" : 8,
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "ragsocex" : "ragsocex",
        "rifindirizzo" : "rifindirizzo",
        "codicesfed" : "codicesfed",
        "contea" : "contea",
        "indirizzocomp" : "indirizzocomp",
        "riswarning" : "riswarning",
        "indirizzoex" : "indirizzoex",
        "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
        "risregione" : "risregione",
        "edificio" : "edificio",
        "statoEst" : {
          "codSian" : 3.353193347011243,
          "crtpiva" : "crtpiva",
          "leniban" : 6,
          "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
          "desiso3166" : "desiso3166",
          "idmediaCg99" : 0.8851374739011653,
          "codice" : 6.704019297950036,
          "numiso3166" : "numiso3166",
          "codiceCg08" : "codiceCg08",
          "currencyCO" : {
            "sigla" : "sigla",
            "dataattuem" : "2000-01-23T04:56:07.000+00:00",
            "numdec" : 7.04836565559697,
            "exchangeRateCO" : [ {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            }, {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            } ],
            "idmediaCg99" : 8.969578798196912,
            "codice" : "codice",
            "indCertoincerto" : 7,
            "cambiofisso" : 0.10263654006109402,
            "descr" : "descr",
            "flgValuem" : 4.652396432933246,
            "indValuem" : 3.0576100241049344,
            "indSepmigl" : 3.0205796992916243,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "descr" : "descr",
          "flgIban" : 3,
          "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
          "codIso" : "codIso",
          "a3iso3166" : "a3iso3166",
          "indTipostato" : 7.058770351582356,
          "a2iso3166" : "a2iso3166",
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "datacee" : "2000-01-23T04:56:07.000+00:00",
          "flgSepa" : 7
        },
        "longitudine" : 6.965117697638846,
        "indweb" : "indweb"
      } ],
      "codiceident" : "codiceident",
      "indirCorEX" : "indirCorEX",
      "flgFattpa" : 7,
      "indirizzo" : "indirizzo",
      "ragsoanagex" : "ragsoanagex",
      "codiceCg07" : 7.061401241503109,
      "indsoggrit" : 7.457744773683766,
      "ragSoAnag" : "ragSoAnag",
      "capcor" : "capcor",
      "cittafisc" : "cittafisc",
      "intragroupStructureCO" : {
        "descr" : "descr",
        "codice" : 7.260521264802104,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "codAnagGen" : 4,
        "codIntercompany" : 9
      },
      "statofiscCg07" : 5.025004791520295,
      "tel2num" : "tel2num",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codfiscale" : "codfiscale",
      "statofed" : "statofed",
      "codrichiamo" : 2,
      "provfisc" : "provfisc",
      "idExtendedAttributeEntity" : 9,
      "citta" : "citta",
      "statonascitaCg07" : 9.965781217890562,
      "codice" : 2,
      "indFiscale" : "indFiscale",
      "nome" : "nome",
      "comnascitaCg01" : "comnascitaCg01",
      "codiceCg15" : "codiceCg15",
      "extensionData" : [ {
        "value" : "",
        "key" : "key"
      }, {
        "value" : "",
        "key" : "key"
      } ],
      "ragsofisc" : "ragsofisc",
      "indemail" : "indemail",
      "indirizzoEX" : "indirizzoEX",
      "comfisCg01" : "comfisCg01",
      "comnascita" : "comnascita",
      "partiva" : "partiva",
      "flgNoblacklist" : 1.2315135367772556,
      "partivaEst" : "partivaEst",
      "cognome" : "cognome",
      "idmediaCg99" : 6.84685269835264,
      "wtCodeCO" : {
        "causdd1" : "causdd1",
        "codNonsog" : 0.8774076871421566,
        "flgRegagevo" : 4.86315908102884,
        "idmediaCg99" : 3.901545264248647,
        "percRipPerc" : 1.8268702177058116,
        "flgRitImposta" : 6.073898085781152,
        "codPrev" : "codPrev",
        "tiporapporto" : "tiporapporto",
        "percripaz" : 9.254183946267839,
        "pluginData" : {
          "key" : ""
        },
        "flgPignTerzi" : 7.933506881737151,
        "flgProteo360" : 5.507386964179881,
        "additionalData" : {
          "key" : ""
        },
        "flgGlad" : 9.702963800023566,
        "codFiscPrev" : "codFiscPrev",
        "gcprev" : 4,
        "idprov" : 0.43431398824148815,
        "codice" : "codice",
        "percci" : 4.573936264232251,
        "flgSosprit" : 8,
        "descr" : "descr",
        "flgMinimi" : 0,
        "codTributo" : "codTributo",
        "indCodattglad" : 2.9409642974827896,
        "indTipocassa" : 1,
        "percra" : 8.863729185622827,
        "percbaseimp" : 6.623518433804886,
        "codTribrp" : "codTribrp",
        "inpsivs" : 8.28965939814297,
        "rowversion" : ""
      },
      "dtiniziopec" : "2000-01-23T04:56:07.000+00:00",
      "capfisc" : "capfisc",
      "codicecorCg07" : 3.616076749251911,
      "codiceCgc0" : 9.301444243932576,
      "cap" : "cap",
      "faxnum" : "faxnum",
      "alias" : "alias",
      "flgOmonimo" : 1.0246457001441578,
      "provnascita" : "provnascita",
      "ragsocor" : "ragsocor",
      "prov" : "prov",
      "flgAnagval" : 4.145608029883936,
      "rapazestCg16" : 1,
      "cellnum" : "cellnum",
      "flgPrsfis" : 1.4894159098541704,
      "tel1num" : "tel1num",
      "idExtendedAttributeSubEntity" : 6,
      "provcor" : "provcor",
      "dtfinepec" : "2000-01-23T04:56:07.000+00:00",
      "cittacor" : "cittacor",
      "codicesfed" : "codicesfed",
      "statofedfisc" : "statofedfisc",
      "indFiscaleEX" : "indFiscaleEX",
      "partitaIVA" : "partitaIVA",
      "indirCor" : "indirCor",
      "sesso" : 4.965218492984954,
      "lastchange" : "2000-01-23T04:56:07.000+00:00",
      "ragsocorex" : "ragsocorex",
      "datanascita" : "2000-01-23T04:56:07.000+00:00",
      "auidAu04" : 5,
      "indweb" : "indweb"
    },
    "goods" : {
      "reverseTypeFI" : {
        "reverseTypeCode" : 0,
        "reverseTypeDescription" : "reverseTypeDescription",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "flgBilconsattpassdist" : 0,
      "contochiu" : "contochiu",
      "flgAnalit" : 5,
      "codeformatted" : "codeformatted",
      "intragroupStructureCO" : {
        "descr" : "descr",
        "codice" : 7.260521264802104,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "codAnagGen" : 4,
        "codIntercompany" : 9
      },
      "flgAggfatt" : 8,
      "indLivchius" : 3,
      "idcontoratattCg24" : 6,
      "idcontoapeCg24" : 8,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "contocrsosp" : "contocrsosp",
      "flgContoimm" : 1,
      "flgOpnonfin" : 5.547564904556697,
      "indDaavec" : 3,
      "cogeprogeMateriali" : 2,
      "coaAccountCustomizationFI" : [ {
        "descr" : "descr",
        "iddespcon" : 6,
        "dittaCg18" : 5.616380282218067,
        "contoCg24" : "contoCg24",
        "idmediaCg99" : 7.014147440046284,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "gruppoCg10" : 9.966789814889403,
        "idCg24" : 9,
        "rowversion" : ""
      }, {
        "descr" : "descr",
        "iddespcon" : 6,
        "dittaCg18" : 5.616380282218067,
        "contoCg24" : "contoCg24",
        "idmediaCg99" : 7.014147440046284,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "gruppoCg10" : 9.966789814889403,
        "idCg24" : 9,
        "rowversion" : ""
      } ],
      "accountType" : 9,
      "contoratpass" : "contoratpass",
      "descr" : "descr",
      "idcontorisattCg24" : 1,
      "indDaav" : 1,
      "suddconti" : 8.780989965779524,
      "contoratatt" : "contoratatt",
      "indMastroCliFor" : 1.9732909296667345,
      "idcontochiuCg24" : 8,
      "percindetra" : 0.9178980228274691,
      "codiceCg22" : 4.863793115215697,
      "indAttpasspor" : 1,
      "indTipoconto" : 4,
      "contoape" : "contoape",
      "flgGespor" : 2,
      "cogeprogeAbil" : 2,
      "flgSaldog" : 5,
      "percindeduc" : 8.262575023052213,
      "contorisatt" : "contorisatt",
      "codiceCgc0" : 2.008994665592807,
      "flgValutaest" : 5,
      "flgRaganal" : 9,
      "alias" : "alias",
      "conto" : "conto",
      "balanceSheetAccountCategory" : 1,
      "cogeprogeNodo" : 6,
      "contorispass" : "contorispass",
      "indContoricav" : 4,
      "vatTypeFI" : {
        "descr" : "descr",
        "indAutofattura" : 7,
        "agviaggio" : 0,
        "codice" : 4.318826475758856,
        "pluginData" : {
          "key" : ""
        },
        "localizzazione" : 8,
        "additionalData" : {
          "key" : ""
        },
        "codiceCg0d" : 9.908114046741538,
        "indTipo" : 7.437703257022269
      },
      "idcontorispassCg24" : 2,
      "cogeprogeAttivita" : 8,
      "flgGesec" : 8,
      "coaInternationalCustomizationFI" : [ {
        "contoCg24" : "contoCg24",
        "subcategoria" : 8,
        "categoria" : 3,
        "gbDeferralcode" : "gbDeferralcode",
        "esModulo347" : 5,
        "pluginData" : {
          "key" : ""
        },
        "id" : 7,
        "iso3166A2" : "iso3166A2",
        "additionalData" : {
          "key" : ""
        },
        "gruppoCg10" : 8.331741856019029,
        "idCg24" : 9,
        "rowversion" : ""
      }, {
        "contoCg24" : "contoCg24",
        "subcategoria" : 8,
        "categoria" : 3,
        "gbDeferralcode" : "gbDeferralcode",
        "esModulo347" : 5,
        "pluginData" : {
          "key" : ""
        },
        "id" : 7,
        "iso3166A2" : "iso3166A2",
        "additionalData" : {
          "key" : ""
        },
        "gruppoCg10" : 8.331741856019029,
        "idCg24" : 9,
        "rowversion" : ""
      } ],
      "gruppoCg10" : 8.546645780823726,
      "coaAccountStateFI" : [ {
        "consosCg24" : "consosCg24",
        "dittaCg18" : 0.8972273556195443,
        "dtdisatt" : "2000-01-23T04:56:07.000+00:00",
        "grusosCg10" : 1.7692392591014339,
        "pluginData" : {
          "key" : ""
        },
        "idstatipdc" : 9,
        "additionalData" : {
          "key" : ""
        },
        "dtconsos" : "2000-01-23T04:56:07.000+00:00",
        "flgDisatt" : 9.684087197655908,
        "idCg24" : 6,
        "rowversion" : ""
      }, {
        "consosCg24" : "consosCg24",
        "dittaCg18" : 0.8972273556195443,
        "dtdisatt" : "2000-01-23T04:56:07.000+00:00",
        "grusosCg10" : 1.7692392591014339,
        "pluginData" : {
          "key" : ""
        },
        "idstatipdc" : 9,
        "additionalData" : {
          "key" : ""
        },
        "dtconsos" : "2000-01-23T04:56:07.000+00:00",
        "flgDisatt" : 9.684087197655908,
        "idCg24" : 6,
        "rowversion" : ""
      } ],
      "coaGroupCodeFI" : {
        "descr" : "descr",
        "numlivcons" : 6.460213024504889,
        "gruppo" : 8.289598895249666,
        "numlivelli" : 6.8668894011844035,
        "accountProposals" : [ {
          "contoCg24" : "contoCg24",
          "codice" : 7.375698277301938,
          "pluginData" : {
            "key" : ""
          },
          "id" : 0,
          "additionalData" : {
            "key" : ""
          },
          "gruppoCg10" : 6.97635352548152,
          "idCg24" : 9,
          "rowversion" : ""
        }, {
          "contoCg24" : "contoCg24",
          "codice" : 7.375698277301938,
          "pluginData" : {
            "key" : ""
          },
          "id" : 0,
          "additionalData" : {
            "key" : ""
          },
          "gruppoCg10" : 6.97635352548152,
          "idCg24" : 9,
          "rowversion" : ""
        } ],
        "pluginData" : {
          "key" : ""
        },
        "maskedit" : "maskedit",
        "additionalData" : {
          "key" : ""
        },
        "flgPdclib" : 9,
        "rowversion" : ""
      },
      "idparent" : 1,
      "idreverse" : 7,
      "flgIntercompany" : 8,
      "idcontoratpassCg24" : 7,
      "flgRarp" : 2,
      "idconto" : 4,
      "cogeprogeSpese" : 5,
      "idRifPdC80" : 7,
      "indCosvend" : 4
    },
    "flgAttivo" : 0.8851374739011653,
    "tipocfCg40" : 5.533258397034986,
    "dmsPublishedEntityFW" : {
      "tipoarchHm30" : 2,
      "idknos" : 6,
      "dittaCg18" : 1.0046985756074744,
      "flgInvalid" : 3,
      "datapub" : "2000-01-23T04:56:07.000+00:00",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "protocollo" : "protocollo",
      "nome" : "nome",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "publicationid" : "publicationid",
      "percorso" : "percorso"
    },
    "officeCO" : {
      "indIrizzo" : "indIrizzo",
      "idmediaCg99" : 6.720288821326667,
      "codice" : 7.766860781935265,
      "indDimcentrocomm" : 5.304373278797373,
      "cap" : "cap",
      "dittaCg18" : 1.6056289151258096,
      "progRea" : 8.708394192403432,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "prov" : "prov",
      "numerorea" : "numerorea",
      "citta" : "citta",
      "rowversion" : ""
    },
    "flgInterCompany" : 6.519180951018382,
    "paymentTermCO" : {
      "flgDesc" : 0.8164256701298711,
      "paymentTermDetailCO" : [ {
        "indImpfix" : 1.4985931822280574,
        "daggfix1" : 9.140242185517025,
        "daggfix2" : 8.81377937009168,
        "ggmmfix" : 3.8463127686084055,
        "ggdecor" : 6.936593194494838,
        "idCg64" : 2,
        "imporfix" : 2.3317418552851765,
        "flgFrperciva" : 2.408218941758913,
        "idCg62" : 4,
        "pluginData" : {
          "key" : ""
        },
        "id" : 4,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 7.321091499885957,
        "indTipocalend" : 7,
        "indTipodecor" : 9.739448828157911,
        "aggfix2" : 9.610516429629122,
        "aggfix1" : 5.948961008630453,
        "perciva" : 5.099298781640682,
        "el2frimp" : 4.180725413706508,
        "ggscadfix2" : 5.103912736584151,
        "tipoeff" : 3.3182952910080674,
        "flgFrpercimp" : 7.686670838404092,
        "percimp" : 0.05965928697733491,
        "prog" : 9.728706165995554,
        "el1frimp" : 4.39343993729625,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 0.6052866655822231,
        "subTypeCO" : {
          "ggoffset" : 9.629537564416708,
          "codiceCg07" : 8.50835276411088,
          "tipoeff" : 0.391063602337155,
          "codPaguc" : "codPaguc",
          "descstipo" : "descstipo",
          "codStipoeff" : 9.551762125042277,
          "flgAssegno" : 5,
          "indModfatturapa" : 2,
          "nationCO" : {
            "codSian" : 3.353193347011243,
            "crtpiva" : "crtpiva",
            "leniban" : 6,
            "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
            "desiso3166" : "desiso3166",
            "idmediaCg99" : 0.8851374739011653,
            "codice" : 6.704019297950036,
            "numiso3166" : "numiso3166",
            "codiceCg08" : "codiceCg08",
            "currencyCO" : {
              "sigla" : "sigla",
              "dataattuem" : "2000-01-23T04:56:07.000+00:00",
              "numdec" : 7.04836565559697,
              "exchangeRateCO" : [ {
                "cambio" : 4.078845849666752,
                "anno" : 3.2588565619047607,
                "idmediaCg99" : 6.628464275087742,
                "codiceCg08" : "codiceCg08",
                "indCertoincerto" : 4,
                "codicerifCg08" : "codicerifCg08",
                "giorno" : 0.2025324113236393,
                "mese" : 1.041444916118296,
                "pluginData" : {
                  "key" : ""
                },
                "additionalData" : {
                  "key" : ""
                },
                "adegcambio" : 5.533258397034986,
                "rowversion" : ""
              }, {
                "cambio" : 4.078845849666752,
                "anno" : 3.2588565619047607,
                "idmediaCg99" : 6.628464275087742,
                "codiceCg08" : "codiceCg08",
                "indCertoincerto" : 4,
                "codicerifCg08" : "codicerifCg08",
                "giorno" : 0.2025324113236393,
                "mese" : 1.041444916118296,
                "pluginData" : {
                  "key" : ""
                },
                "additionalData" : {
                  "key" : ""
                },
                "adegcambio" : 5.533258397034986,
                "rowversion" : ""
              } ],
              "idmediaCg99" : 8.969578798196912,
              "codice" : "codice",
              "indCertoincerto" : 7,
              "cambiofisso" : 0.10263654006109402,
              "descr" : "descr",
              "flgValuem" : 4.652396432933246,
              "indValuem" : 3.0576100241049344,
              "indSepmigl" : 3.0205796992916243,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              }
            },
            "descr" : "descr",
            "flgIban" : 3,
            "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
            "codIso" : "codIso",
            "a3iso3166" : "a3iso3166",
            "indTipostato" : 7.058770351582356,
            "a2iso3166" : "a2iso3166",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "datacee" : "2000-01-23T04:56:07.000+00:00",
            "flgSepa" : 7
          },
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 1,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 4,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 7.964879197514727,
        "indDatarif" : 6.568304668801491,
        "rowversion" : ""
      }, {
        "indImpfix" : 1.4985931822280574,
        "daggfix1" : 9.140242185517025,
        "daggfix2" : 8.81377937009168,
        "ggmmfix" : 3.8463127686084055,
        "ggdecor" : 6.936593194494838,
        "idCg64" : 2,
        "imporfix" : 2.3317418552851765,
        "flgFrperciva" : 2.408218941758913,
        "idCg62" : 4,
        "pluginData" : {
          "key" : ""
        },
        "id" : 4,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 7.321091499885957,
        "indTipocalend" : 7,
        "indTipodecor" : 9.739448828157911,
        "aggfix2" : 9.610516429629122,
        "aggfix1" : 5.948961008630453,
        "perciva" : 5.099298781640682,
        "el2frimp" : 4.180725413706508,
        "ggscadfix2" : 5.103912736584151,
        "tipoeff" : 3.3182952910080674,
        "flgFrpercimp" : 7.686670838404092,
        "percimp" : 0.05965928697733491,
        "prog" : 9.728706165995554,
        "el1frimp" : 4.39343993729625,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 0.6052866655822231,
        "subTypeCO" : {
          "ggoffset" : 9.629537564416708,
          "codiceCg07" : 8.50835276411088,
          "tipoeff" : 0.391063602337155,
          "codPaguc" : "codPaguc",
          "descstipo" : "descstipo",
          "codStipoeff" : 9.551762125042277,
          "flgAssegno" : 5,
          "indModfatturapa" : 2,
          "nationCO" : {
            "codSian" : 3.353193347011243,
            "crtpiva" : "crtpiva",
            "leniban" : 6,
            "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
            "desiso3166" : "desiso3166",
            "idmediaCg99" : 0.8851374739011653,
            "codice" : 6.704019297950036,
            "numiso3166" : "numiso3166",
            "codiceCg08" : "codiceCg08",
            "currencyCO" : {
              "sigla" : "sigla",
              "dataattuem" : "2000-01-23T04:56:07.000+00:00",
              "numdec" : 7.04836565559697,
              "exchangeRateCO" : [ {
                "cambio" : 4.078845849666752,
                "anno" : 3.2588565619047607,
                "idmediaCg99" : 6.628464275087742,
                "codiceCg08" : "codiceCg08",
                "indCertoincerto" : 4,
                "codicerifCg08" : "codicerifCg08",
                "giorno" : 0.2025324113236393,
                "mese" : 1.041444916118296,
                "pluginData" : {
                  "key" : ""
                },
                "additionalData" : {
                  "key" : ""
                },
                "adegcambio" : 5.533258397034986,
                "rowversion" : ""
              }, {
                "cambio" : 4.078845849666752,
                "anno" : 3.2588565619047607,
                "idmediaCg99" : 6.628464275087742,
                "codiceCg08" : "codiceCg08",
                "indCertoincerto" : 4,
                "codicerifCg08" : "codicerifCg08",
                "giorno" : 0.2025324113236393,
                "mese" : 1.041444916118296,
                "pluginData" : {
                  "key" : ""
                },
                "additionalData" : {
                  "key" : ""
                },
                "adegcambio" : 5.533258397034986,
                "rowversion" : ""
              } ],
              "idmediaCg99" : 8.969578798196912,
              "codice" : "codice",
              "indCertoincerto" : 7,
              "cambiofisso" : 0.10263654006109402,
              "descr" : "descr",
              "flgValuem" : 4.652396432933246,
              "indValuem" : 3.0576100241049344,
              "indSepmigl" : 3.0205796992916243,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              }
            },
            "descr" : "descr",
            "flgIban" : 3,
            "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
            "codIso" : "codIso",
            "a3iso3166" : "a3iso3166",
            "indTipostato" : 7.058770351582356,
            "a2iso3166" : "a2iso3166",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "datacee" : "2000-01-23T04:56:07.000+00:00",
            "flgSepa" : 7
          },
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 1,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 4,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 7.964879197514727,
        "indDatarif" : 6.568304668801491,
        "rowversion" : ""
      } ],
      "codPag" : "codPag",
      "desPagAnal" : "desPagAnal",
      "flgDisgg" : 4.13177941962639,
      "flgPrefpass" : 0,
      "idExtendedAttributeSubEntity" : 8,
      "flgPrefatt" : 4,
      "flgStornoiva" : 7.701777079007398,
      "descPag" : "descPag",
      "extensionData" : [ {
        "value" : "",
        "key" : "key"
      }, {
        "value" : "",
        "key" : "key"
      } ],
      "scpermer2" : 2.1518888575299036,
      "pluginData" : {
        "key" : ""
      },
      "id" : 2,
      "scpercas" : 6.936499209818381,
      "scpermer1" : 4.035133329541982,
      "additionalData" : {
        "key" : ""
      },
      "scpercart26" : 4.403697036782718,
      "idExtendedAttributeEntity" : 3,
      "rowversion" : "",
      "scart26" : 0.05189710095898081
    },
    "progrEf08" : 3.0576100241049344,
    "tipoCf" : 7.04836565559697,
    "pluginData" : {
      "key" : ""
    },
    "cliFor" : 3.353193347011243,
    "additionalData" : {
      "key" : ""
    },
    "ggScadFix" : 0.10263654006109402,
    "idExtendedAttributeEntity" : 3,
    "idExtendedAttributeSubEntity" : 4,
    "flgCointestati" : 7.058770351582356,
    "gruppoCg10" : 4.652396432933246,
    "currencyCO" : {
      "sigla" : "sigla",
      "dataattuem" : "2000-01-23T04:56:07.000+00:00",
      "numdec" : 7.04836565559697,
      "exchangeRateCO" : [ {
        "cambio" : 4.078845849666752,
        "anno" : 3.2588565619047607,
        "idmediaCg99" : 6.628464275087742,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 4,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 0.2025324113236393,
        "mese" : 1.041444916118296,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 5.533258397034986,
        "rowversion" : ""
      }, {
        "cambio" : 4.078845849666752,
        "anno" : 3.2588565619047607,
        "idmediaCg99" : 6.628464275087742,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 4,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 0.2025324113236393,
        "mese" : 1.041444916118296,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 5.533258397034986,
        "rowversion" : ""
      } ],
      "idmediaCg99" : 8.969578798196912,
      "codice" : "codice",
      "indCertoincerto" : 7,
      "cambiofisso" : 0.10263654006109402,
      "descr" : "descr",
      "flgValuem" : 4.652396432933246,
      "indValuem" : 3.0576100241049344,
      "indSepmigl" : 3.0205796992916243,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "vatCodeCO" : {
      "flgSospimp" : 1.633699845078339,
      "indNatura" : 8,
      "flgAgri" : 6.090696483578148,
      "tipologia" : 4.778706604314481,
      "percindet" : 6.389489858092311,
      "mossperc" : 5.305668385940959,
      "natureEsCO" : {
        "descr" : "descr",
        "codice" : "codice",
        "datainival" : "2000-01-23T04:56:07.000+00:00",
        "natureAssCO" : [ null, null ],
        "datafineval" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "id" : 3,
        "additionalData" : {
          "key" : ""
        },
        "rowversion" : ""
      },
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "verslynfa" : "verslynfa",
      "idExtendedAttributeEntity" : 0,
      "annotazioni" : "annotazioni",
      "rowVersion" : "",
      "indNatassoswCg2n" : 7,
      "perciva" : 5.201737367852583,
      "percforf" : 6.541917087228235,
      "codice" : "codice",
      "impostamonofasersm" : 4.851239691941878,
      "codiceOss" : "codiceOss",
      "extensionData" : [ null, null ],
      "stdcodivarifCg28" : "stdcodivarifCg28",
      "flgMossgest" : 3,
      "flgAutoue" : 1.2880645475702646,
      "flgIndet" : 2.9790233918904585,
      "codPlafond" : 7.239590766928185,
      "note" : "note",
      "flgAssport398" : 6.677419970877656,
      "flgMossrid" : 0,
      "indStaper" : 3.474156394106027,
      "flgAllclifor" : 9.852147203726787,
      "codiceagr" : "codiceagr",
      "flgImpostadibollo" : 4,
      "flgCorrVent" : 1.822577900073098,
      "aliqivavent" : 2.6736395633233356,
      "flgNotvar" : 7.224413148959403,
      "percmonofasersm" : 6.614319261836819,
      "idprov" : 0.42286244411048224,
      "idExtendedAttributeSubEntity" : 3,
      "natureAssCO" : {
        "descr" : "descr",
        "idCg2m" : 3,
        "idassosw" : 5,
        "codice" : "codice",
        "datainival" : "2000-01-23T04:56:07.000+00:00",
        "datafineval" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "rowversion" : ""
      },
      "flgMonofasersm" : 2.6249013358703053,
      "mosscodCg07" : 6.711221582652969,
      "descrizione" : "descrizione",
      "flgEscludiblacklist" : 5.083590215108117,
      "flgIvaedit" : 9.693372334146686,
      "indtipopart" : 6.008900790410507
    },
    "extensionData" : [ null, null ],
    "classificationData" : {
      "cliforCg44" : 0.2025324113236393,
      "indarrinfat" : 4.573936264232251,
      "indprefstdoc" : 5.299143560275359,
      "notes" : [ {
        "cliforCg44" : 0.30134145536422907,
        "note" : "note",
        "dittaCg18" : 0.4867146239815201,
        "tipocfCg44" : 7.88722683998926,
        "idmediaCg99" : 9.456612101333725,
        "destiponote" : "destiponote",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "prog" : 9.721723570087065
      }, {
        "cliforCg44" : 0.30134145536422907,
        "note" : "note",
        "dittaCg18" : 0.4867146239815201,
        "tipocfCg44" : 7.88722683998926,
        "idmediaCg99" : 9.456612101333725,
        "destiponote" : "destiponote",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "prog" : 9.721723570087065
      } ],
      "sc2percor" : 0.4768402382624515,
      "codrifnum" : 6.628464275087742,
      "grouping1CO" : {
        "dittaCg18" : 3.209082285545927,
        "codRaggrcf1" : "codRaggrcf1",
        "descraggrcf1" : "descraggrcf1",
        "idprov" : 2,
        "idmediaCg99" : 8.262795412896967,
        "tipocf" : 9.146339979307802,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "language" : {
        "iso639" : "iso639",
        "idmediaCg99" : 2.9679475177256287,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "descrlingua" : "descrlingua",
        "codLingua" : "codLingua",
        "siglalingua" : "siglalingua"
      },
      "irs1099" : "irs1099",
      "ggcons" : 2.9409642974827896,
      "flgesclspepor" : 0.5199002018724985,
      "grouping3CO" : {
        "codRaggrcf3" : "codRaggrcf3",
        "descraggrcf3" : "descraggrcf3",
        "dittaCg18" : 8.910869026866926,
        "idprov" : 6,
        "idmediaCg99" : 2.058822123984536,
        "tipocf" : 0.8411762798681321,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "datiAccompagnamento" : {
        "cliforCg44" : 4.8789878742268815,
        "vett1Mg14" : "vett1Mg14",
        "imballoMg95" : "imballoMg95",
        "tipocfCg44" : 1.3949519358941398,
        "idmediaCg99" : 9.806951670467935,
        "portoMg91" : "portoMg91",
        "vett2Mg14" : "vett2Mg14",
        "aspettoMg99" : "aspettoMg99",
        "dittaCg18" : 6.966044574347761,
        "spedizMg15" : "spedizMg15",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "tipospedMg93" : "tipospedMg93"
      },
      "tipoclxdoc" : 0.4833312865174044,
      "priceListSalePurchase" : {
        "desclist" : "desclist",
        "numlist" : 4.637509675190766,
        "valutaCg08" : "valutaCg08",
        "dittaCg18" : 6.918231485891953,
        "flgVenacq" : 0.11859130807119977,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "coddocumMg3g" : "coddocumMg3g",
      "indtestof2" : "0",
      "impdaarrot" : 6.623518433804886,
      "indtestof1" : 3.7814124730767915,
      "pluginData" : {
        "key" : ""
      },
      "flgrottsingdoc" : 8.251625748923757,
      "scimpcor" : 3.804112695731078,
      "additionalData" : {
        "key" : ""
      },
      "dataultord" : "2000-01-23T04:56:07.000+00:00",
      "flgTaxliable" : 0,
      "flgspbol" : 4.459605034958679,
      "magpercor" : 5.877124706116695,
      "taxexemptionno" : "taxexemptionno",
      "scaglspbanc" : 2.380090174313445,
      "macroCategoryCO" : {
        "descrmacrocat" : "descrmacrocat",
        "categorie" : [ null, null ],
        "dittaCg18" : 6.749525837406151,
        "tipocf" : 4.943637496515336,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "macrocat" : "macrocat"
      },
      "datacreaz" : "2000-01-23T04:56:07.000+00:00",
      "flgspeinc" : 3.901545264248647,
      "codrifalf" : "codrifalf",
      "sc1percor" : 7.835035282970782,
      "listmag" : 3.111202833403195,
      "categoryCO" : {
        "macrocatMg10" : "macrocatMg10",
        "tipocfMg10" : 6.173804034172511,
        "descrcat" : "descrcat",
        "dittaCg18" : 2.535258963197524,
        "categ" : "categ",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "dittaCg18" : 4.258773108174356,
      "indspesecum" : 8.37823741034869,
      "magimpcor" : 9.897492629215506,
      "datadismis" : "2000-01-23T04:56:07.000+00:00",
      "dataultdoc" : "2000-01-23T04:56:07.000+00:00",
      "macAreaCO" : {
        "descrmacroar" : "descrmacroar",
        "dittaCg18" : 5.747795090145878,
        "idprov" : 0,
        "tipocf" : 7.3842318535314,
        "areas" : [ null, null ],
        "pluginData" : {
          "key" : ""
        },
        "codiceMacroarea" : "codiceMacroarea",
        "additionalData" : {
          "key" : ""
        }
      },
      "indclibloc" : 9.254183946267839,
      "fixedText1" : {
        "descr" : "descr",
        "datainizioval" : "2000-01-23T04:56:07.000+00:00",
        "indTipoevas" : 4.4935252719377825,
        "idprov" : 1,
        "idmediaCg99" : 9.402167524121316,
        "codice" : "codice",
        "datafineval" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "testo" : "testo"
      },
      "flgart62ctr" : 0,
      "imparrotprec" : 8.28965939814297,
      "areaCO" : {
        "codiceAreaMG" : "codiceAreaMG",
        "macroareaMg07" : "macroareaMg07",
        "dittaCg18" : 0.35262192099236644,
        "zone" : [ {
          "areaMg08" : "areaMg08",
          "macroareaMg08" : "macroareaMg08",
          "dittaCg18" : 2.7977867356748476,
          "idprov" : 9,
          "descrzona" : "descrzona",
          "tipocfMg08" : 0.58919091925136,
          "pluginData" : {
            "key" : ""
          },
          "codiceZona" : "codiceZona",
          "additionalData" : {
            "key" : ""
          }
        }, {
          "areaMg08" : "areaMg08",
          "macroareaMg08" : "macroareaMg08",
          "dittaCg18" : 2.7977867356748476,
          "idprov" : 9,
          "descrzona" : "descrzona",
          "tipocfMg08" : 0.58919091925136,
          "pluginData" : {
            "key" : ""
          },
          "codiceZona" : "codiceZona",
          "additionalData" : {
            "key" : ""
          }
        } ],
        "idprov" : 7,
        "tipocfMg07" : 4.332304821875894,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "descrarea" : "descrarea"
      },
      "dataultvar" : "2000-01-23T04:56:07.000+00:00",
      "tipocfCg44" : 4.518309517874243,
      "fidofactoring" : 4.678947989005849,
      "idmediaCg99" : 1.7325933120207193,
      "datarischio" : "2000-01-23T04:56:07.000+00:00",
      "indstscadest" : 7.606863723092579,
      "grouping2CO" : {
        "codRaggrcf2" : "codRaggrcf2",
        "dittaCg18" : 4.010300976654761,
        "idprov" : 6,
        "descraggrcf2" : "descraggrcf2",
        "idmediaCg99" : 8.276461147928103,
        "tipocf" : 4.141296055235948,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "indclifat" : 1.8268702177058116,
      "fixedExp1" : {
        "flgRicfatriep" : 5.6644160867523485,
        "flgVentstat" : 4.372688051310086,
        "flgIvaincl" : 1,
        "indTipoevas" : 9.785002165136461,
        "idmediaCg99" : 5.7911894223693885,
        "codice" : "codice",
        "indTotspese" : 7.92839742024475,
        "indRotturacorpo" : 1.0639121808530916,
        "indTipospesa" : 7.3718573971919445,
        "indGesintra" : 3.8008573585058016,
        "descr" : "descr",
        "indFatriep" : 5.974942028545841,
        "indTipotot" : 7.726998920545485,
        "indTipoaliq" : 3.2841216543560217,
        "pluginData" : {
          "key" : ""
        },
        "flgVentamm" : 1.5970080735609526,
        "additionalData" : {
          "key" : ""
        },
        "flgOramin" : 3.812761638325517
      },
      "scperpiede" : 8.675064425986758,
      "rischio" : {
        "indSegnalazionecorpo" : 7.464202015255506,
        "flgAttivo" : 4.1661834558007,
        "flgScadereins" : 2.4669941706755685,
        "flgOrdini" : 8.250639315618633,
        "flgCalcmovprev" : 5.573385265048522,
        "flgSaldocon" : 7.273019311111276,
        "pluginData" : {
          "key" : ""
        },
        "flgCalcmovdacons" : 1.9626702727164813,
        "additionalData" : {
          "key" : ""
        },
        "flgScadutoins" : 0.4008378390304357,
        "mesiricscadenze" : 6.642953999458534,
        "flgSelclifortrasf" : 4.432841187680573,
        "indElabscadinsol" : 9.721046668148785,
        "flgScadutonoins" : 2.5524281586707875,
        "codice" : "codice",
        "flgEffettiscaduti" : 3.0269458094096646,
        "flgScaderenoins" : 8.782449469456207,
        "flgCalceffcons" : 2.026856458177285,
        "flgCalcmovcons" : 3.8156682252305574,
        "descrizione" : "descrizione",
        "flgCalceffprev" : 5.296102445648278,
        "dittaCg18" : 2.0981949483881577,
        "flgCalceffdacons" : 3.196820582978078,
        "indAttivatrasf" : 5.726375546151009,
        "mesiricordini" : 6.370609851066415,
        "flgSolobusinesriskattivo" : 3.5117904067536143,
        "indProvenienzafido" : 2.922265432447957,
        "mesiricdocdafatt" : 7.129168897240568
      },
      "dataultfat" : "2000-01-23T04:56:07.000+00:00",
      "notebloc" : "notebloc",
      "areaMGnielsenMg0e" : "areaMGnielsenMg0e",
      "indgesfido" : 8.761432466225475,
      "flgprzcamp" : 5.507386964179881,
      "inddesdocest" : 3.502657762086401,
      "flgdaticlfat" : 9.702963800023566,
      "indgiorni" : 0.4182561061793122,
      "fidoaziendale" : 1.041444916118296,
      "fidolivello1" : 7.260521264802104,
      "indrottcig" : 5.312489704336296,
      "fidolivello2" : 9.132027271330688,
      "raggruppamentoPrevalente" : {
        "descragg" : "descragg",
        "cliforCg44" : 7.390706075830692,
        "dittaCg18" : 1.0502890910539986,
        "idmediaCg99" : 6.176386745020588,
        "codRag" : "codRag",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "indarrl96" : 8.863729185622827,
      "dataultcalsp" : "2000-01-23T04:56:07.000+00:00",
      "flgrottcig" : 6.073898085781152,
      "coddestprev" : "coddestprev",
      "codprevragb" : "codprevragb",
      "art62txt" : "art62txt",
      "flgEstrpayline" : 7.933506881737151,
      "indFattper" : 9.183123594773994,
      "flgqualita" : 4.86315908102884,
      "datablocco" : "2000-01-23T04:56:07.000+00:00",
      "priceListWithMultipleItems" : {
        "descr" : "descr",
        "dittaCg18" : 0.36062689002149373,
        "codice" : "codice",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "subCategoryCO" : {
        "descrsottocat" : "descrsottocat",
        "tipocfMg11" : 8.768153453040833,
        "dittaCg18" : 9.505836306729838,
        "sottcat" : "sottcat",
        "categMg11" : "categMg11",
        "macrocatMg11" : "macrocatMg11",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "lastchange" : "2000-01-23T04:56:07.000+00:00",
      "sc3percor" : 3.1497903714250555
    },
    "datavaliva" : "2000-01-23T04:56:07.000+00:00",
    "dittaCg18" : 3.0937452626664474,
    "flgart62" : 7,
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "indElenchiMov3000" : 3,
    "lastchange" : "2000-01-23T04:56:07.000+00:00"
  },
  "idExtendedAttributeEntity" : 6,
  "codbloccoMg25" : "codbloccoMg25",
  "cambio" : 2.3021358869347655,
  "descraggcont" : "descraggcont",
  "idcontCo02" : 1.4894159098541704,
  "indconvclifat" : 7,
  "storageWH" : {
    "locationWH" : [ {
      "maxpeso" : 2.0561655911354517,
      "profondita" : 2.9691650858515217,
      "umdimens" : "umdimens",
      "codDepMg58" : "codDepMg58",
      "descubicaz" : "descubicaz",
      "coordin1" : "coordin1",
      "umpeso" : "umpeso",
      "indTipoubicaz" : 0.391063602337155,
      "dittaCg18" : 2.4977456046390434,
      "larghezza" : 1.2794383049745206,
      "codClassestoc" : 9.629537564416708,
      "pluginData" : {
        "key" : ""
      },
      "codPriorriemp" : 4.917163120387481,
      "additionalData" : {
        "key" : ""
      },
      "ubicaz" : "ubicaz",
      "coordin3" : "coordin3",
      "altezza" : 5.3152834658745505,
      "coordin2" : "coordin2"
    }, {
      "maxpeso" : 2.0561655911354517,
      "profondita" : 2.9691650858515217,
      "umdimens" : "umdimens",
      "codDepMg58" : "codDepMg58",
      "descubicaz" : "descubicaz",
      "coordin1" : "coordin1",
      "umpeso" : "umpeso",
      "indTipoubicaz" : 0.391063602337155,
      "dittaCg18" : 2.4977456046390434,
      "larghezza" : 1.2794383049745206,
      "codClassestoc" : 9.629537564416708,
      "pluginData" : {
        "key" : ""
      },
      "codPriorriemp" : 4.917163120387481,
      "additionalData" : {
        "key" : ""
      },
      "ubicaz" : "ubicaz",
      "coordin3" : "coordin3",
      "altezza" : 5.3152834658745505,
      "coordin2" : "coordin2"
    } ],
    "indIdep" : "indIdep",
    "datacess" : "2000-01-23T04:56:07.000+00:00",
    "capdep" : "capdep",
    "flgDepprinc" : 8.50835276411088,
    "codDep" : "codDep",
    "indEmail" : "indEmail",
    "dataatt" : "2000-01-23T04:56:07.000+00:00",
    "provdep" : "provdep",
    "dittaCg18" : 3.3182952910080674,
    "telnumdep" : "telnumdep",
    "respdep" : "respdep",
    "indInterest" : 9.551762125042277,
    "locdep" : "locdep",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "faxnumdep" : "faxnumdep",
    "descrdep" : "descrdep"
  },
  "tiponumautof" : 3.5571952270680973,
  "documentoDatiAccompagnamentoMG" : {
    "targavet1" : "targavet1",
    "descaspetto" : "descaspetto",
    "codPortoMg91" : "codPortoMg91",
    "codCautraspMg13" : "codCautraspMg13",
    "targavet2" : "targavet2",
    "codImballoMg95" : "codImballoMg95",
    "vettore2Mg14" : "vettore2Mg14",
    "dataritvet1" : "2000-01-23T04:56:07.000+00:00",
    "descrlettint" : "descrlettint",
    "orainiziotrasp" : 5.944895607614016,
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "oraritvet1" : 6.704019297950036,
    "additionalData" : {
      "key" : ""
    },
    "oraritvet2" : 3.353193347011243,
    "codTipospedMg93" : "codTipospedMg93",
    "vettore1Mg14" : "vettore1Mg14",
    "umvolume" : "umvolume",
    "pesolordo" : 3.0937452626664474,
    "dataritvet2" : "2000-01-23T04:56:07.000+00:00",
    "targarim1" : "targarim1",
    "volume" : 7.058770351582356,
    "targarim2" : "targarim2",
    "totcolli" : 0.8851374739011653,
    "umpeso" : "umpeso",
    "dittaCg18" : 6.878052220127876,
    "spedizMg15" : "spedizMg15",
    "datainiztrasp" : "2000-01-23T04:56:07.000+00:00",
    "pesonetto" : 7.143538047012306,
    "codAspettoMg99" : "codAspettoMg99"
  },
  "numdoc" : 9.965781217890562,
  "documentMaster" : {
    "indTipoop" : 6.778324963048013,
    "dittaCg18" : 2.8841621266687802,
    "gruppocre" : "gruppocre",
    "utentevar" : "utentevar",
    "utentecre" : "utentecre",
    "gruppovar" : "gruppovar",
    "numreg" : "numreg",
    "datavar" : "2000-01-23T04:56:07.000+00:00",
    "datacre" : "2000-01-23T04:56:07.000+00:00",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "descnote1" : "descnote1"
  },
  "cliForDest" : "cliForDest",
  "listmag" : 4.965218492984954,
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ],
  "abbuono" : 5.962133916683182,
  "datainiziopag" : "2000-01-23T04:56:07.000+00:00",
  "datareg" : "2000-01-23T04:56:07.000+00:00",
  "testataPersonalizzata" : [ {
    "idmediaCg99" : 1.17662993142012,
    "datapers1" : "2000-01-23T04:56:07.000+00:00",
    "datapers2" : "2000-01-23T04:56:07.000+00:00",
    "alfpers9" : "alfpers9",
    "datapers3" : "2000-01-23T04:56:07.000+00:00",
    "datapers4" : "2000-01-23T04:56:07.000+00:00",
    "datapers5" : "2000-01-23T04:56:07.000+00:00",
    "datapers6" : "2000-01-23T04:56:07.000+00:00",
    "alfpers4" : "alfpers4",
    "indPers1" : 6.434975173600648,
    "alfpers3" : "alfpers3",
    "indPers2" : 2.729215612801924,
    "alfpers2" : "alfpers2",
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "alfpers1" : "alfpers1",
    "additionalData" : {
      "key" : ""
    },
    "alfpers8" : "alfpers8",
    "alfpers7" : "alfpers7",
    "alfpers6" : "alfpers6",
    "alfpers5" : "alfpers5",
    "numpers11" : 8.206187911681816,
    "numpers1" : 9.774932085941137,
    "numpers12" : 3.4925370028432345,
    "numpers2" : 3.4360986237728,
    "numpers3" : 4.786929569572925,
    "numpers10" : 5.328605645442888,
    "flgPers2" : 3.472023815393955,
    "numpers8" : 2.551900688634915,
    "flgPers1" : 3.3841591171956145,
    "numpers9" : 8.128958126729998,
    "numpers4" : 8.342721204157684,
    "numpers5" : 3.6300678941289712,
    "flgPers4" : 8.67132933794674,
    "numpers6" : 2.1305968583238744,
    "prog" : 8.897844438448299,
    "flgPers3" : 5.22975523929469,
    "numpers7" : 7.68210344846877,
    "dittaCg18" : 5.2388109661003055,
    "alfpers10" : "alfpers10",
    "alfpers11" : "alfpers11",
    "alfpers12" : "alfpers12"
  }, {
    "idmediaCg99" : 1.17662993142012,
    "datapers1" : "2000-01-23T04:56:07.000+00:00",
    "datapers2" : "2000-01-23T04:56:07.000+00:00",
    "alfpers9" : "alfpers9",
    "datapers3" : "2000-01-23T04:56:07.000+00:00",
    "datapers4" : "2000-01-23T04:56:07.000+00:00",
    "datapers5" : "2000-01-23T04:56:07.000+00:00",
    "datapers6" : "2000-01-23T04:56:07.000+00:00",
    "alfpers4" : "alfpers4",
    "indPers1" : 6.434975173600648,
    "alfpers3" : "alfpers3",
    "indPers2" : 2.729215612801924,
    "alfpers2" : "alfpers2",
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "alfpers1" : "alfpers1",
    "additionalData" : {
      "key" : ""
    },
    "alfpers8" : "alfpers8",
    "alfpers7" : "alfpers7",
    "alfpers6" : "alfpers6",
    "alfpers5" : "alfpers5",
    "numpers11" : 8.206187911681816,
    "numpers1" : 9.774932085941137,
    "numpers12" : 3.4925370028432345,
    "numpers2" : 3.4360986237728,
    "numpers3" : 4.786929569572925,
    "numpers10" : 5.328605645442888,
    "flgPers2" : 3.472023815393955,
    "numpers8" : 2.551900688634915,
    "flgPers1" : 3.3841591171956145,
    "numpers9" : 8.128958126729998,
    "numpers4" : 8.342721204157684,
    "numpers5" : 3.6300678941289712,
    "flgPers4" : 8.67132933794674,
    "numpers6" : 2.1305968583238744,
    "prog" : 8.897844438448299,
    "flgPers3" : 5.22975523929469,
    "numpers7" : 7.68210344846877,
    "dittaCg18" : 5.2388109661003055,
    "alfpers10" : "alfpers10",
    "alfpers11" : "alfpers11",
    "alfpers12" : "alfpers12"
  } ],
  "dataplafond" : "2000-01-23T04:56:07.000+00:00",
  "stipodoc" : 8.762042012749001,
  "headingReferenceDocumentMG" : [ {
    "flgNsdocbis" : 9.254183946267839,
    "notevsdoc" : "notevsdoc",
    "rifnsdoc" : "rifnsdoc",
    "datansdoc" : "2000-01-23T04:56:07.000+00:00",
    "seznsdoc" : "seznsdoc",
    "indStipodoc" : 1.8268702177058116,
    "datansconf" : "2000-01-23T04:56:07.000+00:00",
    "datavsconf" : "2000-01-23T04:56:07.000+00:00",
    "datavsdoc" : "2000-01-23T04:56:07.000+00:00",
    "fedatadoc" : "2000-01-23T04:56:07.000+00:00",
    "numnsdoc" : 9.183123594773994,
    "dittaCg18" : 8.863729185622827,
    "feiddoc" : "feiddoc",
    "feidsoggetto" : "feidsoggetto",
    "indTipodoc" : 3.502657762086401,
    "numregCo99" : "numregCo99",
    "numvsdoc" : "numvsdoc",
    "pluginData" : {
      "key" : ""
    },
    "notensdoc" : "notensdoc",
    "progRif" : 8.761432466225475,
    "rifvsdoc" : "rifvsdoc",
    "additionalData" : {
      "key" : ""
    }
  }, {
    "flgNsdocbis" : 9.254183946267839,
    "notevsdoc" : "notevsdoc",
    "rifnsdoc" : "rifnsdoc",
    "datansdoc" : "2000-01-23T04:56:07.000+00:00",
    "seznsdoc" : "seznsdoc",
    "indStipodoc" : 1.8268702177058116,
    "datansconf" : "2000-01-23T04:56:07.000+00:00",
    "datavsconf" : "2000-01-23T04:56:07.000+00:00",
    "datavsdoc" : "2000-01-23T04:56:07.000+00:00",
    "fedatadoc" : "2000-01-23T04:56:07.000+00:00",
    "numnsdoc" : 9.183123594773994,
    "dittaCg18" : 8.863729185622827,
    "feiddoc" : "feiddoc",
    "feidsoggetto" : "feidsoggetto",
    "indTipodoc" : 3.502657762086401,
    "numregCo99" : "numregCo99",
    "numvsdoc" : "numvsdoc",
    "pluginData" : {
      "key" : ""
    },
    "notensdoc" : "notensdoc",
    "progRif" : 8.761432466225475,
    "rifvsdoc" : "rifvsdoc",
    "additionalData" : {
      "key" : ""
    }
  } ],
  "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
  "causmagMg51" : 7.061401241503109,
  "cup" : "cup",
  "cig" : "cig",
  "documentoTestataAgentiMG" : [ {
    "idagenteMg17" : 4,
    "dittaCg18" : 6.519180951018382,
    "perprov" : 3.0205796992916243,
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "indRegprov" : 7.740351818741173,
    "additionalData" : {
      "key" : ""
    },
    "flgAgerifer" : 0.10263654006109402,
    "codiceAgente" : "codiceAgente",
    "indModcalc" : 8.969578798196912
  }, {
    "idagenteMg17" : 4,
    "dittaCg18" : 6.519180951018382,
    "perprov" : 3.0205796992916243,
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "indRegprov" : 7.740351818741173,
    "additionalData" : {
      "key" : ""
    },
    "flgAgerifer" : 0.10263654006109402,
    "codiceAgente" : "codiceAgente",
    "indModcalc" : 8.969578798196912
  } ],
  "cauprestCg15" : "cauprestCg15",
  "esclusioneAgentiMultipli" : 0,
  "idmediaCg99" : 6.84685269835264,
  "acconto" : 1.4658129805029452,
  "flgSpincas" : 1,
  "officeCO" : {
    "indIrizzo" : "indIrizzo",
    "idmediaCg99" : 6.720288821326667,
    "codice" : 7.766860781935265,
    "indDimcentrocomm" : 5.304373278797373,
    "cap" : "cap",
    "dittaCg18" : 1.6056289151258096,
    "progRea" : 8.708394192403432,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "prov" : "prov",
    "numerorea" : "numerorea",
    "citta" : "citta",
    "rowversion" : ""
  },
  "datadoc" : "2000-01-23T04:56:07.000+00:00",
  "codpagCg62" : "codpagCg62",
  "flgDocstamp" : 7,
  "documentoTestataProgettiMG" : {
    "codDipPd06" : "codDipPd06",
    "codProgcol" : "codProgcol",
    "causmgoMgfo" : 3,
    "codProgetto" : "codProgetto",
    "codSprogetto" : 3.2588565619047607,
    "dittaCg18" : 4.078845849666752,
    "codCommessa" : "codCommessa",
    "nodorifcolPd0c" : "nodorifcolPd0c",
    "codScommessa" : 7.04836565559697,
    "pluginData" : {
      "key" : ""
    },
    "nodorifPd0c" : "nodorifPd0c",
    "additionalData" : {
      "key" : ""
    },
    "codSprogcol" : 5.533258397034986
  },
  "testataOrdine" : {
    "dataconsint" : "2000-01-23T04:56:07.000+00:00",
    "flgNonpiuev" : 6,
    "flgEvastot" : 6,
    "priorita" : 4.778706604314481,
    "flgNoevasparz" : 5,
    "ggtollercons" : 6.614319261836819,
    "flgRicpreev" : 5,
    "datacons" : "2000-01-23T04:56:07.000+00:00",
    "dittaCg18" : 3.474156394106027,
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "dataconsorig" : "2000-01-23T04:56:07.000+00:00",
    "flgNonann" : 6,
    "additionalData" : {
      "key" : ""
    },
    "flgConfrit" : 6,
    "tipoordine" : 3.0237995775442372,
    "tipoinoltro" : 0.7449262586083982
  },
  "progrEf08" : 9.369310271410669,
  "sezdoc" : "sezdoc",
  "numautof" : 5.025004791520295,
  "tipodoc" : 9.018348186070783,
  "datacambio" : "2000-01-23T04:56:07.000+00:00",
  "stagioneMg5t" : 6,
  "flgClifat" : 4,
  "idExtendedAttributeSubEntity" : 1,
  "documentoTestataRateiMG" : {
    "dadatacomp" : "2000-01-23T04:56:07.000+00:00",
    "flgDaav" : 8.28965939814297,
    "dataregesinc" : "2000-01-23T04:56:07.000+00:00",
    "indTipocomp" : 4.573936264232251,
    "dittaCg18" : 1.7325933120207193,
    "flgDisatcoge" : 6.623518433804886,
    "contopar" : "contopar",
    "datacompivaman" : "2000-01-23T04:56:07.000+00:00",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "adatacomp" : "2000-01-23T04:56:07.000+00:00",
    "dataregesprec" : "2000-01-23T04:56:07.000+00:00"
  },
  "codcabCg13" : 3.616076749251911,
  "documentoTestataProvvigioniMG" : [ {
    "idagenteMg17" : 9,
    "flgStenas" : 0.8774076871421566,
    "flgProvsosp" : 1.041444916118296,
    "idmediaCg99" : 0.5199002018724985,
    "imporprov" : 4.86315908102884,
    "imponprov" : 7.933506881737151,
    "imponprovVal" : 5.507386964179881,
    "trimestrePa23" : 2.9409642974827896,
    "provmedia" : 0.43431398824148815,
    "flgPers" : 4.258773108174356,
    "imporprovVal" : 6.073898085781152,
    "noteprov" : "noteprov",
    "flgSt" : 7.260521264802104,
    "flgStarcred" : 9.132027271330688,
    "indTipomov" : 3.901545264248647,
    "flgProvvar" : 4.678947989005849,
    "dittaCg18" : 6.628464275087742,
    "annoPa23" : 0.2025324113236393,
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "indSt" : 4.459605034958679,
    "additionalData" : {
      "key" : ""
    },
    "codiceAgente" : "codiceAgente",
    "indPers" : 8.251625748923757
  }, {
    "idagenteMg17" : 9,
    "flgStenas" : 0.8774076871421566,
    "flgProvsosp" : 1.041444916118296,
    "idmediaCg99" : 0.5199002018724985,
    "imporprov" : 4.86315908102884,
    "imponprov" : 7.933506881737151,
    "imponprovVal" : 5.507386964179881,
    "trimestrePa23" : 2.9409642974827896,
    "provmedia" : 0.43431398824148815,
    "flgPers" : 4.258773108174356,
    "imporprovVal" : 6.073898085781152,
    "noteprov" : "noteprov",
    "flgSt" : 7.260521264802104,
    "flgStarcred" : 9.132027271330688,
    "indTipomov" : 3.901545264248647,
    "flgProvvar" : 4.678947989005849,
    "dittaCg18" : 6.628464275087742,
    "annoPa23" : 0.2025324113236393,
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "indSt" : 4.459605034958679,
    "additionalData" : {
      "key" : ""
    },
    "codiceAgente" : "codiceAgente",
    "indPers" : 8.251625748923757
  } ],
  "flgLockOnDocExist" : true,
  "lineaFa05" : "lineaFa05",
  "notedocum" : "notedocum",
  "numReg" : "000000000000",
  "righe" : [ {
    "flgContribinteg" : 7,
    "statoAttualeCO" : {
      "statiDisponibili" : [ null, null ],
      "statoCorrente" : {
        "indTipoStato" : 8,
        "idStato" : 2,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "seq" : 2
      },
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "prezzo2iva" : 9.806951670467935,
    "documentoRigaProgettiMG" : {
      "codDipPd06" : "codDipPd06",
      "attivitaPd0d" : "attivitaPd0d",
      "codProgcol" : "codProgcol",
      "idattrezzaturaVc02" : 6,
      "idartepuVc02" : 2,
      "nodoPd0c" : "nodoPd0c",
      "idmedia" : 0.8411762798681321,
      "codProgetto" : "codProgetto",
      "codSprogetto" : 4.141296055235948,
      "dittaCg18" : 8.910869026866926,
      "codCommessa" : "codCommessa",
      "nodorifcolPd0c" : "nodorifcolPd0c",
      "codScommessa" : 8.276461147928103,
      "spesaPd64" : "spesaPd64",
      "pluginData" : {
        "key" : ""
      },
      "nodorifPd0c" : "nodorifPd0c",
      "additionalData" : {
        "key" : ""
      },
      "codSprogcol" : 6.458262756685686
    },
    "cpmerceCg24" : "cpmerceCg24",
    "profondita" : 1.3949519358941398,
    "prezzo2" : 6.966044574347761,
    "ditta" : 3.111202833403195,
    "prezzo1" : 6.173804034172511,
    "um1" : "um1",
    "indtiporiga" : 7,
    "documentoRigaCOINMG" : {
      "pdcvdsorigPc01" : 4.010300976654761,
      "pdcdestPc01" : 8.262795412896967,
      "vdsorigPc03" : "vdsorigPc03",
      "contoorigPc03" : "contoorigPc03",
      "idmediaCg99" : 3.209082285545927,
      "contodestPc03" : "contodestPc03",
      "flgEsclriga" : 4.4935252719377825,
      "vdsdestPc03" : "vdsdestPc03",
      "dittaCg18" : 1.7045651386993,
      "pdcorigPc01" : 2.9805393113464476,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "pdcvdsdestPc01" : 9.146339979307802
    },
    "pluginData" : {
      "key" : ""
    },
    "um2" : "um2",
    "additionalData" : {
      "key" : ""
    },
    "barcode" : "barcode",
    "fatconv" : 9.897492629215506,
    "magimp" : 4.332304821875894,
    "coddepcolMg58" : "coddepcolMg58",
    "pesol" : 0.58919091925136,
    "prezzo1iva" : 4.8789878742268815,
    "peson" : 2.535258963197524,
    "flgContribprev" : 0,
    "importo" : 3.804112695731078,
    "pzconf" : 1.5970080735609526,
    "flgPriceDiscForce" : true,
    "flgRitenas" : 2,
    "progPadre" : 1.2555055362323109,
    "testoFissoMG" : {
      "descr" : "descr",
      "datainizioval" : "2000-01-23T04:56:07.000+00:00",
      "indTipoevas" : 4.4935252719377825,
      "idprov" : 1,
      "idmediaCg99" : 9.402167524121316,
      "codice" : "codice",
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "testo" : "testo"
    },
    "codescl4Mg82" : "codescl4Mg82",
    "codartMg66" : "codartMg66",
    "rigaIntra" : {
      "meserif" : 5.829097284708605,
      "modincassoIn04" : "modincassoIn04",
      "paesepagCg07" : 8.071139232091417,
      "percadegvalstat" : 8.257837395465918,
      "fatconvumsuppl" : 2.831445253698411,
      "codiceCg72" : "codiceCg72",
      "unsuppl" : 9.878259040728768,
      "paeseorigCg07" : 1.2786903972794905,
      "provdest" : "provdest",
      "provorig" : "provorig",
      "progRiga" : 5.547564904556697,
      "indTipoCg72" : 5.499986845135928,
      "annorif" : 2.924533207692744,
      "dittaCg18" : 8.238101405568635,
      "moderogazioneIn03" : "moderogazioneIn03",
      "paesedestCg07" : 0.7242789830362995,
      "massanetta" : 8.569658089905484,
      "paeseprovCg07" : 2.7107020326702136,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "flgEsclintra" : 6.345503614942988
    },
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "spesaVariaMG" : {
      "flgRicfatriep" : 5.6644160867523485,
      "flgVentstat" : 4.372688051310086,
      "flgIvaincl" : 1,
      "indTipoevas" : 9.785002165136461,
      "idmediaCg99" : 5.7911894223693885,
      "codice" : "codice",
      "indTotspese" : 7.92839742024475,
      "indRotturacorpo" : 1.0639121808530916,
      "indTipospesa" : 7.3718573971919445,
      "indGesintra" : 3.8008573585058016,
      "descr" : "descr",
      "indFatriep" : 5.974942028545841,
      "indTipotot" : 7.726998920545485,
      "indTipoaliq" : 3.2841216543560217,
      "pluginData" : {
        "key" : ""
      },
      "flgVentamm" : 1.5970080735609526,
      "additionalData" : {
        "key" : ""
      },
      "flgOramin" : 3.812761638325517
    },
    "rigaEstesa" : [ {
      "alfst10" : "alfst10",
      "datast2" : "2000-01-23T04:56:07.000+00:00",
      "numst12" : 6.642953999458534,
      "datast1" : "2000-01-23T04:56:07.000+00:00",
      "alfst12" : "alfst12",
      "alfst11" : "alfst11",
      "idmediaCg99" : 5.726375546151009,
      "datast4" : "2000-01-23T04:56:07.000+00:00",
      "numst10" : 7.129168897240568,
      "datast3" : "2000-01-23T04:56:07.000+00:00",
      "numst11" : 6.370609851066415,
      "progRiga" : 2.008994665592807,
      "datast6" : "2000-01-23T04:56:07.000+00:00",
      "datast5" : "2000-01-23T04:56:07.000+00:00",
      "alfst4" : "alfst4",
      "alfst5" : "alfst5",
      "alfst6" : "alfst6",
      "alfst7" : "alfst7",
      "alfst8" : "alfst8",
      "alfst9" : "alfst9",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "alfst1" : "alfst1",
      "alfst2" : "alfst2",
      "alfst3" : "alfst3",
      "flgSt2" : 2.5524281586707875,
      "flgSt3" : 4.432841187680573,
      "flgSt4" : 3.5117904067536143,
      "numst8" : 9.007961177824221,
      "numst7" : 3.7846852362095262,
      "numst9" : 1.5743672347582194,
      "prog" : 4.863793115215697,
      "numst2" : 9.505836306729838,
      "numst1" : 7.464202015255506,
      "numst4" : 2.684056218962324,
      "dittaCg18" : 8.782449469456207,
      "numst3" : 8.768153453040833,
      "numst6" : 1.0046985756074744,
      "numst5" : 6.712603870693706,
      "indSt1" : 9.721046668148785,
      "indSt2" : 2.922265432447957,
      "flgSt1" : 0.4008378390304357
    }, {
      "alfst10" : "alfst10",
      "datast2" : "2000-01-23T04:56:07.000+00:00",
      "numst12" : 6.642953999458534,
      "datast1" : "2000-01-23T04:56:07.000+00:00",
      "alfst12" : "alfst12",
      "alfst11" : "alfst11",
      "idmediaCg99" : 5.726375546151009,
      "datast4" : "2000-01-23T04:56:07.000+00:00",
      "numst10" : 7.129168897240568,
      "datast3" : "2000-01-23T04:56:07.000+00:00",
      "numst11" : 6.370609851066415,
      "progRiga" : 2.008994665592807,
      "datast6" : "2000-01-23T04:56:07.000+00:00",
      "datast5" : "2000-01-23T04:56:07.000+00:00",
      "alfst4" : "alfst4",
      "alfst5" : "alfst5",
      "alfst6" : "alfst6",
      "alfst7" : "alfst7",
      "alfst8" : "alfst8",
      "alfst9" : "alfst9",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "alfst1" : "alfst1",
      "alfst2" : "alfst2",
      "alfst3" : "alfst3",
      "flgSt2" : 2.5524281586707875,
      "flgSt3" : 4.432841187680573,
      "flgSt4" : 3.5117904067536143,
      "numst8" : 9.007961177824221,
      "numst7" : 3.7846852362095262,
      "numst9" : 1.5743672347582194,
      "prog" : 4.863793115215697,
      "numst2" : 9.505836306729838,
      "numst1" : 7.464202015255506,
      "numst4" : 2.684056218962324,
      "dittaCg18" : 8.782449469456207,
      "numst3" : 8.768153453040833,
      "numst6" : 1.0046985756074744,
      "numst5" : 6.712603870693706,
      "indSt1" : 9.721046668148785,
      "indSt2" : 2.922265432447957,
      "flgSt1" : 0.4008378390304357
    } ],
    "causmagMg51" : 8.37823741034869,
    "cup" : "cup",
    "cig" : "cig",
    "codescl3Mg82" : "codescl3Mg82",
    "progvisuasta" : 5.6644160867523485,
    "rigaOrdine" : {
      "codTraclegdb" : "codTraclegdb",
      "dataconsint" : "2000-01-23T04:56:07.000+00:00",
      "datalancio" : "2000-01-23T04:56:07.000+00:00",
      "flgNonpiuev" : 9,
      "datainizlav" : "2000-01-23T04:56:07.000+00:00",
      "qta2trasfddtcl" : 4.318826475758856,
      "flgConsconf" : 7,
      "flgRicpreev" : 6,
      "collitrasfp" : 9.966789814889403,
      "progRiga" : 0.6895265584691002,
      "qta2lanc" : 0.29551818216563164,
      "qta2prel" : 0.7370530802760489,
      "collicons" : 8.780989965779524,
      "qta2trasfp" : 9.908114046741538,
      "codPiano" : "codPiano",
      "flgNosugg" : 1,
      "numpiano" : 7.375698277301938,
      "qta1prel" : 8.331741856019029,
      "datapianif" : "2000-01-23T04:56:07.000+00:00",
      "numregCo99" : "numregCo99",
      "qta1cons" : 3.5366534267201475,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datafineoap" : "2000-01-23T04:56:07.000+00:00",
      "flgSospriga" : 9,
      "numpropPd39" : 6.97635352548152,
      "qta1lanc" : 5.267310321293582,
      "contpcarPd79" : 9.748669620880193,
      "indStatodescsp" : 6,
      "qta1trasfddtcl" : 7.6528347060559,
      "flgNoevasparz" : 0,
      "ggtollercons" : 9.372628622067484,
      "qta2cons" : 8.223593720381889,
      "collitrasfddtcl" : 5.616380282218067,
      "indStatocons" : 6,
      "codTraclegwbs" : "codTraclegwbs",
      "datacons" : "2000-01-23T04:56:07.000+00:00",
      "valorecons" : 7.541803065493349,
      "dittaCg18" : 6.203595661339589,
      "indEvasdescsp" : 8,
      "qta1trasfp" : 9.120398275527268,
      "dataconsorig" : "2000-01-23T04:56:07.000+00:00",
      "datainizoap" : "2000-01-23T04:56:07.000+00:00",
      "progRigpiaPd80" : 9.290244967928562
    },
    "flgRitacc" : 3,
    "svar2" : "svar2",
    "codschedaMg42" : "codschedaMg42",
    "svar1" : "svar1",
    "capacita" : 5.312489704336296,
    "fatconvcf" : 5.877124706116695,
    "codescl2Mg82" : "codescl2Mg82",
    "colli" : 7.606863723092579,
    "codartcli" : "codartcli",
    "altezza" : 0.4182561061793122,
    "opzioneMg5e" : "opzioneMg5e",
    "stagioneMg5t" : 7,
    "scper1" : 3.8008573585058016,
    "indlisacqven" : 8,
    "qta2" : 5.7911894223693885,
    "scper2" : 1.0639121808530916,
    "scper3" : 3.2841216543560217,
    "scper4" : 9.785002165136461,
    "indlisfisso" : 4,
    "magper2" : 9.386524999783381,
    "qta1" : 4.372688051310086,
    "estdescart" : "estdescart",
    "codescl1Mg82" : "codescl1Mg82",
    "documentoRigaRateiMG" : {
      "flgDaav" : 0.11859130807119977,
      "dataregesinc" : "2000-01-23T04:56:07.000+00:00",
      "imprettcostobu" : 7.390706075830692,
      "imprettcostobuVal" : 1.0502890910539986,
      "importo" : 0.36062689002149373,
      "percforf" : 4.1661834558007,
      "adatacomp" : "2000-01-23T04:56:07.000+00:00",
      "indTipomovbu" : 2.0981949483881577,
      "dadatacomp" : "2000-01-23T04:56:07.000+00:00",
      "indTipocomp" : 6.176386745020588,
      "dittaCg18" : 6.918231485891953,
      "flgDisatcoge" : 4.637509675190766,
      "codBeneusato" : 7.88722683998926,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "contoparCg24" : "contoparCg24",
      "dataregesprec" : "2000-01-23T04:56:07.000+00:00"
    },
    "rigaPersonalizzata" : [ {
      "idmediaCg99" : 5.304373278797373,
      "progRiga" : 9.610516429629122,
      "datapers1" : "2000-01-23T04:56:07.000+00:00",
      "datapers2" : "2000-01-23T04:56:07.000+00:00",
      "alfpers9" : "alfpers9",
      "datapers3" : "2000-01-23T04:56:07.000+00:00",
      "datapers4" : "2000-01-23T04:56:07.000+00:00",
      "datapers5" : "2000-01-23T04:56:07.000+00:00",
      "datapers6" : "2000-01-23T04:56:07.000+00:00",
      "alfpers4" : "alfpers4",
      "indPers1" : 8.708394192403432,
      "alfpers3" : "alfpers3",
      "indPers2" : 0.8164256701298711,
      "alfpers2" : "alfpers2",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "alfpers1" : "alfpers1",
      "additionalData" : {
        "key" : ""
      },
      "alfpers8" : "alfpers8",
      "alfpers7" : "alfpers7",
      "alfpers6" : "alfpers6",
      "alfpers5" : "alfpers5",
      "numpers11" : 0.313237310471568,
      "numpers1" : 4.13177941962639,
      "numpers12" : 7.701777079007398,
      "numpers2" : 2.1871588311421153,
      "numpers3" : 0.05189710095898081,
      "numpers10" : 4.4580628783592156,
      "flgPers2" : 7.766860781935265,
      "numpers8" : 3.0659734456354117,
      "flgPers1" : 8.875589915795528,
      "numpers9" : 8.638367073739522,
      "numpers4" : 4.403697036782718,
      "numpers5" : 6.936499209818381,
      "flgPers4" : 6.720288821326667,
      "numpers6" : 4.035133329541982,
      "prog" : 5.948961008630453,
      "flgPers3" : 1.6056289151258096,
      "numpers7" : 2.1518888575299036,
      "dittaCg18" : 7.437703257022269,
      "alfpers10" : "alfpers10",
      "alfpers11" : "alfpers11",
      "alfpers12" : "alfpers12"
    }, {
      "idmediaCg99" : 5.304373278797373,
      "progRiga" : 9.610516429629122,
      "datapers1" : "2000-01-23T04:56:07.000+00:00",
      "datapers2" : "2000-01-23T04:56:07.000+00:00",
      "alfpers9" : "alfpers9",
      "datapers3" : "2000-01-23T04:56:07.000+00:00",
      "datapers4" : "2000-01-23T04:56:07.000+00:00",
      "datapers5" : "2000-01-23T04:56:07.000+00:00",
      "datapers6" : "2000-01-23T04:56:07.000+00:00",
      "alfpers4" : "alfpers4",
      "indPers1" : 8.708394192403432,
      "alfpers3" : "alfpers3",
      "indPers2" : 0.8164256701298711,
      "alfpers2" : "alfpers2",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "alfpers1" : "alfpers1",
      "additionalData" : {
        "key" : ""
      },
      "alfpers8" : "alfpers8",
      "alfpers7" : "alfpers7",
      "alfpers6" : "alfpers6",
      "alfpers5" : "alfpers5",
      "numpers11" : 0.313237310471568,
      "numpers1" : 4.13177941962639,
      "numpers12" : 7.701777079007398,
      "numpers2" : 2.1871588311421153,
      "numpers3" : 0.05189710095898081,
      "numpers10" : 4.4580628783592156,
      "flgPers2" : 7.766860781935265,
      "numpers8" : 3.0659734456354117,
      "flgPers1" : 8.875589915795528,
      "numpers9" : 8.638367073739522,
      "numpers4" : 4.403697036782718,
      "numpers5" : 6.936499209818381,
      "flgPers4" : 6.720288821326667,
      "numpers6" : 4.035133329541982,
      "prog" : 5.948961008630453,
      "flgPers3" : 1.6056289151258096,
      "numpers7" : 2.1518888575299036,
      "dittaCg18" : 7.437703257022269,
      "alfpers10" : "alfpers10",
      "alfpers11" : "alfpers11",
      "alfpers12" : "alfpers12"
    } ],
    "documentoRigaProvvigioniMG" : [ {
      "idagenteMg17" : 0,
      "percprov" : 9.456612101333725,
      "imporprov" : 4.943637496515336,
      "indRegprov" : 0.4867146239815201,
      "imponprov" : 7.3842318535314,
      "imponprovVal" : 6.749525837406151,
      "progRiga" : 9.721723570087065,
      "imporprovVal" : 0.30134145536422907,
      "dittaCg18" : 2.9679475177256287,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "flgVarprov" : 5.747795090145878,
      "additionalData" : {
        "key" : ""
      },
      "codiceAgente" : "codiceAgente"
    }, {
      "idagenteMg17" : 0,
      "percprov" : 9.456612101333725,
      "imporprov" : 4.943637496515336,
      "indRegprov" : 0.4867146239815201,
      "imponprov" : 7.3842318535314,
      "imponprovVal" : 6.749525837406151,
      "progRiga" : 9.721723570087065,
      "imporprovVal" : 0.30134145536422907,
      "dittaCg18" : 2.9679475177256287,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "flgVarprov" : 5.747795090145878,
      "additionalData" : {
        "key" : ""
      },
      "codiceAgente" : "codiceAgente"
    } ],
    "magper1" : 2.7977867356748476,
    "tara" : 9.402167524121316,
    "packaging" : {
      "umPeso" : "umPeso",
      "qta2Conf" : 7.273019311111276,
      "qta1Conf" : 8.250639315618633,
      "pesoLordo" : 3.8156682252305574,
      "umCapac" : "umCapac",
      "colliConf" : 3.196820582978078,
      "progRiga" : 5.573385265048522,
      "volume" : 2.4669941706755685,
      "umVolume" : "umVolume",
      "dittaCg18" : 5.296102445648278,
      "codConfezMg96" : "codConfezMg96",
      "capacita" : 2.026856458177285,
      "pzConf" : 3.0269458094096646,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "pesoNetto" : 1.9626702727164813
    },
    "rigaLotti" : [ {
      "cliforCg44" : 5.5569822283364845,
      "note" : "note",
      "flgNonpiuev" : 8.546645780823726,
      "codSscc" : "codSscc",
      "progMg4f" : 8.310924482277276,
      "tipocfCg44" : 4.757484754617172,
      "idmediaCg99" : 4.784107115651097,
      "codArtMg66" : "codArtMg66",
      "codDepMg58" : "codDepMg58",
      "codProgPd14" : "codProgPd14",
      "progRiga" : 7.886583288201395,
      "progRigarifDo30" : 1.4793631642421967,
      "codConfezMg96" : "codConfezMg96",
      "numregCo99" : "numregCo99",
      "qta1cons" : 1.8407572303125541,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codBagnomat" : "codBagnomat",
      "codArtpfMg66" : "codArtpfMg66",
      "codPallets" : "codPallets",
      "opzionepfMg5e" : "opzionepfMg5e",
      "opzioneMg5e" : "opzioneMg5e",
      "qta2" : 7.200147194425509,
      "codLottopfMg4g" : "codLottopfMg4g",
      "codLottoMg4g" : "codLottoMg4g",
      "sernum" : "sernum",
      "scadenza" : "2000-01-23T04:56:07.000+00:00",
      "anagraficaLotto" : {
        "note" : "note",
        "dittaCg18" : 4.754071900895484,
        "idmediaCg99" : 1.1864130338603074,
        "codArtMg66" : "codArtMg66",
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "codLotto" : "codLotto",
        "additionalData" : {
          "key" : ""
        },
        "datascad" : "2000-01-23T04:56:07.000+00:00",
        "lib1" : 3.8601930294054942,
        "desclotto" : "desclotto",
        "opzioneMg5e" : "opzioneMg5e"
      },
      "qta1" : 2.719219329469812,
      "qta2cons" : 7.135782839148426,
      "ubicazcollMg97" : "ubicazcollMg97",
      "progRifDo52" : 6.607129449620165,
      "prog" : 8.036294790673514,
      "parametroMovimentazioneLotto" : {
        "flgNote" : 4.5403315819302215,
        "dittaCg18" : 3.8581948879558317,
        "flgAggprogval" : 1.9732909296667345,
        "indGiacsca" : 8.262575023052213,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "prog" : 0.9178980228274691,
        "tipomov" : "tipomov"
      },
      "ubicazMg97" : "ubicazMg97",
      "sotprogPd14" : 1.0348002257634148,
      "dittaCg18" : 5.412786966532157,
      "numregrifCo99" : "numregrifCo99",
      "causmagMg51" : 2.60416377551006
    }, {
      "cliforCg44" : 5.5569822283364845,
      "note" : "note",
      "flgNonpiuev" : 8.546645780823726,
      "codSscc" : "codSscc",
      "progMg4f" : 8.310924482277276,
      "tipocfCg44" : 4.757484754617172,
      "idmediaCg99" : 4.784107115651097,
      "codArtMg66" : "codArtMg66",
      "codDepMg58" : "codDepMg58",
      "codProgPd14" : "codProgPd14",
      "progRiga" : 7.886583288201395,
      "progRigarifDo30" : 1.4793631642421967,
      "codConfezMg96" : "codConfezMg96",
      "numregCo99" : "numregCo99",
      "qta1cons" : 1.8407572303125541,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codBagnomat" : "codBagnomat",
      "codArtpfMg66" : "codArtpfMg66",
      "codPallets" : "codPallets",
      "opzionepfMg5e" : "opzionepfMg5e",
      "opzioneMg5e" : "opzioneMg5e",
      "qta2" : 7.200147194425509,
      "codLottopfMg4g" : "codLottopfMg4g",
      "codLottoMg4g" : "codLottoMg4g",
      "sernum" : "sernum",
      "scadenza" : "2000-01-23T04:56:07.000+00:00",
      "anagraficaLotto" : {
        "note" : "note",
        "dittaCg18" : 4.754071900895484,
        "idmediaCg99" : 1.1864130338603074,
        "codArtMg66" : "codArtMg66",
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "codLotto" : "codLotto",
        "additionalData" : {
          "key" : ""
        },
        "datascad" : "2000-01-23T04:56:07.000+00:00",
        "lib1" : 3.8601930294054942,
        "desclotto" : "desclotto",
        "opzioneMg5e" : "opzioneMg5e"
      },
      "qta1" : 2.719219329469812,
      "qta2cons" : 7.135782839148426,
      "ubicazcollMg97" : "ubicazcollMg97",
      "progRifDo52" : 6.607129449620165,
      "prog" : 8.036294790673514,
      "parametroMovimentazioneLotto" : {
        "flgNote" : 4.5403315819302215,
        "dittaCg18" : 3.8581948879558317,
        "flgAggprogval" : 1.9732909296667345,
        "indGiacsca" : 8.262575023052213,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "prog" : 0.9178980228274691,
        "tipomov" : "tipomov"
      },
      "ubicazMg97" : "ubicazMg97",
      "sotprogPd14" : 1.0348002257634148,
      "dittaCg18" : 5.412786966532157,
      "numregrifCo99" : "numregrifCo99",
      "causmagMg51" : 2.60416377551006
    } ],
    "coddepMg58" : "coddepMg58",
    "costotot" : 3.7814124730767915,
    "indtipoomag" : 0,
    "scper5" : 7.3718573971919445,
    "scper6" : 7.726998920545485,
    "indlisprior" : 0,
    "progrRiga" : 3.812761638325517,
    "lineaFa05" : "lineaFa05",
    "codartfor" : "codartfor",
    "numReg" : "numReg",
    "descart" : "descart",
    "alivacompCg28" : "alivacompCg28",
    "base" : 5.299143560275359,
    "scimp" : 5.974942028545841,
    "rigaRiferimenti" : [ {
      "flgNsdocbis" : 7.686670838404092,
      "qta2mov" : 0.05965928697733491,
      "flgNonpiuevpdc" : 7.321091499885957,
      "notevsdoc" : "notevsdoc",
      "seqfase" : 5.099298781640682,
      "datansdoc" : "2000-01-23T04:56:07.000+00:00",
      "indQtaordres" : 3,
      "seznsdoc" : "seznsdoc",
      "indStipodoc" : 0,
      "datansconf" : "2000-01-23T04:56:07.000+00:00",
      "datavsconf" : "2000-01-23T04:56:07.000+00:00",
      "progRiga" : 6.568304668801491,
      "valoremov" : 9.728706165995554,
      "progRigarifDo30" : 7.338782761819433,
      "progRigapadreDo30" : 1.4985931822280574,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "notensdoc" : "notensdoc",
      "progRif" : 2.3317418552851765,
      "rifvsdoc" : "rifvsdoc",
      "additionalData" : {
        "key" : ""
      },
      "numregpadreCo99" : "numregpadreCo99",
      "flgAggprescvar" : 7.964879197514727,
      "qta1mov" : 9.739448828157911,
      "collimov" : 9.140242185517025,
      "flgAggqtatrasf" : 4,
      "rifnsdoc" : "rifnsdoc",
      "fasePd12" : 4.39343993729625,
      "datavsdoc" : "2000-01-23T04:56:07.000+00:00",
      "indAggdocorigine" : 6.936593194494838,
      "progPdcDo65" : 4.075306827525243,
      "flgStornoqtaval" : 2,
      "numnsdoc" : 4.515863748649669,
      "dittaCg18" : 8.81377937009168,
      "indTipodoc" : 5,
      "numregrifCo99" : "numregrifCo99",
      "numvsdoc" : "numvsdoc",
      "progPdcrifDo65" : 2.674423984487264
    }, {
      "flgNsdocbis" : 7.686670838404092,
      "qta2mov" : 0.05965928697733491,
      "flgNonpiuevpdc" : 7.321091499885957,
      "notevsdoc" : "notevsdoc",
      "seqfase" : 5.099298781640682,
      "datansdoc" : "2000-01-23T04:56:07.000+00:00",
      "indQtaordres" : 3,
      "seznsdoc" : "seznsdoc",
      "indStipodoc" : 0,
      "datansconf" : "2000-01-23T04:56:07.000+00:00",
      "datavsconf" : "2000-01-23T04:56:07.000+00:00",
      "progRiga" : 6.568304668801491,
      "valoremov" : 9.728706165995554,
      "progRigarifDo30" : 7.338782761819433,
      "progRigapadreDo30" : 1.4985931822280574,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "notensdoc" : "notensdoc",
      "progRif" : 2.3317418552851765,
      "rifvsdoc" : "rifvsdoc",
      "additionalData" : {
        "key" : ""
      },
      "numregpadreCo99" : "numregpadreCo99",
      "flgAggprescvar" : 7.964879197514727,
      "qta1mov" : 9.739448828157911,
      "collimov" : 9.140242185517025,
      "flgAggqtatrasf" : 4,
      "rifnsdoc" : "rifnsdoc",
      "fasePd12" : 4.39343993729625,
      "datavsdoc" : "2000-01-23T04:56:07.000+00:00",
      "indAggdocorigine" : 6.936593194494838,
      "progPdcDo65" : 4.075306827525243,
      "flgStornoqtaval" : 2,
      "numnsdoc" : 4.515863748649669,
      "dittaCg18" : 8.81377937009168,
      "indTipodoc" : 5,
      "numregrifCo99" : "numregrifCo99",
      "numvsdoc" : "numvsdoc",
      "progPdcrifDo65" : 2.674423984487264
    } ]
  }, {
    "flgContribinteg" : 7,
    "statoAttualeCO" : {
      "statiDisponibili" : [ null, null ],
      "statoCorrente" : {
        "indTipoStato" : 8,
        "idStato" : 2,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "seq" : 2
      },
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "prezzo2iva" : 9.806951670467935,
    "documentoRigaProgettiMG" : {
      "codDipPd06" : "codDipPd06",
      "attivitaPd0d" : "attivitaPd0d",
      "codProgcol" : "codProgcol",
      "idattrezzaturaVc02" : 6,
      "idartepuVc02" : 2,
      "nodoPd0c" : "nodoPd0c",
      "idmedia" : 0.8411762798681321,
      "codProgetto" : "codProgetto",
      "codSprogetto" : 4.141296055235948,
      "dittaCg18" : 8.910869026866926,
      "codCommessa" : "codCommessa",
      "nodorifcolPd0c" : "nodorifcolPd0c",
      "codScommessa" : 8.276461147928103,
      "spesaPd64" : "spesaPd64",
      "pluginData" : {
        "key" : ""
      },
      "nodorifPd0c" : "nodorifPd0c",
      "additionalData" : {
        "key" : ""
      },
      "codSprogcol" : 6.458262756685686
    },
    "cpmerceCg24" : "cpmerceCg24",
    "profondita" : 1.3949519358941398,
    "prezzo2" : 6.966044574347761,
    "ditta" : 3.111202833403195,
    "prezzo1" : 6.173804034172511,
    "um1" : "um1",
    "indtiporiga" : 7,
    "documentoRigaCOINMG" : {
      "pdcvdsorigPc01" : 4.010300976654761,
      "pdcdestPc01" : 8.262795412896967,
      "vdsorigPc03" : "vdsorigPc03",
      "contoorigPc03" : "contoorigPc03",
      "idmediaCg99" : 3.209082285545927,
      "contodestPc03" : "contodestPc03",
      "flgEsclriga" : 4.4935252719377825,
      "vdsdestPc03" : "vdsdestPc03",
      "dittaCg18" : 1.7045651386993,
      "pdcorigPc01" : 2.9805393113464476,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "pdcvdsdestPc01" : 9.146339979307802
    },
    "pluginData" : {
      "key" : ""
    },
    "um2" : "um2",
    "additionalData" : {
      "key" : ""
    },
    "barcode" : "barcode",
    "fatconv" : 9.897492629215506,
    "magimp" : 4.332304821875894,
    "coddepcolMg58" : "coddepcolMg58",
    "pesol" : 0.58919091925136,
    "prezzo1iva" : 4.8789878742268815,
    "peson" : 2.535258963197524,
    "flgContribprev" : 0,
    "importo" : 3.804112695731078,
    "pzconf" : 1.5970080735609526,
    "flgPriceDiscForce" : true,
    "flgRitenas" : 2,
    "progPadre" : 1.2555055362323109,
    "testoFissoMG" : {
      "descr" : "descr",
      "datainizioval" : "2000-01-23T04:56:07.000+00:00",
      "indTipoevas" : 4.4935252719377825,
      "idprov" : 1,
      "idmediaCg99" : 9.402167524121316,
      "codice" : "codice",
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "testo" : "testo"
    },
    "codescl4Mg82" : "codescl4Mg82",
    "codartMg66" : "codartMg66",
    "rigaIntra" : {
      "meserif" : 5.829097284708605,
      "modincassoIn04" : "modincassoIn04",
      "paesepagCg07" : 8.071139232091417,
      "percadegvalstat" : 8.257837395465918,
      "fatconvumsuppl" : 2.831445253698411,
      "codiceCg72" : "codiceCg72",
      "unsuppl" : 9.878259040728768,
      "paeseorigCg07" : 1.2786903972794905,
      "provdest" : "provdest",
      "provorig" : "provorig",
      "progRiga" : 5.547564904556697,
      "indTipoCg72" : 5.499986845135928,
      "annorif" : 2.924533207692744,
      "dittaCg18" : 8.238101405568635,
      "moderogazioneIn03" : "moderogazioneIn03",
      "paesedestCg07" : 0.7242789830362995,
      "massanetta" : 8.569658089905484,
      "paeseprovCg07" : 2.7107020326702136,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "flgEsclintra" : 6.345503614942988
    },
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "spesaVariaMG" : {
      "flgRicfatriep" : 5.6644160867523485,
      "flgVentstat" : 4.372688051310086,
      "flgIvaincl" : 1,
      "indTipoevas" : 9.785002165136461,
      "idmediaCg99" : 5.7911894223693885,
      "codice" : "codice",
      "indTotspese" : 7.92839742024475,
      "indRotturacorpo" : 1.0639121808530916,
      "indTipospesa" : 7.3718573971919445,
      "indGesintra" : 3.8008573585058016,
      "descr" : "descr",
      "indFatriep" : 5.974942028545841,
      "indTipotot" : 7.726998920545485,
      "indTipoaliq" : 3.2841216543560217,
      "pluginData" : {
        "key" : ""
      },
      "flgVentamm" : 1.5970080735609526,
      "additionalData" : {
        "key" : ""
      },
      "flgOramin" : 3.812761638325517
    },
    "rigaEstesa" : [ {
      "alfst10" : "alfst10",
      "datast2" : "2000-01-23T04:56:07.000+00:00",
      "numst12" : 6.642953999458534,
      "datast1" : "2000-01-23T04:56:07.000+00:00",
      "alfst12" : "alfst12",
      "alfst11" : "alfst11",
      "idmediaCg99" : 5.726375546151009,
      "datast4" : "2000-01-23T04:56:07.000+00:00",
      "numst10" : 7.129168897240568,
      "datast3" : "2000-01-23T04:56:07.000+00:00",
      "numst11" : 6.370609851066415,
      "progRiga" : 2.008994665592807,
      "datast6" : "2000-01-23T04:56:07.000+00:00",
      "datast5" : "2000-01-23T04:56:07.000+00:00",
      "alfst4" : "alfst4",
      "alfst5" : "alfst5",
      "alfst6" : "alfst6",
      "alfst7" : "alfst7",
      "alfst8" : "alfst8",
      "alfst9" : "alfst9",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "alfst1" : "alfst1",
      "alfst2" : "alfst2",
      "alfst3" : "alfst3",
      "flgSt2" : 2.5524281586707875,
      "flgSt3" : 4.432841187680573,
      "flgSt4" : 3.5117904067536143,
      "numst8" : 9.007961177824221,
      "numst7" : 3.7846852362095262,
      "numst9" : 1.5743672347582194,
      "prog" : 4.863793115215697,
      "numst2" : 9.505836306729838,
      "numst1" : 7.464202015255506,
      "numst4" : 2.684056218962324,
      "dittaCg18" : 8.782449469456207,
      "numst3" : 8.768153453040833,
      "numst6" : 1.0046985756074744,
      "numst5" : 6.712603870693706,
      "indSt1" : 9.721046668148785,
      "indSt2" : 2.922265432447957,
      "flgSt1" : 0.4008378390304357
    }, {
      "alfst10" : "alfst10",
      "datast2" : "2000-01-23T04:56:07.000+00:00",
      "numst12" : 6.642953999458534,
      "datast1" : "2000-01-23T04:56:07.000+00:00",
      "alfst12" : "alfst12",
      "alfst11" : "alfst11",
      "idmediaCg99" : 5.726375546151009,
      "datast4" : "2000-01-23T04:56:07.000+00:00",
      "numst10" : 7.129168897240568,
      "datast3" : "2000-01-23T04:56:07.000+00:00",
      "numst11" : 6.370609851066415,
      "progRiga" : 2.008994665592807,
      "datast6" : "2000-01-23T04:56:07.000+00:00",
      "datast5" : "2000-01-23T04:56:07.000+00:00",
      "alfst4" : "alfst4",
      "alfst5" : "alfst5",
      "alfst6" : "alfst6",
      "alfst7" : "alfst7",
      "alfst8" : "alfst8",
      "alfst9" : "alfst9",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "alfst1" : "alfst1",
      "alfst2" : "alfst2",
      "alfst3" : "alfst3",
      "flgSt2" : 2.5524281586707875,
      "flgSt3" : 4.432841187680573,
      "flgSt4" : 3.5117904067536143,
      "numst8" : 9.007961177824221,
      "numst7" : 3.7846852362095262,
      "numst9" : 1.5743672347582194,
      "prog" : 4.863793115215697,
      "numst2" : 9.505836306729838,
      "numst1" : 7.464202015255506,
      "numst4" : 2.684056218962324,
      "dittaCg18" : 8.782449469456207,
      "numst3" : 8.768153453040833,
      "numst6" : 1.0046985756074744,
      "numst5" : 6.712603870693706,
      "indSt1" : 9.721046668148785,
      "indSt2" : 2.922265432447957,
      "flgSt1" : 0.4008378390304357
    } ],
    "causmagMg51" : 8.37823741034869,
    "cup" : "cup",
    "cig" : "cig",
    "codescl3Mg82" : "codescl3Mg82",
    "progvisuasta" : 5.6644160867523485,
    "rigaOrdine" : {
      "codTraclegdb" : "codTraclegdb",
      "dataconsint" : "2000-01-23T04:56:07.000+00:00",
      "datalancio" : "2000-01-23T04:56:07.000+00:00",
      "flgNonpiuev" : 9,
      "datainizlav" : "2000-01-23T04:56:07.000+00:00",
      "qta2trasfddtcl" : 4.318826475758856,
      "flgConsconf" : 7,
      "flgRicpreev" : 6,
      "collitrasfp" : 9.966789814889403,
      "progRiga" : 0.6895265584691002,
      "qta2lanc" : 0.29551818216563164,
      "qta2prel" : 0.7370530802760489,
      "collicons" : 8.780989965779524,
      "qta2trasfp" : 9.908114046741538,
      "codPiano" : "codPiano",
      "flgNosugg" : 1,
      "numpiano" : 7.375698277301938,
      "qta1prel" : 8.331741856019029,
      "datapianif" : "2000-01-23T04:56:07.000+00:00",
      "numregCo99" : "numregCo99",
      "qta1cons" : 3.5366534267201475,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datafineoap" : "2000-01-23T04:56:07.000+00:00",
      "flgSospriga" : 9,
      "numpropPd39" : 6.97635352548152,
      "qta1lanc" : 5.267310321293582,
      "contpcarPd79" : 9.748669620880193,
      "indStatodescsp" : 6,
      "qta1trasfddtcl" : 7.6528347060559,
      "flgNoevasparz" : 0,
      "ggtollercons" : 9.372628622067484,
      "qta2cons" : 8.223593720381889,
      "collitrasfddtcl" : 5.616380282218067,
      "indStatocons" : 6,
      "codTraclegwbs" : "codTraclegwbs",
      "datacons" : "2000-01-23T04:56:07.000+00:00",
      "valorecons" : 7.541803065493349,
      "dittaCg18" : 6.203595661339589,
      "indEvasdescsp" : 8,
      "qta1trasfp" : 9.120398275527268,
      "dataconsorig" : "2000-01-23T04:56:07.000+00:00",
      "datainizoap" : "2000-01-23T04:56:07.000+00:00",
      "progRigpiaPd80" : 9.290244967928562
    },
    "flgRitacc" : 3,
    "svar2" : "svar2",
    "codschedaMg42" : "codschedaMg42",
    "svar1" : "svar1",
    "capacita" : 5.312489704336296,
    "fatconvcf" : 5.877124706116695,
    "codescl2Mg82" : "codescl2Mg82",
    "colli" : 7.606863723092579,
    "codartcli" : "codartcli",
    "altezza" : 0.4182561061793122,
    "opzioneMg5e" : "opzioneMg5e",
    "stagioneMg5t" : 7,
    "scper1" : 3.8008573585058016,
    "indlisacqven" : 8,
    "qta2" : 5.7911894223693885,
    "scper2" : 1.0639121808530916,
    "scper3" : 3.2841216543560217,
    "scper4" : 9.785002165136461,
    "indlisfisso" : 4,
    "magper2" : 9.386524999783381,
    "qta1" : 4.372688051310086,
    "estdescart" : "estdescart",
    "codescl1Mg82" : "codescl1Mg82",
    "documentoRigaRateiMG" : {
      "flgDaav" : 0.11859130807119977,
      "dataregesinc" : "2000-01-23T04:56:07.000+00:00",
      "imprettcostobu" : 7.390706075830692,
      "imprettcostobuVal" : 1.0502890910539986,
      "importo" : 0.36062689002149373,
      "percforf" : 4.1661834558007,
      "adatacomp" : "2000-01-23T04:56:07.000+00:00",
      "indTipomovbu" : 2.0981949483881577,
      "dadatacomp" : "2000-01-23T04:56:07.000+00:00",
      "indTipocomp" : 6.176386745020588,
      "dittaCg18" : 6.918231485891953,
      "flgDisatcoge" : 4.637509675190766,
      "codBeneusato" : 7.88722683998926,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "contoparCg24" : "contoparCg24",
      "dataregesprec" : "2000-01-23T04:56:07.000+00:00"
    },
    "rigaPersonalizzata" : [ {
      "idmediaCg99" : 5.304373278797373,
      "progRiga" : 9.610516429629122,
      "datapers1" : "2000-01-23T04:56:07.000+00:00",
      "datapers2" : "2000-01-23T04:56:07.000+00:00",
      "alfpers9" : "alfpers9",
      "datapers3" : "2000-01-23T04:56:07.000+00:00",
      "datapers4" : "2000-01-23T04:56:07.000+00:00",
      "datapers5" : "2000-01-23T04:56:07.000+00:00",
      "datapers6" : "2000-01-23T04:56:07.000+00:00",
      "alfpers4" : "alfpers4",
      "indPers1" : 8.708394192403432,
      "alfpers3" : "alfpers3",
      "indPers2" : 0.8164256701298711,
      "alfpers2" : "alfpers2",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "alfpers1" : "alfpers1",
      "additionalData" : {
        "key" : ""
      },
      "alfpers8" : "alfpers8",
      "alfpers7" : "alfpers7",
      "alfpers6" : "alfpers6",
      "alfpers5" : "alfpers5",
      "numpers11" : 0.313237310471568,
      "numpers1" : 4.13177941962639,
      "numpers12" : 7.701777079007398,
      "numpers2" : 2.1871588311421153,
      "numpers3" : 0.05189710095898081,
      "numpers10" : 4.4580628783592156,
      "flgPers2" : 7.766860781935265,
      "numpers8" : 3.0659734456354117,
      "flgPers1" : 8.875589915795528,
      "numpers9" : 8.638367073739522,
      "numpers4" : 4.403697036782718,
      "numpers5" : 6.936499209818381,
      "flgPers4" : 6.720288821326667,
      "numpers6" : 4.035133329541982,
      "prog" : 5.948961008630453,
      "flgPers3" : 1.6056289151258096,
      "numpers7" : 2.1518888575299036,
      "dittaCg18" : 7.437703257022269,
      "alfpers10" : "alfpers10",
      "alfpers11" : "alfpers11",
      "alfpers12" : "alfpers12"
    }, {
      "idmediaCg99" : 5.304373278797373,
      "progRiga" : 9.610516429629122,
      "datapers1" : "2000-01-23T04:56:07.000+00:00",
      "datapers2" : "2000-01-23T04:56:07.000+00:00",
      "alfpers9" : "alfpers9",
      "datapers3" : "2000-01-23T04:56:07.000+00:00",
      "datapers4" : "2000-01-23T04:56:07.000+00:00",
      "datapers5" : "2000-01-23T04:56:07.000+00:00",
      "datapers6" : "2000-01-23T04:56:07.000+00:00",
      "alfpers4" : "alfpers4",
      "indPers1" : 8.708394192403432,
      "alfpers3" : "alfpers3",
      "indPers2" : 0.8164256701298711,
      "alfpers2" : "alfpers2",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "alfpers1" : "alfpers1",
      "additionalData" : {
        "key" : ""
      },
      "alfpers8" : "alfpers8",
      "alfpers7" : "alfpers7",
      "alfpers6" : "alfpers6",
      "alfpers5" : "alfpers5",
      "numpers11" : 0.313237310471568,
      "numpers1" : 4.13177941962639,
      "numpers12" : 7.701777079007398,
      "numpers2" : 2.1871588311421153,
      "numpers3" : 0.05189710095898081,
      "numpers10" : 4.4580628783592156,
      "flgPers2" : 7.766860781935265,
      "numpers8" : 3.0659734456354117,
      "flgPers1" : 8.875589915795528,
      "numpers9" : 8.638367073739522,
      "numpers4" : 4.403697036782718,
      "numpers5" : 6.936499209818381,
      "flgPers4" : 6.720288821326667,
      "numpers6" : 4.035133329541982,
      "prog" : 5.948961008630453,
      "flgPers3" : 1.6056289151258096,
      "numpers7" : 2.1518888575299036,
      "dittaCg18" : 7.437703257022269,
      "alfpers10" : "alfpers10",
      "alfpers11" : "alfpers11",
      "alfpers12" : "alfpers12"
    } ],
    "documentoRigaProvvigioniMG" : [ {
      "idagenteMg17" : 0,
      "percprov" : 9.456612101333725,
      "imporprov" : 4.943637496515336,
      "indRegprov" : 0.4867146239815201,
      "imponprov" : 7.3842318535314,
      "imponprovVal" : 6.749525837406151,
      "progRiga" : 9.721723570087065,
      "imporprovVal" : 0.30134145536422907,
      "dittaCg18" : 2.9679475177256287,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "flgVarprov" : 5.747795090145878,
      "additionalData" : {
        "key" : ""
      },
      "codiceAgente" : "codiceAgente"
    }, {
      "idagenteMg17" : 0,
      "percprov" : 9.456612101333725,
      "imporprov" : 4.943637496515336,
      "indRegprov" : 0.4867146239815201,
      "imponprov" : 7.3842318535314,
      "imponprovVal" : 6.749525837406151,
      "progRiga" : 9.721723570087065,
      "imporprovVal" : 0.30134145536422907,
      "dittaCg18" : 2.9679475177256287,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "flgVarprov" : 5.747795090145878,
      "additionalData" : {
        "key" : ""
      },
      "codiceAgente" : "codiceAgente"
    } ],
    "magper1" : 2.7977867356748476,
    "tara" : 9.402167524121316,
    "packaging" : {
      "umPeso" : "umPeso",
      "qta2Conf" : 7.273019311111276,
      "qta1Conf" : 8.250639315618633,
      "pesoLordo" : 3.8156682252305574,
      "umCapac" : "umCapac",
      "colliConf" : 3.196820582978078,
      "progRiga" : 5.573385265048522,
      "volume" : 2.4669941706755685,
      "umVolume" : "umVolume",
      "dittaCg18" : 5.296102445648278,
      "codConfezMg96" : "codConfezMg96",
      "capacita" : 2.026856458177285,
      "pzConf" : 3.0269458094096646,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "pesoNetto" : 1.9626702727164813
    },
    "rigaLotti" : [ {
      "cliforCg44" : 5.5569822283364845,
      "note" : "note",
      "flgNonpiuev" : 8.546645780823726,
      "codSscc" : "codSscc",
      "progMg4f" : 8.310924482277276,
      "tipocfCg44" : 4.757484754617172,
      "idmediaCg99" : 4.784107115651097,
      "codArtMg66" : "codArtMg66",
      "codDepMg58" : "codDepMg58",
      "codProgPd14" : "codProgPd14",
      "progRiga" : 7.886583288201395,
      "progRigarifDo30" : 1.4793631642421967,
      "codConfezMg96" : "codConfezMg96",
      "numregCo99" : "numregCo99",
      "qta1cons" : 1.8407572303125541,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codBagnomat" : "codBagnomat",
      "codArtpfMg66" : "codArtpfMg66",
      "codPallets" : "codPallets",
      "opzionepfMg5e" : "opzionepfMg5e",
      "opzioneMg5e" : "opzioneMg5e",
      "qta2" : 7.200147194425509,
      "codLottopfMg4g" : "codLottopfMg4g",
      "codLottoMg4g" : "codLottoMg4g",
      "sernum" : "sernum",
      "scadenza" : "2000-01-23T04:56:07.000+00:00",
      "anagraficaLotto" : {
        "note" : "note",
        "dittaCg18" : 4.754071900895484,
        "idmediaCg99" : 1.1864130338603074,
        "codArtMg66" : "codArtMg66",
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "codLotto" : "codLotto",
        "additionalData" : {
          "key" : ""
        },
        "datascad" : "2000-01-23T04:56:07.000+00:00",
        "lib1" : 3.8601930294054942,
        "desclotto" : "desclotto",
        "opzioneMg5e" : "opzioneMg5e"
      },
      "qta1" : 2.719219329469812,
      "qta2cons" : 7.135782839148426,
      "ubicazcollMg97" : "ubicazcollMg97",
      "progRifDo52" : 6.607129449620165,
      "prog" : 8.036294790673514,
      "parametroMovimentazioneLotto" : {
        "flgNote" : 4.5403315819302215,
        "dittaCg18" : 3.8581948879558317,
        "flgAggprogval" : 1.9732909296667345,
        "indGiacsca" : 8.262575023052213,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "prog" : 0.9178980228274691,
        "tipomov" : "tipomov"
      },
      "ubicazMg97" : "ubicazMg97",
      "sotprogPd14" : 1.0348002257634148,
      "dittaCg18" : 5.412786966532157,
      "numregrifCo99" : "numregrifCo99",
      "causmagMg51" : 2.60416377551006
    }, {
      "cliforCg44" : 5.5569822283364845,
      "note" : "note",
      "flgNonpiuev" : 8.546645780823726,
      "codSscc" : "codSscc",
      "progMg4f" : 8.310924482277276,
      "tipocfCg44" : 4.757484754617172,
      "idmediaCg99" : 4.784107115651097,
      "codArtMg66" : "codArtMg66",
      "codDepMg58" : "codDepMg58",
      "codProgPd14" : "codProgPd14",
      "progRiga" : 7.886583288201395,
      "progRigarifDo30" : 1.4793631642421967,
      "codConfezMg96" : "codConfezMg96",
      "numregCo99" : "numregCo99",
      "qta1cons" : 1.8407572303125541,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codBagnomat" : "codBagnomat",
      "codArtpfMg66" : "codArtpfMg66",
      "codPallets" : "codPallets",
      "opzionepfMg5e" : "opzionepfMg5e",
      "opzioneMg5e" : "opzioneMg5e",
      "qta2" : 7.200147194425509,
      "codLottopfMg4g" : "codLottopfMg4g",
      "codLottoMg4g" : "codLottoMg4g",
      "sernum" : "sernum",
      "scadenza" : "2000-01-23T04:56:07.000+00:00",
      "anagraficaLotto" : {
        "note" : "note",
        "dittaCg18" : 4.754071900895484,
        "idmediaCg99" : 1.1864130338603074,
        "codArtMg66" : "codArtMg66",
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "codLotto" : "codLotto",
        "additionalData" : {
          "key" : ""
        },
        "datascad" : "2000-01-23T04:56:07.000+00:00",
        "lib1" : 3.8601930294054942,
        "desclotto" : "desclotto",
        "opzioneMg5e" : "opzioneMg5e"
      },
      "qta1" : 2.719219329469812,
      "qta2cons" : 7.135782839148426,
      "ubicazcollMg97" : "ubicazcollMg97",
      "progRifDo52" : 6.607129449620165,
      "prog" : 8.036294790673514,
      "parametroMovimentazioneLotto" : {
        "flgNote" : 4.5403315819302215,
        "dittaCg18" : 3.8581948879558317,
        "flgAggprogval" : 1.9732909296667345,
        "indGiacsca" : 8.262575023052213,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "prog" : 0.9178980228274691,
        "tipomov" : "tipomov"
      },
      "ubicazMg97" : "ubicazMg97",
      "sotprogPd14" : 1.0348002257634148,
      "dittaCg18" : 5.412786966532157,
      "numregrifCo99" : "numregrifCo99",
      "causmagMg51" : 2.60416377551006
    } ],
    "coddepMg58" : "coddepMg58",
    "costotot" : 3.7814124730767915,
    "indtipoomag" : 0,
    "scper5" : 7.3718573971919445,
    "scper6" : 7.726998920545485,
    "indlisprior" : 0,
    "progrRiga" : 3.812761638325517,
    "lineaFa05" : "lineaFa05",
    "codartfor" : "codartfor",
    "numReg" : "numReg",
    "descart" : "descart",
    "alivacompCg28" : "alivacompCg28",
    "base" : 5.299143560275359,
    "scimp" : 5.974942028545841,
    "rigaRiferimenti" : [ {
      "flgNsdocbis" : 7.686670838404092,
      "qta2mov" : 0.05965928697733491,
      "flgNonpiuevpdc" : 7.321091499885957,
      "notevsdoc" : "notevsdoc",
      "seqfase" : 5.099298781640682,
      "datansdoc" : "2000-01-23T04:56:07.000+00:00",
      "indQtaordres" : 3,
      "seznsdoc" : "seznsdoc",
      "indStipodoc" : 0,
      "datansconf" : "2000-01-23T04:56:07.000+00:00",
      "datavsconf" : "2000-01-23T04:56:07.000+00:00",
      "progRiga" : 6.568304668801491,
      "valoremov" : 9.728706165995554,
      "progRigarifDo30" : 7.338782761819433,
      "progRigapadreDo30" : 1.4985931822280574,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "notensdoc" : "notensdoc",
      "progRif" : 2.3317418552851765,
      "rifvsdoc" : "rifvsdoc",
      "additionalData" : {
        "key" : ""
      },
      "numregpadreCo99" : "numregpadreCo99",
      "flgAggprescvar" : 7.964879197514727,
      "qta1mov" : 9.739448828157911,
      "collimov" : 9.140242185517025,
      "flgAggqtatrasf" : 4,
      "rifnsdoc" : "rifnsdoc",
      "fasePd12" : 4.39343993729625,
      "datavsdoc" : "2000-01-23T04:56:07.000+00:00",
      "indAggdocorigine" : 6.936593194494838,
      "progPdcDo65" : 4.075306827525243,
      "flgStornoqtaval" : 2,
      "numnsdoc" : 4.515863748649669,
      "dittaCg18" : 8.81377937009168,
      "indTipodoc" : 5,
      "numregrifCo99" : "numregrifCo99",
      "numvsdoc" : "numvsdoc",
      "progPdcrifDo65" : 2.674423984487264
    }, {
      "flgNsdocbis" : 7.686670838404092,
      "qta2mov" : 0.05965928697733491,
      "flgNonpiuevpdc" : 7.321091499885957,
      "notevsdoc" : "notevsdoc",
      "seqfase" : 5.099298781640682,
      "datansdoc" : "2000-01-23T04:56:07.000+00:00",
      "indQtaordres" : 3,
      "seznsdoc" : "seznsdoc",
      "indStipodoc" : 0,
      "datansconf" : "2000-01-23T04:56:07.000+00:00",
      "datavsconf" : "2000-01-23T04:56:07.000+00:00",
      "progRiga" : 6.568304668801491,
      "valoremov" : 9.728706165995554,
      "progRigarifDo30" : 7.338782761819433,
      "progRigapadreDo30" : 1.4985931822280574,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "notensdoc" : "notensdoc",
      "progRif" : 2.3317418552851765,
      "rifvsdoc" : "rifvsdoc",
      "additionalData" : {
        "key" : ""
      },
      "numregpadreCo99" : "numregpadreCo99",
      "flgAggprescvar" : 7.964879197514727,
      "qta1mov" : 9.739448828157911,
      "collimov" : 9.140242185517025,
      "flgAggqtatrasf" : 4,
      "rifnsdoc" : "rifnsdoc",
      "fasePd12" : 4.39343993729625,
      "datavsdoc" : "2000-01-23T04:56:07.000+00:00",
      "indAggdocorigine" : 6.936593194494838,
      "progPdcDo65" : 4.075306827525243,
      "flgStornoqtaval" : 2,
      "numnsdoc" : 4.515863748649669,
      "dittaCg18" : 8.81377937009168,
      "indTipodoc" : 5,
      "numregrifCo99" : "numregrifCo99",
      "numvsdoc" : "numvsdoc",
      "progPdcrifDo65" : 2.674423984487264
    } ]
  } ],
  "tipodocnumeraz" : 6.438423552598547,
  "lastchange" : "2000-01-23T04:56:07.000+00:00",
  "esclusioneIvaTestata" : 6,
  "testataEstesa" : [ {
    "alfst10" : "alfst10",
    "datast2" : "2000-01-23T04:56:07.000+00:00",
    "numst12" : 9.693372334146686,
    "datast1" : "2000-01-23T04:56:07.000+00:00",
    "alfst12" : "alfst12",
    "alfst11" : "alfst11",
    "idmediaCg99" : 6.677419970877656,
    "datast4" : "2000-01-23T04:56:07.000+00:00",
    "numst10" : 4.966567419166605,
    "datast3" : "2000-01-23T04:56:07.000+00:00",
    "numst11" : 2.9790233918904585,
    "datast6" : "2000-01-23T04:56:07.000+00:00",
    "datast5" : "2000-01-23T04:56:07.000+00:00",
    "alfst4" : "alfst4",
    "alfst5" : "alfst5",
    "alfst6" : "alfst6",
    "alfst7" : "alfst7",
    "alfst8" : "alfst8",
    "alfst9" : "alfst9",
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "alfst1" : "alfst1",
    "alfst2" : "alfst2",
    "alfst3" : "alfst3",
    "flgSt2" : 7.239590766928185,
    "flgSt3" : 6.090696483578148,
    "flgSt4" : 9.852147203726787,
    "numst8" : 4.851239691941878,
    "numst7" : 0.42286244411048224,
    "numst9" : 7.062107048540267,
    "prog" : 8.474710856151638,
    "numst2" : 2.6249013358703053,
    "numst1" : 5.083590215108117,
    "numst4" : 0.9619297253823988,
    "dittaCg18" : 8.018039914932286,
    "numst3" : 3.5742991213280972,
    "numst6" : 1.633699845078339,
    "numst5" : 7.224413148959403,
    "indSt1" : 1.2880645475702646,
    "indSt2" : 1.822577900073098,
    "flgSt1" : 2.6736395633233356
  }, {
    "alfst10" : "alfst10",
    "datast2" : "2000-01-23T04:56:07.000+00:00",
    "numst12" : 9.693372334146686,
    "datast1" : "2000-01-23T04:56:07.000+00:00",
    "alfst12" : "alfst12",
    "alfst11" : "alfst11",
    "idmediaCg99" : 6.677419970877656,
    "datast4" : "2000-01-23T04:56:07.000+00:00",
    "numst10" : 4.966567419166605,
    "datast3" : "2000-01-23T04:56:07.000+00:00",
    "numst11" : 2.9790233918904585,
    "datast6" : "2000-01-23T04:56:07.000+00:00",
    "datast5" : "2000-01-23T04:56:07.000+00:00",
    "alfst4" : "alfst4",
    "alfst5" : "alfst5",
    "alfst6" : "alfst6",
    "alfst7" : "alfst7",
    "alfst8" : "alfst8",
    "alfst9" : "alfst9",
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "alfst1" : "alfst1",
    "alfst2" : "alfst2",
    "alfst3" : "alfst3",
    "flgSt2" : 7.239590766928185,
    "flgSt3" : 6.090696483578148,
    "flgSt4" : 9.852147203726787,
    "numst8" : 4.851239691941878,
    "numst7" : 0.42286244411048224,
    "numst9" : 7.062107048540267,
    "prog" : 8.474710856151638,
    "numst2" : 2.6249013358703053,
    "numst1" : 5.083590215108117,
    "numst4" : 0.9619297253823988,
    "dittaCg18" : 8.018039914932286,
    "numst3" : 3.5742991213280972,
    "numst6" : 1.633699845078339,
    "numst5" : 7.224413148959403,
    "indSt1" : 1.2880645475702646,
    "indSt2" : 1.822577900073098,
    "flgSt1" : 2.6736395633233356
  } ]
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Check the Customer Credit
 * Get an object of type corresponding the requested id and check for associated customer credit
 *
 * id String Id to get the object
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns CustomerCreditResultDTO
 **/
exports.apiV1EnvironmentMGDocumentoIdCheckcustomercreditGET = function(id,environment,authorizationScope,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "customerSupplierType" : "customerSupplierType",
  "isCreditExceeded" : true,
  "creditTotal" : 6.027456183070403,
  "customerSupplierName" : "customerSupplierName",
  "creditResidual" : 1.4658129805029452,
  "creditAvailable" : 0.8008281904610115,
  "customerSupplierCode" : "customerSupplierCode"
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Delete the document having Numreg equals to {ID}
 * Deleting object of type
 *
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentMGDocumentoIdDELETE = function(id,environment,authorizationScope,force,ignoreCompanyPolicyFilter,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Get the document having Numreg equals to {ID}
 * Get an object of type corresponding the requested id
 *
 * id String Id to get the object
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * dlevel String Serialization level (optional)
 * dlevelkey String Serialization level key (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns DocumentoTestataMGDTO
 **/
exports.apiV1EnvironmentMGDocumentoIdGET = function(id,environment,authorizationScope,ignoreCompanyPolicyFilter,dlevel,dlevelkey,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "totaliDocumento" : {
    "totalePagare" : 7.691531173686691,
    "scimpmerce" : 2.1184454156145116,
    "totspbolli" : 0.907335931343648,
    "acconto" : 2.7105647837031563,
    "ivaomag" : 8.776709848030322,
    "totaleCosto" : 9.660013839736129,
    "abbuono" : 5.799021278474435,
    "marginedocumento" : 9.576768325858186,
    "imponibomag" : 1.5673210879004595,
    "scimpcassa" : 5.473133728634785,
    "scpercassa2" : 3.93938484566677,
    "scpermerce3" : 9.616627406338315,
    "totdocumento" : 2.376630828418186,
    "scpercassa1" : 6.434791978928281,
    "scpermerce2" : 8.65952233326453,
    "scpermerce1" : 2.162514338057849,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "totimponibile" : 5.898513389775777,
    "totiva" : 2.4062866311545816,
    "totspinc" : 6.232321224432258
  },
  "callOptions" : {
    "flgLockOnDocExist" : false,
    "enableAdditionalValidations" : false,
    "flgSpincasForceZero" : false,
    "esclusioneAgentiMultipli" : false,
    "esclusioneSpeseTestiCliFor" : false,
    "flgSpbolliForceZero" : false,
    "disableLetterOfIntent" : false,
    "esclusioneIvaTestata" : false,
    "flgDisableItemControl" : false
  },
  "valutaCg08" : "valutaCg08",
  "flgSpbolli" : 1,
  "numdocorig" : "numdocorig",
  "codIva" : {
    "flgSospimp" : 1.633699845078339,
    "indNatura" : 8,
    "flgAgri" : 6.090696483578148,
    "tipologia" : 4.778706604314481,
    "percindet" : 6.389489858092311,
    "mossperc" : 5.305668385940959,
    "natureEsCO" : {
      "descr" : "descr",
      "codice" : "codice",
      "datainival" : "2000-01-23T04:56:07.000+00:00",
      "natureAssCO" : [ null, null ],
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "id" : 3,
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "verslynfa" : "verslynfa",
    "idExtendedAttributeEntity" : 0,
    "annotazioni" : "annotazioni",
    "rowVersion" : "",
    "indNatassoswCg2n" : 7,
    "perciva" : 5.201737367852583,
    "percforf" : 6.541917087228235,
    "codice" : "codice",
    "impostamonofasersm" : 4.851239691941878,
    "codiceOss" : "codiceOss",
    "extensionData" : [ null, null ],
    "stdcodivarifCg28" : "stdcodivarifCg28",
    "flgMossgest" : 3,
    "flgAutoue" : 1.2880645475702646,
    "flgIndet" : 2.9790233918904585,
    "codPlafond" : 7.239590766928185,
    "note" : "note",
    "flgAssport398" : 6.677419970877656,
    "flgMossrid" : 0,
    "indStaper" : 3.474156394106027,
    "flgAllclifor" : 9.852147203726787,
    "codiceagr" : "codiceagr",
    "flgImpostadibollo" : 4,
    "flgCorrVent" : 1.822577900073098,
    "aliqivavent" : 2.6736395633233356,
    "flgNotvar" : 7.224413148959403,
    "percmonofasersm" : 6.614319261836819,
    "idprov" : 0.42286244411048224,
    "idExtendedAttributeSubEntity" : 3,
    "natureAssCO" : {
      "descr" : "descr",
      "idCg2m" : 3,
      "idassosw" : 5,
      "codice" : "codice",
      "datainival" : "2000-01-23T04:56:07.000+00:00",
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "flgMonofasersm" : 2.6249013358703053,
    "mosscodCg07" : 6.711221582652969,
    "descrizione" : "descrizione",
    "flgEscludiblacklist" : 5.083590215108117,
    "flgIvaedit" : 9.693372334146686,
    "indtipopart" : 6.008900790410507
  },
  "bancaCg12" : 5.637376656633329,
  "ditta" : 2.027123023002322,
  "anagraficaDocumentoDitta" : {
    "indStaperMg36" : 6.027456183070403,
    "codDocumMg36" : "codDocumMg36",
    "dittaCg18" : 0.8008281904610115,
    "sezdefault" : "sezdefault",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    }
  },
  "testoletint" : "testoletint",
  "indfattpa" : 1,
  "sezautof" : "sezautof",
  "cliforfatt" : 9.301444243932576,
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "customerSupplierMG" : {
    "statoAttualeCO" : {
      "statiDisponibili" : [ null, null ],
      "statoCorrente" : {
        "indTipoStato" : 8,
        "idStato" : 2,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "seq" : 2
      },
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "contratto" : "contratto",
    "idCliFor" : 8,
    "idmediaCg99" : 7.740351818741173,
    "blackListGeneralMasterData" : {
      "datavalid" : "2000-01-23T04:56:07.000+00:00",
      "ragsofiscex" : "ragsofiscex",
      "addresses" : [ {
        "indirizzocomp2" : "indirizzocomp2",
        "addressesType" : [ {
          "tipo" : 6,
          "idCG1J" : 6,
          "pluginData" : {
            "key" : ""
          },
          "id" : 2,
          "additionalData" : {
            "key" : ""
          }
        }, {
          "tipo" : 6,
          "idCG1J" : 6,
          "pluginData" : {
            "key" : ""
          },
          "id" : 2,
          "additionalData" : {
            "key" : ""
          }
        } ],
        "risstato" : "risstato",
        "riszip" : "riszip",
        "pv" : "pv",
        "precisione" : "precisione",
        "codlinguaMg52" : "codlinguaMg52",
        "frazione" : "frazione",
        "emailPec" : "emailPec",
        "tipologia" : "tipologia",
        "via" : "via",
        "idTeamportal" : 6,
        "numciv" : "numciv",
        "cap" : "cap",
        "latitudine" : 3.5571952270680973,
        "statoCg07" : 1.284659006116532,
        "presso" : "presso",
        "federalStateViewCO" : {
          "descr" : "descr",
          "iso3166statofed" : "iso3166statofed",
          "a2iso3166Cg07" : "a2iso3166Cg07",
          "pluginData" : {
            "key" : ""
          },
          "codiceCg07" : 5.944895607614016,
          "additionalData" : {
            "key" : ""
          },
          "statofed" : "statofed"
        },
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "fax" : "fax",
        "statofed" : "statofed",
        "telefono" : "telefono",
        "datamod" : "2000-01-23T04:56:07.000+00:00",
        "email" : "email",
        "citta" : "citta",
        "ragsoc" : "ragsoc",
        "cellnum" : "cellnum",
        "comanaCg01" : "comanaCg01",
        "codiceCg16" : 8,
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "ragsocex" : "ragsocex",
        "rifindirizzo" : "rifindirizzo",
        "codicesfed" : "codicesfed",
        "contea" : "contea",
        "indirizzocomp" : "indirizzocomp",
        "riswarning" : "riswarning",
        "indirizzoex" : "indirizzoex",
        "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
        "risregione" : "risregione",
        "edificio" : "edificio",
        "statoEst" : {
          "codSian" : 3.353193347011243,
          "crtpiva" : "crtpiva",
          "leniban" : 6,
          "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
          "desiso3166" : "desiso3166",
          "idmediaCg99" : 0.8851374739011653,
          "codice" : 6.704019297950036,
          "numiso3166" : "numiso3166",
          "codiceCg08" : "codiceCg08",
          "currencyCO" : {
            "sigla" : "sigla",
            "dataattuem" : "2000-01-23T04:56:07.000+00:00",
            "numdec" : 7.04836565559697,
            "exchangeRateCO" : [ {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            }, {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            } ],
            "idmediaCg99" : 8.969578798196912,
            "codice" : "codice",
            "indCertoincerto" : 7,
            "cambiofisso" : 0.10263654006109402,
            "descr" : "descr",
            "flgValuem" : 4.652396432933246,
            "indValuem" : 3.0576100241049344,
            "indSepmigl" : 3.0205796992916243,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "descr" : "descr",
          "flgIban" : 3,
          "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
          "codIso" : "codIso",
          "a3iso3166" : "a3iso3166",
          "indTipostato" : 7.058770351582356,
          "a2iso3166" : "a2iso3166",
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "datacee" : "2000-01-23T04:56:07.000+00:00",
          "flgSepa" : 7
        },
        "longitudine" : 6.965117697638846,
        "indweb" : "indweb"
      }, {
        "indirizzocomp2" : "indirizzocomp2",
        "addressesType" : [ {
          "tipo" : 6,
          "idCG1J" : 6,
          "pluginData" : {
            "key" : ""
          },
          "id" : 2,
          "additionalData" : {
            "key" : ""
          }
        }, {
          "tipo" : 6,
          "idCG1J" : 6,
          "pluginData" : {
            "key" : ""
          },
          "id" : 2,
          "additionalData" : {
            "key" : ""
          }
        } ],
        "risstato" : "risstato",
        "riszip" : "riszip",
        "pv" : "pv",
        "precisione" : "precisione",
        "codlinguaMg52" : "codlinguaMg52",
        "frazione" : "frazione",
        "emailPec" : "emailPec",
        "tipologia" : "tipologia",
        "via" : "via",
        "idTeamportal" : 6,
        "numciv" : "numciv",
        "cap" : "cap",
        "latitudine" : 3.5571952270680973,
        "statoCg07" : 1.284659006116532,
        "presso" : "presso",
        "federalStateViewCO" : {
          "descr" : "descr",
          "iso3166statofed" : "iso3166statofed",
          "a2iso3166Cg07" : "a2iso3166Cg07",
          "pluginData" : {
            "key" : ""
          },
          "codiceCg07" : 5.944895607614016,
          "additionalData" : {
            "key" : ""
          },
          "statofed" : "statofed"
        },
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "fax" : "fax",
        "statofed" : "statofed",
        "telefono" : "telefono",
        "datamod" : "2000-01-23T04:56:07.000+00:00",
        "email" : "email",
        "citta" : "citta",
        "ragsoc" : "ragsoc",
        "cellnum" : "cellnum",
        "comanaCg01" : "comanaCg01",
        "codiceCg16" : 8,
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "ragsocex" : "ragsocex",
        "rifindirizzo" : "rifindirizzo",
        "codicesfed" : "codicesfed",
        "contea" : "contea",
        "indirizzocomp" : "indirizzocomp",
        "riswarning" : "riswarning",
        "indirizzoex" : "indirizzoex",
        "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
        "risregione" : "risregione",
        "edificio" : "edificio",
        "statoEst" : {
          "codSian" : 3.353193347011243,
          "crtpiva" : "crtpiva",
          "leniban" : 6,
          "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
          "desiso3166" : "desiso3166",
          "idmediaCg99" : 0.8851374739011653,
          "codice" : 6.704019297950036,
          "numiso3166" : "numiso3166",
          "codiceCg08" : "codiceCg08",
          "currencyCO" : {
            "sigla" : "sigla",
            "dataattuem" : "2000-01-23T04:56:07.000+00:00",
            "numdec" : 7.04836565559697,
            "exchangeRateCO" : [ {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            }, {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            } ],
            "idmediaCg99" : 8.969578798196912,
            "codice" : "codice",
            "indCertoincerto" : 7,
            "cambiofisso" : 0.10263654006109402,
            "descr" : "descr",
            "flgValuem" : 4.652396432933246,
            "indValuem" : 3.0576100241049344,
            "indSepmigl" : 3.0205796992916243,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "descr" : "descr",
          "flgIban" : 3,
          "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
          "codIso" : "codIso",
          "a3iso3166" : "a3iso3166",
          "indTipostato" : 7.058770351582356,
          "a2iso3166" : "a2iso3166",
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "datacee" : "2000-01-23T04:56:07.000+00:00",
          "flgSepa" : 7
        },
        "longitudine" : 6.965117697638846,
        "indweb" : "indweb"
      } ],
      "codiceident" : "codiceident",
      "indirCorEX" : "indirCorEX",
      "flgFattpa" : 7,
      "indirizzo" : "indirizzo",
      "ragsoanagex" : "ragsoanagex",
      "codiceCg07" : 7.061401241503109,
      "indsoggrit" : 7.457744773683766,
      "ragSoAnag" : "ragSoAnag",
      "capcor" : "capcor",
      "cittafisc" : "cittafisc",
      "intragroupStructureCO" : {
        "descr" : "descr",
        "codice" : 7.260521264802104,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "codAnagGen" : 4,
        "codIntercompany" : 9
      },
      "statofiscCg07" : 5.025004791520295,
      "tel2num" : "tel2num",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codfiscale" : "codfiscale",
      "statofed" : "statofed",
      "codrichiamo" : 2,
      "provfisc" : "provfisc",
      "idExtendedAttributeEntity" : 9,
      "citta" : "citta",
      "statonascitaCg07" : 9.965781217890562,
      "codice" : 2,
      "indFiscale" : "indFiscale",
      "nome" : "nome",
      "comnascitaCg01" : "comnascitaCg01",
      "codiceCg15" : "codiceCg15",
      "extensionData" : [ {
        "value" : "",
        "key" : "key"
      }, {
        "value" : "",
        "key" : "key"
      } ],
      "ragsofisc" : "ragsofisc",
      "indemail" : "indemail",
      "indirizzoEX" : "indirizzoEX",
      "comfisCg01" : "comfisCg01",
      "comnascita" : "comnascita",
      "partiva" : "partiva",
      "flgNoblacklist" : 1.2315135367772556,
      "partivaEst" : "partivaEst",
      "cognome" : "cognome",
      "idmediaCg99" : 6.84685269835264,
      "wtCodeCO" : {
        "causdd1" : "causdd1",
        "codNonsog" : 0.8774076871421566,
        "flgRegagevo" : 4.86315908102884,
        "idmediaCg99" : 3.901545264248647,
        "percRipPerc" : 1.8268702177058116,
        "flgRitImposta" : 6.073898085781152,
        "codPrev" : "codPrev",
        "tiporapporto" : "tiporapporto",
        "percripaz" : 9.254183946267839,
        "pluginData" : {
          "key" : ""
        },
        "flgPignTerzi" : 7.933506881737151,
        "flgProteo360" : 5.507386964179881,
        "additionalData" : {
          "key" : ""
        },
        "flgGlad" : 9.702963800023566,
        "codFiscPrev" : "codFiscPrev",
        "gcprev" : 4,
        "idprov" : 0.43431398824148815,
        "codice" : "codice",
        "percci" : 4.573936264232251,
        "flgSosprit" : 8,
        "descr" : "descr",
        "flgMinimi" : 0,
        "codTributo" : "codTributo",
        "indCodattglad" : 2.9409642974827896,
        "indTipocassa" : 1,
        "percra" : 8.863729185622827,
        "percbaseimp" : 6.623518433804886,
        "codTribrp" : "codTribrp",
        "inpsivs" : 8.28965939814297,
        "rowversion" : ""
      },
      "dtiniziopec" : "2000-01-23T04:56:07.000+00:00",
      "capfisc" : "capfisc",
      "codicecorCg07" : 3.616076749251911,
      "codiceCgc0" : 9.301444243932576,
      "cap" : "cap",
      "faxnum" : "faxnum",
      "alias" : "alias",
      "flgOmonimo" : 1.0246457001441578,
      "provnascita" : "provnascita",
      "ragsocor" : "ragsocor",
      "prov" : "prov",
      "flgAnagval" : 4.145608029883936,
      "rapazestCg16" : 1,
      "cellnum" : "cellnum",
      "flgPrsfis" : 1.4894159098541704,
      "tel1num" : "tel1num",
      "idExtendedAttributeSubEntity" : 6,
      "provcor" : "provcor",
      "dtfinepec" : "2000-01-23T04:56:07.000+00:00",
      "cittacor" : "cittacor",
      "codicesfed" : "codicesfed",
      "statofedfisc" : "statofedfisc",
      "indFiscaleEX" : "indFiscaleEX",
      "partitaIVA" : "partitaIVA",
      "indirCor" : "indirCor",
      "sesso" : 4.965218492984954,
      "lastchange" : "2000-01-23T04:56:07.000+00:00",
      "ragsocorex" : "ragsocorex",
      "datanascita" : "2000-01-23T04:56:07.000+00:00",
      "auidAu04" : 5,
      "indweb" : "indweb"
    },
    "goods" : {
      "reverseTypeFI" : {
        "reverseTypeCode" : 0,
        "reverseTypeDescription" : "reverseTypeDescription",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "flgBilconsattpassdist" : 0,
      "contochiu" : "contochiu",
      "flgAnalit" : 5,
      "codeformatted" : "codeformatted",
      "intragroupStructureCO" : {
        "descr" : "descr",
        "codice" : 7.260521264802104,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "codAnagGen" : 4,
        "codIntercompany" : 9
      },
      "flgAggfatt" : 8,
      "indLivchius" : 3,
      "idcontoratattCg24" : 6,
      "idcontoapeCg24" : 8,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "contocrsosp" : "contocrsosp",
      "flgContoimm" : 1,
      "flgOpnonfin" : 5.547564904556697,
      "indDaavec" : 3,
      "cogeprogeMateriali" : 2,
      "coaAccountCustomizationFI" : [ {
        "descr" : "descr",
        "iddespcon" : 6,
        "dittaCg18" : 5.616380282218067,
        "contoCg24" : "contoCg24",
        "idmediaCg99" : 7.014147440046284,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "gruppoCg10" : 9.966789814889403,
        "idCg24" : 9,
        "rowversion" : ""
      }, {
        "descr" : "descr",
        "iddespcon" : 6,
        "dittaCg18" : 5.616380282218067,
        "contoCg24" : "contoCg24",
        "idmediaCg99" : 7.014147440046284,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "gruppoCg10" : 9.966789814889403,
        "idCg24" : 9,
        "rowversion" : ""
      } ],
      "accountType" : 9,
      "contoratpass" : "contoratpass",
      "descr" : "descr",
      "idcontorisattCg24" : 1,
      "indDaav" : 1,
      "suddconti" : 8.780989965779524,
      "contoratatt" : "contoratatt",
      "indMastroCliFor" : 1.9732909296667345,
      "idcontochiuCg24" : 8,
      "percindetra" : 0.9178980228274691,
      "codiceCg22" : 4.863793115215697,
      "indAttpasspor" : 1,
      "indTipoconto" : 4,
      "contoape" : "contoape",
      "flgGespor" : 2,
      "cogeprogeAbil" : 2,
      "flgSaldog" : 5,
      "percindeduc" : 8.262575023052213,
      "contorisatt" : "contorisatt",
      "codiceCgc0" : 2.008994665592807,
      "flgValutaest" : 5,
      "flgRaganal" : 9,
      "alias" : "alias",
      "conto" : "conto",
      "balanceSheetAccountCategory" : 1,
      "cogeprogeNodo" : 6,
      "contorispass" : "contorispass",
      "indContoricav" : 4,
      "vatTypeFI" : {
        "descr" : "descr",
        "indAutofattura" : 7,
        "agviaggio" : 0,
        "codice" : 4.318826475758856,
        "pluginData" : {
          "key" : ""
        },
        "localizzazione" : 8,
        "additionalData" : {
          "key" : ""
        },
        "codiceCg0d" : 9.908114046741538,
        "indTipo" : 7.437703257022269
      },
      "idcontorispassCg24" : 2,
      "cogeprogeAttivita" : 8,
      "flgGesec" : 8,
      "coaInternationalCustomizationFI" : [ {
        "contoCg24" : "contoCg24",
        "subcategoria" : 8,
        "categoria" : 3,
        "gbDeferralcode" : "gbDeferralcode",
        "esModulo347" : 5,
        "pluginData" : {
          "key" : ""
        },
        "id" : 7,
        "iso3166A2" : "iso3166A2",
        "additionalData" : {
          "key" : ""
        },
        "gruppoCg10" : 8.331741856019029,
        "idCg24" : 9,
        "rowversion" : ""
      }, {
        "contoCg24" : "contoCg24",
        "subcategoria" : 8,
        "categoria" : 3,
        "gbDeferralcode" : "gbDeferralcode",
        "esModulo347" : 5,
        "pluginData" : {
          "key" : ""
        },
        "id" : 7,
        "iso3166A2" : "iso3166A2",
        "additionalData" : {
          "key" : ""
        },
        "gruppoCg10" : 8.331741856019029,
        "idCg24" : 9,
        "rowversion" : ""
      } ],
      "gruppoCg10" : 8.546645780823726,
      "coaAccountStateFI" : [ {
        "consosCg24" : "consosCg24",
        "dittaCg18" : 0.8972273556195443,
        "dtdisatt" : "2000-01-23T04:56:07.000+00:00",
        "grusosCg10" : 1.7692392591014339,
        "pluginData" : {
          "key" : ""
        },
        "idstatipdc" : 9,
        "additionalData" : {
          "key" : ""
        },
        "dtconsos" : "2000-01-23T04:56:07.000+00:00",
        "flgDisatt" : 9.684087197655908,
        "idCg24" : 6,
        "rowversion" : ""
      }, {
        "consosCg24" : "consosCg24",
        "dittaCg18" : 0.8972273556195443,
        "dtdisatt" : "2000-01-23T04:56:07.000+00:00",
        "grusosCg10" : 1.7692392591014339,
        "pluginData" : {
          "key" : ""
        },
        "idstatipdc" : 9,
        "additionalData" : {
          "key" : ""
        },
        "dtconsos" : "2000-01-23T04:56:07.000+00:00",
        "flgDisatt" : 9.684087197655908,
        "idCg24" : 6,
        "rowversion" : ""
      } ],
      "coaGroupCodeFI" : {
        "descr" : "descr",
        "numlivcons" : 6.460213024504889,
        "gruppo" : 8.289598895249666,
        "numlivelli" : 6.8668894011844035,
        "accountProposals" : [ {
          "contoCg24" : "contoCg24",
          "codice" : 7.375698277301938,
          "pluginData" : {
            "key" : ""
          },
          "id" : 0,
          "additionalData" : {
            "key" : ""
          },
          "gruppoCg10" : 6.97635352548152,
          "idCg24" : 9,
          "rowversion" : ""
        }, {
          "contoCg24" : "contoCg24",
          "codice" : 7.375698277301938,
          "pluginData" : {
            "key" : ""
          },
          "id" : 0,
          "additionalData" : {
            "key" : ""
          },
          "gruppoCg10" : 6.97635352548152,
          "idCg24" : 9,
          "rowversion" : ""
        } ],
        "pluginData" : {
          "key" : ""
        },
        "maskedit" : "maskedit",
        "additionalData" : {
          "key" : ""
        },
        "flgPdclib" : 9,
        "rowversion" : ""
      },
      "idparent" : 1,
      "idreverse" : 7,
      "flgIntercompany" : 8,
      "idcontoratpassCg24" : 7,
      "flgRarp" : 2,
      "idconto" : 4,
      "cogeprogeSpese" : 5,
      "idRifPdC80" : 7,
      "indCosvend" : 4
    },
    "flgAttivo" : 0.8851374739011653,
    "tipocfCg40" : 5.533258397034986,
    "dmsPublishedEntityFW" : {
      "tipoarchHm30" : 2,
      "idknos" : 6,
      "dittaCg18" : 1.0046985756074744,
      "flgInvalid" : 3,
      "datapub" : "2000-01-23T04:56:07.000+00:00",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "protocollo" : "protocollo",
      "nome" : "nome",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "publicationid" : "publicationid",
      "percorso" : "percorso"
    },
    "officeCO" : {
      "indIrizzo" : "indIrizzo",
      "idmediaCg99" : 6.720288821326667,
      "codice" : 7.766860781935265,
      "indDimcentrocomm" : 5.304373278797373,
      "cap" : "cap",
      "dittaCg18" : 1.6056289151258096,
      "progRea" : 8.708394192403432,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "prov" : "prov",
      "numerorea" : "numerorea",
      "citta" : "citta",
      "rowversion" : ""
    },
    "flgInterCompany" : 6.519180951018382,
    "paymentTermCO" : {
      "flgDesc" : 0.8164256701298711,
      "paymentTermDetailCO" : [ {
        "indImpfix" : 1.4985931822280574,
        "daggfix1" : 9.140242185517025,
        "daggfix2" : 8.81377937009168,
        "ggmmfix" : 3.8463127686084055,
        "ggdecor" : 6.936593194494838,
        "idCg64" : 2,
        "imporfix" : 2.3317418552851765,
        "flgFrperciva" : 2.408218941758913,
        "idCg62" : 4,
        "pluginData" : {
          "key" : ""
        },
        "id" : 4,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 7.321091499885957,
        "indTipocalend" : 7,
        "indTipodecor" : 9.739448828157911,
        "aggfix2" : 9.610516429629122,
        "aggfix1" : 5.948961008630453,
        "perciva" : 5.099298781640682,
        "el2frimp" : 4.180725413706508,
        "ggscadfix2" : 5.103912736584151,
        "tipoeff" : 3.3182952910080674,
        "flgFrpercimp" : 7.686670838404092,
        "percimp" : 0.05965928697733491,
        "prog" : 9.728706165995554,
        "el1frimp" : 4.39343993729625,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 0.6052866655822231,
        "subTypeCO" : {
          "ggoffset" : 9.629537564416708,
          "codiceCg07" : 8.50835276411088,
          "tipoeff" : 0.391063602337155,
          "codPaguc" : "codPaguc",
          "descstipo" : "descstipo",
          "codStipoeff" : 9.551762125042277,
          "flgAssegno" : 5,
          "indModfatturapa" : 2,
          "nationCO" : {
            "codSian" : 3.353193347011243,
            "crtpiva" : "crtpiva",
            "leniban" : 6,
            "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
            "desiso3166" : "desiso3166",
            "idmediaCg99" : 0.8851374739011653,
            "codice" : 6.704019297950036,
            "numiso3166" : "numiso3166",
            "codiceCg08" : "codiceCg08",
            "currencyCO" : {
              "sigla" : "sigla",
              "dataattuem" : "2000-01-23T04:56:07.000+00:00",
              "numdec" : 7.04836565559697,
              "exchangeRateCO" : [ {
                "cambio" : 4.078845849666752,
                "anno" : 3.2588565619047607,
                "idmediaCg99" : 6.628464275087742,
                "codiceCg08" : "codiceCg08",
                "indCertoincerto" : 4,
                "codicerifCg08" : "codicerifCg08",
                "giorno" : 0.2025324113236393,
                "mese" : 1.041444916118296,
                "pluginData" : {
                  "key" : ""
                },
                "additionalData" : {
                  "key" : ""
                },
                "adegcambio" : 5.533258397034986,
                "rowversion" : ""
              }, {
                "cambio" : 4.078845849666752,
                "anno" : 3.2588565619047607,
                "idmediaCg99" : 6.628464275087742,
                "codiceCg08" : "codiceCg08",
                "indCertoincerto" : 4,
                "codicerifCg08" : "codicerifCg08",
                "giorno" : 0.2025324113236393,
                "mese" : 1.041444916118296,
                "pluginData" : {
                  "key" : ""
                },
                "additionalData" : {
                  "key" : ""
                },
                "adegcambio" : 5.533258397034986,
                "rowversion" : ""
              } ],
              "idmediaCg99" : 8.969578798196912,
              "codice" : "codice",
              "indCertoincerto" : 7,
              "cambiofisso" : 0.10263654006109402,
              "descr" : "descr",
              "flgValuem" : 4.652396432933246,
              "indValuem" : 3.0576100241049344,
              "indSepmigl" : 3.0205796992916243,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              }
            },
            "descr" : "descr",
            "flgIban" : 3,
            "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
            "codIso" : "codIso",
            "a3iso3166" : "a3iso3166",
            "indTipostato" : 7.058770351582356,
            "a2iso3166" : "a2iso3166",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "datacee" : "2000-01-23T04:56:07.000+00:00",
            "flgSepa" : 7
          },
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 1,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 4,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 7.964879197514727,
        "indDatarif" : 6.568304668801491,
        "rowversion" : ""
      }, {
        "indImpfix" : 1.4985931822280574,
        "daggfix1" : 9.140242185517025,
        "daggfix2" : 8.81377937009168,
        "ggmmfix" : 3.8463127686084055,
        "ggdecor" : 6.936593194494838,
        "idCg64" : 2,
        "imporfix" : 2.3317418552851765,
        "flgFrperciva" : 2.408218941758913,
        "idCg62" : 4,
        "pluginData" : {
          "key" : ""
        },
        "id" : 4,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 7.321091499885957,
        "indTipocalend" : 7,
        "indTipodecor" : 9.739448828157911,
        "aggfix2" : 9.610516429629122,
        "aggfix1" : 5.948961008630453,
        "perciva" : 5.099298781640682,
        "el2frimp" : 4.180725413706508,
        "ggscadfix2" : 5.103912736584151,
        "tipoeff" : 3.3182952910080674,
        "flgFrpercimp" : 7.686670838404092,
        "percimp" : 0.05965928697733491,
        "prog" : 9.728706165995554,
        "el1frimp" : 4.39343993729625,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 0.6052866655822231,
        "subTypeCO" : {
          "ggoffset" : 9.629537564416708,
          "codiceCg07" : 8.50835276411088,
          "tipoeff" : 0.391063602337155,
          "codPaguc" : "codPaguc",
          "descstipo" : "descstipo",
          "codStipoeff" : 9.551762125042277,
          "flgAssegno" : 5,
          "indModfatturapa" : 2,
          "nationCO" : {
            "codSian" : 3.353193347011243,
            "crtpiva" : "crtpiva",
            "leniban" : 6,
            "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
            "desiso3166" : "desiso3166",
            "idmediaCg99" : 0.8851374739011653,
            "codice" : 6.704019297950036,
            "numiso3166" : "numiso3166",
            "codiceCg08" : "codiceCg08",
            "currencyCO" : {
              "sigla" : "sigla",
              "dataattuem" : "2000-01-23T04:56:07.000+00:00",
              "numdec" : 7.04836565559697,
              "exchangeRateCO" : [ {
                "cambio" : 4.078845849666752,
                "anno" : 3.2588565619047607,
                "idmediaCg99" : 6.628464275087742,
                "codiceCg08" : "codiceCg08",
                "indCertoincerto" : 4,
                "codicerifCg08" : "codicerifCg08",
                "giorno" : 0.2025324113236393,
                "mese" : 1.041444916118296,
                "pluginData" : {
                  "key" : ""
                },
                "additionalData" : {
                  "key" : ""
                },
                "adegcambio" : 5.533258397034986,
                "rowversion" : ""
              }, {
                "cambio" : 4.078845849666752,
                "anno" : 3.2588565619047607,
                "idmediaCg99" : 6.628464275087742,
                "codiceCg08" : "codiceCg08",
                "indCertoincerto" : 4,
                "codicerifCg08" : "codicerifCg08",
                "giorno" : 0.2025324113236393,
                "mese" : 1.041444916118296,
                "pluginData" : {
                  "key" : ""
                },
                "additionalData" : {
                  "key" : ""
                },
                "adegcambio" : 5.533258397034986,
                "rowversion" : ""
              } ],
              "idmediaCg99" : 8.969578798196912,
              "codice" : "codice",
              "indCertoincerto" : 7,
              "cambiofisso" : 0.10263654006109402,
              "descr" : "descr",
              "flgValuem" : 4.652396432933246,
              "indValuem" : 3.0576100241049344,
              "indSepmigl" : 3.0205796992916243,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              }
            },
            "descr" : "descr",
            "flgIban" : 3,
            "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
            "codIso" : "codIso",
            "a3iso3166" : "a3iso3166",
            "indTipostato" : 7.058770351582356,
            "a2iso3166" : "a2iso3166",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "datacee" : "2000-01-23T04:56:07.000+00:00",
            "flgSepa" : 7
          },
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 1,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 4,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 7.964879197514727,
        "indDatarif" : 6.568304668801491,
        "rowversion" : ""
      } ],
      "codPag" : "codPag",
      "desPagAnal" : "desPagAnal",
      "flgDisgg" : 4.13177941962639,
      "flgPrefpass" : 0,
      "idExtendedAttributeSubEntity" : 8,
      "flgPrefatt" : 4,
      "flgStornoiva" : 7.701777079007398,
      "descPag" : "descPag",
      "extensionData" : [ {
        "value" : "",
        "key" : "key"
      }, {
        "value" : "",
        "key" : "key"
      } ],
      "scpermer2" : 2.1518888575299036,
      "pluginData" : {
        "key" : ""
      },
      "id" : 2,
      "scpercas" : 6.936499209818381,
      "scpermer1" : 4.035133329541982,
      "additionalData" : {
        "key" : ""
      },
      "scpercart26" : 4.403697036782718,
      "idExtendedAttributeEntity" : 3,
      "rowversion" : "",
      "scart26" : 0.05189710095898081
    },
    "progrEf08" : 3.0576100241049344,
    "tipoCf" : 7.04836565559697,
    "pluginData" : {
      "key" : ""
    },
    "cliFor" : 3.353193347011243,
    "additionalData" : {
      "key" : ""
    },
    "ggScadFix" : 0.10263654006109402,
    "idExtendedAttributeEntity" : 3,
    "idExtendedAttributeSubEntity" : 4,
    "flgCointestati" : 7.058770351582356,
    "gruppoCg10" : 4.652396432933246,
    "currencyCO" : {
      "sigla" : "sigla",
      "dataattuem" : "2000-01-23T04:56:07.000+00:00",
      "numdec" : 7.04836565559697,
      "exchangeRateCO" : [ {
        "cambio" : 4.078845849666752,
        "anno" : 3.2588565619047607,
        "idmediaCg99" : 6.628464275087742,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 4,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 0.2025324113236393,
        "mese" : 1.041444916118296,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 5.533258397034986,
        "rowversion" : ""
      }, {
        "cambio" : 4.078845849666752,
        "anno" : 3.2588565619047607,
        "idmediaCg99" : 6.628464275087742,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 4,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 0.2025324113236393,
        "mese" : 1.041444916118296,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 5.533258397034986,
        "rowversion" : ""
      } ],
      "idmediaCg99" : 8.969578798196912,
      "codice" : "codice",
      "indCertoincerto" : 7,
      "cambiofisso" : 0.10263654006109402,
      "descr" : "descr",
      "flgValuem" : 4.652396432933246,
      "indValuem" : 3.0576100241049344,
      "indSepmigl" : 3.0205796992916243,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "vatCodeCO" : {
      "flgSospimp" : 1.633699845078339,
      "indNatura" : 8,
      "flgAgri" : 6.090696483578148,
      "tipologia" : 4.778706604314481,
      "percindet" : 6.389489858092311,
      "mossperc" : 5.305668385940959,
      "natureEsCO" : {
        "descr" : "descr",
        "codice" : "codice",
        "datainival" : "2000-01-23T04:56:07.000+00:00",
        "natureAssCO" : [ null, null ],
        "datafineval" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "id" : 3,
        "additionalData" : {
          "key" : ""
        },
        "rowversion" : ""
      },
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "verslynfa" : "verslynfa",
      "idExtendedAttributeEntity" : 0,
      "annotazioni" : "annotazioni",
      "rowVersion" : "",
      "indNatassoswCg2n" : 7,
      "perciva" : 5.201737367852583,
      "percforf" : 6.541917087228235,
      "codice" : "codice",
      "impostamonofasersm" : 4.851239691941878,
      "codiceOss" : "codiceOss",
      "extensionData" : [ null, null ],
      "stdcodivarifCg28" : "stdcodivarifCg28",
      "flgMossgest" : 3,
      "flgAutoue" : 1.2880645475702646,
      "flgIndet" : 2.9790233918904585,
      "codPlafond" : 7.239590766928185,
      "note" : "note",
      "flgAssport398" : 6.677419970877656,
      "flgMossrid" : 0,
      "indStaper" : 3.474156394106027,
      "flgAllclifor" : 9.852147203726787,
      "codiceagr" : "codiceagr",
      "flgImpostadibollo" : 4,
      "flgCorrVent" : 1.822577900073098,
      "aliqivavent" : 2.6736395633233356,
      "flgNotvar" : 7.224413148959403,
      "percmonofasersm" : 6.614319261836819,
      "idprov" : 0.42286244411048224,
      "idExtendedAttributeSubEntity" : 3,
      "natureAssCO" : {
        "descr" : "descr",
        "idCg2m" : 3,
        "idassosw" : 5,
        "codice" : "codice",
        "datainival" : "2000-01-23T04:56:07.000+00:00",
        "datafineval" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "rowversion" : ""
      },
      "flgMonofasersm" : 2.6249013358703053,
      "mosscodCg07" : 6.711221582652969,
      "descrizione" : "descrizione",
      "flgEscludiblacklist" : 5.083590215108117,
      "flgIvaedit" : 9.693372334146686,
      "indtipopart" : 6.008900790410507
    },
    "extensionData" : [ null, null ],
    "classificationData" : {
      "cliforCg44" : 0.2025324113236393,
      "indarrinfat" : 4.573936264232251,
      "indprefstdoc" : 5.299143560275359,
      "notes" : [ {
        "cliforCg44" : 0.30134145536422907,
        "note" : "note",
        "dittaCg18" : 0.4867146239815201,
        "tipocfCg44" : 7.88722683998926,
        "idmediaCg99" : 9.456612101333725,
        "destiponote" : "destiponote",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "prog" : 9.721723570087065
      }, {
        "cliforCg44" : 0.30134145536422907,
        "note" : "note",
        "dittaCg18" : 0.4867146239815201,
        "tipocfCg44" : 7.88722683998926,
        "idmediaCg99" : 9.456612101333725,
        "destiponote" : "destiponote",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "prog" : 9.721723570087065
      } ],
      "sc2percor" : 0.4768402382624515,
      "codrifnum" : 6.628464275087742,
      "grouping1CO" : {
        "dittaCg18" : 3.209082285545927,
        "codRaggrcf1" : "codRaggrcf1",
        "descraggrcf1" : "descraggrcf1",
        "idprov" : 2,
        "idmediaCg99" : 8.262795412896967,
        "tipocf" : 9.146339979307802,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "language" : {
        "iso639" : "iso639",
        "idmediaCg99" : 2.9679475177256287,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "descrlingua" : "descrlingua",
        "codLingua" : "codLingua",
        "siglalingua" : "siglalingua"
      },
      "irs1099" : "irs1099",
      "ggcons" : 2.9409642974827896,
      "flgesclspepor" : 0.5199002018724985,
      "grouping3CO" : {
        "codRaggrcf3" : "codRaggrcf3",
        "descraggrcf3" : "descraggrcf3",
        "dittaCg18" : 8.910869026866926,
        "idprov" : 6,
        "idmediaCg99" : 2.058822123984536,
        "tipocf" : 0.8411762798681321,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "datiAccompagnamento" : {
        "cliforCg44" : 4.8789878742268815,
        "vett1Mg14" : "vett1Mg14",
        "imballoMg95" : "imballoMg95",
        "tipocfCg44" : 1.3949519358941398,
        "idmediaCg99" : 9.806951670467935,
        "portoMg91" : "portoMg91",
        "vett2Mg14" : "vett2Mg14",
        "aspettoMg99" : "aspettoMg99",
        "dittaCg18" : 6.966044574347761,
        "spedizMg15" : "spedizMg15",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "tipospedMg93" : "tipospedMg93"
      },
      "tipoclxdoc" : 0.4833312865174044,
      "priceListSalePurchase" : {
        "desclist" : "desclist",
        "numlist" : 4.637509675190766,
        "valutaCg08" : "valutaCg08",
        "dittaCg18" : 6.918231485891953,
        "flgVenacq" : 0.11859130807119977,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "coddocumMg3g" : "coddocumMg3g",
      "indtestof2" : "0",
      "impdaarrot" : 6.623518433804886,
      "indtestof1" : 3.7814124730767915,
      "pluginData" : {
        "key" : ""
      },
      "flgrottsingdoc" : 8.251625748923757,
      "scimpcor" : 3.804112695731078,
      "additionalData" : {
        "key" : ""
      },
      "dataultord" : "2000-01-23T04:56:07.000+00:00",
      "flgTaxliable" : 0,
      "flgspbol" : 4.459605034958679,
      "magpercor" : 5.877124706116695,
      "taxexemptionno" : "taxexemptionno",
      "scaglspbanc" : 2.380090174313445,
      "macroCategoryCO" : {
        "descrmacrocat" : "descrmacrocat",
        "categorie" : [ null, null ],
        "dittaCg18" : 6.749525837406151,
        "tipocf" : 4.943637496515336,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "macrocat" : "macrocat"
      },
      "datacreaz" : "2000-01-23T04:56:07.000+00:00",
      "flgspeinc" : 3.901545264248647,
      "codrifalf" : "codrifalf",
      "sc1percor" : 7.835035282970782,
      "listmag" : 3.111202833403195,
      "categoryCO" : {
        "macrocatMg10" : "macrocatMg10",
        "tipocfMg10" : 6.173804034172511,
        "descrcat" : "descrcat",
        "dittaCg18" : 2.535258963197524,
        "categ" : "categ",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "dittaCg18" : 4.258773108174356,
      "indspesecum" : 8.37823741034869,
      "magimpcor" : 9.897492629215506,
      "datadismis" : "2000-01-23T04:56:07.000+00:00",
      "dataultdoc" : "2000-01-23T04:56:07.000+00:00",
      "macAreaCO" : {
        "descrmacroar" : "descrmacroar",
        "dittaCg18" : 5.747795090145878,
        "idprov" : 0,
        "tipocf" : 7.3842318535314,
        "areas" : [ null, null ],
        "pluginData" : {
          "key" : ""
        },
        "codiceMacroarea" : "codiceMacroarea",
        "additionalData" : {
          "key" : ""
        }
      },
      "indclibloc" : 9.254183946267839,
      "fixedText1" : {
        "descr" : "descr",
        "datainizioval" : "2000-01-23T04:56:07.000+00:00",
        "indTipoevas" : 4.4935252719377825,
        "idprov" : 1,
        "idmediaCg99" : 9.402167524121316,
        "codice" : "codice",
        "datafineval" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "testo" : "testo"
      },
      "flgart62ctr" : 0,
      "imparrotprec" : 8.28965939814297,
      "areaCO" : {
        "codiceAreaMG" : "codiceAreaMG",
        "macroareaMg07" : "macroareaMg07",
        "dittaCg18" : 0.35262192099236644,
        "zone" : [ {
          "areaMg08" : "areaMg08",
          "macroareaMg08" : "macroareaMg08",
          "dittaCg18" : 2.7977867356748476,
          "idprov" : 9,
          "descrzona" : "descrzona",
          "tipocfMg08" : 0.58919091925136,
          "pluginData" : {
            "key" : ""
          },
          "codiceZona" : "codiceZona",
          "additionalData" : {
            "key" : ""
          }
        }, {
          "areaMg08" : "areaMg08",
          "macroareaMg08" : "macroareaMg08",
          "dittaCg18" : 2.7977867356748476,
          "idprov" : 9,
          "descrzona" : "descrzona",
          "tipocfMg08" : 0.58919091925136,
          "pluginData" : {
            "key" : ""
          },
          "codiceZona" : "codiceZona",
          "additionalData" : {
            "key" : ""
          }
        } ],
        "idprov" : 7,
        "tipocfMg07" : 4.332304821875894,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "descrarea" : "descrarea"
      },
      "dataultvar" : "2000-01-23T04:56:07.000+00:00",
      "tipocfCg44" : 4.518309517874243,
      "fidofactoring" : 4.678947989005849,
      "idmediaCg99" : 1.7325933120207193,
      "datarischio" : "2000-01-23T04:56:07.000+00:00",
      "indstscadest" : 7.606863723092579,
      "grouping2CO" : {
        "codRaggrcf2" : "codRaggrcf2",
        "dittaCg18" : 4.010300976654761,
        "idprov" : 6,
        "descraggrcf2" : "descraggrcf2",
        "idmediaCg99" : 8.276461147928103,
        "tipocf" : 4.141296055235948,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "indclifat" : 1.8268702177058116,
      "fixedExp1" : {
        "flgRicfatriep" : 5.6644160867523485,
        "flgVentstat" : 4.372688051310086,
        "flgIvaincl" : 1,
        "indTipoevas" : 9.785002165136461,
        "idmediaCg99" : 5.7911894223693885,
        "codice" : "codice",
        "indTotspese" : 7.92839742024475,
        "indRotturacorpo" : 1.0639121808530916,
        "indTipospesa" : 7.3718573971919445,
        "indGesintra" : 3.8008573585058016,
        "descr" : "descr",
        "indFatriep" : 5.974942028545841,
        "indTipotot" : 7.726998920545485,
        "indTipoaliq" : 3.2841216543560217,
        "pluginData" : {
          "key" : ""
        },
        "flgVentamm" : 1.5970080735609526,
        "additionalData" : {
          "key" : ""
        },
        "flgOramin" : 3.812761638325517
      },
      "scperpiede" : 8.675064425986758,
      "rischio" : {
        "indSegnalazionecorpo" : 7.464202015255506,
        "flgAttivo" : 4.1661834558007,
        "flgScadereins" : 2.4669941706755685,
        "flgOrdini" : 8.250639315618633,
        "flgCalcmovprev" : 5.573385265048522,
        "flgSaldocon" : 7.273019311111276,
        "pluginData" : {
          "key" : ""
        },
        "flgCalcmovdacons" : 1.9626702727164813,
        "additionalData" : {
          "key" : ""
        },
        "flgScadutoins" : 0.4008378390304357,
        "mesiricscadenze" : 6.642953999458534,
        "flgSelclifortrasf" : 4.432841187680573,
        "indElabscadinsol" : 9.721046668148785,
        "flgScadutonoins" : 2.5524281586707875,
        "codice" : "codice",
        "flgEffettiscaduti" : 3.0269458094096646,
        "flgScaderenoins" : 8.782449469456207,
        "flgCalceffcons" : 2.026856458177285,
        "flgCalcmovcons" : 3.8156682252305574,
        "descrizione" : "descrizione",
        "flgCalceffprev" : 5.296102445648278,
        "dittaCg18" : 2.0981949483881577,
        "flgCalceffdacons" : 3.196820582978078,
        "indAttivatrasf" : 5.726375546151009,
        "mesiricordini" : 6.370609851066415,
        "flgSolobusinesriskattivo" : 3.5117904067536143,
        "indProvenienzafido" : 2.922265432447957,
        "mesiricdocdafatt" : 7.129168897240568
      },
      "dataultfat" : "2000-01-23T04:56:07.000+00:00",
      "notebloc" : "notebloc",
      "areaMGnielsenMg0e" : "areaMGnielsenMg0e",
      "indgesfido" : 8.761432466225475,
      "flgprzcamp" : 5.507386964179881,
      "inddesdocest" : 3.502657762086401,
      "flgdaticlfat" : 9.702963800023566,
      "indgiorni" : 0.4182561061793122,
      "fidoaziendale" : 1.041444916118296,
      "fidolivello1" : 7.260521264802104,
      "indrottcig" : 5.312489704336296,
      "fidolivello2" : 9.132027271330688,
      "raggruppamentoPrevalente" : {
        "descragg" : "descragg",
        "cliforCg44" : 7.390706075830692,
        "dittaCg18" : 1.0502890910539986,
        "idmediaCg99" : 6.176386745020588,
        "codRag" : "codRag",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "indarrl96" : 8.863729185622827,
      "dataultcalsp" : "2000-01-23T04:56:07.000+00:00",
      "flgrottcig" : 6.073898085781152,
      "coddestprev" : "coddestprev",
      "codprevragb" : "codprevragb",
      "art62txt" : "art62txt",
      "flgEstrpayline" : 7.933506881737151,
      "indFattper" : 9.183123594773994,
      "flgqualita" : 4.86315908102884,
      "datablocco" : "2000-01-23T04:56:07.000+00:00",
      "priceListWithMultipleItems" : {
        "descr" : "descr",
        "dittaCg18" : 0.36062689002149373,
        "codice" : "codice",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "subCategoryCO" : {
        "descrsottocat" : "descrsottocat",
        "tipocfMg11" : 8.768153453040833,
        "dittaCg18" : 9.505836306729838,
        "sottcat" : "sottcat",
        "categMg11" : "categMg11",
        "macrocatMg11" : "macrocatMg11",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "lastchange" : "2000-01-23T04:56:07.000+00:00",
      "sc3percor" : 3.1497903714250555
    },
    "datavaliva" : "2000-01-23T04:56:07.000+00:00",
    "dittaCg18" : 3.0937452626664474,
    "flgart62" : 7,
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "indElenchiMov3000" : 3,
    "lastchange" : "2000-01-23T04:56:07.000+00:00"
  },
  "idExtendedAttributeEntity" : 6,
  "codbloccoMg25" : "codbloccoMg25",
  "cambio" : 2.3021358869347655,
  "descraggcont" : "descraggcont",
  "idcontCo02" : 1.4894159098541704,
  "indconvclifat" : 7,
  "storageWH" : {
    "locationWH" : [ {
      "maxpeso" : 2.0561655911354517,
      "profondita" : 2.9691650858515217,
      "umdimens" : "umdimens",
      "codDepMg58" : "codDepMg58",
      "descubicaz" : "descubicaz",
      "coordin1" : "coordin1",
      "umpeso" : "umpeso",
      "indTipoubicaz" : 0.391063602337155,
      "dittaCg18" : 2.4977456046390434,
      "larghezza" : 1.2794383049745206,
      "codClassestoc" : 9.629537564416708,
      "pluginData" : {
        "key" : ""
      },
      "codPriorriemp" : 4.917163120387481,
      "additionalData" : {
        "key" : ""
      },
      "ubicaz" : "ubicaz",
      "coordin3" : "coordin3",
      "altezza" : 5.3152834658745505,
      "coordin2" : "coordin2"
    }, {
      "maxpeso" : 2.0561655911354517,
      "profondita" : 2.9691650858515217,
      "umdimens" : "umdimens",
      "codDepMg58" : "codDepMg58",
      "descubicaz" : "descubicaz",
      "coordin1" : "coordin1",
      "umpeso" : "umpeso",
      "indTipoubicaz" : 0.391063602337155,
      "dittaCg18" : 2.4977456046390434,
      "larghezza" : 1.2794383049745206,
      "codClassestoc" : 9.629537564416708,
      "pluginData" : {
        "key" : ""
      },
      "codPriorriemp" : 4.917163120387481,
      "additionalData" : {
        "key" : ""
      },
      "ubicaz" : "ubicaz",
      "coordin3" : "coordin3",
      "altezza" : 5.3152834658745505,
      "coordin2" : "coordin2"
    } ],
    "indIdep" : "indIdep",
    "datacess" : "2000-01-23T04:56:07.000+00:00",
    "capdep" : "capdep",
    "flgDepprinc" : 8.50835276411088,
    "codDep" : "codDep",
    "indEmail" : "indEmail",
    "dataatt" : "2000-01-23T04:56:07.000+00:00",
    "provdep" : "provdep",
    "dittaCg18" : 3.3182952910080674,
    "telnumdep" : "telnumdep",
    "respdep" : "respdep",
    "indInterest" : 9.551762125042277,
    "locdep" : "locdep",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "faxnumdep" : "faxnumdep",
    "descrdep" : "descrdep"
  },
  "tiponumautof" : 3.5571952270680973,
  "documentoDatiAccompagnamentoMG" : {
    "targavet1" : "targavet1",
    "descaspetto" : "descaspetto",
    "codPortoMg91" : "codPortoMg91",
    "codCautraspMg13" : "codCautraspMg13",
    "targavet2" : "targavet2",
    "codImballoMg95" : "codImballoMg95",
    "vettore2Mg14" : "vettore2Mg14",
    "dataritvet1" : "2000-01-23T04:56:07.000+00:00",
    "descrlettint" : "descrlettint",
    "orainiziotrasp" : 5.944895607614016,
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "oraritvet1" : 6.704019297950036,
    "additionalData" : {
      "key" : ""
    },
    "oraritvet2" : 3.353193347011243,
    "codTipospedMg93" : "codTipospedMg93",
    "vettore1Mg14" : "vettore1Mg14",
    "umvolume" : "umvolume",
    "pesolordo" : 3.0937452626664474,
    "dataritvet2" : "2000-01-23T04:56:07.000+00:00",
    "targarim1" : "targarim1",
    "volume" : 7.058770351582356,
    "targarim2" : "targarim2",
    "totcolli" : 0.8851374739011653,
    "umpeso" : "umpeso",
    "dittaCg18" : 6.878052220127876,
    "spedizMg15" : "spedizMg15",
    "datainiztrasp" : "2000-01-23T04:56:07.000+00:00",
    "pesonetto" : 7.143538047012306,
    "codAspettoMg99" : "codAspettoMg99"
  },
  "numdoc" : 9.965781217890562,
  "documentMaster" : {
    "indTipoop" : 6.778324963048013,
    "dittaCg18" : 2.8841621266687802,
    "gruppocre" : "gruppocre",
    "utentevar" : "utentevar",
    "utentecre" : "utentecre",
    "gruppovar" : "gruppovar",
    "numreg" : "numreg",
    "datavar" : "2000-01-23T04:56:07.000+00:00",
    "datacre" : "2000-01-23T04:56:07.000+00:00",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "descnote1" : "descnote1"
  },
  "cliForDest" : "cliForDest",
  "listmag" : 4.965218492984954,
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ],
  "abbuono" : 5.962133916683182,
  "datainiziopag" : "2000-01-23T04:56:07.000+00:00",
  "datareg" : "2000-01-23T04:56:07.000+00:00",
  "testataPersonalizzata" : [ {
    "idmediaCg99" : 1.17662993142012,
    "datapers1" : "2000-01-23T04:56:07.000+00:00",
    "datapers2" : "2000-01-23T04:56:07.000+00:00",
    "alfpers9" : "alfpers9",
    "datapers3" : "2000-01-23T04:56:07.000+00:00",
    "datapers4" : "2000-01-23T04:56:07.000+00:00",
    "datapers5" : "2000-01-23T04:56:07.000+00:00",
    "datapers6" : "2000-01-23T04:56:07.000+00:00",
    "alfpers4" : "alfpers4",
    "indPers1" : 6.434975173600648,
    "alfpers3" : "alfpers3",
    "indPers2" : 2.729215612801924,
    "alfpers2" : "alfpers2",
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "alfpers1" : "alfpers1",
    "additionalData" : {
      "key" : ""
    },
    "alfpers8" : "alfpers8",
    "alfpers7" : "alfpers7",
    "alfpers6" : "alfpers6",
    "alfpers5" : "alfpers5",
    "numpers11" : 8.206187911681816,
    "numpers1" : 9.774932085941137,
    "numpers12" : 3.4925370028432345,
    "numpers2" : 3.4360986237728,
    "numpers3" : 4.786929569572925,
    "numpers10" : 5.328605645442888,
    "flgPers2" : 3.472023815393955,
    "numpers8" : 2.551900688634915,
    "flgPers1" : 3.3841591171956145,
    "numpers9" : 8.128958126729998,
    "numpers4" : 8.342721204157684,
    "numpers5" : 3.6300678941289712,
    "flgPers4" : 8.67132933794674,
    "numpers6" : 2.1305968583238744,
    "prog" : 8.897844438448299,
    "flgPers3" : 5.22975523929469,
    "numpers7" : 7.68210344846877,
    "dittaCg18" : 5.2388109661003055,
    "alfpers10" : "alfpers10",
    "alfpers11" : "alfpers11",
    "alfpers12" : "alfpers12"
  }, {
    "idmediaCg99" : 1.17662993142012,
    "datapers1" : "2000-01-23T04:56:07.000+00:00",
    "datapers2" : "2000-01-23T04:56:07.000+00:00",
    "alfpers9" : "alfpers9",
    "datapers3" : "2000-01-23T04:56:07.000+00:00",
    "datapers4" : "2000-01-23T04:56:07.000+00:00",
    "datapers5" : "2000-01-23T04:56:07.000+00:00",
    "datapers6" : "2000-01-23T04:56:07.000+00:00",
    "alfpers4" : "alfpers4",
    "indPers1" : 6.434975173600648,
    "alfpers3" : "alfpers3",
    "indPers2" : 2.729215612801924,
    "alfpers2" : "alfpers2",
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "alfpers1" : "alfpers1",
    "additionalData" : {
      "key" : ""
    },
    "alfpers8" : "alfpers8",
    "alfpers7" : "alfpers7",
    "alfpers6" : "alfpers6",
    "alfpers5" : "alfpers5",
    "numpers11" : 8.206187911681816,
    "numpers1" : 9.774932085941137,
    "numpers12" : 3.4925370028432345,
    "numpers2" : 3.4360986237728,
    "numpers3" : 4.786929569572925,
    "numpers10" : 5.328605645442888,
    "flgPers2" : 3.472023815393955,
    "numpers8" : 2.551900688634915,
    "flgPers1" : 3.3841591171956145,
    "numpers9" : 8.128958126729998,
    "numpers4" : 8.342721204157684,
    "numpers5" : 3.6300678941289712,
    "flgPers4" : 8.67132933794674,
    "numpers6" : 2.1305968583238744,
    "prog" : 8.897844438448299,
    "flgPers3" : 5.22975523929469,
    "numpers7" : 7.68210344846877,
    "dittaCg18" : 5.2388109661003055,
    "alfpers10" : "alfpers10",
    "alfpers11" : "alfpers11",
    "alfpers12" : "alfpers12"
  } ],
  "dataplafond" : "2000-01-23T04:56:07.000+00:00",
  "stipodoc" : 8.762042012749001,
  "headingReferenceDocumentMG" : [ {
    "flgNsdocbis" : 9.254183946267839,
    "notevsdoc" : "notevsdoc",
    "rifnsdoc" : "rifnsdoc",
    "datansdoc" : "2000-01-23T04:56:07.000+00:00",
    "seznsdoc" : "seznsdoc",
    "indStipodoc" : 1.8268702177058116,
    "datansconf" : "2000-01-23T04:56:07.000+00:00",
    "datavsconf" : "2000-01-23T04:56:07.000+00:00",
    "datavsdoc" : "2000-01-23T04:56:07.000+00:00",
    "fedatadoc" : "2000-01-23T04:56:07.000+00:00",
    "numnsdoc" : 9.183123594773994,
    "dittaCg18" : 8.863729185622827,
    "feiddoc" : "feiddoc",
    "feidsoggetto" : "feidsoggetto",
    "indTipodoc" : 3.502657762086401,
    "numregCo99" : "numregCo99",
    "numvsdoc" : "numvsdoc",
    "pluginData" : {
      "key" : ""
    },
    "notensdoc" : "notensdoc",
    "progRif" : 8.761432466225475,
    "rifvsdoc" : "rifvsdoc",
    "additionalData" : {
      "key" : ""
    }
  }, {
    "flgNsdocbis" : 9.254183946267839,
    "notevsdoc" : "notevsdoc",
    "rifnsdoc" : "rifnsdoc",
    "datansdoc" : "2000-01-23T04:56:07.000+00:00",
    "seznsdoc" : "seznsdoc",
    "indStipodoc" : 1.8268702177058116,
    "datansconf" : "2000-01-23T04:56:07.000+00:00",
    "datavsconf" : "2000-01-23T04:56:07.000+00:00",
    "datavsdoc" : "2000-01-23T04:56:07.000+00:00",
    "fedatadoc" : "2000-01-23T04:56:07.000+00:00",
    "numnsdoc" : 9.183123594773994,
    "dittaCg18" : 8.863729185622827,
    "feiddoc" : "feiddoc",
    "feidsoggetto" : "feidsoggetto",
    "indTipodoc" : 3.502657762086401,
    "numregCo99" : "numregCo99",
    "numvsdoc" : "numvsdoc",
    "pluginData" : {
      "key" : ""
    },
    "notensdoc" : "notensdoc",
    "progRif" : 8.761432466225475,
    "rifvsdoc" : "rifvsdoc",
    "additionalData" : {
      "key" : ""
    }
  } ],
  "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
  "causmagMg51" : 7.061401241503109,
  "cup" : "cup",
  "cig" : "cig",
  "documentoTestataAgentiMG" : [ {
    "idagenteMg17" : 4,
    "dittaCg18" : 6.519180951018382,
    "perprov" : 3.0205796992916243,
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "indRegprov" : 7.740351818741173,
    "additionalData" : {
      "key" : ""
    },
    "flgAgerifer" : 0.10263654006109402,
    "codiceAgente" : "codiceAgente",
    "indModcalc" : 8.969578798196912
  }, {
    "idagenteMg17" : 4,
    "dittaCg18" : 6.519180951018382,
    "perprov" : 3.0205796992916243,
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "indRegprov" : 7.740351818741173,
    "additionalData" : {
      "key" : ""
    },
    "flgAgerifer" : 0.10263654006109402,
    "codiceAgente" : "codiceAgente",
    "indModcalc" : 8.969578798196912
  } ],
  "cauprestCg15" : "cauprestCg15",
  "esclusioneAgentiMultipli" : 0,
  "idmediaCg99" : 6.84685269835264,
  "acconto" : 1.4658129805029452,
  "flgSpincas" : 1,
  "officeCO" : {
    "indIrizzo" : "indIrizzo",
    "idmediaCg99" : 6.720288821326667,
    "codice" : 7.766860781935265,
    "indDimcentrocomm" : 5.304373278797373,
    "cap" : "cap",
    "dittaCg18" : 1.6056289151258096,
    "progRea" : 8.708394192403432,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "prov" : "prov",
    "numerorea" : "numerorea",
    "citta" : "citta",
    "rowversion" : ""
  },
  "datadoc" : "2000-01-23T04:56:07.000+00:00",
  "codpagCg62" : "codpagCg62",
  "flgDocstamp" : 7,
  "documentoTestataProgettiMG" : {
    "codDipPd06" : "codDipPd06",
    "codProgcol" : "codProgcol",
    "causmgoMgfo" : 3,
    "codProgetto" : "codProgetto",
    "codSprogetto" : 3.2588565619047607,
    "dittaCg18" : 4.078845849666752,
    "codCommessa" : "codCommessa",
    "nodorifcolPd0c" : "nodorifcolPd0c",
    "codScommessa" : 7.04836565559697,
    "pluginData" : {
      "key" : ""
    },
    "nodorifPd0c" : "nodorifPd0c",
    "additionalData" : {
      "key" : ""
    },
    "codSprogcol" : 5.533258397034986
  },
  "testataOrdine" : {
    "dataconsint" : "2000-01-23T04:56:07.000+00:00",
    "flgNonpiuev" : 6,
    "flgEvastot" : 6,
    "priorita" : 4.778706604314481,
    "flgNoevasparz" : 5,
    "ggtollercons" : 6.614319261836819,
    "flgRicpreev" : 5,
    "datacons" : "2000-01-23T04:56:07.000+00:00",
    "dittaCg18" : 3.474156394106027,
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "dataconsorig" : "2000-01-23T04:56:07.000+00:00",
    "flgNonann" : 6,
    "additionalData" : {
      "key" : ""
    },
    "flgConfrit" : 6,
    "tipoordine" : 3.0237995775442372,
    "tipoinoltro" : 0.7449262586083982
  },
  "progrEf08" : 9.369310271410669,
  "sezdoc" : "sezdoc",
  "numautof" : 5.025004791520295,
  "tipodoc" : 9.018348186070783,
  "datacambio" : "2000-01-23T04:56:07.000+00:00",
  "stagioneMg5t" : 6,
  "flgClifat" : 4,
  "idExtendedAttributeSubEntity" : 1,
  "documentoTestataRateiMG" : {
    "dadatacomp" : "2000-01-23T04:56:07.000+00:00",
    "flgDaav" : 8.28965939814297,
    "dataregesinc" : "2000-01-23T04:56:07.000+00:00",
    "indTipocomp" : 4.573936264232251,
    "dittaCg18" : 1.7325933120207193,
    "flgDisatcoge" : 6.623518433804886,
    "contopar" : "contopar",
    "datacompivaman" : "2000-01-23T04:56:07.000+00:00",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "adatacomp" : "2000-01-23T04:56:07.000+00:00",
    "dataregesprec" : "2000-01-23T04:56:07.000+00:00"
  },
  "codcabCg13" : 3.616076749251911,
  "documentoTestataProvvigioniMG" : [ {
    "idagenteMg17" : 9,
    "flgStenas" : 0.8774076871421566,
    "flgProvsosp" : 1.041444916118296,
    "idmediaCg99" : 0.5199002018724985,
    "imporprov" : 4.86315908102884,
    "imponprov" : 7.933506881737151,
    "imponprovVal" : 5.507386964179881,
    "trimestrePa23" : 2.9409642974827896,
    "provmedia" : 0.43431398824148815,
    "flgPers" : 4.258773108174356,
    "imporprovVal" : 6.073898085781152,
    "noteprov" : "noteprov",
    "flgSt" : 7.260521264802104,
    "flgStarcred" : 9.132027271330688,
    "indTipomov" : 3.901545264248647,
    "flgProvvar" : 4.678947989005849,
    "dittaCg18" : 6.628464275087742,
    "annoPa23" : 0.2025324113236393,
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "indSt" : 4.459605034958679,
    "additionalData" : {
      "key" : ""
    },
    "codiceAgente" : "codiceAgente",
    "indPers" : 8.251625748923757
  }, {
    "idagenteMg17" : 9,
    "flgStenas" : 0.8774076871421566,
    "flgProvsosp" : 1.041444916118296,
    "idmediaCg99" : 0.5199002018724985,
    "imporprov" : 4.86315908102884,
    "imponprov" : 7.933506881737151,
    "imponprovVal" : 5.507386964179881,
    "trimestrePa23" : 2.9409642974827896,
    "provmedia" : 0.43431398824148815,
    "flgPers" : 4.258773108174356,
    "imporprovVal" : 6.073898085781152,
    "noteprov" : "noteprov",
    "flgSt" : 7.260521264802104,
    "flgStarcred" : 9.132027271330688,
    "indTipomov" : 3.901545264248647,
    "flgProvvar" : 4.678947989005849,
    "dittaCg18" : 6.628464275087742,
    "annoPa23" : 0.2025324113236393,
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "indSt" : 4.459605034958679,
    "additionalData" : {
      "key" : ""
    },
    "codiceAgente" : "codiceAgente",
    "indPers" : 8.251625748923757
  } ],
  "flgLockOnDocExist" : true,
  "lineaFa05" : "lineaFa05",
  "notedocum" : "notedocum",
  "numReg" : "000000000000",
  "righe" : [ {
    "flgContribinteg" : 7,
    "statoAttualeCO" : {
      "statiDisponibili" : [ null, null ],
      "statoCorrente" : {
        "indTipoStato" : 8,
        "idStato" : 2,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "seq" : 2
      },
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "prezzo2iva" : 9.806951670467935,
    "documentoRigaProgettiMG" : {
      "codDipPd06" : "codDipPd06",
      "attivitaPd0d" : "attivitaPd0d",
      "codProgcol" : "codProgcol",
      "idattrezzaturaVc02" : 6,
      "idartepuVc02" : 2,
      "nodoPd0c" : "nodoPd0c",
      "idmedia" : 0.8411762798681321,
      "codProgetto" : "codProgetto",
      "codSprogetto" : 4.141296055235948,
      "dittaCg18" : 8.910869026866926,
      "codCommessa" : "codCommessa",
      "nodorifcolPd0c" : "nodorifcolPd0c",
      "codScommessa" : 8.276461147928103,
      "spesaPd64" : "spesaPd64",
      "pluginData" : {
        "key" : ""
      },
      "nodorifPd0c" : "nodorifPd0c",
      "additionalData" : {
        "key" : ""
      },
      "codSprogcol" : 6.458262756685686
    },
    "cpmerceCg24" : "cpmerceCg24",
    "profondita" : 1.3949519358941398,
    "prezzo2" : 6.966044574347761,
    "ditta" : 3.111202833403195,
    "prezzo1" : 6.173804034172511,
    "um1" : "um1",
    "indtiporiga" : 7,
    "documentoRigaCOINMG" : {
      "pdcvdsorigPc01" : 4.010300976654761,
      "pdcdestPc01" : 8.262795412896967,
      "vdsorigPc03" : "vdsorigPc03",
      "contoorigPc03" : "contoorigPc03",
      "idmediaCg99" : 3.209082285545927,
      "contodestPc03" : "contodestPc03",
      "flgEsclriga" : 4.4935252719377825,
      "vdsdestPc03" : "vdsdestPc03",
      "dittaCg18" : 1.7045651386993,
      "pdcorigPc01" : 2.9805393113464476,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "pdcvdsdestPc01" : 9.146339979307802
    },
    "pluginData" : {
      "key" : ""
    },
    "um2" : "um2",
    "additionalData" : {
      "key" : ""
    },
    "barcode" : "barcode",
    "fatconv" : 9.897492629215506,
    "magimp" : 4.332304821875894,
    "coddepcolMg58" : "coddepcolMg58",
    "pesol" : 0.58919091925136,
    "prezzo1iva" : 4.8789878742268815,
    "peson" : 2.535258963197524,
    "flgContribprev" : 0,
    "importo" : 3.804112695731078,
    "pzconf" : 1.5970080735609526,
    "flgPriceDiscForce" : true,
    "flgRitenas" : 2,
    "progPadre" : 1.2555055362323109,
    "testoFissoMG" : {
      "descr" : "descr",
      "datainizioval" : "2000-01-23T04:56:07.000+00:00",
      "indTipoevas" : 4.4935252719377825,
      "idprov" : 1,
      "idmediaCg99" : 9.402167524121316,
      "codice" : "codice",
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "testo" : "testo"
    },
    "codescl4Mg82" : "codescl4Mg82",
    "codartMg66" : "codartMg66",
    "rigaIntra" : {
      "meserif" : 5.829097284708605,
      "modincassoIn04" : "modincassoIn04",
      "paesepagCg07" : 8.071139232091417,
      "percadegvalstat" : 8.257837395465918,
      "fatconvumsuppl" : 2.831445253698411,
      "codiceCg72" : "codiceCg72",
      "unsuppl" : 9.878259040728768,
      "paeseorigCg07" : 1.2786903972794905,
      "provdest" : "provdest",
      "provorig" : "provorig",
      "progRiga" : 5.547564904556697,
      "indTipoCg72" : 5.499986845135928,
      "annorif" : 2.924533207692744,
      "dittaCg18" : 8.238101405568635,
      "moderogazioneIn03" : "moderogazioneIn03",
      "paesedestCg07" : 0.7242789830362995,
      "massanetta" : 8.569658089905484,
      "paeseprovCg07" : 2.7107020326702136,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "flgEsclintra" : 6.345503614942988
    },
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "spesaVariaMG" : {
      "flgRicfatriep" : 5.6644160867523485,
      "flgVentstat" : 4.372688051310086,
      "flgIvaincl" : 1,
      "indTipoevas" : 9.785002165136461,
      "idmediaCg99" : 5.7911894223693885,
      "codice" : "codice",
      "indTotspese" : 7.92839742024475,
      "indRotturacorpo" : 1.0639121808530916,
      "indTipospesa" : 7.3718573971919445,
      "indGesintra" : 3.8008573585058016,
      "descr" : "descr",
      "indFatriep" : 5.974942028545841,
      "indTipotot" : 7.726998920545485,
      "indTipoaliq" : 3.2841216543560217,
      "pluginData" : {
        "key" : ""
      },
      "flgVentamm" : 1.5970080735609526,
      "additionalData" : {
        "key" : ""
      },
      "flgOramin" : 3.812761638325517
    },
    "rigaEstesa" : [ {
      "alfst10" : "alfst10",
      "datast2" : "2000-01-23T04:56:07.000+00:00",
      "numst12" : 6.642953999458534,
      "datast1" : "2000-01-23T04:56:07.000+00:00",
      "alfst12" : "alfst12",
      "alfst11" : "alfst11",
      "idmediaCg99" : 5.726375546151009,
      "datast4" : "2000-01-23T04:56:07.000+00:00",
      "numst10" : 7.129168897240568,
      "datast3" : "2000-01-23T04:56:07.000+00:00",
      "numst11" : 6.370609851066415,
      "progRiga" : 2.008994665592807,
      "datast6" : "2000-01-23T04:56:07.000+00:00",
      "datast5" : "2000-01-23T04:56:07.000+00:00",
      "alfst4" : "alfst4",
      "alfst5" : "alfst5",
      "alfst6" : "alfst6",
      "alfst7" : "alfst7",
      "alfst8" : "alfst8",
      "alfst9" : "alfst9",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "alfst1" : "alfst1",
      "alfst2" : "alfst2",
      "alfst3" : "alfst3",
      "flgSt2" : 2.5524281586707875,
      "flgSt3" : 4.432841187680573,
      "flgSt4" : 3.5117904067536143,
      "numst8" : 9.007961177824221,
      "numst7" : 3.7846852362095262,
      "numst9" : 1.5743672347582194,
      "prog" : 4.863793115215697,
      "numst2" : 9.505836306729838,
      "numst1" : 7.464202015255506,
      "numst4" : 2.684056218962324,
      "dittaCg18" : 8.782449469456207,
      "numst3" : 8.768153453040833,
      "numst6" : 1.0046985756074744,
      "numst5" : 6.712603870693706,
      "indSt1" : 9.721046668148785,
      "indSt2" : 2.922265432447957,
      "flgSt1" : 0.4008378390304357
    }, {
      "alfst10" : "alfst10",
      "datast2" : "2000-01-23T04:56:07.000+00:00",
      "numst12" : 6.642953999458534,
      "datast1" : "2000-01-23T04:56:07.000+00:00",
      "alfst12" : "alfst12",
      "alfst11" : "alfst11",
      "idmediaCg99" : 5.726375546151009,
      "datast4" : "2000-01-23T04:56:07.000+00:00",
      "numst10" : 7.129168897240568,
      "datast3" : "2000-01-23T04:56:07.000+00:00",
      "numst11" : 6.370609851066415,
      "progRiga" : 2.008994665592807,
      "datast6" : "2000-01-23T04:56:07.000+00:00",
      "datast5" : "2000-01-23T04:56:07.000+00:00",
      "alfst4" : "alfst4",
      "alfst5" : "alfst5",
      "alfst6" : "alfst6",
      "alfst7" : "alfst7",
      "alfst8" : "alfst8",
      "alfst9" : "alfst9",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "alfst1" : "alfst1",
      "alfst2" : "alfst2",
      "alfst3" : "alfst3",
      "flgSt2" : 2.5524281586707875,
      "flgSt3" : 4.432841187680573,
      "flgSt4" : 3.5117904067536143,
      "numst8" : 9.007961177824221,
      "numst7" : 3.7846852362095262,
      "numst9" : 1.5743672347582194,
      "prog" : 4.863793115215697,
      "numst2" : 9.505836306729838,
      "numst1" : 7.464202015255506,
      "numst4" : 2.684056218962324,
      "dittaCg18" : 8.782449469456207,
      "numst3" : 8.768153453040833,
      "numst6" : 1.0046985756074744,
      "numst5" : 6.712603870693706,
      "indSt1" : 9.721046668148785,
      "indSt2" : 2.922265432447957,
      "flgSt1" : 0.4008378390304357
    } ],
    "causmagMg51" : 8.37823741034869,
    "cup" : "cup",
    "cig" : "cig",
    "codescl3Mg82" : "codescl3Mg82",
    "progvisuasta" : 5.6644160867523485,
    "rigaOrdine" : {
      "codTraclegdb" : "codTraclegdb",
      "dataconsint" : "2000-01-23T04:56:07.000+00:00",
      "datalancio" : "2000-01-23T04:56:07.000+00:00",
      "flgNonpiuev" : 9,
      "datainizlav" : "2000-01-23T04:56:07.000+00:00",
      "qta2trasfddtcl" : 4.318826475758856,
      "flgConsconf" : 7,
      "flgRicpreev" : 6,
      "collitrasfp" : 9.966789814889403,
      "progRiga" : 0.6895265584691002,
      "qta2lanc" : 0.29551818216563164,
      "qta2prel" : 0.7370530802760489,
      "collicons" : 8.780989965779524,
      "qta2trasfp" : 9.908114046741538,
      "codPiano" : "codPiano",
      "flgNosugg" : 1,
      "numpiano" : 7.375698277301938,
      "qta1prel" : 8.331741856019029,
      "datapianif" : "2000-01-23T04:56:07.000+00:00",
      "numregCo99" : "numregCo99",
      "qta1cons" : 3.5366534267201475,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datafineoap" : "2000-01-23T04:56:07.000+00:00",
      "flgSospriga" : 9,
      "numpropPd39" : 6.97635352548152,
      "qta1lanc" : 5.267310321293582,
      "contpcarPd79" : 9.748669620880193,
      "indStatodescsp" : 6,
      "qta1trasfddtcl" : 7.6528347060559,
      "flgNoevasparz" : 0,
      "ggtollercons" : 9.372628622067484,
      "qta2cons" : 8.223593720381889,
      "collitrasfddtcl" : 5.616380282218067,
      "indStatocons" : 6,
      "codTraclegwbs" : "codTraclegwbs",
      "datacons" : "2000-01-23T04:56:07.000+00:00",
      "valorecons" : 7.541803065493349,
      "dittaCg18" : 6.203595661339589,
      "indEvasdescsp" : 8,
      "qta1trasfp" : 9.120398275527268,
      "dataconsorig" : "2000-01-23T04:56:07.000+00:00",
      "datainizoap" : "2000-01-23T04:56:07.000+00:00",
      "progRigpiaPd80" : 9.290244967928562
    },
    "flgRitacc" : 3,
    "svar2" : "svar2",
    "codschedaMg42" : "codschedaMg42",
    "svar1" : "svar1",
    "capacita" : 5.312489704336296,
    "fatconvcf" : 5.877124706116695,
    "codescl2Mg82" : "codescl2Mg82",
    "colli" : 7.606863723092579,
    "codartcli" : "codartcli",
    "altezza" : 0.4182561061793122,
    "opzioneMg5e" : "opzioneMg5e",
    "stagioneMg5t" : 7,
    "scper1" : 3.8008573585058016,
    "indlisacqven" : 8,
    "qta2" : 5.7911894223693885,
    "scper2" : 1.0639121808530916,
    "scper3" : 3.2841216543560217,
    "scper4" : 9.785002165136461,
    "indlisfisso" : 4,
    "magper2" : 9.386524999783381,
    "qta1" : 4.372688051310086,
    "estdescart" : "estdescart",
    "codescl1Mg82" : "codescl1Mg82",
    "documentoRigaRateiMG" : {
      "flgDaav" : 0.11859130807119977,
      "dataregesinc" : "2000-01-23T04:56:07.000+00:00",
      "imprettcostobu" : 7.390706075830692,
      "imprettcostobuVal" : 1.0502890910539986,
      "importo" : 0.36062689002149373,
      "percforf" : 4.1661834558007,
      "adatacomp" : "2000-01-23T04:56:07.000+00:00",
      "indTipomovbu" : 2.0981949483881577,
      "dadatacomp" : "2000-01-23T04:56:07.000+00:00",
      "indTipocomp" : 6.176386745020588,
      "dittaCg18" : 6.918231485891953,
      "flgDisatcoge" : 4.637509675190766,
      "codBeneusato" : 7.88722683998926,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "contoparCg24" : "contoparCg24",
      "dataregesprec" : "2000-01-23T04:56:07.000+00:00"
    },
    "rigaPersonalizzata" : [ {
      "idmediaCg99" : 5.304373278797373,
      "progRiga" : 9.610516429629122,
      "datapers1" : "2000-01-23T04:56:07.000+00:00",
      "datapers2" : "2000-01-23T04:56:07.000+00:00",
      "alfpers9" : "alfpers9",
      "datapers3" : "2000-01-23T04:56:07.000+00:00",
      "datapers4" : "2000-01-23T04:56:07.000+00:00",
      "datapers5" : "2000-01-23T04:56:07.000+00:00",
      "datapers6" : "2000-01-23T04:56:07.000+00:00",
      "alfpers4" : "alfpers4",
      "indPers1" : 8.708394192403432,
      "alfpers3" : "alfpers3",
      "indPers2" : 0.8164256701298711,
      "alfpers2" : "alfpers2",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "alfpers1" : "alfpers1",
      "additionalData" : {
        "key" : ""
      },
      "alfpers8" : "alfpers8",
      "alfpers7" : "alfpers7",
      "alfpers6" : "alfpers6",
      "alfpers5" : "alfpers5",
      "numpers11" : 0.313237310471568,
      "numpers1" : 4.13177941962639,
      "numpers12" : 7.701777079007398,
      "numpers2" : 2.1871588311421153,
      "numpers3" : 0.05189710095898081,
      "numpers10" : 4.4580628783592156,
      "flgPers2" : 7.766860781935265,
      "numpers8" : 3.0659734456354117,
      "flgPers1" : 8.875589915795528,
      "numpers9" : 8.638367073739522,
      "numpers4" : 4.403697036782718,
      "numpers5" : 6.936499209818381,
      "flgPers4" : 6.720288821326667,
      "numpers6" : 4.035133329541982,
      "prog" : 5.948961008630453,
      "flgPers3" : 1.6056289151258096,
      "numpers7" : 2.1518888575299036,
      "dittaCg18" : 7.437703257022269,
      "alfpers10" : "alfpers10",
      "alfpers11" : "alfpers11",
      "alfpers12" : "alfpers12"
    }, {
      "idmediaCg99" : 5.304373278797373,
      "progRiga" : 9.610516429629122,
      "datapers1" : "2000-01-23T04:56:07.000+00:00",
      "datapers2" : "2000-01-23T04:56:07.000+00:00",
      "alfpers9" : "alfpers9",
      "datapers3" : "2000-01-23T04:56:07.000+00:00",
      "datapers4" : "2000-01-23T04:56:07.000+00:00",
      "datapers5" : "2000-01-23T04:56:07.000+00:00",
      "datapers6" : "2000-01-23T04:56:07.000+00:00",
      "alfpers4" : "alfpers4",
      "indPers1" : 8.708394192403432,
      "alfpers3" : "alfpers3",
      "indPers2" : 0.8164256701298711,
      "alfpers2" : "alfpers2",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "alfpers1" : "alfpers1",
      "additionalData" : {
        "key" : ""
      },
      "alfpers8" : "alfpers8",
      "alfpers7" : "alfpers7",
      "alfpers6" : "alfpers6",
      "alfpers5" : "alfpers5",
      "numpers11" : 0.313237310471568,
      "numpers1" : 4.13177941962639,
      "numpers12" : 7.701777079007398,
      "numpers2" : 2.1871588311421153,
      "numpers3" : 0.05189710095898081,
      "numpers10" : 4.4580628783592156,
      "flgPers2" : 7.766860781935265,
      "numpers8" : 3.0659734456354117,
      "flgPers1" : 8.875589915795528,
      "numpers9" : 8.638367073739522,
      "numpers4" : 4.403697036782718,
      "numpers5" : 6.936499209818381,
      "flgPers4" : 6.720288821326667,
      "numpers6" : 4.035133329541982,
      "prog" : 5.948961008630453,
      "flgPers3" : 1.6056289151258096,
      "numpers7" : 2.1518888575299036,
      "dittaCg18" : 7.437703257022269,
      "alfpers10" : "alfpers10",
      "alfpers11" : "alfpers11",
      "alfpers12" : "alfpers12"
    } ],
    "documentoRigaProvvigioniMG" : [ {
      "idagenteMg17" : 0,
      "percprov" : 9.456612101333725,
      "imporprov" : 4.943637496515336,
      "indRegprov" : 0.4867146239815201,
      "imponprov" : 7.3842318535314,
      "imponprovVal" : 6.749525837406151,
      "progRiga" : 9.721723570087065,
      "imporprovVal" : 0.30134145536422907,
      "dittaCg18" : 2.9679475177256287,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "flgVarprov" : 5.747795090145878,
      "additionalData" : {
        "key" : ""
      },
      "codiceAgente" : "codiceAgente"
    }, {
      "idagenteMg17" : 0,
      "percprov" : 9.456612101333725,
      "imporprov" : 4.943637496515336,
      "indRegprov" : 0.4867146239815201,
      "imponprov" : 7.3842318535314,
      "imponprovVal" : 6.749525837406151,
      "progRiga" : 9.721723570087065,
      "imporprovVal" : 0.30134145536422907,
      "dittaCg18" : 2.9679475177256287,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "flgVarprov" : 5.747795090145878,
      "additionalData" : {
        "key" : ""
      },
      "codiceAgente" : "codiceAgente"
    } ],
    "magper1" : 2.7977867356748476,
    "tara" : 9.402167524121316,
    "packaging" : {
      "umPeso" : "umPeso",
      "qta2Conf" : 7.273019311111276,
      "qta1Conf" : 8.250639315618633,
      "pesoLordo" : 3.8156682252305574,
      "umCapac" : "umCapac",
      "colliConf" : 3.196820582978078,
      "progRiga" : 5.573385265048522,
      "volume" : 2.4669941706755685,
      "umVolume" : "umVolume",
      "dittaCg18" : 5.296102445648278,
      "codConfezMg96" : "codConfezMg96",
      "capacita" : 2.026856458177285,
      "pzConf" : 3.0269458094096646,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "pesoNetto" : 1.9626702727164813
    },
    "rigaLotti" : [ {
      "cliforCg44" : 5.5569822283364845,
      "note" : "note",
      "flgNonpiuev" : 8.546645780823726,
      "codSscc" : "codSscc",
      "progMg4f" : 8.310924482277276,
      "tipocfCg44" : 4.757484754617172,
      "idmediaCg99" : 4.784107115651097,
      "codArtMg66" : "codArtMg66",
      "codDepMg58" : "codDepMg58",
      "codProgPd14" : "codProgPd14",
      "progRiga" : 7.886583288201395,
      "progRigarifDo30" : 1.4793631642421967,
      "codConfezMg96" : "codConfezMg96",
      "numregCo99" : "numregCo99",
      "qta1cons" : 1.8407572303125541,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codBagnomat" : "codBagnomat",
      "codArtpfMg66" : "codArtpfMg66",
      "codPallets" : "codPallets",
      "opzionepfMg5e" : "opzionepfMg5e",
      "opzioneMg5e" : "opzioneMg5e",
      "qta2" : 7.200147194425509,
      "codLottopfMg4g" : "codLottopfMg4g",
      "codLottoMg4g" : "codLottoMg4g",
      "sernum" : "sernum",
      "scadenza" : "2000-01-23T04:56:07.000+00:00",
      "anagraficaLotto" : {
        "note" : "note",
        "dittaCg18" : 4.754071900895484,
        "idmediaCg99" : 1.1864130338603074,
        "codArtMg66" : "codArtMg66",
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "codLotto" : "codLotto",
        "additionalData" : {
          "key" : ""
        },
        "datascad" : "2000-01-23T04:56:07.000+00:00",
        "lib1" : 3.8601930294054942,
        "desclotto" : "desclotto",
        "opzioneMg5e" : "opzioneMg5e"
      },
      "qta1" : 2.719219329469812,
      "qta2cons" : 7.135782839148426,
      "ubicazcollMg97" : "ubicazcollMg97",
      "progRifDo52" : 6.607129449620165,
      "prog" : 8.036294790673514,
      "parametroMovimentazioneLotto" : {
        "flgNote" : 4.5403315819302215,
        "dittaCg18" : 3.8581948879558317,
        "flgAggprogval" : 1.9732909296667345,
        "indGiacsca" : 8.262575023052213,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "prog" : 0.9178980228274691,
        "tipomov" : "tipomov"
      },
      "ubicazMg97" : "ubicazMg97",
      "sotprogPd14" : 1.0348002257634148,
      "dittaCg18" : 5.412786966532157,
      "numregrifCo99" : "numregrifCo99",
      "causmagMg51" : 2.60416377551006
    }, {
      "cliforCg44" : 5.5569822283364845,
      "note" : "note",
      "flgNonpiuev" : 8.546645780823726,
      "codSscc" : "codSscc",
      "progMg4f" : 8.310924482277276,
      "tipocfCg44" : 4.757484754617172,
      "idmediaCg99" : 4.784107115651097,
      "codArtMg66" : "codArtMg66",
      "codDepMg58" : "codDepMg58",
      "codProgPd14" : "codProgPd14",
      "progRiga" : 7.886583288201395,
      "progRigarifDo30" : 1.4793631642421967,
      "codConfezMg96" : "codConfezMg96",
      "numregCo99" : "numregCo99",
      "qta1cons" : 1.8407572303125541,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codBagnomat" : "codBagnomat",
      "codArtpfMg66" : "codArtpfMg66",
      "codPallets" : "codPallets",
      "opzionepfMg5e" : "opzionepfMg5e",
      "opzioneMg5e" : "opzioneMg5e",
      "qta2" : 7.200147194425509,
      "codLottopfMg4g" : "codLottopfMg4g",
      "codLottoMg4g" : "codLottoMg4g",
      "sernum" : "sernum",
      "scadenza" : "2000-01-23T04:56:07.000+00:00",
      "anagraficaLotto" : {
        "note" : "note",
        "dittaCg18" : 4.754071900895484,
        "idmediaCg99" : 1.1864130338603074,
        "codArtMg66" : "codArtMg66",
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "codLotto" : "codLotto",
        "additionalData" : {
          "key" : ""
        },
        "datascad" : "2000-01-23T04:56:07.000+00:00",
        "lib1" : 3.8601930294054942,
        "desclotto" : "desclotto",
        "opzioneMg5e" : "opzioneMg5e"
      },
      "qta1" : 2.719219329469812,
      "qta2cons" : 7.135782839148426,
      "ubicazcollMg97" : "ubicazcollMg97",
      "progRifDo52" : 6.607129449620165,
      "prog" : 8.036294790673514,
      "parametroMovimentazioneLotto" : {
        "flgNote" : 4.5403315819302215,
        "dittaCg18" : 3.8581948879558317,
        "flgAggprogval" : 1.9732909296667345,
        "indGiacsca" : 8.262575023052213,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "prog" : 0.9178980228274691,
        "tipomov" : "tipomov"
      },
      "ubicazMg97" : "ubicazMg97",
      "sotprogPd14" : 1.0348002257634148,
      "dittaCg18" : 5.412786966532157,
      "numregrifCo99" : "numregrifCo99",
      "causmagMg51" : 2.60416377551006
    } ],
    "coddepMg58" : "coddepMg58",
    "costotot" : 3.7814124730767915,
    "indtipoomag" : 0,
    "scper5" : 7.3718573971919445,
    "scper6" : 7.726998920545485,
    "indlisprior" : 0,
    "progrRiga" : 3.812761638325517,
    "lineaFa05" : "lineaFa05",
    "codartfor" : "codartfor",
    "numReg" : "numReg",
    "descart" : "descart",
    "alivacompCg28" : "alivacompCg28",
    "base" : 5.299143560275359,
    "scimp" : 5.974942028545841,
    "rigaRiferimenti" : [ {
      "flgNsdocbis" : 7.686670838404092,
      "qta2mov" : 0.05965928697733491,
      "flgNonpiuevpdc" : 7.321091499885957,
      "notevsdoc" : "notevsdoc",
      "seqfase" : 5.099298781640682,
      "datansdoc" : "2000-01-23T04:56:07.000+00:00",
      "indQtaordres" : 3,
      "seznsdoc" : "seznsdoc",
      "indStipodoc" : 0,
      "datansconf" : "2000-01-23T04:56:07.000+00:00",
      "datavsconf" : "2000-01-23T04:56:07.000+00:00",
      "progRiga" : 6.568304668801491,
      "valoremov" : 9.728706165995554,
      "progRigarifDo30" : 7.338782761819433,
      "progRigapadreDo30" : 1.4985931822280574,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "notensdoc" : "notensdoc",
      "progRif" : 2.3317418552851765,
      "rifvsdoc" : "rifvsdoc",
      "additionalData" : {
        "key" : ""
      },
      "numregpadreCo99" : "numregpadreCo99",
      "flgAggprescvar" : 7.964879197514727,
      "qta1mov" : 9.739448828157911,
      "collimov" : 9.140242185517025,
      "flgAggqtatrasf" : 4,
      "rifnsdoc" : "rifnsdoc",
      "fasePd12" : 4.39343993729625,
      "datavsdoc" : "2000-01-23T04:56:07.000+00:00",
      "indAggdocorigine" : 6.936593194494838,
      "progPdcDo65" : 4.075306827525243,
      "flgStornoqtaval" : 2,
      "numnsdoc" : 4.515863748649669,
      "dittaCg18" : 8.81377937009168,
      "indTipodoc" : 5,
      "numregrifCo99" : "numregrifCo99",
      "numvsdoc" : "numvsdoc",
      "progPdcrifDo65" : 2.674423984487264
    }, {
      "flgNsdocbis" : 7.686670838404092,
      "qta2mov" : 0.05965928697733491,
      "flgNonpiuevpdc" : 7.321091499885957,
      "notevsdoc" : "notevsdoc",
      "seqfase" : 5.099298781640682,
      "datansdoc" : "2000-01-23T04:56:07.000+00:00",
      "indQtaordres" : 3,
      "seznsdoc" : "seznsdoc",
      "indStipodoc" : 0,
      "datansconf" : "2000-01-23T04:56:07.000+00:00",
      "datavsconf" : "2000-01-23T04:56:07.000+00:00",
      "progRiga" : 6.568304668801491,
      "valoremov" : 9.728706165995554,
      "progRigarifDo30" : 7.338782761819433,
      "progRigapadreDo30" : 1.4985931822280574,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "notensdoc" : "notensdoc",
      "progRif" : 2.3317418552851765,
      "rifvsdoc" : "rifvsdoc",
      "additionalData" : {
        "key" : ""
      },
      "numregpadreCo99" : "numregpadreCo99",
      "flgAggprescvar" : 7.964879197514727,
      "qta1mov" : 9.739448828157911,
      "collimov" : 9.140242185517025,
      "flgAggqtatrasf" : 4,
      "rifnsdoc" : "rifnsdoc",
      "fasePd12" : 4.39343993729625,
      "datavsdoc" : "2000-01-23T04:56:07.000+00:00",
      "indAggdocorigine" : 6.936593194494838,
      "progPdcDo65" : 4.075306827525243,
      "flgStornoqtaval" : 2,
      "numnsdoc" : 4.515863748649669,
      "dittaCg18" : 8.81377937009168,
      "indTipodoc" : 5,
      "numregrifCo99" : "numregrifCo99",
      "numvsdoc" : "numvsdoc",
      "progPdcrifDo65" : 2.674423984487264
    } ]
  }, {
    "flgContribinteg" : 7,
    "statoAttualeCO" : {
      "statiDisponibili" : [ null, null ],
      "statoCorrente" : {
        "indTipoStato" : 8,
        "idStato" : 2,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "seq" : 2
      },
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "prezzo2iva" : 9.806951670467935,
    "documentoRigaProgettiMG" : {
      "codDipPd06" : "codDipPd06",
      "attivitaPd0d" : "attivitaPd0d",
      "codProgcol" : "codProgcol",
      "idattrezzaturaVc02" : 6,
      "idartepuVc02" : 2,
      "nodoPd0c" : "nodoPd0c",
      "idmedia" : 0.8411762798681321,
      "codProgetto" : "codProgetto",
      "codSprogetto" : 4.141296055235948,
      "dittaCg18" : 8.910869026866926,
      "codCommessa" : "codCommessa",
      "nodorifcolPd0c" : "nodorifcolPd0c",
      "codScommessa" : 8.276461147928103,
      "spesaPd64" : "spesaPd64",
      "pluginData" : {
        "key" : ""
      },
      "nodorifPd0c" : "nodorifPd0c",
      "additionalData" : {
        "key" : ""
      },
      "codSprogcol" : 6.458262756685686
    },
    "cpmerceCg24" : "cpmerceCg24",
    "profondita" : 1.3949519358941398,
    "prezzo2" : 6.966044574347761,
    "ditta" : 3.111202833403195,
    "prezzo1" : 6.173804034172511,
    "um1" : "um1",
    "indtiporiga" : 7,
    "documentoRigaCOINMG" : {
      "pdcvdsorigPc01" : 4.010300976654761,
      "pdcdestPc01" : 8.262795412896967,
      "vdsorigPc03" : "vdsorigPc03",
      "contoorigPc03" : "contoorigPc03",
      "idmediaCg99" : 3.209082285545927,
      "contodestPc03" : "contodestPc03",
      "flgEsclriga" : 4.4935252719377825,
      "vdsdestPc03" : "vdsdestPc03",
      "dittaCg18" : 1.7045651386993,
      "pdcorigPc01" : 2.9805393113464476,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "pdcvdsdestPc01" : 9.146339979307802
    },
    "pluginData" : {
      "key" : ""
    },
    "um2" : "um2",
    "additionalData" : {
      "key" : ""
    },
    "barcode" : "barcode",
    "fatconv" : 9.897492629215506,
    "magimp" : 4.332304821875894,
    "coddepcolMg58" : "coddepcolMg58",
    "pesol" : 0.58919091925136,
    "prezzo1iva" : 4.8789878742268815,
    "peson" : 2.535258963197524,
    "flgContribprev" : 0,
    "importo" : 3.804112695731078,
    "pzconf" : 1.5970080735609526,
    "flgPriceDiscForce" : true,
    "flgRitenas" : 2,
    "progPadre" : 1.2555055362323109,
    "testoFissoMG" : {
      "descr" : "descr",
      "datainizioval" : "2000-01-23T04:56:07.000+00:00",
      "indTipoevas" : 4.4935252719377825,
      "idprov" : 1,
      "idmediaCg99" : 9.402167524121316,
      "codice" : "codice",
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "testo" : "testo"
    },
    "codescl4Mg82" : "codescl4Mg82",
    "codartMg66" : "codartMg66",
    "rigaIntra" : {
      "meserif" : 5.829097284708605,
      "modincassoIn04" : "modincassoIn04",
      "paesepagCg07" : 8.071139232091417,
      "percadegvalstat" : 8.257837395465918,
      "fatconvumsuppl" : 2.831445253698411,
      "codiceCg72" : "codiceCg72",
      "unsuppl" : 9.878259040728768,
      "paeseorigCg07" : 1.2786903972794905,
      "provdest" : "provdest",
      "provorig" : "provorig",
      "progRiga" : 5.547564904556697,
      "indTipoCg72" : 5.499986845135928,
      "annorif" : 2.924533207692744,
      "dittaCg18" : 8.238101405568635,
      "moderogazioneIn03" : "moderogazioneIn03",
      "paesedestCg07" : 0.7242789830362995,
      "massanetta" : 8.569658089905484,
      "paeseprovCg07" : 2.7107020326702136,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "flgEsclintra" : 6.345503614942988
    },
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "spesaVariaMG" : {
      "flgRicfatriep" : 5.6644160867523485,
      "flgVentstat" : 4.372688051310086,
      "flgIvaincl" : 1,
      "indTipoevas" : 9.785002165136461,
      "idmediaCg99" : 5.7911894223693885,
      "codice" : "codice",
      "indTotspese" : 7.92839742024475,
      "indRotturacorpo" : 1.0639121808530916,
      "indTipospesa" : 7.3718573971919445,
      "indGesintra" : 3.8008573585058016,
      "descr" : "descr",
      "indFatriep" : 5.974942028545841,
      "indTipotot" : 7.726998920545485,
      "indTipoaliq" : 3.2841216543560217,
      "pluginData" : {
        "key" : ""
      },
      "flgVentamm" : 1.5970080735609526,
      "additionalData" : {
        "key" : ""
      },
      "flgOramin" : 3.812761638325517
    },
    "rigaEstesa" : [ {
      "alfst10" : "alfst10",
      "datast2" : "2000-01-23T04:56:07.000+00:00",
      "numst12" : 6.642953999458534,
      "datast1" : "2000-01-23T04:56:07.000+00:00",
      "alfst12" : "alfst12",
      "alfst11" : "alfst11",
      "idmediaCg99" : 5.726375546151009,
      "datast4" : "2000-01-23T04:56:07.000+00:00",
      "numst10" : 7.129168897240568,
      "datast3" : "2000-01-23T04:56:07.000+00:00",
      "numst11" : 6.370609851066415,
      "progRiga" : 2.008994665592807,
      "datast6" : "2000-01-23T04:56:07.000+00:00",
      "datast5" : "2000-01-23T04:56:07.000+00:00",
      "alfst4" : "alfst4",
      "alfst5" : "alfst5",
      "alfst6" : "alfst6",
      "alfst7" : "alfst7",
      "alfst8" : "alfst8",
      "alfst9" : "alfst9",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "alfst1" : "alfst1",
      "alfst2" : "alfst2",
      "alfst3" : "alfst3",
      "flgSt2" : 2.5524281586707875,
      "flgSt3" : 4.432841187680573,
      "flgSt4" : 3.5117904067536143,
      "numst8" : 9.007961177824221,
      "numst7" : 3.7846852362095262,
      "numst9" : 1.5743672347582194,
      "prog" : 4.863793115215697,
      "numst2" : 9.505836306729838,
      "numst1" : 7.464202015255506,
      "numst4" : 2.684056218962324,
      "dittaCg18" : 8.782449469456207,
      "numst3" : 8.768153453040833,
      "numst6" : 1.0046985756074744,
      "numst5" : 6.712603870693706,
      "indSt1" : 9.721046668148785,
      "indSt2" : 2.922265432447957,
      "flgSt1" : 0.4008378390304357
    }, {
      "alfst10" : "alfst10",
      "datast2" : "2000-01-23T04:56:07.000+00:00",
      "numst12" : 6.642953999458534,
      "datast1" : "2000-01-23T04:56:07.000+00:00",
      "alfst12" : "alfst12",
      "alfst11" : "alfst11",
      "idmediaCg99" : 5.726375546151009,
      "datast4" : "2000-01-23T04:56:07.000+00:00",
      "numst10" : 7.129168897240568,
      "datast3" : "2000-01-23T04:56:07.000+00:00",
      "numst11" : 6.370609851066415,
      "progRiga" : 2.008994665592807,
      "datast6" : "2000-01-23T04:56:07.000+00:00",
      "datast5" : "2000-01-23T04:56:07.000+00:00",
      "alfst4" : "alfst4",
      "alfst5" : "alfst5",
      "alfst6" : "alfst6",
      "alfst7" : "alfst7",
      "alfst8" : "alfst8",
      "alfst9" : "alfst9",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "alfst1" : "alfst1",
      "alfst2" : "alfst2",
      "alfst3" : "alfst3",
      "flgSt2" : 2.5524281586707875,
      "flgSt3" : 4.432841187680573,
      "flgSt4" : 3.5117904067536143,
      "numst8" : 9.007961177824221,
      "numst7" : 3.7846852362095262,
      "numst9" : 1.5743672347582194,
      "prog" : 4.863793115215697,
      "numst2" : 9.505836306729838,
      "numst1" : 7.464202015255506,
      "numst4" : 2.684056218962324,
      "dittaCg18" : 8.782449469456207,
      "numst3" : 8.768153453040833,
      "numst6" : 1.0046985756074744,
      "numst5" : 6.712603870693706,
      "indSt1" : 9.721046668148785,
      "indSt2" : 2.922265432447957,
      "flgSt1" : 0.4008378390304357
    } ],
    "causmagMg51" : 8.37823741034869,
    "cup" : "cup",
    "cig" : "cig",
    "codescl3Mg82" : "codescl3Mg82",
    "progvisuasta" : 5.6644160867523485,
    "rigaOrdine" : {
      "codTraclegdb" : "codTraclegdb",
      "dataconsint" : "2000-01-23T04:56:07.000+00:00",
      "datalancio" : "2000-01-23T04:56:07.000+00:00",
      "flgNonpiuev" : 9,
      "datainizlav" : "2000-01-23T04:56:07.000+00:00",
      "qta2trasfddtcl" : 4.318826475758856,
      "flgConsconf" : 7,
      "flgRicpreev" : 6,
      "collitrasfp" : 9.966789814889403,
      "progRiga" : 0.6895265584691002,
      "qta2lanc" : 0.29551818216563164,
      "qta2prel" : 0.7370530802760489,
      "collicons" : 8.780989965779524,
      "qta2trasfp" : 9.908114046741538,
      "codPiano" : "codPiano",
      "flgNosugg" : 1,
      "numpiano" : 7.375698277301938,
      "qta1prel" : 8.331741856019029,
      "datapianif" : "2000-01-23T04:56:07.000+00:00",
      "numregCo99" : "numregCo99",
      "qta1cons" : 3.5366534267201475,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datafineoap" : "2000-01-23T04:56:07.000+00:00",
      "flgSospriga" : 9,
      "numpropPd39" : 6.97635352548152,
      "qta1lanc" : 5.267310321293582,
      "contpcarPd79" : 9.748669620880193,
      "indStatodescsp" : 6,
      "qta1trasfddtcl" : 7.6528347060559,
      "flgNoevasparz" : 0,
      "ggtollercons" : 9.372628622067484,
      "qta2cons" : 8.223593720381889,
      "collitrasfddtcl" : 5.616380282218067,
      "indStatocons" : 6,
      "codTraclegwbs" : "codTraclegwbs",
      "datacons" : "2000-01-23T04:56:07.000+00:00",
      "valorecons" : 7.541803065493349,
      "dittaCg18" : 6.203595661339589,
      "indEvasdescsp" : 8,
      "qta1trasfp" : 9.120398275527268,
      "dataconsorig" : "2000-01-23T04:56:07.000+00:00",
      "datainizoap" : "2000-01-23T04:56:07.000+00:00",
      "progRigpiaPd80" : 9.290244967928562
    },
    "flgRitacc" : 3,
    "svar2" : "svar2",
    "codschedaMg42" : "codschedaMg42",
    "svar1" : "svar1",
    "capacita" : 5.312489704336296,
    "fatconvcf" : 5.877124706116695,
    "codescl2Mg82" : "codescl2Mg82",
    "colli" : 7.606863723092579,
    "codartcli" : "codartcli",
    "altezza" : 0.4182561061793122,
    "opzioneMg5e" : "opzioneMg5e",
    "stagioneMg5t" : 7,
    "scper1" : 3.8008573585058016,
    "indlisacqven" : 8,
    "qta2" : 5.7911894223693885,
    "scper2" : 1.0639121808530916,
    "scper3" : 3.2841216543560217,
    "scper4" : 9.785002165136461,
    "indlisfisso" : 4,
    "magper2" : 9.386524999783381,
    "qta1" : 4.372688051310086,
    "estdescart" : "estdescart",
    "codescl1Mg82" : "codescl1Mg82",
    "documentoRigaRateiMG" : {
      "flgDaav" : 0.11859130807119977,
      "dataregesinc" : "2000-01-23T04:56:07.000+00:00",
      "imprettcostobu" : 7.390706075830692,
      "imprettcostobuVal" : 1.0502890910539986,
      "importo" : 0.36062689002149373,
      "percforf" : 4.1661834558007,
      "adatacomp" : "2000-01-23T04:56:07.000+00:00",
      "indTipomovbu" : 2.0981949483881577,
      "dadatacomp" : "2000-01-23T04:56:07.000+00:00",
      "indTipocomp" : 6.176386745020588,
      "dittaCg18" : 6.918231485891953,
      "flgDisatcoge" : 4.637509675190766,
      "codBeneusato" : 7.88722683998926,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "contoparCg24" : "contoparCg24",
      "dataregesprec" : "2000-01-23T04:56:07.000+00:00"
    },
    "rigaPersonalizzata" : [ {
      "idmediaCg99" : 5.304373278797373,
      "progRiga" : 9.610516429629122,
      "datapers1" : "2000-01-23T04:56:07.000+00:00",
      "datapers2" : "2000-01-23T04:56:07.000+00:00",
      "alfpers9" : "alfpers9",
      "datapers3" : "2000-01-23T04:56:07.000+00:00",
      "datapers4" : "2000-01-23T04:56:07.000+00:00",
      "datapers5" : "2000-01-23T04:56:07.000+00:00",
      "datapers6" : "2000-01-23T04:56:07.000+00:00",
      "alfpers4" : "alfpers4",
      "indPers1" : 8.708394192403432,
      "alfpers3" : "alfpers3",
      "indPers2" : 0.8164256701298711,
      "alfpers2" : "alfpers2",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "alfpers1" : "alfpers1",
      "additionalData" : {
        "key" : ""
      },
      "alfpers8" : "alfpers8",
      "alfpers7" : "alfpers7",
      "alfpers6" : "alfpers6",
      "alfpers5" : "alfpers5",
      "numpers11" : 0.313237310471568,
      "numpers1" : 4.13177941962639,
      "numpers12" : 7.701777079007398,
      "numpers2" : 2.1871588311421153,
      "numpers3" : 0.05189710095898081,
      "numpers10" : 4.4580628783592156,
      "flgPers2" : 7.766860781935265,
      "numpers8" : 3.0659734456354117,
      "flgPers1" : 8.875589915795528,
      "numpers9" : 8.638367073739522,
      "numpers4" : 4.403697036782718,
      "numpers5" : 6.936499209818381,
      "flgPers4" : 6.720288821326667,
      "numpers6" : 4.035133329541982,
      "prog" : 5.948961008630453,
      "flgPers3" : 1.6056289151258096,
      "numpers7" : 2.1518888575299036,
      "dittaCg18" : 7.437703257022269,
      "alfpers10" : "alfpers10",
      "alfpers11" : "alfpers11",
      "alfpers12" : "alfpers12"
    }, {
      "idmediaCg99" : 5.304373278797373,
      "progRiga" : 9.610516429629122,
      "datapers1" : "2000-01-23T04:56:07.000+00:00",
      "datapers2" : "2000-01-23T04:56:07.000+00:00",
      "alfpers9" : "alfpers9",
      "datapers3" : "2000-01-23T04:56:07.000+00:00",
      "datapers4" : "2000-01-23T04:56:07.000+00:00",
      "datapers5" : "2000-01-23T04:56:07.000+00:00",
      "datapers6" : "2000-01-23T04:56:07.000+00:00",
      "alfpers4" : "alfpers4",
      "indPers1" : 8.708394192403432,
      "alfpers3" : "alfpers3",
      "indPers2" : 0.8164256701298711,
      "alfpers2" : "alfpers2",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "alfpers1" : "alfpers1",
      "additionalData" : {
        "key" : ""
      },
      "alfpers8" : "alfpers8",
      "alfpers7" : "alfpers7",
      "alfpers6" : "alfpers6",
      "alfpers5" : "alfpers5",
      "numpers11" : 0.313237310471568,
      "numpers1" : 4.13177941962639,
      "numpers12" : 7.701777079007398,
      "numpers2" : 2.1871588311421153,
      "numpers3" : 0.05189710095898081,
      "numpers10" : 4.4580628783592156,
      "flgPers2" : 7.766860781935265,
      "numpers8" : 3.0659734456354117,
      "flgPers1" : 8.875589915795528,
      "numpers9" : 8.638367073739522,
      "numpers4" : 4.403697036782718,
      "numpers5" : 6.936499209818381,
      "flgPers4" : 6.720288821326667,
      "numpers6" : 4.035133329541982,
      "prog" : 5.948961008630453,
      "flgPers3" : 1.6056289151258096,
      "numpers7" : 2.1518888575299036,
      "dittaCg18" : 7.437703257022269,
      "alfpers10" : "alfpers10",
      "alfpers11" : "alfpers11",
      "alfpers12" : "alfpers12"
    } ],
    "documentoRigaProvvigioniMG" : [ {
      "idagenteMg17" : 0,
      "percprov" : 9.456612101333725,
      "imporprov" : 4.943637496515336,
      "indRegprov" : 0.4867146239815201,
      "imponprov" : 7.3842318535314,
      "imponprovVal" : 6.749525837406151,
      "progRiga" : 9.721723570087065,
      "imporprovVal" : 0.30134145536422907,
      "dittaCg18" : 2.9679475177256287,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "flgVarprov" : 5.747795090145878,
      "additionalData" : {
        "key" : ""
      },
      "codiceAgente" : "codiceAgente"
    }, {
      "idagenteMg17" : 0,
      "percprov" : 9.456612101333725,
      "imporprov" : 4.943637496515336,
      "indRegprov" : 0.4867146239815201,
      "imponprov" : 7.3842318535314,
      "imponprovVal" : 6.749525837406151,
      "progRiga" : 9.721723570087065,
      "imporprovVal" : 0.30134145536422907,
      "dittaCg18" : 2.9679475177256287,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "flgVarprov" : 5.747795090145878,
      "additionalData" : {
        "key" : ""
      },
      "codiceAgente" : "codiceAgente"
    } ],
    "magper1" : 2.7977867356748476,
    "tara" : 9.402167524121316,
    "packaging" : {
      "umPeso" : "umPeso",
      "qta2Conf" : 7.273019311111276,
      "qta1Conf" : 8.250639315618633,
      "pesoLordo" : 3.8156682252305574,
      "umCapac" : "umCapac",
      "colliConf" : 3.196820582978078,
      "progRiga" : 5.573385265048522,
      "volume" : 2.4669941706755685,
      "umVolume" : "umVolume",
      "dittaCg18" : 5.296102445648278,
      "codConfezMg96" : "codConfezMg96",
      "capacita" : 2.026856458177285,
      "pzConf" : 3.0269458094096646,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "pesoNetto" : 1.9626702727164813
    },
    "rigaLotti" : [ {
      "cliforCg44" : 5.5569822283364845,
      "note" : "note",
      "flgNonpiuev" : 8.546645780823726,
      "codSscc" : "codSscc",
      "progMg4f" : 8.310924482277276,
      "tipocfCg44" : 4.757484754617172,
      "idmediaCg99" : 4.784107115651097,
      "codArtMg66" : "codArtMg66",
      "codDepMg58" : "codDepMg58",
      "codProgPd14" : "codProgPd14",
      "progRiga" : 7.886583288201395,
      "progRigarifDo30" : 1.4793631642421967,
      "codConfezMg96" : "codConfezMg96",
      "numregCo99" : "numregCo99",
      "qta1cons" : 1.8407572303125541,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codBagnomat" : "codBagnomat",
      "codArtpfMg66" : "codArtpfMg66",
      "codPallets" : "codPallets",
      "opzionepfMg5e" : "opzionepfMg5e",
      "opzioneMg5e" : "opzioneMg5e",
      "qta2" : 7.200147194425509,
      "codLottopfMg4g" : "codLottopfMg4g",
      "codLottoMg4g" : "codLottoMg4g",
      "sernum" : "sernum",
      "scadenza" : "2000-01-23T04:56:07.000+00:00",
      "anagraficaLotto" : {
        "note" : "note",
        "dittaCg18" : 4.754071900895484,
        "idmediaCg99" : 1.1864130338603074,
        "codArtMg66" : "codArtMg66",
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "codLotto" : "codLotto",
        "additionalData" : {
          "key" : ""
        },
        "datascad" : "2000-01-23T04:56:07.000+00:00",
        "lib1" : 3.8601930294054942,
        "desclotto" : "desclotto",
        "opzioneMg5e" : "opzioneMg5e"
      },
      "qta1" : 2.719219329469812,
      "qta2cons" : 7.135782839148426,
      "ubicazcollMg97" : "ubicazcollMg97",
      "progRifDo52" : 6.607129449620165,
      "prog" : 8.036294790673514,
      "parametroMovimentazioneLotto" : {
        "flgNote" : 4.5403315819302215,
        "dittaCg18" : 3.8581948879558317,
        "flgAggprogval" : 1.9732909296667345,
        "indGiacsca" : 8.262575023052213,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "prog" : 0.9178980228274691,
        "tipomov" : "tipomov"
      },
      "ubicazMg97" : "ubicazMg97",
      "sotprogPd14" : 1.0348002257634148,
      "dittaCg18" : 5.412786966532157,
      "numregrifCo99" : "numregrifCo99",
      "causmagMg51" : 2.60416377551006
    }, {
      "cliforCg44" : 5.5569822283364845,
      "note" : "note",
      "flgNonpiuev" : 8.546645780823726,
      "codSscc" : "codSscc",
      "progMg4f" : 8.310924482277276,
      "tipocfCg44" : 4.757484754617172,
      "idmediaCg99" : 4.784107115651097,
      "codArtMg66" : "codArtMg66",
      "codDepMg58" : "codDepMg58",
      "codProgPd14" : "codProgPd14",
      "progRiga" : 7.886583288201395,
      "progRigarifDo30" : 1.4793631642421967,
      "codConfezMg96" : "codConfezMg96",
      "numregCo99" : "numregCo99",
      "qta1cons" : 1.8407572303125541,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codBagnomat" : "codBagnomat",
      "codArtpfMg66" : "codArtpfMg66",
      "codPallets" : "codPallets",
      "opzionepfMg5e" : "opzionepfMg5e",
      "opzioneMg5e" : "opzioneMg5e",
      "qta2" : 7.200147194425509,
      "codLottopfMg4g" : "codLottopfMg4g",
      "codLottoMg4g" : "codLottoMg4g",
      "sernum" : "sernum",
      "scadenza" : "2000-01-23T04:56:07.000+00:00",
      "anagraficaLotto" : {
        "note" : "note",
        "dittaCg18" : 4.754071900895484,
        "idmediaCg99" : 1.1864130338603074,
        "codArtMg66" : "codArtMg66",
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "codLotto" : "codLotto",
        "additionalData" : {
          "key" : ""
        },
        "datascad" : "2000-01-23T04:56:07.000+00:00",
        "lib1" : 3.8601930294054942,
        "desclotto" : "desclotto",
        "opzioneMg5e" : "opzioneMg5e"
      },
      "qta1" : 2.719219329469812,
      "qta2cons" : 7.135782839148426,
      "ubicazcollMg97" : "ubicazcollMg97",
      "progRifDo52" : 6.607129449620165,
      "prog" : 8.036294790673514,
      "parametroMovimentazioneLotto" : {
        "flgNote" : 4.5403315819302215,
        "dittaCg18" : 3.8581948879558317,
        "flgAggprogval" : 1.9732909296667345,
        "indGiacsca" : 8.262575023052213,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "prog" : 0.9178980228274691,
        "tipomov" : "tipomov"
      },
      "ubicazMg97" : "ubicazMg97",
      "sotprogPd14" : 1.0348002257634148,
      "dittaCg18" : 5.412786966532157,
      "numregrifCo99" : "numregrifCo99",
      "causmagMg51" : 2.60416377551006
    } ],
    "coddepMg58" : "coddepMg58",
    "costotot" : 3.7814124730767915,
    "indtipoomag" : 0,
    "scper5" : 7.3718573971919445,
    "scper6" : 7.726998920545485,
    "indlisprior" : 0,
    "progrRiga" : 3.812761638325517,
    "lineaFa05" : "lineaFa05",
    "codartfor" : "codartfor",
    "numReg" : "numReg",
    "descart" : "descart",
    "alivacompCg28" : "alivacompCg28",
    "base" : 5.299143560275359,
    "scimp" : 5.974942028545841,
    "rigaRiferimenti" : [ {
      "flgNsdocbis" : 7.686670838404092,
      "qta2mov" : 0.05965928697733491,
      "flgNonpiuevpdc" : 7.321091499885957,
      "notevsdoc" : "notevsdoc",
      "seqfase" : 5.099298781640682,
      "datansdoc" : "2000-01-23T04:56:07.000+00:00",
      "indQtaordres" : 3,
      "seznsdoc" : "seznsdoc",
      "indStipodoc" : 0,
      "datansconf" : "2000-01-23T04:56:07.000+00:00",
      "datavsconf" : "2000-01-23T04:56:07.000+00:00",
      "progRiga" : 6.568304668801491,
      "valoremov" : 9.728706165995554,
      "progRigarifDo30" : 7.338782761819433,
      "progRigapadreDo30" : 1.4985931822280574,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "notensdoc" : "notensdoc",
      "progRif" : 2.3317418552851765,
      "rifvsdoc" : "rifvsdoc",
      "additionalData" : {
        "key" : ""
      },
      "numregpadreCo99" : "numregpadreCo99",
      "flgAggprescvar" : 7.964879197514727,
      "qta1mov" : 9.739448828157911,
      "collimov" : 9.140242185517025,
      "flgAggqtatrasf" : 4,
      "rifnsdoc" : "rifnsdoc",
      "fasePd12" : 4.39343993729625,
      "datavsdoc" : "2000-01-23T04:56:07.000+00:00",
      "indAggdocorigine" : 6.936593194494838,
      "progPdcDo65" : 4.075306827525243,
      "flgStornoqtaval" : 2,
      "numnsdoc" : 4.515863748649669,
      "dittaCg18" : 8.81377937009168,
      "indTipodoc" : 5,
      "numregrifCo99" : "numregrifCo99",
      "numvsdoc" : "numvsdoc",
      "progPdcrifDo65" : 2.674423984487264
    }, {
      "flgNsdocbis" : 7.686670838404092,
      "qta2mov" : 0.05965928697733491,
      "flgNonpiuevpdc" : 7.321091499885957,
      "notevsdoc" : "notevsdoc",
      "seqfase" : 5.099298781640682,
      "datansdoc" : "2000-01-23T04:56:07.000+00:00",
      "indQtaordres" : 3,
      "seznsdoc" : "seznsdoc",
      "indStipodoc" : 0,
      "datansconf" : "2000-01-23T04:56:07.000+00:00",
      "datavsconf" : "2000-01-23T04:56:07.000+00:00",
      "progRiga" : 6.568304668801491,
      "valoremov" : 9.728706165995554,
      "progRigarifDo30" : 7.338782761819433,
      "progRigapadreDo30" : 1.4985931822280574,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "notensdoc" : "notensdoc",
      "progRif" : 2.3317418552851765,
      "rifvsdoc" : "rifvsdoc",
      "additionalData" : {
        "key" : ""
      },
      "numregpadreCo99" : "numregpadreCo99",
      "flgAggprescvar" : 7.964879197514727,
      "qta1mov" : 9.739448828157911,
      "collimov" : 9.140242185517025,
      "flgAggqtatrasf" : 4,
      "rifnsdoc" : "rifnsdoc",
      "fasePd12" : 4.39343993729625,
      "datavsdoc" : "2000-01-23T04:56:07.000+00:00",
      "indAggdocorigine" : 6.936593194494838,
      "progPdcDo65" : 4.075306827525243,
      "flgStornoqtaval" : 2,
      "numnsdoc" : 4.515863748649669,
      "dittaCg18" : 8.81377937009168,
      "indTipodoc" : 5,
      "numregrifCo99" : "numregrifCo99",
      "numvsdoc" : "numvsdoc",
      "progPdcrifDo65" : 2.674423984487264
    } ]
  } ],
  "tipodocnumeraz" : 6.438423552598547,
  "lastchange" : "2000-01-23T04:56:07.000+00:00",
  "esclusioneIvaTestata" : 6,
  "testataEstesa" : [ {
    "alfst10" : "alfst10",
    "datast2" : "2000-01-23T04:56:07.000+00:00",
    "numst12" : 9.693372334146686,
    "datast1" : "2000-01-23T04:56:07.000+00:00",
    "alfst12" : "alfst12",
    "alfst11" : "alfst11",
    "idmediaCg99" : 6.677419970877656,
    "datast4" : "2000-01-23T04:56:07.000+00:00",
    "numst10" : 4.966567419166605,
    "datast3" : "2000-01-23T04:56:07.000+00:00",
    "numst11" : 2.9790233918904585,
    "datast6" : "2000-01-23T04:56:07.000+00:00",
    "datast5" : "2000-01-23T04:56:07.000+00:00",
    "alfst4" : "alfst4",
    "alfst5" : "alfst5",
    "alfst6" : "alfst6",
    "alfst7" : "alfst7",
    "alfst8" : "alfst8",
    "alfst9" : "alfst9",
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "alfst1" : "alfst1",
    "alfst2" : "alfst2",
    "alfst3" : "alfst3",
    "flgSt2" : 7.239590766928185,
    "flgSt3" : 6.090696483578148,
    "flgSt4" : 9.852147203726787,
    "numst8" : 4.851239691941878,
    "numst7" : 0.42286244411048224,
    "numst9" : 7.062107048540267,
    "prog" : 8.474710856151638,
    "numst2" : 2.6249013358703053,
    "numst1" : 5.083590215108117,
    "numst4" : 0.9619297253823988,
    "dittaCg18" : 8.018039914932286,
    "numst3" : 3.5742991213280972,
    "numst6" : 1.633699845078339,
    "numst5" : 7.224413148959403,
    "indSt1" : 1.2880645475702646,
    "indSt2" : 1.822577900073098,
    "flgSt1" : 2.6736395633233356
  }, {
    "alfst10" : "alfst10",
    "datast2" : "2000-01-23T04:56:07.000+00:00",
    "numst12" : 9.693372334146686,
    "datast1" : "2000-01-23T04:56:07.000+00:00",
    "alfst12" : "alfst12",
    "alfst11" : "alfst11",
    "idmediaCg99" : 6.677419970877656,
    "datast4" : "2000-01-23T04:56:07.000+00:00",
    "numst10" : 4.966567419166605,
    "datast3" : "2000-01-23T04:56:07.000+00:00",
    "numst11" : 2.9790233918904585,
    "datast6" : "2000-01-23T04:56:07.000+00:00",
    "datast5" : "2000-01-23T04:56:07.000+00:00",
    "alfst4" : "alfst4",
    "alfst5" : "alfst5",
    "alfst6" : "alfst6",
    "alfst7" : "alfst7",
    "alfst8" : "alfst8",
    "alfst9" : "alfst9",
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "alfst1" : "alfst1",
    "alfst2" : "alfst2",
    "alfst3" : "alfst3",
    "flgSt2" : 7.239590766928185,
    "flgSt3" : 6.090696483578148,
    "flgSt4" : 9.852147203726787,
    "numst8" : 4.851239691941878,
    "numst7" : 0.42286244411048224,
    "numst9" : 7.062107048540267,
    "prog" : 8.474710856151638,
    "numst2" : 2.6249013358703053,
    "numst1" : 5.083590215108117,
    "numst4" : 0.9619297253823988,
    "dittaCg18" : 8.018039914932286,
    "numst3" : 3.5742991213280972,
    "numst6" : 1.633699845078339,
    "numst5" : 7.224413148959403,
    "indSt1" : 1.2880645475702646,
    "indSt2" : 1.822577900073098,
    "flgSt1" : 2.6736395633233356
  } ]
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Update the document having Numreg equals to {ID}
 * Updating an object of type
 *
 * body DocumentoTestataMGDTO Object of type to update
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns DocumentoTestataMGDTO
 **/
exports.apiV1EnvironmentMGDocumentoIdPUT = function(body,force,ignoreCompanyPolicyFilter,_op,company,user,id,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "totaliDocumento" : {
    "totalePagare" : 7.691531173686691,
    "scimpmerce" : 2.1184454156145116,
    "totspbolli" : 0.907335931343648,
    "acconto" : 2.7105647837031563,
    "ivaomag" : 8.776709848030322,
    "totaleCosto" : 9.660013839736129,
    "abbuono" : 5.799021278474435,
    "marginedocumento" : 9.576768325858186,
    "imponibomag" : 1.5673210879004595,
    "scimpcassa" : 5.473133728634785,
    "scpercassa2" : 3.93938484566677,
    "scpermerce3" : 9.616627406338315,
    "totdocumento" : 2.376630828418186,
    "scpercassa1" : 6.434791978928281,
    "scpermerce2" : 8.65952233326453,
    "scpermerce1" : 2.162514338057849,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "totimponibile" : 5.898513389775777,
    "totiva" : 2.4062866311545816,
    "totspinc" : 6.232321224432258
  },
  "callOptions" : {
    "flgLockOnDocExist" : false,
    "enableAdditionalValidations" : false,
    "flgSpincasForceZero" : false,
    "esclusioneAgentiMultipli" : false,
    "esclusioneSpeseTestiCliFor" : false,
    "flgSpbolliForceZero" : false,
    "disableLetterOfIntent" : false,
    "esclusioneIvaTestata" : false,
    "flgDisableItemControl" : false
  },
  "valutaCg08" : "valutaCg08",
  "flgSpbolli" : 1,
  "numdocorig" : "numdocorig",
  "codIva" : {
    "flgSospimp" : 1.633699845078339,
    "indNatura" : 8,
    "flgAgri" : 6.090696483578148,
    "tipologia" : 4.778706604314481,
    "percindet" : 6.389489858092311,
    "mossperc" : 5.305668385940959,
    "natureEsCO" : {
      "descr" : "descr",
      "codice" : "codice",
      "datainival" : "2000-01-23T04:56:07.000+00:00",
      "natureAssCO" : [ null, null ],
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "id" : 3,
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "verslynfa" : "verslynfa",
    "idExtendedAttributeEntity" : 0,
    "annotazioni" : "annotazioni",
    "rowVersion" : "",
    "indNatassoswCg2n" : 7,
    "perciva" : 5.201737367852583,
    "percforf" : 6.541917087228235,
    "codice" : "codice",
    "impostamonofasersm" : 4.851239691941878,
    "codiceOss" : "codiceOss",
    "extensionData" : [ null, null ],
    "stdcodivarifCg28" : "stdcodivarifCg28",
    "flgMossgest" : 3,
    "flgAutoue" : 1.2880645475702646,
    "flgIndet" : 2.9790233918904585,
    "codPlafond" : 7.239590766928185,
    "note" : "note",
    "flgAssport398" : 6.677419970877656,
    "flgMossrid" : 0,
    "indStaper" : 3.474156394106027,
    "flgAllclifor" : 9.852147203726787,
    "codiceagr" : "codiceagr",
    "flgImpostadibollo" : 4,
    "flgCorrVent" : 1.822577900073098,
    "aliqivavent" : 2.6736395633233356,
    "flgNotvar" : 7.224413148959403,
    "percmonofasersm" : 6.614319261836819,
    "idprov" : 0.42286244411048224,
    "idExtendedAttributeSubEntity" : 3,
    "natureAssCO" : {
      "descr" : "descr",
      "idCg2m" : 3,
      "idassosw" : 5,
      "codice" : "codice",
      "datainival" : "2000-01-23T04:56:07.000+00:00",
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "flgMonofasersm" : 2.6249013358703053,
    "mosscodCg07" : 6.711221582652969,
    "descrizione" : "descrizione",
    "flgEscludiblacklist" : 5.083590215108117,
    "flgIvaedit" : 9.693372334146686,
    "indtipopart" : 6.008900790410507
  },
  "bancaCg12" : 5.637376656633329,
  "ditta" : 2.027123023002322,
  "anagraficaDocumentoDitta" : {
    "indStaperMg36" : 6.027456183070403,
    "codDocumMg36" : "codDocumMg36",
    "dittaCg18" : 0.8008281904610115,
    "sezdefault" : "sezdefault",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    }
  },
  "testoletint" : "testoletint",
  "indfattpa" : 1,
  "sezautof" : "sezautof",
  "cliforfatt" : 9.301444243932576,
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "customerSupplierMG" : {
    "statoAttualeCO" : {
      "statiDisponibili" : [ null, null ],
      "statoCorrente" : {
        "indTipoStato" : 8,
        "idStato" : 2,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "seq" : 2
      },
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "contratto" : "contratto",
    "idCliFor" : 8,
    "idmediaCg99" : 7.740351818741173,
    "blackListGeneralMasterData" : {
      "datavalid" : "2000-01-23T04:56:07.000+00:00",
      "ragsofiscex" : "ragsofiscex",
      "addresses" : [ {
        "indirizzocomp2" : "indirizzocomp2",
        "addressesType" : [ {
          "tipo" : 6,
          "idCG1J" : 6,
          "pluginData" : {
            "key" : ""
          },
          "id" : 2,
          "additionalData" : {
            "key" : ""
          }
        }, {
          "tipo" : 6,
          "idCG1J" : 6,
          "pluginData" : {
            "key" : ""
          },
          "id" : 2,
          "additionalData" : {
            "key" : ""
          }
        } ],
        "risstato" : "risstato",
        "riszip" : "riszip",
        "pv" : "pv",
        "precisione" : "precisione",
        "codlinguaMg52" : "codlinguaMg52",
        "frazione" : "frazione",
        "emailPec" : "emailPec",
        "tipologia" : "tipologia",
        "via" : "via",
        "idTeamportal" : 6,
        "numciv" : "numciv",
        "cap" : "cap",
        "latitudine" : 3.5571952270680973,
        "statoCg07" : 1.284659006116532,
        "presso" : "presso",
        "federalStateViewCO" : {
          "descr" : "descr",
          "iso3166statofed" : "iso3166statofed",
          "a2iso3166Cg07" : "a2iso3166Cg07",
          "pluginData" : {
            "key" : ""
          },
          "codiceCg07" : 5.944895607614016,
          "additionalData" : {
            "key" : ""
          },
          "statofed" : "statofed"
        },
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "fax" : "fax",
        "statofed" : "statofed",
        "telefono" : "telefono",
        "datamod" : "2000-01-23T04:56:07.000+00:00",
        "email" : "email",
        "citta" : "citta",
        "ragsoc" : "ragsoc",
        "cellnum" : "cellnum",
        "comanaCg01" : "comanaCg01",
        "codiceCg16" : 8,
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "ragsocex" : "ragsocex",
        "rifindirizzo" : "rifindirizzo",
        "codicesfed" : "codicesfed",
        "contea" : "contea",
        "indirizzocomp" : "indirizzocomp",
        "riswarning" : "riswarning",
        "indirizzoex" : "indirizzoex",
        "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
        "risregione" : "risregione",
        "edificio" : "edificio",
        "statoEst" : {
          "codSian" : 3.353193347011243,
          "crtpiva" : "crtpiva",
          "leniban" : 6,
          "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
          "desiso3166" : "desiso3166",
          "idmediaCg99" : 0.8851374739011653,
          "codice" : 6.704019297950036,
          "numiso3166" : "numiso3166",
          "codiceCg08" : "codiceCg08",
          "currencyCO" : {
            "sigla" : "sigla",
            "dataattuem" : "2000-01-23T04:56:07.000+00:00",
            "numdec" : 7.04836565559697,
            "exchangeRateCO" : [ {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            }, {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            } ],
            "idmediaCg99" : 8.969578798196912,
            "codice" : "codice",
            "indCertoincerto" : 7,
            "cambiofisso" : 0.10263654006109402,
            "descr" : "descr",
            "flgValuem" : 4.652396432933246,
            "indValuem" : 3.0576100241049344,
            "indSepmigl" : 3.0205796992916243,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "descr" : "descr",
          "flgIban" : 3,
          "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
          "codIso" : "codIso",
          "a3iso3166" : "a3iso3166",
          "indTipostato" : 7.058770351582356,
          "a2iso3166" : "a2iso3166",
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "datacee" : "2000-01-23T04:56:07.000+00:00",
          "flgSepa" : 7
        },
        "longitudine" : 6.965117697638846,
        "indweb" : "indweb"
      }, {
        "indirizzocomp2" : "indirizzocomp2",
        "addressesType" : [ {
          "tipo" : 6,
          "idCG1J" : 6,
          "pluginData" : {
            "key" : ""
          },
          "id" : 2,
          "additionalData" : {
            "key" : ""
          }
        }, {
          "tipo" : 6,
          "idCG1J" : 6,
          "pluginData" : {
            "key" : ""
          },
          "id" : 2,
          "additionalData" : {
            "key" : ""
          }
        } ],
        "risstato" : "risstato",
        "riszip" : "riszip",
        "pv" : "pv",
        "precisione" : "precisione",
        "codlinguaMg52" : "codlinguaMg52",
        "frazione" : "frazione",
        "emailPec" : "emailPec",
        "tipologia" : "tipologia",
        "via" : "via",
        "idTeamportal" : 6,
        "numciv" : "numciv",
        "cap" : "cap",
        "latitudine" : 3.5571952270680973,
        "statoCg07" : 1.284659006116532,
        "presso" : "presso",
        "federalStateViewCO" : {
          "descr" : "descr",
          "iso3166statofed" : "iso3166statofed",
          "a2iso3166Cg07" : "a2iso3166Cg07",
          "pluginData" : {
            "key" : ""
          },
          "codiceCg07" : 5.944895607614016,
          "additionalData" : {
            "key" : ""
          },
          "statofed" : "statofed"
        },
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "fax" : "fax",
        "statofed" : "statofed",
        "telefono" : "telefono",
        "datamod" : "2000-01-23T04:56:07.000+00:00",
        "email" : "email",
        "citta" : "citta",
        "ragsoc" : "ragsoc",
        "cellnum" : "cellnum",
        "comanaCg01" : "comanaCg01",
        "codiceCg16" : 8,
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "ragsocex" : "ragsocex",
        "rifindirizzo" : "rifindirizzo",
        "codicesfed" : "codicesfed",
        "contea" : "contea",
        "indirizzocomp" : "indirizzocomp",
        "riswarning" : "riswarning",
        "indirizzoex" : "indirizzoex",
        "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
        "risregione" : "risregione",
        "edificio" : "edificio",
        "statoEst" : {
          "codSian" : 3.353193347011243,
          "crtpiva" : "crtpiva",
          "leniban" : 6,
          "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
          "desiso3166" : "desiso3166",
          "idmediaCg99" : 0.8851374739011653,
          "codice" : 6.704019297950036,
          "numiso3166" : "numiso3166",
          "codiceCg08" : "codiceCg08",
          "currencyCO" : {
            "sigla" : "sigla",
            "dataattuem" : "2000-01-23T04:56:07.000+00:00",
            "numdec" : 7.04836565559697,
            "exchangeRateCO" : [ {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            }, {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            } ],
            "idmediaCg99" : 8.969578798196912,
            "codice" : "codice",
            "indCertoincerto" : 7,
            "cambiofisso" : 0.10263654006109402,
            "descr" : "descr",
            "flgValuem" : 4.652396432933246,
            "indValuem" : 3.0576100241049344,
            "indSepmigl" : 3.0205796992916243,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "descr" : "descr",
          "flgIban" : 3,
          "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
          "codIso" : "codIso",
          "a3iso3166" : "a3iso3166",
          "indTipostato" : 7.058770351582356,
          "a2iso3166" : "a2iso3166",
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "datacee" : "2000-01-23T04:56:07.000+00:00",
          "flgSepa" : 7
        },
        "longitudine" : 6.965117697638846,
        "indweb" : "indweb"
      } ],
      "codiceident" : "codiceident",
      "indirCorEX" : "indirCorEX",
      "flgFattpa" : 7,
      "indirizzo" : "indirizzo",
      "ragsoanagex" : "ragsoanagex",
      "codiceCg07" : 7.061401241503109,
      "indsoggrit" : 7.457744773683766,
      "ragSoAnag" : "ragSoAnag",
      "capcor" : "capcor",
      "cittafisc" : "cittafisc",
      "intragroupStructureCO" : {
        "descr" : "descr",
        "codice" : 7.260521264802104,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "codAnagGen" : 4,
        "codIntercompany" : 9
      },
      "statofiscCg07" : 5.025004791520295,
      "tel2num" : "tel2num",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codfiscale" : "codfiscale",
      "statofed" : "statofed",
      "codrichiamo" : 2,
      "provfisc" : "provfisc",
      "idExtendedAttributeEntity" : 9,
      "citta" : "citta",
      "statonascitaCg07" : 9.965781217890562,
      "codice" : 2,
      "indFiscale" : "indFiscale",
      "nome" : "nome",
      "comnascitaCg01" : "comnascitaCg01",
      "codiceCg15" : "codiceCg15",
      "extensionData" : [ {
        "value" : "",
        "key" : "key"
      }, {
        "value" : "",
        "key" : "key"
      } ],
      "ragsofisc" : "ragsofisc",
      "indemail" : "indemail",
      "indirizzoEX" : "indirizzoEX",
      "comfisCg01" : "comfisCg01",
      "comnascita" : "comnascita",
      "partiva" : "partiva",
      "flgNoblacklist" : 1.2315135367772556,
      "partivaEst" : "partivaEst",
      "cognome" : "cognome",
      "idmediaCg99" : 6.84685269835264,
      "wtCodeCO" : {
        "causdd1" : "causdd1",
        "codNonsog" : 0.8774076871421566,
        "flgRegagevo" : 4.86315908102884,
        "idmediaCg99" : 3.901545264248647,
        "percRipPerc" : 1.8268702177058116,
        "flgRitImposta" : 6.073898085781152,
        "codPrev" : "codPrev",
        "tiporapporto" : "tiporapporto",
        "percripaz" : 9.254183946267839,
        "pluginData" : {
          "key" : ""
        },
        "flgPignTerzi" : 7.933506881737151,
        "flgProteo360" : 5.507386964179881,
        "additionalData" : {
          "key" : ""
        },
        "flgGlad" : 9.702963800023566,
        "codFiscPrev" : "codFiscPrev",
        "gcprev" : 4,
        "idprov" : 0.43431398824148815,
        "codice" : "codice",
        "percci" : 4.573936264232251,
        "flgSosprit" : 8,
        "descr" : "descr",
        "flgMinimi" : 0,
        "codTributo" : "codTributo",
        "indCodattglad" : 2.9409642974827896,
        "indTipocassa" : 1,
        "percra" : 8.863729185622827,
        "percbaseimp" : 6.623518433804886,
        "codTribrp" : "codTribrp",
        "inpsivs" : 8.28965939814297,
        "rowversion" : ""
      },
      "dtiniziopec" : "2000-01-23T04:56:07.000+00:00",
      "capfisc" : "capfisc",
      "codicecorCg07" : 3.616076749251911,
      "codiceCgc0" : 9.301444243932576,
      "cap" : "cap",
      "faxnum" : "faxnum",
      "alias" : "alias",
      "flgOmonimo" : 1.0246457001441578,
      "provnascita" : "provnascita",
      "ragsocor" : "ragsocor",
      "prov" : "prov",
      "flgAnagval" : 4.145608029883936,
      "rapazestCg16" : 1,
      "cellnum" : "cellnum",
      "flgPrsfis" : 1.4894159098541704,
      "tel1num" : "tel1num",
      "idExtendedAttributeSubEntity" : 6,
      "provcor" : "provcor",
      "dtfinepec" : "2000-01-23T04:56:07.000+00:00",
      "cittacor" : "cittacor",
      "codicesfed" : "codicesfed",
      "statofedfisc" : "statofedfisc",
      "indFiscaleEX" : "indFiscaleEX",
      "partitaIVA" : "partitaIVA",
      "indirCor" : "indirCor",
      "sesso" : 4.965218492984954,
      "lastchange" : "2000-01-23T04:56:07.000+00:00",
      "ragsocorex" : "ragsocorex",
      "datanascita" : "2000-01-23T04:56:07.000+00:00",
      "auidAu04" : 5,
      "indweb" : "indweb"
    },
    "goods" : {
      "reverseTypeFI" : {
        "reverseTypeCode" : 0,
        "reverseTypeDescription" : "reverseTypeDescription",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "flgBilconsattpassdist" : 0,
      "contochiu" : "contochiu",
      "flgAnalit" : 5,
      "codeformatted" : "codeformatted",
      "intragroupStructureCO" : {
        "descr" : "descr",
        "codice" : 7.260521264802104,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "codAnagGen" : 4,
        "codIntercompany" : 9
      },
      "flgAggfatt" : 8,
      "indLivchius" : 3,
      "idcontoratattCg24" : 6,
      "idcontoapeCg24" : 8,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "contocrsosp" : "contocrsosp",
      "flgContoimm" : 1,
      "flgOpnonfin" : 5.547564904556697,
      "indDaavec" : 3,
      "cogeprogeMateriali" : 2,
      "coaAccountCustomizationFI" : [ {
        "descr" : "descr",
        "iddespcon" : 6,
        "dittaCg18" : 5.616380282218067,
        "contoCg24" : "contoCg24",
        "idmediaCg99" : 7.014147440046284,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "gruppoCg10" : 9.966789814889403,
        "idCg24" : 9,
        "rowversion" : ""
      }, {
        "descr" : "descr",
        "iddespcon" : 6,
        "dittaCg18" : 5.616380282218067,
        "contoCg24" : "contoCg24",
        "idmediaCg99" : 7.014147440046284,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "gruppoCg10" : 9.966789814889403,
        "idCg24" : 9,
        "rowversion" : ""
      } ],
      "accountType" : 9,
      "contoratpass" : "contoratpass",
      "descr" : "descr",
      "idcontorisattCg24" : 1,
      "indDaav" : 1,
      "suddconti" : 8.780989965779524,
      "contoratatt" : "contoratatt",
      "indMastroCliFor" : 1.9732909296667345,
      "idcontochiuCg24" : 8,
      "percindetra" : 0.9178980228274691,
      "codiceCg22" : 4.863793115215697,
      "indAttpasspor" : 1,
      "indTipoconto" : 4,
      "contoape" : "contoape",
      "flgGespor" : 2,
      "cogeprogeAbil" : 2,
      "flgSaldog" : 5,
      "percindeduc" : 8.262575023052213,
      "contorisatt" : "contorisatt",
      "codiceCgc0" : 2.008994665592807,
      "flgValutaest" : 5,
      "flgRaganal" : 9,
      "alias" : "alias",
      "conto" : "conto",
      "balanceSheetAccountCategory" : 1,
      "cogeprogeNodo" : 6,
      "contorispass" : "contorispass",
      "indContoricav" : 4,
      "vatTypeFI" : {
        "descr" : "descr",
        "indAutofattura" : 7,
        "agviaggio" : 0,
        "codice" : 4.318826475758856,
        "pluginData" : {
          "key" : ""
        },
        "localizzazione" : 8,
        "additionalData" : {
          "key" : ""
        },
        "codiceCg0d" : 9.908114046741538,
        "indTipo" : 7.437703257022269
      },
      "idcontorispassCg24" : 2,
      "cogeprogeAttivita" : 8,
      "flgGesec" : 8,
      "coaInternationalCustomizationFI" : [ {
        "contoCg24" : "contoCg24",
        "subcategoria" : 8,
        "categoria" : 3,
        "gbDeferralcode" : "gbDeferralcode",
        "esModulo347" : 5,
        "pluginData" : {
          "key" : ""
        },
        "id" : 7,
        "iso3166A2" : "iso3166A2",
        "additionalData" : {
          "key" : ""
        },
        "gruppoCg10" : 8.331741856019029,
        "idCg24" : 9,
        "rowversion" : ""
      }, {
        "contoCg24" : "contoCg24",
        "subcategoria" : 8,
        "categoria" : 3,
        "gbDeferralcode" : "gbDeferralcode",
        "esModulo347" : 5,
        "pluginData" : {
          "key" : ""
        },
        "id" : 7,
        "iso3166A2" : "iso3166A2",
        "additionalData" : {
          "key" : ""
        },
        "gruppoCg10" : 8.331741856019029,
        "idCg24" : 9,
        "rowversion" : ""
      } ],
      "gruppoCg10" : 8.546645780823726,
      "coaAccountStateFI" : [ {
        "consosCg24" : "consosCg24",
        "dittaCg18" : 0.8972273556195443,
        "dtdisatt" : "2000-01-23T04:56:07.000+00:00",
        "grusosCg10" : 1.7692392591014339,
        "pluginData" : {
          "key" : ""
        },
        "idstatipdc" : 9,
        "additionalData" : {
          "key" : ""
        },
        "dtconsos" : "2000-01-23T04:56:07.000+00:00",
        "flgDisatt" : 9.684087197655908,
        "idCg24" : 6,
        "rowversion" : ""
      }, {
        "consosCg24" : "consosCg24",
        "dittaCg18" : 0.8972273556195443,
        "dtdisatt" : "2000-01-23T04:56:07.000+00:00",
        "grusosCg10" : 1.7692392591014339,
        "pluginData" : {
          "key" : ""
        },
        "idstatipdc" : 9,
        "additionalData" : {
          "key" : ""
        },
        "dtconsos" : "2000-01-23T04:56:07.000+00:00",
        "flgDisatt" : 9.684087197655908,
        "idCg24" : 6,
        "rowversion" : ""
      } ],
      "coaGroupCodeFI" : {
        "descr" : "descr",
        "numlivcons" : 6.460213024504889,
        "gruppo" : 8.289598895249666,
        "numlivelli" : 6.8668894011844035,
        "accountProposals" : [ {
          "contoCg24" : "contoCg24",
          "codice" : 7.375698277301938,
          "pluginData" : {
            "key" : ""
          },
          "id" : 0,
          "additionalData" : {
            "key" : ""
          },
          "gruppoCg10" : 6.97635352548152,
          "idCg24" : 9,
          "rowversion" : ""
        }, {
          "contoCg24" : "contoCg24",
          "codice" : 7.375698277301938,
          "pluginData" : {
            "key" : ""
          },
          "id" : 0,
          "additionalData" : {
            "key" : ""
          },
          "gruppoCg10" : 6.97635352548152,
          "idCg24" : 9,
          "rowversion" : ""
        } ],
        "pluginData" : {
          "key" : ""
        },
        "maskedit" : "maskedit",
        "additionalData" : {
          "key" : ""
        },
        "flgPdclib" : 9,
        "rowversion" : ""
      },
      "idparent" : 1,
      "idreverse" : 7,
      "flgIntercompany" : 8,
      "idcontoratpassCg24" : 7,
      "flgRarp" : 2,
      "idconto" : 4,
      "cogeprogeSpese" : 5,
      "idRifPdC80" : 7,
      "indCosvend" : 4
    },
    "flgAttivo" : 0.8851374739011653,
    "tipocfCg40" : 5.533258397034986,
    "dmsPublishedEntityFW" : {
      "tipoarchHm30" : 2,
      "idknos" : 6,
      "dittaCg18" : 1.0046985756074744,
      "flgInvalid" : 3,
      "datapub" : "2000-01-23T04:56:07.000+00:00",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "protocollo" : "protocollo",
      "nome" : "nome",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "publicationid" : "publicationid",
      "percorso" : "percorso"
    },
    "officeCO" : {
      "indIrizzo" : "indIrizzo",
      "idmediaCg99" : 6.720288821326667,
      "codice" : 7.766860781935265,
      "indDimcentrocomm" : 5.304373278797373,
      "cap" : "cap",
      "dittaCg18" : 1.6056289151258096,
      "progRea" : 8.708394192403432,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "prov" : "prov",
      "numerorea" : "numerorea",
      "citta" : "citta",
      "rowversion" : ""
    },
    "flgInterCompany" : 6.519180951018382,
    "paymentTermCO" : {
      "flgDesc" : 0.8164256701298711,
      "paymentTermDetailCO" : [ {
        "indImpfix" : 1.4985931822280574,
        "daggfix1" : 9.140242185517025,
        "daggfix2" : 8.81377937009168,
        "ggmmfix" : 3.8463127686084055,
        "ggdecor" : 6.936593194494838,
        "idCg64" : 2,
        "imporfix" : 2.3317418552851765,
        "flgFrperciva" : 2.408218941758913,
        "idCg62" : 4,
        "pluginData" : {
          "key" : ""
        },
        "id" : 4,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 7.321091499885957,
        "indTipocalend" : 7,
        "indTipodecor" : 9.739448828157911,
        "aggfix2" : 9.610516429629122,
        "aggfix1" : 5.948961008630453,
        "perciva" : 5.099298781640682,
        "el2frimp" : 4.180725413706508,
        "ggscadfix2" : 5.103912736584151,
        "tipoeff" : 3.3182952910080674,
        "flgFrpercimp" : 7.686670838404092,
        "percimp" : 0.05965928697733491,
        "prog" : 9.728706165995554,
        "el1frimp" : 4.39343993729625,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 0.6052866655822231,
        "subTypeCO" : {
          "ggoffset" : 9.629537564416708,
          "codiceCg07" : 8.50835276411088,
          "tipoeff" : 0.391063602337155,
          "codPaguc" : "codPaguc",
          "descstipo" : "descstipo",
          "codStipoeff" : 9.551762125042277,
          "flgAssegno" : 5,
          "indModfatturapa" : 2,
          "nationCO" : {
            "codSian" : 3.353193347011243,
            "crtpiva" : "crtpiva",
            "leniban" : 6,
            "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
            "desiso3166" : "desiso3166",
            "idmediaCg99" : 0.8851374739011653,
            "codice" : 6.704019297950036,
            "numiso3166" : "numiso3166",
            "codiceCg08" : "codiceCg08",
            "currencyCO" : {
              "sigla" : "sigla",
              "dataattuem" : "2000-01-23T04:56:07.000+00:00",
              "numdec" : 7.04836565559697,
              "exchangeRateCO" : [ {
                "cambio" : 4.078845849666752,
                "anno" : 3.2588565619047607,
                "idmediaCg99" : 6.628464275087742,
                "codiceCg08" : "codiceCg08",
                "indCertoincerto" : 4,
                "codicerifCg08" : "codicerifCg08",
                "giorno" : 0.2025324113236393,
                "mese" : 1.041444916118296,
                "pluginData" : {
                  "key" : ""
                },
                "additionalData" : {
                  "key" : ""
                },
                "adegcambio" : 5.533258397034986,
                "rowversion" : ""
              }, {
                "cambio" : 4.078845849666752,
                "anno" : 3.2588565619047607,
                "idmediaCg99" : 6.628464275087742,
                "codiceCg08" : "codiceCg08",
                "indCertoincerto" : 4,
                "codicerifCg08" : "codicerifCg08",
                "giorno" : 0.2025324113236393,
                "mese" : 1.041444916118296,
                "pluginData" : {
                  "key" : ""
                },
                "additionalData" : {
                  "key" : ""
                },
                "adegcambio" : 5.533258397034986,
                "rowversion" : ""
              } ],
              "idmediaCg99" : 8.969578798196912,
              "codice" : "codice",
              "indCertoincerto" : 7,
              "cambiofisso" : 0.10263654006109402,
              "descr" : "descr",
              "flgValuem" : 4.652396432933246,
              "indValuem" : 3.0576100241049344,
              "indSepmigl" : 3.0205796992916243,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              }
            },
            "descr" : "descr",
            "flgIban" : 3,
            "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
            "codIso" : "codIso",
            "a3iso3166" : "a3iso3166",
            "indTipostato" : 7.058770351582356,
            "a2iso3166" : "a2iso3166",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "datacee" : "2000-01-23T04:56:07.000+00:00",
            "flgSepa" : 7
          },
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 1,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 4,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 7.964879197514727,
        "indDatarif" : 6.568304668801491,
        "rowversion" : ""
      }, {
        "indImpfix" : 1.4985931822280574,
        "daggfix1" : 9.140242185517025,
        "daggfix2" : 8.81377937009168,
        "ggmmfix" : 3.8463127686084055,
        "ggdecor" : 6.936593194494838,
        "idCg64" : 2,
        "imporfix" : 2.3317418552851765,
        "flgFrperciva" : 2.408218941758913,
        "idCg62" : 4,
        "pluginData" : {
          "key" : ""
        },
        "id" : 4,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 7.321091499885957,
        "indTipocalend" : 7,
        "indTipodecor" : 9.739448828157911,
        "aggfix2" : 9.610516429629122,
        "aggfix1" : 5.948961008630453,
        "perciva" : 5.099298781640682,
        "el2frimp" : 4.180725413706508,
        "ggscadfix2" : 5.103912736584151,
        "tipoeff" : 3.3182952910080674,
        "flgFrpercimp" : 7.686670838404092,
        "percimp" : 0.05965928697733491,
        "prog" : 9.728706165995554,
        "el1frimp" : 4.39343993729625,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 0.6052866655822231,
        "subTypeCO" : {
          "ggoffset" : 9.629537564416708,
          "codiceCg07" : 8.50835276411088,
          "tipoeff" : 0.391063602337155,
          "codPaguc" : "codPaguc",
          "descstipo" : "descstipo",
          "codStipoeff" : 9.551762125042277,
          "flgAssegno" : 5,
          "indModfatturapa" : 2,
          "nationCO" : {
            "codSian" : 3.353193347011243,
            "crtpiva" : "crtpiva",
            "leniban" : 6,
            "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
            "desiso3166" : "desiso3166",
            "idmediaCg99" : 0.8851374739011653,
            "codice" : 6.704019297950036,
            "numiso3166" : "numiso3166",
            "codiceCg08" : "codiceCg08",
            "currencyCO" : {
              "sigla" : "sigla",
              "dataattuem" : "2000-01-23T04:56:07.000+00:00",
              "numdec" : 7.04836565559697,
              "exchangeRateCO" : [ {
                "cambio" : 4.078845849666752,
                "anno" : 3.2588565619047607,
                "idmediaCg99" : 6.628464275087742,
                "codiceCg08" : "codiceCg08",
                "indCertoincerto" : 4,
                "codicerifCg08" : "codicerifCg08",
                "giorno" : 0.2025324113236393,
                "mese" : 1.041444916118296,
                "pluginData" : {
                  "key" : ""
                },
                "additionalData" : {
                  "key" : ""
                },
                "adegcambio" : 5.533258397034986,
                "rowversion" : ""
              }, {
                "cambio" : 4.078845849666752,
                "anno" : 3.2588565619047607,
                "idmediaCg99" : 6.628464275087742,
                "codiceCg08" : "codiceCg08",
                "indCertoincerto" : 4,
                "codicerifCg08" : "codicerifCg08",
                "giorno" : 0.2025324113236393,
                "mese" : 1.041444916118296,
                "pluginData" : {
                  "key" : ""
                },
                "additionalData" : {
                  "key" : ""
                },
                "adegcambio" : 5.533258397034986,
                "rowversion" : ""
              } ],
              "idmediaCg99" : 8.969578798196912,
              "codice" : "codice",
              "indCertoincerto" : 7,
              "cambiofisso" : 0.10263654006109402,
              "descr" : "descr",
              "flgValuem" : 4.652396432933246,
              "indValuem" : 3.0576100241049344,
              "indSepmigl" : 3.0205796992916243,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              }
            },
            "descr" : "descr",
            "flgIban" : 3,
            "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
            "codIso" : "codIso",
            "a3iso3166" : "a3iso3166",
            "indTipostato" : 7.058770351582356,
            "a2iso3166" : "a2iso3166",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "datacee" : "2000-01-23T04:56:07.000+00:00",
            "flgSepa" : 7
          },
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 1,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 4,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 7.964879197514727,
        "indDatarif" : 6.568304668801491,
        "rowversion" : ""
      } ],
      "codPag" : "codPag",
      "desPagAnal" : "desPagAnal",
      "flgDisgg" : 4.13177941962639,
      "flgPrefpass" : 0,
      "idExtendedAttributeSubEntity" : 8,
      "flgPrefatt" : 4,
      "flgStornoiva" : 7.701777079007398,
      "descPag" : "descPag",
      "extensionData" : [ {
        "value" : "",
        "key" : "key"
      }, {
        "value" : "",
        "key" : "key"
      } ],
      "scpermer2" : 2.1518888575299036,
      "pluginData" : {
        "key" : ""
      },
      "id" : 2,
      "scpercas" : 6.936499209818381,
      "scpermer1" : 4.035133329541982,
      "additionalData" : {
        "key" : ""
      },
      "scpercart26" : 4.403697036782718,
      "idExtendedAttributeEntity" : 3,
      "rowversion" : "",
      "scart26" : 0.05189710095898081
    },
    "progrEf08" : 3.0576100241049344,
    "tipoCf" : 7.04836565559697,
    "pluginData" : {
      "key" : ""
    },
    "cliFor" : 3.353193347011243,
    "additionalData" : {
      "key" : ""
    },
    "ggScadFix" : 0.10263654006109402,
    "idExtendedAttributeEntity" : 3,
    "idExtendedAttributeSubEntity" : 4,
    "flgCointestati" : 7.058770351582356,
    "gruppoCg10" : 4.652396432933246,
    "currencyCO" : {
      "sigla" : "sigla",
      "dataattuem" : "2000-01-23T04:56:07.000+00:00",
      "numdec" : 7.04836565559697,
      "exchangeRateCO" : [ {
        "cambio" : 4.078845849666752,
        "anno" : 3.2588565619047607,
        "idmediaCg99" : 6.628464275087742,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 4,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 0.2025324113236393,
        "mese" : 1.041444916118296,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 5.533258397034986,
        "rowversion" : ""
      }, {
        "cambio" : 4.078845849666752,
        "anno" : 3.2588565619047607,
        "idmediaCg99" : 6.628464275087742,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 4,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 0.2025324113236393,
        "mese" : 1.041444916118296,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 5.533258397034986,
        "rowversion" : ""
      } ],
      "idmediaCg99" : 8.969578798196912,
      "codice" : "codice",
      "indCertoincerto" : 7,
      "cambiofisso" : 0.10263654006109402,
      "descr" : "descr",
      "flgValuem" : 4.652396432933246,
      "indValuem" : 3.0576100241049344,
      "indSepmigl" : 3.0205796992916243,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "vatCodeCO" : {
      "flgSospimp" : 1.633699845078339,
      "indNatura" : 8,
      "flgAgri" : 6.090696483578148,
      "tipologia" : 4.778706604314481,
      "percindet" : 6.389489858092311,
      "mossperc" : 5.305668385940959,
      "natureEsCO" : {
        "descr" : "descr",
        "codice" : "codice",
        "datainival" : "2000-01-23T04:56:07.000+00:00",
        "natureAssCO" : [ null, null ],
        "datafineval" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "id" : 3,
        "additionalData" : {
          "key" : ""
        },
        "rowversion" : ""
      },
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "verslynfa" : "verslynfa",
      "idExtendedAttributeEntity" : 0,
      "annotazioni" : "annotazioni",
      "rowVersion" : "",
      "indNatassoswCg2n" : 7,
      "perciva" : 5.201737367852583,
      "percforf" : 6.541917087228235,
      "codice" : "codice",
      "impostamonofasersm" : 4.851239691941878,
      "codiceOss" : "codiceOss",
      "extensionData" : [ null, null ],
      "stdcodivarifCg28" : "stdcodivarifCg28",
      "flgMossgest" : 3,
      "flgAutoue" : 1.2880645475702646,
      "flgIndet" : 2.9790233918904585,
      "codPlafond" : 7.239590766928185,
      "note" : "note",
      "flgAssport398" : 6.677419970877656,
      "flgMossrid" : 0,
      "indStaper" : 3.474156394106027,
      "flgAllclifor" : 9.852147203726787,
      "codiceagr" : "codiceagr",
      "flgImpostadibollo" : 4,
      "flgCorrVent" : 1.822577900073098,
      "aliqivavent" : 2.6736395633233356,
      "flgNotvar" : 7.224413148959403,
      "percmonofasersm" : 6.614319261836819,
      "idprov" : 0.42286244411048224,
      "idExtendedAttributeSubEntity" : 3,
      "natureAssCO" : {
        "descr" : "descr",
        "idCg2m" : 3,
        "idassosw" : 5,
        "codice" : "codice",
        "datainival" : "2000-01-23T04:56:07.000+00:00",
        "datafineval" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "rowversion" : ""
      },
      "flgMonofasersm" : 2.6249013358703053,
      "mosscodCg07" : 6.711221582652969,
      "descrizione" : "descrizione",
      "flgEscludiblacklist" : 5.083590215108117,
      "flgIvaedit" : 9.693372334146686,
      "indtipopart" : 6.008900790410507
    },
    "extensionData" : [ null, null ],
    "classificationData" : {
      "cliforCg44" : 0.2025324113236393,
      "indarrinfat" : 4.573936264232251,
      "indprefstdoc" : 5.299143560275359,
      "notes" : [ {
        "cliforCg44" : 0.30134145536422907,
        "note" : "note",
        "dittaCg18" : 0.4867146239815201,
        "tipocfCg44" : 7.88722683998926,
        "idmediaCg99" : 9.456612101333725,
        "destiponote" : "destiponote",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "prog" : 9.721723570087065
      }, {
        "cliforCg44" : 0.30134145536422907,
        "note" : "note",
        "dittaCg18" : 0.4867146239815201,
        "tipocfCg44" : 7.88722683998926,
        "idmediaCg99" : 9.456612101333725,
        "destiponote" : "destiponote",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "prog" : 9.721723570087065
      } ],
      "sc2percor" : 0.4768402382624515,
      "codrifnum" : 6.628464275087742,
      "grouping1CO" : {
        "dittaCg18" : 3.209082285545927,
        "codRaggrcf1" : "codRaggrcf1",
        "descraggrcf1" : "descraggrcf1",
        "idprov" : 2,
        "idmediaCg99" : 8.262795412896967,
        "tipocf" : 9.146339979307802,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "language" : {
        "iso639" : "iso639",
        "idmediaCg99" : 2.9679475177256287,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "descrlingua" : "descrlingua",
        "codLingua" : "codLingua",
        "siglalingua" : "siglalingua"
      },
      "irs1099" : "irs1099",
      "ggcons" : 2.9409642974827896,
      "flgesclspepor" : 0.5199002018724985,
      "grouping3CO" : {
        "codRaggrcf3" : "codRaggrcf3",
        "descraggrcf3" : "descraggrcf3",
        "dittaCg18" : 8.910869026866926,
        "idprov" : 6,
        "idmediaCg99" : 2.058822123984536,
        "tipocf" : 0.8411762798681321,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "datiAccompagnamento" : {
        "cliforCg44" : 4.8789878742268815,
        "vett1Mg14" : "vett1Mg14",
        "imballoMg95" : "imballoMg95",
        "tipocfCg44" : 1.3949519358941398,
        "idmediaCg99" : 9.806951670467935,
        "portoMg91" : "portoMg91",
        "vett2Mg14" : "vett2Mg14",
        "aspettoMg99" : "aspettoMg99",
        "dittaCg18" : 6.966044574347761,
        "spedizMg15" : "spedizMg15",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "tipospedMg93" : "tipospedMg93"
      },
      "tipoclxdoc" : 0.4833312865174044,
      "priceListSalePurchase" : {
        "desclist" : "desclist",
        "numlist" : 4.637509675190766,
        "valutaCg08" : "valutaCg08",
        "dittaCg18" : 6.918231485891953,
        "flgVenacq" : 0.11859130807119977,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "coddocumMg3g" : "coddocumMg3g",
      "indtestof2" : "0",
      "impdaarrot" : 6.623518433804886,
      "indtestof1" : 3.7814124730767915,
      "pluginData" : {
        "key" : ""
      },
      "flgrottsingdoc" : 8.251625748923757,
      "scimpcor" : 3.804112695731078,
      "additionalData" : {
        "key" : ""
      },
      "dataultord" : "2000-01-23T04:56:07.000+00:00",
      "flgTaxliable" : 0,
      "flgspbol" : 4.459605034958679,
      "magpercor" : 5.877124706116695,
      "taxexemptionno" : "taxexemptionno",
      "scaglspbanc" : 2.380090174313445,
      "macroCategoryCO" : {
        "descrmacrocat" : "descrmacrocat",
        "categorie" : [ null, null ],
        "dittaCg18" : 6.749525837406151,
        "tipocf" : 4.943637496515336,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "macrocat" : "macrocat"
      },
      "datacreaz" : "2000-01-23T04:56:07.000+00:00",
      "flgspeinc" : 3.901545264248647,
      "codrifalf" : "codrifalf",
      "sc1percor" : 7.835035282970782,
      "listmag" : 3.111202833403195,
      "categoryCO" : {
        "macrocatMg10" : "macrocatMg10",
        "tipocfMg10" : 6.173804034172511,
        "descrcat" : "descrcat",
        "dittaCg18" : 2.535258963197524,
        "categ" : "categ",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "dittaCg18" : 4.258773108174356,
      "indspesecum" : 8.37823741034869,
      "magimpcor" : 9.897492629215506,
      "datadismis" : "2000-01-23T04:56:07.000+00:00",
      "dataultdoc" : "2000-01-23T04:56:07.000+00:00",
      "macAreaCO" : {
        "descrmacroar" : "descrmacroar",
        "dittaCg18" : 5.747795090145878,
        "idprov" : 0,
        "tipocf" : 7.3842318535314,
        "areas" : [ null, null ],
        "pluginData" : {
          "key" : ""
        },
        "codiceMacroarea" : "codiceMacroarea",
        "additionalData" : {
          "key" : ""
        }
      },
      "indclibloc" : 9.254183946267839,
      "fixedText1" : {
        "descr" : "descr",
        "datainizioval" : "2000-01-23T04:56:07.000+00:00",
        "indTipoevas" : 4.4935252719377825,
        "idprov" : 1,
        "idmediaCg99" : 9.402167524121316,
        "codice" : "codice",
        "datafineval" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "testo" : "testo"
      },
      "flgart62ctr" : 0,
      "imparrotprec" : 8.28965939814297,
      "areaCO" : {
        "codiceAreaMG" : "codiceAreaMG",
        "macroareaMg07" : "macroareaMg07",
        "dittaCg18" : 0.35262192099236644,
        "zone" : [ {
          "areaMg08" : "areaMg08",
          "macroareaMg08" : "macroareaMg08",
          "dittaCg18" : 2.7977867356748476,
          "idprov" : 9,
          "descrzona" : "descrzona",
          "tipocfMg08" : 0.58919091925136,
          "pluginData" : {
            "key" : ""
          },
          "codiceZona" : "codiceZona",
          "additionalData" : {
            "key" : ""
          }
        }, {
          "areaMg08" : "areaMg08",
          "macroareaMg08" : "macroareaMg08",
          "dittaCg18" : 2.7977867356748476,
          "idprov" : 9,
          "descrzona" : "descrzona",
          "tipocfMg08" : 0.58919091925136,
          "pluginData" : {
            "key" : ""
          },
          "codiceZona" : "codiceZona",
          "additionalData" : {
            "key" : ""
          }
        } ],
        "idprov" : 7,
        "tipocfMg07" : 4.332304821875894,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "descrarea" : "descrarea"
      },
      "dataultvar" : "2000-01-23T04:56:07.000+00:00",
      "tipocfCg44" : 4.518309517874243,
      "fidofactoring" : 4.678947989005849,
      "idmediaCg99" : 1.7325933120207193,
      "datarischio" : "2000-01-23T04:56:07.000+00:00",
      "indstscadest" : 7.606863723092579,
      "grouping2CO" : {
        "codRaggrcf2" : "codRaggrcf2",
        "dittaCg18" : 4.010300976654761,
        "idprov" : 6,
        "descraggrcf2" : "descraggrcf2",
        "idmediaCg99" : 8.276461147928103,
        "tipocf" : 4.141296055235948,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "indclifat" : 1.8268702177058116,
      "fixedExp1" : {
        "flgRicfatriep" : 5.6644160867523485,
        "flgVentstat" : 4.372688051310086,
        "flgIvaincl" : 1,
        "indTipoevas" : 9.785002165136461,
        "idmediaCg99" : 5.7911894223693885,
        "codice" : "codice",
        "indTotspese" : 7.92839742024475,
        "indRotturacorpo" : 1.0639121808530916,
        "indTipospesa" : 7.3718573971919445,
        "indGesintra" : 3.8008573585058016,
        "descr" : "descr",
        "indFatriep" : 5.974942028545841,
        "indTipotot" : 7.726998920545485,
        "indTipoaliq" : 3.2841216543560217,
        "pluginData" : {
          "key" : ""
        },
        "flgVentamm" : 1.5970080735609526,
        "additionalData" : {
          "key" : ""
        },
        "flgOramin" : 3.812761638325517
      },
      "scperpiede" : 8.675064425986758,
      "rischio" : {
        "indSegnalazionecorpo" : 7.464202015255506,
        "flgAttivo" : 4.1661834558007,
        "flgScadereins" : 2.4669941706755685,
        "flgOrdini" : 8.250639315618633,
        "flgCalcmovprev" : 5.573385265048522,
        "flgSaldocon" : 7.273019311111276,
        "pluginData" : {
          "key" : ""
        },
        "flgCalcmovdacons" : 1.9626702727164813,
        "additionalData" : {
          "key" : ""
        },
        "flgScadutoins" : 0.4008378390304357,
        "mesiricscadenze" : 6.642953999458534,
        "flgSelclifortrasf" : 4.432841187680573,
        "indElabscadinsol" : 9.721046668148785,
        "flgScadutonoins" : 2.5524281586707875,
        "codice" : "codice",
        "flgEffettiscaduti" : 3.0269458094096646,
        "flgScaderenoins" : 8.782449469456207,
        "flgCalceffcons" : 2.026856458177285,
        "flgCalcmovcons" : 3.8156682252305574,
        "descrizione" : "descrizione",
        "flgCalceffprev" : 5.296102445648278,
        "dittaCg18" : 2.0981949483881577,
        "flgCalceffdacons" : 3.196820582978078,
        "indAttivatrasf" : 5.726375546151009,
        "mesiricordini" : 6.370609851066415,
        "flgSolobusinesriskattivo" : 3.5117904067536143,
        "indProvenienzafido" : 2.922265432447957,
        "mesiricdocdafatt" : 7.129168897240568
      },
      "dataultfat" : "2000-01-23T04:56:07.000+00:00",
      "notebloc" : "notebloc",
      "areaMGnielsenMg0e" : "areaMGnielsenMg0e",
      "indgesfido" : 8.761432466225475,
      "flgprzcamp" : 5.507386964179881,
      "inddesdocest" : 3.502657762086401,
      "flgdaticlfat" : 9.702963800023566,
      "indgiorni" : 0.4182561061793122,
      "fidoaziendale" : 1.041444916118296,
      "fidolivello1" : 7.260521264802104,
      "indrottcig" : 5.312489704336296,
      "fidolivello2" : 9.132027271330688,
      "raggruppamentoPrevalente" : {
        "descragg" : "descragg",
        "cliforCg44" : 7.390706075830692,
        "dittaCg18" : 1.0502890910539986,
        "idmediaCg99" : 6.176386745020588,
        "codRag" : "codRag",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "indarrl96" : 8.863729185622827,
      "dataultcalsp" : "2000-01-23T04:56:07.000+00:00",
      "flgrottcig" : 6.073898085781152,
      "coddestprev" : "coddestprev",
      "codprevragb" : "codprevragb",
      "art62txt" : "art62txt",
      "flgEstrpayline" : 7.933506881737151,
      "indFattper" : 9.183123594773994,
      "flgqualita" : 4.86315908102884,
      "datablocco" : "2000-01-23T04:56:07.000+00:00",
      "priceListWithMultipleItems" : {
        "descr" : "descr",
        "dittaCg18" : 0.36062689002149373,
        "codice" : "codice",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "subCategoryCO" : {
        "descrsottocat" : "descrsottocat",
        "tipocfMg11" : 8.768153453040833,
        "dittaCg18" : 9.505836306729838,
        "sottcat" : "sottcat",
        "categMg11" : "categMg11",
        "macrocatMg11" : "macrocatMg11",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "lastchange" : "2000-01-23T04:56:07.000+00:00",
      "sc3percor" : 3.1497903714250555
    },
    "datavaliva" : "2000-01-23T04:56:07.000+00:00",
    "dittaCg18" : 3.0937452626664474,
    "flgart62" : 7,
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "indElenchiMov3000" : 3,
    "lastchange" : "2000-01-23T04:56:07.000+00:00"
  },
  "idExtendedAttributeEntity" : 6,
  "codbloccoMg25" : "codbloccoMg25",
  "cambio" : 2.3021358869347655,
  "descraggcont" : "descraggcont",
  "idcontCo02" : 1.4894159098541704,
  "indconvclifat" : 7,
  "storageWH" : {
    "locationWH" : [ {
      "maxpeso" : 2.0561655911354517,
      "profondita" : 2.9691650858515217,
      "umdimens" : "umdimens",
      "codDepMg58" : "codDepMg58",
      "descubicaz" : "descubicaz",
      "coordin1" : "coordin1",
      "umpeso" : "umpeso",
      "indTipoubicaz" : 0.391063602337155,
      "dittaCg18" : 2.4977456046390434,
      "larghezza" : 1.2794383049745206,
      "codClassestoc" : 9.629537564416708,
      "pluginData" : {
        "key" : ""
      },
      "codPriorriemp" : 4.917163120387481,
      "additionalData" : {
        "key" : ""
      },
      "ubicaz" : "ubicaz",
      "coordin3" : "coordin3",
      "altezza" : 5.3152834658745505,
      "coordin2" : "coordin2"
    }, {
      "maxpeso" : 2.0561655911354517,
      "profondita" : 2.9691650858515217,
      "umdimens" : "umdimens",
      "codDepMg58" : "codDepMg58",
      "descubicaz" : "descubicaz",
      "coordin1" : "coordin1",
      "umpeso" : "umpeso",
      "indTipoubicaz" : 0.391063602337155,
      "dittaCg18" : 2.4977456046390434,
      "larghezza" : 1.2794383049745206,
      "codClassestoc" : 9.629537564416708,
      "pluginData" : {
        "key" : ""
      },
      "codPriorriemp" : 4.917163120387481,
      "additionalData" : {
        "key" : ""
      },
      "ubicaz" : "ubicaz",
      "coordin3" : "coordin3",
      "altezza" : 5.3152834658745505,
      "coordin2" : "coordin2"
    } ],
    "indIdep" : "indIdep",
    "datacess" : "2000-01-23T04:56:07.000+00:00",
    "capdep" : "capdep",
    "flgDepprinc" : 8.50835276411088,
    "codDep" : "codDep",
    "indEmail" : "indEmail",
    "dataatt" : "2000-01-23T04:56:07.000+00:00",
    "provdep" : "provdep",
    "dittaCg18" : 3.3182952910080674,
    "telnumdep" : "telnumdep",
    "respdep" : "respdep",
    "indInterest" : 9.551762125042277,
    "locdep" : "locdep",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "faxnumdep" : "faxnumdep",
    "descrdep" : "descrdep"
  },
  "tiponumautof" : 3.5571952270680973,
  "documentoDatiAccompagnamentoMG" : {
    "targavet1" : "targavet1",
    "descaspetto" : "descaspetto",
    "codPortoMg91" : "codPortoMg91",
    "codCautraspMg13" : "codCautraspMg13",
    "targavet2" : "targavet2",
    "codImballoMg95" : "codImballoMg95",
    "vettore2Mg14" : "vettore2Mg14",
    "dataritvet1" : "2000-01-23T04:56:07.000+00:00",
    "descrlettint" : "descrlettint",
    "orainiziotrasp" : 5.944895607614016,
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "oraritvet1" : 6.704019297950036,
    "additionalData" : {
      "key" : ""
    },
    "oraritvet2" : 3.353193347011243,
    "codTipospedMg93" : "codTipospedMg93",
    "vettore1Mg14" : "vettore1Mg14",
    "umvolume" : "umvolume",
    "pesolordo" : 3.0937452626664474,
    "dataritvet2" : "2000-01-23T04:56:07.000+00:00",
    "targarim1" : "targarim1",
    "volume" : 7.058770351582356,
    "targarim2" : "targarim2",
    "totcolli" : 0.8851374739011653,
    "umpeso" : "umpeso",
    "dittaCg18" : 6.878052220127876,
    "spedizMg15" : "spedizMg15",
    "datainiztrasp" : "2000-01-23T04:56:07.000+00:00",
    "pesonetto" : 7.143538047012306,
    "codAspettoMg99" : "codAspettoMg99"
  },
  "numdoc" : 9.965781217890562,
  "documentMaster" : {
    "indTipoop" : 6.778324963048013,
    "dittaCg18" : 2.8841621266687802,
    "gruppocre" : "gruppocre",
    "utentevar" : "utentevar",
    "utentecre" : "utentecre",
    "gruppovar" : "gruppovar",
    "numreg" : "numreg",
    "datavar" : "2000-01-23T04:56:07.000+00:00",
    "datacre" : "2000-01-23T04:56:07.000+00:00",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "descnote1" : "descnote1"
  },
  "cliForDest" : "cliForDest",
  "listmag" : 4.965218492984954,
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ],
  "abbuono" : 5.962133916683182,
  "datainiziopag" : "2000-01-23T04:56:07.000+00:00",
  "datareg" : "2000-01-23T04:56:07.000+00:00",
  "testataPersonalizzata" : [ {
    "idmediaCg99" : 1.17662993142012,
    "datapers1" : "2000-01-23T04:56:07.000+00:00",
    "datapers2" : "2000-01-23T04:56:07.000+00:00",
    "alfpers9" : "alfpers9",
    "datapers3" : "2000-01-23T04:56:07.000+00:00",
    "datapers4" : "2000-01-23T04:56:07.000+00:00",
    "datapers5" : "2000-01-23T04:56:07.000+00:00",
    "datapers6" : "2000-01-23T04:56:07.000+00:00",
    "alfpers4" : "alfpers4",
    "indPers1" : 6.434975173600648,
    "alfpers3" : "alfpers3",
    "indPers2" : 2.729215612801924,
    "alfpers2" : "alfpers2",
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "alfpers1" : "alfpers1",
    "additionalData" : {
      "key" : ""
    },
    "alfpers8" : "alfpers8",
    "alfpers7" : "alfpers7",
    "alfpers6" : "alfpers6",
    "alfpers5" : "alfpers5",
    "numpers11" : 8.206187911681816,
    "numpers1" : 9.774932085941137,
    "numpers12" : 3.4925370028432345,
    "numpers2" : 3.4360986237728,
    "numpers3" : 4.786929569572925,
    "numpers10" : 5.328605645442888,
    "flgPers2" : 3.472023815393955,
    "numpers8" : 2.551900688634915,
    "flgPers1" : 3.3841591171956145,
    "numpers9" : 8.128958126729998,
    "numpers4" : 8.342721204157684,
    "numpers5" : 3.6300678941289712,
    "flgPers4" : 8.67132933794674,
    "numpers6" : 2.1305968583238744,
    "prog" : 8.897844438448299,
    "flgPers3" : 5.22975523929469,
    "numpers7" : 7.68210344846877,
    "dittaCg18" : 5.2388109661003055,
    "alfpers10" : "alfpers10",
    "alfpers11" : "alfpers11",
    "alfpers12" : "alfpers12"
  }, {
    "idmediaCg99" : 1.17662993142012,
    "datapers1" : "2000-01-23T04:56:07.000+00:00",
    "datapers2" : "2000-01-23T04:56:07.000+00:00",
    "alfpers9" : "alfpers9",
    "datapers3" : "2000-01-23T04:56:07.000+00:00",
    "datapers4" : "2000-01-23T04:56:07.000+00:00",
    "datapers5" : "2000-01-23T04:56:07.000+00:00",
    "datapers6" : "2000-01-23T04:56:07.000+00:00",
    "alfpers4" : "alfpers4",
    "indPers1" : 6.434975173600648,
    "alfpers3" : "alfpers3",
    "indPers2" : 2.729215612801924,
    "alfpers2" : "alfpers2",
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "alfpers1" : "alfpers1",
    "additionalData" : {
      "key" : ""
    },
    "alfpers8" : "alfpers8",
    "alfpers7" : "alfpers7",
    "alfpers6" : "alfpers6",
    "alfpers5" : "alfpers5",
    "numpers11" : 8.206187911681816,
    "numpers1" : 9.774932085941137,
    "numpers12" : 3.4925370028432345,
    "numpers2" : 3.4360986237728,
    "numpers3" : 4.786929569572925,
    "numpers10" : 5.328605645442888,
    "flgPers2" : 3.472023815393955,
    "numpers8" : 2.551900688634915,
    "flgPers1" : 3.3841591171956145,
    "numpers9" : 8.128958126729998,
    "numpers4" : 8.342721204157684,
    "numpers5" : 3.6300678941289712,
    "flgPers4" : 8.67132933794674,
    "numpers6" : 2.1305968583238744,
    "prog" : 8.897844438448299,
    "flgPers3" : 5.22975523929469,
    "numpers7" : 7.68210344846877,
    "dittaCg18" : 5.2388109661003055,
    "alfpers10" : "alfpers10",
    "alfpers11" : "alfpers11",
    "alfpers12" : "alfpers12"
  } ],
  "dataplafond" : "2000-01-23T04:56:07.000+00:00",
  "stipodoc" : 8.762042012749001,
  "headingReferenceDocumentMG" : [ {
    "flgNsdocbis" : 9.254183946267839,
    "notevsdoc" : "notevsdoc",
    "rifnsdoc" : "rifnsdoc",
    "datansdoc" : "2000-01-23T04:56:07.000+00:00",
    "seznsdoc" : "seznsdoc",
    "indStipodoc" : 1.8268702177058116,
    "datansconf" : "2000-01-23T04:56:07.000+00:00",
    "datavsconf" : "2000-01-23T04:56:07.000+00:00",
    "datavsdoc" : "2000-01-23T04:56:07.000+00:00",
    "fedatadoc" : "2000-01-23T04:56:07.000+00:00",
    "numnsdoc" : 9.183123594773994,
    "dittaCg18" : 8.863729185622827,
    "feiddoc" : "feiddoc",
    "feidsoggetto" : "feidsoggetto",
    "indTipodoc" : 3.502657762086401,
    "numregCo99" : "numregCo99",
    "numvsdoc" : "numvsdoc",
    "pluginData" : {
      "key" : ""
    },
    "notensdoc" : "notensdoc",
    "progRif" : 8.761432466225475,
    "rifvsdoc" : "rifvsdoc",
    "additionalData" : {
      "key" : ""
    }
  }, {
    "flgNsdocbis" : 9.254183946267839,
    "notevsdoc" : "notevsdoc",
    "rifnsdoc" : "rifnsdoc",
    "datansdoc" : "2000-01-23T04:56:07.000+00:00",
    "seznsdoc" : "seznsdoc",
    "indStipodoc" : 1.8268702177058116,
    "datansconf" : "2000-01-23T04:56:07.000+00:00",
    "datavsconf" : "2000-01-23T04:56:07.000+00:00",
    "datavsdoc" : "2000-01-23T04:56:07.000+00:00",
    "fedatadoc" : "2000-01-23T04:56:07.000+00:00",
    "numnsdoc" : 9.183123594773994,
    "dittaCg18" : 8.863729185622827,
    "feiddoc" : "feiddoc",
    "feidsoggetto" : "feidsoggetto",
    "indTipodoc" : 3.502657762086401,
    "numregCo99" : "numregCo99",
    "numvsdoc" : "numvsdoc",
    "pluginData" : {
      "key" : ""
    },
    "notensdoc" : "notensdoc",
    "progRif" : 8.761432466225475,
    "rifvsdoc" : "rifvsdoc",
    "additionalData" : {
      "key" : ""
    }
  } ],
  "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
  "causmagMg51" : 7.061401241503109,
  "cup" : "cup",
  "cig" : "cig",
  "documentoTestataAgentiMG" : [ {
    "idagenteMg17" : 4,
    "dittaCg18" : 6.519180951018382,
    "perprov" : 3.0205796992916243,
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "indRegprov" : 7.740351818741173,
    "additionalData" : {
      "key" : ""
    },
    "flgAgerifer" : 0.10263654006109402,
    "codiceAgente" : "codiceAgente",
    "indModcalc" : 8.969578798196912
  }, {
    "idagenteMg17" : 4,
    "dittaCg18" : 6.519180951018382,
    "perprov" : 3.0205796992916243,
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "indRegprov" : 7.740351818741173,
    "additionalData" : {
      "key" : ""
    },
    "flgAgerifer" : 0.10263654006109402,
    "codiceAgente" : "codiceAgente",
    "indModcalc" : 8.969578798196912
  } ],
  "cauprestCg15" : "cauprestCg15",
  "esclusioneAgentiMultipli" : 0,
  "idmediaCg99" : 6.84685269835264,
  "acconto" : 1.4658129805029452,
  "flgSpincas" : 1,
  "officeCO" : {
    "indIrizzo" : "indIrizzo",
    "idmediaCg99" : 6.720288821326667,
    "codice" : 7.766860781935265,
    "indDimcentrocomm" : 5.304373278797373,
    "cap" : "cap",
    "dittaCg18" : 1.6056289151258096,
    "progRea" : 8.708394192403432,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "prov" : "prov",
    "numerorea" : "numerorea",
    "citta" : "citta",
    "rowversion" : ""
  },
  "datadoc" : "2000-01-23T04:56:07.000+00:00",
  "codpagCg62" : "codpagCg62",
  "flgDocstamp" : 7,
  "documentoTestataProgettiMG" : {
    "codDipPd06" : "codDipPd06",
    "codProgcol" : "codProgcol",
    "causmgoMgfo" : 3,
    "codProgetto" : "codProgetto",
    "codSprogetto" : 3.2588565619047607,
    "dittaCg18" : 4.078845849666752,
    "codCommessa" : "codCommessa",
    "nodorifcolPd0c" : "nodorifcolPd0c",
    "codScommessa" : 7.04836565559697,
    "pluginData" : {
      "key" : ""
    },
    "nodorifPd0c" : "nodorifPd0c",
    "additionalData" : {
      "key" : ""
    },
    "codSprogcol" : 5.533258397034986
  },
  "testataOrdine" : {
    "dataconsint" : "2000-01-23T04:56:07.000+00:00",
    "flgNonpiuev" : 6,
    "flgEvastot" : 6,
    "priorita" : 4.778706604314481,
    "flgNoevasparz" : 5,
    "ggtollercons" : 6.614319261836819,
    "flgRicpreev" : 5,
    "datacons" : "2000-01-23T04:56:07.000+00:00",
    "dittaCg18" : 3.474156394106027,
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "dataconsorig" : "2000-01-23T04:56:07.000+00:00",
    "flgNonann" : 6,
    "additionalData" : {
      "key" : ""
    },
    "flgConfrit" : 6,
    "tipoordine" : 3.0237995775442372,
    "tipoinoltro" : 0.7449262586083982
  },
  "progrEf08" : 9.369310271410669,
  "sezdoc" : "sezdoc",
  "numautof" : 5.025004791520295,
  "tipodoc" : 9.018348186070783,
  "datacambio" : "2000-01-23T04:56:07.000+00:00",
  "stagioneMg5t" : 6,
  "flgClifat" : 4,
  "idExtendedAttributeSubEntity" : 1,
  "documentoTestataRateiMG" : {
    "dadatacomp" : "2000-01-23T04:56:07.000+00:00",
    "flgDaav" : 8.28965939814297,
    "dataregesinc" : "2000-01-23T04:56:07.000+00:00",
    "indTipocomp" : 4.573936264232251,
    "dittaCg18" : 1.7325933120207193,
    "flgDisatcoge" : 6.623518433804886,
    "contopar" : "contopar",
    "datacompivaman" : "2000-01-23T04:56:07.000+00:00",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "adatacomp" : "2000-01-23T04:56:07.000+00:00",
    "dataregesprec" : "2000-01-23T04:56:07.000+00:00"
  },
  "codcabCg13" : 3.616076749251911,
  "documentoTestataProvvigioniMG" : [ {
    "idagenteMg17" : 9,
    "flgStenas" : 0.8774076871421566,
    "flgProvsosp" : 1.041444916118296,
    "idmediaCg99" : 0.5199002018724985,
    "imporprov" : 4.86315908102884,
    "imponprov" : 7.933506881737151,
    "imponprovVal" : 5.507386964179881,
    "trimestrePa23" : 2.9409642974827896,
    "provmedia" : 0.43431398824148815,
    "flgPers" : 4.258773108174356,
    "imporprovVal" : 6.073898085781152,
    "noteprov" : "noteprov",
    "flgSt" : 7.260521264802104,
    "flgStarcred" : 9.132027271330688,
    "indTipomov" : 3.901545264248647,
    "flgProvvar" : 4.678947989005849,
    "dittaCg18" : 6.628464275087742,
    "annoPa23" : 0.2025324113236393,
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "indSt" : 4.459605034958679,
    "additionalData" : {
      "key" : ""
    },
    "codiceAgente" : "codiceAgente",
    "indPers" : 8.251625748923757
  }, {
    "idagenteMg17" : 9,
    "flgStenas" : 0.8774076871421566,
    "flgProvsosp" : 1.041444916118296,
    "idmediaCg99" : 0.5199002018724985,
    "imporprov" : 4.86315908102884,
    "imponprov" : 7.933506881737151,
    "imponprovVal" : 5.507386964179881,
    "trimestrePa23" : 2.9409642974827896,
    "provmedia" : 0.43431398824148815,
    "flgPers" : 4.258773108174356,
    "imporprovVal" : 6.073898085781152,
    "noteprov" : "noteprov",
    "flgSt" : 7.260521264802104,
    "flgStarcred" : 9.132027271330688,
    "indTipomov" : 3.901545264248647,
    "flgProvvar" : 4.678947989005849,
    "dittaCg18" : 6.628464275087742,
    "annoPa23" : 0.2025324113236393,
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "indSt" : 4.459605034958679,
    "additionalData" : {
      "key" : ""
    },
    "codiceAgente" : "codiceAgente",
    "indPers" : 8.251625748923757
  } ],
  "flgLockOnDocExist" : true,
  "lineaFa05" : "lineaFa05",
  "notedocum" : "notedocum",
  "numReg" : "000000000000",
  "righe" : [ {
    "flgContribinteg" : 7,
    "statoAttualeCO" : {
      "statiDisponibili" : [ null, null ],
      "statoCorrente" : {
        "indTipoStato" : 8,
        "idStato" : 2,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "seq" : 2
      },
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "prezzo2iva" : 9.806951670467935,
    "documentoRigaProgettiMG" : {
      "codDipPd06" : "codDipPd06",
      "attivitaPd0d" : "attivitaPd0d",
      "codProgcol" : "codProgcol",
      "idattrezzaturaVc02" : 6,
      "idartepuVc02" : 2,
      "nodoPd0c" : "nodoPd0c",
      "idmedia" : 0.8411762798681321,
      "codProgetto" : "codProgetto",
      "codSprogetto" : 4.141296055235948,
      "dittaCg18" : 8.910869026866926,
      "codCommessa" : "codCommessa",
      "nodorifcolPd0c" : "nodorifcolPd0c",
      "codScommessa" : 8.276461147928103,
      "spesaPd64" : "spesaPd64",
      "pluginData" : {
        "key" : ""
      },
      "nodorifPd0c" : "nodorifPd0c",
      "additionalData" : {
        "key" : ""
      },
      "codSprogcol" : 6.458262756685686
    },
    "cpmerceCg24" : "cpmerceCg24",
    "profondita" : 1.3949519358941398,
    "prezzo2" : 6.966044574347761,
    "ditta" : 3.111202833403195,
    "prezzo1" : 6.173804034172511,
    "um1" : "um1",
    "indtiporiga" : 7,
    "documentoRigaCOINMG" : {
      "pdcvdsorigPc01" : 4.010300976654761,
      "pdcdestPc01" : 8.262795412896967,
      "vdsorigPc03" : "vdsorigPc03",
      "contoorigPc03" : "contoorigPc03",
      "idmediaCg99" : 3.209082285545927,
      "contodestPc03" : "contodestPc03",
      "flgEsclriga" : 4.4935252719377825,
      "vdsdestPc03" : "vdsdestPc03",
      "dittaCg18" : 1.7045651386993,
      "pdcorigPc01" : 2.9805393113464476,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "pdcvdsdestPc01" : 9.146339979307802
    },
    "pluginData" : {
      "key" : ""
    },
    "um2" : "um2",
    "additionalData" : {
      "key" : ""
    },
    "barcode" : "barcode",
    "fatconv" : 9.897492629215506,
    "magimp" : 4.332304821875894,
    "coddepcolMg58" : "coddepcolMg58",
    "pesol" : 0.58919091925136,
    "prezzo1iva" : 4.8789878742268815,
    "peson" : 2.535258963197524,
    "flgContribprev" : 0,
    "importo" : 3.804112695731078,
    "pzconf" : 1.5970080735609526,
    "flgPriceDiscForce" : true,
    "flgRitenas" : 2,
    "progPadre" : 1.2555055362323109,
    "testoFissoMG" : {
      "descr" : "descr",
      "datainizioval" : "2000-01-23T04:56:07.000+00:00",
      "indTipoevas" : 4.4935252719377825,
      "idprov" : 1,
      "idmediaCg99" : 9.402167524121316,
      "codice" : "codice",
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "testo" : "testo"
    },
    "codescl4Mg82" : "codescl4Mg82",
    "codartMg66" : "codartMg66",
    "rigaIntra" : {
      "meserif" : 5.829097284708605,
      "modincassoIn04" : "modincassoIn04",
      "paesepagCg07" : 8.071139232091417,
      "percadegvalstat" : 8.257837395465918,
      "fatconvumsuppl" : 2.831445253698411,
      "codiceCg72" : "codiceCg72",
      "unsuppl" : 9.878259040728768,
      "paeseorigCg07" : 1.2786903972794905,
      "provdest" : "provdest",
      "provorig" : "provorig",
      "progRiga" : 5.547564904556697,
      "indTipoCg72" : 5.499986845135928,
      "annorif" : 2.924533207692744,
      "dittaCg18" : 8.238101405568635,
      "moderogazioneIn03" : "moderogazioneIn03",
      "paesedestCg07" : 0.7242789830362995,
      "massanetta" : 8.569658089905484,
      "paeseprovCg07" : 2.7107020326702136,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "flgEsclintra" : 6.345503614942988
    },
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "spesaVariaMG" : {
      "flgRicfatriep" : 5.6644160867523485,
      "flgVentstat" : 4.372688051310086,
      "flgIvaincl" : 1,
      "indTipoevas" : 9.785002165136461,
      "idmediaCg99" : 5.7911894223693885,
      "codice" : "codice",
      "indTotspese" : 7.92839742024475,
      "indRotturacorpo" : 1.0639121808530916,
      "indTipospesa" : 7.3718573971919445,
      "indGesintra" : 3.8008573585058016,
      "descr" : "descr",
      "indFatriep" : 5.974942028545841,
      "indTipotot" : 7.726998920545485,
      "indTipoaliq" : 3.2841216543560217,
      "pluginData" : {
        "key" : ""
      },
      "flgVentamm" : 1.5970080735609526,
      "additionalData" : {
        "key" : ""
      },
      "flgOramin" : 3.812761638325517
    },
    "rigaEstesa" : [ {
      "alfst10" : "alfst10",
      "datast2" : "2000-01-23T04:56:07.000+00:00",
      "numst12" : 6.642953999458534,
      "datast1" : "2000-01-23T04:56:07.000+00:00",
      "alfst12" : "alfst12",
      "alfst11" : "alfst11",
      "idmediaCg99" : 5.726375546151009,
      "datast4" : "2000-01-23T04:56:07.000+00:00",
      "numst10" : 7.129168897240568,
      "datast3" : "2000-01-23T04:56:07.000+00:00",
      "numst11" : 6.370609851066415,
      "progRiga" : 2.008994665592807,
      "datast6" : "2000-01-23T04:56:07.000+00:00",
      "datast5" : "2000-01-23T04:56:07.000+00:00",
      "alfst4" : "alfst4",
      "alfst5" : "alfst5",
      "alfst6" : "alfst6",
      "alfst7" : "alfst7",
      "alfst8" : "alfst8",
      "alfst9" : "alfst9",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "alfst1" : "alfst1",
      "alfst2" : "alfst2",
      "alfst3" : "alfst3",
      "flgSt2" : 2.5524281586707875,
      "flgSt3" : 4.432841187680573,
      "flgSt4" : 3.5117904067536143,
      "numst8" : 9.007961177824221,
      "numst7" : 3.7846852362095262,
      "numst9" : 1.5743672347582194,
      "prog" : 4.863793115215697,
      "numst2" : 9.505836306729838,
      "numst1" : 7.464202015255506,
      "numst4" : 2.684056218962324,
      "dittaCg18" : 8.782449469456207,
      "numst3" : 8.768153453040833,
      "numst6" : 1.0046985756074744,
      "numst5" : 6.712603870693706,
      "indSt1" : 9.721046668148785,
      "indSt2" : 2.922265432447957,
      "flgSt1" : 0.4008378390304357
    }, {
      "alfst10" : "alfst10",
      "datast2" : "2000-01-23T04:56:07.000+00:00",
      "numst12" : 6.642953999458534,
      "datast1" : "2000-01-23T04:56:07.000+00:00",
      "alfst12" : "alfst12",
      "alfst11" : "alfst11",
      "idmediaCg99" : 5.726375546151009,
      "datast4" : "2000-01-23T04:56:07.000+00:00",
      "numst10" : 7.129168897240568,
      "datast3" : "2000-01-23T04:56:07.000+00:00",
      "numst11" : 6.370609851066415,
      "progRiga" : 2.008994665592807,
      "datast6" : "2000-01-23T04:56:07.000+00:00",
      "datast5" : "2000-01-23T04:56:07.000+00:00",
      "alfst4" : "alfst4",
      "alfst5" : "alfst5",
      "alfst6" : "alfst6",
      "alfst7" : "alfst7",
      "alfst8" : "alfst8",
      "alfst9" : "alfst9",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "alfst1" : "alfst1",
      "alfst2" : "alfst2",
      "alfst3" : "alfst3",
      "flgSt2" : 2.5524281586707875,
      "flgSt3" : 4.432841187680573,
      "flgSt4" : 3.5117904067536143,
      "numst8" : 9.007961177824221,
      "numst7" : 3.7846852362095262,
      "numst9" : 1.5743672347582194,
      "prog" : 4.863793115215697,
      "numst2" : 9.505836306729838,
      "numst1" : 7.464202015255506,
      "numst4" : 2.684056218962324,
      "dittaCg18" : 8.782449469456207,
      "numst3" : 8.768153453040833,
      "numst6" : 1.0046985756074744,
      "numst5" : 6.712603870693706,
      "indSt1" : 9.721046668148785,
      "indSt2" : 2.922265432447957,
      "flgSt1" : 0.4008378390304357
    } ],
    "causmagMg51" : 8.37823741034869,
    "cup" : "cup",
    "cig" : "cig",
    "codescl3Mg82" : "codescl3Mg82",
    "progvisuasta" : 5.6644160867523485,
    "rigaOrdine" : {
      "codTraclegdb" : "codTraclegdb",
      "dataconsint" : "2000-01-23T04:56:07.000+00:00",
      "datalancio" : "2000-01-23T04:56:07.000+00:00",
      "flgNonpiuev" : 9,
      "datainizlav" : "2000-01-23T04:56:07.000+00:00",
      "qta2trasfddtcl" : 4.318826475758856,
      "flgConsconf" : 7,
      "flgRicpreev" : 6,
      "collitrasfp" : 9.966789814889403,
      "progRiga" : 0.6895265584691002,
      "qta2lanc" : 0.29551818216563164,
      "qta2prel" : 0.7370530802760489,
      "collicons" : 8.780989965779524,
      "qta2trasfp" : 9.908114046741538,
      "codPiano" : "codPiano",
      "flgNosugg" : 1,
      "numpiano" : 7.375698277301938,
      "qta1prel" : 8.331741856019029,
      "datapianif" : "2000-01-23T04:56:07.000+00:00",
      "numregCo99" : "numregCo99",
      "qta1cons" : 3.5366534267201475,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datafineoap" : "2000-01-23T04:56:07.000+00:00",
      "flgSospriga" : 9,
      "numpropPd39" : 6.97635352548152,
      "qta1lanc" : 5.267310321293582,
      "contpcarPd79" : 9.748669620880193,
      "indStatodescsp" : 6,
      "qta1trasfddtcl" : 7.6528347060559,
      "flgNoevasparz" : 0,
      "ggtollercons" : 9.372628622067484,
      "qta2cons" : 8.223593720381889,
      "collitrasfddtcl" : 5.616380282218067,
      "indStatocons" : 6,
      "codTraclegwbs" : "codTraclegwbs",
      "datacons" : "2000-01-23T04:56:07.000+00:00",
      "valorecons" : 7.541803065493349,
      "dittaCg18" : 6.203595661339589,
      "indEvasdescsp" : 8,
      "qta1trasfp" : 9.120398275527268,
      "dataconsorig" : "2000-01-23T04:56:07.000+00:00",
      "datainizoap" : "2000-01-23T04:56:07.000+00:00",
      "progRigpiaPd80" : 9.290244967928562
    },
    "flgRitacc" : 3,
    "svar2" : "svar2",
    "codschedaMg42" : "codschedaMg42",
    "svar1" : "svar1",
    "capacita" : 5.312489704336296,
    "fatconvcf" : 5.877124706116695,
    "codescl2Mg82" : "codescl2Mg82",
    "colli" : 7.606863723092579,
    "codartcli" : "codartcli",
    "altezza" : 0.4182561061793122,
    "opzioneMg5e" : "opzioneMg5e",
    "stagioneMg5t" : 7,
    "scper1" : 3.8008573585058016,
    "indlisacqven" : 8,
    "qta2" : 5.7911894223693885,
    "scper2" : 1.0639121808530916,
    "scper3" : 3.2841216543560217,
    "scper4" : 9.785002165136461,
    "indlisfisso" : 4,
    "magper2" : 9.386524999783381,
    "qta1" : 4.372688051310086,
    "estdescart" : "estdescart",
    "codescl1Mg82" : "codescl1Mg82",
    "documentoRigaRateiMG" : {
      "flgDaav" : 0.11859130807119977,
      "dataregesinc" : "2000-01-23T04:56:07.000+00:00",
      "imprettcostobu" : 7.390706075830692,
      "imprettcostobuVal" : 1.0502890910539986,
      "importo" : 0.36062689002149373,
      "percforf" : 4.1661834558007,
      "adatacomp" : "2000-01-23T04:56:07.000+00:00",
      "indTipomovbu" : 2.0981949483881577,
      "dadatacomp" : "2000-01-23T04:56:07.000+00:00",
      "indTipocomp" : 6.176386745020588,
      "dittaCg18" : 6.918231485891953,
      "flgDisatcoge" : 4.637509675190766,
      "codBeneusato" : 7.88722683998926,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "contoparCg24" : "contoparCg24",
      "dataregesprec" : "2000-01-23T04:56:07.000+00:00"
    },
    "rigaPersonalizzata" : [ {
      "idmediaCg99" : 5.304373278797373,
      "progRiga" : 9.610516429629122,
      "datapers1" : "2000-01-23T04:56:07.000+00:00",
      "datapers2" : "2000-01-23T04:56:07.000+00:00",
      "alfpers9" : "alfpers9",
      "datapers3" : "2000-01-23T04:56:07.000+00:00",
      "datapers4" : "2000-01-23T04:56:07.000+00:00",
      "datapers5" : "2000-01-23T04:56:07.000+00:00",
      "datapers6" : "2000-01-23T04:56:07.000+00:00",
      "alfpers4" : "alfpers4",
      "indPers1" : 8.708394192403432,
      "alfpers3" : "alfpers3",
      "indPers2" : 0.8164256701298711,
      "alfpers2" : "alfpers2",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "alfpers1" : "alfpers1",
      "additionalData" : {
        "key" : ""
      },
      "alfpers8" : "alfpers8",
      "alfpers7" : "alfpers7",
      "alfpers6" : "alfpers6",
      "alfpers5" : "alfpers5",
      "numpers11" : 0.313237310471568,
      "numpers1" : 4.13177941962639,
      "numpers12" : 7.701777079007398,
      "numpers2" : 2.1871588311421153,
      "numpers3" : 0.05189710095898081,
      "numpers10" : 4.4580628783592156,
      "flgPers2" : 7.766860781935265,
      "numpers8" : 3.0659734456354117,
      "flgPers1" : 8.875589915795528,
      "numpers9" : 8.638367073739522,
      "numpers4" : 4.403697036782718,
      "numpers5" : 6.936499209818381,
      "flgPers4" : 6.720288821326667,
      "numpers6" : 4.035133329541982,
      "prog" : 5.948961008630453,
      "flgPers3" : 1.6056289151258096,
      "numpers7" : 2.1518888575299036,
      "dittaCg18" : 7.437703257022269,
      "alfpers10" : "alfpers10",
      "alfpers11" : "alfpers11",
      "alfpers12" : "alfpers12"
    }, {
      "idmediaCg99" : 5.304373278797373,
      "progRiga" : 9.610516429629122,
      "datapers1" : "2000-01-23T04:56:07.000+00:00",
      "datapers2" : "2000-01-23T04:56:07.000+00:00",
      "alfpers9" : "alfpers9",
      "datapers3" : "2000-01-23T04:56:07.000+00:00",
      "datapers4" : "2000-01-23T04:56:07.000+00:00",
      "datapers5" : "2000-01-23T04:56:07.000+00:00",
      "datapers6" : "2000-01-23T04:56:07.000+00:00",
      "alfpers4" : "alfpers4",
      "indPers1" : 8.708394192403432,
      "alfpers3" : "alfpers3",
      "indPers2" : 0.8164256701298711,
      "alfpers2" : "alfpers2",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "alfpers1" : "alfpers1",
      "additionalData" : {
        "key" : ""
      },
      "alfpers8" : "alfpers8",
      "alfpers7" : "alfpers7",
      "alfpers6" : "alfpers6",
      "alfpers5" : "alfpers5",
      "numpers11" : 0.313237310471568,
      "numpers1" : 4.13177941962639,
      "numpers12" : 7.701777079007398,
      "numpers2" : 2.1871588311421153,
      "numpers3" : 0.05189710095898081,
      "numpers10" : 4.4580628783592156,
      "flgPers2" : 7.766860781935265,
      "numpers8" : 3.0659734456354117,
      "flgPers1" : 8.875589915795528,
      "numpers9" : 8.638367073739522,
      "numpers4" : 4.403697036782718,
      "numpers5" : 6.936499209818381,
      "flgPers4" : 6.720288821326667,
      "numpers6" : 4.035133329541982,
      "prog" : 5.948961008630453,
      "flgPers3" : 1.6056289151258096,
      "numpers7" : 2.1518888575299036,
      "dittaCg18" : 7.437703257022269,
      "alfpers10" : "alfpers10",
      "alfpers11" : "alfpers11",
      "alfpers12" : "alfpers12"
    } ],
    "documentoRigaProvvigioniMG" : [ {
      "idagenteMg17" : 0,
      "percprov" : 9.456612101333725,
      "imporprov" : 4.943637496515336,
      "indRegprov" : 0.4867146239815201,
      "imponprov" : 7.3842318535314,
      "imponprovVal" : 6.749525837406151,
      "progRiga" : 9.721723570087065,
      "imporprovVal" : 0.30134145536422907,
      "dittaCg18" : 2.9679475177256287,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "flgVarprov" : 5.747795090145878,
      "additionalData" : {
        "key" : ""
      },
      "codiceAgente" : "codiceAgente"
    }, {
      "idagenteMg17" : 0,
      "percprov" : 9.456612101333725,
      "imporprov" : 4.943637496515336,
      "indRegprov" : 0.4867146239815201,
      "imponprov" : 7.3842318535314,
      "imponprovVal" : 6.749525837406151,
      "progRiga" : 9.721723570087065,
      "imporprovVal" : 0.30134145536422907,
      "dittaCg18" : 2.9679475177256287,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "flgVarprov" : 5.747795090145878,
      "additionalData" : {
        "key" : ""
      },
      "codiceAgente" : "codiceAgente"
    } ],
    "magper1" : 2.7977867356748476,
    "tara" : 9.402167524121316,
    "packaging" : {
      "umPeso" : "umPeso",
      "qta2Conf" : 7.273019311111276,
      "qta1Conf" : 8.250639315618633,
      "pesoLordo" : 3.8156682252305574,
      "umCapac" : "umCapac",
      "colliConf" : 3.196820582978078,
      "progRiga" : 5.573385265048522,
      "volume" : 2.4669941706755685,
      "umVolume" : "umVolume",
      "dittaCg18" : 5.296102445648278,
      "codConfezMg96" : "codConfezMg96",
      "capacita" : 2.026856458177285,
      "pzConf" : 3.0269458094096646,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "pesoNetto" : 1.9626702727164813
    },
    "rigaLotti" : [ {
      "cliforCg44" : 5.5569822283364845,
      "note" : "note",
      "flgNonpiuev" : 8.546645780823726,
      "codSscc" : "codSscc",
      "progMg4f" : 8.310924482277276,
      "tipocfCg44" : 4.757484754617172,
      "idmediaCg99" : 4.784107115651097,
      "codArtMg66" : "codArtMg66",
      "codDepMg58" : "codDepMg58",
      "codProgPd14" : "codProgPd14",
      "progRiga" : 7.886583288201395,
      "progRigarifDo30" : 1.4793631642421967,
      "codConfezMg96" : "codConfezMg96",
      "numregCo99" : "numregCo99",
      "qta1cons" : 1.8407572303125541,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codBagnomat" : "codBagnomat",
      "codArtpfMg66" : "codArtpfMg66",
      "codPallets" : "codPallets",
      "opzionepfMg5e" : "opzionepfMg5e",
      "opzioneMg5e" : "opzioneMg5e",
      "qta2" : 7.200147194425509,
      "codLottopfMg4g" : "codLottopfMg4g",
      "codLottoMg4g" : "codLottoMg4g",
      "sernum" : "sernum",
      "scadenza" : "2000-01-23T04:56:07.000+00:00",
      "anagraficaLotto" : {
        "note" : "note",
        "dittaCg18" : 4.754071900895484,
        "idmediaCg99" : 1.1864130338603074,
        "codArtMg66" : "codArtMg66",
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "codLotto" : "codLotto",
        "additionalData" : {
          "key" : ""
        },
        "datascad" : "2000-01-23T04:56:07.000+00:00",
        "lib1" : 3.8601930294054942,
        "desclotto" : "desclotto",
        "opzioneMg5e" : "opzioneMg5e"
      },
      "qta1" : 2.719219329469812,
      "qta2cons" : 7.135782839148426,
      "ubicazcollMg97" : "ubicazcollMg97",
      "progRifDo52" : 6.607129449620165,
      "prog" : 8.036294790673514,
      "parametroMovimentazioneLotto" : {
        "flgNote" : 4.5403315819302215,
        "dittaCg18" : 3.8581948879558317,
        "flgAggprogval" : 1.9732909296667345,
        "indGiacsca" : 8.262575023052213,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "prog" : 0.9178980228274691,
        "tipomov" : "tipomov"
      },
      "ubicazMg97" : "ubicazMg97",
      "sotprogPd14" : 1.0348002257634148,
      "dittaCg18" : 5.412786966532157,
      "numregrifCo99" : "numregrifCo99",
      "causmagMg51" : 2.60416377551006
    }, {
      "cliforCg44" : 5.5569822283364845,
      "note" : "note",
      "flgNonpiuev" : 8.546645780823726,
      "codSscc" : "codSscc",
      "progMg4f" : 8.310924482277276,
      "tipocfCg44" : 4.757484754617172,
      "idmediaCg99" : 4.784107115651097,
      "codArtMg66" : "codArtMg66",
      "codDepMg58" : "codDepMg58",
      "codProgPd14" : "codProgPd14",
      "progRiga" : 7.886583288201395,
      "progRigarifDo30" : 1.4793631642421967,
      "codConfezMg96" : "codConfezMg96",
      "numregCo99" : "numregCo99",
      "qta1cons" : 1.8407572303125541,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codBagnomat" : "codBagnomat",
      "codArtpfMg66" : "codArtpfMg66",
      "codPallets" : "codPallets",
      "opzionepfMg5e" : "opzionepfMg5e",
      "opzioneMg5e" : "opzioneMg5e",
      "qta2" : 7.200147194425509,
      "codLottopfMg4g" : "codLottopfMg4g",
      "codLottoMg4g" : "codLottoMg4g",
      "sernum" : "sernum",
      "scadenza" : "2000-01-23T04:56:07.000+00:00",
      "anagraficaLotto" : {
        "note" : "note",
        "dittaCg18" : 4.754071900895484,
        "idmediaCg99" : 1.1864130338603074,
        "codArtMg66" : "codArtMg66",
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "codLotto" : "codLotto",
        "additionalData" : {
          "key" : ""
        },
        "datascad" : "2000-01-23T04:56:07.000+00:00",
        "lib1" : 3.8601930294054942,
        "desclotto" : "desclotto",
        "opzioneMg5e" : "opzioneMg5e"
      },
      "qta1" : 2.719219329469812,
      "qta2cons" : 7.135782839148426,
      "ubicazcollMg97" : "ubicazcollMg97",
      "progRifDo52" : 6.607129449620165,
      "prog" : 8.036294790673514,
      "parametroMovimentazioneLotto" : {
        "flgNote" : 4.5403315819302215,
        "dittaCg18" : 3.8581948879558317,
        "flgAggprogval" : 1.9732909296667345,
        "indGiacsca" : 8.262575023052213,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "prog" : 0.9178980228274691,
        "tipomov" : "tipomov"
      },
      "ubicazMg97" : "ubicazMg97",
      "sotprogPd14" : 1.0348002257634148,
      "dittaCg18" : 5.412786966532157,
      "numregrifCo99" : "numregrifCo99",
      "causmagMg51" : 2.60416377551006
    } ],
    "coddepMg58" : "coddepMg58",
    "costotot" : 3.7814124730767915,
    "indtipoomag" : 0,
    "scper5" : 7.3718573971919445,
    "scper6" : 7.726998920545485,
    "indlisprior" : 0,
    "progrRiga" : 3.812761638325517,
    "lineaFa05" : "lineaFa05",
    "codartfor" : "codartfor",
    "numReg" : "numReg",
    "descart" : "descart",
    "alivacompCg28" : "alivacompCg28",
    "base" : 5.299143560275359,
    "scimp" : 5.974942028545841,
    "rigaRiferimenti" : [ {
      "flgNsdocbis" : 7.686670838404092,
      "qta2mov" : 0.05965928697733491,
      "flgNonpiuevpdc" : 7.321091499885957,
      "notevsdoc" : "notevsdoc",
      "seqfase" : 5.099298781640682,
      "datansdoc" : "2000-01-23T04:56:07.000+00:00",
      "indQtaordres" : 3,
      "seznsdoc" : "seznsdoc",
      "indStipodoc" : 0,
      "datansconf" : "2000-01-23T04:56:07.000+00:00",
      "datavsconf" : "2000-01-23T04:56:07.000+00:00",
      "progRiga" : 6.568304668801491,
      "valoremov" : 9.728706165995554,
      "progRigarifDo30" : 7.338782761819433,
      "progRigapadreDo30" : 1.4985931822280574,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "notensdoc" : "notensdoc",
      "progRif" : 2.3317418552851765,
      "rifvsdoc" : "rifvsdoc",
      "additionalData" : {
        "key" : ""
      },
      "numregpadreCo99" : "numregpadreCo99",
      "flgAggprescvar" : 7.964879197514727,
      "qta1mov" : 9.739448828157911,
      "collimov" : 9.140242185517025,
      "flgAggqtatrasf" : 4,
      "rifnsdoc" : "rifnsdoc",
      "fasePd12" : 4.39343993729625,
      "datavsdoc" : "2000-01-23T04:56:07.000+00:00",
      "indAggdocorigine" : 6.936593194494838,
      "progPdcDo65" : 4.075306827525243,
      "flgStornoqtaval" : 2,
      "numnsdoc" : 4.515863748649669,
      "dittaCg18" : 8.81377937009168,
      "indTipodoc" : 5,
      "numregrifCo99" : "numregrifCo99",
      "numvsdoc" : "numvsdoc",
      "progPdcrifDo65" : 2.674423984487264
    }, {
      "flgNsdocbis" : 7.686670838404092,
      "qta2mov" : 0.05965928697733491,
      "flgNonpiuevpdc" : 7.321091499885957,
      "notevsdoc" : "notevsdoc",
      "seqfase" : 5.099298781640682,
      "datansdoc" : "2000-01-23T04:56:07.000+00:00",
      "indQtaordres" : 3,
      "seznsdoc" : "seznsdoc",
      "indStipodoc" : 0,
      "datansconf" : "2000-01-23T04:56:07.000+00:00",
      "datavsconf" : "2000-01-23T04:56:07.000+00:00",
      "progRiga" : 6.568304668801491,
      "valoremov" : 9.728706165995554,
      "progRigarifDo30" : 7.338782761819433,
      "progRigapadreDo30" : 1.4985931822280574,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "notensdoc" : "notensdoc",
      "progRif" : 2.3317418552851765,
      "rifvsdoc" : "rifvsdoc",
      "additionalData" : {
        "key" : ""
      },
      "numregpadreCo99" : "numregpadreCo99",
      "flgAggprescvar" : 7.964879197514727,
      "qta1mov" : 9.739448828157911,
      "collimov" : 9.140242185517025,
      "flgAggqtatrasf" : 4,
      "rifnsdoc" : "rifnsdoc",
      "fasePd12" : 4.39343993729625,
      "datavsdoc" : "2000-01-23T04:56:07.000+00:00",
      "indAggdocorigine" : 6.936593194494838,
      "progPdcDo65" : 4.075306827525243,
      "flgStornoqtaval" : 2,
      "numnsdoc" : 4.515863748649669,
      "dittaCg18" : 8.81377937009168,
      "indTipodoc" : 5,
      "numregrifCo99" : "numregrifCo99",
      "numvsdoc" : "numvsdoc",
      "progPdcrifDo65" : 2.674423984487264
    } ]
  }, {
    "flgContribinteg" : 7,
    "statoAttualeCO" : {
      "statiDisponibili" : [ null, null ],
      "statoCorrente" : {
        "indTipoStato" : 8,
        "idStato" : 2,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "seq" : 2
      },
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "prezzo2iva" : 9.806951670467935,
    "documentoRigaProgettiMG" : {
      "codDipPd06" : "codDipPd06",
      "attivitaPd0d" : "attivitaPd0d",
      "codProgcol" : "codProgcol",
      "idattrezzaturaVc02" : 6,
      "idartepuVc02" : 2,
      "nodoPd0c" : "nodoPd0c",
      "idmedia" : 0.8411762798681321,
      "codProgetto" : "codProgetto",
      "codSprogetto" : 4.141296055235948,
      "dittaCg18" : 8.910869026866926,
      "codCommessa" : "codCommessa",
      "nodorifcolPd0c" : "nodorifcolPd0c",
      "codScommessa" : 8.276461147928103,
      "spesaPd64" : "spesaPd64",
      "pluginData" : {
        "key" : ""
      },
      "nodorifPd0c" : "nodorifPd0c",
      "additionalData" : {
        "key" : ""
      },
      "codSprogcol" : 6.458262756685686
    },
    "cpmerceCg24" : "cpmerceCg24",
    "profondita" : 1.3949519358941398,
    "prezzo2" : 6.966044574347761,
    "ditta" : 3.111202833403195,
    "prezzo1" : 6.173804034172511,
    "um1" : "um1",
    "indtiporiga" : 7,
    "documentoRigaCOINMG" : {
      "pdcvdsorigPc01" : 4.010300976654761,
      "pdcdestPc01" : 8.262795412896967,
      "vdsorigPc03" : "vdsorigPc03",
      "contoorigPc03" : "contoorigPc03",
      "idmediaCg99" : 3.209082285545927,
      "contodestPc03" : "contodestPc03",
      "flgEsclriga" : 4.4935252719377825,
      "vdsdestPc03" : "vdsdestPc03",
      "dittaCg18" : 1.7045651386993,
      "pdcorigPc01" : 2.9805393113464476,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "pdcvdsdestPc01" : 9.146339979307802
    },
    "pluginData" : {
      "key" : ""
    },
    "um2" : "um2",
    "additionalData" : {
      "key" : ""
    },
    "barcode" : "barcode",
    "fatconv" : 9.897492629215506,
    "magimp" : 4.332304821875894,
    "coddepcolMg58" : "coddepcolMg58",
    "pesol" : 0.58919091925136,
    "prezzo1iva" : 4.8789878742268815,
    "peson" : 2.535258963197524,
    "flgContribprev" : 0,
    "importo" : 3.804112695731078,
    "pzconf" : 1.5970080735609526,
    "flgPriceDiscForce" : true,
    "flgRitenas" : 2,
    "progPadre" : 1.2555055362323109,
    "testoFissoMG" : {
      "descr" : "descr",
      "datainizioval" : "2000-01-23T04:56:07.000+00:00",
      "indTipoevas" : 4.4935252719377825,
      "idprov" : 1,
      "idmediaCg99" : 9.402167524121316,
      "codice" : "codice",
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "testo" : "testo"
    },
    "codescl4Mg82" : "codescl4Mg82",
    "codartMg66" : "codartMg66",
    "rigaIntra" : {
      "meserif" : 5.829097284708605,
      "modincassoIn04" : "modincassoIn04",
      "paesepagCg07" : 8.071139232091417,
      "percadegvalstat" : 8.257837395465918,
      "fatconvumsuppl" : 2.831445253698411,
      "codiceCg72" : "codiceCg72",
      "unsuppl" : 9.878259040728768,
      "paeseorigCg07" : 1.2786903972794905,
      "provdest" : "provdest",
      "provorig" : "provorig",
      "progRiga" : 5.547564904556697,
      "indTipoCg72" : 5.499986845135928,
      "annorif" : 2.924533207692744,
      "dittaCg18" : 8.238101405568635,
      "moderogazioneIn03" : "moderogazioneIn03",
      "paesedestCg07" : 0.7242789830362995,
      "massanetta" : 8.569658089905484,
      "paeseprovCg07" : 2.7107020326702136,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "flgEsclintra" : 6.345503614942988
    },
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "spesaVariaMG" : {
      "flgRicfatriep" : 5.6644160867523485,
      "flgVentstat" : 4.372688051310086,
      "flgIvaincl" : 1,
      "indTipoevas" : 9.785002165136461,
      "idmediaCg99" : 5.7911894223693885,
      "codice" : "codice",
      "indTotspese" : 7.92839742024475,
      "indRotturacorpo" : 1.0639121808530916,
      "indTipospesa" : 7.3718573971919445,
      "indGesintra" : 3.8008573585058016,
      "descr" : "descr",
      "indFatriep" : 5.974942028545841,
      "indTipotot" : 7.726998920545485,
      "indTipoaliq" : 3.2841216543560217,
      "pluginData" : {
        "key" : ""
      },
      "flgVentamm" : 1.5970080735609526,
      "additionalData" : {
        "key" : ""
      },
      "flgOramin" : 3.812761638325517
    },
    "rigaEstesa" : [ {
      "alfst10" : "alfst10",
      "datast2" : "2000-01-23T04:56:07.000+00:00",
      "numst12" : 6.642953999458534,
      "datast1" : "2000-01-23T04:56:07.000+00:00",
      "alfst12" : "alfst12",
      "alfst11" : "alfst11",
      "idmediaCg99" : 5.726375546151009,
      "datast4" : "2000-01-23T04:56:07.000+00:00",
      "numst10" : 7.129168897240568,
      "datast3" : "2000-01-23T04:56:07.000+00:00",
      "numst11" : 6.370609851066415,
      "progRiga" : 2.008994665592807,
      "datast6" : "2000-01-23T04:56:07.000+00:00",
      "datast5" : "2000-01-23T04:56:07.000+00:00",
      "alfst4" : "alfst4",
      "alfst5" : "alfst5",
      "alfst6" : "alfst6",
      "alfst7" : "alfst7",
      "alfst8" : "alfst8",
      "alfst9" : "alfst9",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "alfst1" : "alfst1",
      "alfst2" : "alfst2",
      "alfst3" : "alfst3",
      "flgSt2" : 2.5524281586707875,
      "flgSt3" : 4.432841187680573,
      "flgSt4" : 3.5117904067536143,
      "numst8" : 9.007961177824221,
      "numst7" : 3.7846852362095262,
      "numst9" : 1.5743672347582194,
      "prog" : 4.863793115215697,
      "numst2" : 9.505836306729838,
      "numst1" : 7.464202015255506,
      "numst4" : 2.684056218962324,
      "dittaCg18" : 8.782449469456207,
      "numst3" : 8.768153453040833,
      "numst6" : 1.0046985756074744,
      "numst5" : 6.712603870693706,
      "indSt1" : 9.721046668148785,
      "indSt2" : 2.922265432447957,
      "flgSt1" : 0.4008378390304357
    }, {
      "alfst10" : "alfst10",
      "datast2" : "2000-01-23T04:56:07.000+00:00",
      "numst12" : 6.642953999458534,
      "datast1" : "2000-01-23T04:56:07.000+00:00",
      "alfst12" : "alfst12",
      "alfst11" : "alfst11",
      "idmediaCg99" : 5.726375546151009,
      "datast4" : "2000-01-23T04:56:07.000+00:00",
      "numst10" : 7.129168897240568,
      "datast3" : "2000-01-23T04:56:07.000+00:00",
      "numst11" : 6.370609851066415,
      "progRiga" : 2.008994665592807,
      "datast6" : "2000-01-23T04:56:07.000+00:00",
      "datast5" : "2000-01-23T04:56:07.000+00:00",
      "alfst4" : "alfst4",
      "alfst5" : "alfst5",
      "alfst6" : "alfst6",
      "alfst7" : "alfst7",
      "alfst8" : "alfst8",
      "alfst9" : "alfst9",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "alfst1" : "alfst1",
      "alfst2" : "alfst2",
      "alfst3" : "alfst3",
      "flgSt2" : 2.5524281586707875,
      "flgSt3" : 4.432841187680573,
      "flgSt4" : 3.5117904067536143,
      "numst8" : 9.007961177824221,
      "numst7" : 3.7846852362095262,
      "numst9" : 1.5743672347582194,
      "prog" : 4.863793115215697,
      "numst2" : 9.505836306729838,
      "numst1" : 7.464202015255506,
      "numst4" : 2.684056218962324,
      "dittaCg18" : 8.782449469456207,
      "numst3" : 8.768153453040833,
      "numst6" : 1.0046985756074744,
      "numst5" : 6.712603870693706,
      "indSt1" : 9.721046668148785,
      "indSt2" : 2.922265432447957,
      "flgSt1" : 0.4008378390304357
    } ],
    "causmagMg51" : 8.37823741034869,
    "cup" : "cup",
    "cig" : "cig",
    "codescl3Mg82" : "codescl3Mg82",
    "progvisuasta" : 5.6644160867523485,
    "rigaOrdine" : {
      "codTraclegdb" : "codTraclegdb",
      "dataconsint" : "2000-01-23T04:56:07.000+00:00",
      "datalancio" : "2000-01-23T04:56:07.000+00:00",
      "flgNonpiuev" : 9,
      "datainizlav" : "2000-01-23T04:56:07.000+00:00",
      "qta2trasfddtcl" : 4.318826475758856,
      "flgConsconf" : 7,
      "flgRicpreev" : 6,
      "collitrasfp" : 9.966789814889403,
      "progRiga" : 0.6895265584691002,
      "qta2lanc" : 0.29551818216563164,
      "qta2prel" : 0.7370530802760489,
      "collicons" : 8.780989965779524,
      "qta2trasfp" : 9.908114046741538,
      "codPiano" : "codPiano",
      "flgNosugg" : 1,
      "numpiano" : 7.375698277301938,
      "qta1prel" : 8.331741856019029,
      "datapianif" : "2000-01-23T04:56:07.000+00:00",
      "numregCo99" : "numregCo99",
      "qta1cons" : 3.5366534267201475,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datafineoap" : "2000-01-23T04:56:07.000+00:00",
      "flgSospriga" : 9,
      "numpropPd39" : 6.97635352548152,
      "qta1lanc" : 5.267310321293582,
      "contpcarPd79" : 9.748669620880193,
      "indStatodescsp" : 6,
      "qta1trasfddtcl" : 7.6528347060559,
      "flgNoevasparz" : 0,
      "ggtollercons" : 9.372628622067484,
      "qta2cons" : 8.223593720381889,
      "collitrasfddtcl" : 5.616380282218067,
      "indStatocons" : 6,
      "codTraclegwbs" : "codTraclegwbs",
      "datacons" : "2000-01-23T04:56:07.000+00:00",
      "valorecons" : 7.541803065493349,
      "dittaCg18" : 6.203595661339589,
      "indEvasdescsp" : 8,
      "qta1trasfp" : 9.120398275527268,
      "dataconsorig" : "2000-01-23T04:56:07.000+00:00",
      "datainizoap" : "2000-01-23T04:56:07.000+00:00",
      "progRigpiaPd80" : 9.290244967928562
    },
    "flgRitacc" : 3,
    "svar2" : "svar2",
    "codschedaMg42" : "codschedaMg42",
    "svar1" : "svar1",
    "capacita" : 5.312489704336296,
    "fatconvcf" : 5.877124706116695,
    "codescl2Mg82" : "codescl2Mg82",
    "colli" : 7.606863723092579,
    "codartcli" : "codartcli",
    "altezza" : 0.4182561061793122,
    "opzioneMg5e" : "opzioneMg5e",
    "stagioneMg5t" : 7,
    "scper1" : 3.8008573585058016,
    "indlisacqven" : 8,
    "qta2" : 5.7911894223693885,
    "scper2" : 1.0639121808530916,
    "scper3" : 3.2841216543560217,
    "scper4" : 9.785002165136461,
    "indlisfisso" : 4,
    "magper2" : 9.386524999783381,
    "qta1" : 4.372688051310086,
    "estdescart" : "estdescart",
    "codescl1Mg82" : "codescl1Mg82",
    "documentoRigaRateiMG" : {
      "flgDaav" : 0.11859130807119977,
      "dataregesinc" : "2000-01-23T04:56:07.000+00:00",
      "imprettcostobu" : 7.390706075830692,
      "imprettcostobuVal" : 1.0502890910539986,
      "importo" : 0.36062689002149373,
      "percforf" : 4.1661834558007,
      "adatacomp" : "2000-01-23T04:56:07.000+00:00",
      "indTipomovbu" : 2.0981949483881577,
      "dadatacomp" : "2000-01-23T04:56:07.000+00:00",
      "indTipocomp" : 6.176386745020588,
      "dittaCg18" : 6.918231485891953,
      "flgDisatcoge" : 4.637509675190766,
      "codBeneusato" : 7.88722683998926,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "contoparCg24" : "contoparCg24",
      "dataregesprec" : "2000-01-23T04:56:07.000+00:00"
    },
    "rigaPersonalizzata" : [ {
      "idmediaCg99" : 5.304373278797373,
      "progRiga" : 9.610516429629122,
      "datapers1" : "2000-01-23T04:56:07.000+00:00",
      "datapers2" : "2000-01-23T04:56:07.000+00:00",
      "alfpers9" : "alfpers9",
      "datapers3" : "2000-01-23T04:56:07.000+00:00",
      "datapers4" : "2000-01-23T04:56:07.000+00:00",
      "datapers5" : "2000-01-23T04:56:07.000+00:00",
      "datapers6" : "2000-01-23T04:56:07.000+00:00",
      "alfpers4" : "alfpers4",
      "indPers1" : 8.708394192403432,
      "alfpers3" : "alfpers3",
      "indPers2" : 0.8164256701298711,
      "alfpers2" : "alfpers2",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "alfpers1" : "alfpers1",
      "additionalData" : {
        "key" : ""
      },
      "alfpers8" : "alfpers8",
      "alfpers7" : "alfpers7",
      "alfpers6" : "alfpers6",
      "alfpers5" : "alfpers5",
      "numpers11" : 0.313237310471568,
      "numpers1" : 4.13177941962639,
      "numpers12" : 7.701777079007398,
      "numpers2" : 2.1871588311421153,
      "numpers3" : 0.05189710095898081,
      "numpers10" : 4.4580628783592156,
      "flgPers2" : 7.766860781935265,
      "numpers8" : 3.0659734456354117,
      "flgPers1" : 8.875589915795528,
      "numpers9" : 8.638367073739522,
      "numpers4" : 4.403697036782718,
      "numpers5" : 6.936499209818381,
      "flgPers4" : 6.720288821326667,
      "numpers6" : 4.035133329541982,
      "prog" : 5.948961008630453,
      "flgPers3" : 1.6056289151258096,
      "numpers7" : 2.1518888575299036,
      "dittaCg18" : 7.437703257022269,
      "alfpers10" : "alfpers10",
      "alfpers11" : "alfpers11",
      "alfpers12" : "alfpers12"
    }, {
      "idmediaCg99" : 5.304373278797373,
      "progRiga" : 9.610516429629122,
      "datapers1" : "2000-01-23T04:56:07.000+00:00",
      "datapers2" : "2000-01-23T04:56:07.000+00:00",
      "alfpers9" : "alfpers9",
      "datapers3" : "2000-01-23T04:56:07.000+00:00",
      "datapers4" : "2000-01-23T04:56:07.000+00:00",
      "datapers5" : "2000-01-23T04:56:07.000+00:00",
      "datapers6" : "2000-01-23T04:56:07.000+00:00",
      "alfpers4" : "alfpers4",
      "indPers1" : 8.708394192403432,
      "alfpers3" : "alfpers3",
      "indPers2" : 0.8164256701298711,
      "alfpers2" : "alfpers2",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "alfpers1" : "alfpers1",
      "additionalData" : {
        "key" : ""
      },
      "alfpers8" : "alfpers8",
      "alfpers7" : "alfpers7",
      "alfpers6" : "alfpers6",
      "alfpers5" : "alfpers5",
      "numpers11" : 0.313237310471568,
      "numpers1" : 4.13177941962639,
      "numpers12" : 7.701777079007398,
      "numpers2" : 2.1871588311421153,
      "numpers3" : 0.05189710095898081,
      "numpers10" : 4.4580628783592156,
      "flgPers2" : 7.766860781935265,
      "numpers8" : 3.0659734456354117,
      "flgPers1" : 8.875589915795528,
      "numpers9" : 8.638367073739522,
      "numpers4" : 4.403697036782718,
      "numpers5" : 6.936499209818381,
      "flgPers4" : 6.720288821326667,
      "numpers6" : 4.035133329541982,
      "prog" : 5.948961008630453,
      "flgPers3" : 1.6056289151258096,
      "numpers7" : 2.1518888575299036,
      "dittaCg18" : 7.437703257022269,
      "alfpers10" : "alfpers10",
      "alfpers11" : "alfpers11",
      "alfpers12" : "alfpers12"
    } ],
    "documentoRigaProvvigioniMG" : [ {
      "idagenteMg17" : 0,
      "percprov" : 9.456612101333725,
      "imporprov" : 4.943637496515336,
      "indRegprov" : 0.4867146239815201,
      "imponprov" : 7.3842318535314,
      "imponprovVal" : 6.749525837406151,
      "progRiga" : 9.721723570087065,
      "imporprovVal" : 0.30134145536422907,
      "dittaCg18" : 2.9679475177256287,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "flgVarprov" : 5.747795090145878,
      "additionalData" : {
        "key" : ""
      },
      "codiceAgente" : "codiceAgente"
    }, {
      "idagenteMg17" : 0,
      "percprov" : 9.456612101333725,
      "imporprov" : 4.943637496515336,
      "indRegprov" : 0.4867146239815201,
      "imponprov" : 7.3842318535314,
      "imponprovVal" : 6.749525837406151,
      "progRiga" : 9.721723570087065,
      "imporprovVal" : 0.30134145536422907,
      "dittaCg18" : 2.9679475177256287,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "flgVarprov" : 5.747795090145878,
      "additionalData" : {
        "key" : ""
      },
      "codiceAgente" : "codiceAgente"
    } ],
    "magper1" : 2.7977867356748476,
    "tara" : 9.402167524121316,
    "packaging" : {
      "umPeso" : "umPeso",
      "qta2Conf" : 7.273019311111276,
      "qta1Conf" : 8.250639315618633,
      "pesoLordo" : 3.8156682252305574,
      "umCapac" : "umCapac",
      "colliConf" : 3.196820582978078,
      "progRiga" : 5.573385265048522,
      "volume" : 2.4669941706755685,
      "umVolume" : "umVolume",
      "dittaCg18" : 5.296102445648278,
      "codConfezMg96" : "codConfezMg96",
      "capacita" : 2.026856458177285,
      "pzConf" : 3.0269458094096646,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "pesoNetto" : 1.9626702727164813
    },
    "rigaLotti" : [ {
      "cliforCg44" : 5.5569822283364845,
      "note" : "note",
      "flgNonpiuev" : 8.546645780823726,
      "codSscc" : "codSscc",
      "progMg4f" : 8.310924482277276,
      "tipocfCg44" : 4.757484754617172,
      "idmediaCg99" : 4.784107115651097,
      "codArtMg66" : "codArtMg66",
      "codDepMg58" : "codDepMg58",
      "codProgPd14" : "codProgPd14",
      "progRiga" : 7.886583288201395,
      "progRigarifDo30" : 1.4793631642421967,
      "codConfezMg96" : "codConfezMg96",
      "numregCo99" : "numregCo99",
      "qta1cons" : 1.8407572303125541,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codBagnomat" : "codBagnomat",
      "codArtpfMg66" : "codArtpfMg66",
      "codPallets" : "codPallets",
      "opzionepfMg5e" : "opzionepfMg5e",
      "opzioneMg5e" : "opzioneMg5e",
      "qta2" : 7.200147194425509,
      "codLottopfMg4g" : "codLottopfMg4g",
      "codLottoMg4g" : "codLottoMg4g",
      "sernum" : "sernum",
      "scadenza" : "2000-01-23T04:56:07.000+00:00",
      "anagraficaLotto" : {
        "note" : "note",
        "dittaCg18" : 4.754071900895484,
        "idmediaCg99" : 1.1864130338603074,
        "codArtMg66" : "codArtMg66",
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "codLotto" : "codLotto",
        "additionalData" : {
          "key" : ""
        },
        "datascad" : "2000-01-23T04:56:07.000+00:00",
        "lib1" : 3.8601930294054942,
        "desclotto" : "desclotto",
        "opzioneMg5e" : "opzioneMg5e"
      },
      "qta1" : 2.719219329469812,
      "qta2cons" : 7.135782839148426,
      "ubicazcollMg97" : "ubicazcollMg97",
      "progRifDo52" : 6.607129449620165,
      "prog" : 8.036294790673514,
      "parametroMovimentazioneLotto" : {
        "flgNote" : 4.5403315819302215,
        "dittaCg18" : 3.8581948879558317,
        "flgAggprogval" : 1.9732909296667345,
        "indGiacsca" : 8.262575023052213,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "prog" : 0.9178980228274691,
        "tipomov" : "tipomov"
      },
      "ubicazMg97" : "ubicazMg97",
      "sotprogPd14" : 1.0348002257634148,
      "dittaCg18" : 5.412786966532157,
      "numregrifCo99" : "numregrifCo99",
      "causmagMg51" : 2.60416377551006
    }, {
      "cliforCg44" : 5.5569822283364845,
      "note" : "note",
      "flgNonpiuev" : 8.546645780823726,
      "codSscc" : "codSscc",
      "progMg4f" : 8.310924482277276,
      "tipocfCg44" : 4.757484754617172,
      "idmediaCg99" : 4.784107115651097,
      "codArtMg66" : "codArtMg66",
      "codDepMg58" : "codDepMg58",
      "codProgPd14" : "codProgPd14",
      "progRiga" : 7.886583288201395,
      "progRigarifDo30" : 1.4793631642421967,
      "codConfezMg96" : "codConfezMg96",
      "numregCo99" : "numregCo99",
      "qta1cons" : 1.8407572303125541,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codBagnomat" : "codBagnomat",
      "codArtpfMg66" : "codArtpfMg66",
      "codPallets" : "codPallets",
      "opzionepfMg5e" : "opzionepfMg5e",
      "opzioneMg5e" : "opzioneMg5e",
      "qta2" : 7.200147194425509,
      "codLottopfMg4g" : "codLottopfMg4g",
      "codLottoMg4g" : "codLottoMg4g",
      "sernum" : "sernum",
      "scadenza" : "2000-01-23T04:56:07.000+00:00",
      "anagraficaLotto" : {
        "note" : "note",
        "dittaCg18" : 4.754071900895484,
        "idmediaCg99" : 1.1864130338603074,
        "codArtMg66" : "codArtMg66",
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "codLotto" : "codLotto",
        "additionalData" : {
          "key" : ""
        },
        "datascad" : "2000-01-23T04:56:07.000+00:00",
        "lib1" : 3.8601930294054942,
        "desclotto" : "desclotto",
        "opzioneMg5e" : "opzioneMg5e"
      },
      "qta1" : 2.719219329469812,
      "qta2cons" : 7.135782839148426,
      "ubicazcollMg97" : "ubicazcollMg97",
      "progRifDo52" : 6.607129449620165,
      "prog" : 8.036294790673514,
      "parametroMovimentazioneLotto" : {
        "flgNote" : 4.5403315819302215,
        "dittaCg18" : 3.8581948879558317,
        "flgAggprogval" : 1.9732909296667345,
        "indGiacsca" : 8.262575023052213,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "prog" : 0.9178980228274691,
        "tipomov" : "tipomov"
      },
      "ubicazMg97" : "ubicazMg97",
      "sotprogPd14" : 1.0348002257634148,
      "dittaCg18" : 5.412786966532157,
      "numregrifCo99" : "numregrifCo99",
      "causmagMg51" : 2.60416377551006
    } ],
    "coddepMg58" : "coddepMg58",
    "costotot" : 3.7814124730767915,
    "indtipoomag" : 0,
    "scper5" : 7.3718573971919445,
    "scper6" : 7.726998920545485,
    "indlisprior" : 0,
    "progrRiga" : 3.812761638325517,
    "lineaFa05" : "lineaFa05",
    "codartfor" : "codartfor",
    "numReg" : "numReg",
    "descart" : "descart",
    "alivacompCg28" : "alivacompCg28",
    "base" : 5.299143560275359,
    "scimp" : 5.974942028545841,
    "rigaRiferimenti" : [ {
      "flgNsdocbis" : 7.686670838404092,
      "qta2mov" : 0.05965928697733491,
      "flgNonpiuevpdc" : 7.321091499885957,
      "notevsdoc" : "notevsdoc",
      "seqfase" : 5.099298781640682,
      "datansdoc" : "2000-01-23T04:56:07.000+00:00",
      "indQtaordres" : 3,
      "seznsdoc" : "seznsdoc",
      "indStipodoc" : 0,
      "datansconf" : "2000-01-23T04:56:07.000+00:00",
      "datavsconf" : "2000-01-23T04:56:07.000+00:00",
      "progRiga" : 6.568304668801491,
      "valoremov" : 9.728706165995554,
      "progRigarifDo30" : 7.338782761819433,
      "progRigapadreDo30" : 1.4985931822280574,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "notensdoc" : "notensdoc",
      "progRif" : 2.3317418552851765,
      "rifvsdoc" : "rifvsdoc",
      "additionalData" : {
        "key" : ""
      },
      "numregpadreCo99" : "numregpadreCo99",
      "flgAggprescvar" : 7.964879197514727,
      "qta1mov" : 9.739448828157911,
      "collimov" : 9.140242185517025,
      "flgAggqtatrasf" : 4,
      "rifnsdoc" : "rifnsdoc",
      "fasePd12" : 4.39343993729625,
      "datavsdoc" : "2000-01-23T04:56:07.000+00:00",
      "indAggdocorigine" : 6.936593194494838,
      "progPdcDo65" : 4.075306827525243,
      "flgStornoqtaval" : 2,
      "numnsdoc" : 4.515863748649669,
      "dittaCg18" : 8.81377937009168,
      "indTipodoc" : 5,
      "numregrifCo99" : "numregrifCo99",
      "numvsdoc" : "numvsdoc",
      "progPdcrifDo65" : 2.674423984487264
    }, {
      "flgNsdocbis" : 7.686670838404092,
      "qta2mov" : 0.05965928697733491,
      "flgNonpiuevpdc" : 7.321091499885957,
      "notevsdoc" : "notevsdoc",
      "seqfase" : 5.099298781640682,
      "datansdoc" : "2000-01-23T04:56:07.000+00:00",
      "indQtaordres" : 3,
      "seznsdoc" : "seznsdoc",
      "indStipodoc" : 0,
      "datansconf" : "2000-01-23T04:56:07.000+00:00",
      "datavsconf" : "2000-01-23T04:56:07.000+00:00",
      "progRiga" : 6.568304668801491,
      "valoremov" : 9.728706165995554,
      "progRigarifDo30" : 7.338782761819433,
      "progRigapadreDo30" : 1.4985931822280574,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "notensdoc" : "notensdoc",
      "progRif" : 2.3317418552851765,
      "rifvsdoc" : "rifvsdoc",
      "additionalData" : {
        "key" : ""
      },
      "numregpadreCo99" : "numregpadreCo99",
      "flgAggprescvar" : 7.964879197514727,
      "qta1mov" : 9.739448828157911,
      "collimov" : 9.140242185517025,
      "flgAggqtatrasf" : 4,
      "rifnsdoc" : "rifnsdoc",
      "fasePd12" : 4.39343993729625,
      "datavsdoc" : "2000-01-23T04:56:07.000+00:00",
      "indAggdocorigine" : 6.936593194494838,
      "progPdcDo65" : 4.075306827525243,
      "flgStornoqtaval" : 2,
      "numnsdoc" : 4.515863748649669,
      "dittaCg18" : 8.81377937009168,
      "indTipodoc" : 5,
      "numregrifCo99" : "numregrifCo99",
      "numvsdoc" : "numvsdoc",
      "progPdcrifDo65" : 2.674423984487264
    } ]
  } ],
  "tipodocnumeraz" : 6.438423552598547,
  "lastchange" : "2000-01-23T04:56:07.000+00:00",
  "esclusioneIvaTestata" : 6,
  "testataEstesa" : [ {
    "alfst10" : "alfst10",
    "datast2" : "2000-01-23T04:56:07.000+00:00",
    "numst12" : 9.693372334146686,
    "datast1" : "2000-01-23T04:56:07.000+00:00",
    "alfst12" : "alfst12",
    "alfst11" : "alfst11",
    "idmediaCg99" : 6.677419970877656,
    "datast4" : "2000-01-23T04:56:07.000+00:00",
    "numst10" : 4.966567419166605,
    "datast3" : "2000-01-23T04:56:07.000+00:00",
    "numst11" : 2.9790233918904585,
    "datast6" : "2000-01-23T04:56:07.000+00:00",
    "datast5" : "2000-01-23T04:56:07.000+00:00",
    "alfst4" : "alfst4",
    "alfst5" : "alfst5",
    "alfst6" : "alfst6",
    "alfst7" : "alfst7",
    "alfst8" : "alfst8",
    "alfst9" : "alfst9",
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "alfst1" : "alfst1",
    "alfst2" : "alfst2",
    "alfst3" : "alfst3",
    "flgSt2" : 7.239590766928185,
    "flgSt3" : 6.090696483578148,
    "flgSt4" : 9.852147203726787,
    "numst8" : 4.851239691941878,
    "numst7" : 0.42286244411048224,
    "numst9" : 7.062107048540267,
    "prog" : 8.474710856151638,
    "numst2" : 2.6249013358703053,
    "numst1" : 5.083590215108117,
    "numst4" : 0.9619297253823988,
    "dittaCg18" : 8.018039914932286,
    "numst3" : 3.5742991213280972,
    "numst6" : 1.633699845078339,
    "numst5" : 7.224413148959403,
    "indSt1" : 1.2880645475702646,
    "indSt2" : 1.822577900073098,
    "flgSt1" : 2.6736395633233356
  }, {
    "alfst10" : "alfst10",
    "datast2" : "2000-01-23T04:56:07.000+00:00",
    "numst12" : 9.693372334146686,
    "datast1" : "2000-01-23T04:56:07.000+00:00",
    "alfst12" : "alfst12",
    "alfst11" : "alfst11",
    "idmediaCg99" : 6.677419970877656,
    "datast4" : "2000-01-23T04:56:07.000+00:00",
    "numst10" : 4.966567419166605,
    "datast3" : "2000-01-23T04:56:07.000+00:00",
    "numst11" : 2.9790233918904585,
    "datast6" : "2000-01-23T04:56:07.000+00:00",
    "datast5" : "2000-01-23T04:56:07.000+00:00",
    "alfst4" : "alfst4",
    "alfst5" : "alfst5",
    "alfst6" : "alfst6",
    "alfst7" : "alfst7",
    "alfst8" : "alfst8",
    "alfst9" : "alfst9",
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "alfst1" : "alfst1",
    "alfst2" : "alfst2",
    "alfst3" : "alfst3",
    "flgSt2" : 7.239590766928185,
    "flgSt3" : 6.090696483578148,
    "flgSt4" : 9.852147203726787,
    "numst8" : 4.851239691941878,
    "numst7" : 0.42286244411048224,
    "numst9" : 7.062107048540267,
    "prog" : 8.474710856151638,
    "numst2" : 2.6249013358703053,
    "numst1" : 5.083590215108117,
    "numst4" : 0.9619297253823988,
    "dittaCg18" : 8.018039914932286,
    "numst3" : 3.5742991213280972,
    "numst6" : 1.633699845078339,
    "numst5" : 7.224413148959403,
    "indSt1" : 1.2880645475702646,
    "indSt2" : 1.822577900073098,
    "flgSt1" : 2.6736395633233356
  } ]
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Get by ID with print document
 * Get an object of type corresponding the requested id and print it
 *
 * id String Id to get the object
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * reportname String Report name (optional)
 * dlevel String Serialization level (optional)
 * dlevelkey String Serialization level key (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns String
 **/
exports.apiV1EnvironmentMGDocumentoIdPrintGET = function(id,environment,authorizationScope,reportname,dlevel,dlevelkey,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = "";
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Get list of report names usable for the document
 * Get list of report names usable for the document
 *
 * id String Id to get the object
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns DocumentReportListResultDTO
 **/
exports.apiV1EnvironmentMGDocumentoIdPrintReportnameGET = function(id,environment,authorizationScope,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "documentReports" : [ {
    "path" : "path",
    "default" : 0,
    "reportName" : "reportName",
    "document" : "document",
    "description" : "description"
  }, {
    "path" : "path",
    "default" : 0,
    "reportName" : "reportName",
    "document" : "document",
    "description" : "description"
  } ]
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Create
 * Creating new object of type
 *
 * body DocumentoTestataMGDTO Object of type to create
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request (optional)
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns DocumentoTestataMGDTO
 **/
exports.apiV1EnvironmentMGDocumentoPOST = function(body,ignoreCompanyPolicyFilter,_op,force,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "totaliDocumento" : {
    "totalePagare" : 7.691531173686691,
    "scimpmerce" : 2.1184454156145116,
    "totspbolli" : 0.907335931343648,
    "acconto" : 2.7105647837031563,
    "ivaomag" : 8.776709848030322,
    "totaleCosto" : 9.660013839736129,
    "abbuono" : 5.799021278474435,
    "marginedocumento" : 9.576768325858186,
    "imponibomag" : 1.5673210879004595,
    "scimpcassa" : 5.473133728634785,
    "scpercassa2" : 3.93938484566677,
    "scpermerce3" : 9.616627406338315,
    "totdocumento" : 2.376630828418186,
    "scpercassa1" : 6.434791978928281,
    "scpermerce2" : 8.65952233326453,
    "scpermerce1" : 2.162514338057849,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "totimponibile" : 5.898513389775777,
    "totiva" : 2.4062866311545816,
    "totspinc" : 6.232321224432258
  },
  "callOptions" : {
    "flgLockOnDocExist" : false,
    "enableAdditionalValidations" : false,
    "flgSpincasForceZero" : false,
    "esclusioneAgentiMultipli" : false,
    "esclusioneSpeseTestiCliFor" : false,
    "flgSpbolliForceZero" : false,
    "disableLetterOfIntent" : false,
    "esclusioneIvaTestata" : false,
    "flgDisableItemControl" : false
  },
  "valutaCg08" : "valutaCg08",
  "flgSpbolli" : 1,
  "numdocorig" : "numdocorig",
  "codIva" : {
    "flgSospimp" : 1.633699845078339,
    "indNatura" : 8,
    "flgAgri" : 6.090696483578148,
    "tipologia" : 4.778706604314481,
    "percindet" : 6.389489858092311,
    "mossperc" : 5.305668385940959,
    "natureEsCO" : {
      "descr" : "descr",
      "codice" : "codice",
      "datainival" : "2000-01-23T04:56:07.000+00:00",
      "natureAssCO" : [ null, null ],
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "id" : 3,
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "verslynfa" : "verslynfa",
    "idExtendedAttributeEntity" : 0,
    "annotazioni" : "annotazioni",
    "rowVersion" : "",
    "indNatassoswCg2n" : 7,
    "perciva" : 5.201737367852583,
    "percforf" : 6.541917087228235,
    "codice" : "codice",
    "impostamonofasersm" : 4.851239691941878,
    "codiceOss" : "codiceOss",
    "extensionData" : [ null, null ],
    "stdcodivarifCg28" : "stdcodivarifCg28",
    "flgMossgest" : 3,
    "flgAutoue" : 1.2880645475702646,
    "flgIndet" : 2.9790233918904585,
    "codPlafond" : 7.239590766928185,
    "note" : "note",
    "flgAssport398" : 6.677419970877656,
    "flgMossrid" : 0,
    "indStaper" : 3.474156394106027,
    "flgAllclifor" : 9.852147203726787,
    "codiceagr" : "codiceagr",
    "flgImpostadibollo" : 4,
    "flgCorrVent" : 1.822577900073098,
    "aliqivavent" : 2.6736395633233356,
    "flgNotvar" : 7.224413148959403,
    "percmonofasersm" : 6.614319261836819,
    "idprov" : 0.42286244411048224,
    "idExtendedAttributeSubEntity" : 3,
    "natureAssCO" : {
      "descr" : "descr",
      "idCg2m" : 3,
      "idassosw" : 5,
      "codice" : "codice",
      "datainival" : "2000-01-23T04:56:07.000+00:00",
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "flgMonofasersm" : 2.6249013358703053,
    "mosscodCg07" : 6.711221582652969,
    "descrizione" : "descrizione",
    "flgEscludiblacklist" : 5.083590215108117,
    "flgIvaedit" : 9.693372334146686,
    "indtipopart" : 6.008900790410507
  },
  "bancaCg12" : 5.637376656633329,
  "ditta" : 2.027123023002322,
  "anagraficaDocumentoDitta" : {
    "indStaperMg36" : 6.027456183070403,
    "codDocumMg36" : "codDocumMg36",
    "dittaCg18" : 0.8008281904610115,
    "sezdefault" : "sezdefault",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    }
  },
  "testoletint" : "testoletint",
  "indfattpa" : 1,
  "sezautof" : "sezautof",
  "cliforfatt" : 9.301444243932576,
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "customerSupplierMG" : {
    "statoAttualeCO" : {
      "statiDisponibili" : [ null, null ],
      "statoCorrente" : {
        "indTipoStato" : 8,
        "idStato" : 2,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "seq" : 2
      },
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "contratto" : "contratto",
    "idCliFor" : 8,
    "idmediaCg99" : 7.740351818741173,
    "blackListGeneralMasterData" : {
      "datavalid" : "2000-01-23T04:56:07.000+00:00",
      "ragsofiscex" : "ragsofiscex",
      "addresses" : [ {
        "indirizzocomp2" : "indirizzocomp2",
        "addressesType" : [ {
          "tipo" : 6,
          "idCG1J" : 6,
          "pluginData" : {
            "key" : ""
          },
          "id" : 2,
          "additionalData" : {
            "key" : ""
          }
        }, {
          "tipo" : 6,
          "idCG1J" : 6,
          "pluginData" : {
            "key" : ""
          },
          "id" : 2,
          "additionalData" : {
            "key" : ""
          }
        } ],
        "risstato" : "risstato",
        "riszip" : "riszip",
        "pv" : "pv",
        "precisione" : "precisione",
        "codlinguaMg52" : "codlinguaMg52",
        "frazione" : "frazione",
        "emailPec" : "emailPec",
        "tipologia" : "tipologia",
        "via" : "via",
        "idTeamportal" : 6,
        "numciv" : "numciv",
        "cap" : "cap",
        "latitudine" : 3.5571952270680973,
        "statoCg07" : 1.284659006116532,
        "presso" : "presso",
        "federalStateViewCO" : {
          "descr" : "descr",
          "iso3166statofed" : "iso3166statofed",
          "a2iso3166Cg07" : "a2iso3166Cg07",
          "pluginData" : {
            "key" : ""
          },
          "codiceCg07" : 5.944895607614016,
          "additionalData" : {
            "key" : ""
          },
          "statofed" : "statofed"
        },
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "fax" : "fax",
        "statofed" : "statofed",
        "telefono" : "telefono",
        "datamod" : "2000-01-23T04:56:07.000+00:00",
        "email" : "email",
        "citta" : "citta",
        "ragsoc" : "ragsoc",
        "cellnum" : "cellnum",
        "comanaCg01" : "comanaCg01",
        "codiceCg16" : 8,
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "ragsocex" : "ragsocex",
        "rifindirizzo" : "rifindirizzo",
        "codicesfed" : "codicesfed",
        "contea" : "contea",
        "indirizzocomp" : "indirizzocomp",
        "riswarning" : "riswarning",
        "indirizzoex" : "indirizzoex",
        "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
        "risregione" : "risregione",
        "edificio" : "edificio",
        "statoEst" : {
          "codSian" : 3.353193347011243,
          "crtpiva" : "crtpiva",
          "leniban" : 6,
          "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
          "desiso3166" : "desiso3166",
          "idmediaCg99" : 0.8851374739011653,
          "codice" : 6.704019297950036,
          "numiso3166" : "numiso3166",
          "codiceCg08" : "codiceCg08",
          "currencyCO" : {
            "sigla" : "sigla",
            "dataattuem" : "2000-01-23T04:56:07.000+00:00",
            "numdec" : 7.04836565559697,
            "exchangeRateCO" : [ {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            }, {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            } ],
            "idmediaCg99" : 8.969578798196912,
            "codice" : "codice",
            "indCertoincerto" : 7,
            "cambiofisso" : 0.10263654006109402,
            "descr" : "descr",
            "flgValuem" : 4.652396432933246,
            "indValuem" : 3.0576100241049344,
            "indSepmigl" : 3.0205796992916243,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "descr" : "descr",
          "flgIban" : 3,
          "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
          "codIso" : "codIso",
          "a3iso3166" : "a3iso3166",
          "indTipostato" : 7.058770351582356,
          "a2iso3166" : "a2iso3166",
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "datacee" : "2000-01-23T04:56:07.000+00:00",
          "flgSepa" : 7
        },
        "longitudine" : 6.965117697638846,
        "indweb" : "indweb"
      }, {
        "indirizzocomp2" : "indirizzocomp2",
        "addressesType" : [ {
          "tipo" : 6,
          "idCG1J" : 6,
          "pluginData" : {
            "key" : ""
          },
          "id" : 2,
          "additionalData" : {
            "key" : ""
          }
        }, {
          "tipo" : 6,
          "idCG1J" : 6,
          "pluginData" : {
            "key" : ""
          },
          "id" : 2,
          "additionalData" : {
            "key" : ""
          }
        } ],
        "risstato" : "risstato",
        "riszip" : "riszip",
        "pv" : "pv",
        "precisione" : "precisione",
        "codlinguaMg52" : "codlinguaMg52",
        "frazione" : "frazione",
        "emailPec" : "emailPec",
        "tipologia" : "tipologia",
        "via" : "via",
        "idTeamportal" : 6,
        "numciv" : "numciv",
        "cap" : "cap",
        "latitudine" : 3.5571952270680973,
        "statoCg07" : 1.284659006116532,
        "presso" : "presso",
        "federalStateViewCO" : {
          "descr" : "descr",
          "iso3166statofed" : "iso3166statofed",
          "a2iso3166Cg07" : "a2iso3166Cg07",
          "pluginData" : {
            "key" : ""
          },
          "codiceCg07" : 5.944895607614016,
          "additionalData" : {
            "key" : ""
          },
          "statofed" : "statofed"
        },
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "fax" : "fax",
        "statofed" : "statofed",
        "telefono" : "telefono",
        "datamod" : "2000-01-23T04:56:07.000+00:00",
        "email" : "email",
        "citta" : "citta",
        "ragsoc" : "ragsoc",
        "cellnum" : "cellnum",
        "comanaCg01" : "comanaCg01",
        "codiceCg16" : 8,
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "ragsocex" : "ragsocex",
        "rifindirizzo" : "rifindirizzo",
        "codicesfed" : "codicesfed",
        "contea" : "contea",
        "indirizzocomp" : "indirizzocomp",
        "riswarning" : "riswarning",
        "indirizzoex" : "indirizzoex",
        "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
        "risregione" : "risregione",
        "edificio" : "edificio",
        "statoEst" : {
          "codSian" : 3.353193347011243,
          "crtpiva" : "crtpiva",
          "leniban" : 6,
          "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
          "desiso3166" : "desiso3166",
          "idmediaCg99" : 0.8851374739011653,
          "codice" : 6.704019297950036,
          "numiso3166" : "numiso3166",
          "codiceCg08" : "codiceCg08",
          "currencyCO" : {
            "sigla" : "sigla",
            "dataattuem" : "2000-01-23T04:56:07.000+00:00",
            "numdec" : 7.04836565559697,
            "exchangeRateCO" : [ {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            }, {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            } ],
            "idmediaCg99" : 8.969578798196912,
            "codice" : "codice",
            "indCertoincerto" : 7,
            "cambiofisso" : 0.10263654006109402,
            "descr" : "descr",
            "flgValuem" : 4.652396432933246,
            "indValuem" : 3.0576100241049344,
            "indSepmigl" : 3.0205796992916243,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "descr" : "descr",
          "flgIban" : 3,
          "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
          "codIso" : "codIso",
          "a3iso3166" : "a3iso3166",
          "indTipostato" : 7.058770351582356,
          "a2iso3166" : "a2iso3166",
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "datacee" : "2000-01-23T04:56:07.000+00:00",
          "flgSepa" : 7
        },
        "longitudine" : 6.965117697638846,
        "indweb" : "indweb"
      } ],
      "codiceident" : "codiceident",
      "indirCorEX" : "indirCorEX",
      "flgFattpa" : 7,
      "indirizzo" : "indirizzo",
      "ragsoanagex" : "ragsoanagex",
      "codiceCg07" : 7.061401241503109,
      "indsoggrit" : 7.457744773683766,
      "ragSoAnag" : "ragSoAnag",
      "capcor" : "capcor",
      "cittafisc" : "cittafisc",
      "intragroupStructureCO" : {
        "descr" : "descr",
        "codice" : 7.260521264802104,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "codAnagGen" : 4,
        "codIntercompany" : 9
      },
      "statofiscCg07" : 5.025004791520295,
      "tel2num" : "tel2num",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codfiscale" : "codfiscale",
      "statofed" : "statofed",
      "codrichiamo" : 2,
      "provfisc" : "provfisc",
      "idExtendedAttributeEntity" : 9,
      "citta" : "citta",
      "statonascitaCg07" : 9.965781217890562,
      "codice" : 2,
      "indFiscale" : "indFiscale",
      "nome" : "nome",
      "comnascitaCg01" : "comnascitaCg01",
      "codiceCg15" : "codiceCg15",
      "extensionData" : [ {
        "value" : "",
        "key" : "key"
      }, {
        "value" : "",
        "key" : "key"
      } ],
      "ragsofisc" : "ragsofisc",
      "indemail" : "indemail",
      "indirizzoEX" : "indirizzoEX",
      "comfisCg01" : "comfisCg01",
      "comnascita" : "comnascita",
      "partiva" : "partiva",
      "flgNoblacklist" : 1.2315135367772556,
      "partivaEst" : "partivaEst",
      "cognome" : "cognome",
      "idmediaCg99" : 6.84685269835264,
      "wtCodeCO" : {
        "causdd1" : "causdd1",
        "codNonsog" : 0.8774076871421566,
        "flgRegagevo" : 4.86315908102884,
        "idmediaCg99" : 3.901545264248647,
        "percRipPerc" : 1.8268702177058116,
        "flgRitImposta" : 6.073898085781152,
        "codPrev" : "codPrev",
        "tiporapporto" : "tiporapporto",
        "percripaz" : 9.254183946267839,
        "pluginData" : {
          "key" : ""
        },
        "flgPignTerzi" : 7.933506881737151,
        "flgProteo360" : 5.507386964179881,
        "additionalData" : {
          "key" : ""
        },
        "flgGlad" : 9.702963800023566,
        "codFiscPrev" : "codFiscPrev",
        "gcprev" : 4,
        "idprov" : 0.43431398824148815,
        "codice" : "codice",
        "percci" : 4.573936264232251,
        "flgSosprit" : 8,
        "descr" : "descr",
        "flgMinimi" : 0,
        "codTributo" : "codTributo",
        "indCodattglad" : 2.9409642974827896,
        "indTipocassa" : 1,
        "percra" : 8.863729185622827,
        "percbaseimp" : 6.623518433804886,
        "codTribrp" : "codTribrp",
        "inpsivs" : 8.28965939814297,
        "rowversion" : ""
      },
      "dtiniziopec" : "2000-01-23T04:56:07.000+00:00",
      "capfisc" : "capfisc",
      "codicecorCg07" : 3.616076749251911,
      "codiceCgc0" : 9.301444243932576,
      "cap" : "cap",
      "faxnum" : "faxnum",
      "alias" : "alias",
      "flgOmonimo" : 1.0246457001441578,
      "provnascita" : "provnascita",
      "ragsocor" : "ragsocor",
      "prov" : "prov",
      "flgAnagval" : 4.145608029883936,
      "rapazestCg16" : 1,
      "cellnum" : "cellnum",
      "flgPrsfis" : 1.4894159098541704,
      "tel1num" : "tel1num",
      "idExtendedAttributeSubEntity" : 6,
      "provcor" : "provcor",
      "dtfinepec" : "2000-01-23T04:56:07.000+00:00",
      "cittacor" : "cittacor",
      "codicesfed" : "codicesfed",
      "statofedfisc" : "statofedfisc",
      "indFiscaleEX" : "indFiscaleEX",
      "partitaIVA" : "partitaIVA",
      "indirCor" : "indirCor",
      "sesso" : 4.965218492984954,
      "lastchange" : "2000-01-23T04:56:07.000+00:00",
      "ragsocorex" : "ragsocorex",
      "datanascita" : "2000-01-23T04:56:07.000+00:00",
      "auidAu04" : 5,
      "indweb" : "indweb"
    },
    "goods" : {
      "reverseTypeFI" : {
        "reverseTypeCode" : 0,
        "reverseTypeDescription" : "reverseTypeDescription",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "flgBilconsattpassdist" : 0,
      "contochiu" : "contochiu",
      "flgAnalit" : 5,
      "codeformatted" : "codeformatted",
      "intragroupStructureCO" : {
        "descr" : "descr",
        "codice" : 7.260521264802104,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "codAnagGen" : 4,
        "codIntercompany" : 9
      },
      "flgAggfatt" : 8,
      "indLivchius" : 3,
      "idcontoratattCg24" : 6,
      "idcontoapeCg24" : 8,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "contocrsosp" : "contocrsosp",
      "flgContoimm" : 1,
      "flgOpnonfin" : 5.547564904556697,
      "indDaavec" : 3,
      "cogeprogeMateriali" : 2,
      "coaAccountCustomizationFI" : [ {
        "descr" : "descr",
        "iddespcon" : 6,
        "dittaCg18" : 5.616380282218067,
        "contoCg24" : "contoCg24",
        "idmediaCg99" : 7.014147440046284,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "gruppoCg10" : 9.966789814889403,
        "idCg24" : 9,
        "rowversion" : ""
      }, {
        "descr" : "descr",
        "iddespcon" : 6,
        "dittaCg18" : 5.616380282218067,
        "contoCg24" : "contoCg24",
        "idmediaCg99" : 7.014147440046284,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "gruppoCg10" : 9.966789814889403,
        "idCg24" : 9,
        "rowversion" : ""
      } ],
      "accountType" : 9,
      "contoratpass" : "contoratpass",
      "descr" : "descr",
      "idcontorisattCg24" : 1,
      "indDaav" : 1,
      "suddconti" : 8.780989965779524,
      "contoratatt" : "contoratatt",
      "indMastroCliFor" : 1.9732909296667345,
      "idcontochiuCg24" : 8,
      "percindetra" : 0.9178980228274691,
      "codiceCg22" : 4.863793115215697,
      "indAttpasspor" : 1,
      "indTipoconto" : 4,
      "contoape" : "contoape",
      "flgGespor" : 2,
      "cogeprogeAbil" : 2,
      "flgSaldog" : 5,
      "percindeduc" : 8.262575023052213,
      "contorisatt" : "contorisatt",
      "codiceCgc0" : 2.008994665592807,
      "flgValutaest" : 5,
      "flgRaganal" : 9,
      "alias" : "alias",
      "conto" : "conto",
      "balanceSheetAccountCategory" : 1,
      "cogeprogeNodo" : 6,
      "contorispass" : "contorispass",
      "indContoricav" : 4,
      "vatTypeFI" : {
        "descr" : "descr",
        "indAutofattura" : 7,
        "agviaggio" : 0,
        "codice" : 4.318826475758856,
        "pluginData" : {
          "key" : ""
        },
        "localizzazione" : 8,
        "additionalData" : {
          "key" : ""
        },
        "codiceCg0d" : 9.908114046741538,
        "indTipo" : 7.437703257022269
      },
      "idcontorispassCg24" : 2,
      "cogeprogeAttivita" : 8,
      "flgGesec" : 8,
      "coaInternationalCustomizationFI" : [ {
        "contoCg24" : "contoCg24",
        "subcategoria" : 8,
        "categoria" : 3,
        "gbDeferralcode" : "gbDeferralcode",
        "esModulo347" : 5,
        "pluginData" : {
          "key" : ""
        },
        "id" : 7,
        "iso3166A2" : "iso3166A2",
        "additionalData" : {
          "key" : ""
        },
        "gruppoCg10" : 8.331741856019029,
        "idCg24" : 9,
        "rowversion" : ""
      }, {
        "contoCg24" : "contoCg24",
        "subcategoria" : 8,
        "categoria" : 3,
        "gbDeferralcode" : "gbDeferralcode",
        "esModulo347" : 5,
        "pluginData" : {
          "key" : ""
        },
        "id" : 7,
        "iso3166A2" : "iso3166A2",
        "additionalData" : {
          "key" : ""
        },
        "gruppoCg10" : 8.331741856019029,
        "idCg24" : 9,
        "rowversion" : ""
      } ],
      "gruppoCg10" : 8.546645780823726,
      "coaAccountStateFI" : [ {
        "consosCg24" : "consosCg24",
        "dittaCg18" : 0.8972273556195443,
        "dtdisatt" : "2000-01-23T04:56:07.000+00:00",
        "grusosCg10" : 1.7692392591014339,
        "pluginData" : {
          "key" : ""
        },
        "idstatipdc" : 9,
        "additionalData" : {
          "key" : ""
        },
        "dtconsos" : "2000-01-23T04:56:07.000+00:00",
        "flgDisatt" : 9.684087197655908,
        "idCg24" : 6,
        "rowversion" : ""
      }, {
        "consosCg24" : "consosCg24",
        "dittaCg18" : 0.8972273556195443,
        "dtdisatt" : "2000-01-23T04:56:07.000+00:00",
        "grusosCg10" : 1.7692392591014339,
        "pluginData" : {
          "key" : ""
        },
        "idstatipdc" : 9,
        "additionalData" : {
          "key" : ""
        },
        "dtconsos" : "2000-01-23T04:56:07.000+00:00",
        "flgDisatt" : 9.684087197655908,
        "idCg24" : 6,
        "rowversion" : ""
      } ],
      "coaGroupCodeFI" : {
        "descr" : "descr",
        "numlivcons" : 6.460213024504889,
        "gruppo" : 8.289598895249666,
        "numlivelli" : 6.8668894011844035,
        "accountProposals" : [ {
          "contoCg24" : "contoCg24",
          "codice" : 7.375698277301938,
          "pluginData" : {
            "key" : ""
          },
          "id" : 0,
          "additionalData" : {
            "key" : ""
          },
          "gruppoCg10" : 6.97635352548152,
          "idCg24" : 9,
          "rowversion" : ""
        }, {
          "contoCg24" : "contoCg24",
          "codice" : 7.375698277301938,
          "pluginData" : {
            "key" : ""
          },
          "id" : 0,
          "additionalData" : {
            "key" : ""
          },
          "gruppoCg10" : 6.97635352548152,
          "idCg24" : 9,
          "rowversion" : ""
        } ],
        "pluginData" : {
          "key" : ""
        },
        "maskedit" : "maskedit",
        "additionalData" : {
          "key" : ""
        },
        "flgPdclib" : 9,
        "rowversion" : ""
      },
      "idparent" : 1,
      "idreverse" : 7,
      "flgIntercompany" : 8,
      "idcontoratpassCg24" : 7,
      "flgRarp" : 2,
      "idconto" : 4,
      "cogeprogeSpese" : 5,
      "idRifPdC80" : 7,
      "indCosvend" : 4
    },
    "flgAttivo" : 0.8851374739011653,
    "tipocfCg40" : 5.533258397034986,
    "dmsPublishedEntityFW" : {
      "tipoarchHm30" : 2,
      "idknos" : 6,
      "dittaCg18" : 1.0046985756074744,
      "flgInvalid" : 3,
      "datapub" : "2000-01-23T04:56:07.000+00:00",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "protocollo" : "protocollo",
      "nome" : "nome",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "publicationid" : "publicationid",
      "percorso" : "percorso"
    },
    "officeCO" : {
      "indIrizzo" : "indIrizzo",
      "idmediaCg99" : 6.720288821326667,
      "codice" : 7.766860781935265,
      "indDimcentrocomm" : 5.304373278797373,
      "cap" : "cap",
      "dittaCg18" : 1.6056289151258096,
      "progRea" : 8.708394192403432,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "prov" : "prov",
      "numerorea" : "numerorea",
      "citta" : "citta",
      "rowversion" : ""
    },
    "flgInterCompany" : 6.519180951018382,
    "paymentTermCO" : {
      "flgDesc" : 0.8164256701298711,
      "paymentTermDetailCO" : [ {
        "indImpfix" : 1.4985931822280574,
        "daggfix1" : 9.140242185517025,
        "daggfix2" : 8.81377937009168,
        "ggmmfix" : 3.8463127686084055,
        "ggdecor" : 6.936593194494838,
        "idCg64" : 2,
        "imporfix" : 2.3317418552851765,
        "flgFrperciva" : 2.408218941758913,
        "idCg62" : 4,
        "pluginData" : {
          "key" : ""
        },
        "id" : 4,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 7.321091499885957,
        "indTipocalend" : 7,
        "indTipodecor" : 9.739448828157911,
        "aggfix2" : 9.610516429629122,
        "aggfix1" : 5.948961008630453,
        "perciva" : 5.099298781640682,
        "el2frimp" : 4.180725413706508,
        "ggscadfix2" : 5.103912736584151,
        "tipoeff" : 3.3182952910080674,
        "flgFrpercimp" : 7.686670838404092,
        "percimp" : 0.05965928697733491,
        "prog" : 9.728706165995554,
        "el1frimp" : 4.39343993729625,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 0.6052866655822231,
        "subTypeCO" : {
          "ggoffset" : 9.629537564416708,
          "codiceCg07" : 8.50835276411088,
          "tipoeff" : 0.391063602337155,
          "codPaguc" : "codPaguc",
          "descstipo" : "descstipo",
          "codStipoeff" : 9.551762125042277,
          "flgAssegno" : 5,
          "indModfatturapa" : 2,
          "nationCO" : {
            "codSian" : 3.353193347011243,
            "crtpiva" : "crtpiva",
            "leniban" : 6,
            "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
            "desiso3166" : "desiso3166",
            "idmediaCg99" : 0.8851374739011653,
            "codice" : 6.704019297950036,
            "numiso3166" : "numiso3166",
            "codiceCg08" : "codiceCg08",
            "currencyCO" : {
              "sigla" : "sigla",
              "dataattuem" : "2000-01-23T04:56:07.000+00:00",
              "numdec" : 7.04836565559697,
              "exchangeRateCO" : [ {
                "cambio" : 4.078845849666752,
                "anno" : 3.2588565619047607,
                "idmediaCg99" : 6.628464275087742,
                "codiceCg08" : "codiceCg08",
                "indCertoincerto" : 4,
                "codicerifCg08" : "codicerifCg08",
                "giorno" : 0.2025324113236393,
                "mese" : 1.041444916118296,
                "pluginData" : {
                  "key" : ""
                },
                "additionalData" : {
                  "key" : ""
                },
                "adegcambio" : 5.533258397034986,
                "rowversion" : ""
              }, {
                "cambio" : 4.078845849666752,
                "anno" : 3.2588565619047607,
                "idmediaCg99" : 6.628464275087742,
                "codiceCg08" : "codiceCg08",
                "indCertoincerto" : 4,
                "codicerifCg08" : "codicerifCg08",
                "giorno" : 0.2025324113236393,
                "mese" : 1.041444916118296,
                "pluginData" : {
                  "key" : ""
                },
                "additionalData" : {
                  "key" : ""
                },
                "adegcambio" : 5.533258397034986,
                "rowversion" : ""
              } ],
              "idmediaCg99" : 8.969578798196912,
              "codice" : "codice",
              "indCertoincerto" : 7,
              "cambiofisso" : 0.10263654006109402,
              "descr" : "descr",
              "flgValuem" : 4.652396432933246,
              "indValuem" : 3.0576100241049344,
              "indSepmigl" : 3.0205796992916243,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              }
            },
            "descr" : "descr",
            "flgIban" : 3,
            "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
            "codIso" : "codIso",
            "a3iso3166" : "a3iso3166",
            "indTipostato" : 7.058770351582356,
            "a2iso3166" : "a2iso3166",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "datacee" : "2000-01-23T04:56:07.000+00:00",
            "flgSepa" : 7
          },
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 1,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 4,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 7.964879197514727,
        "indDatarif" : 6.568304668801491,
        "rowversion" : ""
      }, {
        "indImpfix" : 1.4985931822280574,
        "daggfix1" : 9.140242185517025,
        "daggfix2" : 8.81377937009168,
        "ggmmfix" : 3.8463127686084055,
        "ggdecor" : 6.936593194494838,
        "idCg64" : 2,
        "imporfix" : 2.3317418552851765,
        "flgFrperciva" : 2.408218941758913,
        "idCg62" : 4,
        "pluginData" : {
          "key" : ""
        },
        "id" : 4,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 7.321091499885957,
        "indTipocalend" : 7,
        "indTipodecor" : 9.739448828157911,
        "aggfix2" : 9.610516429629122,
        "aggfix1" : 5.948961008630453,
        "perciva" : 5.099298781640682,
        "el2frimp" : 4.180725413706508,
        "ggscadfix2" : 5.103912736584151,
        "tipoeff" : 3.3182952910080674,
        "flgFrpercimp" : 7.686670838404092,
        "percimp" : 0.05965928697733491,
        "prog" : 9.728706165995554,
        "el1frimp" : 4.39343993729625,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 0.6052866655822231,
        "subTypeCO" : {
          "ggoffset" : 9.629537564416708,
          "codiceCg07" : 8.50835276411088,
          "tipoeff" : 0.391063602337155,
          "codPaguc" : "codPaguc",
          "descstipo" : "descstipo",
          "codStipoeff" : 9.551762125042277,
          "flgAssegno" : 5,
          "indModfatturapa" : 2,
          "nationCO" : {
            "codSian" : 3.353193347011243,
            "crtpiva" : "crtpiva",
            "leniban" : 6,
            "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
            "desiso3166" : "desiso3166",
            "idmediaCg99" : 0.8851374739011653,
            "codice" : 6.704019297950036,
            "numiso3166" : "numiso3166",
            "codiceCg08" : "codiceCg08",
            "currencyCO" : {
              "sigla" : "sigla",
              "dataattuem" : "2000-01-23T04:56:07.000+00:00",
              "numdec" : 7.04836565559697,
              "exchangeRateCO" : [ {
                "cambio" : 4.078845849666752,
                "anno" : 3.2588565619047607,
                "idmediaCg99" : 6.628464275087742,
                "codiceCg08" : "codiceCg08",
                "indCertoincerto" : 4,
                "codicerifCg08" : "codicerifCg08",
                "giorno" : 0.2025324113236393,
                "mese" : 1.041444916118296,
                "pluginData" : {
                  "key" : ""
                },
                "additionalData" : {
                  "key" : ""
                },
                "adegcambio" : 5.533258397034986,
                "rowversion" : ""
              }, {
                "cambio" : 4.078845849666752,
                "anno" : 3.2588565619047607,
                "idmediaCg99" : 6.628464275087742,
                "codiceCg08" : "codiceCg08",
                "indCertoincerto" : 4,
                "codicerifCg08" : "codicerifCg08",
                "giorno" : 0.2025324113236393,
                "mese" : 1.041444916118296,
                "pluginData" : {
                  "key" : ""
                },
                "additionalData" : {
                  "key" : ""
                },
                "adegcambio" : 5.533258397034986,
                "rowversion" : ""
              } ],
              "idmediaCg99" : 8.969578798196912,
              "codice" : "codice",
              "indCertoincerto" : 7,
              "cambiofisso" : 0.10263654006109402,
              "descr" : "descr",
              "flgValuem" : 4.652396432933246,
              "indValuem" : 3.0576100241049344,
              "indSepmigl" : 3.0205796992916243,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              }
            },
            "descr" : "descr",
            "flgIban" : 3,
            "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
            "codIso" : "codIso",
            "a3iso3166" : "a3iso3166",
            "indTipostato" : 7.058770351582356,
            "a2iso3166" : "a2iso3166",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "datacee" : "2000-01-23T04:56:07.000+00:00",
            "flgSepa" : 7
          },
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 1,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 4,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 7.964879197514727,
        "indDatarif" : 6.568304668801491,
        "rowversion" : ""
      } ],
      "codPag" : "codPag",
      "desPagAnal" : "desPagAnal",
      "flgDisgg" : 4.13177941962639,
      "flgPrefpass" : 0,
      "idExtendedAttributeSubEntity" : 8,
      "flgPrefatt" : 4,
      "flgStornoiva" : 7.701777079007398,
      "descPag" : "descPag",
      "extensionData" : [ {
        "value" : "",
        "key" : "key"
      }, {
        "value" : "",
        "key" : "key"
      } ],
      "scpermer2" : 2.1518888575299036,
      "pluginData" : {
        "key" : ""
      },
      "id" : 2,
      "scpercas" : 6.936499209818381,
      "scpermer1" : 4.035133329541982,
      "additionalData" : {
        "key" : ""
      },
      "scpercart26" : 4.403697036782718,
      "idExtendedAttributeEntity" : 3,
      "rowversion" : "",
      "scart26" : 0.05189710095898081
    },
    "progrEf08" : 3.0576100241049344,
    "tipoCf" : 7.04836565559697,
    "pluginData" : {
      "key" : ""
    },
    "cliFor" : 3.353193347011243,
    "additionalData" : {
      "key" : ""
    },
    "ggScadFix" : 0.10263654006109402,
    "idExtendedAttributeEntity" : 3,
    "idExtendedAttributeSubEntity" : 4,
    "flgCointestati" : 7.058770351582356,
    "gruppoCg10" : 4.652396432933246,
    "currencyCO" : {
      "sigla" : "sigla",
      "dataattuem" : "2000-01-23T04:56:07.000+00:00",
      "numdec" : 7.04836565559697,
      "exchangeRateCO" : [ {
        "cambio" : 4.078845849666752,
        "anno" : 3.2588565619047607,
        "idmediaCg99" : 6.628464275087742,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 4,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 0.2025324113236393,
        "mese" : 1.041444916118296,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 5.533258397034986,
        "rowversion" : ""
      }, {
        "cambio" : 4.078845849666752,
        "anno" : 3.2588565619047607,
        "idmediaCg99" : 6.628464275087742,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 4,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 0.2025324113236393,
        "mese" : 1.041444916118296,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 5.533258397034986,
        "rowversion" : ""
      } ],
      "idmediaCg99" : 8.969578798196912,
      "codice" : "codice",
      "indCertoincerto" : 7,
      "cambiofisso" : 0.10263654006109402,
      "descr" : "descr",
      "flgValuem" : 4.652396432933246,
      "indValuem" : 3.0576100241049344,
      "indSepmigl" : 3.0205796992916243,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "vatCodeCO" : {
      "flgSospimp" : 1.633699845078339,
      "indNatura" : 8,
      "flgAgri" : 6.090696483578148,
      "tipologia" : 4.778706604314481,
      "percindet" : 6.389489858092311,
      "mossperc" : 5.305668385940959,
      "natureEsCO" : {
        "descr" : "descr",
        "codice" : "codice",
        "datainival" : "2000-01-23T04:56:07.000+00:00",
        "natureAssCO" : [ null, null ],
        "datafineval" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "id" : 3,
        "additionalData" : {
          "key" : ""
        },
        "rowversion" : ""
      },
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "verslynfa" : "verslynfa",
      "idExtendedAttributeEntity" : 0,
      "annotazioni" : "annotazioni",
      "rowVersion" : "",
      "indNatassoswCg2n" : 7,
      "perciva" : 5.201737367852583,
      "percforf" : 6.541917087228235,
      "codice" : "codice",
      "impostamonofasersm" : 4.851239691941878,
      "codiceOss" : "codiceOss",
      "extensionData" : [ null, null ],
      "stdcodivarifCg28" : "stdcodivarifCg28",
      "flgMossgest" : 3,
      "flgAutoue" : 1.2880645475702646,
      "flgIndet" : 2.9790233918904585,
      "codPlafond" : 7.239590766928185,
      "note" : "note",
      "flgAssport398" : 6.677419970877656,
      "flgMossrid" : 0,
      "indStaper" : 3.474156394106027,
      "flgAllclifor" : 9.852147203726787,
      "codiceagr" : "codiceagr",
      "flgImpostadibollo" : 4,
      "flgCorrVent" : 1.822577900073098,
      "aliqivavent" : 2.6736395633233356,
      "flgNotvar" : 7.224413148959403,
      "percmonofasersm" : 6.614319261836819,
      "idprov" : 0.42286244411048224,
      "idExtendedAttributeSubEntity" : 3,
      "natureAssCO" : {
        "descr" : "descr",
        "idCg2m" : 3,
        "idassosw" : 5,
        "codice" : "codice",
        "datainival" : "2000-01-23T04:56:07.000+00:00",
        "datafineval" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "rowversion" : ""
      },
      "flgMonofasersm" : 2.6249013358703053,
      "mosscodCg07" : 6.711221582652969,
      "descrizione" : "descrizione",
      "flgEscludiblacklist" : 5.083590215108117,
      "flgIvaedit" : 9.693372334146686,
      "indtipopart" : 6.008900790410507
    },
    "extensionData" : [ null, null ],
    "classificationData" : {
      "cliforCg44" : 0.2025324113236393,
      "indarrinfat" : 4.573936264232251,
      "indprefstdoc" : 5.299143560275359,
      "notes" : [ {
        "cliforCg44" : 0.30134145536422907,
        "note" : "note",
        "dittaCg18" : 0.4867146239815201,
        "tipocfCg44" : 7.88722683998926,
        "idmediaCg99" : 9.456612101333725,
        "destiponote" : "destiponote",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "prog" : 9.721723570087065
      }, {
        "cliforCg44" : 0.30134145536422907,
        "note" : "note",
        "dittaCg18" : 0.4867146239815201,
        "tipocfCg44" : 7.88722683998926,
        "idmediaCg99" : 9.456612101333725,
        "destiponote" : "destiponote",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "prog" : 9.721723570087065
      } ],
      "sc2percor" : 0.4768402382624515,
      "codrifnum" : 6.628464275087742,
      "grouping1CO" : {
        "dittaCg18" : 3.209082285545927,
        "codRaggrcf1" : "codRaggrcf1",
        "descraggrcf1" : "descraggrcf1",
        "idprov" : 2,
        "idmediaCg99" : 8.262795412896967,
        "tipocf" : 9.146339979307802,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "language" : {
        "iso639" : "iso639",
        "idmediaCg99" : 2.9679475177256287,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "descrlingua" : "descrlingua",
        "codLingua" : "codLingua",
        "siglalingua" : "siglalingua"
      },
      "irs1099" : "irs1099",
      "ggcons" : 2.9409642974827896,
      "flgesclspepor" : 0.5199002018724985,
      "grouping3CO" : {
        "codRaggrcf3" : "codRaggrcf3",
        "descraggrcf3" : "descraggrcf3",
        "dittaCg18" : 8.910869026866926,
        "idprov" : 6,
        "idmediaCg99" : 2.058822123984536,
        "tipocf" : 0.8411762798681321,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "datiAccompagnamento" : {
        "cliforCg44" : 4.8789878742268815,
        "vett1Mg14" : "vett1Mg14",
        "imballoMg95" : "imballoMg95",
        "tipocfCg44" : 1.3949519358941398,
        "idmediaCg99" : 9.806951670467935,
        "portoMg91" : "portoMg91",
        "vett2Mg14" : "vett2Mg14",
        "aspettoMg99" : "aspettoMg99",
        "dittaCg18" : 6.966044574347761,
        "spedizMg15" : "spedizMg15",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "tipospedMg93" : "tipospedMg93"
      },
      "tipoclxdoc" : 0.4833312865174044,
      "priceListSalePurchase" : {
        "desclist" : "desclist",
        "numlist" : 4.637509675190766,
        "valutaCg08" : "valutaCg08",
        "dittaCg18" : 6.918231485891953,
        "flgVenacq" : 0.11859130807119977,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "coddocumMg3g" : "coddocumMg3g",
      "indtestof2" : "0",
      "impdaarrot" : 6.623518433804886,
      "indtestof1" : 3.7814124730767915,
      "pluginData" : {
        "key" : ""
      },
      "flgrottsingdoc" : 8.251625748923757,
      "scimpcor" : 3.804112695731078,
      "additionalData" : {
        "key" : ""
      },
      "dataultord" : "2000-01-23T04:56:07.000+00:00",
      "flgTaxliable" : 0,
      "flgspbol" : 4.459605034958679,
      "magpercor" : 5.877124706116695,
      "taxexemptionno" : "taxexemptionno",
      "scaglspbanc" : 2.380090174313445,
      "macroCategoryCO" : {
        "descrmacrocat" : "descrmacrocat",
        "categorie" : [ null, null ],
        "dittaCg18" : 6.749525837406151,
        "tipocf" : 4.943637496515336,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "macrocat" : "macrocat"
      },
      "datacreaz" : "2000-01-23T04:56:07.000+00:00",
      "flgspeinc" : 3.901545264248647,
      "codrifalf" : "codrifalf",
      "sc1percor" : 7.835035282970782,
      "listmag" : 3.111202833403195,
      "categoryCO" : {
        "macrocatMg10" : "macrocatMg10",
        "tipocfMg10" : 6.173804034172511,
        "descrcat" : "descrcat",
        "dittaCg18" : 2.535258963197524,
        "categ" : "categ",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "dittaCg18" : 4.258773108174356,
      "indspesecum" : 8.37823741034869,
      "magimpcor" : 9.897492629215506,
      "datadismis" : "2000-01-23T04:56:07.000+00:00",
      "dataultdoc" : "2000-01-23T04:56:07.000+00:00",
      "macAreaCO" : {
        "descrmacroar" : "descrmacroar",
        "dittaCg18" : 5.747795090145878,
        "idprov" : 0,
        "tipocf" : 7.3842318535314,
        "areas" : [ null, null ],
        "pluginData" : {
          "key" : ""
        },
        "codiceMacroarea" : "codiceMacroarea",
        "additionalData" : {
          "key" : ""
        }
      },
      "indclibloc" : 9.254183946267839,
      "fixedText1" : {
        "descr" : "descr",
        "datainizioval" : "2000-01-23T04:56:07.000+00:00",
        "indTipoevas" : 4.4935252719377825,
        "idprov" : 1,
        "idmediaCg99" : 9.402167524121316,
        "codice" : "codice",
        "datafineval" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "testo" : "testo"
      },
      "flgart62ctr" : 0,
      "imparrotprec" : 8.28965939814297,
      "areaCO" : {
        "codiceAreaMG" : "codiceAreaMG",
        "macroareaMg07" : "macroareaMg07",
        "dittaCg18" : 0.35262192099236644,
        "zone" : [ {
          "areaMg08" : "areaMg08",
          "macroareaMg08" : "macroareaMg08",
          "dittaCg18" : 2.7977867356748476,
          "idprov" : 9,
          "descrzona" : "descrzona",
          "tipocfMg08" : 0.58919091925136,
          "pluginData" : {
            "key" : ""
          },
          "codiceZona" : "codiceZona",
          "additionalData" : {
            "key" : ""
          }
        }, {
          "areaMg08" : "areaMg08",
          "macroareaMg08" : "macroareaMg08",
          "dittaCg18" : 2.7977867356748476,
          "idprov" : 9,
          "descrzona" : "descrzona",
          "tipocfMg08" : 0.58919091925136,
          "pluginData" : {
            "key" : ""
          },
          "codiceZona" : "codiceZona",
          "additionalData" : {
            "key" : ""
          }
        } ],
        "idprov" : 7,
        "tipocfMg07" : 4.332304821875894,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "descrarea" : "descrarea"
      },
      "dataultvar" : "2000-01-23T04:56:07.000+00:00",
      "tipocfCg44" : 4.518309517874243,
      "fidofactoring" : 4.678947989005849,
      "idmediaCg99" : 1.7325933120207193,
      "datarischio" : "2000-01-23T04:56:07.000+00:00",
      "indstscadest" : 7.606863723092579,
      "grouping2CO" : {
        "codRaggrcf2" : "codRaggrcf2",
        "dittaCg18" : 4.010300976654761,
        "idprov" : 6,
        "descraggrcf2" : "descraggrcf2",
        "idmediaCg99" : 8.276461147928103,
        "tipocf" : 4.141296055235948,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "indclifat" : 1.8268702177058116,
      "fixedExp1" : {
        "flgRicfatriep" : 5.6644160867523485,
        "flgVentstat" : 4.372688051310086,
        "flgIvaincl" : 1,
        "indTipoevas" : 9.785002165136461,
        "idmediaCg99" : 5.7911894223693885,
        "codice" : "codice",
        "indTotspese" : 7.92839742024475,
        "indRotturacorpo" : 1.0639121808530916,
        "indTipospesa" : 7.3718573971919445,
        "indGesintra" : 3.8008573585058016,
        "descr" : "descr",
        "indFatriep" : 5.974942028545841,
        "indTipotot" : 7.726998920545485,
        "indTipoaliq" : 3.2841216543560217,
        "pluginData" : {
          "key" : ""
        },
        "flgVentamm" : 1.5970080735609526,
        "additionalData" : {
          "key" : ""
        },
        "flgOramin" : 3.812761638325517
      },
      "scperpiede" : 8.675064425986758,
      "rischio" : {
        "indSegnalazionecorpo" : 7.464202015255506,
        "flgAttivo" : 4.1661834558007,
        "flgScadereins" : 2.4669941706755685,
        "flgOrdini" : 8.250639315618633,
        "flgCalcmovprev" : 5.573385265048522,
        "flgSaldocon" : 7.273019311111276,
        "pluginData" : {
          "key" : ""
        },
        "flgCalcmovdacons" : 1.9626702727164813,
        "additionalData" : {
          "key" : ""
        },
        "flgScadutoins" : 0.4008378390304357,
        "mesiricscadenze" : 6.642953999458534,
        "flgSelclifortrasf" : 4.432841187680573,
        "indElabscadinsol" : 9.721046668148785,
        "flgScadutonoins" : 2.5524281586707875,
        "codice" : "codice",
        "flgEffettiscaduti" : 3.0269458094096646,
        "flgScaderenoins" : 8.782449469456207,
        "flgCalceffcons" : 2.026856458177285,
        "flgCalcmovcons" : 3.8156682252305574,
        "descrizione" : "descrizione",
        "flgCalceffprev" : 5.296102445648278,
        "dittaCg18" : 2.0981949483881577,
        "flgCalceffdacons" : 3.196820582978078,
        "indAttivatrasf" : 5.726375546151009,
        "mesiricordini" : 6.370609851066415,
        "flgSolobusinesriskattivo" : 3.5117904067536143,
        "indProvenienzafido" : 2.922265432447957,
        "mesiricdocdafatt" : 7.129168897240568
      },
      "dataultfat" : "2000-01-23T04:56:07.000+00:00",
      "notebloc" : "notebloc",
      "areaMGnielsenMg0e" : "areaMGnielsenMg0e",
      "indgesfido" : 8.761432466225475,
      "flgprzcamp" : 5.507386964179881,
      "inddesdocest" : 3.502657762086401,
      "flgdaticlfat" : 9.702963800023566,
      "indgiorni" : 0.4182561061793122,
      "fidoaziendale" : 1.041444916118296,
      "fidolivello1" : 7.260521264802104,
      "indrottcig" : 5.312489704336296,
      "fidolivello2" : 9.132027271330688,
      "raggruppamentoPrevalente" : {
        "descragg" : "descragg",
        "cliforCg44" : 7.390706075830692,
        "dittaCg18" : 1.0502890910539986,
        "idmediaCg99" : 6.176386745020588,
        "codRag" : "codRag",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "indarrl96" : 8.863729185622827,
      "dataultcalsp" : "2000-01-23T04:56:07.000+00:00",
      "flgrottcig" : 6.073898085781152,
      "coddestprev" : "coddestprev",
      "codprevragb" : "codprevragb",
      "art62txt" : "art62txt",
      "flgEstrpayline" : 7.933506881737151,
      "indFattper" : 9.183123594773994,
      "flgqualita" : 4.86315908102884,
      "datablocco" : "2000-01-23T04:56:07.000+00:00",
      "priceListWithMultipleItems" : {
        "descr" : "descr",
        "dittaCg18" : 0.36062689002149373,
        "codice" : "codice",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "subCategoryCO" : {
        "descrsottocat" : "descrsottocat",
        "tipocfMg11" : 8.768153453040833,
        "dittaCg18" : 9.505836306729838,
        "sottcat" : "sottcat",
        "categMg11" : "categMg11",
        "macrocatMg11" : "macrocatMg11",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "lastchange" : "2000-01-23T04:56:07.000+00:00",
      "sc3percor" : 3.1497903714250555
    },
    "datavaliva" : "2000-01-23T04:56:07.000+00:00",
    "dittaCg18" : 3.0937452626664474,
    "flgart62" : 7,
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "indElenchiMov3000" : 3,
    "lastchange" : "2000-01-23T04:56:07.000+00:00"
  },
  "idExtendedAttributeEntity" : 6,
  "codbloccoMg25" : "codbloccoMg25",
  "cambio" : 2.3021358869347655,
  "descraggcont" : "descraggcont",
  "idcontCo02" : 1.4894159098541704,
  "indconvclifat" : 7,
  "storageWH" : {
    "locationWH" : [ {
      "maxpeso" : 2.0561655911354517,
      "profondita" : 2.9691650858515217,
      "umdimens" : "umdimens",
      "codDepMg58" : "codDepMg58",
      "descubicaz" : "descubicaz",
      "coordin1" : "coordin1",
      "umpeso" : "umpeso",
      "indTipoubicaz" : 0.391063602337155,
      "dittaCg18" : 2.4977456046390434,
      "larghezza" : 1.2794383049745206,
      "codClassestoc" : 9.629537564416708,
      "pluginData" : {
        "key" : ""
      },
      "codPriorriemp" : 4.917163120387481,
      "additionalData" : {
        "key" : ""
      },
      "ubicaz" : "ubicaz",
      "coordin3" : "coordin3",
      "altezza" : 5.3152834658745505,
      "coordin2" : "coordin2"
    }, {
      "maxpeso" : 2.0561655911354517,
      "profondita" : 2.9691650858515217,
      "umdimens" : "umdimens",
      "codDepMg58" : "codDepMg58",
      "descubicaz" : "descubicaz",
      "coordin1" : "coordin1",
      "umpeso" : "umpeso",
      "indTipoubicaz" : 0.391063602337155,
      "dittaCg18" : 2.4977456046390434,
      "larghezza" : 1.2794383049745206,
      "codClassestoc" : 9.629537564416708,
      "pluginData" : {
        "key" : ""
      },
      "codPriorriemp" : 4.917163120387481,
      "additionalData" : {
        "key" : ""
      },
      "ubicaz" : "ubicaz",
      "coordin3" : "coordin3",
      "altezza" : 5.3152834658745505,
      "coordin2" : "coordin2"
    } ],
    "indIdep" : "indIdep",
    "datacess" : "2000-01-23T04:56:07.000+00:00",
    "capdep" : "capdep",
    "flgDepprinc" : 8.50835276411088,
    "codDep" : "codDep",
    "indEmail" : "indEmail",
    "dataatt" : "2000-01-23T04:56:07.000+00:00",
    "provdep" : "provdep",
    "dittaCg18" : 3.3182952910080674,
    "telnumdep" : "telnumdep",
    "respdep" : "respdep",
    "indInterest" : 9.551762125042277,
    "locdep" : "locdep",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "faxnumdep" : "faxnumdep",
    "descrdep" : "descrdep"
  },
  "tiponumautof" : 3.5571952270680973,
  "documentoDatiAccompagnamentoMG" : {
    "targavet1" : "targavet1",
    "descaspetto" : "descaspetto",
    "codPortoMg91" : "codPortoMg91",
    "codCautraspMg13" : "codCautraspMg13",
    "targavet2" : "targavet2",
    "codImballoMg95" : "codImballoMg95",
    "vettore2Mg14" : "vettore2Mg14",
    "dataritvet1" : "2000-01-23T04:56:07.000+00:00",
    "descrlettint" : "descrlettint",
    "orainiziotrasp" : 5.944895607614016,
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "oraritvet1" : 6.704019297950036,
    "additionalData" : {
      "key" : ""
    },
    "oraritvet2" : 3.353193347011243,
    "codTipospedMg93" : "codTipospedMg93",
    "vettore1Mg14" : "vettore1Mg14",
    "umvolume" : "umvolume",
    "pesolordo" : 3.0937452626664474,
    "dataritvet2" : "2000-01-23T04:56:07.000+00:00",
    "targarim1" : "targarim1",
    "volume" : 7.058770351582356,
    "targarim2" : "targarim2",
    "totcolli" : 0.8851374739011653,
    "umpeso" : "umpeso",
    "dittaCg18" : 6.878052220127876,
    "spedizMg15" : "spedizMg15",
    "datainiztrasp" : "2000-01-23T04:56:07.000+00:00",
    "pesonetto" : 7.143538047012306,
    "codAspettoMg99" : "codAspettoMg99"
  },
  "numdoc" : 9.965781217890562,
  "documentMaster" : {
    "indTipoop" : 6.778324963048013,
    "dittaCg18" : 2.8841621266687802,
    "gruppocre" : "gruppocre",
    "utentevar" : "utentevar",
    "utentecre" : "utentecre",
    "gruppovar" : "gruppovar",
    "numreg" : "numreg",
    "datavar" : "2000-01-23T04:56:07.000+00:00",
    "datacre" : "2000-01-23T04:56:07.000+00:00",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "descnote1" : "descnote1"
  },
  "cliForDest" : "cliForDest",
  "listmag" : 4.965218492984954,
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ],
  "abbuono" : 5.962133916683182,
  "datainiziopag" : "2000-01-23T04:56:07.000+00:00",
  "datareg" : "2000-01-23T04:56:07.000+00:00",
  "testataPersonalizzata" : [ {
    "idmediaCg99" : 1.17662993142012,
    "datapers1" : "2000-01-23T04:56:07.000+00:00",
    "datapers2" : "2000-01-23T04:56:07.000+00:00",
    "alfpers9" : "alfpers9",
    "datapers3" : "2000-01-23T04:56:07.000+00:00",
    "datapers4" : "2000-01-23T04:56:07.000+00:00",
    "datapers5" : "2000-01-23T04:56:07.000+00:00",
    "datapers6" : "2000-01-23T04:56:07.000+00:00",
    "alfpers4" : "alfpers4",
    "indPers1" : 6.434975173600648,
    "alfpers3" : "alfpers3",
    "indPers2" : 2.729215612801924,
    "alfpers2" : "alfpers2",
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "alfpers1" : "alfpers1",
    "additionalData" : {
      "key" : ""
    },
    "alfpers8" : "alfpers8",
    "alfpers7" : "alfpers7",
    "alfpers6" : "alfpers6",
    "alfpers5" : "alfpers5",
    "numpers11" : 8.206187911681816,
    "numpers1" : 9.774932085941137,
    "numpers12" : 3.4925370028432345,
    "numpers2" : 3.4360986237728,
    "numpers3" : 4.786929569572925,
    "numpers10" : 5.328605645442888,
    "flgPers2" : 3.472023815393955,
    "numpers8" : 2.551900688634915,
    "flgPers1" : 3.3841591171956145,
    "numpers9" : 8.128958126729998,
    "numpers4" : 8.342721204157684,
    "numpers5" : 3.6300678941289712,
    "flgPers4" : 8.67132933794674,
    "numpers6" : 2.1305968583238744,
    "prog" : 8.897844438448299,
    "flgPers3" : 5.22975523929469,
    "numpers7" : 7.68210344846877,
    "dittaCg18" : 5.2388109661003055,
    "alfpers10" : "alfpers10",
    "alfpers11" : "alfpers11",
    "alfpers12" : "alfpers12"
  }, {
    "idmediaCg99" : 1.17662993142012,
    "datapers1" : "2000-01-23T04:56:07.000+00:00",
    "datapers2" : "2000-01-23T04:56:07.000+00:00",
    "alfpers9" : "alfpers9",
    "datapers3" : "2000-01-23T04:56:07.000+00:00",
    "datapers4" : "2000-01-23T04:56:07.000+00:00",
    "datapers5" : "2000-01-23T04:56:07.000+00:00",
    "datapers6" : "2000-01-23T04:56:07.000+00:00",
    "alfpers4" : "alfpers4",
    "indPers1" : 6.434975173600648,
    "alfpers3" : "alfpers3",
    "indPers2" : 2.729215612801924,
    "alfpers2" : "alfpers2",
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "alfpers1" : "alfpers1",
    "additionalData" : {
      "key" : ""
    },
    "alfpers8" : "alfpers8",
    "alfpers7" : "alfpers7",
    "alfpers6" : "alfpers6",
    "alfpers5" : "alfpers5",
    "numpers11" : 8.206187911681816,
    "numpers1" : 9.774932085941137,
    "numpers12" : 3.4925370028432345,
    "numpers2" : 3.4360986237728,
    "numpers3" : 4.786929569572925,
    "numpers10" : 5.328605645442888,
    "flgPers2" : 3.472023815393955,
    "numpers8" : 2.551900688634915,
    "flgPers1" : 3.3841591171956145,
    "numpers9" : 8.128958126729998,
    "numpers4" : 8.342721204157684,
    "numpers5" : 3.6300678941289712,
    "flgPers4" : 8.67132933794674,
    "numpers6" : 2.1305968583238744,
    "prog" : 8.897844438448299,
    "flgPers3" : 5.22975523929469,
    "numpers7" : 7.68210344846877,
    "dittaCg18" : 5.2388109661003055,
    "alfpers10" : "alfpers10",
    "alfpers11" : "alfpers11",
    "alfpers12" : "alfpers12"
  } ],
  "dataplafond" : "2000-01-23T04:56:07.000+00:00",
  "stipodoc" : 8.762042012749001,
  "headingReferenceDocumentMG" : [ {
    "flgNsdocbis" : 9.254183946267839,
    "notevsdoc" : "notevsdoc",
    "rifnsdoc" : "rifnsdoc",
    "datansdoc" : "2000-01-23T04:56:07.000+00:00",
    "seznsdoc" : "seznsdoc",
    "indStipodoc" : 1.8268702177058116,
    "datansconf" : "2000-01-23T04:56:07.000+00:00",
    "datavsconf" : "2000-01-23T04:56:07.000+00:00",
    "datavsdoc" : "2000-01-23T04:56:07.000+00:00",
    "fedatadoc" : "2000-01-23T04:56:07.000+00:00",
    "numnsdoc" : 9.183123594773994,
    "dittaCg18" : 8.863729185622827,
    "feiddoc" : "feiddoc",
    "feidsoggetto" : "feidsoggetto",
    "indTipodoc" : 3.502657762086401,
    "numregCo99" : "numregCo99",
    "numvsdoc" : "numvsdoc",
    "pluginData" : {
      "key" : ""
    },
    "notensdoc" : "notensdoc",
    "progRif" : 8.761432466225475,
    "rifvsdoc" : "rifvsdoc",
    "additionalData" : {
      "key" : ""
    }
  }, {
    "flgNsdocbis" : 9.254183946267839,
    "notevsdoc" : "notevsdoc",
    "rifnsdoc" : "rifnsdoc",
    "datansdoc" : "2000-01-23T04:56:07.000+00:00",
    "seznsdoc" : "seznsdoc",
    "indStipodoc" : 1.8268702177058116,
    "datansconf" : "2000-01-23T04:56:07.000+00:00",
    "datavsconf" : "2000-01-23T04:56:07.000+00:00",
    "datavsdoc" : "2000-01-23T04:56:07.000+00:00",
    "fedatadoc" : "2000-01-23T04:56:07.000+00:00",
    "numnsdoc" : 9.183123594773994,
    "dittaCg18" : 8.863729185622827,
    "feiddoc" : "feiddoc",
    "feidsoggetto" : "feidsoggetto",
    "indTipodoc" : 3.502657762086401,
    "numregCo99" : "numregCo99",
    "numvsdoc" : "numvsdoc",
    "pluginData" : {
      "key" : ""
    },
    "notensdoc" : "notensdoc",
    "progRif" : 8.761432466225475,
    "rifvsdoc" : "rifvsdoc",
    "additionalData" : {
      "key" : ""
    }
  } ],
  "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
  "causmagMg51" : 7.061401241503109,
  "cup" : "cup",
  "cig" : "cig",
  "documentoTestataAgentiMG" : [ {
    "idagenteMg17" : 4,
    "dittaCg18" : 6.519180951018382,
    "perprov" : 3.0205796992916243,
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "indRegprov" : 7.740351818741173,
    "additionalData" : {
      "key" : ""
    },
    "flgAgerifer" : 0.10263654006109402,
    "codiceAgente" : "codiceAgente",
    "indModcalc" : 8.969578798196912
  }, {
    "idagenteMg17" : 4,
    "dittaCg18" : 6.519180951018382,
    "perprov" : 3.0205796992916243,
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "indRegprov" : 7.740351818741173,
    "additionalData" : {
      "key" : ""
    },
    "flgAgerifer" : 0.10263654006109402,
    "codiceAgente" : "codiceAgente",
    "indModcalc" : 8.969578798196912
  } ],
  "cauprestCg15" : "cauprestCg15",
  "esclusioneAgentiMultipli" : 0,
  "idmediaCg99" : 6.84685269835264,
  "acconto" : 1.4658129805029452,
  "flgSpincas" : 1,
  "officeCO" : {
    "indIrizzo" : "indIrizzo",
    "idmediaCg99" : 6.720288821326667,
    "codice" : 7.766860781935265,
    "indDimcentrocomm" : 5.304373278797373,
    "cap" : "cap",
    "dittaCg18" : 1.6056289151258096,
    "progRea" : 8.708394192403432,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "prov" : "prov",
    "numerorea" : "numerorea",
    "citta" : "citta",
    "rowversion" : ""
  },
  "datadoc" : "2000-01-23T04:56:07.000+00:00",
  "codpagCg62" : "codpagCg62",
  "flgDocstamp" : 7,
  "documentoTestataProgettiMG" : {
    "codDipPd06" : "codDipPd06",
    "codProgcol" : "codProgcol",
    "causmgoMgfo" : 3,
    "codProgetto" : "codProgetto",
    "codSprogetto" : 3.2588565619047607,
    "dittaCg18" : 4.078845849666752,
    "codCommessa" : "codCommessa",
    "nodorifcolPd0c" : "nodorifcolPd0c",
    "codScommessa" : 7.04836565559697,
    "pluginData" : {
      "key" : ""
    },
    "nodorifPd0c" : "nodorifPd0c",
    "additionalData" : {
      "key" : ""
    },
    "codSprogcol" : 5.533258397034986
  },
  "testataOrdine" : {
    "dataconsint" : "2000-01-23T04:56:07.000+00:00",
    "flgNonpiuev" : 6,
    "flgEvastot" : 6,
    "priorita" : 4.778706604314481,
    "flgNoevasparz" : 5,
    "ggtollercons" : 6.614319261836819,
    "flgRicpreev" : 5,
    "datacons" : "2000-01-23T04:56:07.000+00:00",
    "dittaCg18" : 3.474156394106027,
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "dataconsorig" : "2000-01-23T04:56:07.000+00:00",
    "flgNonann" : 6,
    "additionalData" : {
      "key" : ""
    },
    "flgConfrit" : 6,
    "tipoordine" : 3.0237995775442372,
    "tipoinoltro" : 0.7449262586083982
  },
  "progrEf08" : 9.369310271410669,
  "sezdoc" : "sezdoc",
  "numautof" : 5.025004791520295,
  "tipodoc" : 9.018348186070783,
  "datacambio" : "2000-01-23T04:56:07.000+00:00",
  "stagioneMg5t" : 6,
  "flgClifat" : 4,
  "idExtendedAttributeSubEntity" : 1,
  "documentoTestataRateiMG" : {
    "dadatacomp" : "2000-01-23T04:56:07.000+00:00",
    "flgDaav" : 8.28965939814297,
    "dataregesinc" : "2000-01-23T04:56:07.000+00:00",
    "indTipocomp" : 4.573936264232251,
    "dittaCg18" : 1.7325933120207193,
    "flgDisatcoge" : 6.623518433804886,
    "contopar" : "contopar",
    "datacompivaman" : "2000-01-23T04:56:07.000+00:00",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "adatacomp" : "2000-01-23T04:56:07.000+00:00",
    "dataregesprec" : "2000-01-23T04:56:07.000+00:00"
  },
  "codcabCg13" : 3.616076749251911,
  "documentoTestataProvvigioniMG" : [ {
    "idagenteMg17" : 9,
    "flgStenas" : 0.8774076871421566,
    "flgProvsosp" : 1.041444916118296,
    "idmediaCg99" : 0.5199002018724985,
    "imporprov" : 4.86315908102884,
    "imponprov" : 7.933506881737151,
    "imponprovVal" : 5.507386964179881,
    "trimestrePa23" : 2.9409642974827896,
    "provmedia" : 0.43431398824148815,
    "flgPers" : 4.258773108174356,
    "imporprovVal" : 6.073898085781152,
    "noteprov" : "noteprov",
    "flgSt" : 7.260521264802104,
    "flgStarcred" : 9.132027271330688,
    "indTipomov" : 3.901545264248647,
    "flgProvvar" : 4.678947989005849,
    "dittaCg18" : 6.628464275087742,
    "annoPa23" : 0.2025324113236393,
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "indSt" : 4.459605034958679,
    "additionalData" : {
      "key" : ""
    },
    "codiceAgente" : "codiceAgente",
    "indPers" : 8.251625748923757
  }, {
    "idagenteMg17" : 9,
    "flgStenas" : 0.8774076871421566,
    "flgProvsosp" : 1.041444916118296,
    "idmediaCg99" : 0.5199002018724985,
    "imporprov" : 4.86315908102884,
    "imponprov" : 7.933506881737151,
    "imponprovVal" : 5.507386964179881,
    "trimestrePa23" : 2.9409642974827896,
    "provmedia" : 0.43431398824148815,
    "flgPers" : 4.258773108174356,
    "imporprovVal" : 6.073898085781152,
    "noteprov" : "noteprov",
    "flgSt" : 7.260521264802104,
    "flgStarcred" : 9.132027271330688,
    "indTipomov" : 3.901545264248647,
    "flgProvvar" : 4.678947989005849,
    "dittaCg18" : 6.628464275087742,
    "annoPa23" : 0.2025324113236393,
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "indSt" : 4.459605034958679,
    "additionalData" : {
      "key" : ""
    },
    "codiceAgente" : "codiceAgente",
    "indPers" : 8.251625748923757
  } ],
  "flgLockOnDocExist" : true,
  "lineaFa05" : "lineaFa05",
  "notedocum" : "notedocum",
  "numReg" : "000000000000",
  "righe" : [ {
    "flgContribinteg" : 7,
    "statoAttualeCO" : {
      "statiDisponibili" : [ null, null ],
      "statoCorrente" : {
        "indTipoStato" : 8,
        "idStato" : 2,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "seq" : 2
      },
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "prezzo2iva" : 9.806951670467935,
    "documentoRigaProgettiMG" : {
      "codDipPd06" : "codDipPd06",
      "attivitaPd0d" : "attivitaPd0d",
      "codProgcol" : "codProgcol",
      "idattrezzaturaVc02" : 6,
      "idartepuVc02" : 2,
      "nodoPd0c" : "nodoPd0c",
      "idmedia" : 0.8411762798681321,
      "codProgetto" : "codProgetto",
      "codSprogetto" : 4.141296055235948,
      "dittaCg18" : 8.910869026866926,
      "codCommessa" : "codCommessa",
      "nodorifcolPd0c" : "nodorifcolPd0c",
      "codScommessa" : 8.276461147928103,
      "spesaPd64" : "spesaPd64",
      "pluginData" : {
        "key" : ""
      },
      "nodorifPd0c" : "nodorifPd0c",
      "additionalData" : {
        "key" : ""
      },
      "codSprogcol" : 6.458262756685686
    },
    "cpmerceCg24" : "cpmerceCg24",
    "profondita" : 1.3949519358941398,
    "prezzo2" : 6.966044574347761,
    "ditta" : 3.111202833403195,
    "prezzo1" : 6.173804034172511,
    "um1" : "um1",
    "indtiporiga" : 7,
    "documentoRigaCOINMG" : {
      "pdcvdsorigPc01" : 4.010300976654761,
      "pdcdestPc01" : 8.262795412896967,
      "vdsorigPc03" : "vdsorigPc03",
      "contoorigPc03" : "contoorigPc03",
      "idmediaCg99" : 3.209082285545927,
      "contodestPc03" : "contodestPc03",
      "flgEsclriga" : 4.4935252719377825,
      "vdsdestPc03" : "vdsdestPc03",
      "dittaCg18" : 1.7045651386993,
      "pdcorigPc01" : 2.9805393113464476,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "pdcvdsdestPc01" : 9.146339979307802
    },
    "pluginData" : {
      "key" : ""
    },
    "um2" : "um2",
    "additionalData" : {
      "key" : ""
    },
    "barcode" : "barcode",
    "fatconv" : 9.897492629215506,
    "magimp" : 4.332304821875894,
    "coddepcolMg58" : "coddepcolMg58",
    "pesol" : 0.58919091925136,
    "prezzo1iva" : 4.8789878742268815,
    "peson" : 2.535258963197524,
    "flgContribprev" : 0,
    "importo" : 3.804112695731078,
    "pzconf" : 1.5970080735609526,
    "flgPriceDiscForce" : true,
    "flgRitenas" : 2,
    "progPadre" : 1.2555055362323109,
    "testoFissoMG" : {
      "descr" : "descr",
      "datainizioval" : "2000-01-23T04:56:07.000+00:00",
      "indTipoevas" : 4.4935252719377825,
      "idprov" : 1,
      "idmediaCg99" : 9.402167524121316,
      "codice" : "codice",
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "testo" : "testo"
    },
    "codescl4Mg82" : "codescl4Mg82",
    "codartMg66" : "codartMg66",
    "rigaIntra" : {
      "meserif" : 5.829097284708605,
      "modincassoIn04" : "modincassoIn04",
      "paesepagCg07" : 8.071139232091417,
      "percadegvalstat" : 8.257837395465918,
      "fatconvumsuppl" : 2.831445253698411,
      "codiceCg72" : "codiceCg72",
      "unsuppl" : 9.878259040728768,
      "paeseorigCg07" : 1.2786903972794905,
      "provdest" : "provdest",
      "provorig" : "provorig",
      "progRiga" : 5.547564904556697,
      "indTipoCg72" : 5.499986845135928,
      "annorif" : 2.924533207692744,
      "dittaCg18" : 8.238101405568635,
      "moderogazioneIn03" : "moderogazioneIn03",
      "paesedestCg07" : 0.7242789830362995,
      "massanetta" : 8.569658089905484,
      "paeseprovCg07" : 2.7107020326702136,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "flgEsclintra" : 6.345503614942988
    },
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "spesaVariaMG" : {
      "flgRicfatriep" : 5.6644160867523485,
      "flgVentstat" : 4.372688051310086,
      "flgIvaincl" : 1,
      "indTipoevas" : 9.785002165136461,
      "idmediaCg99" : 5.7911894223693885,
      "codice" : "codice",
      "indTotspese" : 7.92839742024475,
      "indRotturacorpo" : 1.0639121808530916,
      "indTipospesa" : 7.3718573971919445,
      "indGesintra" : 3.8008573585058016,
      "descr" : "descr",
      "indFatriep" : 5.974942028545841,
      "indTipotot" : 7.726998920545485,
      "indTipoaliq" : 3.2841216543560217,
      "pluginData" : {
        "key" : ""
      },
      "flgVentamm" : 1.5970080735609526,
      "additionalData" : {
        "key" : ""
      },
      "flgOramin" : 3.812761638325517
    },
    "rigaEstesa" : [ {
      "alfst10" : "alfst10",
      "datast2" : "2000-01-23T04:56:07.000+00:00",
      "numst12" : 6.642953999458534,
      "datast1" : "2000-01-23T04:56:07.000+00:00",
      "alfst12" : "alfst12",
      "alfst11" : "alfst11",
      "idmediaCg99" : 5.726375546151009,
      "datast4" : "2000-01-23T04:56:07.000+00:00",
      "numst10" : 7.129168897240568,
      "datast3" : "2000-01-23T04:56:07.000+00:00",
      "numst11" : 6.370609851066415,
      "progRiga" : 2.008994665592807,
      "datast6" : "2000-01-23T04:56:07.000+00:00",
      "datast5" : "2000-01-23T04:56:07.000+00:00",
      "alfst4" : "alfst4",
      "alfst5" : "alfst5",
      "alfst6" : "alfst6",
      "alfst7" : "alfst7",
      "alfst8" : "alfst8",
      "alfst9" : "alfst9",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "alfst1" : "alfst1",
      "alfst2" : "alfst2",
      "alfst3" : "alfst3",
      "flgSt2" : 2.5524281586707875,
      "flgSt3" : 4.432841187680573,
      "flgSt4" : 3.5117904067536143,
      "numst8" : 9.007961177824221,
      "numst7" : 3.7846852362095262,
      "numst9" : 1.5743672347582194,
      "prog" : 4.863793115215697,
      "numst2" : 9.505836306729838,
      "numst1" : 7.464202015255506,
      "numst4" : 2.684056218962324,
      "dittaCg18" : 8.782449469456207,
      "numst3" : 8.768153453040833,
      "numst6" : 1.0046985756074744,
      "numst5" : 6.712603870693706,
      "indSt1" : 9.721046668148785,
      "indSt2" : 2.922265432447957,
      "flgSt1" : 0.4008378390304357
    }, {
      "alfst10" : "alfst10",
      "datast2" : "2000-01-23T04:56:07.000+00:00",
      "numst12" : 6.642953999458534,
      "datast1" : "2000-01-23T04:56:07.000+00:00",
      "alfst12" : "alfst12",
      "alfst11" : "alfst11",
      "idmediaCg99" : 5.726375546151009,
      "datast4" : "2000-01-23T04:56:07.000+00:00",
      "numst10" : 7.129168897240568,
      "datast3" : "2000-01-23T04:56:07.000+00:00",
      "numst11" : 6.370609851066415,
      "progRiga" : 2.008994665592807,
      "datast6" : "2000-01-23T04:56:07.000+00:00",
      "datast5" : "2000-01-23T04:56:07.000+00:00",
      "alfst4" : "alfst4",
      "alfst5" : "alfst5",
      "alfst6" : "alfst6",
      "alfst7" : "alfst7",
      "alfst8" : "alfst8",
      "alfst9" : "alfst9",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "alfst1" : "alfst1",
      "alfst2" : "alfst2",
      "alfst3" : "alfst3",
      "flgSt2" : 2.5524281586707875,
      "flgSt3" : 4.432841187680573,
      "flgSt4" : 3.5117904067536143,
      "numst8" : 9.007961177824221,
      "numst7" : 3.7846852362095262,
      "numst9" : 1.5743672347582194,
      "prog" : 4.863793115215697,
      "numst2" : 9.505836306729838,
      "numst1" : 7.464202015255506,
      "numst4" : 2.684056218962324,
      "dittaCg18" : 8.782449469456207,
      "numst3" : 8.768153453040833,
      "numst6" : 1.0046985756074744,
      "numst5" : 6.712603870693706,
      "indSt1" : 9.721046668148785,
      "indSt2" : 2.922265432447957,
      "flgSt1" : 0.4008378390304357
    } ],
    "causmagMg51" : 8.37823741034869,
    "cup" : "cup",
    "cig" : "cig",
    "codescl3Mg82" : "codescl3Mg82",
    "progvisuasta" : 5.6644160867523485,
    "rigaOrdine" : {
      "codTraclegdb" : "codTraclegdb",
      "dataconsint" : "2000-01-23T04:56:07.000+00:00",
      "datalancio" : "2000-01-23T04:56:07.000+00:00",
      "flgNonpiuev" : 9,
      "datainizlav" : "2000-01-23T04:56:07.000+00:00",
      "qta2trasfddtcl" : 4.318826475758856,
      "flgConsconf" : 7,
      "flgRicpreev" : 6,
      "collitrasfp" : 9.966789814889403,
      "progRiga" : 0.6895265584691002,
      "qta2lanc" : 0.29551818216563164,
      "qta2prel" : 0.7370530802760489,
      "collicons" : 8.780989965779524,
      "qta2trasfp" : 9.908114046741538,
      "codPiano" : "codPiano",
      "flgNosugg" : 1,
      "numpiano" : 7.375698277301938,
      "qta1prel" : 8.331741856019029,
      "datapianif" : "2000-01-23T04:56:07.000+00:00",
      "numregCo99" : "numregCo99",
      "qta1cons" : 3.5366534267201475,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datafineoap" : "2000-01-23T04:56:07.000+00:00",
      "flgSospriga" : 9,
      "numpropPd39" : 6.97635352548152,
      "qta1lanc" : 5.267310321293582,
      "contpcarPd79" : 9.748669620880193,
      "indStatodescsp" : 6,
      "qta1trasfddtcl" : 7.6528347060559,
      "flgNoevasparz" : 0,
      "ggtollercons" : 9.372628622067484,
      "qta2cons" : 8.223593720381889,
      "collitrasfddtcl" : 5.616380282218067,
      "indStatocons" : 6,
      "codTraclegwbs" : "codTraclegwbs",
      "datacons" : "2000-01-23T04:56:07.000+00:00",
      "valorecons" : 7.541803065493349,
      "dittaCg18" : 6.203595661339589,
      "indEvasdescsp" : 8,
      "qta1trasfp" : 9.120398275527268,
      "dataconsorig" : "2000-01-23T04:56:07.000+00:00",
      "datainizoap" : "2000-01-23T04:56:07.000+00:00",
      "progRigpiaPd80" : 9.290244967928562
    },
    "flgRitacc" : 3,
    "svar2" : "svar2",
    "codschedaMg42" : "codschedaMg42",
    "svar1" : "svar1",
    "capacita" : 5.312489704336296,
    "fatconvcf" : 5.877124706116695,
    "codescl2Mg82" : "codescl2Mg82",
    "colli" : 7.606863723092579,
    "codartcli" : "codartcli",
    "altezza" : 0.4182561061793122,
    "opzioneMg5e" : "opzioneMg5e",
    "stagioneMg5t" : 7,
    "scper1" : 3.8008573585058016,
    "indlisacqven" : 8,
    "qta2" : 5.7911894223693885,
    "scper2" : 1.0639121808530916,
    "scper3" : 3.2841216543560217,
    "scper4" : 9.785002165136461,
    "indlisfisso" : 4,
    "magper2" : 9.386524999783381,
    "qta1" : 4.372688051310086,
    "estdescart" : "estdescart",
    "codescl1Mg82" : "codescl1Mg82",
    "documentoRigaRateiMG" : {
      "flgDaav" : 0.11859130807119977,
      "dataregesinc" : "2000-01-23T04:56:07.000+00:00",
      "imprettcostobu" : 7.390706075830692,
      "imprettcostobuVal" : 1.0502890910539986,
      "importo" : 0.36062689002149373,
      "percforf" : 4.1661834558007,
      "adatacomp" : "2000-01-23T04:56:07.000+00:00",
      "indTipomovbu" : 2.0981949483881577,
      "dadatacomp" : "2000-01-23T04:56:07.000+00:00",
      "indTipocomp" : 6.176386745020588,
      "dittaCg18" : 6.918231485891953,
      "flgDisatcoge" : 4.637509675190766,
      "codBeneusato" : 7.88722683998926,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "contoparCg24" : "contoparCg24",
      "dataregesprec" : "2000-01-23T04:56:07.000+00:00"
    },
    "rigaPersonalizzata" : [ {
      "idmediaCg99" : 5.304373278797373,
      "progRiga" : 9.610516429629122,
      "datapers1" : "2000-01-23T04:56:07.000+00:00",
      "datapers2" : "2000-01-23T04:56:07.000+00:00",
      "alfpers9" : "alfpers9",
      "datapers3" : "2000-01-23T04:56:07.000+00:00",
      "datapers4" : "2000-01-23T04:56:07.000+00:00",
      "datapers5" : "2000-01-23T04:56:07.000+00:00",
      "datapers6" : "2000-01-23T04:56:07.000+00:00",
      "alfpers4" : "alfpers4",
      "indPers1" : 8.708394192403432,
      "alfpers3" : "alfpers3",
      "indPers2" : 0.8164256701298711,
      "alfpers2" : "alfpers2",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "alfpers1" : "alfpers1",
      "additionalData" : {
        "key" : ""
      },
      "alfpers8" : "alfpers8",
      "alfpers7" : "alfpers7",
      "alfpers6" : "alfpers6",
      "alfpers5" : "alfpers5",
      "numpers11" : 0.313237310471568,
      "numpers1" : 4.13177941962639,
      "numpers12" : 7.701777079007398,
      "numpers2" : 2.1871588311421153,
      "numpers3" : 0.05189710095898081,
      "numpers10" : 4.4580628783592156,
      "flgPers2" : 7.766860781935265,
      "numpers8" : 3.0659734456354117,
      "flgPers1" : 8.875589915795528,
      "numpers9" : 8.638367073739522,
      "numpers4" : 4.403697036782718,
      "numpers5" : 6.936499209818381,
      "flgPers4" : 6.720288821326667,
      "numpers6" : 4.035133329541982,
      "prog" : 5.948961008630453,
      "flgPers3" : 1.6056289151258096,
      "numpers7" : 2.1518888575299036,
      "dittaCg18" : 7.437703257022269,
      "alfpers10" : "alfpers10",
      "alfpers11" : "alfpers11",
      "alfpers12" : "alfpers12"
    }, {
      "idmediaCg99" : 5.304373278797373,
      "progRiga" : 9.610516429629122,
      "datapers1" : "2000-01-23T04:56:07.000+00:00",
      "datapers2" : "2000-01-23T04:56:07.000+00:00",
      "alfpers9" : "alfpers9",
      "datapers3" : "2000-01-23T04:56:07.000+00:00",
      "datapers4" : "2000-01-23T04:56:07.000+00:00",
      "datapers5" : "2000-01-23T04:56:07.000+00:00",
      "datapers6" : "2000-01-23T04:56:07.000+00:00",
      "alfpers4" : "alfpers4",
      "indPers1" : 8.708394192403432,
      "alfpers3" : "alfpers3",
      "indPers2" : 0.8164256701298711,
      "alfpers2" : "alfpers2",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "alfpers1" : "alfpers1",
      "additionalData" : {
        "key" : ""
      },
      "alfpers8" : "alfpers8",
      "alfpers7" : "alfpers7",
      "alfpers6" : "alfpers6",
      "alfpers5" : "alfpers5",
      "numpers11" : 0.313237310471568,
      "numpers1" : 4.13177941962639,
      "numpers12" : 7.701777079007398,
      "numpers2" : 2.1871588311421153,
      "numpers3" : 0.05189710095898081,
      "numpers10" : 4.4580628783592156,
      "flgPers2" : 7.766860781935265,
      "numpers8" : 3.0659734456354117,
      "flgPers1" : 8.875589915795528,
      "numpers9" : 8.638367073739522,
      "numpers4" : 4.403697036782718,
      "numpers5" : 6.936499209818381,
      "flgPers4" : 6.720288821326667,
      "numpers6" : 4.035133329541982,
      "prog" : 5.948961008630453,
      "flgPers3" : 1.6056289151258096,
      "numpers7" : 2.1518888575299036,
      "dittaCg18" : 7.437703257022269,
      "alfpers10" : "alfpers10",
      "alfpers11" : "alfpers11",
      "alfpers12" : "alfpers12"
    } ],
    "documentoRigaProvvigioniMG" : [ {
      "idagenteMg17" : 0,
      "percprov" : 9.456612101333725,
      "imporprov" : 4.943637496515336,
      "indRegprov" : 0.4867146239815201,
      "imponprov" : 7.3842318535314,
      "imponprovVal" : 6.749525837406151,
      "progRiga" : 9.721723570087065,
      "imporprovVal" : 0.30134145536422907,
      "dittaCg18" : 2.9679475177256287,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "flgVarprov" : 5.747795090145878,
      "additionalData" : {
        "key" : ""
      },
      "codiceAgente" : "codiceAgente"
    }, {
      "idagenteMg17" : 0,
      "percprov" : 9.456612101333725,
      "imporprov" : 4.943637496515336,
      "indRegprov" : 0.4867146239815201,
      "imponprov" : 7.3842318535314,
      "imponprovVal" : 6.749525837406151,
      "progRiga" : 9.721723570087065,
      "imporprovVal" : 0.30134145536422907,
      "dittaCg18" : 2.9679475177256287,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "flgVarprov" : 5.747795090145878,
      "additionalData" : {
        "key" : ""
      },
      "codiceAgente" : "codiceAgente"
    } ],
    "magper1" : 2.7977867356748476,
    "tara" : 9.402167524121316,
    "packaging" : {
      "umPeso" : "umPeso",
      "qta2Conf" : 7.273019311111276,
      "qta1Conf" : 8.250639315618633,
      "pesoLordo" : 3.8156682252305574,
      "umCapac" : "umCapac",
      "colliConf" : 3.196820582978078,
      "progRiga" : 5.573385265048522,
      "volume" : 2.4669941706755685,
      "umVolume" : "umVolume",
      "dittaCg18" : 5.296102445648278,
      "codConfezMg96" : "codConfezMg96",
      "capacita" : 2.026856458177285,
      "pzConf" : 3.0269458094096646,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "pesoNetto" : 1.9626702727164813
    },
    "rigaLotti" : [ {
      "cliforCg44" : 5.5569822283364845,
      "note" : "note",
      "flgNonpiuev" : 8.546645780823726,
      "codSscc" : "codSscc",
      "progMg4f" : 8.310924482277276,
      "tipocfCg44" : 4.757484754617172,
      "idmediaCg99" : 4.784107115651097,
      "codArtMg66" : "codArtMg66",
      "codDepMg58" : "codDepMg58",
      "codProgPd14" : "codProgPd14",
      "progRiga" : 7.886583288201395,
      "progRigarifDo30" : 1.4793631642421967,
      "codConfezMg96" : "codConfezMg96",
      "numregCo99" : "numregCo99",
      "qta1cons" : 1.8407572303125541,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codBagnomat" : "codBagnomat",
      "codArtpfMg66" : "codArtpfMg66",
      "codPallets" : "codPallets",
      "opzionepfMg5e" : "opzionepfMg5e",
      "opzioneMg5e" : "opzioneMg5e",
      "qta2" : 7.200147194425509,
      "codLottopfMg4g" : "codLottopfMg4g",
      "codLottoMg4g" : "codLottoMg4g",
      "sernum" : "sernum",
      "scadenza" : "2000-01-23T04:56:07.000+00:00",
      "anagraficaLotto" : {
        "note" : "note",
        "dittaCg18" : 4.754071900895484,
        "idmediaCg99" : 1.1864130338603074,
        "codArtMg66" : "codArtMg66",
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "codLotto" : "codLotto",
        "additionalData" : {
          "key" : ""
        },
        "datascad" : "2000-01-23T04:56:07.000+00:00",
        "lib1" : 3.8601930294054942,
        "desclotto" : "desclotto",
        "opzioneMg5e" : "opzioneMg5e"
      },
      "qta1" : 2.719219329469812,
      "qta2cons" : 7.135782839148426,
      "ubicazcollMg97" : "ubicazcollMg97",
      "progRifDo52" : 6.607129449620165,
      "prog" : 8.036294790673514,
      "parametroMovimentazioneLotto" : {
        "flgNote" : 4.5403315819302215,
        "dittaCg18" : 3.8581948879558317,
        "flgAggprogval" : 1.9732909296667345,
        "indGiacsca" : 8.262575023052213,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "prog" : 0.9178980228274691,
        "tipomov" : "tipomov"
      },
      "ubicazMg97" : "ubicazMg97",
      "sotprogPd14" : 1.0348002257634148,
      "dittaCg18" : 5.412786966532157,
      "numregrifCo99" : "numregrifCo99",
      "causmagMg51" : 2.60416377551006
    }, {
      "cliforCg44" : 5.5569822283364845,
      "note" : "note",
      "flgNonpiuev" : 8.546645780823726,
      "codSscc" : "codSscc",
      "progMg4f" : 8.310924482277276,
      "tipocfCg44" : 4.757484754617172,
      "idmediaCg99" : 4.784107115651097,
      "codArtMg66" : "codArtMg66",
      "codDepMg58" : "codDepMg58",
      "codProgPd14" : "codProgPd14",
      "progRiga" : 7.886583288201395,
      "progRigarifDo30" : 1.4793631642421967,
      "codConfezMg96" : "codConfezMg96",
      "numregCo99" : "numregCo99",
      "qta1cons" : 1.8407572303125541,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codBagnomat" : "codBagnomat",
      "codArtpfMg66" : "codArtpfMg66",
      "codPallets" : "codPallets",
      "opzionepfMg5e" : "opzionepfMg5e",
      "opzioneMg5e" : "opzioneMg5e",
      "qta2" : 7.200147194425509,
      "codLottopfMg4g" : "codLottopfMg4g",
      "codLottoMg4g" : "codLottoMg4g",
      "sernum" : "sernum",
      "scadenza" : "2000-01-23T04:56:07.000+00:00",
      "anagraficaLotto" : {
        "note" : "note",
        "dittaCg18" : 4.754071900895484,
        "idmediaCg99" : 1.1864130338603074,
        "codArtMg66" : "codArtMg66",
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "codLotto" : "codLotto",
        "additionalData" : {
          "key" : ""
        },
        "datascad" : "2000-01-23T04:56:07.000+00:00",
        "lib1" : 3.8601930294054942,
        "desclotto" : "desclotto",
        "opzioneMg5e" : "opzioneMg5e"
      },
      "qta1" : 2.719219329469812,
      "qta2cons" : 7.135782839148426,
      "ubicazcollMg97" : "ubicazcollMg97",
      "progRifDo52" : 6.607129449620165,
      "prog" : 8.036294790673514,
      "parametroMovimentazioneLotto" : {
        "flgNote" : 4.5403315819302215,
        "dittaCg18" : 3.8581948879558317,
        "flgAggprogval" : 1.9732909296667345,
        "indGiacsca" : 8.262575023052213,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "prog" : 0.9178980228274691,
        "tipomov" : "tipomov"
      },
      "ubicazMg97" : "ubicazMg97",
      "sotprogPd14" : 1.0348002257634148,
      "dittaCg18" : 5.412786966532157,
      "numregrifCo99" : "numregrifCo99",
      "causmagMg51" : 2.60416377551006
    } ],
    "coddepMg58" : "coddepMg58",
    "costotot" : 3.7814124730767915,
    "indtipoomag" : 0,
    "scper5" : 7.3718573971919445,
    "scper6" : 7.726998920545485,
    "indlisprior" : 0,
    "progrRiga" : 3.812761638325517,
    "lineaFa05" : "lineaFa05",
    "codartfor" : "codartfor",
    "numReg" : "numReg",
    "descart" : "descart",
    "alivacompCg28" : "alivacompCg28",
    "base" : 5.299143560275359,
    "scimp" : 5.974942028545841,
    "rigaRiferimenti" : [ {
      "flgNsdocbis" : 7.686670838404092,
      "qta2mov" : 0.05965928697733491,
      "flgNonpiuevpdc" : 7.321091499885957,
      "notevsdoc" : "notevsdoc",
      "seqfase" : 5.099298781640682,
      "datansdoc" : "2000-01-23T04:56:07.000+00:00",
      "indQtaordres" : 3,
      "seznsdoc" : "seznsdoc",
      "indStipodoc" : 0,
      "datansconf" : "2000-01-23T04:56:07.000+00:00",
      "datavsconf" : "2000-01-23T04:56:07.000+00:00",
      "progRiga" : 6.568304668801491,
      "valoremov" : 9.728706165995554,
      "progRigarifDo30" : 7.338782761819433,
      "progRigapadreDo30" : 1.4985931822280574,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "notensdoc" : "notensdoc",
      "progRif" : 2.3317418552851765,
      "rifvsdoc" : "rifvsdoc",
      "additionalData" : {
        "key" : ""
      },
      "numregpadreCo99" : "numregpadreCo99",
      "flgAggprescvar" : 7.964879197514727,
      "qta1mov" : 9.739448828157911,
      "collimov" : 9.140242185517025,
      "flgAggqtatrasf" : 4,
      "rifnsdoc" : "rifnsdoc",
      "fasePd12" : 4.39343993729625,
      "datavsdoc" : "2000-01-23T04:56:07.000+00:00",
      "indAggdocorigine" : 6.936593194494838,
      "progPdcDo65" : 4.075306827525243,
      "flgStornoqtaval" : 2,
      "numnsdoc" : 4.515863748649669,
      "dittaCg18" : 8.81377937009168,
      "indTipodoc" : 5,
      "numregrifCo99" : "numregrifCo99",
      "numvsdoc" : "numvsdoc",
      "progPdcrifDo65" : 2.674423984487264
    }, {
      "flgNsdocbis" : 7.686670838404092,
      "qta2mov" : 0.05965928697733491,
      "flgNonpiuevpdc" : 7.321091499885957,
      "notevsdoc" : "notevsdoc",
      "seqfase" : 5.099298781640682,
      "datansdoc" : "2000-01-23T04:56:07.000+00:00",
      "indQtaordres" : 3,
      "seznsdoc" : "seznsdoc",
      "indStipodoc" : 0,
      "datansconf" : "2000-01-23T04:56:07.000+00:00",
      "datavsconf" : "2000-01-23T04:56:07.000+00:00",
      "progRiga" : 6.568304668801491,
      "valoremov" : 9.728706165995554,
      "progRigarifDo30" : 7.338782761819433,
      "progRigapadreDo30" : 1.4985931822280574,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "notensdoc" : "notensdoc",
      "progRif" : 2.3317418552851765,
      "rifvsdoc" : "rifvsdoc",
      "additionalData" : {
        "key" : ""
      },
      "numregpadreCo99" : "numregpadreCo99",
      "flgAggprescvar" : 7.964879197514727,
      "qta1mov" : 9.739448828157911,
      "collimov" : 9.140242185517025,
      "flgAggqtatrasf" : 4,
      "rifnsdoc" : "rifnsdoc",
      "fasePd12" : 4.39343993729625,
      "datavsdoc" : "2000-01-23T04:56:07.000+00:00",
      "indAggdocorigine" : 6.936593194494838,
      "progPdcDo65" : 4.075306827525243,
      "flgStornoqtaval" : 2,
      "numnsdoc" : 4.515863748649669,
      "dittaCg18" : 8.81377937009168,
      "indTipodoc" : 5,
      "numregrifCo99" : "numregrifCo99",
      "numvsdoc" : "numvsdoc",
      "progPdcrifDo65" : 2.674423984487264
    } ]
  }, {
    "flgContribinteg" : 7,
    "statoAttualeCO" : {
      "statiDisponibili" : [ null, null ],
      "statoCorrente" : {
        "indTipoStato" : 8,
        "idStato" : 2,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "seq" : 2
      },
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "prezzo2iva" : 9.806951670467935,
    "documentoRigaProgettiMG" : {
      "codDipPd06" : "codDipPd06",
      "attivitaPd0d" : "attivitaPd0d",
      "codProgcol" : "codProgcol",
      "idattrezzaturaVc02" : 6,
      "idartepuVc02" : 2,
      "nodoPd0c" : "nodoPd0c",
      "idmedia" : 0.8411762798681321,
      "codProgetto" : "codProgetto",
      "codSprogetto" : 4.141296055235948,
      "dittaCg18" : 8.910869026866926,
      "codCommessa" : "codCommessa",
      "nodorifcolPd0c" : "nodorifcolPd0c",
      "codScommessa" : 8.276461147928103,
      "spesaPd64" : "spesaPd64",
      "pluginData" : {
        "key" : ""
      },
      "nodorifPd0c" : "nodorifPd0c",
      "additionalData" : {
        "key" : ""
      },
      "codSprogcol" : 6.458262756685686
    },
    "cpmerceCg24" : "cpmerceCg24",
    "profondita" : 1.3949519358941398,
    "prezzo2" : 6.966044574347761,
    "ditta" : 3.111202833403195,
    "prezzo1" : 6.173804034172511,
    "um1" : "um1",
    "indtiporiga" : 7,
    "documentoRigaCOINMG" : {
      "pdcvdsorigPc01" : 4.010300976654761,
      "pdcdestPc01" : 8.262795412896967,
      "vdsorigPc03" : "vdsorigPc03",
      "contoorigPc03" : "contoorigPc03",
      "idmediaCg99" : 3.209082285545927,
      "contodestPc03" : "contodestPc03",
      "flgEsclriga" : 4.4935252719377825,
      "vdsdestPc03" : "vdsdestPc03",
      "dittaCg18" : 1.7045651386993,
      "pdcorigPc01" : 2.9805393113464476,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "pdcvdsdestPc01" : 9.146339979307802
    },
    "pluginData" : {
      "key" : ""
    },
    "um2" : "um2",
    "additionalData" : {
      "key" : ""
    },
    "barcode" : "barcode",
    "fatconv" : 9.897492629215506,
    "magimp" : 4.332304821875894,
    "coddepcolMg58" : "coddepcolMg58",
    "pesol" : 0.58919091925136,
    "prezzo1iva" : 4.8789878742268815,
    "peson" : 2.535258963197524,
    "flgContribprev" : 0,
    "importo" : 3.804112695731078,
    "pzconf" : 1.5970080735609526,
    "flgPriceDiscForce" : true,
    "flgRitenas" : 2,
    "progPadre" : 1.2555055362323109,
    "testoFissoMG" : {
      "descr" : "descr",
      "datainizioval" : "2000-01-23T04:56:07.000+00:00",
      "indTipoevas" : 4.4935252719377825,
      "idprov" : 1,
      "idmediaCg99" : 9.402167524121316,
      "codice" : "codice",
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "testo" : "testo"
    },
    "codescl4Mg82" : "codescl4Mg82",
    "codartMg66" : "codartMg66",
    "rigaIntra" : {
      "meserif" : 5.829097284708605,
      "modincassoIn04" : "modincassoIn04",
      "paesepagCg07" : 8.071139232091417,
      "percadegvalstat" : 8.257837395465918,
      "fatconvumsuppl" : 2.831445253698411,
      "codiceCg72" : "codiceCg72",
      "unsuppl" : 9.878259040728768,
      "paeseorigCg07" : 1.2786903972794905,
      "provdest" : "provdest",
      "provorig" : "provorig",
      "progRiga" : 5.547564904556697,
      "indTipoCg72" : 5.499986845135928,
      "annorif" : 2.924533207692744,
      "dittaCg18" : 8.238101405568635,
      "moderogazioneIn03" : "moderogazioneIn03",
      "paesedestCg07" : 0.7242789830362995,
      "massanetta" : 8.569658089905484,
      "paeseprovCg07" : 2.7107020326702136,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "flgEsclintra" : 6.345503614942988
    },
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "spesaVariaMG" : {
      "flgRicfatriep" : 5.6644160867523485,
      "flgVentstat" : 4.372688051310086,
      "flgIvaincl" : 1,
      "indTipoevas" : 9.785002165136461,
      "idmediaCg99" : 5.7911894223693885,
      "codice" : "codice",
      "indTotspese" : 7.92839742024475,
      "indRotturacorpo" : 1.0639121808530916,
      "indTipospesa" : 7.3718573971919445,
      "indGesintra" : 3.8008573585058016,
      "descr" : "descr",
      "indFatriep" : 5.974942028545841,
      "indTipotot" : 7.726998920545485,
      "indTipoaliq" : 3.2841216543560217,
      "pluginData" : {
        "key" : ""
      },
      "flgVentamm" : 1.5970080735609526,
      "additionalData" : {
        "key" : ""
      },
      "flgOramin" : 3.812761638325517
    },
    "rigaEstesa" : [ {
      "alfst10" : "alfst10",
      "datast2" : "2000-01-23T04:56:07.000+00:00",
      "numst12" : 6.642953999458534,
      "datast1" : "2000-01-23T04:56:07.000+00:00",
      "alfst12" : "alfst12",
      "alfst11" : "alfst11",
      "idmediaCg99" : 5.726375546151009,
      "datast4" : "2000-01-23T04:56:07.000+00:00",
      "numst10" : 7.129168897240568,
      "datast3" : "2000-01-23T04:56:07.000+00:00",
      "numst11" : 6.370609851066415,
      "progRiga" : 2.008994665592807,
      "datast6" : "2000-01-23T04:56:07.000+00:00",
      "datast5" : "2000-01-23T04:56:07.000+00:00",
      "alfst4" : "alfst4",
      "alfst5" : "alfst5",
      "alfst6" : "alfst6",
      "alfst7" : "alfst7",
      "alfst8" : "alfst8",
      "alfst9" : "alfst9",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "alfst1" : "alfst1",
      "alfst2" : "alfst2",
      "alfst3" : "alfst3",
      "flgSt2" : 2.5524281586707875,
      "flgSt3" : 4.432841187680573,
      "flgSt4" : 3.5117904067536143,
      "numst8" : 9.007961177824221,
      "numst7" : 3.7846852362095262,
      "numst9" : 1.5743672347582194,
      "prog" : 4.863793115215697,
      "numst2" : 9.505836306729838,
      "numst1" : 7.464202015255506,
      "numst4" : 2.684056218962324,
      "dittaCg18" : 8.782449469456207,
      "numst3" : 8.768153453040833,
      "numst6" : 1.0046985756074744,
      "numst5" : 6.712603870693706,
      "indSt1" : 9.721046668148785,
      "indSt2" : 2.922265432447957,
      "flgSt1" : 0.4008378390304357
    }, {
      "alfst10" : "alfst10",
      "datast2" : "2000-01-23T04:56:07.000+00:00",
      "numst12" : 6.642953999458534,
      "datast1" : "2000-01-23T04:56:07.000+00:00",
      "alfst12" : "alfst12",
      "alfst11" : "alfst11",
      "idmediaCg99" : 5.726375546151009,
      "datast4" : "2000-01-23T04:56:07.000+00:00",
      "numst10" : 7.129168897240568,
      "datast3" : "2000-01-23T04:56:07.000+00:00",
      "numst11" : 6.370609851066415,
      "progRiga" : 2.008994665592807,
      "datast6" : "2000-01-23T04:56:07.000+00:00",
      "datast5" : "2000-01-23T04:56:07.000+00:00",
      "alfst4" : "alfst4",
      "alfst5" : "alfst5",
      "alfst6" : "alfst6",
      "alfst7" : "alfst7",
      "alfst8" : "alfst8",
      "alfst9" : "alfst9",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "alfst1" : "alfst1",
      "alfst2" : "alfst2",
      "alfst3" : "alfst3",
      "flgSt2" : 2.5524281586707875,
      "flgSt3" : 4.432841187680573,
      "flgSt4" : 3.5117904067536143,
      "numst8" : 9.007961177824221,
      "numst7" : 3.7846852362095262,
      "numst9" : 1.5743672347582194,
      "prog" : 4.863793115215697,
      "numst2" : 9.505836306729838,
      "numst1" : 7.464202015255506,
      "numst4" : 2.684056218962324,
      "dittaCg18" : 8.782449469456207,
      "numst3" : 8.768153453040833,
      "numst6" : 1.0046985756074744,
      "numst5" : 6.712603870693706,
      "indSt1" : 9.721046668148785,
      "indSt2" : 2.922265432447957,
      "flgSt1" : 0.4008378390304357
    } ],
    "causmagMg51" : 8.37823741034869,
    "cup" : "cup",
    "cig" : "cig",
    "codescl3Mg82" : "codescl3Mg82",
    "progvisuasta" : 5.6644160867523485,
    "rigaOrdine" : {
      "codTraclegdb" : "codTraclegdb",
      "dataconsint" : "2000-01-23T04:56:07.000+00:00",
      "datalancio" : "2000-01-23T04:56:07.000+00:00",
      "flgNonpiuev" : 9,
      "datainizlav" : "2000-01-23T04:56:07.000+00:00",
      "qta2trasfddtcl" : 4.318826475758856,
      "flgConsconf" : 7,
      "flgRicpreev" : 6,
      "collitrasfp" : 9.966789814889403,
      "progRiga" : 0.6895265584691002,
      "qta2lanc" : 0.29551818216563164,
      "qta2prel" : 0.7370530802760489,
      "collicons" : 8.780989965779524,
      "qta2trasfp" : 9.908114046741538,
      "codPiano" : "codPiano",
      "flgNosugg" : 1,
      "numpiano" : 7.375698277301938,
      "qta1prel" : 8.331741856019029,
      "datapianif" : "2000-01-23T04:56:07.000+00:00",
      "numregCo99" : "numregCo99",
      "qta1cons" : 3.5366534267201475,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datafineoap" : "2000-01-23T04:56:07.000+00:00",
      "flgSospriga" : 9,
      "numpropPd39" : 6.97635352548152,
      "qta1lanc" : 5.267310321293582,
      "contpcarPd79" : 9.748669620880193,
      "indStatodescsp" : 6,
      "qta1trasfddtcl" : 7.6528347060559,
      "flgNoevasparz" : 0,
      "ggtollercons" : 9.372628622067484,
      "qta2cons" : 8.223593720381889,
      "collitrasfddtcl" : 5.616380282218067,
      "indStatocons" : 6,
      "codTraclegwbs" : "codTraclegwbs",
      "datacons" : "2000-01-23T04:56:07.000+00:00",
      "valorecons" : 7.541803065493349,
      "dittaCg18" : 6.203595661339589,
      "indEvasdescsp" : 8,
      "qta1trasfp" : 9.120398275527268,
      "dataconsorig" : "2000-01-23T04:56:07.000+00:00",
      "datainizoap" : "2000-01-23T04:56:07.000+00:00",
      "progRigpiaPd80" : 9.290244967928562
    },
    "flgRitacc" : 3,
    "svar2" : "svar2",
    "codschedaMg42" : "codschedaMg42",
    "svar1" : "svar1",
    "capacita" : 5.312489704336296,
    "fatconvcf" : 5.877124706116695,
    "codescl2Mg82" : "codescl2Mg82",
    "colli" : 7.606863723092579,
    "codartcli" : "codartcli",
    "altezza" : 0.4182561061793122,
    "opzioneMg5e" : "opzioneMg5e",
    "stagioneMg5t" : 7,
    "scper1" : 3.8008573585058016,
    "indlisacqven" : 8,
    "qta2" : 5.7911894223693885,
    "scper2" : 1.0639121808530916,
    "scper3" : 3.2841216543560217,
    "scper4" : 9.785002165136461,
    "indlisfisso" : 4,
    "magper2" : 9.386524999783381,
    "qta1" : 4.372688051310086,
    "estdescart" : "estdescart",
    "codescl1Mg82" : "codescl1Mg82",
    "documentoRigaRateiMG" : {
      "flgDaav" : 0.11859130807119977,
      "dataregesinc" : "2000-01-23T04:56:07.000+00:00",
      "imprettcostobu" : 7.390706075830692,
      "imprettcostobuVal" : 1.0502890910539986,
      "importo" : 0.36062689002149373,
      "percforf" : 4.1661834558007,
      "adatacomp" : "2000-01-23T04:56:07.000+00:00",
      "indTipomovbu" : 2.0981949483881577,
      "dadatacomp" : "2000-01-23T04:56:07.000+00:00",
      "indTipocomp" : 6.176386745020588,
      "dittaCg18" : 6.918231485891953,
      "flgDisatcoge" : 4.637509675190766,
      "codBeneusato" : 7.88722683998926,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "contoparCg24" : "contoparCg24",
      "dataregesprec" : "2000-01-23T04:56:07.000+00:00"
    },
    "rigaPersonalizzata" : [ {
      "idmediaCg99" : 5.304373278797373,
      "progRiga" : 9.610516429629122,
      "datapers1" : "2000-01-23T04:56:07.000+00:00",
      "datapers2" : "2000-01-23T04:56:07.000+00:00",
      "alfpers9" : "alfpers9",
      "datapers3" : "2000-01-23T04:56:07.000+00:00",
      "datapers4" : "2000-01-23T04:56:07.000+00:00",
      "datapers5" : "2000-01-23T04:56:07.000+00:00",
      "datapers6" : "2000-01-23T04:56:07.000+00:00",
      "alfpers4" : "alfpers4",
      "indPers1" : 8.708394192403432,
      "alfpers3" : "alfpers3",
      "indPers2" : 0.8164256701298711,
      "alfpers2" : "alfpers2",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "alfpers1" : "alfpers1",
      "additionalData" : {
        "key" : ""
      },
      "alfpers8" : "alfpers8",
      "alfpers7" : "alfpers7",
      "alfpers6" : "alfpers6",
      "alfpers5" : "alfpers5",
      "numpers11" : 0.313237310471568,
      "numpers1" : 4.13177941962639,
      "numpers12" : 7.701777079007398,
      "numpers2" : 2.1871588311421153,
      "numpers3" : 0.05189710095898081,
      "numpers10" : 4.4580628783592156,
      "flgPers2" : 7.766860781935265,
      "numpers8" : 3.0659734456354117,
      "flgPers1" : 8.875589915795528,
      "numpers9" : 8.638367073739522,
      "numpers4" : 4.403697036782718,
      "numpers5" : 6.936499209818381,
      "flgPers4" : 6.720288821326667,
      "numpers6" : 4.035133329541982,
      "prog" : 5.948961008630453,
      "flgPers3" : 1.6056289151258096,
      "numpers7" : 2.1518888575299036,
      "dittaCg18" : 7.437703257022269,
      "alfpers10" : "alfpers10",
      "alfpers11" : "alfpers11",
      "alfpers12" : "alfpers12"
    }, {
      "idmediaCg99" : 5.304373278797373,
      "progRiga" : 9.610516429629122,
      "datapers1" : "2000-01-23T04:56:07.000+00:00",
      "datapers2" : "2000-01-23T04:56:07.000+00:00",
      "alfpers9" : "alfpers9",
      "datapers3" : "2000-01-23T04:56:07.000+00:00",
      "datapers4" : "2000-01-23T04:56:07.000+00:00",
      "datapers5" : "2000-01-23T04:56:07.000+00:00",
      "datapers6" : "2000-01-23T04:56:07.000+00:00",
      "alfpers4" : "alfpers4",
      "indPers1" : 8.708394192403432,
      "alfpers3" : "alfpers3",
      "indPers2" : 0.8164256701298711,
      "alfpers2" : "alfpers2",
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "alfpers1" : "alfpers1",
      "additionalData" : {
        "key" : ""
      },
      "alfpers8" : "alfpers8",
      "alfpers7" : "alfpers7",
      "alfpers6" : "alfpers6",
      "alfpers5" : "alfpers5",
      "numpers11" : 0.313237310471568,
      "numpers1" : 4.13177941962639,
      "numpers12" : 7.701777079007398,
      "numpers2" : 2.1871588311421153,
      "numpers3" : 0.05189710095898081,
      "numpers10" : 4.4580628783592156,
      "flgPers2" : 7.766860781935265,
      "numpers8" : 3.0659734456354117,
      "flgPers1" : 8.875589915795528,
      "numpers9" : 8.638367073739522,
      "numpers4" : 4.403697036782718,
      "numpers5" : 6.936499209818381,
      "flgPers4" : 6.720288821326667,
      "numpers6" : 4.035133329541982,
      "prog" : 5.948961008630453,
      "flgPers3" : 1.6056289151258096,
      "numpers7" : 2.1518888575299036,
      "dittaCg18" : 7.437703257022269,
      "alfpers10" : "alfpers10",
      "alfpers11" : "alfpers11",
      "alfpers12" : "alfpers12"
    } ],
    "documentoRigaProvvigioniMG" : [ {
      "idagenteMg17" : 0,
      "percprov" : 9.456612101333725,
      "imporprov" : 4.943637496515336,
      "indRegprov" : 0.4867146239815201,
      "imponprov" : 7.3842318535314,
      "imponprovVal" : 6.749525837406151,
      "progRiga" : 9.721723570087065,
      "imporprovVal" : 0.30134145536422907,
      "dittaCg18" : 2.9679475177256287,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "flgVarprov" : 5.747795090145878,
      "additionalData" : {
        "key" : ""
      },
      "codiceAgente" : "codiceAgente"
    }, {
      "idagenteMg17" : 0,
      "percprov" : 9.456612101333725,
      "imporprov" : 4.943637496515336,
      "indRegprov" : 0.4867146239815201,
      "imponprov" : 7.3842318535314,
      "imponprovVal" : 6.749525837406151,
      "progRiga" : 9.721723570087065,
      "imporprovVal" : 0.30134145536422907,
      "dittaCg18" : 2.9679475177256287,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "flgVarprov" : 5.747795090145878,
      "additionalData" : {
        "key" : ""
      },
      "codiceAgente" : "codiceAgente"
    } ],
    "magper1" : 2.7977867356748476,
    "tara" : 9.402167524121316,
    "packaging" : {
      "umPeso" : "umPeso",
      "qta2Conf" : 7.273019311111276,
      "qta1Conf" : 8.250639315618633,
      "pesoLordo" : 3.8156682252305574,
      "umCapac" : "umCapac",
      "colliConf" : 3.196820582978078,
      "progRiga" : 5.573385265048522,
      "volume" : 2.4669941706755685,
      "umVolume" : "umVolume",
      "dittaCg18" : 5.296102445648278,
      "codConfezMg96" : "codConfezMg96",
      "capacita" : 2.026856458177285,
      "pzConf" : 3.0269458094096646,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "pesoNetto" : 1.9626702727164813
    },
    "rigaLotti" : [ {
      "cliforCg44" : 5.5569822283364845,
      "note" : "note",
      "flgNonpiuev" : 8.546645780823726,
      "codSscc" : "codSscc",
      "progMg4f" : 8.310924482277276,
      "tipocfCg44" : 4.757484754617172,
      "idmediaCg99" : 4.784107115651097,
      "codArtMg66" : "codArtMg66",
      "codDepMg58" : "codDepMg58",
      "codProgPd14" : "codProgPd14",
      "progRiga" : 7.886583288201395,
      "progRigarifDo30" : 1.4793631642421967,
      "codConfezMg96" : "codConfezMg96",
      "numregCo99" : "numregCo99",
      "qta1cons" : 1.8407572303125541,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codBagnomat" : "codBagnomat",
      "codArtpfMg66" : "codArtpfMg66",
      "codPallets" : "codPallets",
      "opzionepfMg5e" : "opzionepfMg5e",
      "opzioneMg5e" : "opzioneMg5e",
      "qta2" : 7.200147194425509,
      "codLottopfMg4g" : "codLottopfMg4g",
      "codLottoMg4g" : "codLottoMg4g",
      "sernum" : "sernum",
      "scadenza" : "2000-01-23T04:56:07.000+00:00",
      "anagraficaLotto" : {
        "note" : "note",
        "dittaCg18" : 4.754071900895484,
        "idmediaCg99" : 1.1864130338603074,
        "codArtMg66" : "codArtMg66",
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "codLotto" : "codLotto",
        "additionalData" : {
          "key" : ""
        },
        "datascad" : "2000-01-23T04:56:07.000+00:00",
        "lib1" : 3.8601930294054942,
        "desclotto" : "desclotto",
        "opzioneMg5e" : "opzioneMg5e"
      },
      "qta1" : 2.719219329469812,
      "qta2cons" : 7.135782839148426,
      "ubicazcollMg97" : "ubicazcollMg97",
      "progRifDo52" : 6.607129449620165,
      "prog" : 8.036294790673514,
      "parametroMovimentazioneLotto" : {
        "flgNote" : 4.5403315819302215,
        "dittaCg18" : 3.8581948879558317,
        "flgAggprogval" : 1.9732909296667345,
        "indGiacsca" : 8.262575023052213,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "prog" : 0.9178980228274691,
        "tipomov" : "tipomov"
      },
      "ubicazMg97" : "ubicazMg97",
      "sotprogPd14" : 1.0348002257634148,
      "dittaCg18" : 5.412786966532157,
      "numregrifCo99" : "numregrifCo99",
      "causmagMg51" : 2.60416377551006
    }, {
      "cliforCg44" : 5.5569822283364845,
      "note" : "note",
      "flgNonpiuev" : 8.546645780823726,
      "codSscc" : "codSscc",
      "progMg4f" : 8.310924482277276,
      "tipocfCg44" : 4.757484754617172,
      "idmediaCg99" : 4.784107115651097,
      "codArtMg66" : "codArtMg66",
      "codDepMg58" : "codDepMg58",
      "codProgPd14" : "codProgPd14",
      "progRiga" : 7.886583288201395,
      "progRigarifDo30" : 1.4793631642421967,
      "codConfezMg96" : "codConfezMg96",
      "numregCo99" : "numregCo99",
      "qta1cons" : 1.8407572303125541,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codBagnomat" : "codBagnomat",
      "codArtpfMg66" : "codArtpfMg66",
      "codPallets" : "codPallets",
      "opzionepfMg5e" : "opzionepfMg5e",
      "opzioneMg5e" : "opzioneMg5e",
      "qta2" : 7.200147194425509,
      "codLottopfMg4g" : "codLottopfMg4g",
      "codLottoMg4g" : "codLottoMg4g",
      "sernum" : "sernum",
      "scadenza" : "2000-01-23T04:56:07.000+00:00",
      "anagraficaLotto" : {
        "note" : "note",
        "dittaCg18" : 4.754071900895484,
        "idmediaCg99" : 1.1864130338603074,
        "codArtMg66" : "codArtMg66",
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "codLotto" : "codLotto",
        "additionalData" : {
          "key" : ""
        },
        "datascad" : "2000-01-23T04:56:07.000+00:00",
        "lib1" : 3.8601930294054942,
        "desclotto" : "desclotto",
        "opzioneMg5e" : "opzioneMg5e"
      },
      "qta1" : 2.719219329469812,
      "qta2cons" : 7.135782839148426,
      "ubicazcollMg97" : "ubicazcollMg97",
      "progRifDo52" : 6.607129449620165,
      "prog" : 8.036294790673514,
      "parametroMovimentazioneLotto" : {
        "flgNote" : 4.5403315819302215,
        "dittaCg18" : 3.8581948879558317,
        "flgAggprogval" : 1.9732909296667345,
        "indGiacsca" : 8.262575023052213,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "prog" : 0.9178980228274691,
        "tipomov" : "tipomov"
      },
      "ubicazMg97" : "ubicazMg97",
      "sotprogPd14" : 1.0348002257634148,
      "dittaCg18" : 5.412786966532157,
      "numregrifCo99" : "numregrifCo99",
      "causmagMg51" : 2.60416377551006
    } ],
    "coddepMg58" : "coddepMg58",
    "costotot" : 3.7814124730767915,
    "indtipoomag" : 0,
    "scper5" : 7.3718573971919445,
    "scper6" : 7.726998920545485,
    "indlisprior" : 0,
    "progrRiga" : 3.812761638325517,
    "lineaFa05" : "lineaFa05",
    "codartfor" : "codartfor",
    "numReg" : "numReg",
    "descart" : "descart",
    "alivacompCg28" : "alivacompCg28",
    "base" : 5.299143560275359,
    "scimp" : 5.974942028545841,
    "rigaRiferimenti" : [ {
      "flgNsdocbis" : 7.686670838404092,
      "qta2mov" : 0.05965928697733491,
      "flgNonpiuevpdc" : 7.321091499885957,
      "notevsdoc" : "notevsdoc",
      "seqfase" : 5.099298781640682,
      "datansdoc" : "2000-01-23T04:56:07.000+00:00",
      "indQtaordres" : 3,
      "seznsdoc" : "seznsdoc",
      "indStipodoc" : 0,
      "datansconf" : "2000-01-23T04:56:07.000+00:00",
      "datavsconf" : "2000-01-23T04:56:07.000+00:00",
      "progRiga" : 6.568304668801491,
      "valoremov" : 9.728706165995554,
      "progRigarifDo30" : 7.338782761819433,
      "progRigapadreDo30" : 1.4985931822280574,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "notensdoc" : "notensdoc",
      "progRif" : 2.3317418552851765,
      "rifvsdoc" : "rifvsdoc",
      "additionalData" : {
        "key" : ""
      },
      "numregpadreCo99" : "numregpadreCo99",
      "flgAggprescvar" : 7.964879197514727,
      "qta1mov" : 9.739448828157911,
      "collimov" : 9.140242185517025,
      "flgAggqtatrasf" : 4,
      "rifnsdoc" : "rifnsdoc",
      "fasePd12" : 4.39343993729625,
      "datavsdoc" : "2000-01-23T04:56:07.000+00:00",
      "indAggdocorigine" : 6.936593194494838,
      "progPdcDo65" : 4.075306827525243,
      "flgStornoqtaval" : 2,
      "numnsdoc" : 4.515863748649669,
      "dittaCg18" : 8.81377937009168,
      "indTipodoc" : 5,
      "numregrifCo99" : "numregrifCo99",
      "numvsdoc" : "numvsdoc",
      "progPdcrifDo65" : 2.674423984487264
    }, {
      "flgNsdocbis" : 7.686670838404092,
      "qta2mov" : 0.05965928697733491,
      "flgNonpiuevpdc" : 7.321091499885957,
      "notevsdoc" : "notevsdoc",
      "seqfase" : 5.099298781640682,
      "datansdoc" : "2000-01-23T04:56:07.000+00:00",
      "indQtaordres" : 3,
      "seznsdoc" : "seznsdoc",
      "indStipodoc" : 0,
      "datansconf" : "2000-01-23T04:56:07.000+00:00",
      "datavsconf" : "2000-01-23T04:56:07.000+00:00",
      "progRiga" : 6.568304668801491,
      "valoremov" : 9.728706165995554,
      "progRigarifDo30" : 7.338782761819433,
      "progRigapadreDo30" : 1.4985931822280574,
      "numregCo99" : "numregCo99",
      "pluginData" : {
        "key" : ""
      },
      "notensdoc" : "notensdoc",
      "progRif" : 2.3317418552851765,
      "rifvsdoc" : "rifvsdoc",
      "additionalData" : {
        "key" : ""
      },
      "numregpadreCo99" : "numregpadreCo99",
      "flgAggprescvar" : 7.964879197514727,
      "qta1mov" : 9.739448828157911,
      "collimov" : 9.140242185517025,
      "flgAggqtatrasf" : 4,
      "rifnsdoc" : "rifnsdoc",
      "fasePd12" : 4.39343993729625,
      "datavsdoc" : "2000-01-23T04:56:07.000+00:00",
      "indAggdocorigine" : 6.936593194494838,
      "progPdcDo65" : 4.075306827525243,
      "flgStornoqtaval" : 2,
      "numnsdoc" : 4.515863748649669,
      "dittaCg18" : 8.81377937009168,
      "indTipodoc" : 5,
      "numregrifCo99" : "numregrifCo99",
      "numvsdoc" : "numvsdoc",
      "progPdcrifDo65" : 2.674423984487264
    } ]
  } ],
  "tipodocnumeraz" : 6.438423552598547,
  "lastchange" : "2000-01-23T04:56:07.000+00:00",
  "esclusioneIvaTestata" : 6,
  "testataEstesa" : [ {
    "alfst10" : "alfst10",
    "datast2" : "2000-01-23T04:56:07.000+00:00",
    "numst12" : 9.693372334146686,
    "datast1" : "2000-01-23T04:56:07.000+00:00",
    "alfst12" : "alfst12",
    "alfst11" : "alfst11",
    "idmediaCg99" : 6.677419970877656,
    "datast4" : "2000-01-23T04:56:07.000+00:00",
    "numst10" : 4.966567419166605,
    "datast3" : "2000-01-23T04:56:07.000+00:00",
    "numst11" : 2.9790233918904585,
    "datast6" : "2000-01-23T04:56:07.000+00:00",
    "datast5" : "2000-01-23T04:56:07.000+00:00",
    "alfst4" : "alfst4",
    "alfst5" : "alfst5",
    "alfst6" : "alfst6",
    "alfst7" : "alfst7",
    "alfst8" : "alfst8",
    "alfst9" : "alfst9",
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "alfst1" : "alfst1",
    "alfst2" : "alfst2",
    "alfst3" : "alfst3",
    "flgSt2" : 7.239590766928185,
    "flgSt3" : 6.090696483578148,
    "flgSt4" : 9.852147203726787,
    "numst8" : 4.851239691941878,
    "numst7" : 0.42286244411048224,
    "numst9" : 7.062107048540267,
    "prog" : 8.474710856151638,
    "numst2" : 2.6249013358703053,
    "numst1" : 5.083590215108117,
    "numst4" : 0.9619297253823988,
    "dittaCg18" : 8.018039914932286,
    "numst3" : 3.5742991213280972,
    "numst6" : 1.633699845078339,
    "numst5" : 7.224413148959403,
    "indSt1" : 1.2880645475702646,
    "indSt2" : 1.822577900073098,
    "flgSt1" : 2.6736395633233356
  }, {
    "alfst10" : "alfst10",
    "datast2" : "2000-01-23T04:56:07.000+00:00",
    "numst12" : 9.693372334146686,
    "datast1" : "2000-01-23T04:56:07.000+00:00",
    "alfst12" : "alfst12",
    "alfst11" : "alfst11",
    "idmediaCg99" : 6.677419970877656,
    "datast4" : "2000-01-23T04:56:07.000+00:00",
    "numst10" : 4.966567419166605,
    "datast3" : "2000-01-23T04:56:07.000+00:00",
    "numst11" : 2.9790233918904585,
    "datast6" : "2000-01-23T04:56:07.000+00:00",
    "datast5" : "2000-01-23T04:56:07.000+00:00",
    "alfst4" : "alfst4",
    "alfst5" : "alfst5",
    "alfst6" : "alfst6",
    "alfst7" : "alfst7",
    "alfst8" : "alfst8",
    "alfst9" : "alfst9",
    "numregCo99" : "numregCo99",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "alfst1" : "alfst1",
    "alfst2" : "alfst2",
    "alfst3" : "alfst3",
    "flgSt2" : 7.239590766928185,
    "flgSt3" : 6.090696483578148,
    "flgSt4" : 9.852147203726787,
    "numst8" : 4.851239691941878,
    "numst7" : 0.42286244411048224,
    "numst9" : 7.062107048540267,
    "prog" : 8.474710856151638,
    "numst2" : 2.6249013358703053,
    "numst1" : 5.083590215108117,
    "numst4" : 0.9619297253823988,
    "dittaCg18" : 8.018039914932286,
    "numst3" : 3.5742991213280972,
    "numst6" : 1.633699845078339,
    "numst5" : 7.224413148959403,
    "indSt1" : 1.2880645475702646,
    "indSt2" : 1.822577900073098,
    "flgSt1" : 2.6736395633233356
  } ]
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}

