/* 
 * TSE Cloud - MG
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.1000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// UnloadComponentKitParameterDTO
    /// </summary>
    [DataContract]
        public partial class UnloadComponentKitParameterDTO :  IEquatable<UnloadComponentKitParameterDTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="UnloadComponentKitParameterDTO" /> class.
        /// </summary>
        /// <param name="documentCode">Document code for uploading component kit (required).</param>
        /// <param name="postingDate">Document posting date.</param>
        /// <param name="documentDate">Document date.</param>
        /// <param name="documentSectional">Document sectional.</param>
        /// <param name="documentNumber">Document number.</param>
        /// <param name="storageCode">Storage code.</param>
        /// <param name="indExplosionLevel">Explosion level type&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - 0 - All levels&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - 1 - Up to level&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - 2 - Up to 1st level&lt;/li&gt;&lt;/ul&gt; (default to &quot;0&quot;).</param>
        /// <param name="numberLevel">Number level if explosion level type is up to level  (default to 1).</param>
        /// <param name="indSemiFinishedProducts">Semi-finished goods handling type&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - 0 - Nessuno&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - 1 - Unload only&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - 2 - Load and unload&lt;/li&gt;&lt;/ul&gt; (default to &quot;0&quot;).</param>
        /// <param name="recalculateCostKitProduct">Recalculation of the cost of Kit products (default to false).</param>
        /// <param name="includeBOMComponents">Also include the BOM components (1st level) in the download (default to false).</param>
        public UnloadComponentKitParameterDTO(string documentCode = default(string), DateTime? postingDate = default(DateTime?), DateTime? documentDate = default(DateTime?), string documentSectional = default(string), double? documentNumber = default(double?), string storageCode = default(string), string indExplosionLevel = "0", int? numberLevel = 1, string indSemiFinishedProducts = "0", bool? recalculateCostKitProduct = false, bool? includeBOMComponents = false)
        {
            // to ensure "documentCode" is required (not null)
            if (documentCode == null)
            {
                throw new InvalidDataException("documentCode is a required property for UnloadComponentKitParameterDTO and cannot be null");
            }
            else
            {
                this.DocumentCode = documentCode;
            }
            this.PostingDate = postingDate;
            this.DocumentDate = documentDate;
            this.DocumentSectional = documentSectional;
            this.DocumentNumber = documentNumber;
            this.StorageCode = storageCode;
            // use default value if no "indExplosionLevel" provided
            if (indExplosionLevel == null)
            {
                this.IndExplosionLevel = "0";
            }
            else
            {
                this.IndExplosionLevel = indExplosionLevel;
            }
            // use default value if no "numberLevel" provided
            if (numberLevel == null)
            {
                this.NumberLevel = 1;
            }
            else
            {
                this.NumberLevel = numberLevel;
            }
            // use default value if no "indSemiFinishedProducts" provided
            if (indSemiFinishedProducts == null)
            {
                this.IndSemiFinishedProducts = "0";
            }
            else
            {
                this.IndSemiFinishedProducts = indSemiFinishedProducts;
            }
            // use default value if no "recalculateCostKitProduct" provided
            if (recalculateCostKitProduct == null)
            {
                this.RecalculateCostKitProduct = false;
            }
            else
            {
                this.RecalculateCostKitProduct = recalculateCostKitProduct;
            }
            // use default value if no "includeBOMComponents" provided
            if (includeBOMComponents == null)
            {
                this.IncludeBOMComponents = false;
            }
            else
            {
                this.IncludeBOMComponents = includeBOMComponents;
            }
        }
        
        /// <summary>
        /// Document code for uploading component kit
        /// </summary>
        /// <value>Document code for uploading component kit</value>
        [DataMember(Name="documentCode", EmitDefaultValue=false)]
        public string DocumentCode { get; set; }

        /// <summary>
        /// Document posting date
        /// </summary>
        /// <value>Document posting date</value>
        [DataMember(Name="postingDate", EmitDefaultValue=false)]
        public DateTime? PostingDate { get; set; }

        /// <summary>
        /// Document date
        /// </summary>
        /// <value>Document date</value>
        [DataMember(Name="documentDate", EmitDefaultValue=false)]
        public DateTime? DocumentDate { get; set; }

        /// <summary>
        /// Document sectional
        /// </summary>
        /// <value>Document sectional</value>
        [DataMember(Name="documentSectional", EmitDefaultValue=false)]
        public string DocumentSectional { get; set; }

        /// <summary>
        /// Document number
        /// </summary>
        /// <value>Document number</value>
        [DataMember(Name="documentNumber", EmitDefaultValue=false)]
        public double? DocumentNumber { get; set; }

        /// <summary>
        /// Storage code
        /// </summary>
        /// <value>Storage code</value>
        [DataMember(Name="storageCode", EmitDefaultValue=false)]
        public string StorageCode { get; set; }

        /// <summary>
        /// Explosion level type&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - 0 - All levels&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - 1 - Up to level&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - 2 - Up to 1st level&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>Explosion level type&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - 0 - All levels&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - 1 - Up to level&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - 2 - Up to 1st level&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indExplosionLevel", EmitDefaultValue=false)]
        public string IndExplosionLevel { get; set; }

        /// <summary>
        /// Number level if explosion level type is up to level 
        /// </summary>
        /// <value>Number level if explosion level type is up to level </value>
        [DataMember(Name="numberLevel", EmitDefaultValue=false)]
        public int? NumberLevel { get; set; }

        /// <summary>
        /// Semi-finished goods handling type&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - 0 - Nessuno&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - 1 - Unload only&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - 2 - Load and unload&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>Semi-finished goods handling type&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - 0 - Nessuno&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - 1 - Unload only&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - 2 - Load and unload&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indSemiFinishedProducts", EmitDefaultValue=false)]
        public string IndSemiFinishedProducts { get; set; }

        /// <summary>
        /// Recalculation of the cost of Kit products
        /// </summary>
        /// <value>Recalculation of the cost of Kit products</value>
        [DataMember(Name="recalculateCostKitProduct", EmitDefaultValue=false)]
        public bool? RecalculateCostKitProduct { get; set; }

        /// <summary>
        /// Also include the BOM components (1st level) in the download
        /// </summary>
        /// <value>Also include the BOM components (1st level) in the download</value>
        [DataMember(Name="includeBOMComponents", EmitDefaultValue=false)]
        public bool? IncludeBOMComponents { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class UnloadComponentKitParameterDTO {\n");
            sb.Append("  DocumentCode: ").Append(DocumentCode).Append("\n");
            sb.Append("  PostingDate: ").Append(PostingDate).Append("\n");
            sb.Append("  DocumentDate: ").Append(DocumentDate).Append("\n");
            sb.Append("  DocumentSectional: ").Append(DocumentSectional).Append("\n");
            sb.Append("  DocumentNumber: ").Append(DocumentNumber).Append("\n");
            sb.Append("  StorageCode: ").Append(StorageCode).Append("\n");
            sb.Append("  IndExplosionLevel: ").Append(IndExplosionLevel).Append("\n");
            sb.Append("  NumberLevel: ").Append(NumberLevel).Append("\n");
            sb.Append("  IndSemiFinishedProducts: ").Append(IndSemiFinishedProducts).Append("\n");
            sb.Append("  RecalculateCostKitProduct: ").Append(RecalculateCostKitProduct).Append("\n");
            sb.Append("  IncludeBOMComponents: ").Append(IncludeBOMComponents).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as UnloadComponentKitParameterDTO);
        }

        /// <summary>
        /// Returns true if UnloadComponentKitParameterDTO instances are equal
        /// </summary>
        /// <param name="input">Instance of UnloadComponentKitParameterDTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(UnloadComponentKitParameterDTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.DocumentCode == input.DocumentCode ||
                    (this.DocumentCode != null &&
                    this.DocumentCode.Equals(input.DocumentCode))
                ) && 
                (
                    this.PostingDate == input.PostingDate ||
                    (this.PostingDate != null &&
                    this.PostingDate.Equals(input.PostingDate))
                ) && 
                (
                    this.DocumentDate == input.DocumentDate ||
                    (this.DocumentDate != null &&
                    this.DocumentDate.Equals(input.DocumentDate))
                ) && 
                (
                    this.DocumentSectional == input.DocumentSectional ||
                    (this.DocumentSectional != null &&
                    this.DocumentSectional.Equals(input.DocumentSectional))
                ) && 
                (
                    this.DocumentNumber == input.DocumentNumber ||
                    (this.DocumentNumber != null &&
                    this.DocumentNumber.Equals(input.DocumentNumber))
                ) && 
                (
                    this.StorageCode == input.StorageCode ||
                    (this.StorageCode != null &&
                    this.StorageCode.Equals(input.StorageCode))
                ) && 
                (
                    this.IndExplosionLevel == input.IndExplosionLevel ||
                    (this.IndExplosionLevel != null &&
                    this.IndExplosionLevel.Equals(input.IndExplosionLevel))
                ) && 
                (
                    this.NumberLevel == input.NumberLevel ||
                    (this.NumberLevel != null &&
                    this.NumberLevel.Equals(input.NumberLevel))
                ) && 
                (
                    this.IndSemiFinishedProducts == input.IndSemiFinishedProducts ||
                    (this.IndSemiFinishedProducts != null &&
                    this.IndSemiFinishedProducts.Equals(input.IndSemiFinishedProducts))
                ) && 
                (
                    this.RecalculateCostKitProduct == input.RecalculateCostKitProduct ||
                    (this.RecalculateCostKitProduct != null &&
                    this.RecalculateCostKitProduct.Equals(input.RecalculateCostKitProduct))
                ) && 
                (
                    this.IncludeBOMComponents == input.IncludeBOMComponents ||
                    (this.IncludeBOMComponents != null &&
                    this.IncludeBOMComponents.Equals(input.IncludeBOMComponents))
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.DocumentCode != null)
                    hashCode = hashCode * 59 + this.DocumentCode.GetHashCode();
                if (this.PostingDate != null)
                    hashCode = hashCode * 59 + this.PostingDate.GetHashCode();
                if (this.DocumentDate != null)
                    hashCode = hashCode * 59 + this.DocumentDate.GetHashCode();
                if (this.DocumentSectional != null)
                    hashCode = hashCode * 59 + this.DocumentSectional.GetHashCode();
                if (this.DocumentNumber != null)
                    hashCode = hashCode * 59 + this.DocumentNumber.GetHashCode();
                if (this.StorageCode != null)
                    hashCode = hashCode * 59 + this.StorageCode.GetHashCode();
                if (this.IndExplosionLevel != null)
                    hashCode = hashCode * 59 + this.IndExplosionLevel.GetHashCode();
                if (this.NumberLevel != null)
                    hashCode = hashCode * 59 + this.NumberLevel.GetHashCode();
                if (this.IndSemiFinishedProducts != null)
                    hashCode = hashCode * 59 + this.IndSemiFinishedProducts.GetHashCode();
                if (this.RecalculateCostKitProduct != null)
                    hashCode = hashCode * 59 + this.RecalculateCostKitProduct.GetHashCode();
                if (this.IncludeBOMComponents != null)
                    hashCode = hashCode * 59 + this.IncludeBOMComponents.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
