/* 
 * TSE Cloud - MG
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.1000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// MG58_DEPOSITI - Deposito&lt;br&gt;Proprietà chiave:&lt;ul&gt;&lt;li&gt;&lt;b&gt;CodDep&lt;/b&gt;&lt;/li&gt;&lt;li&gt;&lt;b&gt;DittaCg18&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;
    /// </summary>
    [DataContract]
        public partial class StorageWHDTO :  IEquatable<StorageWHDTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="StorageWHDTO" /> class.
        /// </summary>
        /// <param name="capdep">MG58_CAPDEP - Cap.</param>
        /// <param name="codDep">MG58_CODDEP - Codice deposito (required).</param>
        /// <param name="dataatt">MG58_DATAATT - Data attivazione (required).</param>
        /// <param name="datacess">MG58_DATACESS - Data cessazione.</param>
        /// <param name="descrdep">MG58_DESCRDEP - Descrizione.</param>
        /// <param name="dittaCg18">MG58_DITTA_CG18 - Ditta (default to 0).</param>
        /// <param name="faxnumdep">MG58_FAXNUMDEP - Fax.</param>
        /// <param name="flgDepprinc">MG58_FLGDEPPRINC - Deposito principale&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="indEmail">MG58_INDEMAIL - Email.</param>
        /// <param name="indIdep">MG58_INDIDEP - Indirizzo deposito.</param>
        /// <param name="indInterest">MG58_INDINTEREST - Tipo deposito&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Interno&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Esterno&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="locdep">MG58_LOCDEP - Località.</param>
        /// <param name="provdep">MG58_PROVDEP - Prov..</param>
        /// <param name="respdep">MG58_RESPDEP - Responsabile.</param>
        /// <param name="telnumdep">MG58_TELNUMDEP - Telefono.</param>
        /// <param name="locationWH">locationWH.</param>
        /// <param name="extensionData">extensionData.</param>
        /// <param name="additionalData">additionalData.</param>
        /// <param name="pluginData">pluginData.</param>
        public StorageWHDTO(string capdep = default(string), string codDep = default(string), DateTime? dataatt = default(DateTime?), DateTime? datacess = default(DateTime?), string descrdep = default(string), double? dittaCg18 = 0, string faxnumdep = default(string), double? flgDepprinc = 0, string indEmail = default(string), string indIdep = default(string), double? indInterest = 0, string locdep = default(string), string provdep = default(string), string respdep = default(string), string telnumdep = default(string), List<LocationWHDTO> locationWH = default(List<LocationWHDTO>), List<StringObjectKeyValuePair> extensionData = default(List<StringObjectKeyValuePair>), Dictionary<string, Object> additionalData = default(Dictionary<string, Object>), Dictionary<string, Object> pluginData = default(Dictionary<string, Object>))
        {
            // to ensure "codDep" is required (not null)
            if (codDep == null)
            {
                throw new InvalidDataException("codDep is a required property for StorageWHDTO and cannot be null");
            }
            else
            {
                this.CodDep = codDep;
            }
            // to ensure "dataatt" is required (not null)
            if (dataatt == null)
            {
                throw new InvalidDataException("dataatt is a required property for StorageWHDTO and cannot be null");
            }
            else
            {
                this.Dataatt = dataatt;
            }
            this.Capdep = capdep;
            this.Datacess = datacess;
            this.Descrdep = descrdep;
            // use default value if no "dittaCg18" provided
            if (dittaCg18 == null)
            {
                this.DittaCg18 = 0;
            }
            else
            {
                this.DittaCg18 = dittaCg18;
            }
            this.Faxnumdep = faxnumdep;
            // use default value if no "flgDepprinc" provided
            if (flgDepprinc == null)
            {
                this.FlgDepprinc = 0;
            }
            else
            {
                this.FlgDepprinc = flgDepprinc;
            }
            this.IndEmail = indEmail;
            this.IndIdep = indIdep;
            // use default value if no "indInterest" provided
            if (indInterest == null)
            {
                this.IndInterest = 0;
            }
            else
            {
                this.IndInterest = indInterest;
            }
            this.Locdep = locdep;
            this.Provdep = provdep;
            this.Respdep = respdep;
            this.Telnumdep = telnumdep;
            this.LocationWH = locationWH;
            this.ExtensionData = extensionData;
            this.AdditionalData = additionalData;
            this.PluginData = pluginData;
        }
        
        /// <summary>
        /// MG58_CAPDEP - Cap
        /// </summary>
        /// <value>MG58_CAPDEP - Cap</value>
        [DataMember(Name="capdep", EmitDefaultValue=false)]
        public string Capdep { get; set; }

        /// <summary>
        /// MG58_CODDEP - Codice deposito
        /// </summary>
        /// <value>MG58_CODDEP - Codice deposito</value>
        [DataMember(Name="codDep", EmitDefaultValue=false)]
        public string CodDep { get; set; }

        /// <summary>
        /// MG58_DATAATT - Data attivazione
        /// </summary>
        /// <value>MG58_DATAATT - Data attivazione</value>
        [DataMember(Name="dataatt", EmitDefaultValue=false)]
        public DateTime? Dataatt { get; set; }

        /// <summary>
        /// MG58_DATACESS - Data cessazione
        /// </summary>
        /// <value>MG58_DATACESS - Data cessazione</value>
        [DataMember(Name="datacess", EmitDefaultValue=false)]
        public DateTime? Datacess { get; set; }

        /// <summary>
        /// MG58_DESCRDEP - Descrizione
        /// </summary>
        /// <value>MG58_DESCRDEP - Descrizione</value>
        [DataMember(Name="descrdep", EmitDefaultValue=false)]
        public string Descrdep { get; set; }

        /// <summary>
        /// MG58_DITTA_CG18 - Ditta
        /// </summary>
        /// <value>MG58_DITTA_CG18 - Ditta</value>
        [DataMember(Name="dittaCg18", EmitDefaultValue=false)]
        public double? DittaCg18 { get; set; }

        /// <summary>
        /// MG58_FAXNUMDEP - Fax
        /// </summary>
        /// <value>MG58_FAXNUMDEP - Fax</value>
        [DataMember(Name="faxnumdep", EmitDefaultValue=false)]
        public string Faxnumdep { get; set; }

        /// <summary>
        /// MG58_FLGDEPPRINC - Deposito principale&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG58_FLGDEPPRINC - Deposito principale&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgDepprinc", EmitDefaultValue=false)]
        public double? FlgDepprinc { get; set; }

        /// <summary>
        /// MG58_INDEMAIL - Email
        /// </summary>
        /// <value>MG58_INDEMAIL - Email</value>
        [DataMember(Name="indEmail", EmitDefaultValue=false)]
        public string IndEmail { get; set; }

        /// <summary>
        /// MG58_INDIDEP - Indirizzo deposito
        /// </summary>
        /// <value>MG58_INDIDEP - Indirizzo deposito</value>
        [DataMember(Name="indIdep", EmitDefaultValue=false)]
        public string IndIdep { get; set; }

        /// <summary>
        /// MG58_INDINTEREST - Tipo deposito&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Interno&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Esterno&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG58_INDINTEREST - Tipo deposito&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Interno&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Esterno&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indInterest", EmitDefaultValue=false)]
        public double? IndInterest { get; set; }

        /// <summary>
        /// MG58_LOCDEP - Località
        /// </summary>
        /// <value>MG58_LOCDEP - Località</value>
        [DataMember(Name="locdep", EmitDefaultValue=false)]
        public string Locdep { get; set; }

        /// <summary>
        /// MG58_PROVDEP - Prov.
        /// </summary>
        /// <value>MG58_PROVDEP - Prov.</value>
        [DataMember(Name="provdep", EmitDefaultValue=false)]
        public string Provdep { get; set; }

        /// <summary>
        /// MG58_RESPDEP - Responsabile
        /// </summary>
        /// <value>MG58_RESPDEP - Responsabile</value>
        [DataMember(Name="respdep", EmitDefaultValue=false)]
        public string Respdep { get; set; }

        /// <summary>
        /// MG58_TELNUMDEP - Telefono
        /// </summary>
        /// <value>MG58_TELNUMDEP - Telefono</value>
        [DataMember(Name="telnumdep", EmitDefaultValue=false)]
        public string Telnumdep { get; set; }

        /// <summary>
        /// Gets or Sets LocationWH
        /// </summary>
        [DataMember(Name="locationWH", EmitDefaultValue=false)]
        public List<LocationWHDTO> LocationWH { get; set; }

        /// <summary>
        /// Gets or Sets ExtensionData
        /// </summary>
        [DataMember(Name="extensionData", EmitDefaultValue=false)]
        public List<StringObjectKeyValuePair> ExtensionData { get; set; }

        /// <summary>
        /// Gets or Sets AdditionalData
        /// </summary>
        [DataMember(Name="additionalData", EmitDefaultValue=false)]
        public Dictionary<string, Object> AdditionalData { get; set; }

        /// <summary>
        /// Gets or Sets PluginData
        /// </summary>
        [DataMember(Name="pluginData", EmitDefaultValue=false)]
        public Dictionary<string, Object> PluginData { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class StorageWHDTO {\n");
            sb.Append("  Capdep: ").Append(Capdep).Append("\n");
            sb.Append("  CodDep: ").Append(CodDep).Append("\n");
            sb.Append("  Dataatt: ").Append(Dataatt).Append("\n");
            sb.Append("  Datacess: ").Append(Datacess).Append("\n");
            sb.Append("  Descrdep: ").Append(Descrdep).Append("\n");
            sb.Append("  DittaCg18: ").Append(DittaCg18).Append("\n");
            sb.Append("  Faxnumdep: ").Append(Faxnumdep).Append("\n");
            sb.Append("  FlgDepprinc: ").Append(FlgDepprinc).Append("\n");
            sb.Append("  IndEmail: ").Append(IndEmail).Append("\n");
            sb.Append("  IndIdep: ").Append(IndIdep).Append("\n");
            sb.Append("  IndInterest: ").Append(IndInterest).Append("\n");
            sb.Append("  Locdep: ").Append(Locdep).Append("\n");
            sb.Append("  Provdep: ").Append(Provdep).Append("\n");
            sb.Append("  Respdep: ").Append(Respdep).Append("\n");
            sb.Append("  Telnumdep: ").Append(Telnumdep).Append("\n");
            sb.Append("  LocationWH: ").Append(LocationWH).Append("\n");
            sb.Append("  ExtensionData: ").Append(ExtensionData).Append("\n");
            sb.Append("  AdditionalData: ").Append(AdditionalData).Append("\n");
            sb.Append("  PluginData: ").Append(PluginData).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as StorageWHDTO);
        }

        /// <summary>
        /// Returns true if StorageWHDTO instances are equal
        /// </summary>
        /// <param name="input">Instance of StorageWHDTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(StorageWHDTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.Capdep == input.Capdep ||
                    (this.Capdep != null &&
                    this.Capdep.Equals(input.Capdep))
                ) && 
                (
                    this.CodDep == input.CodDep ||
                    (this.CodDep != null &&
                    this.CodDep.Equals(input.CodDep))
                ) && 
                (
                    this.Dataatt == input.Dataatt ||
                    (this.Dataatt != null &&
                    this.Dataatt.Equals(input.Dataatt))
                ) && 
                (
                    this.Datacess == input.Datacess ||
                    (this.Datacess != null &&
                    this.Datacess.Equals(input.Datacess))
                ) && 
                (
                    this.Descrdep == input.Descrdep ||
                    (this.Descrdep != null &&
                    this.Descrdep.Equals(input.Descrdep))
                ) && 
                (
                    this.DittaCg18 == input.DittaCg18 ||
                    (this.DittaCg18 != null &&
                    this.DittaCg18.Equals(input.DittaCg18))
                ) && 
                (
                    this.Faxnumdep == input.Faxnumdep ||
                    (this.Faxnumdep != null &&
                    this.Faxnumdep.Equals(input.Faxnumdep))
                ) && 
                (
                    this.FlgDepprinc == input.FlgDepprinc ||
                    (this.FlgDepprinc != null &&
                    this.FlgDepprinc.Equals(input.FlgDepprinc))
                ) && 
                (
                    this.IndEmail == input.IndEmail ||
                    (this.IndEmail != null &&
                    this.IndEmail.Equals(input.IndEmail))
                ) && 
                (
                    this.IndIdep == input.IndIdep ||
                    (this.IndIdep != null &&
                    this.IndIdep.Equals(input.IndIdep))
                ) && 
                (
                    this.IndInterest == input.IndInterest ||
                    (this.IndInterest != null &&
                    this.IndInterest.Equals(input.IndInterest))
                ) && 
                (
                    this.Locdep == input.Locdep ||
                    (this.Locdep != null &&
                    this.Locdep.Equals(input.Locdep))
                ) && 
                (
                    this.Provdep == input.Provdep ||
                    (this.Provdep != null &&
                    this.Provdep.Equals(input.Provdep))
                ) && 
                (
                    this.Respdep == input.Respdep ||
                    (this.Respdep != null &&
                    this.Respdep.Equals(input.Respdep))
                ) && 
                (
                    this.Telnumdep == input.Telnumdep ||
                    (this.Telnumdep != null &&
                    this.Telnumdep.Equals(input.Telnumdep))
                ) && 
                (
                    this.LocationWH == input.LocationWH ||
                    this.LocationWH != null &&
                    input.LocationWH != null &&
                    this.LocationWH.SequenceEqual(input.LocationWH)
                ) && 
                (
                    this.ExtensionData == input.ExtensionData ||
                    this.ExtensionData != null &&
                    input.ExtensionData != null &&
                    this.ExtensionData.SequenceEqual(input.ExtensionData)
                ) && 
                (
                    this.AdditionalData == input.AdditionalData ||
                    this.AdditionalData != null &&
                    input.AdditionalData != null &&
                    this.AdditionalData.SequenceEqual(input.AdditionalData)
                ) && 
                (
                    this.PluginData == input.PluginData ||
                    this.PluginData != null &&
                    input.PluginData != null &&
                    this.PluginData.SequenceEqual(input.PluginData)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.Capdep != null)
                    hashCode = hashCode * 59 + this.Capdep.GetHashCode();
                if (this.CodDep != null)
                    hashCode = hashCode * 59 + this.CodDep.GetHashCode();
                if (this.Dataatt != null)
                    hashCode = hashCode * 59 + this.Dataatt.GetHashCode();
                if (this.Datacess != null)
                    hashCode = hashCode * 59 + this.Datacess.GetHashCode();
                if (this.Descrdep != null)
                    hashCode = hashCode * 59 + this.Descrdep.GetHashCode();
                if (this.DittaCg18 != null)
                    hashCode = hashCode * 59 + this.DittaCg18.GetHashCode();
                if (this.Faxnumdep != null)
                    hashCode = hashCode * 59 + this.Faxnumdep.GetHashCode();
                if (this.FlgDepprinc != null)
                    hashCode = hashCode * 59 + this.FlgDepprinc.GetHashCode();
                if (this.IndEmail != null)
                    hashCode = hashCode * 59 + this.IndEmail.GetHashCode();
                if (this.IndIdep != null)
                    hashCode = hashCode * 59 + this.IndIdep.GetHashCode();
                if (this.IndInterest != null)
                    hashCode = hashCode * 59 + this.IndInterest.GetHashCode();
                if (this.Locdep != null)
                    hashCode = hashCode * 59 + this.Locdep.GetHashCode();
                if (this.Provdep != null)
                    hashCode = hashCode * 59 + this.Provdep.GetHashCode();
                if (this.Respdep != null)
                    hashCode = hashCode * 59 + this.Respdep.GetHashCode();
                if (this.Telnumdep != null)
                    hashCode = hashCode * 59 + this.Telnumdep.GetHashCode();
                if (this.LocationWH != null)
                    hashCode = hashCode * 59 + this.LocationWH.GetHashCode();
                if (this.ExtensionData != null)
                    hashCode = hashCode * 59 + this.ExtensionData.GetHashCode();
                if (this.AdditionalData != null)
                    hashCode = hashCode * 59 + this.AdditionalData.GetHashCode();
                if (this.PluginData != null)
                    hashCode = hashCode * 59 + this.PluginData.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
