/* 
 * TSE Cloud - MG
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.1000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// CG07_TABSTATIEST - Stati esteri&lt;br&gt;Proprietà chiave:&lt;ul&gt;&lt;li&gt;&lt;b&gt;Codice&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;
    /// </summary>
    [DataContract]
        public partial class NationCODTO :  IEquatable<NationCODTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="NationCODTO" /> class.
        /// </summary>
        /// <param name="a2iso3166">CG07_A2ISO3166 - Alpha-2 ISO 3166.</param>
        /// <param name="a3iso3166">CG07_A3ISO3166 - Alpha-3 ISO 3166.</param>
        /// <param name="codice">CG07_CODICE - Codice (required).</param>
        /// <param name="codiceCg08">CG07_CODICE_CG08 - Divisa.</param>
        /// <param name="codIso">CG07_CODISO - Codice ISO.</param>
        /// <param name="codSian">CG07_CODSIAN - Codice SIAN.</param>
        /// <param name="crtpiva">CG07_CRTPIVA - Caratteri lunghezza partita IVA (separati da /).</param>
        /// <param name="datacee">CG07_DATACEE - Data ingresso CEE.</param>
        /// <param name="datafinblacklist">CG07_DATAFINBLACKLIST - Data uscita Black List.</param>
        /// <param name="datainiblacklist">CG07_DATAINIBLACKLIST - Data ingresso Black List.</param>
        /// <param name="descr">CG07_DESCR - Descrizione.</param>
        /// <param name="desiso3166">CG07_DESISO3166 - Descrizione Stato ISO 3166.</param>
        /// <param name="flgIban">CG07_FLGIBAN - Utilizzo IBAN&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="flgSepa">CG07_FLGSEPA - Utilizzo standard SEPA&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="idmediaCg99">CG07_IDMEDIA_CG99 - ID HyperMedia.</param>
        /// <param name="indTipostato">CG07_INDTIPOSTATO - Tipo Nazione&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Extracomunitario&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Intracomunitario&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Rep. San Marino&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="leniban">CG07_LENIBAN - Lunghezza IBAN.</param>
        /// <param name="numiso3166">CG07_NUMISO3166 - Number ISO 3166.</param>
        /// <param name="currencyCO">currencyCO.</param>
        /// <param name="extensionData">extensionData.</param>
        /// <param name="additionalData">additionalData.</param>
        /// <param name="pluginData">pluginData.</param>
        public NationCODTO(string a2iso3166 = default(string), string a3iso3166 = default(string), double? codice = default(double?), string codiceCg08 = default(string), string codIso = default(string), double? codSian = default(double?), string crtpiva = default(string), DateTime? datacee = default(DateTime?), DateTime? datafinblacklist = default(DateTime?), DateTime? datainiblacklist = default(DateTime?), string descr = default(string), string desiso3166 = default(string), int? flgIban = default(int?), int? flgSepa = default(int?), double? idmediaCg99 = default(double?), double? indTipostato = 0, int? leniban = default(int?), string numiso3166 = default(string), CurrencyCODTO currencyCO = default(CurrencyCODTO), List<StringObjectKeyValuePair> extensionData = default(List<StringObjectKeyValuePair>), Dictionary<string, Object> additionalData = default(Dictionary<string, Object>), Dictionary<string, Object> pluginData = default(Dictionary<string, Object>))
        {
            // to ensure "codice" is required (not null)
            if (codice == null)
            {
                throw new InvalidDataException("codice is a required property for NationCODTO and cannot be null");
            }
            else
            {
                this.Codice = codice;
            }
            this.A2iso3166 = a2iso3166;
            this.A3iso3166 = a3iso3166;
            this.CodiceCg08 = codiceCg08;
            this.CodIso = codIso;
            this.CodSian = codSian;
            this.Crtpiva = crtpiva;
            this.Datacee = datacee;
            this.Datafinblacklist = datafinblacklist;
            this.Datainiblacklist = datainiblacklist;
            this.Descr = descr;
            this.Desiso3166 = desiso3166;
            this.FlgIban = flgIban;
            this.FlgSepa = flgSepa;
            this.IdmediaCg99 = idmediaCg99;
            // use default value if no "indTipostato" provided
            if (indTipostato == null)
            {
                this.IndTipostato = 0;
            }
            else
            {
                this.IndTipostato = indTipostato;
            }
            this.Leniban = leniban;
            this.Numiso3166 = numiso3166;
            this.CurrencyCO = currencyCO;
            this.ExtensionData = extensionData;
            this.AdditionalData = additionalData;
            this.PluginData = pluginData;
        }
        
        /// <summary>
        /// CG07_A2ISO3166 - Alpha-2 ISO 3166
        /// </summary>
        /// <value>CG07_A2ISO3166 - Alpha-2 ISO 3166</value>
        [DataMember(Name="a2iso3166", EmitDefaultValue=false)]
        public string A2iso3166 { get; set; }

        /// <summary>
        /// CG07_A3ISO3166 - Alpha-3 ISO 3166
        /// </summary>
        /// <value>CG07_A3ISO3166 - Alpha-3 ISO 3166</value>
        [DataMember(Name="a3iso3166", EmitDefaultValue=false)]
        public string A3iso3166 { get; set; }

        /// <summary>
        /// CG07_CODICE - Codice
        /// </summary>
        /// <value>CG07_CODICE - Codice</value>
        [DataMember(Name="codice", EmitDefaultValue=false)]
        public double? Codice { get; set; }

        /// <summary>
        /// CG07_CODICE_CG08 - Divisa
        /// </summary>
        /// <value>CG07_CODICE_CG08 - Divisa</value>
        [DataMember(Name="codiceCg08", EmitDefaultValue=false)]
        public string CodiceCg08 { get; set; }

        /// <summary>
        /// CG07_CODISO - Codice ISO
        /// </summary>
        /// <value>CG07_CODISO - Codice ISO</value>
        [DataMember(Name="codIso", EmitDefaultValue=false)]
        public string CodIso { get; set; }

        /// <summary>
        /// CG07_CODSIAN - Codice SIAN
        /// </summary>
        /// <value>CG07_CODSIAN - Codice SIAN</value>
        [DataMember(Name="codSian", EmitDefaultValue=false)]
        public double? CodSian { get; set; }

        /// <summary>
        /// CG07_CRTPIVA - Caratteri lunghezza partita IVA (separati da /)
        /// </summary>
        /// <value>CG07_CRTPIVA - Caratteri lunghezza partita IVA (separati da /)</value>
        [DataMember(Name="crtpiva", EmitDefaultValue=false)]
        public string Crtpiva { get; set; }

        /// <summary>
        /// CG07_DATACEE - Data ingresso CEE
        /// </summary>
        /// <value>CG07_DATACEE - Data ingresso CEE</value>
        [DataMember(Name="datacee", EmitDefaultValue=false)]
        public DateTime? Datacee { get; set; }

        /// <summary>
        /// CG07_DATAFINBLACKLIST - Data uscita Black List
        /// </summary>
        /// <value>CG07_DATAFINBLACKLIST - Data uscita Black List</value>
        [DataMember(Name="datafinblacklist", EmitDefaultValue=false)]
        public DateTime? Datafinblacklist { get; set; }

        /// <summary>
        /// CG07_DATAINIBLACKLIST - Data ingresso Black List
        /// </summary>
        /// <value>CG07_DATAINIBLACKLIST - Data ingresso Black List</value>
        [DataMember(Name="datainiblacklist", EmitDefaultValue=false)]
        public DateTime? Datainiblacklist { get; set; }

        /// <summary>
        /// CG07_DESCR - Descrizione
        /// </summary>
        /// <value>CG07_DESCR - Descrizione</value>
        [DataMember(Name="descr", EmitDefaultValue=false)]
        public string Descr { get; set; }

        /// <summary>
        /// CG07_DESISO3166 - Descrizione Stato ISO 3166
        /// </summary>
        /// <value>CG07_DESISO3166 - Descrizione Stato ISO 3166</value>
        [DataMember(Name="desiso3166", EmitDefaultValue=false)]
        public string Desiso3166 { get; set; }

        /// <summary>
        /// CG07_FLGIBAN - Utilizzo IBAN&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG07_FLGIBAN - Utilizzo IBAN&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgIban", EmitDefaultValue=false)]
        public int? FlgIban { get; set; }

        /// <summary>
        /// CG07_FLGSEPA - Utilizzo standard SEPA&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG07_FLGSEPA - Utilizzo standard SEPA&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgSepa", EmitDefaultValue=false)]
        public int? FlgSepa { get; set; }

        /// <summary>
        /// CG07_IDMEDIA_CG99 - ID HyperMedia
        /// </summary>
        /// <value>CG07_IDMEDIA_CG99 - ID HyperMedia</value>
        [DataMember(Name="idmediaCg99", EmitDefaultValue=false)]
        public double? IdmediaCg99 { get; set; }

        /// <summary>
        /// CG07_INDTIPOSTATO - Tipo Nazione&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Extracomunitario&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Intracomunitario&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Rep. San Marino&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG07_INDTIPOSTATO - Tipo Nazione&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Extracomunitario&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Intracomunitario&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Rep. San Marino&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indTipostato", EmitDefaultValue=false)]
        public double? IndTipostato { get; set; }

        /// <summary>
        /// CG07_LENIBAN - Lunghezza IBAN
        /// </summary>
        /// <value>CG07_LENIBAN - Lunghezza IBAN</value>
        [DataMember(Name="leniban", EmitDefaultValue=false)]
        public int? Leniban { get; set; }

        /// <summary>
        /// CG07_NUMISO3166 - Number ISO 3166
        /// </summary>
        /// <value>CG07_NUMISO3166 - Number ISO 3166</value>
        [DataMember(Name="numiso3166", EmitDefaultValue=false)]
        public string Numiso3166 { get; set; }

        /// <summary>
        /// Gets or Sets CurrencyCO
        /// </summary>
        [DataMember(Name="currencyCO", EmitDefaultValue=false)]
        public CurrencyCODTO CurrencyCO { get; set; }

        /// <summary>
        /// Gets or Sets ExtensionData
        /// </summary>
        [DataMember(Name="extensionData", EmitDefaultValue=false)]
        public List<StringObjectKeyValuePair> ExtensionData { get; set; }

        /// <summary>
        /// Gets or Sets AdditionalData
        /// </summary>
        [DataMember(Name="additionalData", EmitDefaultValue=false)]
        public Dictionary<string, Object> AdditionalData { get; set; }

        /// <summary>
        /// Gets or Sets PluginData
        /// </summary>
        [DataMember(Name="pluginData", EmitDefaultValue=false)]
        public Dictionary<string, Object> PluginData { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class NationCODTO {\n");
            sb.Append("  A2iso3166: ").Append(A2iso3166).Append("\n");
            sb.Append("  A3iso3166: ").Append(A3iso3166).Append("\n");
            sb.Append("  Codice: ").Append(Codice).Append("\n");
            sb.Append("  CodiceCg08: ").Append(CodiceCg08).Append("\n");
            sb.Append("  CodIso: ").Append(CodIso).Append("\n");
            sb.Append("  CodSian: ").Append(CodSian).Append("\n");
            sb.Append("  Crtpiva: ").Append(Crtpiva).Append("\n");
            sb.Append("  Datacee: ").Append(Datacee).Append("\n");
            sb.Append("  Datafinblacklist: ").Append(Datafinblacklist).Append("\n");
            sb.Append("  Datainiblacklist: ").Append(Datainiblacklist).Append("\n");
            sb.Append("  Descr: ").Append(Descr).Append("\n");
            sb.Append("  Desiso3166: ").Append(Desiso3166).Append("\n");
            sb.Append("  FlgIban: ").Append(FlgIban).Append("\n");
            sb.Append("  FlgSepa: ").Append(FlgSepa).Append("\n");
            sb.Append("  IdmediaCg99: ").Append(IdmediaCg99).Append("\n");
            sb.Append("  IndTipostato: ").Append(IndTipostato).Append("\n");
            sb.Append("  Leniban: ").Append(Leniban).Append("\n");
            sb.Append("  Numiso3166: ").Append(Numiso3166).Append("\n");
            sb.Append("  CurrencyCO: ").Append(CurrencyCO).Append("\n");
            sb.Append("  ExtensionData: ").Append(ExtensionData).Append("\n");
            sb.Append("  AdditionalData: ").Append(AdditionalData).Append("\n");
            sb.Append("  PluginData: ").Append(PluginData).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as NationCODTO);
        }

        /// <summary>
        /// Returns true if NationCODTO instances are equal
        /// </summary>
        /// <param name="input">Instance of NationCODTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(NationCODTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.A2iso3166 == input.A2iso3166 ||
                    (this.A2iso3166 != null &&
                    this.A2iso3166.Equals(input.A2iso3166))
                ) && 
                (
                    this.A3iso3166 == input.A3iso3166 ||
                    (this.A3iso3166 != null &&
                    this.A3iso3166.Equals(input.A3iso3166))
                ) && 
                (
                    this.Codice == input.Codice ||
                    (this.Codice != null &&
                    this.Codice.Equals(input.Codice))
                ) && 
                (
                    this.CodiceCg08 == input.CodiceCg08 ||
                    (this.CodiceCg08 != null &&
                    this.CodiceCg08.Equals(input.CodiceCg08))
                ) && 
                (
                    this.CodIso == input.CodIso ||
                    (this.CodIso != null &&
                    this.CodIso.Equals(input.CodIso))
                ) && 
                (
                    this.CodSian == input.CodSian ||
                    (this.CodSian != null &&
                    this.CodSian.Equals(input.CodSian))
                ) && 
                (
                    this.Crtpiva == input.Crtpiva ||
                    (this.Crtpiva != null &&
                    this.Crtpiva.Equals(input.Crtpiva))
                ) && 
                (
                    this.Datacee == input.Datacee ||
                    (this.Datacee != null &&
                    this.Datacee.Equals(input.Datacee))
                ) && 
                (
                    this.Datafinblacklist == input.Datafinblacklist ||
                    (this.Datafinblacklist != null &&
                    this.Datafinblacklist.Equals(input.Datafinblacklist))
                ) && 
                (
                    this.Datainiblacklist == input.Datainiblacklist ||
                    (this.Datainiblacklist != null &&
                    this.Datainiblacklist.Equals(input.Datainiblacklist))
                ) && 
                (
                    this.Descr == input.Descr ||
                    (this.Descr != null &&
                    this.Descr.Equals(input.Descr))
                ) && 
                (
                    this.Desiso3166 == input.Desiso3166 ||
                    (this.Desiso3166 != null &&
                    this.Desiso3166.Equals(input.Desiso3166))
                ) && 
                (
                    this.FlgIban == input.FlgIban ||
                    (this.FlgIban != null &&
                    this.FlgIban.Equals(input.FlgIban))
                ) && 
                (
                    this.FlgSepa == input.FlgSepa ||
                    (this.FlgSepa != null &&
                    this.FlgSepa.Equals(input.FlgSepa))
                ) && 
                (
                    this.IdmediaCg99 == input.IdmediaCg99 ||
                    (this.IdmediaCg99 != null &&
                    this.IdmediaCg99.Equals(input.IdmediaCg99))
                ) && 
                (
                    this.IndTipostato == input.IndTipostato ||
                    (this.IndTipostato != null &&
                    this.IndTipostato.Equals(input.IndTipostato))
                ) && 
                (
                    this.Leniban == input.Leniban ||
                    (this.Leniban != null &&
                    this.Leniban.Equals(input.Leniban))
                ) && 
                (
                    this.Numiso3166 == input.Numiso3166 ||
                    (this.Numiso3166 != null &&
                    this.Numiso3166.Equals(input.Numiso3166))
                ) && 
                (
                    this.CurrencyCO == input.CurrencyCO ||
                    (this.CurrencyCO != null &&
                    this.CurrencyCO.Equals(input.CurrencyCO))
                ) && 
                (
                    this.ExtensionData == input.ExtensionData ||
                    this.ExtensionData != null &&
                    input.ExtensionData != null &&
                    this.ExtensionData.SequenceEqual(input.ExtensionData)
                ) && 
                (
                    this.AdditionalData == input.AdditionalData ||
                    this.AdditionalData != null &&
                    input.AdditionalData != null &&
                    this.AdditionalData.SequenceEqual(input.AdditionalData)
                ) && 
                (
                    this.PluginData == input.PluginData ||
                    this.PluginData != null &&
                    input.PluginData != null &&
                    this.PluginData.SequenceEqual(input.PluginData)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.A2iso3166 != null)
                    hashCode = hashCode * 59 + this.A2iso3166.GetHashCode();
                if (this.A3iso3166 != null)
                    hashCode = hashCode * 59 + this.A3iso3166.GetHashCode();
                if (this.Codice != null)
                    hashCode = hashCode * 59 + this.Codice.GetHashCode();
                if (this.CodiceCg08 != null)
                    hashCode = hashCode * 59 + this.CodiceCg08.GetHashCode();
                if (this.CodIso != null)
                    hashCode = hashCode * 59 + this.CodIso.GetHashCode();
                if (this.CodSian != null)
                    hashCode = hashCode * 59 + this.CodSian.GetHashCode();
                if (this.Crtpiva != null)
                    hashCode = hashCode * 59 + this.Crtpiva.GetHashCode();
                if (this.Datacee != null)
                    hashCode = hashCode * 59 + this.Datacee.GetHashCode();
                if (this.Datafinblacklist != null)
                    hashCode = hashCode * 59 + this.Datafinblacklist.GetHashCode();
                if (this.Datainiblacklist != null)
                    hashCode = hashCode * 59 + this.Datainiblacklist.GetHashCode();
                if (this.Descr != null)
                    hashCode = hashCode * 59 + this.Descr.GetHashCode();
                if (this.Desiso3166 != null)
                    hashCode = hashCode * 59 + this.Desiso3166.GetHashCode();
                if (this.FlgIban != null)
                    hashCode = hashCode * 59 + this.FlgIban.GetHashCode();
                if (this.FlgSepa != null)
                    hashCode = hashCode * 59 + this.FlgSepa.GetHashCode();
                if (this.IdmediaCg99 != null)
                    hashCode = hashCode * 59 + this.IdmediaCg99.GetHashCode();
                if (this.IndTipostato != null)
                    hashCode = hashCode * 59 + this.IndTipostato.GetHashCode();
                if (this.Leniban != null)
                    hashCode = hashCode * 59 + this.Leniban.GetHashCode();
                if (this.Numiso3166 != null)
                    hashCode = hashCode * 59 + this.Numiso3166.GetHashCode();
                if (this.CurrencyCO != null)
                    hashCode = hashCode * 59 + this.CurrencyCO.GetHashCode();
                if (this.ExtensionData != null)
                    hashCode = hashCode * 59 + this.ExtensionData.GetHashCode();
                if (this.AdditionalData != null)
                    hashCode = hashCode * 59 + this.AdditionalData.GetHashCode();
                if (this.PluginData != null)
                    hashCode = hashCode * 59 + this.PluginData.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
