/* 
 * TSE Cloud - MG
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.1000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// DO12_DOCTESTARIF - Documenti di riferimento testata&lt;br&gt;Proprietà chiave:&lt;ul&gt;&lt;li&gt;&lt;b&gt;DittaCg18&lt;/b&gt;&lt;/li&gt;&lt;li&gt;&lt;b&gt;IndStipodoc&lt;/b&gt;&lt;/li&gt;&lt;li&gt;&lt;b&gt;IndTipodoc&lt;/b&gt;&lt;/li&gt;&lt;li&gt;&lt;b&gt;NumregCo99&lt;/b&gt;&lt;/li&gt;&lt;li&gt;&lt;b&gt;ProgRif&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;
    /// </summary>
    [DataContract]
        public partial class HeadingReferenceDocumentMGDTO :  IEquatable<HeadingReferenceDocumentMGDTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="HeadingReferenceDocumentMGDTO" /> class.
        /// </summary>
        /// <param name="datansconf">DO12_DATANSCONF - Data nostra conferma.</param>
        /// <param name="datansdoc">DO12_DATANSDOC - Data nostro documento.</param>
        /// <param name="datavsconf">DO12_DATAVSCONF - Data vostra conferma.</param>
        /// <param name="datavsdoc">DO12_DATAVSDOC - Data vostro documento.</param>
        /// <param name="dittaCg18">DO12_DITTA_CG18 - Ditta (default to 0).</param>
        /// <param name="fedatadoc">DO12_FEDATADOC - Fedatadoc.</param>
        /// <param name="feiddoc">DO12_FEIDDOC - Feiddoc.</param>
        /// <param name="feidsoggetto">DO12_FEIDSOGGETTO - Feidsoggetto.</param>
        /// <param name="flgNsdocbis">DO12_FLGNSDOCBIS - Flag bis ns documento&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="indStipodoc">DO12_INDSTIPODOC - Indicatore sottotipo documento di riferimento (default to 0).</param>
        /// <param name="indTipodoc">DO12_INDTIPODOC - Indicatore tipo documento di riferimento (default to 0).</param>
        /// <param name="notensdoc">DO12_NOTENSDOC - Note nostro documento.</param>
        /// <param name="notevsdoc">DO12_NOTEVSDOC - Note vostro documento.</param>
        /// <param name="numnsdoc">DO12_NUMNSDOC - Numero nostro documento.</param>
        /// <param name="numregCo99">DO12_NUMREG_CO99 - Numero registrazione (required).</param>
        /// <param name="numvsdoc">DO12_NUMVSDOC - Numero vostro documento.</param>
        /// <param name="progRif">DO12_PROGRIF - Progressivo di rif. (required).</param>
        /// <param name="rifnsdoc">DO12_RIFNSDOC - Riferimento nostro documento.</param>
        /// <param name="rifvsdoc">DO12_RIFVSDOC - Riferimento vostro documento.</param>
        /// <param name="seznsdoc">DO12_SEZNSDOC - Sezionale nostro documento.</param>
        /// <param name="extensionData">extensionData.</param>
        /// <param name="additionalData">additionalData.</param>
        /// <param name="pluginData">pluginData.</param>
        public HeadingReferenceDocumentMGDTO(DateTime? datansconf = default(DateTime?), DateTime? datansdoc = default(DateTime?), DateTime? datavsconf = default(DateTime?), DateTime? datavsdoc = default(DateTime?), double? dittaCg18 = 0, DateTime? fedatadoc = default(DateTime?), string feiddoc = default(string), string feidsoggetto = default(string), double? flgNsdocbis = default(double?), double? indStipodoc = 0, double? indTipodoc = 0, string notensdoc = default(string), string notevsdoc = default(string), double? numnsdoc = default(double?), string numregCo99 = default(string), string numvsdoc = default(string), double? progRif = default(double?), string rifnsdoc = default(string), string rifvsdoc = default(string), string seznsdoc = default(string), List<StringObjectKeyValuePair> extensionData = default(List<StringObjectKeyValuePair>), Dictionary<string, Object> additionalData = default(Dictionary<string, Object>), Dictionary<string, Object> pluginData = default(Dictionary<string, Object>))
        {
            // to ensure "numregCo99" is required (not null)
            if (numregCo99 == null)
            {
                throw new InvalidDataException("numregCo99 is a required property for HeadingReferenceDocumentMGDTO and cannot be null");
            }
            else
            {
                this.NumregCo99 = numregCo99;
            }
            // to ensure "progRif" is required (not null)
            if (progRif == null)
            {
                throw new InvalidDataException("progRif is a required property for HeadingReferenceDocumentMGDTO and cannot be null");
            }
            else
            {
                this.ProgRif = progRif;
            }
            this.Datansconf = datansconf;
            this.Datansdoc = datansdoc;
            this.Datavsconf = datavsconf;
            this.Datavsdoc = datavsdoc;
            // use default value if no "dittaCg18" provided
            if (dittaCg18 == null)
            {
                this.DittaCg18 = 0;
            }
            else
            {
                this.DittaCg18 = dittaCg18;
            }
            this.Fedatadoc = fedatadoc;
            this.Feiddoc = feiddoc;
            this.Feidsoggetto = feidsoggetto;
            this.FlgNsdocbis = flgNsdocbis;
            // use default value if no "indStipodoc" provided
            if (indStipodoc == null)
            {
                this.IndStipodoc = 0;
            }
            else
            {
                this.IndStipodoc = indStipodoc;
            }
            // use default value if no "indTipodoc" provided
            if (indTipodoc == null)
            {
                this.IndTipodoc = 0;
            }
            else
            {
                this.IndTipodoc = indTipodoc;
            }
            this.Notensdoc = notensdoc;
            this.Notevsdoc = notevsdoc;
            this.Numnsdoc = numnsdoc;
            this.Numvsdoc = numvsdoc;
            this.Rifnsdoc = rifnsdoc;
            this.Rifvsdoc = rifvsdoc;
            this.Seznsdoc = seznsdoc;
            this.ExtensionData = extensionData;
            this.AdditionalData = additionalData;
            this.PluginData = pluginData;
        }
        
        /// <summary>
        /// DO12_DATANSCONF - Data nostra conferma
        /// </summary>
        /// <value>DO12_DATANSCONF - Data nostra conferma</value>
        [DataMember(Name="datansconf", EmitDefaultValue=false)]
        public DateTime? Datansconf { get; set; }

        /// <summary>
        /// DO12_DATANSDOC - Data nostro documento
        /// </summary>
        /// <value>DO12_DATANSDOC - Data nostro documento</value>
        [DataMember(Name="datansdoc", EmitDefaultValue=false)]
        public DateTime? Datansdoc { get; set; }

        /// <summary>
        /// DO12_DATAVSCONF - Data vostra conferma
        /// </summary>
        /// <value>DO12_DATAVSCONF - Data vostra conferma</value>
        [DataMember(Name="datavsconf", EmitDefaultValue=false)]
        public DateTime? Datavsconf { get; set; }

        /// <summary>
        /// DO12_DATAVSDOC - Data vostro documento
        /// </summary>
        /// <value>DO12_DATAVSDOC - Data vostro documento</value>
        [DataMember(Name="datavsdoc", EmitDefaultValue=false)]
        public DateTime? Datavsdoc { get; set; }

        /// <summary>
        /// DO12_DITTA_CG18 - Ditta
        /// </summary>
        /// <value>DO12_DITTA_CG18 - Ditta</value>
        [DataMember(Name="dittaCg18", EmitDefaultValue=false)]
        public double? DittaCg18 { get; set; }

        /// <summary>
        /// DO12_FEDATADOC - Fedatadoc
        /// </summary>
        /// <value>DO12_FEDATADOC - Fedatadoc</value>
        [DataMember(Name="fedatadoc", EmitDefaultValue=false)]
        public DateTime? Fedatadoc { get; set; }

        /// <summary>
        /// DO12_FEIDDOC - Feiddoc
        /// </summary>
        /// <value>DO12_FEIDDOC - Feiddoc</value>
        [DataMember(Name="feiddoc", EmitDefaultValue=false)]
        public string Feiddoc { get; set; }

        /// <summary>
        /// DO12_FEIDSOGGETTO - Feidsoggetto
        /// </summary>
        /// <value>DO12_FEIDSOGGETTO - Feidsoggetto</value>
        [DataMember(Name="feidsoggetto", EmitDefaultValue=false)]
        public string Feidsoggetto { get; set; }

        /// <summary>
        /// DO12_FLGNSDOCBIS - Flag bis ns documento&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>DO12_FLGNSDOCBIS - Flag bis ns documento&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgNsdocbis", EmitDefaultValue=false)]
        public double? FlgNsdocbis { get; set; }

        /// <summary>
        /// DO12_INDSTIPODOC - Indicatore sottotipo documento di riferimento
        /// </summary>
        /// <value>DO12_INDSTIPODOC - Indicatore sottotipo documento di riferimento</value>
        [DataMember(Name="indStipodoc", EmitDefaultValue=false)]
        public double? IndStipodoc { get; set; }

        /// <summary>
        /// DO12_INDTIPODOC - Indicatore tipo documento di riferimento
        /// </summary>
        /// <value>DO12_INDTIPODOC - Indicatore tipo documento di riferimento</value>
        [DataMember(Name="indTipodoc", EmitDefaultValue=false)]
        public double? IndTipodoc { get; set; }

        /// <summary>
        /// DO12_NOTENSDOC - Note nostro documento
        /// </summary>
        /// <value>DO12_NOTENSDOC - Note nostro documento</value>
        [DataMember(Name="notensdoc", EmitDefaultValue=false)]
        public string Notensdoc { get; set; }

        /// <summary>
        /// DO12_NOTEVSDOC - Note vostro documento
        /// </summary>
        /// <value>DO12_NOTEVSDOC - Note vostro documento</value>
        [DataMember(Name="notevsdoc", EmitDefaultValue=false)]
        public string Notevsdoc { get; set; }

        /// <summary>
        /// DO12_NUMNSDOC - Numero nostro documento
        /// </summary>
        /// <value>DO12_NUMNSDOC - Numero nostro documento</value>
        [DataMember(Name="numnsdoc", EmitDefaultValue=false)]
        public double? Numnsdoc { get; set; }

        /// <summary>
        /// DO12_NUMREG_CO99 - Numero registrazione
        /// </summary>
        /// <value>DO12_NUMREG_CO99 - Numero registrazione</value>
        [DataMember(Name="numregCo99", EmitDefaultValue=false)]
        public string NumregCo99 { get; set; }

        /// <summary>
        /// DO12_NUMVSDOC - Numero vostro documento
        /// </summary>
        /// <value>DO12_NUMVSDOC - Numero vostro documento</value>
        [DataMember(Name="numvsdoc", EmitDefaultValue=false)]
        public string Numvsdoc { get; set; }

        /// <summary>
        /// DO12_PROGRIF - Progressivo di rif.
        /// </summary>
        /// <value>DO12_PROGRIF - Progressivo di rif.</value>
        [DataMember(Name="progRif", EmitDefaultValue=false)]
        public double? ProgRif { get; set; }

        /// <summary>
        /// DO12_RIFNSDOC - Riferimento nostro documento
        /// </summary>
        /// <value>DO12_RIFNSDOC - Riferimento nostro documento</value>
        [DataMember(Name="rifnsdoc", EmitDefaultValue=false)]
        public string Rifnsdoc { get; set; }

        /// <summary>
        /// DO12_RIFVSDOC - Riferimento vostro documento
        /// </summary>
        /// <value>DO12_RIFVSDOC - Riferimento vostro documento</value>
        [DataMember(Name="rifvsdoc", EmitDefaultValue=false)]
        public string Rifvsdoc { get; set; }

        /// <summary>
        /// DO12_SEZNSDOC - Sezionale nostro documento
        /// </summary>
        /// <value>DO12_SEZNSDOC - Sezionale nostro documento</value>
        [DataMember(Name="seznsdoc", EmitDefaultValue=false)]
        public string Seznsdoc { get; set; }

        /// <summary>
        /// Gets or Sets ExtensionData
        /// </summary>
        [DataMember(Name="extensionData", EmitDefaultValue=false)]
        public List<StringObjectKeyValuePair> ExtensionData { get; set; }

        /// <summary>
        /// Gets or Sets AdditionalData
        /// </summary>
        [DataMember(Name="additionalData", EmitDefaultValue=false)]
        public Dictionary<string, Object> AdditionalData { get; set; }

        /// <summary>
        /// Gets or Sets PluginData
        /// </summary>
        [DataMember(Name="pluginData", EmitDefaultValue=false)]
        public Dictionary<string, Object> PluginData { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class HeadingReferenceDocumentMGDTO {\n");
            sb.Append("  Datansconf: ").Append(Datansconf).Append("\n");
            sb.Append("  Datansdoc: ").Append(Datansdoc).Append("\n");
            sb.Append("  Datavsconf: ").Append(Datavsconf).Append("\n");
            sb.Append("  Datavsdoc: ").Append(Datavsdoc).Append("\n");
            sb.Append("  DittaCg18: ").Append(DittaCg18).Append("\n");
            sb.Append("  Fedatadoc: ").Append(Fedatadoc).Append("\n");
            sb.Append("  Feiddoc: ").Append(Feiddoc).Append("\n");
            sb.Append("  Feidsoggetto: ").Append(Feidsoggetto).Append("\n");
            sb.Append("  FlgNsdocbis: ").Append(FlgNsdocbis).Append("\n");
            sb.Append("  IndStipodoc: ").Append(IndStipodoc).Append("\n");
            sb.Append("  IndTipodoc: ").Append(IndTipodoc).Append("\n");
            sb.Append("  Notensdoc: ").Append(Notensdoc).Append("\n");
            sb.Append("  Notevsdoc: ").Append(Notevsdoc).Append("\n");
            sb.Append("  Numnsdoc: ").Append(Numnsdoc).Append("\n");
            sb.Append("  NumregCo99: ").Append(NumregCo99).Append("\n");
            sb.Append("  Numvsdoc: ").Append(Numvsdoc).Append("\n");
            sb.Append("  ProgRif: ").Append(ProgRif).Append("\n");
            sb.Append("  Rifnsdoc: ").Append(Rifnsdoc).Append("\n");
            sb.Append("  Rifvsdoc: ").Append(Rifvsdoc).Append("\n");
            sb.Append("  Seznsdoc: ").Append(Seznsdoc).Append("\n");
            sb.Append("  ExtensionData: ").Append(ExtensionData).Append("\n");
            sb.Append("  AdditionalData: ").Append(AdditionalData).Append("\n");
            sb.Append("  PluginData: ").Append(PluginData).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as HeadingReferenceDocumentMGDTO);
        }

        /// <summary>
        /// Returns true if HeadingReferenceDocumentMGDTO instances are equal
        /// </summary>
        /// <param name="input">Instance of HeadingReferenceDocumentMGDTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(HeadingReferenceDocumentMGDTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.Datansconf == input.Datansconf ||
                    (this.Datansconf != null &&
                    this.Datansconf.Equals(input.Datansconf))
                ) && 
                (
                    this.Datansdoc == input.Datansdoc ||
                    (this.Datansdoc != null &&
                    this.Datansdoc.Equals(input.Datansdoc))
                ) && 
                (
                    this.Datavsconf == input.Datavsconf ||
                    (this.Datavsconf != null &&
                    this.Datavsconf.Equals(input.Datavsconf))
                ) && 
                (
                    this.Datavsdoc == input.Datavsdoc ||
                    (this.Datavsdoc != null &&
                    this.Datavsdoc.Equals(input.Datavsdoc))
                ) && 
                (
                    this.DittaCg18 == input.DittaCg18 ||
                    (this.DittaCg18 != null &&
                    this.DittaCg18.Equals(input.DittaCg18))
                ) && 
                (
                    this.Fedatadoc == input.Fedatadoc ||
                    (this.Fedatadoc != null &&
                    this.Fedatadoc.Equals(input.Fedatadoc))
                ) && 
                (
                    this.Feiddoc == input.Feiddoc ||
                    (this.Feiddoc != null &&
                    this.Feiddoc.Equals(input.Feiddoc))
                ) && 
                (
                    this.Feidsoggetto == input.Feidsoggetto ||
                    (this.Feidsoggetto != null &&
                    this.Feidsoggetto.Equals(input.Feidsoggetto))
                ) && 
                (
                    this.FlgNsdocbis == input.FlgNsdocbis ||
                    (this.FlgNsdocbis != null &&
                    this.FlgNsdocbis.Equals(input.FlgNsdocbis))
                ) && 
                (
                    this.IndStipodoc == input.IndStipodoc ||
                    (this.IndStipodoc != null &&
                    this.IndStipodoc.Equals(input.IndStipodoc))
                ) && 
                (
                    this.IndTipodoc == input.IndTipodoc ||
                    (this.IndTipodoc != null &&
                    this.IndTipodoc.Equals(input.IndTipodoc))
                ) && 
                (
                    this.Notensdoc == input.Notensdoc ||
                    (this.Notensdoc != null &&
                    this.Notensdoc.Equals(input.Notensdoc))
                ) && 
                (
                    this.Notevsdoc == input.Notevsdoc ||
                    (this.Notevsdoc != null &&
                    this.Notevsdoc.Equals(input.Notevsdoc))
                ) && 
                (
                    this.Numnsdoc == input.Numnsdoc ||
                    (this.Numnsdoc != null &&
                    this.Numnsdoc.Equals(input.Numnsdoc))
                ) && 
                (
                    this.NumregCo99 == input.NumregCo99 ||
                    (this.NumregCo99 != null &&
                    this.NumregCo99.Equals(input.NumregCo99))
                ) && 
                (
                    this.Numvsdoc == input.Numvsdoc ||
                    (this.Numvsdoc != null &&
                    this.Numvsdoc.Equals(input.Numvsdoc))
                ) && 
                (
                    this.ProgRif == input.ProgRif ||
                    (this.ProgRif != null &&
                    this.ProgRif.Equals(input.ProgRif))
                ) && 
                (
                    this.Rifnsdoc == input.Rifnsdoc ||
                    (this.Rifnsdoc != null &&
                    this.Rifnsdoc.Equals(input.Rifnsdoc))
                ) && 
                (
                    this.Rifvsdoc == input.Rifvsdoc ||
                    (this.Rifvsdoc != null &&
                    this.Rifvsdoc.Equals(input.Rifvsdoc))
                ) && 
                (
                    this.Seznsdoc == input.Seznsdoc ||
                    (this.Seznsdoc != null &&
                    this.Seznsdoc.Equals(input.Seznsdoc))
                ) && 
                (
                    this.ExtensionData == input.ExtensionData ||
                    this.ExtensionData != null &&
                    input.ExtensionData != null &&
                    this.ExtensionData.SequenceEqual(input.ExtensionData)
                ) && 
                (
                    this.AdditionalData == input.AdditionalData ||
                    this.AdditionalData != null &&
                    input.AdditionalData != null &&
                    this.AdditionalData.SequenceEqual(input.AdditionalData)
                ) && 
                (
                    this.PluginData == input.PluginData ||
                    this.PluginData != null &&
                    input.PluginData != null &&
                    this.PluginData.SequenceEqual(input.PluginData)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.Datansconf != null)
                    hashCode = hashCode * 59 + this.Datansconf.GetHashCode();
                if (this.Datansdoc != null)
                    hashCode = hashCode * 59 + this.Datansdoc.GetHashCode();
                if (this.Datavsconf != null)
                    hashCode = hashCode * 59 + this.Datavsconf.GetHashCode();
                if (this.Datavsdoc != null)
                    hashCode = hashCode * 59 + this.Datavsdoc.GetHashCode();
                if (this.DittaCg18 != null)
                    hashCode = hashCode * 59 + this.DittaCg18.GetHashCode();
                if (this.Fedatadoc != null)
                    hashCode = hashCode * 59 + this.Fedatadoc.GetHashCode();
                if (this.Feiddoc != null)
                    hashCode = hashCode * 59 + this.Feiddoc.GetHashCode();
                if (this.Feidsoggetto != null)
                    hashCode = hashCode * 59 + this.Feidsoggetto.GetHashCode();
                if (this.FlgNsdocbis != null)
                    hashCode = hashCode * 59 + this.FlgNsdocbis.GetHashCode();
                if (this.IndStipodoc != null)
                    hashCode = hashCode * 59 + this.IndStipodoc.GetHashCode();
                if (this.IndTipodoc != null)
                    hashCode = hashCode * 59 + this.IndTipodoc.GetHashCode();
                if (this.Notensdoc != null)
                    hashCode = hashCode * 59 + this.Notensdoc.GetHashCode();
                if (this.Notevsdoc != null)
                    hashCode = hashCode * 59 + this.Notevsdoc.GetHashCode();
                if (this.Numnsdoc != null)
                    hashCode = hashCode * 59 + this.Numnsdoc.GetHashCode();
                if (this.NumregCo99 != null)
                    hashCode = hashCode * 59 + this.NumregCo99.GetHashCode();
                if (this.Numvsdoc != null)
                    hashCode = hashCode * 59 + this.Numvsdoc.GetHashCode();
                if (this.ProgRif != null)
                    hashCode = hashCode * 59 + this.ProgRif.GetHashCode();
                if (this.Rifnsdoc != null)
                    hashCode = hashCode * 59 + this.Rifnsdoc.GetHashCode();
                if (this.Rifvsdoc != null)
                    hashCode = hashCode * 59 + this.Rifvsdoc.GetHashCode();
                if (this.Seznsdoc != null)
                    hashCode = hashCode * 59 + this.Seznsdoc.GetHashCode();
                if (this.ExtensionData != null)
                    hashCode = hashCode * 59 + this.ExtensionData.GetHashCode();
                if (this.AdditionalData != null)
                    hashCode = hashCode * 59 + this.AdditionalData.GetHashCode();
                if (this.PluginData != null)
                    hashCode = hashCode * 59 + this.PluginData.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
