/* 
 * TSE Cloud - MG
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.1000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using RestSharp;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace IO.Swagger.Api
{
    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
        public interface ICustomerSupplierExtensionMGApi : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// Get by ID
        /// </summary>
        /// <remarks>
        /// Get an object of type corresponding the requested id
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="tipocfCg44">TipocfCg44 Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>CustomerSupplierExtensionMGDTO</returns>
        CustomerSupplierExtensionMGDTO ApiV1EnvironmentMGCustomerSupplierExtensionMGIdGet (string id, string environment, string tipocfCg44, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null);

        /// <summary>
        /// Get by ID
        /// </summary>
        /// <remarks>
        /// Get an object of type corresponding the requested id
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="tipocfCg44">TipocfCg44 Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>ApiResponse of CustomerSupplierExtensionMGDTO</returns>
        ApiResponse<CustomerSupplierExtensionMGDTO> ApiV1EnvironmentMGCustomerSupplierExtensionMGIdGetWithHttpInfo (string id, string environment, string tipocfCg44, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null);
        /// <summary>
        /// Update partial
        /// </summary>
        /// <remarks>
        /// Patching an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfCg44">TipocfCg44 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns></returns>
        void ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPatch (Object body, string authorizationScope, string tipocfCg44, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);

        /// <summary>
        /// Update partial
        /// </summary>
        /// <remarks>
        /// Patching an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfCg44">TipocfCg44 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPatchWithHttpInfo (Object body, string authorizationScope, string tipocfCg44, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);
        /// <summary>
        /// Update
        /// </summary>
        /// <remarks>
        /// Updating an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfCg44">TipocfCg44 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>CustomerSupplierExtensionMGDTO</returns>
        CustomerSupplierExtensionMGDTO ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPut (CustomerSupplierExtensionMGDTO body, string authorizationScope, string tipocfCg44, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);

        /// <summary>
        /// Update
        /// </summary>
        /// <remarks>
        /// Updating an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfCg44">TipocfCg44 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of CustomerSupplierExtensionMGDTO</returns>
        ApiResponse<CustomerSupplierExtensionMGDTO> ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPutWithHttpInfo (CustomerSupplierExtensionMGDTO body, string authorizationScope, string tipocfCg44, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);
        /// <summary>
        /// Validate
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns></returns>
        void ApiV1EnvironmentMGCustomerSupplierExtensionMGValidatePost (CustomerSupplierExtensionMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null);

        /// <summary>
        /// Validate
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> ApiV1EnvironmentMGCustomerSupplierExtensionMGValidatePostWithHttpInfo (CustomerSupplierExtensionMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null);
        #endregion Synchronous Operations
        #region Asynchronous Operations
        /// <summary>
        /// Get by ID
        /// </summary>
        /// <remarks>
        /// Get an object of type corresponding the requested id
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="tipocfCg44">TipocfCg44 Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of CustomerSupplierExtensionMGDTO</returns>
        System.Threading.Tasks.Task<CustomerSupplierExtensionMGDTO> ApiV1EnvironmentMGCustomerSupplierExtensionMGIdGetAsync (string id, string environment, string tipocfCg44, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null);

        /// <summary>
        /// Get by ID
        /// </summary>
        /// <remarks>
        /// Get an object of type corresponding the requested id
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="tipocfCg44">TipocfCg44 Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse (CustomerSupplierExtensionMGDTO)</returns>
        System.Threading.Tasks.Task<ApiResponse<CustomerSupplierExtensionMGDTO>> ApiV1EnvironmentMGCustomerSupplierExtensionMGIdGetAsyncWithHttpInfo (string id, string environment, string tipocfCg44, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null);
        /// <summary>
        /// Update partial
        /// </summary>
        /// <remarks>
        /// Patching an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfCg44">TipocfCg44 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPatchAsync (Object body, string authorizationScope, string tipocfCg44, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);

        /// <summary>
        /// Update partial
        /// </summary>
        /// <remarks>
        /// Patching an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfCg44">TipocfCg44 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPatchAsyncWithHttpInfo (Object body, string authorizationScope, string tipocfCg44, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);
        /// <summary>
        /// Update
        /// </summary>
        /// <remarks>
        /// Updating an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfCg44">TipocfCg44 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of CustomerSupplierExtensionMGDTO</returns>
        System.Threading.Tasks.Task<CustomerSupplierExtensionMGDTO> ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPutAsync (CustomerSupplierExtensionMGDTO body, string authorizationScope, string tipocfCg44, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);

        /// <summary>
        /// Update
        /// </summary>
        /// <remarks>
        /// Updating an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfCg44">TipocfCg44 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (CustomerSupplierExtensionMGDTO)</returns>
        System.Threading.Tasks.Task<ApiResponse<CustomerSupplierExtensionMGDTO>> ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPutAsyncWithHttpInfo (CustomerSupplierExtensionMGDTO body, string authorizationScope, string tipocfCg44, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);
        /// <summary>
        /// Validate
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task ApiV1EnvironmentMGCustomerSupplierExtensionMGValidatePostAsync (CustomerSupplierExtensionMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null);

        /// <summary>
        /// Validate
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentMGCustomerSupplierExtensionMGValidatePostAsyncWithHttpInfo (CustomerSupplierExtensionMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null);
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
        public partial class CustomerSupplierExtensionMGApi : ICustomerSupplierExtensionMGApi
    {
        private IO.Swagger.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="CustomerSupplierExtensionMGApi"/> class.
        /// </summary>
        /// <returns></returns>
        public CustomerSupplierExtensionMGApi(String basePath)
        {
            this.Configuration = new IO.Swagger.Client.Configuration { BasePath = basePath };

            ExceptionFactory = IO.Swagger.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="CustomerSupplierExtensionMGApi"/> class
        /// </summary>
        /// <returns></returns>
        public CustomerSupplierExtensionMGApi()
        {
            this.Configuration = IO.Swagger.Client.Configuration.Default;

            ExceptionFactory = IO.Swagger.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="CustomerSupplierExtensionMGApi"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public CustomerSupplierExtensionMGApi(IO.Swagger.Client.Configuration configuration = null)
        {
            if (configuration == null) // use the default one in Configuration
                this.Configuration = IO.Swagger.Client.Configuration.Default;
            else
                this.Configuration = configuration;

            ExceptionFactory = IO.Swagger.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public String GetBasePath()
        {
            return this.Configuration.ApiClient.RestClient.Options.BaseUrl.ToString();
        }

        /// <summary>
        /// Sets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        [Obsolete("SetBasePath is deprecated, please do 'Configuration.ApiClient = new ApiClient(\"http://new-path\")' instead.")]
        public void SetBasePath(String basePath)
        {
            // do nothing
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public IO.Swagger.Client.Configuration Configuration {get; set;}

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public IO.Swagger.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// Gets the default header.
        /// </summary>
        /// <returns>Dictionary of HTTP header</returns>
        [Obsolete("DefaultHeader is deprecated, please use Configuration.DefaultHeader instead.")]
        public IDictionary<String, String> DefaultHeader()
        {
            return new ReadOnlyDictionary<string, string>(this.Configuration.DefaultHeader);
        }

        /// <summary>
        /// Add default header.
        /// </summary>
        /// <param name="key">Header field name.</param>
        /// <param name="value">Header field value.</param>
        /// <returns></returns>
        [Obsolete("AddDefaultHeader is deprecated, please use Configuration.AddDefaultHeader instead.")]
        public void AddDefaultHeader(string key, string value)
        {
            this.Configuration.AddDefaultHeader(key, value);
        }

        /// <summary>
        /// Get by ID Get an object of type corresponding the requested id
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="tipocfCg44">TipocfCg44 Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>CustomerSupplierExtensionMGDTO</returns>
        public CustomerSupplierExtensionMGDTO ApiV1EnvironmentMGCustomerSupplierExtensionMGIdGet (string id, string environment, string tipocfCg44, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null)
        {
             ApiResponse<CustomerSupplierExtensionMGDTO> localVarResponse = ApiV1EnvironmentMGCustomerSupplierExtensionMGIdGetWithHttpInfo(id, environment, tipocfCg44, authorizationScope, dlevel, dlevelkey, company, user, acceptLanguage);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Get by ID Get an object of type corresponding the requested id
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="tipocfCg44">TipocfCg44 Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>ApiResponse of CustomerSupplierExtensionMGDTO</returns>
        public ApiResponse< CustomerSupplierExtensionMGDTO > ApiV1EnvironmentMGCustomerSupplierExtensionMGIdGetWithHttpInfo (string id, string environment, string tipocfCg44, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null)
        {
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGIdGet");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGIdGet");
            // verify the required parameter 'tipocfCg44' is set
            if (tipocfCg44 == null)
                throw new ApiException(400, "Missing required parameter 'tipocfCg44' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGIdGet");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGIdGet");

            var localVarPath = "/api/v1/{environment}/MG/CustomerSupplierExtensionMG/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (dlevel != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "dlevel", dlevel)); // query parameter
            if (dlevelkey != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "dlevelkey", dlevelkey)); // query parameter
            if (tipocfCg44 != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "TipocfCg44", tipocfCg44)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Get, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGCustomerSupplierExtensionMGIdGet", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<CustomerSupplierExtensionMGDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (CustomerSupplierExtensionMGDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(CustomerSupplierExtensionMGDTO)));
        }

        /// <summary>
        /// Get by ID Get an object of type corresponding the requested id
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="tipocfCg44">TipocfCg44 Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of CustomerSupplierExtensionMGDTO</returns>
        public async System.Threading.Tasks.Task<CustomerSupplierExtensionMGDTO> ApiV1EnvironmentMGCustomerSupplierExtensionMGIdGetAsync (string id, string environment, string tipocfCg44, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null)
        {
             ApiResponse<CustomerSupplierExtensionMGDTO> localVarResponse = await ApiV1EnvironmentMGCustomerSupplierExtensionMGIdGetAsyncWithHttpInfo(id, environment, tipocfCg44, authorizationScope, dlevel, dlevelkey, company, user, acceptLanguage);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Get by ID Get an object of type corresponding the requested id
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="tipocfCg44">TipocfCg44 Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse (CustomerSupplierExtensionMGDTO)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<CustomerSupplierExtensionMGDTO>> ApiV1EnvironmentMGCustomerSupplierExtensionMGIdGetAsyncWithHttpInfo (string id, string environment, string tipocfCg44, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null)
        {
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGIdGet");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGIdGet");
            // verify the required parameter 'tipocfCg44' is set
            if (tipocfCg44 == null)
                throw new ApiException(400, "Missing required parameter 'tipocfCg44' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGIdGet");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGIdGet");

            var localVarPath = "/api/v1/{environment}/MG/CustomerSupplierExtensionMG/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (dlevel != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "dlevel", dlevel)); // query parameter
            if (dlevelkey != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "dlevelkey", dlevelkey)); // query parameter
            if (tipocfCg44 != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "TipocfCg44", tipocfCg44)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Get, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGCustomerSupplierExtensionMGIdGet", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<CustomerSupplierExtensionMGDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (CustomerSupplierExtensionMGDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(CustomerSupplierExtensionMGDTO)));
        }

        /// <summary>
        /// Update partial Patching an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfCg44">TipocfCg44 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns></returns>
        public void ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPatch (Object body, string authorizationScope, string tipocfCg44, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
             ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPatchWithHttpInfo(body, authorizationScope, tipocfCg44, id, environment, acceptLanguage, force, op, company, user);
        }

        /// <summary>
        /// Update partial Patching an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfCg44">TipocfCg44 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public ApiResponse<Object> ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPatchWithHttpInfo (Object body, string authorizationScope, string tipocfCg44, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPatch");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPatch");
            // verify the required parameter 'tipocfCg44' is set
            if (tipocfCg44 == null)
                throw new ApiException(400, "Missing required parameter 'tipocfCg44' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPatch");
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPatch");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPatch");

            var localVarPath = "/api/v1/{environment}/MG/CustomerSupplierExtensionMG/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (tipocfCg44 != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "TipocfCg44", tipocfCg44)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Patch, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPatch", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Update partial Patching an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfCg44">TipocfCg44 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPatchAsync (Object body, string authorizationScope, string tipocfCg44, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
             await ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPatchAsyncWithHttpInfo(body, authorizationScope, tipocfCg44, id, environment, acceptLanguage, force, op, company, user);

        }

        /// <summary>
        /// Update partial Patching an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfCg44">TipocfCg44 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPatchAsyncWithHttpInfo (Object body, string authorizationScope, string tipocfCg44, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPatch");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPatch");
            // verify the required parameter 'tipocfCg44' is set
            if (tipocfCg44 == null)
                throw new ApiException(400, "Missing required parameter 'tipocfCg44' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPatch");
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPatch");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPatch");

            var localVarPath = "/api/v1/{environment}/MG/CustomerSupplierExtensionMG/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (tipocfCg44 != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "TipocfCg44", tipocfCg44)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Patch, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPatch", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Update Updating an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfCg44">TipocfCg44 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>CustomerSupplierExtensionMGDTO</returns>
        public CustomerSupplierExtensionMGDTO ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPut (CustomerSupplierExtensionMGDTO body, string authorizationScope, string tipocfCg44, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
             ApiResponse<CustomerSupplierExtensionMGDTO> localVarResponse = ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPutWithHttpInfo(body, authorizationScope, tipocfCg44, id, environment, acceptLanguage, force, op, company, user);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Update Updating an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfCg44">TipocfCg44 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of CustomerSupplierExtensionMGDTO</returns>
        public ApiResponse< CustomerSupplierExtensionMGDTO > ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPutWithHttpInfo (CustomerSupplierExtensionMGDTO body, string authorizationScope, string tipocfCg44, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPut");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPut");
            // verify the required parameter 'tipocfCg44' is set
            if (tipocfCg44 == null)
                throw new ApiException(400, "Missing required parameter 'tipocfCg44' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPut");
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPut");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPut");

            var localVarPath = "/api/v1/{environment}/MG/CustomerSupplierExtensionMG/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (tipocfCg44 != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "TipocfCg44", tipocfCg44)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Put, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPut", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<CustomerSupplierExtensionMGDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (CustomerSupplierExtensionMGDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(CustomerSupplierExtensionMGDTO)));
        }

        /// <summary>
        /// Update Updating an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfCg44">TipocfCg44 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of CustomerSupplierExtensionMGDTO</returns>
        public async System.Threading.Tasks.Task<CustomerSupplierExtensionMGDTO> ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPutAsync (CustomerSupplierExtensionMGDTO body, string authorizationScope, string tipocfCg44, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
             ApiResponse<CustomerSupplierExtensionMGDTO> localVarResponse = await ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPutAsyncWithHttpInfo(body, authorizationScope, tipocfCg44, id, environment, acceptLanguage, force, op, company, user);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Update Updating an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfCg44">TipocfCg44 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (CustomerSupplierExtensionMGDTO)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<CustomerSupplierExtensionMGDTO>> ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPutAsyncWithHttpInfo (CustomerSupplierExtensionMGDTO body, string authorizationScope, string tipocfCg44, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPut");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPut");
            // verify the required parameter 'tipocfCg44' is set
            if (tipocfCg44 == null)
                throw new ApiException(400, "Missing required parameter 'tipocfCg44' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPut");
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPut");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPut");

            var localVarPath = "/api/v1/{environment}/MG/CustomerSupplierExtensionMG/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (tipocfCg44 != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "TipocfCg44", tipocfCg44)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Put, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPut", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<CustomerSupplierExtensionMGDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (CustomerSupplierExtensionMGDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(CustomerSupplierExtensionMGDTO)));
        }

        /// <summary>
        /// Validate Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns></returns>
        public void ApiV1EnvironmentMGCustomerSupplierExtensionMGValidatePost (CustomerSupplierExtensionMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)
        {
             ApiV1EnvironmentMGCustomerSupplierExtensionMGValidatePostWithHttpInfo(body, authorizationScope, environment, acceptLanguage, company, user);
        }

        /// <summary>
        /// Validate Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public ApiResponse<Object> ApiV1EnvironmentMGCustomerSupplierExtensionMGValidatePostWithHttpInfo (CustomerSupplierExtensionMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGValidatePost");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGValidatePost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGValidatePost");

            var localVarPath = "/api/v1/{environment}/MG/CustomerSupplierExtensionMG/validate";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGCustomerSupplierExtensionMGValidatePost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Validate Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task ApiV1EnvironmentMGCustomerSupplierExtensionMGValidatePostAsync (CustomerSupplierExtensionMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)
        {
             await ApiV1EnvironmentMGCustomerSupplierExtensionMGValidatePostAsyncWithHttpInfo(body, authorizationScope, environment, acceptLanguage, company, user);

        }

        /// <summary>
        /// Validate Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentMGCustomerSupplierExtensionMGValidatePostAsyncWithHttpInfo (CustomerSupplierExtensionMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGValidatePost");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGValidatePost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling CustomerSupplierExtensionMGApi->ApiV1EnvironmentMGCustomerSupplierExtensionMGValidatePost");

            var localVarPath = "/api/v1/{environment}/MG/CustomerSupplierExtensionMG/validate";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGCustomerSupplierExtensionMGValidatePost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

    }
}
