# IO.Swagger.Api.IEImportMGApi

All URIs are relative to *https://apicsdemo.teamsystem.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**ApiV1EnvironmentMGIEImportMGDocumentPost**](IEImportMGApi.md#apiv1environmentmgieimportmgdocumentpost) | **POST** /api/v1/{environment}/MG/IEImportMG/document | Import Documents based on the required parameters

<a name="apiv1environmentmgieimportmgdocumentpost"></a>
# **ApiV1EnvironmentMGIEImportMGDocumentPost**
> ImportExportResultDTO ApiV1EnvironmentMGIEImportMGDocumentPost (ImportDocumentMGParameterDTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)

Import Documents based on the required parameters

Import Documents based on the required parameters

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentMGIEImportMGDocumentPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new IEImportMGApi();
            var body = new ImportDocumentMGParameterDTO(); // ImportDocumentMGParameterDTO | Import Documents parameters
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Import Documents based on the required parameters
                ImportExportResultDTO result = apiInstance.ApiV1EnvironmentMGIEImportMGDocumentPost(body, authorizationScope, environment, acceptLanguage, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling IEImportMGApi.ApiV1EnvironmentMGIEImportMGDocumentPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**ImportDocumentMGParameterDTO**](ImportDocumentMGParameterDTO.md)| Import Documents parameters | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**ImportExportResultDTO**](ImportExportResultDTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
