# IO.Swagger.Api.GiacenzaMGApi

All URIs are relative to *https://apicsdemo.teamsystem.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**ApiV1EnvironmentMGGiacenzaMGDisponibilitaPost**](GiacenzaMGApi.md#apiv1environmentmggiacenzamgdisponibilitapost) | **POST** /api/v1/{environment}/MG/GiacenzaMG/disponibilita | Calculate stock availability based on the required parameters
[**ApiV1EnvironmentMGGiacenzaMGRicalcologiacenzaPost**](GiacenzaMGApi.md#apiv1environmentmggiacenzamgricalcologiacenzapost) | **POST** /api/v1/{environment}/MG/GiacenzaMG/ricalcologiacenza | Recalculate the stock based on the required parameters
[**ApiV1EnvironmentMGGiacenzaMGValidatePost**](GiacenzaMGApi.md#apiv1environmentmggiacenzamgvalidatepost) | **POST** /api/v1/{environment}/MG/GiacenzaMG/validate | Validate

<a name="apiv1environmentmggiacenzamgdisponibilitapost"></a>
# **ApiV1EnvironmentMGGiacenzaMGDisponibilitaPost**
> void ApiV1EnvironmentMGGiacenzaMGDisponibilitaPost (CalcolaDisponibilitaParams body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)

Calculate stock availability based on the required parameters

Calculate stock availability based on the required parameters

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentMGGiacenzaMGDisponibilitaPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new GiacenzaMGApi();
            var body = new CalcolaDisponibilitaParams(); // CalcolaDisponibilitaParams | Object that contains all the parameters that can affect the stock availability recalculation
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Calculate stock availability based on the required parameters
                apiInstance.ApiV1EnvironmentMGGiacenzaMGDisponibilitaPost(body, authorizationScope, environment, acceptLanguage, company, user);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling GiacenzaMGApi.ApiV1EnvironmentMGGiacenzaMGDisponibilitaPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**CalcolaDisponibilitaParams**](CalcolaDisponibilitaParams.md)| Object that contains all the parameters that can affect the stock availability recalculation | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

void (empty response body)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentmggiacenzamgricalcologiacenzapost"></a>
# **ApiV1EnvironmentMGGiacenzaMGRicalcologiacenzaPost**
> void ApiV1EnvironmentMGGiacenzaMGRicalcologiacenzaPost (RicalcoloGiacenzaParams body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)

Recalculate the stock based on the required parameters

Recalculate the stock based on the required parameters

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentMGGiacenzaMGRicalcologiacenzaPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new GiacenzaMGApi();
            var body = new RicalcoloGiacenzaParams(); // RicalcoloGiacenzaParams | Object that contains all the parameters that can affect the stock recalculation
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Recalculate the stock based on the required parameters
                apiInstance.ApiV1EnvironmentMGGiacenzaMGRicalcologiacenzaPost(body, authorizationScope, environment, acceptLanguage, company, user);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling GiacenzaMGApi.ApiV1EnvironmentMGGiacenzaMGRicalcologiacenzaPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**RicalcoloGiacenzaParams**](RicalcoloGiacenzaParams.md)| Object that contains all the parameters that can affect the stock recalculation | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

void (empty response body)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentmggiacenzamgvalidatepost"></a>
# **ApiV1EnvironmentMGGiacenzaMGValidatePost**
> void ApiV1EnvironmentMGGiacenzaMGValidatePost (GiacenzaMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)

Validate

Validation of object of type

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentMGGiacenzaMGValidatePostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new GiacenzaMGApi();
            var body = new GiacenzaMGDTO(); // GiacenzaMGDTO | Object of type to validate
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Validate
                apiInstance.ApiV1EnvironmentMGGiacenzaMGValidatePost(body, authorizationScope, environment, acceptLanguage, company, user);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling GiacenzaMGApi.ApiV1EnvironmentMGGiacenzaMGValidatePost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**GiacenzaMGDTO**](GiacenzaMGDTO.md)| Object of type to validate | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

void (empty response body)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
