/* 
 * TSE Cloud - MG
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.3000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// MG62_TESTIFIS - Testi fissi&lt;br&gt;Proprietà chiave:&lt;ul&gt;&lt;li&gt;&lt;b&gt;Codice&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;
    /// </summary>
    [DataContract]
        public partial class TestoFissoMGDTO :  IEquatable<TestoFissoMGDTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="TestoFissoMGDTO" /> class.
        /// </summary>
        /// <param name="codice">MG62_CODICE - Codice testo fisso (required).</param>
        /// <param name="datafineval">MG62_DATAFINEVAL - Data fine validità.</param>
        /// <param name="datainizioval">MG62_DATAINIZIOVAL - Data inizio validità.</param>
        /// <param name="descr">MG62_DESCR - Descrizione.</param>
        /// <param name="idmediaCg99">MG62_IDMEDIA_CG99 - ID HyperMedia.</param>
        /// <param name="idprov">MG62_IDPROV - IdProv (Required only in PUT/PATCH).</param>
        /// <param name="indTipoevas">MG62_INDTIPOEVAS - Tipo trasf. doc.&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si trasformazione, solo la 1^ volta in automatico&lt;/li&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No trasformazione&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Si trasformazione, sempre in automatico&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Si trasformazione, solo la 1^ volta con conferma manuale&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Si trasformazione, sempre con conferma manuale&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Si trasformazione, se trasformata riga di riferimento&lt;/li&gt;&lt;/ul&gt; (default to 1).</param>
        /// <param name="testo">MG62_TESTO - Testo.</param>
        /// <param name="additionalData">additionalData.</param>
        /// <param name="pluginData">pluginData.</param>
        public TestoFissoMGDTO(string codice = default(string), DateTime? datafineval = default(DateTime?), DateTime? datainizioval = default(DateTime?), string descr = default(string), double? idmediaCg99 = default(double?), int? idprov = default(int?), double? indTipoevas = 1, string testo = default(string), Dictionary<string, Object> additionalData = default(Dictionary<string, Object>), Dictionary<string, Object> pluginData = default(Dictionary<string, Object>))
        {
            // to ensure "codice" is required (not null)
            if (codice == null)
            {
                throw new InvalidDataException("codice is a required property for TestoFissoMGDTO and cannot be null");
            }
            else
            {
                this.Codice = codice;
            }
            this.Datafineval = datafineval;
            this.Datainizioval = datainizioval;
            this.Descr = descr;
            this.IdmediaCg99 = idmediaCg99;
            this.Idprov = idprov;
            // use default value if no "indTipoevas" provided
            if (indTipoevas == null)
            {
                this.IndTipoevas = 1;
            }
            else
            {
                this.IndTipoevas = indTipoevas;
            }
            this.Testo = testo;
            this.AdditionalData = additionalData;
            this.PluginData = pluginData;
        }
        
        /// <summary>
        /// MG62_CODICE - Codice testo fisso
        /// </summary>
        /// <value>MG62_CODICE - Codice testo fisso</value>
        [DataMember(Name="codice", EmitDefaultValue=false)]
        public string Codice { get; set; }

        /// <summary>
        /// MG62_DATAFINEVAL - Data fine validità
        /// </summary>
        /// <value>MG62_DATAFINEVAL - Data fine validità</value>
        [DataMember(Name="datafineval", EmitDefaultValue=false)]
        public DateTime? Datafineval { get; set; }

        /// <summary>
        /// MG62_DATAINIZIOVAL - Data inizio validità
        /// </summary>
        /// <value>MG62_DATAINIZIOVAL - Data inizio validità</value>
        [DataMember(Name="datainizioval", EmitDefaultValue=false)]
        public DateTime? Datainizioval { get; set; }

        /// <summary>
        /// MG62_DESCR - Descrizione
        /// </summary>
        /// <value>MG62_DESCR - Descrizione</value>
        [DataMember(Name="descr", EmitDefaultValue=false)]
        public string Descr { get; set; }

        /// <summary>
        /// MG62_IDMEDIA_CG99 - ID HyperMedia
        /// </summary>
        /// <value>MG62_IDMEDIA_CG99 - ID HyperMedia</value>
        [DataMember(Name="idmediaCg99", EmitDefaultValue=false)]
        public double? IdmediaCg99 { get; set; }

        /// <summary>
        /// MG62_IDPROV - IdProv (Required only in PUT/PATCH)
        /// </summary>
        /// <value>MG62_IDPROV - IdProv (Required only in PUT/PATCH)</value>
        [DataMember(Name="idprov", EmitDefaultValue=false)]
        public int? Idprov { get; set; }

        /// <summary>
        /// MG62_INDTIPOEVAS - Tipo trasf. doc.&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si trasformazione, solo la 1^ volta in automatico&lt;/li&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No trasformazione&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Si trasformazione, sempre in automatico&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Si trasformazione, solo la 1^ volta con conferma manuale&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Si trasformazione, sempre con conferma manuale&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Si trasformazione, se trasformata riga di riferimento&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG62_INDTIPOEVAS - Tipo trasf. doc.&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si trasformazione, solo la 1^ volta in automatico&lt;/li&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No trasformazione&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Si trasformazione, sempre in automatico&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Si trasformazione, solo la 1^ volta con conferma manuale&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Si trasformazione, sempre con conferma manuale&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Si trasformazione, se trasformata riga di riferimento&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indTipoevas", EmitDefaultValue=false)]
        public double? IndTipoevas { get; set; }

        /// <summary>
        /// MG62_TESTO - Testo
        /// </summary>
        /// <value>MG62_TESTO - Testo</value>
        [DataMember(Name="testo", EmitDefaultValue=false)]
        public string Testo { get; set; }

        /// <summary>
        /// Gets or Sets AdditionalData
        /// </summary>
        [DataMember(Name="additionalData", EmitDefaultValue=false)]
        public Dictionary<string, Object> AdditionalData { get; set; }

        /// <summary>
        /// Gets or Sets PluginData
        /// </summary>
        [DataMember(Name="pluginData", EmitDefaultValue=false)]
        public Dictionary<string, Object> PluginData { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class TestoFissoMGDTO {\n");
            sb.Append("  Codice: ").Append(Codice).Append("\n");
            sb.Append("  Datafineval: ").Append(Datafineval).Append("\n");
            sb.Append("  Datainizioval: ").Append(Datainizioval).Append("\n");
            sb.Append("  Descr: ").Append(Descr).Append("\n");
            sb.Append("  IdmediaCg99: ").Append(IdmediaCg99).Append("\n");
            sb.Append("  Idprov: ").Append(Idprov).Append("\n");
            sb.Append("  IndTipoevas: ").Append(IndTipoevas).Append("\n");
            sb.Append("  Testo: ").Append(Testo).Append("\n");
            sb.Append("  AdditionalData: ").Append(AdditionalData).Append("\n");
            sb.Append("  PluginData: ").Append(PluginData).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as TestoFissoMGDTO);
        }

        /// <summary>
        /// Returns true if TestoFissoMGDTO instances are equal
        /// </summary>
        /// <param name="input">Instance of TestoFissoMGDTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(TestoFissoMGDTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.Codice == input.Codice ||
                    (this.Codice != null &&
                    this.Codice.Equals(input.Codice))
                ) && 
                (
                    this.Datafineval == input.Datafineval ||
                    (this.Datafineval != null &&
                    this.Datafineval.Equals(input.Datafineval))
                ) && 
                (
                    this.Datainizioval == input.Datainizioval ||
                    (this.Datainizioval != null &&
                    this.Datainizioval.Equals(input.Datainizioval))
                ) && 
                (
                    this.Descr == input.Descr ||
                    (this.Descr != null &&
                    this.Descr.Equals(input.Descr))
                ) && 
                (
                    this.IdmediaCg99 == input.IdmediaCg99 ||
                    (this.IdmediaCg99 != null &&
                    this.IdmediaCg99.Equals(input.IdmediaCg99))
                ) && 
                (
                    this.Idprov == input.Idprov ||
                    (this.Idprov != null &&
                    this.Idprov.Equals(input.Idprov))
                ) && 
                (
                    this.IndTipoevas == input.IndTipoevas ||
                    (this.IndTipoevas != null &&
                    this.IndTipoevas.Equals(input.IndTipoevas))
                ) && 
                (
                    this.Testo == input.Testo ||
                    (this.Testo != null &&
                    this.Testo.Equals(input.Testo))
                ) && 
                (
                    this.AdditionalData == input.AdditionalData ||
                    this.AdditionalData != null &&
                    input.AdditionalData != null &&
                    this.AdditionalData.SequenceEqual(input.AdditionalData)
                ) && 
                (
                    this.PluginData == input.PluginData ||
                    this.PluginData != null &&
                    input.PluginData != null &&
                    this.PluginData.SequenceEqual(input.PluginData)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.Codice != null)
                    hashCode = hashCode * 59 + this.Codice.GetHashCode();
                if (this.Datafineval != null)
                    hashCode = hashCode * 59 + this.Datafineval.GetHashCode();
                if (this.Datainizioval != null)
                    hashCode = hashCode * 59 + this.Datainizioval.GetHashCode();
                if (this.Descr != null)
                    hashCode = hashCode * 59 + this.Descr.GetHashCode();
                if (this.IdmediaCg99 != null)
                    hashCode = hashCode * 59 + this.IdmediaCg99.GetHashCode();
                if (this.Idprov != null)
                    hashCode = hashCode * 59 + this.Idprov.GetHashCode();
                if (this.IndTipoevas != null)
                    hashCode = hashCode * 59 + this.IndTipoevas.GetHashCode();
                if (this.Testo != null)
                    hashCode = hashCode * 59 + this.Testo.GetHashCode();
                if (this.AdditionalData != null)
                    hashCode = hashCode * 59 + this.AdditionalData.GetHashCode();
                if (this.PluginData != null)
                    hashCode = hashCode * 59 + this.PluginData.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
