/* 
 * TSE Cloud - MG
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.3000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// MG2A_RISCHIO - Controllo rischio&lt;br&gt;Proprietà chiave:&lt;ul&gt;&lt;li&gt;&lt;b&gt;Codice&lt;/b&gt;&lt;/li&gt;&lt;li&gt;&lt;b&gt;DittaCg18&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;
    /// </summary>
    [DataContract]
        public partial class RiskMGDTO :  IEquatable<RiskMGDTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="RiskMGDTO" /> class.
        /// </summary>
        /// <param name="codice">MG2A_CODICE - Codice rischio (required).</param>
        /// <param name="descrizione">MG2A_DESCRIZIONE - Descrizione.</param>
        /// <param name="dittaCg18">MG2A_DITTA_CG18 - Ditta (default to 0).</param>
        /// <param name="flgAttivo">MG2A_FLGATTIVO - Condizione attiva&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="flgCalceffcons">MG2A_FLGCALCEFFCONS - Elaborazione scadenze consolidate&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="flgCalceffdacons">MG2A_FLGCALCEFFDACONS - Includi scadenze da consolidare&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="flgCalceffprev">MG2A_FLGCALCEFFPREV - Includi scadenze previsionali&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="flgCalcmovcons">MG2A_FLGCALCMOVCONS - Includi movimenti consolidati nel calcolo del saldo&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="flgCalcmovdacons">MG2A_FLGCALCMOVDACONS - Includi movimenti da consolidare nel calcolo del saldo&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="flgCalcmovprev">MG2A_FLGCALCMOVPREV - Includi movimenti previsionali nel calcolo del saldo&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="flgEffettiscaduti">MG2A_FLGEFFETTISCADUTI - Includi effetti  da liberalizzare nel valore del fido&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="flgOrdini">MG2A_FLGORDINI - Includi ordini non evasi nel valore del fido&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="flgSaldocon">MG2A_FLGSALDOCON - Includi saldo contabile nel valore del fido&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="flgScadereins">MG2A_FLGSCADEREINS - Includi effetti a scadere insoluti nel valore del fido&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="flgScaderenoins">MG2A_FLGSCADERENOINS - Includi effetti a scadere non insoluti nel valore del fido&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="flgScadutoins">MG2A_FLGSCADUTOINS - Includi effetti scaduti insoluti nel valore del fido&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="flgScadutonoins">MG2A_FLGSCADUTONOINS - Includi effetti scaduti non insoluti nel valore del fido&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="flgSelclifortrasf">MG2A_FLGSELCLIFORTRASF - Blocco selezione clienti/fornitori in trasformazione&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="flgSolobusinesriskattivo">MG2A_FLGSOLOBUSINESRISKATTIVO - FlgSolobusinesriskattivo&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="indAttivatrasf">MG2A_INDATTIVATRASF - Modalità di attivazione su trasformazione&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Tutti selezionati&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Tutti,con fuori fido deselezionati&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Solo fuori fido selezionati&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Solo fuori fido deselezionati&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Escludi fuori fido in automatico&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="indElabscadinsol">MG2A_INDELABSCADINSOL - Tipo elaborazione scadenze insolute&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Tutte le scadenze&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Solo scadenze aperte&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Solo scadenze chiuse&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="indProvenienzafido">MG2A_INDPROVENIENZAFIDO - Indicatore provenienza fido&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Fido cliente/Fido ass.credito&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Fido ass.credito/Fido cliente&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Fido cliente + Fido ass.rischio&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="indSegnalazionecorpo">MG2A_INDSEGNALAZIONECORPO - Modalità segnalazione fuori fido su corpo documento&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Segnalazione semplice&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Segnalazione con valori&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Segnalazione completa&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="mesiricdocdafatt">MG2A_MESIRICDOCDAFATT - Mesi retroattivi recupero doc. da fatturare.</param>
        /// <param name="mesiricordini">MG2A_MESIRICORDINI - Mesi retroattivi recupero doc. da evadere.</param>
        /// <param name="mesiricscadenze">MG2A_MESIRICSCADENZE - Mesi retroattivi recupero scadenze da recuperare.</param>
        /// <param name="additionalData">additionalData.</param>
        /// <param name="pluginData">pluginData.</param>
        public RiskMGDTO(string codice = default(string), string descrizione = default(string), double? dittaCg18 = 0, double? flgAttivo = default(double?), double? flgCalceffcons = default(double?), double? flgCalceffdacons = default(double?), double? flgCalceffprev = default(double?), double? flgCalcmovcons = default(double?), double? flgCalcmovdacons = default(double?), double? flgCalcmovprev = default(double?), double? flgEffettiscaduti = default(double?), double? flgOrdini = default(double?), double? flgSaldocon = default(double?), double? flgScadereins = default(double?), double? flgScaderenoins = default(double?), double? flgScadutoins = default(double?), double? flgScadutonoins = default(double?), double? flgSelclifortrasf = default(double?), double? flgSolobusinesriskattivo = default(double?), double? indAttivatrasf = default(double?), double? indElabscadinsol = default(double?), double? indProvenienzafido = default(double?), double? indSegnalazionecorpo = default(double?), double? mesiricdocdafatt = default(double?), double? mesiricordini = default(double?), double? mesiricscadenze = default(double?), Dictionary<string, Object> additionalData = default(Dictionary<string, Object>), Dictionary<string, Object> pluginData = default(Dictionary<string, Object>))
        {
            // to ensure "codice" is required (not null)
            if (codice == null)
            {
                throw new InvalidDataException("codice is a required property for RiskMGDTO and cannot be null");
            }
            else
            {
                this.Codice = codice;
            }
            this.Descrizione = descrizione;
            // use default value if no "dittaCg18" provided
            if (dittaCg18 == null)
            {
                this.DittaCg18 = 0;
            }
            else
            {
                this.DittaCg18 = dittaCg18;
            }
            this.FlgAttivo = flgAttivo;
            this.FlgCalceffcons = flgCalceffcons;
            this.FlgCalceffdacons = flgCalceffdacons;
            this.FlgCalceffprev = flgCalceffprev;
            this.FlgCalcmovcons = flgCalcmovcons;
            this.FlgCalcmovdacons = flgCalcmovdacons;
            this.FlgCalcmovprev = flgCalcmovprev;
            this.FlgEffettiscaduti = flgEffettiscaduti;
            this.FlgOrdini = flgOrdini;
            this.FlgSaldocon = flgSaldocon;
            this.FlgScadereins = flgScadereins;
            this.FlgScaderenoins = flgScaderenoins;
            this.FlgScadutoins = flgScadutoins;
            this.FlgScadutonoins = flgScadutonoins;
            this.FlgSelclifortrasf = flgSelclifortrasf;
            this.FlgSolobusinesriskattivo = flgSolobusinesriskattivo;
            this.IndAttivatrasf = indAttivatrasf;
            this.IndElabscadinsol = indElabscadinsol;
            this.IndProvenienzafido = indProvenienzafido;
            this.IndSegnalazionecorpo = indSegnalazionecorpo;
            this.Mesiricdocdafatt = mesiricdocdafatt;
            this.Mesiricordini = mesiricordini;
            this.Mesiricscadenze = mesiricscadenze;
            this.AdditionalData = additionalData;
            this.PluginData = pluginData;
        }
        
        /// <summary>
        /// MG2A_CODICE - Codice rischio
        /// </summary>
        /// <value>MG2A_CODICE - Codice rischio</value>
        [DataMember(Name="codice", EmitDefaultValue=false)]
        public string Codice { get; set; }

        /// <summary>
        /// MG2A_DESCRIZIONE - Descrizione
        /// </summary>
        /// <value>MG2A_DESCRIZIONE - Descrizione</value>
        [DataMember(Name="descrizione", EmitDefaultValue=false)]
        public string Descrizione { get; set; }

        /// <summary>
        /// MG2A_DITTA_CG18 - Ditta
        /// </summary>
        /// <value>MG2A_DITTA_CG18 - Ditta</value>
        [DataMember(Name="dittaCg18", EmitDefaultValue=false)]
        public double? DittaCg18 { get; set; }

        /// <summary>
        /// MG2A_FLGATTIVO - Condizione attiva&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG2A_FLGATTIVO - Condizione attiva&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgAttivo", EmitDefaultValue=false)]
        public double? FlgAttivo { get; set; }

        /// <summary>
        /// MG2A_FLGCALCEFFCONS - Elaborazione scadenze consolidate&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG2A_FLGCALCEFFCONS - Elaborazione scadenze consolidate&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgCalceffcons", EmitDefaultValue=false)]
        public double? FlgCalceffcons { get; set; }

        /// <summary>
        /// MG2A_FLGCALCEFFDACONS - Includi scadenze da consolidare&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG2A_FLGCALCEFFDACONS - Includi scadenze da consolidare&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgCalceffdacons", EmitDefaultValue=false)]
        public double? FlgCalceffdacons { get; set; }

        /// <summary>
        /// MG2A_FLGCALCEFFPREV - Includi scadenze previsionali&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG2A_FLGCALCEFFPREV - Includi scadenze previsionali&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgCalceffprev", EmitDefaultValue=false)]
        public double? FlgCalceffprev { get; set; }

        /// <summary>
        /// MG2A_FLGCALCMOVCONS - Includi movimenti consolidati nel calcolo del saldo&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG2A_FLGCALCMOVCONS - Includi movimenti consolidati nel calcolo del saldo&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgCalcmovcons", EmitDefaultValue=false)]
        public double? FlgCalcmovcons { get; set; }

        /// <summary>
        /// MG2A_FLGCALCMOVDACONS - Includi movimenti da consolidare nel calcolo del saldo&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG2A_FLGCALCMOVDACONS - Includi movimenti da consolidare nel calcolo del saldo&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgCalcmovdacons", EmitDefaultValue=false)]
        public double? FlgCalcmovdacons { get; set; }

        /// <summary>
        /// MG2A_FLGCALCMOVPREV - Includi movimenti previsionali nel calcolo del saldo&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG2A_FLGCALCMOVPREV - Includi movimenti previsionali nel calcolo del saldo&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgCalcmovprev", EmitDefaultValue=false)]
        public double? FlgCalcmovprev { get; set; }

        /// <summary>
        /// MG2A_FLGEFFETTISCADUTI - Includi effetti  da liberalizzare nel valore del fido&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG2A_FLGEFFETTISCADUTI - Includi effetti  da liberalizzare nel valore del fido&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgEffettiscaduti", EmitDefaultValue=false)]
        public double? FlgEffettiscaduti { get; set; }

        /// <summary>
        /// MG2A_FLGORDINI - Includi ordini non evasi nel valore del fido&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG2A_FLGORDINI - Includi ordini non evasi nel valore del fido&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgOrdini", EmitDefaultValue=false)]
        public double? FlgOrdini { get; set; }

        /// <summary>
        /// MG2A_FLGSALDOCON - Includi saldo contabile nel valore del fido&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG2A_FLGSALDOCON - Includi saldo contabile nel valore del fido&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgSaldocon", EmitDefaultValue=false)]
        public double? FlgSaldocon { get; set; }

        /// <summary>
        /// MG2A_FLGSCADEREINS - Includi effetti a scadere insoluti nel valore del fido&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG2A_FLGSCADEREINS - Includi effetti a scadere insoluti nel valore del fido&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgScadereins", EmitDefaultValue=false)]
        public double? FlgScadereins { get; set; }

        /// <summary>
        /// MG2A_FLGSCADERENOINS - Includi effetti a scadere non insoluti nel valore del fido&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG2A_FLGSCADERENOINS - Includi effetti a scadere non insoluti nel valore del fido&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgScaderenoins", EmitDefaultValue=false)]
        public double? FlgScaderenoins { get; set; }

        /// <summary>
        /// MG2A_FLGSCADUTOINS - Includi effetti scaduti insoluti nel valore del fido&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG2A_FLGSCADUTOINS - Includi effetti scaduti insoluti nel valore del fido&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgScadutoins", EmitDefaultValue=false)]
        public double? FlgScadutoins { get; set; }

        /// <summary>
        /// MG2A_FLGSCADUTONOINS - Includi effetti scaduti non insoluti nel valore del fido&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG2A_FLGSCADUTONOINS - Includi effetti scaduti non insoluti nel valore del fido&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgScadutonoins", EmitDefaultValue=false)]
        public double? FlgScadutonoins { get; set; }

        /// <summary>
        /// MG2A_FLGSELCLIFORTRASF - Blocco selezione clienti/fornitori in trasformazione&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG2A_FLGSELCLIFORTRASF - Blocco selezione clienti/fornitori in trasformazione&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgSelclifortrasf", EmitDefaultValue=false)]
        public double? FlgSelclifortrasf { get; set; }

        /// <summary>
        /// MG2A_FLGSOLOBUSINESRISKATTIVO - FlgSolobusinesriskattivo&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG2A_FLGSOLOBUSINESRISKATTIVO - FlgSolobusinesriskattivo&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgSolobusinesriskattivo", EmitDefaultValue=false)]
        public double? FlgSolobusinesriskattivo { get; set; }

        /// <summary>
        /// MG2A_INDATTIVATRASF - Modalità di attivazione su trasformazione&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Tutti selezionati&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Tutti,con fuori fido deselezionati&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Solo fuori fido selezionati&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Solo fuori fido deselezionati&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Escludi fuori fido in automatico&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG2A_INDATTIVATRASF - Modalità di attivazione su trasformazione&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Tutti selezionati&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Tutti,con fuori fido deselezionati&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Solo fuori fido selezionati&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Solo fuori fido deselezionati&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Escludi fuori fido in automatico&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indAttivatrasf", EmitDefaultValue=false)]
        public double? IndAttivatrasf { get; set; }

        /// <summary>
        /// MG2A_INDELABSCADINSOL - Tipo elaborazione scadenze insolute&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Tutte le scadenze&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Solo scadenze aperte&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Solo scadenze chiuse&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG2A_INDELABSCADINSOL - Tipo elaborazione scadenze insolute&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Tutte le scadenze&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Solo scadenze aperte&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Solo scadenze chiuse&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indElabscadinsol", EmitDefaultValue=false)]
        public double? IndElabscadinsol { get; set; }

        /// <summary>
        /// MG2A_INDPROVENIENZAFIDO - Indicatore provenienza fido&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Fido cliente/Fido ass.credito&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Fido ass.credito/Fido cliente&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Fido cliente + Fido ass.rischio&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG2A_INDPROVENIENZAFIDO - Indicatore provenienza fido&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Fido cliente/Fido ass.credito&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Fido ass.credito/Fido cliente&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Fido cliente + Fido ass.rischio&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indProvenienzafido", EmitDefaultValue=false)]
        public double? IndProvenienzafido { get; set; }

        /// <summary>
        /// MG2A_INDSEGNALAZIONECORPO - Modalità segnalazione fuori fido su corpo documento&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Segnalazione semplice&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Segnalazione con valori&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Segnalazione completa&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG2A_INDSEGNALAZIONECORPO - Modalità segnalazione fuori fido su corpo documento&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Segnalazione semplice&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Segnalazione con valori&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Segnalazione completa&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indSegnalazionecorpo", EmitDefaultValue=false)]
        public double? IndSegnalazionecorpo { get; set; }

        /// <summary>
        /// MG2A_MESIRICDOCDAFATT - Mesi retroattivi recupero doc. da fatturare
        /// </summary>
        /// <value>MG2A_MESIRICDOCDAFATT - Mesi retroattivi recupero doc. da fatturare</value>
        [DataMember(Name="mesiricdocdafatt", EmitDefaultValue=false)]
        public double? Mesiricdocdafatt { get; set; }

        /// <summary>
        /// MG2A_MESIRICORDINI - Mesi retroattivi recupero doc. da evadere
        /// </summary>
        /// <value>MG2A_MESIRICORDINI - Mesi retroattivi recupero doc. da evadere</value>
        [DataMember(Name="mesiricordini", EmitDefaultValue=false)]
        public double? Mesiricordini { get; set; }

        /// <summary>
        /// MG2A_MESIRICSCADENZE - Mesi retroattivi recupero scadenze da recuperare
        /// </summary>
        /// <value>MG2A_MESIRICSCADENZE - Mesi retroattivi recupero scadenze da recuperare</value>
        [DataMember(Name="mesiricscadenze", EmitDefaultValue=false)]
        public double? Mesiricscadenze { get; set; }

        /// <summary>
        /// Gets or Sets AdditionalData
        /// </summary>
        [DataMember(Name="additionalData", EmitDefaultValue=false)]
        public Dictionary<string, Object> AdditionalData { get; set; }

        /// <summary>
        /// Gets or Sets PluginData
        /// </summary>
        [DataMember(Name="pluginData", EmitDefaultValue=false)]
        public Dictionary<string, Object> PluginData { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class RiskMGDTO {\n");
            sb.Append("  Codice: ").Append(Codice).Append("\n");
            sb.Append("  Descrizione: ").Append(Descrizione).Append("\n");
            sb.Append("  DittaCg18: ").Append(DittaCg18).Append("\n");
            sb.Append("  FlgAttivo: ").Append(FlgAttivo).Append("\n");
            sb.Append("  FlgCalceffcons: ").Append(FlgCalceffcons).Append("\n");
            sb.Append("  FlgCalceffdacons: ").Append(FlgCalceffdacons).Append("\n");
            sb.Append("  FlgCalceffprev: ").Append(FlgCalceffprev).Append("\n");
            sb.Append("  FlgCalcmovcons: ").Append(FlgCalcmovcons).Append("\n");
            sb.Append("  FlgCalcmovdacons: ").Append(FlgCalcmovdacons).Append("\n");
            sb.Append("  FlgCalcmovprev: ").Append(FlgCalcmovprev).Append("\n");
            sb.Append("  FlgEffettiscaduti: ").Append(FlgEffettiscaduti).Append("\n");
            sb.Append("  FlgOrdini: ").Append(FlgOrdini).Append("\n");
            sb.Append("  FlgSaldocon: ").Append(FlgSaldocon).Append("\n");
            sb.Append("  FlgScadereins: ").Append(FlgScadereins).Append("\n");
            sb.Append("  FlgScaderenoins: ").Append(FlgScaderenoins).Append("\n");
            sb.Append("  FlgScadutoins: ").Append(FlgScadutoins).Append("\n");
            sb.Append("  FlgScadutonoins: ").Append(FlgScadutonoins).Append("\n");
            sb.Append("  FlgSelclifortrasf: ").Append(FlgSelclifortrasf).Append("\n");
            sb.Append("  FlgSolobusinesriskattivo: ").Append(FlgSolobusinesriskattivo).Append("\n");
            sb.Append("  IndAttivatrasf: ").Append(IndAttivatrasf).Append("\n");
            sb.Append("  IndElabscadinsol: ").Append(IndElabscadinsol).Append("\n");
            sb.Append("  IndProvenienzafido: ").Append(IndProvenienzafido).Append("\n");
            sb.Append("  IndSegnalazionecorpo: ").Append(IndSegnalazionecorpo).Append("\n");
            sb.Append("  Mesiricdocdafatt: ").Append(Mesiricdocdafatt).Append("\n");
            sb.Append("  Mesiricordini: ").Append(Mesiricordini).Append("\n");
            sb.Append("  Mesiricscadenze: ").Append(Mesiricscadenze).Append("\n");
            sb.Append("  AdditionalData: ").Append(AdditionalData).Append("\n");
            sb.Append("  PluginData: ").Append(PluginData).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as RiskMGDTO);
        }

        /// <summary>
        /// Returns true if RiskMGDTO instances are equal
        /// </summary>
        /// <param name="input">Instance of RiskMGDTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(RiskMGDTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.Codice == input.Codice ||
                    (this.Codice != null &&
                    this.Codice.Equals(input.Codice))
                ) && 
                (
                    this.Descrizione == input.Descrizione ||
                    (this.Descrizione != null &&
                    this.Descrizione.Equals(input.Descrizione))
                ) && 
                (
                    this.DittaCg18 == input.DittaCg18 ||
                    (this.DittaCg18 != null &&
                    this.DittaCg18.Equals(input.DittaCg18))
                ) && 
                (
                    this.FlgAttivo == input.FlgAttivo ||
                    (this.FlgAttivo != null &&
                    this.FlgAttivo.Equals(input.FlgAttivo))
                ) && 
                (
                    this.FlgCalceffcons == input.FlgCalceffcons ||
                    (this.FlgCalceffcons != null &&
                    this.FlgCalceffcons.Equals(input.FlgCalceffcons))
                ) && 
                (
                    this.FlgCalceffdacons == input.FlgCalceffdacons ||
                    (this.FlgCalceffdacons != null &&
                    this.FlgCalceffdacons.Equals(input.FlgCalceffdacons))
                ) && 
                (
                    this.FlgCalceffprev == input.FlgCalceffprev ||
                    (this.FlgCalceffprev != null &&
                    this.FlgCalceffprev.Equals(input.FlgCalceffprev))
                ) && 
                (
                    this.FlgCalcmovcons == input.FlgCalcmovcons ||
                    (this.FlgCalcmovcons != null &&
                    this.FlgCalcmovcons.Equals(input.FlgCalcmovcons))
                ) && 
                (
                    this.FlgCalcmovdacons == input.FlgCalcmovdacons ||
                    (this.FlgCalcmovdacons != null &&
                    this.FlgCalcmovdacons.Equals(input.FlgCalcmovdacons))
                ) && 
                (
                    this.FlgCalcmovprev == input.FlgCalcmovprev ||
                    (this.FlgCalcmovprev != null &&
                    this.FlgCalcmovprev.Equals(input.FlgCalcmovprev))
                ) && 
                (
                    this.FlgEffettiscaduti == input.FlgEffettiscaduti ||
                    (this.FlgEffettiscaduti != null &&
                    this.FlgEffettiscaduti.Equals(input.FlgEffettiscaduti))
                ) && 
                (
                    this.FlgOrdini == input.FlgOrdini ||
                    (this.FlgOrdini != null &&
                    this.FlgOrdini.Equals(input.FlgOrdini))
                ) && 
                (
                    this.FlgSaldocon == input.FlgSaldocon ||
                    (this.FlgSaldocon != null &&
                    this.FlgSaldocon.Equals(input.FlgSaldocon))
                ) && 
                (
                    this.FlgScadereins == input.FlgScadereins ||
                    (this.FlgScadereins != null &&
                    this.FlgScadereins.Equals(input.FlgScadereins))
                ) && 
                (
                    this.FlgScaderenoins == input.FlgScaderenoins ||
                    (this.FlgScaderenoins != null &&
                    this.FlgScaderenoins.Equals(input.FlgScaderenoins))
                ) && 
                (
                    this.FlgScadutoins == input.FlgScadutoins ||
                    (this.FlgScadutoins != null &&
                    this.FlgScadutoins.Equals(input.FlgScadutoins))
                ) && 
                (
                    this.FlgScadutonoins == input.FlgScadutonoins ||
                    (this.FlgScadutonoins != null &&
                    this.FlgScadutonoins.Equals(input.FlgScadutonoins))
                ) && 
                (
                    this.FlgSelclifortrasf == input.FlgSelclifortrasf ||
                    (this.FlgSelclifortrasf != null &&
                    this.FlgSelclifortrasf.Equals(input.FlgSelclifortrasf))
                ) && 
                (
                    this.FlgSolobusinesriskattivo == input.FlgSolobusinesriskattivo ||
                    (this.FlgSolobusinesriskattivo != null &&
                    this.FlgSolobusinesriskattivo.Equals(input.FlgSolobusinesriskattivo))
                ) && 
                (
                    this.IndAttivatrasf == input.IndAttivatrasf ||
                    (this.IndAttivatrasf != null &&
                    this.IndAttivatrasf.Equals(input.IndAttivatrasf))
                ) && 
                (
                    this.IndElabscadinsol == input.IndElabscadinsol ||
                    (this.IndElabscadinsol != null &&
                    this.IndElabscadinsol.Equals(input.IndElabscadinsol))
                ) && 
                (
                    this.IndProvenienzafido == input.IndProvenienzafido ||
                    (this.IndProvenienzafido != null &&
                    this.IndProvenienzafido.Equals(input.IndProvenienzafido))
                ) && 
                (
                    this.IndSegnalazionecorpo == input.IndSegnalazionecorpo ||
                    (this.IndSegnalazionecorpo != null &&
                    this.IndSegnalazionecorpo.Equals(input.IndSegnalazionecorpo))
                ) && 
                (
                    this.Mesiricdocdafatt == input.Mesiricdocdafatt ||
                    (this.Mesiricdocdafatt != null &&
                    this.Mesiricdocdafatt.Equals(input.Mesiricdocdafatt))
                ) && 
                (
                    this.Mesiricordini == input.Mesiricordini ||
                    (this.Mesiricordini != null &&
                    this.Mesiricordini.Equals(input.Mesiricordini))
                ) && 
                (
                    this.Mesiricscadenze == input.Mesiricscadenze ||
                    (this.Mesiricscadenze != null &&
                    this.Mesiricscadenze.Equals(input.Mesiricscadenze))
                ) && 
                (
                    this.AdditionalData == input.AdditionalData ||
                    this.AdditionalData != null &&
                    input.AdditionalData != null &&
                    this.AdditionalData.SequenceEqual(input.AdditionalData)
                ) && 
                (
                    this.PluginData == input.PluginData ||
                    this.PluginData != null &&
                    input.PluginData != null &&
                    this.PluginData.SequenceEqual(input.PluginData)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.Codice != null)
                    hashCode = hashCode * 59 + this.Codice.GetHashCode();
                if (this.Descrizione != null)
                    hashCode = hashCode * 59 + this.Descrizione.GetHashCode();
                if (this.DittaCg18 != null)
                    hashCode = hashCode * 59 + this.DittaCg18.GetHashCode();
                if (this.FlgAttivo != null)
                    hashCode = hashCode * 59 + this.FlgAttivo.GetHashCode();
                if (this.FlgCalceffcons != null)
                    hashCode = hashCode * 59 + this.FlgCalceffcons.GetHashCode();
                if (this.FlgCalceffdacons != null)
                    hashCode = hashCode * 59 + this.FlgCalceffdacons.GetHashCode();
                if (this.FlgCalceffprev != null)
                    hashCode = hashCode * 59 + this.FlgCalceffprev.GetHashCode();
                if (this.FlgCalcmovcons != null)
                    hashCode = hashCode * 59 + this.FlgCalcmovcons.GetHashCode();
                if (this.FlgCalcmovdacons != null)
                    hashCode = hashCode * 59 + this.FlgCalcmovdacons.GetHashCode();
                if (this.FlgCalcmovprev != null)
                    hashCode = hashCode * 59 + this.FlgCalcmovprev.GetHashCode();
                if (this.FlgEffettiscaduti != null)
                    hashCode = hashCode * 59 + this.FlgEffettiscaduti.GetHashCode();
                if (this.FlgOrdini != null)
                    hashCode = hashCode * 59 + this.FlgOrdini.GetHashCode();
                if (this.FlgSaldocon != null)
                    hashCode = hashCode * 59 + this.FlgSaldocon.GetHashCode();
                if (this.FlgScadereins != null)
                    hashCode = hashCode * 59 + this.FlgScadereins.GetHashCode();
                if (this.FlgScaderenoins != null)
                    hashCode = hashCode * 59 + this.FlgScaderenoins.GetHashCode();
                if (this.FlgScadutoins != null)
                    hashCode = hashCode * 59 + this.FlgScadutoins.GetHashCode();
                if (this.FlgScadutonoins != null)
                    hashCode = hashCode * 59 + this.FlgScadutonoins.GetHashCode();
                if (this.FlgSelclifortrasf != null)
                    hashCode = hashCode * 59 + this.FlgSelclifortrasf.GetHashCode();
                if (this.FlgSolobusinesriskattivo != null)
                    hashCode = hashCode * 59 + this.FlgSolobusinesriskattivo.GetHashCode();
                if (this.IndAttivatrasf != null)
                    hashCode = hashCode * 59 + this.IndAttivatrasf.GetHashCode();
                if (this.IndElabscadinsol != null)
                    hashCode = hashCode * 59 + this.IndElabscadinsol.GetHashCode();
                if (this.IndProvenienzafido != null)
                    hashCode = hashCode * 59 + this.IndProvenienzafido.GetHashCode();
                if (this.IndSegnalazionecorpo != null)
                    hashCode = hashCode * 59 + this.IndSegnalazionecorpo.GetHashCode();
                if (this.Mesiricdocdafatt != null)
                    hashCode = hashCode * 59 + this.Mesiricdocdafatt.GetHashCode();
                if (this.Mesiricordini != null)
                    hashCode = hashCode * 59 + this.Mesiricordini.GetHashCode();
                if (this.Mesiricscadenze != null)
                    hashCode = hashCode * 59 + this.Mesiricscadenze.GetHashCode();
                if (this.AdditionalData != null)
                    hashCode = hashCode * 59 + this.AdditionalData.GetHashCode();
                if (this.PluginData != null)
                    hashCode = hashCode * 59 + this.PluginData.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
