/* 
 * TSE Cloud - MG
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.3000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// KitDocumentResultDTO
    /// </summary>
    [DataContract]
        public partial class KitDocumentResultDTO :  IEquatable<KitDocumentResultDTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="KitDocumentResultDTO" /> class.
        /// </summary>
        /// <param name="numRegLoadProductKit">List of serial numbers created for component unloading documents.</param>
        /// <param name="numRegUnloadComp">List of serial numbers created for kit product loading documents.</param>
        public KitDocumentResultDTO(List<string> numRegLoadProductKit = default(List<string>), List<string> numRegUnloadComp = default(List<string>))
        {
            this.NumRegLoadProductKit = numRegLoadProductKit;
            this.NumRegUnloadComp = numRegUnloadComp;
        }
        
        /// <summary>
        /// List of serial numbers created for component unloading documents
        /// </summary>
        /// <value>List of serial numbers created for component unloading documents</value>
        [DataMember(Name="numRegLoadProductKit", EmitDefaultValue=false)]
        public List<string> NumRegLoadProductKit { get; set; }

        /// <summary>
        /// List of serial numbers created for kit product loading documents
        /// </summary>
        /// <value>List of serial numbers created for kit product loading documents</value>
        [DataMember(Name="numRegUnloadComp", EmitDefaultValue=false)]
        public List<string> NumRegUnloadComp { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class KitDocumentResultDTO {\n");
            sb.Append("  NumRegLoadProductKit: ").Append(NumRegLoadProductKit).Append("\n");
            sb.Append("  NumRegUnloadComp: ").Append(NumRegUnloadComp).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as KitDocumentResultDTO);
        }

        /// <summary>
        /// Returns true if KitDocumentResultDTO instances are equal
        /// </summary>
        /// <param name="input">Instance of KitDocumentResultDTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(KitDocumentResultDTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.NumRegLoadProductKit == input.NumRegLoadProductKit ||
                    this.NumRegLoadProductKit != null &&
                    input.NumRegLoadProductKit != null &&
                    this.NumRegLoadProductKit.SequenceEqual(input.NumRegLoadProductKit)
                ) && 
                (
                    this.NumRegUnloadComp == input.NumRegUnloadComp ||
                    this.NumRegUnloadComp != null &&
                    input.NumRegUnloadComp != null &&
                    this.NumRegUnloadComp.SequenceEqual(input.NumRegUnloadComp)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.NumRegLoadProductKit != null)
                    hashCode = hashCode * 59 + this.NumRegLoadProductKit.GetHashCode();
                if (this.NumRegUnloadComp != null)
                    hashCode = hashCode * 59 + this.NumRegUnloadComp.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
