/* 
 * TSE Cloud - MG
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.3000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// CustomerCreditResultDTO
    /// </summary>
    [DataContract]
        public partial class CustomerCreditResultDTO :  IEquatable<CustomerCreditResultDTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="CustomerCreditResultDTO" /> class.
        /// </summary>
        /// <param name="customerSupplierCode">Customer/Supplier Code.</param>
        /// <param name="customerSupplierType">Customer/Supplier Type.</param>
        /// <param name="customerSupplierName">Customer/Supplier Name.</param>
        /// <param name="isCreditExceeded">If true, the customer is out of credit..</param>
        /// <param name="creditAvailable">Actual credit available for the Customer/Supplier.</param>
        /// <param name="creditTotal">Total credit calculated for the Customer/Supplier.</param>
        /// <param name="creditResidual">Residual credit for the Customer/Supplier.</param>
        public CustomerCreditResultDTO(string customerSupplierCode = default(string), string customerSupplierType = default(string), string customerSupplierName = default(string), bool? isCreditExceeded = default(bool?), double? creditAvailable = default(double?), double? creditTotal = default(double?), double? creditResidual = default(double?))
        {
            this.CustomerSupplierCode = customerSupplierCode;
            this.CustomerSupplierType = customerSupplierType;
            this.CustomerSupplierName = customerSupplierName;
            this.IsCreditExceeded = isCreditExceeded;
            this.CreditAvailable = creditAvailable;
            this.CreditTotal = creditTotal;
            this.CreditResidual = creditResidual;
        }
        
        /// <summary>
        /// Customer/Supplier Code
        /// </summary>
        /// <value>Customer/Supplier Code</value>
        [DataMember(Name="customerSupplierCode", EmitDefaultValue=false)]
        public string CustomerSupplierCode { get; set; }

        /// <summary>
        /// Customer/Supplier Type
        /// </summary>
        /// <value>Customer/Supplier Type</value>
        [DataMember(Name="customerSupplierType", EmitDefaultValue=false)]
        public string CustomerSupplierType { get; set; }

        /// <summary>
        /// Customer/Supplier Name
        /// </summary>
        /// <value>Customer/Supplier Name</value>
        [DataMember(Name="customerSupplierName", EmitDefaultValue=false)]
        public string CustomerSupplierName { get; set; }

        /// <summary>
        /// If true, the customer is out of credit.
        /// </summary>
        /// <value>If true, the customer is out of credit.</value>
        [DataMember(Name="isCreditExceeded", EmitDefaultValue=false)]
        public bool? IsCreditExceeded { get; set; }

        /// <summary>
        /// Actual credit available for the Customer/Supplier
        /// </summary>
        /// <value>Actual credit available for the Customer/Supplier</value>
        [DataMember(Name="creditAvailable", EmitDefaultValue=false)]
        public double? CreditAvailable { get; set; }

        /// <summary>
        /// Total credit calculated for the Customer/Supplier
        /// </summary>
        /// <value>Total credit calculated for the Customer/Supplier</value>
        [DataMember(Name="creditTotal", EmitDefaultValue=false)]
        public double? CreditTotal { get; set; }

        /// <summary>
        /// Residual credit for the Customer/Supplier
        /// </summary>
        /// <value>Residual credit for the Customer/Supplier</value>
        [DataMember(Name="creditResidual", EmitDefaultValue=false)]
        public double? CreditResidual { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class CustomerCreditResultDTO {\n");
            sb.Append("  CustomerSupplierCode: ").Append(CustomerSupplierCode).Append("\n");
            sb.Append("  CustomerSupplierType: ").Append(CustomerSupplierType).Append("\n");
            sb.Append("  CustomerSupplierName: ").Append(CustomerSupplierName).Append("\n");
            sb.Append("  IsCreditExceeded: ").Append(IsCreditExceeded).Append("\n");
            sb.Append("  CreditAvailable: ").Append(CreditAvailable).Append("\n");
            sb.Append("  CreditTotal: ").Append(CreditTotal).Append("\n");
            sb.Append("  CreditResidual: ").Append(CreditResidual).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as CustomerCreditResultDTO);
        }

        /// <summary>
        /// Returns true if CustomerCreditResultDTO instances are equal
        /// </summary>
        /// <param name="input">Instance of CustomerCreditResultDTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(CustomerCreditResultDTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.CustomerSupplierCode == input.CustomerSupplierCode ||
                    (this.CustomerSupplierCode != null &&
                    this.CustomerSupplierCode.Equals(input.CustomerSupplierCode))
                ) && 
                (
                    this.CustomerSupplierType == input.CustomerSupplierType ||
                    (this.CustomerSupplierType != null &&
                    this.CustomerSupplierType.Equals(input.CustomerSupplierType))
                ) && 
                (
                    this.CustomerSupplierName == input.CustomerSupplierName ||
                    (this.CustomerSupplierName != null &&
                    this.CustomerSupplierName.Equals(input.CustomerSupplierName))
                ) && 
                (
                    this.IsCreditExceeded == input.IsCreditExceeded ||
                    (this.IsCreditExceeded != null &&
                    this.IsCreditExceeded.Equals(input.IsCreditExceeded))
                ) && 
                (
                    this.CreditAvailable == input.CreditAvailable ||
                    (this.CreditAvailable != null &&
                    this.CreditAvailable.Equals(input.CreditAvailable))
                ) && 
                (
                    this.CreditTotal == input.CreditTotal ||
                    (this.CreditTotal != null &&
                    this.CreditTotal.Equals(input.CreditTotal))
                ) && 
                (
                    this.CreditResidual == input.CreditResidual ||
                    (this.CreditResidual != null &&
                    this.CreditResidual.Equals(input.CreditResidual))
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.CustomerSupplierCode != null)
                    hashCode = hashCode * 59 + this.CustomerSupplierCode.GetHashCode();
                if (this.CustomerSupplierType != null)
                    hashCode = hashCode * 59 + this.CustomerSupplierType.GetHashCode();
                if (this.CustomerSupplierName != null)
                    hashCode = hashCode * 59 + this.CustomerSupplierName.GetHashCode();
                if (this.IsCreditExceeded != null)
                    hashCode = hashCode * 59 + this.IsCreditExceeded.GetHashCode();
                if (this.CreditAvailable != null)
                    hashCode = hashCode * 59 + this.CreditAvailable.GetHashCode();
                if (this.CreditTotal != null)
                    hashCode = hashCode * 59 + this.CreditTotal.GetHashCode();
                if (this.CreditResidual != null)
                    hashCode = hashCode * 59 + this.CreditResidual.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
