/* 
 * TSE Cloud - MG
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.3000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// MG14_VETTORI - Vettore&lt;br&gt;Proprietà chiave:&lt;ul&gt;&lt;li&gt;&lt;b&gt;Codice&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;
    /// </summary>
    [DataContract]
        public partial class CarrierMGDTO :  IEquatable<CarrierMGDTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="CarrierMGDTO" /> class.
        /// </summary>
        /// <param name="codice">MG14_CODICE - Codice (required).</param>
        /// <param name="codiceCg16">MG14_CODICE_CG16 - Codice anagrafica generale (required).</param>
        /// <param name="flgSchetra">MG14_FLGSCHETRA - Soggetto a stampa scheda di trasporto&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="idmediaCg99">MG14_IDMEDIA_CG99 - ID HyperMedia.</param>
        /// <param name="indPrefstdoc">MG14_INDPREFSTDOC - Stampa pref. documenti&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Stampa&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Fax&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Mail&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - PEC&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Pdf&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Nessuna preferenza&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="nralbotra">MG14_NRALBOTRA - Nr. iscrizione albo autotrasportatori.</param>
        /// <param name="targa">MG14_TARGA - Targa.</param>
        /// <param name="generalMasterDataCO">generalMasterDataCO (required).</param>
        /// <param name="additionalData">additionalData.</param>
        /// <param name="pluginData">pluginData.</param>
        public CarrierMGDTO(string codice = default(string), int? codiceCg16 = default(int?), double? flgSchetra = 0, double? idmediaCg99 = default(double?), double? indPrefstdoc = default(double?), string nralbotra = default(string), string targa = default(string), GeneralMasterDataCODTO generalMasterDataCO = default(GeneralMasterDataCODTO), Dictionary<string, Object> additionalData = default(Dictionary<string, Object>), Dictionary<string, Object> pluginData = default(Dictionary<string, Object>))
        {
            // to ensure "codice" is required (not null)
            if (codice == null)
            {
                throw new InvalidDataException("codice is a required property for CarrierMGDTO and cannot be null");
            }
            else
            {
                this.Codice = codice;
            }
            // to ensure "codiceCg16" is required (not null)
            if (codiceCg16 == null)
            {
                throw new InvalidDataException("codiceCg16 is a required property for CarrierMGDTO and cannot be null");
            }
            else
            {
                this.CodiceCg16 = codiceCg16;
            }
            // to ensure "generalMasterDataCO" is required (not null)
            if (generalMasterDataCO == null)
            {
                throw new InvalidDataException("generalMasterDataCO is a required property for CarrierMGDTO and cannot be null");
            }
            else
            {
                this.GeneralMasterDataCO = generalMasterDataCO;
            }
            // use default value if no "flgSchetra" provided
            if (flgSchetra == null)
            {
                this.FlgSchetra = 0;
            }
            else
            {
                this.FlgSchetra = flgSchetra;
            }
            this.IdmediaCg99 = idmediaCg99;
            this.IndPrefstdoc = indPrefstdoc;
            this.Nralbotra = nralbotra;
            this.Targa = targa;
            this.AdditionalData = additionalData;
            this.PluginData = pluginData;
        }
        
        /// <summary>
        /// MG14_CODICE - Codice
        /// </summary>
        /// <value>MG14_CODICE - Codice</value>
        [DataMember(Name="codice", EmitDefaultValue=false)]
        public string Codice { get; set; }

        /// <summary>
        /// MG14_CODICE_CG16 - Codice anagrafica generale
        /// </summary>
        /// <value>MG14_CODICE_CG16 - Codice anagrafica generale</value>
        [DataMember(Name="codiceCg16", EmitDefaultValue=false)]
        public int? CodiceCg16 { get; set; }

        /// <summary>
        /// MG14_FLGSCHETRA - Soggetto a stampa scheda di trasporto&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG14_FLGSCHETRA - Soggetto a stampa scheda di trasporto&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgSchetra", EmitDefaultValue=false)]
        public double? FlgSchetra { get; set; }

        /// <summary>
        /// MG14_IDMEDIA_CG99 - ID HyperMedia
        /// </summary>
        /// <value>MG14_IDMEDIA_CG99 - ID HyperMedia</value>
        [DataMember(Name="idmediaCg99", EmitDefaultValue=false)]
        public double? IdmediaCg99 { get; set; }

        /// <summary>
        /// MG14_INDPREFSTDOC - Stampa pref. documenti&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Stampa&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Fax&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Mail&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - PEC&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Pdf&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Nessuna preferenza&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG14_INDPREFSTDOC - Stampa pref. documenti&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Stampa&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Fax&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Mail&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - PEC&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Pdf&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Nessuna preferenza&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indPrefstdoc", EmitDefaultValue=false)]
        public double? IndPrefstdoc { get; set; }

        /// <summary>
        /// MG14_NRALBOTRA - Nr. iscrizione albo autotrasportatori
        /// </summary>
        /// <value>MG14_NRALBOTRA - Nr. iscrizione albo autotrasportatori</value>
        [DataMember(Name="nralbotra", EmitDefaultValue=false)]
        public string Nralbotra { get; set; }

        /// <summary>
        /// MG14_TARGA - Targa
        /// </summary>
        /// <value>MG14_TARGA - Targa</value>
        [DataMember(Name="targa", EmitDefaultValue=false)]
        public string Targa { get; set; }

        /// <summary>
        /// Gets or Sets GeneralMasterDataCO
        /// </summary>
        [DataMember(Name="generalMasterDataCO", EmitDefaultValue=false)]
        public GeneralMasterDataCODTO GeneralMasterDataCO { get; set; }

        /// <summary>
        /// Gets or Sets AdditionalData
        /// </summary>
        [DataMember(Name="additionalData", EmitDefaultValue=false)]
        public Dictionary<string, Object> AdditionalData { get; set; }

        /// <summary>
        /// Gets or Sets PluginData
        /// </summary>
        [DataMember(Name="pluginData", EmitDefaultValue=false)]
        public Dictionary<string, Object> PluginData { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class CarrierMGDTO {\n");
            sb.Append("  Codice: ").Append(Codice).Append("\n");
            sb.Append("  CodiceCg16: ").Append(CodiceCg16).Append("\n");
            sb.Append("  FlgSchetra: ").Append(FlgSchetra).Append("\n");
            sb.Append("  IdmediaCg99: ").Append(IdmediaCg99).Append("\n");
            sb.Append("  IndPrefstdoc: ").Append(IndPrefstdoc).Append("\n");
            sb.Append("  Nralbotra: ").Append(Nralbotra).Append("\n");
            sb.Append("  Targa: ").Append(Targa).Append("\n");
            sb.Append("  GeneralMasterDataCO: ").Append(GeneralMasterDataCO).Append("\n");
            sb.Append("  AdditionalData: ").Append(AdditionalData).Append("\n");
            sb.Append("  PluginData: ").Append(PluginData).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as CarrierMGDTO);
        }

        /// <summary>
        /// Returns true if CarrierMGDTO instances are equal
        /// </summary>
        /// <param name="input">Instance of CarrierMGDTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(CarrierMGDTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.Codice == input.Codice ||
                    (this.Codice != null &&
                    this.Codice.Equals(input.Codice))
                ) && 
                (
                    this.CodiceCg16 == input.CodiceCg16 ||
                    (this.CodiceCg16 != null &&
                    this.CodiceCg16.Equals(input.CodiceCg16))
                ) && 
                (
                    this.FlgSchetra == input.FlgSchetra ||
                    (this.FlgSchetra != null &&
                    this.FlgSchetra.Equals(input.FlgSchetra))
                ) && 
                (
                    this.IdmediaCg99 == input.IdmediaCg99 ||
                    (this.IdmediaCg99 != null &&
                    this.IdmediaCg99.Equals(input.IdmediaCg99))
                ) && 
                (
                    this.IndPrefstdoc == input.IndPrefstdoc ||
                    (this.IndPrefstdoc != null &&
                    this.IndPrefstdoc.Equals(input.IndPrefstdoc))
                ) && 
                (
                    this.Nralbotra == input.Nralbotra ||
                    (this.Nralbotra != null &&
                    this.Nralbotra.Equals(input.Nralbotra))
                ) && 
                (
                    this.Targa == input.Targa ||
                    (this.Targa != null &&
                    this.Targa.Equals(input.Targa))
                ) && 
                (
                    this.GeneralMasterDataCO == input.GeneralMasterDataCO ||
                    (this.GeneralMasterDataCO != null &&
                    this.GeneralMasterDataCO.Equals(input.GeneralMasterDataCO))
                ) && 
                (
                    this.AdditionalData == input.AdditionalData ||
                    this.AdditionalData != null &&
                    input.AdditionalData != null &&
                    this.AdditionalData.SequenceEqual(input.AdditionalData)
                ) && 
                (
                    this.PluginData == input.PluginData ||
                    this.PluginData != null &&
                    input.PluginData != null &&
                    this.PluginData.SequenceEqual(input.PluginData)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.Codice != null)
                    hashCode = hashCode * 59 + this.Codice.GetHashCode();
                if (this.CodiceCg16 != null)
                    hashCode = hashCode * 59 + this.CodiceCg16.GetHashCode();
                if (this.FlgSchetra != null)
                    hashCode = hashCode * 59 + this.FlgSchetra.GetHashCode();
                if (this.IdmediaCg99 != null)
                    hashCode = hashCode * 59 + this.IdmediaCg99.GetHashCode();
                if (this.IndPrefstdoc != null)
                    hashCode = hashCode * 59 + this.IndPrefstdoc.GetHashCode();
                if (this.Nralbotra != null)
                    hashCode = hashCode * 59 + this.Nralbotra.GetHashCode();
                if (this.Targa != null)
                    hashCode = hashCode * 59 + this.Targa.GetHashCode();
                if (this.GeneralMasterDataCO != null)
                    hashCode = hashCode * 59 + this.GeneralMasterDataCO.GetHashCode();
                if (this.AdditionalData != null)
                    hashCode = hashCode * 59 + this.AdditionalData.GetHashCode();
                if (this.PluginData != null)
                    hashCode = hashCode * 59 + this.PluginData.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
