/* 
 * TSE Cloud - MG
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.3000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// MG25_LIVBLOCCO - Livelli di blocco&lt;br&gt;Proprietà chiave:&lt;ul&gt;&lt;li&gt;&lt;b&gt;CodBlocco&lt;/b&gt;&lt;/li&gt;&lt;li&gt;&lt;b&gt;DittaCg18&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;
    /// </summary>
    [DataContract]
        public partial class BlockLevelCODTO :  IEquatable<BlockLevelCODTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="BlockLevelCODTO" /> class.
        /// </summary>
        /// <param name="codBlocco">MG25_CODBLOCCO - Codice Blocco (required).</param>
        /// <param name="descrblocco">MG25_DESCRBLOCCO - Descrizione.</param>
        /// <param name="dittaCg18">MG25_DITTA_CG18 - Ditta (default to 0).</param>
        /// <param name="idmediaCg99">MG25_IDMEDIA_CG99 - ID HyperMedia.</param>
        /// <param name="indPayline">MG25_INDPAYLINE - Status Payline&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuno Status Payline&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Status Bloccato Payline&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Status A Legale Payline&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="additionalData">additionalData.</param>
        /// <param name="pluginData">pluginData.</param>
        public BlockLevelCODTO(string codBlocco = default(string), string descrblocco = default(string), double? dittaCg18 = 0, double? idmediaCg99 = default(double?), double? indPayline = default(double?), Dictionary<string, Object> additionalData = default(Dictionary<string, Object>), Dictionary<string, Object> pluginData = default(Dictionary<string, Object>))
        {
            // to ensure "codBlocco" is required (not null)
            if (codBlocco == null)
            {
                throw new InvalidDataException("codBlocco is a required property for BlockLevelCODTO and cannot be null");
            }
            else
            {
                this.CodBlocco = codBlocco;
            }
            this.Descrblocco = descrblocco;
            // use default value if no "dittaCg18" provided
            if (dittaCg18 == null)
            {
                this.DittaCg18 = 0;
            }
            else
            {
                this.DittaCg18 = dittaCg18;
            }
            this.IdmediaCg99 = idmediaCg99;
            this.IndPayline = indPayline;
            this.AdditionalData = additionalData;
            this.PluginData = pluginData;
        }
        
        /// <summary>
        /// MG25_CODBLOCCO - Codice Blocco
        /// </summary>
        /// <value>MG25_CODBLOCCO - Codice Blocco</value>
        [DataMember(Name="codBlocco", EmitDefaultValue=false)]
        public string CodBlocco { get; set; }

        /// <summary>
        /// MG25_DESCRBLOCCO - Descrizione
        /// </summary>
        /// <value>MG25_DESCRBLOCCO - Descrizione</value>
        [DataMember(Name="descrblocco", EmitDefaultValue=false)]
        public string Descrblocco { get; set; }

        /// <summary>
        /// MG25_DITTA_CG18 - Ditta
        /// </summary>
        /// <value>MG25_DITTA_CG18 - Ditta</value>
        [DataMember(Name="dittaCg18", EmitDefaultValue=false)]
        public double? DittaCg18 { get; set; }

        /// <summary>
        /// MG25_IDMEDIA_CG99 - ID HyperMedia
        /// </summary>
        /// <value>MG25_IDMEDIA_CG99 - ID HyperMedia</value>
        [DataMember(Name="idmediaCg99", EmitDefaultValue=false)]
        public double? IdmediaCg99 { get; set; }

        /// <summary>
        /// MG25_INDPAYLINE - Status Payline&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuno Status Payline&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Status Bloccato Payline&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Status A Legale Payline&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG25_INDPAYLINE - Status Payline&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuno Status Payline&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Status Bloccato Payline&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Status A Legale Payline&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indPayline", EmitDefaultValue=false)]
        public double? IndPayline { get; set; }

        /// <summary>
        /// Gets or Sets AdditionalData
        /// </summary>
        [DataMember(Name="additionalData", EmitDefaultValue=false)]
        public Dictionary<string, Object> AdditionalData { get; set; }

        /// <summary>
        /// Gets or Sets PluginData
        /// </summary>
        [DataMember(Name="pluginData", EmitDefaultValue=false)]
        public Dictionary<string, Object> PluginData { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class BlockLevelCODTO {\n");
            sb.Append("  CodBlocco: ").Append(CodBlocco).Append("\n");
            sb.Append("  Descrblocco: ").Append(Descrblocco).Append("\n");
            sb.Append("  DittaCg18: ").Append(DittaCg18).Append("\n");
            sb.Append("  IdmediaCg99: ").Append(IdmediaCg99).Append("\n");
            sb.Append("  IndPayline: ").Append(IndPayline).Append("\n");
            sb.Append("  AdditionalData: ").Append(AdditionalData).Append("\n");
            sb.Append("  PluginData: ").Append(PluginData).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as BlockLevelCODTO);
        }

        /// <summary>
        /// Returns true if BlockLevelCODTO instances are equal
        /// </summary>
        /// <param name="input">Instance of BlockLevelCODTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(BlockLevelCODTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.CodBlocco == input.CodBlocco ||
                    (this.CodBlocco != null &&
                    this.CodBlocco.Equals(input.CodBlocco))
                ) && 
                (
                    this.Descrblocco == input.Descrblocco ||
                    (this.Descrblocco != null &&
                    this.Descrblocco.Equals(input.Descrblocco))
                ) && 
                (
                    this.DittaCg18 == input.DittaCg18 ||
                    (this.DittaCg18 != null &&
                    this.DittaCg18.Equals(input.DittaCg18))
                ) && 
                (
                    this.IdmediaCg99 == input.IdmediaCg99 ||
                    (this.IdmediaCg99 != null &&
                    this.IdmediaCg99.Equals(input.IdmediaCg99))
                ) && 
                (
                    this.IndPayline == input.IndPayline ||
                    (this.IndPayline != null &&
                    this.IndPayline.Equals(input.IndPayline))
                ) && 
                (
                    this.AdditionalData == input.AdditionalData ||
                    this.AdditionalData != null &&
                    input.AdditionalData != null &&
                    this.AdditionalData.SequenceEqual(input.AdditionalData)
                ) && 
                (
                    this.PluginData == input.PluginData ||
                    this.PluginData != null &&
                    input.PluginData != null &&
                    this.PluginData.SequenceEqual(input.PluginData)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.CodBlocco != null)
                    hashCode = hashCode * 59 + this.CodBlocco.GetHashCode();
                if (this.Descrblocco != null)
                    hashCode = hashCode * 59 + this.Descrblocco.GetHashCode();
                if (this.DittaCg18 != null)
                    hashCode = hashCode * 59 + this.DittaCg18.GetHashCode();
                if (this.IdmediaCg99 != null)
                    hashCode = hashCode * 59 + this.IdmediaCg99.GetHashCode();
                if (this.IndPayline != null)
                    hashCode = hashCode * 59 + this.IndPayline.GetHashCode();
                if (this.AdditionalData != null)
                    hashCode = hashCode * 59 + this.AdditionalData.GetHashCode();
                if (this.PluginData != null)
                    hashCode = hashCode * 59 + this.PluginData.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
