/* 
 * TSE Cloud - MG
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.3000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using RestSharp;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace IO.Swagger.Api
{
    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
        public interface IDocumentServiceApi : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// Return Document processing status
        /// </summary>
        /// <remarks>
        /// Document processing status
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Search criteria to apply</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="loadEntireDomain">Specify &#x27;loadEntireDomain&#x3D;true&#x27; if you want all the aggregate (optional)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="getTotalCount">Specify &#x27;gettotalcount&#x3D;true&#x27; if you want the total number of elements (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>DocumentoStatoEvasoMGDTO</returns>
        DocumentoStatoEvasoMGDTO ApiV1EnvironmentMGDocumentServiceDocprocessingstatusPost (SearchDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? loadEntireDomain = null, bool? ignoreCompanyPolicyFilter = null, bool? getTotalCount = null, string company = null, string user = null);

        /// <summary>
        /// Return Document processing status
        /// </summary>
        /// <remarks>
        /// Document processing status
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Search criteria to apply</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="loadEntireDomain">Specify &#x27;loadEntireDomain&#x3D;true&#x27; if you want all the aggregate (optional)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="getTotalCount">Specify &#x27;gettotalcount&#x3D;true&#x27; if you want the total number of elements (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of DocumentoStatoEvasoMGDTO</returns>
        ApiResponse<DocumentoStatoEvasoMGDTO> ApiV1EnvironmentMGDocumentServiceDocprocessingstatusPostWithHttpInfo (SearchDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? loadEntireDomain = null, bool? ignoreCompanyPolicyFilter = null, bool? getTotalCount = null, string company = null, string user = null);
        /// <summary>
        /// Insert Multiple Documents for async process
        /// </summary>
        /// <remarks>
        /// Document async multiple process
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="withvalidpreconditions">Validate Preconditions (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>DocumentoTestataOutMGDTO</returns>
        DocumentoTestataOutMGDTO ApiV1EnvironmentMGDocumentServiceMultiplecreatePost (List<GroupDocumentoTestataMGDTO> body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, bool? withvalidpreconditions = null, string company = null, string user = null);

        /// <summary>
        /// Insert Multiple Documents for async process
        /// </summary>
        /// <remarks>
        /// Document async multiple process
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="withvalidpreconditions">Validate Preconditions (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of DocumentoTestataOutMGDTO</returns>
        ApiResponse<DocumentoTestataOutMGDTO> ApiV1EnvironmentMGDocumentServiceMultiplecreatePostWithHttpInfo (List<GroupDocumentoTestataMGDTO> body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, bool? withvalidpreconditions = null, string company = null, string user = null);
        /// <summary>
        /// Delete records for multiple insert documents by guid
        /// </summary>
        /// <remarks>
        /// Deleting object of type 
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="progress">Force values (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns></returns>
        void ApiV1EnvironmentMGDocumentServiceMultiplecreatehistoryIdDelete (string id, string environment, string authorizationScope, string progress = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null);

        /// <summary>
        /// Delete records for multiple insert documents by guid
        /// </summary>
        /// <remarks>
        /// Deleting object of type 
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="progress">Force values (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> ApiV1EnvironmentMGDocumentServiceMultiplecreatehistoryIdDeleteWithHttpInfo (string id, string environment, string authorizationScope, string progress = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null);
        /// <summary>
        /// Multiple Documents reprocess operations for async insert by guid
        /// </summary>
        /// <remarks>
        /// Document async multiple reprocess
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="guid">That&#x27;s Guid Session MixMatch documents insert value</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="withvalidpreconditions">Validate Preconditions (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>DocumentoTestataOutMGDTO</returns>
        DocumentoTestataOutMGDTO ApiV1EnvironmentMGDocumentServiceMultiplecreatereprocessGuidPost (List<GroupDocumentoTestataMGDTO> body, string authorizationScope, string guid, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, bool? withvalidpreconditions = null, string company = null, string user = null);

        /// <summary>
        /// Multiple Documents reprocess operations for async insert by guid
        /// </summary>
        /// <remarks>
        /// Document async multiple reprocess
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="guid">That&#x27;s Guid Session MixMatch documents insert value</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="withvalidpreconditions">Validate Preconditions (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of DocumentoTestataOutMGDTO</returns>
        ApiResponse<DocumentoTestataOutMGDTO> ApiV1EnvironmentMGDocumentServiceMultiplecreatereprocessGuidPostWithHttpInfo (List<GroupDocumentoTestataMGDTO> body, string authorizationScope, string guid, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, bool? withvalidpreconditions = null, string company = null, string user = null);
        /// <summary>
        /// Delete record for async process portfolio orders
        /// </summary>
        /// <remarks>
        /// Deleting object of type 
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns></returns>
        void ApiV1EnvironmentMGDocumentServiceOrderavailabilityIdDelete (string id, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null);

        /// <summary>
        /// Delete record for async process portfolio orders
        /// </summary>
        /// <remarks>
        /// Deleting object of type 
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> ApiV1EnvironmentMGDocumentServiceOrderavailabilityIdDeleteWithHttpInfo (string id, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null);
        /// <summary>
        /// Return Documents Order Portfolio
        /// </summary>
        /// <remarks>
        /// Document processing status
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>DocumentoPortfolioEvadOrdineOutMGSetDTO</returns>
        DocumentoPortfolioEvadOrdineOutMGSetDTO ApiV1EnvironmentMGDocumentServiceOrderavailabilityPost (DocumentoPortfolioEvadInMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, string company = null, string user = null);

        /// <summary>
        /// Return Documents Order Portfolio
        /// </summary>
        /// <remarks>
        /// Document processing status
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of DocumentoPortfolioEvadOrdineOutMGSetDTO</returns>
        ApiResponse<DocumentoPortfolioEvadOrdineOutMGSetDTO> ApiV1EnvironmentMGDocumentServiceOrderavailabilityPostWithHttpInfo (DocumentoPortfolioEvadInMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, string company = null, string user = null);
        /// <summary>
        /// Document transformation based on the required parameters
        /// </summary>
        /// <remarks>
        /// Document transformation based on the required parameters
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Document transformation parameters</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>DocumentTransformationParameterDTO</returns>
        DocumentTransformationParameterDTO ApiV1EnvironmentMGDocumentServiceTransformPost (DocumentTransformationParameterDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, string company = null, string user = null);

        /// <summary>
        /// Document transformation based on the required parameters
        /// </summary>
        /// <remarks>
        /// Document transformation based on the required parameters
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Document transformation parameters</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of DocumentTransformationParameterDTO</returns>
        ApiResponse<DocumentTransformationParameterDTO> ApiV1EnvironmentMGDocumentServiceTransformPostWithHttpInfo (DocumentTransformationParameterDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, string company = null, string user = null);
        #endregion Synchronous Operations
        #region Asynchronous Operations
        /// <summary>
        /// Return Document processing status
        /// </summary>
        /// <remarks>
        /// Document processing status
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Search criteria to apply</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="loadEntireDomain">Specify &#x27;loadEntireDomain&#x3D;true&#x27; if you want all the aggregate (optional)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="getTotalCount">Specify &#x27;gettotalcount&#x3D;true&#x27; if you want the total number of elements (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of DocumentoStatoEvasoMGDTO</returns>
        System.Threading.Tasks.Task<DocumentoStatoEvasoMGDTO> ApiV1EnvironmentMGDocumentServiceDocprocessingstatusPostAsync (SearchDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? loadEntireDomain = null, bool? ignoreCompanyPolicyFilter = null, bool? getTotalCount = null, string company = null, string user = null);

        /// <summary>
        /// Return Document processing status
        /// </summary>
        /// <remarks>
        /// Document processing status
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Search criteria to apply</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="loadEntireDomain">Specify &#x27;loadEntireDomain&#x3D;true&#x27; if you want all the aggregate (optional)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="getTotalCount">Specify &#x27;gettotalcount&#x3D;true&#x27; if you want the total number of elements (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (DocumentoStatoEvasoMGDTO)</returns>
        System.Threading.Tasks.Task<ApiResponse<DocumentoStatoEvasoMGDTO>> ApiV1EnvironmentMGDocumentServiceDocprocessingstatusPostAsyncWithHttpInfo (SearchDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? loadEntireDomain = null, bool? ignoreCompanyPolicyFilter = null, bool? getTotalCount = null, string company = null, string user = null);
        /// <summary>
        /// Insert Multiple Documents for async process
        /// </summary>
        /// <remarks>
        /// Document async multiple process
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="withvalidpreconditions">Validate Preconditions (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of DocumentoTestataOutMGDTO</returns>
        System.Threading.Tasks.Task<DocumentoTestataOutMGDTO> ApiV1EnvironmentMGDocumentServiceMultiplecreatePostAsync (List<GroupDocumentoTestataMGDTO> body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, bool? withvalidpreconditions = null, string company = null, string user = null);

        /// <summary>
        /// Insert Multiple Documents for async process
        /// </summary>
        /// <remarks>
        /// Document async multiple process
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="withvalidpreconditions">Validate Preconditions (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (DocumentoTestataOutMGDTO)</returns>
        System.Threading.Tasks.Task<ApiResponse<DocumentoTestataOutMGDTO>> ApiV1EnvironmentMGDocumentServiceMultiplecreatePostAsyncWithHttpInfo (List<GroupDocumentoTestataMGDTO> body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, bool? withvalidpreconditions = null, string company = null, string user = null);
        /// <summary>
        /// Delete records for multiple insert documents by guid
        /// </summary>
        /// <remarks>
        /// Deleting object of type 
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="progress">Force values (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task ApiV1EnvironmentMGDocumentServiceMultiplecreatehistoryIdDeleteAsync (string id, string environment, string authorizationScope, string progress = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null);

        /// <summary>
        /// Delete records for multiple insert documents by guid
        /// </summary>
        /// <remarks>
        /// Deleting object of type 
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="progress">Force values (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentMGDocumentServiceMultiplecreatehistoryIdDeleteAsyncWithHttpInfo (string id, string environment, string authorizationScope, string progress = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null);
        /// <summary>
        /// Multiple Documents reprocess operations for async insert by guid
        /// </summary>
        /// <remarks>
        /// Document async multiple reprocess
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="guid">That&#x27;s Guid Session MixMatch documents insert value</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="withvalidpreconditions">Validate Preconditions (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of DocumentoTestataOutMGDTO</returns>
        System.Threading.Tasks.Task<DocumentoTestataOutMGDTO> ApiV1EnvironmentMGDocumentServiceMultiplecreatereprocessGuidPostAsync (List<GroupDocumentoTestataMGDTO> body, string authorizationScope, string guid, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, bool? withvalidpreconditions = null, string company = null, string user = null);

        /// <summary>
        /// Multiple Documents reprocess operations for async insert by guid
        /// </summary>
        /// <remarks>
        /// Document async multiple reprocess
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="guid">That&#x27;s Guid Session MixMatch documents insert value</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="withvalidpreconditions">Validate Preconditions (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (DocumentoTestataOutMGDTO)</returns>
        System.Threading.Tasks.Task<ApiResponse<DocumentoTestataOutMGDTO>> ApiV1EnvironmentMGDocumentServiceMultiplecreatereprocessGuidPostAsyncWithHttpInfo (List<GroupDocumentoTestataMGDTO> body, string authorizationScope, string guid, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, bool? withvalidpreconditions = null, string company = null, string user = null);
        /// <summary>
        /// Delete record for async process portfolio orders
        /// </summary>
        /// <remarks>
        /// Deleting object of type 
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task ApiV1EnvironmentMGDocumentServiceOrderavailabilityIdDeleteAsync (string id, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null);

        /// <summary>
        /// Delete record for async process portfolio orders
        /// </summary>
        /// <remarks>
        /// Deleting object of type 
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentMGDocumentServiceOrderavailabilityIdDeleteAsyncWithHttpInfo (string id, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null);
        /// <summary>
        /// Return Documents Order Portfolio
        /// </summary>
        /// <remarks>
        /// Document processing status
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of DocumentoPortfolioEvadOrdineOutMGSetDTO</returns>
        System.Threading.Tasks.Task<DocumentoPortfolioEvadOrdineOutMGSetDTO> ApiV1EnvironmentMGDocumentServiceOrderavailabilityPostAsync (DocumentoPortfolioEvadInMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, string company = null, string user = null);

        /// <summary>
        /// Return Documents Order Portfolio
        /// </summary>
        /// <remarks>
        /// Document processing status
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (DocumentoPortfolioEvadOrdineOutMGSetDTO)</returns>
        System.Threading.Tasks.Task<ApiResponse<DocumentoPortfolioEvadOrdineOutMGSetDTO>> ApiV1EnvironmentMGDocumentServiceOrderavailabilityPostAsyncWithHttpInfo (DocumentoPortfolioEvadInMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, string company = null, string user = null);
        /// <summary>
        /// Document transformation based on the required parameters
        /// </summary>
        /// <remarks>
        /// Document transformation based on the required parameters
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Document transformation parameters</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of DocumentTransformationParameterDTO</returns>
        System.Threading.Tasks.Task<DocumentTransformationParameterDTO> ApiV1EnvironmentMGDocumentServiceTransformPostAsync (DocumentTransformationParameterDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, string company = null, string user = null);

        /// <summary>
        /// Document transformation based on the required parameters
        /// </summary>
        /// <remarks>
        /// Document transformation based on the required parameters
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Document transformation parameters</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (DocumentTransformationParameterDTO)</returns>
        System.Threading.Tasks.Task<ApiResponse<DocumentTransformationParameterDTO>> ApiV1EnvironmentMGDocumentServiceTransformPostAsyncWithHttpInfo (DocumentTransformationParameterDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, string company = null, string user = null);
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
        public partial class DocumentServiceApi : IDocumentServiceApi
    {
        private IO.Swagger.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="DocumentServiceApi"/> class.
        /// </summary>
        /// <returns></returns>
        public DocumentServiceApi(String basePath)
        {
            this.Configuration = new IO.Swagger.Client.Configuration { BasePath = basePath };

            ExceptionFactory = IO.Swagger.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="DocumentServiceApi"/> class
        /// </summary>
        /// <returns></returns>
        public DocumentServiceApi()
        {
            this.Configuration = IO.Swagger.Client.Configuration.Default;

            ExceptionFactory = IO.Swagger.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="DocumentServiceApi"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public DocumentServiceApi(IO.Swagger.Client.Configuration configuration = null)
        {
            if (configuration == null) // use the default one in Configuration
                this.Configuration = IO.Swagger.Client.Configuration.Default;
            else
                this.Configuration = configuration;

            ExceptionFactory = IO.Swagger.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public String GetBasePath()
        {
            return this.Configuration.ApiClient.RestClient.Options.BaseUrl.ToString();
        }

        /// <summary>
        /// Sets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        [Obsolete("SetBasePath is deprecated, please do 'Configuration.ApiClient = new ApiClient(\"http://new-path\")' instead.")]
        public void SetBasePath(String basePath)
        {
            // do nothing
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public IO.Swagger.Client.Configuration Configuration {get; set;}

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public IO.Swagger.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// Gets the default header.
        /// </summary>
        /// <returns>Dictionary of HTTP header</returns>
        [Obsolete("DefaultHeader is deprecated, please use Configuration.DefaultHeader instead.")]
        public IDictionary<String, String> DefaultHeader()
        {
            return new ReadOnlyDictionary<string, string>(this.Configuration.DefaultHeader);
        }

        /// <summary>
        /// Add default header.
        /// </summary>
        /// <param name="key">Header field name.</param>
        /// <param name="value">Header field value.</param>
        /// <returns></returns>
        [Obsolete("AddDefaultHeader is deprecated, please use Configuration.AddDefaultHeader instead.")]
        public void AddDefaultHeader(string key, string value)
        {
            this.Configuration.AddDefaultHeader(key, value);
        }

        /// <summary>
        /// Return Document processing status Document processing status
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Search criteria to apply</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="loadEntireDomain">Specify &#x27;loadEntireDomain&#x3D;true&#x27; if you want all the aggregate (optional)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="getTotalCount">Specify &#x27;gettotalcount&#x3D;true&#x27; if you want the total number of elements (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>DocumentoStatoEvasoMGDTO</returns>
        public DocumentoStatoEvasoMGDTO ApiV1EnvironmentMGDocumentServiceDocprocessingstatusPost (SearchDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? loadEntireDomain = null, bool? ignoreCompanyPolicyFilter = null, bool? getTotalCount = null, string company = null, string user = null)
        {
             ApiResponse<DocumentoStatoEvasoMGDTO> localVarResponse = ApiV1EnvironmentMGDocumentServiceDocprocessingstatusPostWithHttpInfo(body, authorizationScope, environment, acceptLanguage, acceptTerritory, loadEntireDomain, ignoreCompanyPolicyFilter, getTotalCount, company, user);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Return Document processing status Document processing status
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Search criteria to apply</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="loadEntireDomain">Specify &#x27;loadEntireDomain&#x3D;true&#x27; if you want all the aggregate (optional)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="getTotalCount">Specify &#x27;gettotalcount&#x3D;true&#x27; if you want the total number of elements (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of DocumentoStatoEvasoMGDTO</returns>
        public ApiResponse< DocumentoStatoEvasoMGDTO > ApiV1EnvironmentMGDocumentServiceDocprocessingstatusPostWithHttpInfo (SearchDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? loadEntireDomain = null, bool? ignoreCompanyPolicyFilter = null, bool? getTotalCount = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceDocprocessingstatusPost");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceDocprocessingstatusPost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceDocprocessingstatusPost");

            var localVarPath = "/api/v1/{environment}/MG/DocumentService/docprocessingstatus";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (loadEntireDomain != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "loadEntireDomain", loadEntireDomain)); // query parameter
            if (ignoreCompanyPolicyFilter != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "ignoreCompanyPolicyFilter", ignoreCompanyPolicyFilter)); // query parameter
            if (getTotalCount != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "getTotalCount", getTotalCount)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGDocumentServiceDocprocessingstatusPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<DocumentoStatoEvasoMGDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (DocumentoStatoEvasoMGDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(DocumentoStatoEvasoMGDTO)));
        }

        /// <summary>
        /// Return Document processing status Document processing status
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Search criteria to apply</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="loadEntireDomain">Specify &#x27;loadEntireDomain&#x3D;true&#x27; if you want all the aggregate (optional)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="getTotalCount">Specify &#x27;gettotalcount&#x3D;true&#x27; if you want the total number of elements (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of DocumentoStatoEvasoMGDTO</returns>
        public async System.Threading.Tasks.Task<DocumentoStatoEvasoMGDTO> ApiV1EnvironmentMGDocumentServiceDocprocessingstatusPostAsync (SearchDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? loadEntireDomain = null, bool? ignoreCompanyPolicyFilter = null, bool? getTotalCount = null, string company = null, string user = null)
        {
             ApiResponse<DocumentoStatoEvasoMGDTO> localVarResponse = await ApiV1EnvironmentMGDocumentServiceDocprocessingstatusPostAsyncWithHttpInfo(body, authorizationScope, environment, acceptLanguage, acceptTerritory, loadEntireDomain, ignoreCompanyPolicyFilter, getTotalCount, company, user);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Return Document processing status Document processing status
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Search criteria to apply</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="loadEntireDomain">Specify &#x27;loadEntireDomain&#x3D;true&#x27; if you want all the aggregate (optional)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="getTotalCount">Specify &#x27;gettotalcount&#x3D;true&#x27; if you want the total number of elements (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (DocumentoStatoEvasoMGDTO)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<DocumentoStatoEvasoMGDTO>> ApiV1EnvironmentMGDocumentServiceDocprocessingstatusPostAsyncWithHttpInfo (SearchDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? loadEntireDomain = null, bool? ignoreCompanyPolicyFilter = null, bool? getTotalCount = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceDocprocessingstatusPost");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceDocprocessingstatusPost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceDocprocessingstatusPost");

            var localVarPath = "/api/v1/{environment}/MG/DocumentService/docprocessingstatus";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (loadEntireDomain != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "loadEntireDomain", loadEntireDomain)); // query parameter
            if (ignoreCompanyPolicyFilter != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "ignoreCompanyPolicyFilter", ignoreCompanyPolicyFilter)); // query parameter
            if (getTotalCount != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "getTotalCount", getTotalCount)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGDocumentServiceDocprocessingstatusPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<DocumentoStatoEvasoMGDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (DocumentoStatoEvasoMGDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(DocumentoStatoEvasoMGDTO)));
        }

        /// <summary>
        /// Insert Multiple Documents for async process Document async multiple process
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="withvalidpreconditions">Validate Preconditions (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>DocumentoTestataOutMGDTO</returns>
        public DocumentoTestataOutMGDTO ApiV1EnvironmentMGDocumentServiceMultiplecreatePost (List<GroupDocumentoTestataMGDTO> body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, bool? withvalidpreconditions = null, string company = null, string user = null)
        {
             ApiResponse<DocumentoTestataOutMGDTO> localVarResponse = ApiV1EnvironmentMGDocumentServiceMultiplecreatePostWithHttpInfo(body, authorizationScope, environment, acceptLanguage, acceptTerritory, force, withvalidpreconditions, company, user);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Insert Multiple Documents for async process Document async multiple process
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="withvalidpreconditions">Validate Preconditions (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of DocumentoTestataOutMGDTO</returns>
        public ApiResponse< DocumentoTestataOutMGDTO > ApiV1EnvironmentMGDocumentServiceMultiplecreatePostWithHttpInfo (List<GroupDocumentoTestataMGDTO> body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, bool? withvalidpreconditions = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceMultiplecreatePost");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceMultiplecreatePost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceMultiplecreatePost");

            var localVarPath = "/api/v1/{environment}/MG/DocumentService/multiplecreate";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (withvalidpreconditions != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "withvalidpreconditions", withvalidpreconditions)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGDocumentServiceMultiplecreatePost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<DocumentoTestataOutMGDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (DocumentoTestataOutMGDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(DocumentoTestataOutMGDTO)));
        }

        /// <summary>
        /// Insert Multiple Documents for async process Document async multiple process
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="withvalidpreconditions">Validate Preconditions (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of DocumentoTestataOutMGDTO</returns>
        public async System.Threading.Tasks.Task<DocumentoTestataOutMGDTO> ApiV1EnvironmentMGDocumentServiceMultiplecreatePostAsync (List<GroupDocumentoTestataMGDTO> body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, bool? withvalidpreconditions = null, string company = null, string user = null)
        {
             ApiResponse<DocumentoTestataOutMGDTO> localVarResponse = await ApiV1EnvironmentMGDocumentServiceMultiplecreatePostAsyncWithHttpInfo(body, authorizationScope, environment, acceptLanguage, acceptTerritory, force, withvalidpreconditions, company, user);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Insert Multiple Documents for async process Document async multiple process
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="withvalidpreconditions">Validate Preconditions (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (DocumentoTestataOutMGDTO)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<DocumentoTestataOutMGDTO>> ApiV1EnvironmentMGDocumentServiceMultiplecreatePostAsyncWithHttpInfo (List<GroupDocumentoTestataMGDTO> body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, bool? withvalidpreconditions = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceMultiplecreatePost");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceMultiplecreatePost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceMultiplecreatePost");

            var localVarPath = "/api/v1/{environment}/MG/DocumentService/multiplecreate";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (withvalidpreconditions != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "withvalidpreconditions", withvalidpreconditions)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGDocumentServiceMultiplecreatePost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<DocumentoTestataOutMGDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (DocumentoTestataOutMGDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(DocumentoTestataOutMGDTO)));
        }

        /// <summary>
        /// Delete records for multiple insert documents by guid Deleting object of type 
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="progress">Force values (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns></returns>
        public void ApiV1EnvironmentMGDocumentServiceMultiplecreatehistoryIdDelete (string id, string environment, string authorizationScope, string progress = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)
        {
             ApiV1EnvironmentMGDocumentServiceMultiplecreatehistoryIdDeleteWithHttpInfo(id, environment, authorizationScope, progress, company, user, acceptLanguage, acceptTerritory);
        }

        /// <summary>
        /// Delete records for multiple insert documents by guid Deleting object of type 
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="progress">Force values (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public ApiResponse<Object> ApiV1EnvironmentMGDocumentServiceMultiplecreatehistoryIdDeleteWithHttpInfo (string id, string environment, string authorizationScope, string progress = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)
        {
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceMultiplecreatehistoryIdDelete");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceMultiplecreatehistoryIdDelete");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceMultiplecreatehistoryIdDelete");

            var localVarPath = "/api/v1/{environment}/MG/DocumentService/multiplecreatehistory/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (progress != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "progress", progress)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Delete, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGDocumentServiceMultiplecreatehistoryIdDelete", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Delete records for multiple insert documents by guid Deleting object of type 
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="progress">Force values (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task ApiV1EnvironmentMGDocumentServiceMultiplecreatehistoryIdDeleteAsync (string id, string environment, string authorizationScope, string progress = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)
        {
             await ApiV1EnvironmentMGDocumentServiceMultiplecreatehistoryIdDeleteAsyncWithHttpInfo(id, environment, authorizationScope, progress, company, user, acceptLanguage, acceptTerritory);

        }

        /// <summary>
        /// Delete records for multiple insert documents by guid Deleting object of type 
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="progress">Force values (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentMGDocumentServiceMultiplecreatehistoryIdDeleteAsyncWithHttpInfo (string id, string environment, string authorizationScope, string progress = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)
        {
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceMultiplecreatehistoryIdDelete");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceMultiplecreatehistoryIdDelete");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceMultiplecreatehistoryIdDelete");

            var localVarPath = "/api/v1/{environment}/MG/DocumentService/multiplecreatehistory/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (progress != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "progress", progress)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Delete, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGDocumentServiceMultiplecreatehistoryIdDelete", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Multiple Documents reprocess operations for async insert by guid Document async multiple reprocess
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="guid">That&#x27;s Guid Session MixMatch documents insert value</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="withvalidpreconditions">Validate Preconditions (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>DocumentoTestataOutMGDTO</returns>
        public DocumentoTestataOutMGDTO ApiV1EnvironmentMGDocumentServiceMultiplecreatereprocessGuidPost (List<GroupDocumentoTestataMGDTO> body, string authorizationScope, string guid, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, bool? withvalidpreconditions = null, string company = null, string user = null)
        {
             ApiResponse<DocumentoTestataOutMGDTO> localVarResponse = ApiV1EnvironmentMGDocumentServiceMultiplecreatereprocessGuidPostWithHttpInfo(body, authorizationScope, guid, environment, acceptLanguage, acceptTerritory, force, withvalidpreconditions, company, user);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Multiple Documents reprocess operations for async insert by guid Document async multiple reprocess
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="guid">That&#x27;s Guid Session MixMatch documents insert value</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="withvalidpreconditions">Validate Preconditions (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of DocumentoTestataOutMGDTO</returns>
        public ApiResponse< DocumentoTestataOutMGDTO > ApiV1EnvironmentMGDocumentServiceMultiplecreatereprocessGuidPostWithHttpInfo (List<GroupDocumentoTestataMGDTO> body, string authorizationScope, string guid, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, bool? withvalidpreconditions = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceMultiplecreatereprocessGuidPost");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceMultiplecreatereprocessGuidPost");
            // verify the required parameter 'guid' is set
            if (guid == null)
                throw new ApiException(400, "Missing required parameter 'guid' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceMultiplecreatereprocessGuidPost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceMultiplecreatereprocessGuidPost");

            var localVarPath = "/api/v1/{environment}/MG/DocumentService/multiplecreatereprocess/{guid}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (guid != null) localVarPathParams.Add("guid", this.Configuration.ApiClient.ParameterToString(guid)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (withvalidpreconditions != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "withvalidpreconditions", withvalidpreconditions)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGDocumentServiceMultiplecreatereprocessGuidPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<DocumentoTestataOutMGDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (DocumentoTestataOutMGDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(DocumentoTestataOutMGDTO)));
        }

        /// <summary>
        /// Multiple Documents reprocess operations for async insert by guid Document async multiple reprocess
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="guid">That&#x27;s Guid Session MixMatch documents insert value</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="withvalidpreconditions">Validate Preconditions (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of DocumentoTestataOutMGDTO</returns>
        public async System.Threading.Tasks.Task<DocumentoTestataOutMGDTO> ApiV1EnvironmentMGDocumentServiceMultiplecreatereprocessGuidPostAsync (List<GroupDocumentoTestataMGDTO> body, string authorizationScope, string guid, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, bool? withvalidpreconditions = null, string company = null, string user = null)
        {
             ApiResponse<DocumentoTestataOutMGDTO> localVarResponse = await ApiV1EnvironmentMGDocumentServiceMultiplecreatereprocessGuidPostAsyncWithHttpInfo(body, authorizationScope, guid, environment, acceptLanguage, acceptTerritory, force, withvalidpreconditions, company, user);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Multiple Documents reprocess operations for async insert by guid Document async multiple reprocess
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="guid">That&#x27;s Guid Session MixMatch documents insert value</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="withvalidpreconditions">Validate Preconditions (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (DocumentoTestataOutMGDTO)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<DocumentoTestataOutMGDTO>> ApiV1EnvironmentMGDocumentServiceMultiplecreatereprocessGuidPostAsyncWithHttpInfo (List<GroupDocumentoTestataMGDTO> body, string authorizationScope, string guid, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, bool? withvalidpreconditions = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceMultiplecreatereprocessGuidPost");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceMultiplecreatereprocessGuidPost");
            // verify the required parameter 'guid' is set
            if (guid == null)
                throw new ApiException(400, "Missing required parameter 'guid' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceMultiplecreatereprocessGuidPost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceMultiplecreatereprocessGuidPost");

            var localVarPath = "/api/v1/{environment}/MG/DocumentService/multiplecreatereprocess/{guid}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (guid != null) localVarPathParams.Add("guid", this.Configuration.ApiClient.ParameterToString(guid)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (withvalidpreconditions != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "withvalidpreconditions", withvalidpreconditions)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGDocumentServiceMultiplecreatereprocessGuidPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<DocumentoTestataOutMGDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (DocumentoTestataOutMGDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(DocumentoTestataOutMGDTO)));
        }

        /// <summary>
        /// Delete record for async process portfolio orders Deleting object of type 
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns></returns>
        public void ApiV1EnvironmentMGDocumentServiceOrderavailabilityIdDelete (string id, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)
        {
             ApiV1EnvironmentMGDocumentServiceOrderavailabilityIdDeleteWithHttpInfo(id, environment, authorizationScope, company, user, acceptLanguage, acceptTerritory);
        }

        /// <summary>
        /// Delete record for async process portfolio orders Deleting object of type 
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public ApiResponse<Object> ApiV1EnvironmentMGDocumentServiceOrderavailabilityIdDeleteWithHttpInfo (string id, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)
        {
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceOrderavailabilityIdDelete");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceOrderavailabilityIdDelete");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceOrderavailabilityIdDelete");

            var localVarPath = "/api/v1/{environment}/MG/DocumentService/orderavailability/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Delete, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGDocumentServiceOrderavailabilityIdDelete", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Delete record for async process portfolio orders Deleting object of type 
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task ApiV1EnvironmentMGDocumentServiceOrderavailabilityIdDeleteAsync (string id, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)
        {
             await ApiV1EnvironmentMGDocumentServiceOrderavailabilityIdDeleteAsyncWithHttpInfo(id, environment, authorizationScope, company, user, acceptLanguage, acceptTerritory);

        }

        /// <summary>
        /// Delete record for async process portfolio orders Deleting object of type 
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentMGDocumentServiceOrderavailabilityIdDeleteAsyncWithHttpInfo (string id, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)
        {
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceOrderavailabilityIdDelete");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceOrderavailabilityIdDelete");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceOrderavailabilityIdDelete");

            var localVarPath = "/api/v1/{environment}/MG/DocumentService/orderavailability/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Delete, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGDocumentServiceOrderavailabilityIdDelete", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Return Documents Order Portfolio Document processing status
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>DocumentoPortfolioEvadOrdineOutMGSetDTO</returns>
        public DocumentoPortfolioEvadOrdineOutMGSetDTO ApiV1EnvironmentMGDocumentServiceOrderavailabilityPost (DocumentoPortfolioEvadInMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, string company = null, string user = null)
        {
             ApiResponse<DocumentoPortfolioEvadOrdineOutMGSetDTO> localVarResponse = ApiV1EnvironmentMGDocumentServiceOrderavailabilityPostWithHttpInfo(body, authorizationScope, environment, acceptLanguage, acceptTerritory, force, company, user);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Return Documents Order Portfolio Document processing status
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of DocumentoPortfolioEvadOrdineOutMGSetDTO</returns>
        public ApiResponse< DocumentoPortfolioEvadOrdineOutMGSetDTO > ApiV1EnvironmentMGDocumentServiceOrderavailabilityPostWithHttpInfo (DocumentoPortfolioEvadInMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceOrderavailabilityPost");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceOrderavailabilityPost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceOrderavailabilityPost");

            var localVarPath = "/api/v1/{environment}/MG/DocumentService/orderavailability";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGDocumentServiceOrderavailabilityPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<DocumentoPortfolioEvadOrdineOutMGSetDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (DocumentoPortfolioEvadOrdineOutMGSetDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(DocumentoPortfolioEvadOrdineOutMGSetDTO)));
        }

        /// <summary>
        /// Return Documents Order Portfolio Document processing status
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of DocumentoPortfolioEvadOrdineOutMGSetDTO</returns>
        public async System.Threading.Tasks.Task<DocumentoPortfolioEvadOrdineOutMGSetDTO> ApiV1EnvironmentMGDocumentServiceOrderavailabilityPostAsync (DocumentoPortfolioEvadInMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, string company = null, string user = null)
        {
             ApiResponse<DocumentoPortfolioEvadOrdineOutMGSetDTO> localVarResponse = await ApiV1EnvironmentMGDocumentServiceOrderavailabilityPostAsyncWithHttpInfo(body, authorizationScope, environment, acceptLanguage, acceptTerritory, force, company, user);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Return Documents Order Portfolio Document processing status
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (DocumentoPortfolioEvadOrdineOutMGSetDTO)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<DocumentoPortfolioEvadOrdineOutMGSetDTO>> ApiV1EnvironmentMGDocumentServiceOrderavailabilityPostAsyncWithHttpInfo (DocumentoPortfolioEvadInMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceOrderavailabilityPost");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceOrderavailabilityPost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceOrderavailabilityPost");

            var localVarPath = "/api/v1/{environment}/MG/DocumentService/orderavailability";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGDocumentServiceOrderavailabilityPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<DocumentoPortfolioEvadOrdineOutMGSetDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (DocumentoPortfolioEvadOrdineOutMGSetDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(DocumentoPortfolioEvadOrdineOutMGSetDTO)));
        }

        /// <summary>
        /// Document transformation based on the required parameters Document transformation based on the required parameters
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Document transformation parameters</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>DocumentTransformationParameterDTO</returns>
        public DocumentTransformationParameterDTO ApiV1EnvironmentMGDocumentServiceTransformPost (DocumentTransformationParameterDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, string company = null, string user = null)
        {
             ApiResponse<DocumentTransformationParameterDTO> localVarResponse = ApiV1EnvironmentMGDocumentServiceTransformPostWithHttpInfo(body, authorizationScope, environment, acceptLanguage, acceptTerritory, force, company, user);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Document transformation based on the required parameters Document transformation based on the required parameters
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Document transformation parameters</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of DocumentTransformationParameterDTO</returns>
        public ApiResponse< DocumentTransformationParameterDTO > ApiV1EnvironmentMGDocumentServiceTransformPostWithHttpInfo (DocumentTransformationParameterDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceTransformPost");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceTransformPost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceTransformPost");

            var localVarPath = "/api/v1/{environment}/MG/DocumentService/transform";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGDocumentServiceTransformPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<DocumentTransformationParameterDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (DocumentTransformationParameterDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(DocumentTransformationParameterDTO)));
        }

        /// <summary>
        /// Document transformation based on the required parameters Document transformation based on the required parameters
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Document transformation parameters</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of DocumentTransformationParameterDTO</returns>
        public async System.Threading.Tasks.Task<DocumentTransformationParameterDTO> ApiV1EnvironmentMGDocumentServiceTransformPostAsync (DocumentTransformationParameterDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, string company = null, string user = null)
        {
             ApiResponse<DocumentTransformationParameterDTO> localVarResponse = await ApiV1EnvironmentMGDocumentServiceTransformPostAsyncWithHttpInfo(body, authorizationScope, environment, acceptLanguage, acceptTerritory, force, company, user);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Document transformation based on the required parameters Document transformation based on the required parameters
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Document transformation parameters</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">Force values (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (DocumentTransformationParameterDTO)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<DocumentTransformationParameterDTO>> ApiV1EnvironmentMGDocumentServiceTransformPostAsyncWithHttpInfo (DocumentTransformationParameterDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceTransformPost");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceTransformPost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling DocumentServiceApi->ApiV1EnvironmentMGDocumentServiceTransformPost");

            var localVarPath = "/api/v1/{environment}/MG/DocumentService/transform";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGDocumentServiceTransformPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<DocumentTransformationParameterDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (DocumentTransformationParameterDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(DocumentTransformationParameterDTO)));
        }

    }
}
