'use strict';


/**
 * Get the current state of an object with the list of available states.
 * Get the current state of an object with the list of available states.
 *
 * guid String Guid to get the current state of an object with the list of available states.
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Example for multilanguage (optional)
 * returns CurrentStateCODTO
 **/
exports.apiV1EnvironmentCOStateManagementServiceGuidGET = function(guid,environment,authorizationScope,company,user,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "availableStates" : [ null, null ],
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "currentState" : {
    "indTipoStato" : 1,
    "description" : "description",
    "idStato" : 0,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "seq" : 6,
    "extensionData" : [ {
      "value" : "",
      "key" : "key"
    }, {
      "value" : "",
      "key" : "key"
    } ]
  },
  "extensionData" : [ null, null ]
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Get the current state of an object and the list of operations performed on the state.
 * Get the current state of an object and the list of operations performed on the state.
 *
 * guid String Guid to get the current state of an object and the list of operations performed on the state.
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Example for multilanguage (optional)
 * returns CurrentStateHistoryCODTO
 **/
exports.apiV1EnvironmentCOStateManagementServiceHistoryGuidGET = function(guid,environment,authorizationScope,company,user,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "statusOperationHistory" : [ {
    "idStatus" : 6,
    "historyAuto" : 1,
    "updateDate" : "2000-01-23T04:56:07.000+00:00",
    "statusDescription" : "statusDescription",
    "userDescription" : "userDescription",
    "historyDelete" : 5,
    "idHistory" : 0,
    "validityDate" : "2000-01-23T04:56:07.000+00:00",
    "flowDescription" : "flowDescription"
  }, {
    "idStatus" : 6,
    "historyAuto" : 1,
    "updateDate" : "2000-01-23T04:56:07.000+00:00",
    "statusDescription" : "statusDescription",
    "userDescription" : "userDescription",
    "historyDelete" : 5,
    "idHistory" : 0,
    "validityDate" : "2000-01-23T04:56:07.000+00:00",
    "flowDescription" : "flowDescription"
  } ],
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "currentState" : {
    "indTipoStato" : 1,
    "description" : "description",
    "idStato" : 0,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "seq" : 6,
    "extensionData" : [ {
      "value" : "",
      "key" : "key"
    }, {
      "value" : "",
      "key" : "key"
    } ]
  },
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ]
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Set a new object state or create default state.
 * Set a new object state or create default state.
 *
 * body SetStateParameterDTO Parameters to set a new object state or create default state. 
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * returns CurrentStateCODTO
 **/
exports.apiV1EnvironmentCOStateManagementServiceSetstatePOST = function(body,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "availableStates" : [ null, null ],
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "currentState" : {
    "indTipoStato" : 1,
    "description" : "description",
    "idStato" : 0,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "seq" : 6,
    "extensionData" : [ {
      "value" : "",
      "key" : "key"
    }, {
      "value" : "",
      "key" : "key"
    } ]
  },
  "extensionData" : [ null, null ]
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}

