'use strict';


/**
 * Get new
 * Get an empty object of type corresponding
 *
 * _op String The value must be 'new'
 * param String Specify optional parameters that will be used during entity creation
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns SectionalMasterDataCODTO
 **/
exports.apiV1EnvironmentCOSectionalMasterDataCOGET = function(_op,param,environment,authorizationScope,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "indIntra1213" : 5.637376656633329,
  "indTipologia" : 7.061401241503109,
  "indRegione" : 2.3021358869347655,
  "idagentecoll" : 1,
  "idprov" : 5.962133916683182,
  "puntovenCg7a" : 9.301444243932576,
  "sezionale" : "sezionale",
  "caustcoll" : "caustcoll",
  "dittaCg18" : 0.8008281904610115,
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "descsez" : "descsez",
  "flgNoLiqIva" : 6,
  "storeCO" : {
    "descrizione" : "descrizione",
    "puntoven" : 2.027123023002322,
    "dittaCg18" : 3.616076749251911,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    }
  }
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Proposes the sectional
 * Proposes the sectional based on the parameters passed in the request. If requested, it also returns the relative protocol. If they exist, it also returns the data relating to the self-invoice.
 *
 * body SectionalMasterDataProposalParametersDTO Object that contains all the parameters that are used in the calculation
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns SectionalMasterDataProposalResultDTO
 **/
exports.apiV1EnvironmentCOSectionalMasterDataCOGet_SectionalMasterDataProposalPOST = function(body,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "executionResult" : true,
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "sectionalData" : {
    "indTipologia" : 0.8008281904610115,
    "protocolData" : {
      "numDocOrigData" : {
        "updEnabled" : true,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "numDocOrig" : "numDocOrig"
      },
      "tipodocrif" : 1.4658129805029452,
      "executionResult" : true,
      "numdoc" : 6.027456183070403,
      "pluginData" : {
        "key" : ""
      },
      "datadoc" : "2000-01-23T04:56:07.000+00:00",
      "additionalData" : {
        "key" : ""
      }
    },
    "codAttivita" : 5.962133916683182,
    "codSez" : "codSez",
    "pluginData" : {
      "key" : ""
    },
    "causale" : "causale",
    "additionalData" : {
      "key" : ""
    },
    "descSez" : "descSez"
  }
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Delete
 * Deleting object of type 
 *
 * id String 
 * environment String 
 * dittaCg18 String DittaCg18 Mandatory to execute current action
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOSectionalMasterDataCOIdDELETE = function(id,environment,dittaCg18,authorizationScope,force,ignoreCompanyPolicyFilter,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Get by ID
 * Get an object of type corresponding the requested id
 *
 * id String Id to get the object
 * environment String 
 * dittaCg18 String DittaCg18 Mandatory to execute current action
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * dlevel String Serialization level (optional)
 * dlevelkey String Serialization level key (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns SectionalMasterDataCODTO
 **/
exports.apiV1EnvironmentCOSectionalMasterDataCOIdGET = function(id,environment,dittaCg18,authorizationScope,ignoreCompanyPolicyFilter,dlevel,dlevelkey,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "indIntra1213" : 5.637376656633329,
  "indTipologia" : 7.061401241503109,
  "indRegione" : 2.3021358869347655,
  "idagentecoll" : 1,
  "idprov" : 5.962133916683182,
  "puntovenCg7a" : 9.301444243932576,
  "sezionale" : "sezionale",
  "caustcoll" : "caustcoll",
  "dittaCg18" : 0.8008281904610115,
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "descsez" : "descsez",
  "flgNoLiqIva" : 6,
  "storeCO" : {
    "descrizione" : "descrizione",
    "puntoven" : 2.027123023002322,
    "dittaCg18" : 3.616076749251911,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    }
  }
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Update partial
 * Patching an object of type
 *
 * body  Object of type to patch
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request (optional)
 * dittaCg18 String DittaCg18 Mandatory to execute current action
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOSectionalMasterDataCOIdPATCH = function(body,ignoreCompanyPolicyFilter,force,_op,dittaCg18,company,user,id,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Update
 * Updating an object of type
 *
 * body SectionalMasterDataCODTO Object of type to update
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request (optional)
 * dittaCg18 String DittaCg18 Mandatory to execute current action
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns SectionalMasterDataCODTO
 **/
exports.apiV1EnvironmentCOSectionalMasterDataCOIdPUT = function(body,force,ignoreCompanyPolicyFilter,_op,dittaCg18,company,user,id,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "indIntra1213" : 5.637376656633329,
  "indTipologia" : 7.061401241503109,
  "indRegione" : 2.3021358869347655,
  "idagentecoll" : 1,
  "idprov" : 5.962133916683182,
  "puntovenCg7a" : 9.301444243932576,
  "sezionale" : "sezionale",
  "caustcoll" : "caustcoll",
  "dittaCg18" : 0.8008281904610115,
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "descsez" : "descsez",
  "flgNoLiqIva" : 6,
  "storeCO" : {
    "descrizione" : "descrizione",
    "puntoven" : 2.027123023002322,
    "dittaCg18" : 3.616076749251911,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    }
  }
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Create
 * Creating new object of type
 *
 * body SectionalMasterDataCODTO Object of type to create
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request (optional)
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns SectionalMasterDataCODTO
 **/
exports.apiV1EnvironmentCOSectionalMasterDataCOPOST = function(body,ignoreCompanyPolicyFilter,_op,force,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "indIntra1213" : 5.637376656633329,
  "indTipologia" : 7.061401241503109,
  "indRegione" : 2.3021358869347655,
  "idagentecoll" : 1,
  "idprov" : 5.962133916683182,
  "puntovenCg7a" : 9.301444243932576,
  "sezionale" : "sezionale",
  "caustcoll" : "caustcoll",
  "dittaCg18" : 0.8008281904610115,
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "descsez" : "descsez",
  "flgNoLiqIva" : 6,
  "storeCO" : {
    "descrizione" : "descrizione",
    "puntoven" : 2.027123023002322,
    "dittaCg18" : 3.616076749251911,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    }
  }
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Validate
 * Validation of object of type
 *
 * body SectionalMasterDataCODTO Object of type to validate
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOSectionalMasterDataCOValidatePOST = function(body,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Validation of one on more properties of Type
 * Validation of object of type
 *
 * body String  - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED<br> - The id of an existing object to validate properties, or '' if the object does not exist yet <br> (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns ValidateDTO
 **/
exports.apiV1EnvironmentCOSectionalMasterDataCOValidatePropertiesPOST = function(body,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "items" : [ {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  }, {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  } ]
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}

