# IO.Swagger.Api.CurrencyCOApi

All URIs are relative to *https://apicsdemo.teamsystem.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**ApiV1EnvironmentCOCurrencyCOCalculateAmountByCurrencyPost**](CurrencyCOApi.md#apiv1environmentcocurrencycocalculateamountbycurrencypost) | **POST** /api/v1/{environment}/CO/CurrencyCO/calculateAmountByCurrency | Calculation of the amount by exchange
[**ApiV1EnvironmentCOCurrencyCOCalculateExchangeratePost**](CurrencyCOApi.md#apiv1environmentcocurrencycocalculateexchangeratepost) | **POST** /api/v1/{environment}/CO/CurrencyCO/calculate_exchangerate | Calculation &#x27;Exchange rate&#x27;
[**ApiV1EnvironmentCOCurrencyCOGet**](CurrencyCOApi.md#apiv1environmentcocurrencycoget) | **GET** /api/v1/{environment}/CO/CurrencyCO | Get new
[**ApiV1EnvironmentCOCurrencyCOIdDelete**](CurrencyCOApi.md#apiv1environmentcocurrencycoiddelete) | **DELETE** /api/v1/{environment}/CO/CurrencyCO/{id} | Delete
[**ApiV1EnvironmentCOCurrencyCOIdGet**](CurrencyCOApi.md#apiv1environmentcocurrencycoidget) | **GET** /api/v1/{environment}/CO/CurrencyCO/{id} | Get by ID
[**ApiV1EnvironmentCOCurrencyCOIdPatch**](CurrencyCOApi.md#apiv1environmentcocurrencycoidpatch) | **PATCH** /api/v1/{environment}/CO/CurrencyCO/{id} | Update partial
[**ApiV1EnvironmentCOCurrencyCOIdPut**](CurrencyCOApi.md#apiv1environmentcocurrencycoidput) | **PUT** /api/v1/{environment}/CO/CurrencyCO/{id} | Update
[**ApiV1EnvironmentCOCurrencyCOImportannualaverageratesPost**](CurrencyCOApi.md#apiv1environmentcocurrencycoimportannualaverageratespost) | **POST** /api/v1/{environment}/CO/CurrencyCO/importannualaveragerates | Average annual exchange rates import
[**ApiV1EnvironmentCOCurrencyCOImportcurrencyratesPost**](CurrencyCOApi.md#apiv1environmentcocurrencycoimportcurrencyratespost) | **POST** /api/v1/{environment}/CO/CurrencyCO/importcurrencyrates | Currency Exchange Import
[**ApiV1EnvironmentCOCurrencyCOImportmonthlyaverageratesPost**](CurrencyCOApi.md#apiv1environmentcocurrencycoimportmonthlyaverageratespost) | **POST** /api/v1/{environment}/CO/CurrencyCO/importmonthlyaveragerates | Import of average monthly exchange rates
[**ApiV1EnvironmentCOCurrencyCOImporttimeseriesratesPost**](CurrencyCOApi.md#apiv1environmentcocurrencycoimporttimeseriesratespost) | **POST** /api/v1/{environment}/CO/CurrencyCO/importtimeseriesrates | Import time series exchange rates
[**ApiV1EnvironmentCOCurrencyCOPost**](CurrencyCOApi.md#apiv1environmentcocurrencycopost) | **POST** /api/v1/{environment}/CO/CurrencyCO | Create
[**ApiV1EnvironmentCOCurrencyCOValidatePost**](CurrencyCOApi.md#apiv1environmentcocurrencycovalidatepost) | **POST** /api/v1/{environment}/CO/CurrencyCO/validate | Validate
[**ApiV1EnvironmentCOCurrencyCOValidatePropertiesPost**](CurrencyCOApi.md#apiv1environmentcocurrencycovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/CurrencyCO/validateProperties | Validation of one on more properties of Type

<a name="apiv1environmentcocurrencycocalculateamountbycurrencypost"></a>
# **ApiV1EnvironmentCOCurrencyCOCalculateAmountByCurrencyPost**
> CalculateAmountResultDTO ApiV1EnvironmentCOCurrencyCOCalculateAmountByCurrencyPost (CalculateAmountParametersDTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)

Calculation of the amount by exchange

Currency exchange calculation

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCurrencyCOCalculateAmountByCurrencyPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CurrencyCOApi();
            var body = new CalculateAmountParametersDTO(); // CalculateAmountParametersDTO | Object containing the parameters necessary for the calculation. If it is not passed the exchange will be taken by CG09_TABCAMBI
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Calculation of the amount by exchange
                CalculateAmountResultDTO result = apiInstance.ApiV1EnvironmentCOCurrencyCOCalculateAmountByCurrencyPost(body, authorizationScope, environment, acceptLanguage, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CurrencyCOApi.ApiV1EnvironmentCOCurrencyCOCalculateAmountByCurrencyPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**CalculateAmountParametersDTO**](CalculateAmountParametersDTO.md)| Object containing the parameters necessary for the calculation. If it is not passed the exchange will be taken by CG09_TABCAMBI | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**CalculateAmountResultDTO**](CalculateAmountResultDTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcocurrencycocalculateexchangeratepost"></a>
# **ApiV1EnvironmentCOCurrencyCOCalculateExchangeratePost**
> CalculateExchangeRateResultDTO ApiV1EnvironmentCOCurrencyCOCalculateExchangeratePost (CalculateExchangeRateParametersDTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)

Calculation 'Exchange rate'

Currency exchange calculation

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCurrencyCOCalculateExchangeratePostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CurrencyCOApi();
            var body = new CalculateExchangeRateParametersDTO(); // CalculateExchangeRateParametersDTO | Object that contains all the parameters that are used in the calculation
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Calculation 'Exchange rate'
                CalculateExchangeRateResultDTO result = apiInstance.ApiV1EnvironmentCOCurrencyCOCalculateExchangeratePost(body, authorizationScope, environment, acceptLanguage, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CurrencyCOApi.ApiV1EnvironmentCOCurrencyCOCalculateExchangeratePost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**CalculateExchangeRateParametersDTO**](CalculateExchangeRateParametersDTO.md)| Object that contains all the parameters that are used in the calculation | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**CalculateExchangeRateResultDTO**](CalculateExchangeRateResultDTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcocurrencycoget"></a>
# **ApiV1EnvironmentCOCurrencyCOGet**
> CurrencyCODTO ApiV1EnvironmentCOCurrencyCOGet (string op, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null)

Get new

Get an empty object of type corresponding

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCurrencyCOGetExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CurrencyCOApi();
            var op = op_example;  // string | The value must be 'new'
            var environment = environment_example;  // string | 
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)

            try
            {
                // Get new
                CurrencyCODTO result = apiInstance.ApiV1EnvironmentCOCurrencyCOGet(op, environment, authorizationScope, company, user, acceptLanguage);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CurrencyCOApi.ApiV1EnvironmentCOCurrencyCOGet: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **op** | **string**| The value must be &#x27;new&#x27; | 
 **environment** | **string**|  | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]

### Return type

[**CurrencyCODTO**](CurrencyCODTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcocurrencycoiddelete"></a>
# **ApiV1EnvironmentCOCurrencyCOIdDelete**
> void ApiV1EnvironmentCOCurrencyCOIdDelete (string id, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null)

Delete

Deleting object of type 

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCurrencyCOIdDeleteExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CurrencyCOApi();
            var id = id_example;  // string | 
            var environment = environment_example;  // string | 
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)

            try
            {
                // Delete
                apiInstance.ApiV1EnvironmentCOCurrencyCOIdDelete(id, environment, authorizationScope, company, user, acceptLanguage);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CurrencyCOApi.ApiV1EnvironmentCOCurrencyCOIdDelete: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**|  | 
 **environment** | **string**|  | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]

### Return type

void (empty response body)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcocurrencycoidget"></a>
# **ApiV1EnvironmentCOCurrencyCOIdGet**
> CurrencyCODTO ApiV1EnvironmentCOCurrencyCOIdGet (string id, string environment, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null)

Get by ID

Get an object of type corresponding the requested id

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCurrencyCOIdGetExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CurrencyCOApi();
            var id = id_example;  // string | Id to get the object
            var environment = environment_example;  // string | 
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var dlevel = dlevel_example;  // string | Serialization level (optional) 
            var dlevelkey = dlevelkey_example;  // string | Serialization level key (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)

            try
            {
                // Get by ID
                CurrencyCODTO result = apiInstance.ApiV1EnvironmentCOCurrencyCOIdGet(id, environment, authorizationScope, dlevel, dlevelkey, company, user, acceptLanguage);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CurrencyCOApi.ApiV1EnvironmentCOCurrencyCOIdGet: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**| Id to get the object | 
 **environment** | **string**|  | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **dlevel** | **string**| Serialization level | [optional] 
 **dlevelkey** | **string**| Serialization level key | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]

### Return type

[**CurrencyCODTO**](CurrencyCODTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcocurrencycoidpatch"></a>
# **ApiV1EnvironmentCOCurrencyCOIdPatch**
> void ApiV1EnvironmentCOCurrencyCOIdPatch (Object body, string authorizationScope, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)

Update partial

Patching an object of type

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCurrencyCOIdPatchExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CurrencyCOApi();
            var body = new Object(); // Object | Object of type to patch
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var id = id_example;  // string | 
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)
            var force = force_example;  // string | The warning/s code to bypass (separated by ‘,’) during the execution (optional) 
            var op = op_example;  // string | Set 'reload', if you want the DTO updated in the response request (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Update partial
                apiInstance.ApiV1EnvironmentCOCurrencyCOIdPatch(body, authorizationScope, id, environment, acceptLanguage, force, op, company, user);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CurrencyCOApi.ApiV1EnvironmentCOCurrencyCOIdPatch: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**Object**](Object.md)| Object of type to patch | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **id** | **string**|  | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]
 **force** | **string**| The warning/s code to bypass (separated by ‘,’) during the execution | [optional] 
 **op** | **string**| Set &#x27;reload&#x27;, if you want the DTO updated in the response request | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

void (empty response body)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcocurrencycoidput"></a>
# **ApiV1EnvironmentCOCurrencyCOIdPut**
> CurrencyCODTO ApiV1EnvironmentCOCurrencyCOIdPut (CurrencyCODTO body, string authorizationScope, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)

Update

Updating an object of type

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCurrencyCOIdPutExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CurrencyCOApi();
            var body = new CurrencyCODTO(); // CurrencyCODTO | Object of type to update
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var id = id_example;  // string | 
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)
            var force = force_example;  // string | The warning/s code to bypass (separated by ‘,’) during the execution (optional) 
            var op = op_example;  // string | Set 'reload', if you want the DTO updated in the response request, otherwise will be returned null value (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Update
                CurrencyCODTO result = apiInstance.ApiV1EnvironmentCOCurrencyCOIdPut(body, authorizationScope, id, environment, acceptLanguage, force, op, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CurrencyCOApi.ApiV1EnvironmentCOCurrencyCOIdPut: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**CurrencyCODTO**](CurrencyCODTO.md)| Object of type to update | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **id** | **string**|  | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]
 **force** | **string**| The warning/s code to bypass (separated by ‘,’) during the execution | [optional] 
 **op** | **string**| Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**CurrencyCODTO**](CurrencyCODTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcocurrencycoimportannualaverageratespost"></a>
# **ApiV1EnvironmentCOCurrencyCOImportannualaverageratesPost**
> ImportCurrencyRatesOutputDTO ApiV1EnvironmentCOCurrencyCOImportannualaverageratesPost (ImportAnnualAverageRatesInputDTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)

Average annual exchange rates import

Average annual exchange rates import

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCurrencyCOImportannualaverageratesPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CurrencyCOApi();
            var body = new ImportAnnualAverageRatesInputDTO(); // ImportAnnualAverageRatesInputDTO | Input parameters
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Average annual exchange rates import
                ImportCurrencyRatesOutputDTO result = apiInstance.ApiV1EnvironmentCOCurrencyCOImportannualaverageratesPost(body, authorizationScope, environment, acceptLanguage, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CurrencyCOApi.ApiV1EnvironmentCOCurrencyCOImportannualaverageratesPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**ImportAnnualAverageRatesInputDTO**](ImportAnnualAverageRatesInputDTO.md)| Input parameters | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**ImportCurrencyRatesOutputDTO**](ImportCurrencyRatesOutputDTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcocurrencycoimportcurrencyratespost"></a>
# **ApiV1EnvironmentCOCurrencyCOImportcurrencyratesPost**
> ImportCurrencyRatesOutputDTO ApiV1EnvironmentCOCurrencyCOImportcurrencyratesPost (ImportCurrencyRatesInputDTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)

Currency Exchange Import

Currency Exchange Import

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCurrencyCOImportcurrencyratesPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CurrencyCOApi();
            var body = new ImportCurrencyRatesInputDTO(); // ImportCurrencyRatesInputDTO | Input parameters
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Currency Exchange Import
                ImportCurrencyRatesOutputDTO result = apiInstance.ApiV1EnvironmentCOCurrencyCOImportcurrencyratesPost(body, authorizationScope, environment, acceptLanguage, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CurrencyCOApi.ApiV1EnvironmentCOCurrencyCOImportcurrencyratesPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**ImportCurrencyRatesInputDTO**](ImportCurrencyRatesInputDTO.md)| Input parameters | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**ImportCurrencyRatesOutputDTO**](ImportCurrencyRatesOutputDTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcocurrencycoimportmonthlyaverageratespost"></a>
# **ApiV1EnvironmentCOCurrencyCOImportmonthlyaverageratesPost**
> ImportCurrencyRatesOutputDTO ApiV1EnvironmentCOCurrencyCOImportmonthlyaverageratesPost (ImportMonthlyAverageRatesInputDTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)

Import of average monthly exchange rates

Import of average monthly exchange rates

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCurrencyCOImportmonthlyaverageratesPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CurrencyCOApi();
            var body = new ImportMonthlyAverageRatesInputDTO(); // ImportMonthlyAverageRatesInputDTO | Input parameters
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Import of average monthly exchange rates
                ImportCurrencyRatesOutputDTO result = apiInstance.ApiV1EnvironmentCOCurrencyCOImportmonthlyaverageratesPost(body, authorizationScope, environment, acceptLanguage, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CurrencyCOApi.ApiV1EnvironmentCOCurrencyCOImportmonthlyaverageratesPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**ImportMonthlyAverageRatesInputDTO**](ImportMonthlyAverageRatesInputDTO.md)| Input parameters | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**ImportCurrencyRatesOutputDTO**](ImportCurrencyRatesOutputDTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcocurrencycoimporttimeseriesratespost"></a>
# **ApiV1EnvironmentCOCurrencyCOImporttimeseriesratesPost**
> ImportCurrencyRatesOutputDTO ApiV1EnvironmentCOCurrencyCOImporttimeseriesratesPost (ImportTimeSeriesRatesInputDTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)

Import time series exchange rates

Time Series exchange rates import

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCurrencyCOImporttimeseriesratesPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CurrencyCOApi();
            var body = new ImportTimeSeriesRatesInputDTO(); // ImportTimeSeriesRatesInputDTO | Input parameters
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Import time series exchange rates
                ImportCurrencyRatesOutputDTO result = apiInstance.ApiV1EnvironmentCOCurrencyCOImporttimeseriesratesPost(body, authorizationScope, environment, acceptLanguage, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CurrencyCOApi.ApiV1EnvironmentCOCurrencyCOImporttimeseriesratesPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**ImportTimeSeriesRatesInputDTO**](ImportTimeSeriesRatesInputDTO.md)| Input parameters | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**ImportCurrencyRatesOutputDTO**](ImportCurrencyRatesOutputDTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcocurrencycopost"></a>
# **ApiV1EnvironmentCOCurrencyCOPost**
> CurrencyCODTO ApiV1EnvironmentCOCurrencyCOPost (CurrencyCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)

Create

Creating new object of type

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCurrencyCOPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CurrencyCOApi();
            var body = new CurrencyCODTO(); // CurrencyCODTO | Object of type to create
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Create
                CurrencyCODTO result = apiInstance.ApiV1EnvironmentCOCurrencyCOPost(body, authorizationScope, environment, acceptLanguage, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CurrencyCOApi.ApiV1EnvironmentCOCurrencyCOPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**CurrencyCODTO**](CurrencyCODTO.md)| Object of type to create | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**CurrencyCODTO**](CurrencyCODTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcocurrencycovalidatepost"></a>
# **ApiV1EnvironmentCOCurrencyCOValidatePost**
> void ApiV1EnvironmentCOCurrencyCOValidatePost (CurrencyCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)

Validate

Validation of object of type

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCurrencyCOValidatePostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CurrencyCOApi();
            var body = new CurrencyCODTO(); // CurrencyCODTO | Object of type to validate
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Validate
                apiInstance.ApiV1EnvironmentCOCurrencyCOValidatePost(body, authorizationScope, environment, acceptLanguage, company, user);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CurrencyCOApi.ApiV1EnvironmentCOCurrencyCOValidatePost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**CurrencyCODTO**](CurrencyCODTO.md)| Object of type to validate | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

void (empty response body)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcocurrencycovalidatepropertiespost"></a>
# **ApiV1EnvironmentCOCurrencyCOValidatePropertiesPost**
> ValidateDTO ApiV1EnvironmentCOCurrencyCOValidatePropertiesPost (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string company = null, string user = null)

Validation of one on more properties of Type

Validation of object of type

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCurrencyCOValidatePropertiesPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CurrencyCOApi();
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var body = new string(); // string |  - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED<br> - The id of an existing object to validate properties, or '' if the object does not exist yet <br> (optional) 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Validation of one on more properties of Type
                ValidateDTO result = apiInstance.ApiV1EnvironmentCOCurrencyCOValidatePropertiesPost(authorizationScope, environment, body, acceptLanguage, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CurrencyCOApi.ApiV1EnvironmentCOCurrencyCOValidatePropertiesPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **body** | [**string**](string.md)|  - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; | [optional] 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**ValidateDTO**](ValidateDTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
