'use strict';


/**
 * Get new
 * Get an empty object of type corresponding
 *
 * _op String The value must be 'new'
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Example for multilanguage (optional)
 * returns CompanyDocumentMasterDataMGDTO
 **/
exports.apiV1EnvironmentMGCompanyDocumentMasterDataMGGET = function(_op,environment,authorizationScope,company,user,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "indStaperMg36" : 6.027456183070403,
  "codDocumMg36" : "codDocumMg36",
  "dittaCg18" : 0.8008281904610115,
  "sezdefault" : "sezdefault",
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ]
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Service to view the guided authorizations based on the Document Wizard.
 * Service to view all active modules associated with a document based on its configuration with the Document Wizard.
 *
 * id String Id to get the object
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Example for multilanguage (optional)
 * returns DocumentEnablementWizardResultDTO
 **/
exports.apiV1EnvironmentMGCompanyDocumentMasterDataMGIdEnablementwizardGET = function(id,environment,authorizationScope,company,user,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "isDocumentRowCommission" : true,
  "isDocumentRowCustomizedAttribute" : true,
  "isDocumentHeaderStandardAttribute" : true,
  "isDocumentRowReference" : true,
  "document" : "document",
  "description" : "description",
  "isDocumentRowStandardAttribute" : true,
  "isDocumentHeaderAgent" : true,
  "isDocumentRowAnalyticalCorrelation" : true,
  "isDocumentRow" : true,
  "documentCustom" : 0.8008281904610115,
  "isDocumentHeader" : true,
  "isDocumentHeaderProject" : true,
  "isDocumentHeaderCustomizedAttribute" : true,
  "isDocumentRowProject" : true,
  "isDocumentHeaderShipmentData" : true,
  "isDocumentHeaderReference" : true,
  "isDocumentRowLot" : true,
  "isDocumentRowPackaging" : true,
  "isDocumentRowIntra" : true,
  "isDocumentHeaderCommission" : true,
  "isDocumentRowOrder" : true,
  "isDocumentHeaderAccrual" : true,
  "isDocumentTotal" : true,
  "isDocumentHeaderOrder" : true,
  "isDocumentRowAccrual" : true
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Get by ID
 * Get an object of type corresponding the requested id
 *
 * id String Id to get the object
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * dlevel String Serialization level (optional)
 * dlevelkey String Serialization level key (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Example for multilanguage (optional)
 * returns CompanyDocumentMasterDataMGDTO
 **/
exports.apiV1EnvironmentMGCompanyDocumentMasterDataMGIdGET = function(id,environment,authorizationScope,dlevel,dlevelkey,company,user,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "indStaperMg36" : 6.027456183070403,
  "codDocumMg36" : "codDocumMg36",
  "dittaCg18" : 0.8008281904610115,
  "sezdefault" : "sezdefault",
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ]
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Validate
 * Validation of object of type
 *
 * body CompanyDocumentMasterDataMGDTO Object of type to validate
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentMGCompanyDocumentMasterDataMGValidatePOST = function(body,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Validation of one on more properties of Type
 * Validation of object of type
 *
 * body String  - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED<br> - The id of an existing object to validate properties, or '' if the object does not exist yet <br> (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * returns ValidateDTO
 **/
exports.apiV1EnvironmentMGCompanyDocumentMasterDataMGValidatePropertiesPOST = function(body,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "items" : [ {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  }, {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  } ],
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ]
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}

