/* 
 * TSE Cloud - MG
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.1000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// Stato attuale di un&#x27;entità.
    /// </summary>
    [DataContract]
        public partial class StatoAttualeDTO :  IEquatable<StatoAttualeDTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="StatoAttualeDTO" /> class.
        /// </summary>
        /// <param name="statoCorrente">statoCorrente (required).</param>
        /// <param name="statiDisponibili">Lista di stati disponibili raggiungibili dallo stato corrente. (required).</param>
        /// <param name="extensionData">extensionData.</param>
        /// <param name="additionalData">additionalData.</param>
        /// <param name="pluginData">pluginData.</param>
        public StatoAttualeDTO(StatoDTO statoCorrente = default(StatoDTO), List<StatoDTO> statiDisponibili = default(List<StatoDTO>), List<StringObjectKeyValuePair> extensionData = default(List<StringObjectKeyValuePair>), Dictionary<string, Object> additionalData = default(Dictionary<string, Object>), Dictionary<string, Object> pluginData = default(Dictionary<string, Object>))
        {
            // to ensure "statoCorrente" is required (not null)
            if (statoCorrente == null)
            {
                throw new InvalidDataException("statoCorrente is a required property for StatoAttualeDTO and cannot be null");
            }
            else
            {
                this.StatoCorrente = statoCorrente;
            }
            // to ensure "statiDisponibili" is required (not null)
            if (statiDisponibili == null)
            {
                throw new InvalidDataException("statiDisponibili is a required property for StatoAttualeDTO and cannot be null");
            }
            else
            {
                this.StatiDisponibili = statiDisponibili;
            }
            this.ExtensionData = extensionData;
            this.AdditionalData = additionalData;
            this.PluginData = pluginData;
        }
        
        /// <summary>
        /// Gets or Sets StatoCorrente
        /// </summary>
        [DataMember(Name="statoCorrente", EmitDefaultValue=false)]
        public StatoDTO StatoCorrente { get; set; }

        /// <summary>
        /// Lista di stati disponibili raggiungibili dallo stato corrente.
        /// </summary>
        /// <value>Lista di stati disponibili raggiungibili dallo stato corrente.</value>
        [DataMember(Name="statiDisponibili", EmitDefaultValue=false)]
        public List<StatoDTO> StatiDisponibili { get; set; }

        /// <summary>
        /// Gets or Sets ExtensionData
        /// </summary>
        [DataMember(Name="extensionData", EmitDefaultValue=false)]
        public List<StringObjectKeyValuePair> ExtensionData { get; set; }

        /// <summary>
        /// Gets or Sets AdditionalData
        /// </summary>
        [DataMember(Name="additionalData", EmitDefaultValue=false)]
        public Dictionary<string, Object> AdditionalData { get; set; }

        /// <summary>
        /// Gets or Sets PluginData
        /// </summary>
        [DataMember(Name="pluginData", EmitDefaultValue=false)]
        public Dictionary<string, Object> PluginData { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class StatoAttualeDTO {\n");
            sb.Append("  StatoCorrente: ").Append(StatoCorrente).Append("\n");
            sb.Append("  StatiDisponibili: ").Append(StatiDisponibili).Append("\n");
            sb.Append("  ExtensionData: ").Append(ExtensionData).Append("\n");
            sb.Append("  AdditionalData: ").Append(AdditionalData).Append("\n");
            sb.Append("  PluginData: ").Append(PluginData).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as StatoAttualeDTO);
        }

        /// <summary>
        /// Returns true if StatoAttualeDTO instances are equal
        /// </summary>
        /// <param name="input">Instance of StatoAttualeDTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(StatoAttualeDTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.StatoCorrente == input.StatoCorrente ||
                    (this.StatoCorrente != null &&
                    this.StatoCorrente.Equals(input.StatoCorrente))
                ) && 
                (
                    this.StatiDisponibili == input.StatiDisponibili ||
                    this.StatiDisponibili != null &&
                    input.StatiDisponibili != null &&
                    this.StatiDisponibili.SequenceEqual(input.StatiDisponibili)
                ) && 
                (
                    this.ExtensionData == input.ExtensionData ||
                    this.ExtensionData != null &&
                    input.ExtensionData != null &&
                    this.ExtensionData.SequenceEqual(input.ExtensionData)
                ) && 
                (
                    this.AdditionalData == input.AdditionalData ||
                    this.AdditionalData != null &&
                    input.AdditionalData != null &&
                    this.AdditionalData.SequenceEqual(input.AdditionalData)
                ) && 
                (
                    this.PluginData == input.PluginData ||
                    this.PluginData != null &&
                    input.PluginData != null &&
                    this.PluginData.SequenceEqual(input.PluginData)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.StatoCorrente != null)
                    hashCode = hashCode * 59 + this.StatoCorrente.GetHashCode();
                if (this.StatiDisponibili != null)
                    hashCode = hashCode * 59 + this.StatiDisponibili.GetHashCode();
                if (this.ExtensionData != null)
                    hashCode = hashCode * 59 + this.ExtensionData.GetHashCode();
                if (this.AdditionalData != null)
                    hashCode = hashCode * 59 + this.AdditionalData.GetHashCode();
                if (this.PluginData != null)
                    hashCode = hashCode * 59 + this.PluginData.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
