/* 
 * TSE Cloud - MG
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.1000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// ImportDocumentMGAddParameterDTO
    /// </summary>
    [DataContract]
        public partial class ImportDocumentMGAddParameterDTO :  IEquatable<ImportDocumentMGAddParameterDTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="ImportDocumentMGAddParameterDTO" /> class.
        /// </summary>
        /// <param name="documentCode">Document code to use for import.</param>
        /// <param name="selectionActionDocumentExist">Select the Action to undertake if document exists&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - 0 - Do not update &lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - 1 - Delete document &lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - 2 - Delete and import &lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - 3 - Update header, add body lines &lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - 4 - Insert with same number &lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - 5 - Insert with new number &lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - 6 - Update header, change body lines &lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - 7 - Update header, update body &lt;/li&gt;&lt;/ul&gt; (default to &quot;4&quot;).</param>
        /// <param name="insertNewCustomerSupplier">Inserting new Customers/Suppliers (default to true).</param>
        /// <param name="updateExistingCustomerSupplier">Update existing Customers/Suppliers (default to false).</param>
        /// <param name="insertNewItem">Inserting new Items (default to true).</param>
        /// <param name="updateExistingItem">Update existing Items (default to false).</param>
        /// <param name="insertDataForNotExistingTables">Inserts data for AgencyCO, CarrierMG, RecipientMG, PaymentTermCO, AgentMG, FamilyWH/SubFamilyWH, ItemGroupWH/ItemSubGroupWH if not present in the archive (default to true).</param>
        public ImportDocumentMGAddParameterDTO(string documentCode = default(string), string selectionActionDocumentExist = "4", bool? insertNewCustomerSupplier = true, bool? updateExistingCustomerSupplier = false, bool? insertNewItem = true, bool? updateExistingItem = false, bool? insertDataForNotExistingTables = true)
        {
            this.DocumentCode = documentCode;
            // use default value if no "selectionActionDocumentExist" provided
            if (selectionActionDocumentExist == null)
            {
                this.SelectionActionDocumentExist = "4";
            }
            else
            {
                this.SelectionActionDocumentExist = selectionActionDocumentExist;
            }
            // use default value if no "insertNewCustomerSupplier" provided
            if (insertNewCustomerSupplier == null)
            {
                this.InsertNewCustomerSupplier = true;
            }
            else
            {
                this.InsertNewCustomerSupplier = insertNewCustomerSupplier;
            }
            // use default value if no "updateExistingCustomerSupplier" provided
            if (updateExistingCustomerSupplier == null)
            {
                this.UpdateExistingCustomerSupplier = false;
            }
            else
            {
                this.UpdateExistingCustomerSupplier = updateExistingCustomerSupplier;
            }
            // use default value if no "insertNewItem" provided
            if (insertNewItem == null)
            {
                this.InsertNewItem = true;
            }
            else
            {
                this.InsertNewItem = insertNewItem;
            }
            // use default value if no "updateExistingItem" provided
            if (updateExistingItem == null)
            {
                this.UpdateExistingItem = false;
            }
            else
            {
                this.UpdateExistingItem = updateExistingItem;
            }
            // use default value if no "insertDataForNotExistingTables" provided
            if (insertDataForNotExistingTables == null)
            {
                this.InsertDataForNotExistingTables = true;
            }
            else
            {
                this.InsertDataForNotExistingTables = insertDataForNotExistingTables;
            }
        }
        
        /// <summary>
        /// Document code to use for import
        /// </summary>
        /// <value>Document code to use for import</value>
        [DataMember(Name="documentCode", EmitDefaultValue=false)]
        public string DocumentCode { get; set; }

        /// <summary>
        /// Select the Action to undertake if document exists&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - 0 - Do not update &lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - 1 - Delete document &lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - 2 - Delete and import &lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - 3 - Update header, add body lines &lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - 4 - Insert with same number &lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - 5 - Insert with new number &lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - 6 - Update header, change body lines &lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - 7 - Update header, update body &lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>Select the Action to undertake if document exists&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - 0 - Do not update &lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - 1 - Delete document &lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - 2 - Delete and import &lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - 3 - Update header, add body lines &lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - 4 - Insert with same number &lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - 5 - Insert with new number &lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - 6 - Update header, change body lines &lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - 7 - Update header, update body &lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="selectionActionDocumentExist", EmitDefaultValue=false)]
        public string SelectionActionDocumentExist { get; set; }

        /// <summary>
        /// Inserting new Customers/Suppliers
        /// </summary>
        /// <value>Inserting new Customers/Suppliers</value>
        [DataMember(Name="insertNewCustomerSupplier", EmitDefaultValue=false)]
        public bool? InsertNewCustomerSupplier { get; set; }

        /// <summary>
        /// Update existing Customers/Suppliers
        /// </summary>
        /// <value>Update existing Customers/Suppliers</value>
        [DataMember(Name="updateExistingCustomerSupplier", EmitDefaultValue=false)]
        public bool? UpdateExistingCustomerSupplier { get; set; }

        /// <summary>
        /// Inserting new Items
        /// </summary>
        /// <value>Inserting new Items</value>
        [DataMember(Name="insertNewItem", EmitDefaultValue=false)]
        public bool? InsertNewItem { get; set; }

        /// <summary>
        /// Update existing Items
        /// </summary>
        /// <value>Update existing Items</value>
        [DataMember(Name="updateExistingItem", EmitDefaultValue=false)]
        public bool? UpdateExistingItem { get; set; }

        /// <summary>
        /// Inserts data for AgencyCO, CarrierMG, RecipientMG, PaymentTermCO, AgentMG, FamilyWH/SubFamilyWH, ItemGroupWH/ItemSubGroupWH if not present in the archive
        /// </summary>
        /// <value>Inserts data for AgencyCO, CarrierMG, RecipientMG, PaymentTermCO, AgentMG, FamilyWH/SubFamilyWH, ItemGroupWH/ItemSubGroupWH if not present in the archive</value>
        [DataMember(Name="insertDataForNotExistingTables", EmitDefaultValue=false)]
        public bool? InsertDataForNotExistingTables { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class ImportDocumentMGAddParameterDTO {\n");
            sb.Append("  DocumentCode: ").Append(DocumentCode).Append("\n");
            sb.Append("  SelectionActionDocumentExist: ").Append(SelectionActionDocumentExist).Append("\n");
            sb.Append("  InsertNewCustomerSupplier: ").Append(InsertNewCustomerSupplier).Append("\n");
            sb.Append("  UpdateExistingCustomerSupplier: ").Append(UpdateExistingCustomerSupplier).Append("\n");
            sb.Append("  InsertNewItem: ").Append(InsertNewItem).Append("\n");
            sb.Append("  UpdateExistingItem: ").Append(UpdateExistingItem).Append("\n");
            sb.Append("  InsertDataForNotExistingTables: ").Append(InsertDataForNotExistingTables).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as ImportDocumentMGAddParameterDTO);
        }

        /// <summary>
        /// Returns true if ImportDocumentMGAddParameterDTO instances are equal
        /// </summary>
        /// <param name="input">Instance of ImportDocumentMGAddParameterDTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(ImportDocumentMGAddParameterDTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.DocumentCode == input.DocumentCode ||
                    (this.DocumentCode != null &&
                    this.DocumentCode.Equals(input.DocumentCode))
                ) && 
                (
                    this.SelectionActionDocumentExist == input.SelectionActionDocumentExist ||
                    (this.SelectionActionDocumentExist != null &&
                    this.SelectionActionDocumentExist.Equals(input.SelectionActionDocumentExist))
                ) && 
                (
                    this.InsertNewCustomerSupplier == input.InsertNewCustomerSupplier ||
                    (this.InsertNewCustomerSupplier != null &&
                    this.InsertNewCustomerSupplier.Equals(input.InsertNewCustomerSupplier))
                ) && 
                (
                    this.UpdateExistingCustomerSupplier == input.UpdateExistingCustomerSupplier ||
                    (this.UpdateExistingCustomerSupplier != null &&
                    this.UpdateExistingCustomerSupplier.Equals(input.UpdateExistingCustomerSupplier))
                ) && 
                (
                    this.InsertNewItem == input.InsertNewItem ||
                    (this.InsertNewItem != null &&
                    this.InsertNewItem.Equals(input.InsertNewItem))
                ) && 
                (
                    this.UpdateExistingItem == input.UpdateExistingItem ||
                    (this.UpdateExistingItem != null &&
                    this.UpdateExistingItem.Equals(input.UpdateExistingItem))
                ) && 
                (
                    this.InsertDataForNotExistingTables == input.InsertDataForNotExistingTables ||
                    (this.InsertDataForNotExistingTables != null &&
                    this.InsertDataForNotExistingTables.Equals(input.InsertDataForNotExistingTables))
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.DocumentCode != null)
                    hashCode = hashCode * 59 + this.DocumentCode.GetHashCode();
                if (this.SelectionActionDocumentExist != null)
                    hashCode = hashCode * 59 + this.SelectionActionDocumentExist.GetHashCode();
                if (this.InsertNewCustomerSupplier != null)
                    hashCode = hashCode * 59 + this.InsertNewCustomerSupplier.GetHashCode();
                if (this.UpdateExistingCustomerSupplier != null)
                    hashCode = hashCode * 59 + this.UpdateExistingCustomerSupplier.GetHashCode();
                if (this.InsertNewItem != null)
                    hashCode = hashCode * 59 + this.InsertNewItem.GetHashCode();
                if (this.UpdateExistingItem != null)
                    hashCode = hashCode * 59 + this.UpdateExistingItem.GetHashCode();
                if (this.InsertDataForNotExistingTables != null)
                    hashCode = hashCode * 59 + this.InsertDataForNotExistingTables.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
