# IO.Swagger.Api.DocumentServiceApi

All URIs are relative to *https://apicsdemo.teamsystem.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**ApiV1EnvironmentMGDocumentServiceDocprocessingstatusPost**](DocumentServiceApi.md#apiv1environmentmgdocumentservicedocprocessingstatuspost) | **POST** /api/v1/{environment}/MG/DocumentService/docprocessingstatus | Return Document processing status
[**ApiV1EnvironmentMGDocumentServiceMultiplecreatePost**](DocumentServiceApi.md#apiv1environmentmgdocumentservicemultiplecreatepost) | **POST** /api/v1/{environment}/MG/DocumentService/multiplecreate | Insert Multiple Documents for async process
[**ApiV1EnvironmentMGDocumentServiceMultiplecreatehistoryIdDelete**](DocumentServiceApi.md#apiv1environmentmgdocumentservicemultiplecreatehistoryiddelete) | **DELETE** /api/v1/{environment}/MG/DocumentService/multiplecreatehistory/{id} | Delete records for multiple insert documents by guid
[**ApiV1EnvironmentMGDocumentServiceMultiplecreatereprocessGuidPost**](DocumentServiceApi.md#apiv1environmentmgdocumentservicemultiplecreatereprocessguidpost) | **POST** /api/v1/{environment}/MG/DocumentService/multiplecreatereprocess/{guid} | Multiple Documents reprocess operations for async insert by guid
[**ApiV1EnvironmentMGDocumentServiceOrderavailabilityIdDelete**](DocumentServiceApi.md#apiv1environmentmgdocumentserviceorderavailabilityiddelete) | **DELETE** /api/v1/{environment}/MG/DocumentService/orderavailability/{id} | Delete record for async process portfolio orders
[**ApiV1EnvironmentMGDocumentServiceOrderavailabilityPost**](DocumentServiceApi.md#apiv1environmentmgdocumentserviceorderavailabilitypost) | **POST** /api/v1/{environment}/MG/DocumentService/orderavailability | Return Documents Order Portfolio
[**ApiV1EnvironmentMGDocumentServiceTransformPost**](DocumentServiceApi.md#apiv1environmentmgdocumentservicetransformpost) | **POST** /api/v1/{environment}/MG/DocumentService/transform | Document transformation based on the required parameters

<a name="apiv1environmentmgdocumentservicedocprocessingstatuspost"></a>
# **ApiV1EnvironmentMGDocumentServiceDocprocessingstatusPost**
> DocumentoStatoEvasoMGDTO ApiV1EnvironmentMGDocumentServiceDocprocessingstatusPost (SearchDTO body, string authorizationScope, string loadEntireDomain, string environment, string acceptLanguage = null, string getTotalCount = null, string company = null, string user = null)

Return Document processing status

Document processing status

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentMGDocumentServiceDocprocessingstatusPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new DocumentServiceApi();
            var body = new SearchDTO(); // SearchDTO | Search criteria to apply
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var loadEntireDomain = loadEntireDomain_example;  // string | Specify 'loadEntireDomain=true' if you want all the aggregate
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)
            var getTotalCount = getTotalCount_example;  // string | Specify 'getTotalCount=true' if you want the total number of elements (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Return Document processing status
                DocumentoStatoEvasoMGDTO result = apiInstance.ApiV1EnvironmentMGDocumentServiceDocprocessingstatusPost(body, authorizationScope, loadEntireDomain, environment, acceptLanguage, getTotalCount, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling DocumentServiceApi.ApiV1EnvironmentMGDocumentServiceDocprocessingstatusPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**SearchDTO**](SearchDTO.md)| Search criteria to apply | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **loadEntireDomain** | **string**| Specify &#x27;loadEntireDomain&#x3D;true&#x27; if you want all the aggregate | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]
 **getTotalCount** | **string**| Specify &#x27;getTotalCount&#x3D;true&#x27; if you want the total number of elements | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**DocumentoStatoEvasoMGDTO**](DocumentoStatoEvasoMGDTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentmgdocumentservicemultiplecreatepost"></a>
# **ApiV1EnvironmentMGDocumentServiceMultiplecreatePost**
> DocumentoTestataOutMGDTO ApiV1EnvironmentMGDocumentServiceMultiplecreatePost (List<GroupDocumentoTestataMGDTO> body, string authorizationScope, string environment, string acceptLanguage = null, string force = null, bool? withvalidpreconditions = null, string company = null, string user = null)

Insert Multiple Documents for async process

Document async multiple process

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentMGDocumentServiceMultiplecreatePostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new DocumentServiceApi();
            var body = new List<GroupDocumentoTestataMGDTO>(); // List<GroupDocumentoTestataMGDTO> | Object of type to create
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)
            var force = force_example;  // string | Force values (optional) 
            var withvalidpreconditions = true;  // bool? | Validate Preconditions (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Insert Multiple Documents for async process
                DocumentoTestataOutMGDTO result = apiInstance.ApiV1EnvironmentMGDocumentServiceMultiplecreatePost(body, authorizationScope, environment, acceptLanguage, force, withvalidpreconditions, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling DocumentServiceApi.ApiV1EnvironmentMGDocumentServiceMultiplecreatePost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**List&lt;GroupDocumentoTestataMGDTO&gt;**](GroupDocumentoTestataMGDTO.md)| Object of type to create | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]
 **force** | **string**| Force values | [optional] 
 **withvalidpreconditions** | **bool?**| Validate Preconditions | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**DocumentoTestataOutMGDTO**](DocumentoTestataOutMGDTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentmgdocumentservicemultiplecreatehistoryiddelete"></a>
# **ApiV1EnvironmentMGDocumentServiceMultiplecreatehistoryIdDelete**
> void ApiV1EnvironmentMGDocumentServiceMultiplecreatehistoryIdDelete (string id, string environment, string authorizationScope, string progress = null, string company = null, string user = null, string acceptLanguage = null)

Delete records for multiple insert documents by guid

Deleting object of type 

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentMGDocumentServiceMultiplecreatehistoryIdDeleteExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new DocumentServiceApi();
            var id = id_example;  // string | 
            var environment = environment_example;  // string | 
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var progress = progress_example;  // string | Force values (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)

            try
            {
                // Delete records for multiple insert documents by guid
                apiInstance.ApiV1EnvironmentMGDocumentServiceMultiplecreatehistoryIdDelete(id, environment, authorizationScope, progress, company, user, acceptLanguage);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling DocumentServiceApi.ApiV1EnvironmentMGDocumentServiceMultiplecreatehistoryIdDelete: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**|  | 
 **environment** | **string**|  | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **progress** | **string**| Force values | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]

### Return type

void (empty response body)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentmgdocumentservicemultiplecreatereprocessguidpost"></a>
# **ApiV1EnvironmentMGDocumentServiceMultiplecreatereprocessGuidPost**
> DocumentoTestataOutMGDTO ApiV1EnvironmentMGDocumentServiceMultiplecreatereprocessGuidPost (List<GroupDocumentoTestataMGDTO> body, string authorizationScope, string guid, string environment, string acceptLanguage = null, string force = null, bool? withvalidpreconditions = null, string company = null, string user = null)

Multiple Documents reprocess operations for async insert by guid

Document async multiple reprocess

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentMGDocumentServiceMultiplecreatereprocessGuidPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new DocumentServiceApi();
            var body = new List<GroupDocumentoTestataMGDTO>(); // List<GroupDocumentoTestataMGDTO> | Object of type to update
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var guid = guid_example;  // string | That's Guid Session MixMatch documents insert value
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)
            var force = force_example;  // string | Force values (optional) 
            var withvalidpreconditions = true;  // bool? | Validate Preconditions (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Multiple Documents reprocess operations for async insert by guid
                DocumentoTestataOutMGDTO result = apiInstance.ApiV1EnvironmentMGDocumentServiceMultiplecreatereprocessGuidPost(body, authorizationScope, guid, environment, acceptLanguage, force, withvalidpreconditions, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling DocumentServiceApi.ApiV1EnvironmentMGDocumentServiceMultiplecreatereprocessGuidPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**List&lt;GroupDocumentoTestataMGDTO&gt;**](GroupDocumentoTestataMGDTO.md)| Object of type to update | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **guid** | **string**| That&#x27;s Guid Session MixMatch documents insert value | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]
 **force** | **string**| Force values | [optional] 
 **withvalidpreconditions** | **bool?**| Validate Preconditions | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**DocumentoTestataOutMGDTO**](DocumentoTestataOutMGDTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentmgdocumentserviceorderavailabilityiddelete"></a>
# **ApiV1EnvironmentMGDocumentServiceOrderavailabilityIdDelete**
> void ApiV1EnvironmentMGDocumentServiceOrderavailabilityIdDelete (string id, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null)

Delete record for async process portfolio orders

Deleting object of type 

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentMGDocumentServiceOrderavailabilityIdDeleteExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new DocumentServiceApi();
            var id = id_example;  // string | 
            var environment = environment_example;  // string | 
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)

            try
            {
                // Delete record for async process portfolio orders
                apiInstance.ApiV1EnvironmentMGDocumentServiceOrderavailabilityIdDelete(id, environment, authorizationScope, company, user, acceptLanguage);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling DocumentServiceApi.ApiV1EnvironmentMGDocumentServiceOrderavailabilityIdDelete: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**|  | 
 **environment** | **string**|  | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]

### Return type

void (empty response body)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentmgdocumentserviceorderavailabilitypost"></a>
# **ApiV1EnvironmentMGDocumentServiceOrderavailabilityPost**
> DocumentoPortfolioEvadOrdineOutMGSetDTO ApiV1EnvironmentMGDocumentServiceOrderavailabilityPost (DocumentoPortfolioEvadInMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string force = null, string company = null, string user = null)

Return Documents Order Portfolio

Document processing status

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentMGDocumentServiceOrderavailabilityPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new DocumentServiceApi();
            var body = new DocumentoPortfolioEvadInMGDTO(); // DocumentoPortfolioEvadInMGDTO | Object of type to validate
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)
            var force = force_example;  // string | Force values (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Return Documents Order Portfolio
                DocumentoPortfolioEvadOrdineOutMGSetDTO result = apiInstance.ApiV1EnvironmentMGDocumentServiceOrderavailabilityPost(body, authorizationScope, environment, acceptLanguage, force, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling DocumentServiceApi.ApiV1EnvironmentMGDocumentServiceOrderavailabilityPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**DocumentoPortfolioEvadInMGDTO**](DocumentoPortfolioEvadInMGDTO.md)| Object of type to validate | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]
 **force** | **string**| Force values | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**DocumentoPortfolioEvadOrdineOutMGSetDTO**](DocumentoPortfolioEvadOrdineOutMGSetDTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentmgdocumentservicetransformpost"></a>
# **ApiV1EnvironmentMGDocumentServiceTransformPost**
> DocumentTransformationParameterDTO ApiV1EnvironmentMGDocumentServiceTransformPost (DocumentTransformationParameterDTO body, string authorizationScope, string environment, string acceptLanguage = null, string force = null, string company = null, string user = null)

Document transformation based on the required parameters

Document transformation based on the required parameters

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentMGDocumentServiceTransformPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new DocumentServiceApi();
            var body = new DocumentTransformationParameterDTO(); // DocumentTransformationParameterDTO | Document transformation parameters
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)
            var force = force_example;  // string | Force values (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Document transformation based on the required parameters
                DocumentTransformationParameterDTO result = apiInstance.ApiV1EnvironmentMGDocumentServiceTransformPost(body, authorizationScope, environment, acceptLanguage, force, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling DocumentServiceApi.ApiV1EnvironmentMGDocumentServiceTransformPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**DocumentTransformationParameterDTO**](DocumentTransformationParameterDTO.md)| Document transformation parameters | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]
 **force** | **string**| Force values | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**DocumentTransformationParameterDTO**](DocumentTransformationParameterDTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
