/* 
 * TSE Cloud - MG
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.3000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// CG28_TABCODIVA - Codice IVA&lt;br&gt;Proprietà chiave:&lt;ul&gt;&lt;li&gt;&lt;b&gt;Codice&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;
    /// </summary>
    [DataContract]
        public partial class VatCodeCODTO :  IEquatable<VatCodeCODTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="VatCodeCODTO" /> class.
        /// </summary>
        /// <param name="aliqivavent">CG28_ALIQIVAVENT - % acquisti in ventilazione.</param>
        /// <param name="annotazioni">CG28_ANNOTAZIONI - Annotazioni su fatture di vendita e sui registri IVA art.21 comma 6 DPR 633/72.</param>
        /// <param name="codice">CG28_CODICE - Codice aliquota (required).</param>
        /// <param name="codiceagr">CG28_CODICEAGR - Codice IVA per compensazione agricoltura.</param>
        /// <param name="codiceOss">CG28_OSSCOD_CG28 - Codice IVA correlato.</param>
        /// <param name="codPlafond">CG28_CODPLAFOND - Plafond&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No plafond&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Esportazioni art.8 1°c. a/b, 9 1°c.-Cessioni art.8 1°c. c,2°c.&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Acquisti interni art.8 2°c., 8 bis 2°c., 9 2°c.&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Importazioni art.8 2°c., 68 l.a, 8 bis, 9 2°c.&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Acquisti intracomunitari art. 42 1°c.&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Cessioni intracomunitarie art. 41 2°c.&lt;/li&gt;&lt;li&gt;&lt;i&gt;6&lt;/i&gt; - Cessioni art.8 bis, 1°c. (no lettera intento)&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="descrizione">CG28_DESCR - Descrizione (required).</param>
        /// <param name="flgAgri">CG28_FLGAGRI - Indicare se codice IVA utilizzato per agricoltura&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="flgAllclifor">CG28_FLGALLCLIFOR - Progressivi aliquota IVA inclusi negli allegati clienti fornitori&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="flgAssport398">CG28_FLGASSPORT398 - Soc. sportiva dilettantistica (L.398/91)&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="flgAutoue">CG28_FLGAUTOUE - Vendita auto UE L. 286&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="flgCorrVent">CG28_FLGCORRVENT - Aliquota IVA utilizzata per la registrazione dei corrispettivi da ventilare&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="flgEscludiblacklist">CG28_FLGESCLUDIBLACKLIST - Escludi da black list&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="flgImpostadibollo">CG28_FLGIMPOSTADIBOLLO - Imposta di bollo applicabile&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="flgIndet">CG28_FLGINDET - IVA indetraibile&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="flgIvaedit">CG28_FLGIVAEDIT - Indicare se codice IVA utilizzato per editoria&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Non movimentato&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Movimentato&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="flgMonofasersm">CG28_FLGMONOFASERSM - Monofase Repubblica di San Marino (default to 0).</param>
        /// <param name="flgMossgest">CG28_FLGMOSSGEST - One Stop Shop (OSS)&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="flgMossrid">CG28_FLGMOSSRID - Aliquota ridotta&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="flgNotvar">CG28_FLGNOTVAR - Indicare se codice IVA utilizzato per note variazioni IVA&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="flgSospimp">CG28_FLGSOSPIMP - IVA esigibilità differita&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Immediata&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Differita Enti Pubblici&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Differita altre società&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Enti pubblici Art.17-ter (Split Payment)&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="idprov">CG28_IDPROV - IdProv (Required only in PUT/PATCH).</param>
        /// <param name="impostamonofasersm">CG28_IMPOSTAMONOFASERSM - Importo imposta fissa.</param>
        /// <param name="indNatassoswCg2n">CG28_INDNATASSOSW_CG2N - Natura Assosoftware.</param>
        /// <param name="indNatura">CG28_INDNATURA - Natura.</param>
        /// <param name="indStaper">CG28_INDSTAPER - Standard/Pers.&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Standard&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Personalizzato&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="indtipopart">CG28_INDTIPOPART - Indtipopart&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - NessunValore&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Operazioni con IVA non esposta in fattura&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Operazioni imponibili (es.: reverse charge)&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="mosscodCg07">CG28_MOSSCOD_CG07 - Codice Stato.</param>
        /// <param name="mossperc">CG28_MOSSPERC - VAT rate (%).</param>
        /// <param name="note">CG28_NOTE - Note.</param>
        /// <param name="percforf">CG28_PERCFORF - % forfetizzazione editoria/agricoltura.</param>
        /// <param name="percindet">CG28_PERCINDET - % assoggettamento ad indetraibilità.</param>
        /// <param name="perciva">CG28_PERCIVA - % assoggettamento aliquota.</param>
        /// <param name="percmonofasersm">CG28_PERCMONOFASERSM - % Monofase.</param>
        /// <param name="rowVersion">CG28_ROWVERSION - RowVersion.</param>
        /// <param name="stdcodivarifCg28">CG28_STDCODIVARIF_CG28 - StdcodivarifCg28.</param>
        /// <param name="tipologia">CG28_TIPOLOGIA - Tipologia&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Imponibile&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Non imponibile&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Esente&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Escluso&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Fuori campo IVA&lt;/li&gt;&lt;/ul&gt; (default to 1).</param>
        /// <param name="verslynfa">CG28_VERSLYNFA - Verslynfa.</param>
        /// <param name="idExtendedAttributeEntity">idExtendedAttributeEntity.</param>
        /// <param name="idExtendedAttributeSubEntity">idExtendedAttributeSubEntity.</param>
        /// <param name="nationCO">nationCO.</param>
        /// <param name="natureAssCO">natureAssCO.</param>
        /// <param name="natureEsCO">natureEsCO.</param>
        /// <param name="vatCodeCOAgr">vatCodeCOAgr.</param>
        /// <param name="vatCodeCOAIRif">vatCodeCOAIRif.</param>
        /// <param name="vatCodeCOOss">vatCodeCOOss.</param>
        /// <param name="extensionData">extensionData.</param>
        /// <param name="additionalData">additionalData.</param>
        /// <param name="pluginData">pluginData.</param>
        public VatCodeCODTO(double? aliqivavent = default(double?), string annotazioni = default(string), string codice = default(string), string codiceagr = default(string), string codiceOss = default(string), double? codPlafond = 0, string descrizione = default(string), double? flgAgri = 0, double? flgAllclifor = 0, double? flgAssport398 = 0, double? flgAutoue = 0, double? flgCorrVent = 0, double? flgEscludiblacklist = 0, int? flgImpostadibollo = 0, double? flgIndet = 0, double? flgIvaedit = 0, double? flgMonofasersm = 0, int? flgMossgest = 0, int? flgMossrid = 0, double? flgNotvar = 0, double? flgSospimp = 0, double? idprov = default(double?), double? impostamonofasersm = default(double?), int? indNatassoswCg2n = default(int?), int? indNatura = default(int?), double? indStaper = default(double?), double? indtipopart = 0, double? mosscodCg07 = default(double?), double? mossperc = default(double?), string note = default(string), double? percforf = default(double?), double? percindet = default(double?), double? perciva = default(double?), double? percmonofasersm = default(double?), byte[] rowVersion = default(byte[]), string stdcodivarifCg28 = default(string), double? tipologia = 1, string verslynfa = default(string), int? idExtendedAttributeEntity = default(int?), int? idExtendedAttributeSubEntity = default(int?), NationCODTO nationCO = default(NationCODTO), NatureAssCODTO natureAssCO = default(NatureAssCODTO), NatureEsCODTO natureEsCO = default(NatureEsCODTO), VatCodeCODTO vatCodeCOAgr = default(VatCodeCODTO), VatCodeCODTO vatCodeCOAIRif = default(VatCodeCODTO), VatCodeCODTO vatCodeCOOss = default(VatCodeCODTO), List<StringObjectKeyValuePair> extensionData = default(List<StringObjectKeyValuePair>), Dictionary<string, Object> additionalData = default(Dictionary<string, Object>), Dictionary<string, Object> pluginData = default(Dictionary<string, Object>))
        {
            // to ensure "codice" is required (not null)
            if (codice == null)
            {
                throw new InvalidDataException("codice is a required property for VatCodeCODTO and cannot be null");
            }
            else
            {
                this.Codice = codice;
            }
            // to ensure "descrizione" is required (not null)
            if (descrizione == null)
            {
                throw new InvalidDataException("descrizione is a required property for VatCodeCODTO and cannot be null");
            }
            else
            {
                this.Descrizione = descrizione;
            }
            this.Aliqivavent = aliqivavent;
            this.Annotazioni = annotazioni;
            this.Codiceagr = codiceagr;
            this.CodiceOss = codiceOss;
            // use default value if no "codPlafond" provided
            if (codPlafond == null)
            {
                this.CodPlafond = 0;
            }
            else
            {
                this.CodPlafond = codPlafond;
            }
            // use default value if no "flgAgri" provided
            if (flgAgri == null)
            {
                this.FlgAgri = 0;
            }
            else
            {
                this.FlgAgri = flgAgri;
            }
            // use default value if no "flgAllclifor" provided
            if (flgAllclifor == null)
            {
                this.FlgAllclifor = 0;
            }
            else
            {
                this.FlgAllclifor = flgAllclifor;
            }
            // use default value if no "flgAssport398" provided
            if (flgAssport398 == null)
            {
                this.FlgAssport398 = 0;
            }
            else
            {
                this.FlgAssport398 = flgAssport398;
            }
            // use default value if no "flgAutoue" provided
            if (flgAutoue == null)
            {
                this.FlgAutoue = 0;
            }
            else
            {
                this.FlgAutoue = flgAutoue;
            }
            // use default value if no "flgCorrVent" provided
            if (flgCorrVent == null)
            {
                this.FlgCorrVent = 0;
            }
            else
            {
                this.FlgCorrVent = flgCorrVent;
            }
            // use default value if no "flgEscludiblacklist" provided
            if (flgEscludiblacklist == null)
            {
                this.FlgEscludiblacklist = 0;
            }
            else
            {
                this.FlgEscludiblacklist = flgEscludiblacklist;
            }
            // use default value if no "flgImpostadibollo" provided
            if (flgImpostadibollo == null)
            {
                this.FlgImpostadibollo = 0;
            }
            else
            {
                this.FlgImpostadibollo = flgImpostadibollo;
            }
            // use default value if no "flgIndet" provided
            if (flgIndet == null)
            {
                this.FlgIndet = 0;
            }
            else
            {
                this.FlgIndet = flgIndet;
            }
            // use default value if no "flgIvaedit" provided
            if (flgIvaedit == null)
            {
                this.FlgIvaedit = 0;
            }
            else
            {
                this.FlgIvaedit = flgIvaedit;
            }
            // use default value if no "flgMonofasersm" provided
            if (flgMonofasersm == null)
            {
                this.FlgMonofasersm = 0;
            }
            else
            {
                this.FlgMonofasersm = flgMonofasersm;
            }
            // use default value if no "flgMossgest" provided
            if (flgMossgest == null)
            {
                this.FlgMossgest = 0;
            }
            else
            {
                this.FlgMossgest = flgMossgest;
            }
            // use default value if no "flgMossrid" provided
            if (flgMossrid == null)
            {
                this.FlgMossrid = 0;
            }
            else
            {
                this.FlgMossrid = flgMossrid;
            }
            // use default value if no "flgNotvar" provided
            if (flgNotvar == null)
            {
                this.FlgNotvar = 0;
            }
            else
            {
                this.FlgNotvar = flgNotvar;
            }
            // use default value if no "flgSospimp" provided
            if (flgSospimp == null)
            {
                this.FlgSospimp = 0;
            }
            else
            {
                this.FlgSospimp = flgSospimp;
            }
            this.Idprov = idprov;
            this.Impostamonofasersm = impostamonofasersm;
            this.IndNatassoswCg2n = indNatassoswCg2n;
            this.IndNatura = indNatura;
            this.IndStaper = indStaper;
            // use default value if no "indtipopart" provided
            if (indtipopart == null)
            {
                this.Indtipopart = 0;
            }
            else
            {
                this.Indtipopart = indtipopart;
            }
            this.MosscodCg07 = mosscodCg07;
            this.Mossperc = mossperc;
            this.Note = note;
            this.Percforf = percforf;
            this.Percindet = percindet;
            this.Perciva = perciva;
            this.Percmonofasersm = percmonofasersm;
            this.RowVersion = rowVersion;
            this.StdcodivarifCg28 = stdcodivarifCg28;
            // use default value if no "tipologia" provided
            if (tipologia == null)
            {
                this.Tipologia = 1;
            }
            else
            {
                this.Tipologia = tipologia;
            }
            this.Verslynfa = verslynfa;
            this.IdExtendedAttributeEntity = idExtendedAttributeEntity;
            this.IdExtendedAttributeSubEntity = idExtendedAttributeSubEntity;
            this.NationCO = nationCO;
            this.NatureAssCO = natureAssCO;
            this.NatureEsCO = natureEsCO;
            this.VatCodeCOAgr = vatCodeCOAgr;
            this.VatCodeCOAIRif = vatCodeCOAIRif;
            this.VatCodeCOOss = vatCodeCOOss;
            this.ExtensionData = extensionData;
            this.AdditionalData = additionalData;
            this.PluginData = pluginData;
        }
        
        /// <summary>
        /// CG28_ALIQIVAVENT - % acquisti in ventilazione
        /// </summary>
        /// <value>CG28_ALIQIVAVENT - % acquisti in ventilazione</value>
        [DataMember(Name="aliqivavent", EmitDefaultValue=false)]
        public double? Aliqivavent { get; set; }

        /// <summary>
        /// CG28_ANNOTAZIONI - Annotazioni su fatture di vendita e sui registri IVA art.21 comma 6 DPR 633/72
        /// </summary>
        /// <value>CG28_ANNOTAZIONI - Annotazioni su fatture di vendita e sui registri IVA art.21 comma 6 DPR 633/72</value>
        [DataMember(Name="annotazioni", EmitDefaultValue=false)]
        public string Annotazioni { get; set; }

        /// <summary>
        /// CG28_CODICE - Codice aliquota
        /// </summary>
        /// <value>CG28_CODICE - Codice aliquota</value>
        [DataMember(Name="codice", EmitDefaultValue=false)]
        public string Codice { get; set; }

        /// <summary>
        /// CG28_CODICEAGR - Codice IVA per compensazione agricoltura
        /// </summary>
        /// <value>CG28_CODICEAGR - Codice IVA per compensazione agricoltura</value>
        [DataMember(Name="codiceagr", EmitDefaultValue=false)]
        public string Codiceagr { get; set; }

        /// <summary>
        /// CG28_OSSCOD_CG28 - Codice IVA correlato
        /// </summary>
        /// <value>CG28_OSSCOD_CG28 - Codice IVA correlato</value>
        [DataMember(Name="codiceOss", EmitDefaultValue=false)]
        public string CodiceOss { get; set; }

        /// <summary>
        /// CG28_CODPLAFOND - Plafond&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No plafond&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Esportazioni art.8 1°c. a/b, 9 1°c.-Cessioni art.8 1°c. c,2°c.&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Acquisti interni art.8 2°c., 8 bis 2°c., 9 2°c.&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Importazioni art.8 2°c., 68 l.a, 8 bis, 9 2°c.&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Acquisti intracomunitari art. 42 1°c.&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Cessioni intracomunitarie art. 41 2°c.&lt;/li&gt;&lt;li&gt;&lt;i&gt;6&lt;/i&gt; - Cessioni art.8 bis, 1°c. (no lettera intento)&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG28_CODPLAFOND - Plafond&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No plafond&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Esportazioni art.8 1°c. a/b, 9 1°c.-Cessioni art.8 1°c. c,2°c.&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Acquisti interni art.8 2°c., 8 bis 2°c., 9 2°c.&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Importazioni art.8 2°c., 68 l.a, 8 bis, 9 2°c.&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Acquisti intracomunitari art. 42 1°c.&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Cessioni intracomunitarie art. 41 2°c.&lt;/li&gt;&lt;li&gt;&lt;i&gt;6&lt;/i&gt; - Cessioni art.8 bis, 1°c. (no lettera intento)&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="codPlafond", EmitDefaultValue=false)]
        public double? CodPlafond { get; set; }

        /// <summary>
        /// CG28_DESCR - Descrizione
        /// </summary>
        /// <value>CG28_DESCR - Descrizione</value>
        [DataMember(Name="descrizione", EmitDefaultValue=false)]
        public string Descrizione { get; set; }

        /// <summary>
        /// CG28_FLGAGRI - Indicare se codice IVA utilizzato per agricoltura&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG28_FLGAGRI - Indicare se codice IVA utilizzato per agricoltura&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgAgri", EmitDefaultValue=false)]
        public double? FlgAgri { get; set; }

        /// <summary>
        /// CG28_FLGALLCLIFOR - Progressivi aliquota IVA inclusi negli allegati clienti fornitori&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG28_FLGALLCLIFOR - Progressivi aliquota IVA inclusi negli allegati clienti fornitori&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgAllclifor", EmitDefaultValue=false)]
        public double? FlgAllclifor { get; set; }

        /// <summary>
        /// CG28_FLGASSPORT398 - Soc. sportiva dilettantistica (L.398/91)&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG28_FLGASSPORT398 - Soc. sportiva dilettantistica (L.398/91)&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgAssport398", EmitDefaultValue=false)]
        public double? FlgAssport398 { get; set; }

        /// <summary>
        /// CG28_FLGAUTOUE - Vendita auto UE L. 286&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG28_FLGAUTOUE - Vendita auto UE L. 286&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgAutoue", EmitDefaultValue=false)]
        public double? FlgAutoue { get; set; }

        /// <summary>
        /// CG28_FLGCORRVENT - Aliquota IVA utilizzata per la registrazione dei corrispettivi da ventilare&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG28_FLGCORRVENT - Aliquota IVA utilizzata per la registrazione dei corrispettivi da ventilare&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgCorrVent", EmitDefaultValue=false)]
        public double? FlgCorrVent { get; set; }

        /// <summary>
        /// CG28_FLGESCLUDIBLACKLIST - Escludi da black list&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG28_FLGESCLUDIBLACKLIST - Escludi da black list&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgEscludiblacklist", EmitDefaultValue=false)]
        public double? FlgEscludiblacklist { get; set; }

        /// <summary>
        /// CG28_FLGIMPOSTADIBOLLO - Imposta di bollo applicabile&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG28_FLGIMPOSTADIBOLLO - Imposta di bollo applicabile&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgImpostadibollo", EmitDefaultValue=false)]
        public int? FlgImpostadibollo { get; set; }

        /// <summary>
        /// CG28_FLGINDET - IVA indetraibile&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG28_FLGINDET - IVA indetraibile&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgIndet", EmitDefaultValue=false)]
        public double? FlgIndet { get; set; }

        /// <summary>
        /// CG28_FLGIVAEDIT - Indicare se codice IVA utilizzato per editoria&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Non movimentato&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Movimentato&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG28_FLGIVAEDIT - Indicare se codice IVA utilizzato per editoria&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Non movimentato&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Movimentato&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgIvaedit", EmitDefaultValue=false)]
        public double? FlgIvaedit { get; set; }

        /// <summary>
        /// CG28_FLGMONOFASERSM - Monofase Repubblica di San Marino
        /// </summary>
        /// <value>CG28_FLGMONOFASERSM - Monofase Repubblica di San Marino</value>
        [DataMember(Name="flgMonofasersm", EmitDefaultValue=false)]
        public double? FlgMonofasersm { get; set; }

        /// <summary>
        /// CG28_FLGMOSSGEST - One Stop Shop (OSS)&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG28_FLGMOSSGEST - One Stop Shop (OSS)&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgMossgest", EmitDefaultValue=false)]
        public int? FlgMossgest { get; set; }

        /// <summary>
        /// CG28_FLGMOSSRID - Aliquota ridotta&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG28_FLGMOSSRID - Aliquota ridotta&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgMossrid", EmitDefaultValue=false)]
        public int? FlgMossrid { get; set; }

        /// <summary>
        /// CG28_FLGNOTVAR - Indicare se codice IVA utilizzato per note variazioni IVA&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG28_FLGNOTVAR - Indicare se codice IVA utilizzato per note variazioni IVA&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgNotvar", EmitDefaultValue=false)]
        public double? FlgNotvar { get; set; }

        /// <summary>
        /// CG28_FLGSOSPIMP - IVA esigibilità differita&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Immediata&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Differita Enti Pubblici&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Differita altre società&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Enti pubblici Art.17-ter (Split Payment)&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG28_FLGSOSPIMP - IVA esigibilità differita&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Immediata&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Differita Enti Pubblici&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Differita altre società&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Enti pubblici Art.17-ter (Split Payment)&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgSospimp", EmitDefaultValue=false)]
        public double? FlgSospimp { get; set; }

        /// <summary>
        /// CG28_IDPROV - IdProv (Required only in PUT/PATCH)
        /// </summary>
        /// <value>CG28_IDPROV - IdProv (Required only in PUT/PATCH)</value>
        [DataMember(Name="idprov", EmitDefaultValue=false)]
        public double? Idprov { get; set; }

        /// <summary>
        /// CG28_IMPOSTAMONOFASERSM - Importo imposta fissa
        /// </summary>
        /// <value>CG28_IMPOSTAMONOFASERSM - Importo imposta fissa</value>
        [DataMember(Name="impostamonofasersm", EmitDefaultValue=false)]
        public double? Impostamonofasersm { get; set; }

        /// <summary>
        /// CG28_INDNATASSOSW_CG2N - Natura Assosoftware
        /// </summary>
        /// <value>CG28_INDNATASSOSW_CG2N - Natura Assosoftware</value>
        [DataMember(Name="indNatassoswCg2n", EmitDefaultValue=false)]
        public int? IndNatassoswCg2n { get; set; }

        /// <summary>
        /// CG28_INDNATURA - Natura
        /// </summary>
        /// <value>CG28_INDNATURA - Natura</value>
        [DataMember(Name="indNatura", EmitDefaultValue=false)]
        public int? IndNatura { get; set; }

        /// <summary>
        /// CG28_INDSTAPER - Standard/Pers.&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Standard&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Personalizzato&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG28_INDSTAPER - Standard/Pers.&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Standard&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Personalizzato&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indStaper", EmitDefaultValue=false)]
        public double? IndStaper { get; set; }

        /// <summary>
        /// CG28_INDTIPOPART - Indtipopart&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - NessunValore&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Operazioni con IVA non esposta in fattura&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Operazioni imponibili (es.: reverse charge)&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG28_INDTIPOPART - Indtipopart&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - NessunValore&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Operazioni con IVA non esposta in fattura&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Operazioni imponibili (es.: reverse charge)&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indtipopart", EmitDefaultValue=false)]
        public double? Indtipopart { get; set; }

        /// <summary>
        /// CG28_MOSSCOD_CG07 - Codice Stato
        /// </summary>
        /// <value>CG28_MOSSCOD_CG07 - Codice Stato</value>
        [DataMember(Name="mosscodCg07", EmitDefaultValue=false)]
        public double? MosscodCg07 { get; set; }

        /// <summary>
        /// CG28_MOSSPERC - VAT rate (%)
        /// </summary>
        /// <value>CG28_MOSSPERC - VAT rate (%)</value>
        [DataMember(Name="mossperc", EmitDefaultValue=false)]
        public double? Mossperc { get; set; }

        /// <summary>
        /// CG28_NOTE - Note
        /// </summary>
        /// <value>CG28_NOTE - Note</value>
        [DataMember(Name="note", EmitDefaultValue=false)]
        public string Note { get; set; }

        /// <summary>
        /// CG28_PERCFORF - % forfetizzazione editoria/agricoltura
        /// </summary>
        /// <value>CG28_PERCFORF - % forfetizzazione editoria/agricoltura</value>
        [DataMember(Name="percforf", EmitDefaultValue=false)]
        public double? Percforf { get; set; }

        /// <summary>
        /// CG28_PERCINDET - % assoggettamento ad indetraibilità
        /// </summary>
        /// <value>CG28_PERCINDET - % assoggettamento ad indetraibilità</value>
        [DataMember(Name="percindet", EmitDefaultValue=false)]
        public double? Percindet { get; set; }

        /// <summary>
        /// CG28_PERCIVA - % assoggettamento aliquota
        /// </summary>
        /// <value>CG28_PERCIVA - % assoggettamento aliquota</value>
        [DataMember(Name="perciva", EmitDefaultValue=false)]
        public double? Perciva { get; set; }

        /// <summary>
        /// CG28_PERCMONOFASERSM - % Monofase
        /// </summary>
        /// <value>CG28_PERCMONOFASERSM - % Monofase</value>
        [DataMember(Name="percmonofasersm", EmitDefaultValue=false)]
        public double? Percmonofasersm { get; set; }

        /// <summary>
        /// CG28_ROWVERSION - RowVersion
        /// </summary>
        /// <value>CG28_ROWVERSION - RowVersion</value>
        [DataMember(Name="rowVersion", EmitDefaultValue=false)]
        public byte[] RowVersion { get; set; }

        /// <summary>
        /// CG28_STDCODIVARIF_CG28 - StdcodivarifCg28
        /// </summary>
        /// <value>CG28_STDCODIVARIF_CG28 - StdcodivarifCg28</value>
        [DataMember(Name="stdcodivarifCg28", EmitDefaultValue=false)]
        public string StdcodivarifCg28 { get; set; }

        /// <summary>
        /// CG28_TIPOLOGIA - Tipologia&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Imponibile&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Non imponibile&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Esente&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Escluso&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Fuori campo IVA&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG28_TIPOLOGIA - Tipologia&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Imponibile&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Non imponibile&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Esente&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Escluso&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Fuori campo IVA&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="tipologia", EmitDefaultValue=false)]
        public double? Tipologia { get; set; }

        /// <summary>
        /// CG28_VERSLYNFA - Verslynfa
        /// </summary>
        /// <value>CG28_VERSLYNFA - Verslynfa</value>
        [DataMember(Name="verslynfa", EmitDefaultValue=false)]
        public string Verslynfa { get; set; }

        /// <summary>
        /// Gets or Sets IdExtendedAttributeEntity
        /// </summary>
        [DataMember(Name="idExtendedAttributeEntity", EmitDefaultValue=false)]
        public int? IdExtendedAttributeEntity { get; set; }

        /// <summary>
        /// Gets or Sets IdExtendedAttributeSubEntity
        /// </summary>
        [DataMember(Name="idExtendedAttributeSubEntity", EmitDefaultValue=false)]
        public int? IdExtendedAttributeSubEntity { get; set; }

        /// <summary>
        /// Gets or Sets NationCO
        /// </summary>
        [DataMember(Name="nationCO", EmitDefaultValue=false)]
        public NationCODTO NationCO { get; set; }

        /// <summary>
        /// Gets or Sets NatureAssCO
        /// </summary>
        [DataMember(Name="natureAssCO", EmitDefaultValue=false)]
        public NatureAssCODTO NatureAssCO { get; set; }

        /// <summary>
        /// Gets or Sets NatureEsCO
        /// </summary>
        [DataMember(Name="natureEsCO", EmitDefaultValue=false)]
        public NatureEsCODTO NatureEsCO { get; set; }

        /// <summary>
        /// Gets or Sets VatCodeCOAgr
        /// </summary>
        [DataMember(Name="vatCodeCOAgr", EmitDefaultValue=false)]
        public VatCodeCODTO VatCodeCOAgr { get; set; }

        /// <summary>
        /// Gets or Sets VatCodeCOAIRif
        /// </summary>
        [DataMember(Name="vatCodeCOAIRif", EmitDefaultValue=false)]
        public VatCodeCODTO VatCodeCOAIRif { get; set; }

        /// <summary>
        /// Gets or Sets VatCodeCOOss
        /// </summary>
        [DataMember(Name="vatCodeCOOss", EmitDefaultValue=false)]
        public VatCodeCODTO VatCodeCOOss { get; set; }

        /// <summary>
        /// Gets or Sets ExtensionData
        /// </summary>
        [DataMember(Name="extensionData", EmitDefaultValue=false)]
        public List<StringObjectKeyValuePair> ExtensionData { get; set; }

        /// <summary>
        /// Gets or Sets AdditionalData
        /// </summary>
        [DataMember(Name="additionalData", EmitDefaultValue=false)]
        public Dictionary<string, Object> AdditionalData { get; set; }

        /// <summary>
        /// Gets or Sets PluginData
        /// </summary>
        [DataMember(Name="pluginData", EmitDefaultValue=false)]
        public Dictionary<string, Object> PluginData { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class VatCodeCODTO {\n");
            sb.Append("  Aliqivavent: ").Append(Aliqivavent).Append("\n");
            sb.Append("  Annotazioni: ").Append(Annotazioni).Append("\n");
            sb.Append("  Codice: ").Append(Codice).Append("\n");
            sb.Append("  Codiceagr: ").Append(Codiceagr).Append("\n");
            sb.Append("  CodiceOss: ").Append(CodiceOss).Append("\n");
            sb.Append("  CodPlafond: ").Append(CodPlafond).Append("\n");
            sb.Append("  Descrizione: ").Append(Descrizione).Append("\n");
            sb.Append("  FlgAgri: ").Append(FlgAgri).Append("\n");
            sb.Append("  FlgAllclifor: ").Append(FlgAllclifor).Append("\n");
            sb.Append("  FlgAssport398: ").Append(FlgAssport398).Append("\n");
            sb.Append("  FlgAutoue: ").Append(FlgAutoue).Append("\n");
            sb.Append("  FlgCorrVent: ").Append(FlgCorrVent).Append("\n");
            sb.Append("  FlgEscludiblacklist: ").Append(FlgEscludiblacklist).Append("\n");
            sb.Append("  FlgImpostadibollo: ").Append(FlgImpostadibollo).Append("\n");
            sb.Append("  FlgIndet: ").Append(FlgIndet).Append("\n");
            sb.Append("  FlgIvaedit: ").Append(FlgIvaedit).Append("\n");
            sb.Append("  FlgMonofasersm: ").Append(FlgMonofasersm).Append("\n");
            sb.Append("  FlgMossgest: ").Append(FlgMossgest).Append("\n");
            sb.Append("  FlgMossrid: ").Append(FlgMossrid).Append("\n");
            sb.Append("  FlgNotvar: ").Append(FlgNotvar).Append("\n");
            sb.Append("  FlgSospimp: ").Append(FlgSospimp).Append("\n");
            sb.Append("  Idprov: ").Append(Idprov).Append("\n");
            sb.Append("  Impostamonofasersm: ").Append(Impostamonofasersm).Append("\n");
            sb.Append("  IndNatassoswCg2n: ").Append(IndNatassoswCg2n).Append("\n");
            sb.Append("  IndNatura: ").Append(IndNatura).Append("\n");
            sb.Append("  IndStaper: ").Append(IndStaper).Append("\n");
            sb.Append("  Indtipopart: ").Append(Indtipopart).Append("\n");
            sb.Append("  MosscodCg07: ").Append(MosscodCg07).Append("\n");
            sb.Append("  Mossperc: ").Append(Mossperc).Append("\n");
            sb.Append("  Note: ").Append(Note).Append("\n");
            sb.Append("  Percforf: ").Append(Percforf).Append("\n");
            sb.Append("  Percindet: ").Append(Percindet).Append("\n");
            sb.Append("  Perciva: ").Append(Perciva).Append("\n");
            sb.Append("  Percmonofasersm: ").Append(Percmonofasersm).Append("\n");
            sb.Append("  RowVersion: ").Append(RowVersion).Append("\n");
            sb.Append("  StdcodivarifCg28: ").Append(StdcodivarifCg28).Append("\n");
            sb.Append("  Tipologia: ").Append(Tipologia).Append("\n");
            sb.Append("  Verslynfa: ").Append(Verslynfa).Append("\n");
            sb.Append("  IdExtendedAttributeEntity: ").Append(IdExtendedAttributeEntity).Append("\n");
            sb.Append("  IdExtendedAttributeSubEntity: ").Append(IdExtendedAttributeSubEntity).Append("\n");
            sb.Append("  NationCO: ").Append(NationCO).Append("\n");
            sb.Append("  NatureAssCO: ").Append(NatureAssCO).Append("\n");
            sb.Append("  NatureEsCO: ").Append(NatureEsCO).Append("\n");
            sb.Append("  VatCodeCOAgr: ").Append(VatCodeCOAgr).Append("\n");
            sb.Append("  VatCodeCOAIRif: ").Append(VatCodeCOAIRif).Append("\n");
            sb.Append("  VatCodeCOOss: ").Append(VatCodeCOOss).Append("\n");
            sb.Append("  ExtensionData: ").Append(ExtensionData).Append("\n");
            sb.Append("  AdditionalData: ").Append(AdditionalData).Append("\n");
            sb.Append("  PluginData: ").Append(PluginData).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as VatCodeCODTO);
        }

        /// <summary>
        /// Returns true if VatCodeCODTO instances are equal
        /// </summary>
        /// <param name="input">Instance of VatCodeCODTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(VatCodeCODTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.Aliqivavent == input.Aliqivavent ||
                    (this.Aliqivavent != null &&
                    this.Aliqivavent.Equals(input.Aliqivavent))
                ) && 
                (
                    this.Annotazioni == input.Annotazioni ||
                    (this.Annotazioni != null &&
                    this.Annotazioni.Equals(input.Annotazioni))
                ) && 
                (
                    this.Codice == input.Codice ||
                    (this.Codice != null &&
                    this.Codice.Equals(input.Codice))
                ) && 
                (
                    this.Codiceagr == input.Codiceagr ||
                    (this.Codiceagr != null &&
                    this.Codiceagr.Equals(input.Codiceagr))
                ) && 
                (
                    this.CodiceOss == input.CodiceOss ||
                    (this.CodiceOss != null &&
                    this.CodiceOss.Equals(input.CodiceOss))
                ) && 
                (
                    this.CodPlafond == input.CodPlafond ||
                    (this.CodPlafond != null &&
                    this.CodPlafond.Equals(input.CodPlafond))
                ) && 
                (
                    this.Descrizione == input.Descrizione ||
                    (this.Descrizione != null &&
                    this.Descrizione.Equals(input.Descrizione))
                ) && 
                (
                    this.FlgAgri == input.FlgAgri ||
                    (this.FlgAgri != null &&
                    this.FlgAgri.Equals(input.FlgAgri))
                ) && 
                (
                    this.FlgAllclifor == input.FlgAllclifor ||
                    (this.FlgAllclifor != null &&
                    this.FlgAllclifor.Equals(input.FlgAllclifor))
                ) && 
                (
                    this.FlgAssport398 == input.FlgAssport398 ||
                    (this.FlgAssport398 != null &&
                    this.FlgAssport398.Equals(input.FlgAssport398))
                ) && 
                (
                    this.FlgAutoue == input.FlgAutoue ||
                    (this.FlgAutoue != null &&
                    this.FlgAutoue.Equals(input.FlgAutoue))
                ) && 
                (
                    this.FlgCorrVent == input.FlgCorrVent ||
                    (this.FlgCorrVent != null &&
                    this.FlgCorrVent.Equals(input.FlgCorrVent))
                ) && 
                (
                    this.FlgEscludiblacklist == input.FlgEscludiblacklist ||
                    (this.FlgEscludiblacklist != null &&
                    this.FlgEscludiblacklist.Equals(input.FlgEscludiblacklist))
                ) && 
                (
                    this.FlgImpostadibollo == input.FlgImpostadibollo ||
                    (this.FlgImpostadibollo != null &&
                    this.FlgImpostadibollo.Equals(input.FlgImpostadibollo))
                ) && 
                (
                    this.FlgIndet == input.FlgIndet ||
                    (this.FlgIndet != null &&
                    this.FlgIndet.Equals(input.FlgIndet))
                ) && 
                (
                    this.FlgIvaedit == input.FlgIvaedit ||
                    (this.FlgIvaedit != null &&
                    this.FlgIvaedit.Equals(input.FlgIvaedit))
                ) && 
                (
                    this.FlgMonofasersm == input.FlgMonofasersm ||
                    (this.FlgMonofasersm != null &&
                    this.FlgMonofasersm.Equals(input.FlgMonofasersm))
                ) && 
                (
                    this.FlgMossgest == input.FlgMossgest ||
                    (this.FlgMossgest != null &&
                    this.FlgMossgest.Equals(input.FlgMossgest))
                ) && 
                (
                    this.FlgMossrid == input.FlgMossrid ||
                    (this.FlgMossrid != null &&
                    this.FlgMossrid.Equals(input.FlgMossrid))
                ) && 
                (
                    this.FlgNotvar == input.FlgNotvar ||
                    (this.FlgNotvar != null &&
                    this.FlgNotvar.Equals(input.FlgNotvar))
                ) && 
                (
                    this.FlgSospimp == input.FlgSospimp ||
                    (this.FlgSospimp != null &&
                    this.FlgSospimp.Equals(input.FlgSospimp))
                ) && 
                (
                    this.Idprov == input.Idprov ||
                    (this.Idprov != null &&
                    this.Idprov.Equals(input.Idprov))
                ) && 
                (
                    this.Impostamonofasersm == input.Impostamonofasersm ||
                    (this.Impostamonofasersm != null &&
                    this.Impostamonofasersm.Equals(input.Impostamonofasersm))
                ) && 
                (
                    this.IndNatassoswCg2n == input.IndNatassoswCg2n ||
                    (this.IndNatassoswCg2n != null &&
                    this.IndNatassoswCg2n.Equals(input.IndNatassoswCg2n))
                ) && 
                (
                    this.IndNatura == input.IndNatura ||
                    (this.IndNatura != null &&
                    this.IndNatura.Equals(input.IndNatura))
                ) && 
                (
                    this.IndStaper == input.IndStaper ||
                    (this.IndStaper != null &&
                    this.IndStaper.Equals(input.IndStaper))
                ) && 
                (
                    this.Indtipopart == input.Indtipopart ||
                    (this.Indtipopart != null &&
                    this.Indtipopart.Equals(input.Indtipopart))
                ) && 
                (
                    this.MosscodCg07 == input.MosscodCg07 ||
                    (this.MosscodCg07 != null &&
                    this.MosscodCg07.Equals(input.MosscodCg07))
                ) && 
                (
                    this.Mossperc == input.Mossperc ||
                    (this.Mossperc != null &&
                    this.Mossperc.Equals(input.Mossperc))
                ) && 
                (
                    this.Note == input.Note ||
                    (this.Note != null &&
                    this.Note.Equals(input.Note))
                ) && 
                (
                    this.Percforf == input.Percforf ||
                    (this.Percforf != null &&
                    this.Percforf.Equals(input.Percforf))
                ) && 
                (
                    this.Percindet == input.Percindet ||
                    (this.Percindet != null &&
                    this.Percindet.Equals(input.Percindet))
                ) && 
                (
                    this.Perciva == input.Perciva ||
                    (this.Perciva != null &&
                    this.Perciva.Equals(input.Perciva))
                ) && 
                (
                    this.Percmonofasersm == input.Percmonofasersm ||
                    (this.Percmonofasersm != null &&
                    this.Percmonofasersm.Equals(input.Percmonofasersm))
                ) && 
                (
                    this.RowVersion == input.RowVersion ||
                    (this.RowVersion != null &&
                    this.RowVersion.Equals(input.RowVersion))
                ) && 
                (
                    this.StdcodivarifCg28 == input.StdcodivarifCg28 ||
                    (this.StdcodivarifCg28 != null &&
                    this.StdcodivarifCg28.Equals(input.StdcodivarifCg28))
                ) && 
                (
                    this.Tipologia == input.Tipologia ||
                    (this.Tipologia != null &&
                    this.Tipologia.Equals(input.Tipologia))
                ) && 
                (
                    this.Verslynfa == input.Verslynfa ||
                    (this.Verslynfa != null &&
                    this.Verslynfa.Equals(input.Verslynfa))
                ) && 
                (
                    this.IdExtendedAttributeEntity == input.IdExtendedAttributeEntity ||
                    (this.IdExtendedAttributeEntity != null &&
                    this.IdExtendedAttributeEntity.Equals(input.IdExtendedAttributeEntity))
                ) && 
                (
                    this.IdExtendedAttributeSubEntity == input.IdExtendedAttributeSubEntity ||
                    (this.IdExtendedAttributeSubEntity != null &&
                    this.IdExtendedAttributeSubEntity.Equals(input.IdExtendedAttributeSubEntity))
                ) && 
                (
                    this.NationCO == input.NationCO ||
                    (this.NationCO != null &&
                    this.NationCO.Equals(input.NationCO))
                ) && 
                (
                    this.NatureAssCO == input.NatureAssCO ||
                    (this.NatureAssCO != null &&
                    this.NatureAssCO.Equals(input.NatureAssCO))
                ) && 
                (
                    this.NatureEsCO == input.NatureEsCO ||
                    (this.NatureEsCO != null &&
                    this.NatureEsCO.Equals(input.NatureEsCO))
                ) && 
                (
                    this.VatCodeCOAgr == input.VatCodeCOAgr ||
                    (this.VatCodeCOAgr != null &&
                    this.VatCodeCOAgr.Equals(input.VatCodeCOAgr))
                ) && 
                (
                    this.VatCodeCOAIRif == input.VatCodeCOAIRif ||
                    (this.VatCodeCOAIRif != null &&
                    this.VatCodeCOAIRif.Equals(input.VatCodeCOAIRif))
                ) && 
                (
                    this.VatCodeCOOss == input.VatCodeCOOss ||
                    (this.VatCodeCOOss != null &&
                    this.VatCodeCOOss.Equals(input.VatCodeCOOss))
                ) && 
                (
                    this.ExtensionData == input.ExtensionData ||
                    this.ExtensionData != null &&
                    input.ExtensionData != null &&
                    this.ExtensionData.SequenceEqual(input.ExtensionData)
                ) && 
                (
                    this.AdditionalData == input.AdditionalData ||
                    this.AdditionalData != null &&
                    input.AdditionalData != null &&
                    this.AdditionalData.SequenceEqual(input.AdditionalData)
                ) && 
                (
                    this.PluginData == input.PluginData ||
                    this.PluginData != null &&
                    input.PluginData != null &&
                    this.PluginData.SequenceEqual(input.PluginData)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.Aliqivavent != null)
                    hashCode = hashCode * 59 + this.Aliqivavent.GetHashCode();
                if (this.Annotazioni != null)
                    hashCode = hashCode * 59 + this.Annotazioni.GetHashCode();
                if (this.Codice != null)
                    hashCode = hashCode * 59 + this.Codice.GetHashCode();
                if (this.Codiceagr != null)
                    hashCode = hashCode * 59 + this.Codiceagr.GetHashCode();
                if (this.CodiceOss != null)
                    hashCode = hashCode * 59 + this.CodiceOss.GetHashCode();
                if (this.CodPlafond != null)
                    hashCode = hashCode * 59 + this.CodPlafond.GetHashCode();
                if (this.Descrizione != null)
                    hashCode = hashCode * 59 + this.Descrizione.GetHashCode();
                if (this.FlgAgri != null)
                    hashCode = hashCode * 59 + this.FlgAgri.GetHashCode();
                if (this.FlgAllclifor != null)
                    hashCode = hashCode * 59 + this.FlgAllclifor.GetHashCode();
                if (this.FlgAssport398 != null)
                    hashCode = hashCode * 59 + this.FlgAssport398.GetHashCode();
                if (this.FlgAutoue != null)
                    hashCode = hashCode * 59 + this.FlgAutoue.GetHashCode();
                if (this.FlgCorrVent != null)
                    hashCode = hashCode * 59 + this.FlgCorrVent.GetHashCode();
                if (this.FlgEscludiblacklist != null)
                    hashCode = hashCode * 59 + this.FlgEscludiblacklist.GetHashCode();
                if (this.FlgImpostadibollo != null)
                    hashCode = hashCode * 59 + this.FlgImpostadibollo.GetHashCode();
                if (this.FlgIndet != null)
                    hashCode = hashCode * 59 + this.FlgIndet.GetHashCode();
                if (this.FlgIvaedit != null)
                    hashCode = hashCode * 59 + this.FlgIvaedit.GetHashCode();
                if (this.FlgMonofasersm != null)
                    hashCode = hashCode * 59 + this.FlgMonofasersm.GetHashCode();
                if (this.FlgMossgest != null)
                    hashCode = hashCode * 59 + this.FlgMossgest.GetHashCode();
                if (this.FlgMossrid != null)
                    hashCode = hashCode * 59 + this.FlgMossrid.GetHashCode();
                if (this.FlgNotvar != null)
                    hashCode = hashCode * 59 + this.FlgNotvar.GetHashCode();
                if (this.FlgSospimp != null)
                    hashCode = hashCode * 59 + this.FlgSospimp.GetHashCode();
                if (this.Idprov != null)
                    hashCode = hashCode * 59 + this.Idprov.GetHashCode();
                if (this.Impostamonofasersm != null)
                    hashCode = hashCode * 59 + this.Impostamonofasersm.GetHashCode();
                if (this.IndNatassoswCg2n != null)
                    hashCode = hashCode * 59 + this.IndNatassoswCg2n.GetHashCode();
                if (this.IndNatura != null)
                    hashCode = hashCode * 59 + this.IndNatura.GetHashCode();
                if (this.IndStaper != null)
                    hashCode = hashCode * 59 + this.IndStaper.GetHashCode();
                if (this.Indtipopart != null)
                    hashCode = hashCode * 59 + this.Indtipopart.GetHashCode();
                if (this.MosscodCg07 != null)
                    hashCode = hashCode * 59 + this.MosscodCg07.GetHashCode();
                if (this.Mossperc != null)
                    hashCode = hashCode * 59 + this.Mossperc.GetHashCode();
                if (this.Note != null)
                    hashCode = hashCode * 59 + this.Note.GetHashCode();
                if (this.Percforf != null)
                    hashCode = hashCode * 59 + this.Percforf.GetHashCode();
                if (this.Percindet != null)
                    hashCode = hashCode * 59 + this.Percindet.GetHashCode();
                if (this.Perciva != null)
                    hashCode = hashCode * 59 + this.Perciva.GetHashCode();
                if (this.Percmonofasersm != null)
                    hashCode = hashCode * 59 + this.Percmonofasersm.GetHashCode();
                if (this.RowVersion != null)
                    hashCode = hashCode * 59 + this.RowVersion.GetHashCode();
                if (this.StdcodivarifCg28 != null)
                    hashCode = hashCode * 59 + this.StdcodivarifCg28.GetHashCode();
                if (this.Tipologia != null)
                    hashCode = hashCode * 59 + this.Tipologia.GetHashCode();
                if (this.Verslynfa != null)
                    hashCode = hashCode * 59 + this.Verslynfa.GetHashCode();
                if (this.IdExtendedAttributeEntity != null)
                    hashCode = hashCode * 59 + this.IdExtendedAttributeEntity.GetHashCode();
                if (this.IdExtendedAttributeSubEntity != null)
                    hashCode = hashCode * 59 + this.IdExtendedAttributeSubEntity.GetHashCode();
                if (this.NationCO != null)
                    hashCode = hashCode * 59 + this.NationCO.GetHashCode();
                if (this.NatureAssCO != null)
                    hashCode = hashCode * 59 + this.NatureAssCO.GetHashCode();
                if (this.NatureEsCO != null)
                    hashCode = hashCode * 59 + this.NatureEsCO.GetHashCode();
                if (this.VatCodeCOAgr != null)
                    hashCode = hashCode * 59 + this.VatCodeCOAgr.GetHashCode();
                if (this.VatCodeCOAIRif != null)
                    hashCode = hashCode * 59 + this.VatCodeCOAIRif.GetHashCode();
                if (this.VatCodeCOOss != null)
                    hashCode = hashCode * 59 + this.VatCodeCOOss.GetHashCode();
                if (this.ExtensionData != null)
                    hashCode = hashCode * 59 + this.ExtensionData.GetHashCode();
                if (this.AdditionalData != null)
                    hashCode = hashCode * 59 + this.AdditionalData.GetHashCode();
                if (this.PluginData != null)
                    hashCode = hashCode * 59 + this.PluginData.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
