# IO.Swagger.Api.IEExportMGApi

All URIs are relative to *https://apicsdemo.teamsystem.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**ApiV1EnvironmentMGIEExportMGDocumentPost**](IEExportMGApi.md#apiv1environmentmgieexportmgdocumentpost) | **POST** /api/v1/{environment}/MG/IEExportMG/document | Export Documents based on the required parameters

<a name="apiv1environmentmgieexportmgdocumentpost"></a>
# **ApiV1EnvironmentMGIEExportMGDocumentPost**
> ImportExportResultDTO ApiV1EnvironmentMGIEExportMGDocumentPost (ExportDocumentMGParameterDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)

Export Documents based on the required parameters

Export Documents based on the required parameters

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentMGIEExportMGDocumentPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new IEExportMGApi();
            var body = new ExportDocumentMGParameterDTO(); // ExportDocumentMGParameterDTO | Export Documents parameters
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Export Documents based on the required parameters
                ImportExportResultDTO result = apiInstance.ApiV1EnvironmentMGIEExportMGDocumentPost(body, authorizationScope, environment, acceptLanguage, acceptTerritory, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling IEExportMGApi.ApiV1EnvironmentMGIEExportMGDocumentPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**ExportDocumentMGParameterDTO**](ExportDocumentMGParameterDTO.md)| Export Documents parameters | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**ImportExportResultDTO**](ImportExportResultDTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
