# IO.Swagger - the C# library for the TSE Cloud - MG

This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).

This C# SDK is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: v2025.3000
- SDK version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.dotnet.CSharpClientCodegen
    For more information, please visit [https://mysupport.teamsystem.com/](https://mysupport.teamsystem.com/)

<a name="frameworks-supported"></a>
## Frameworks supported
- .NET 4.7.1 or later

<a name="dependencies"></a>
## Dependencies
- [RestSharp](https://www.nuget.org/packages/RestSharp) - 111.4.1 or later
- [Json.NET](https://www.nuget.org/packages/Newtonsoft.Json/) - 7.0.0 or later
- [JsonSubTypes](https://www.nuget.org/packages/JsonSubTypes/) - 1.2.0 or later

The DLLs included in the package may not be the latest version. We recommend using [NuGet](https://docs.nuget.org/consume/installing-nuget) to obtain the latest version of the packages:
```
Install-Package RestSharp
Install-Package Newtonsoft.Json
Install-Package JsonSubTypes
```

NOTE: RestSharp versions greater than 105.1.0 have a bug which causes file uploads to fail. See [RestSharp#742](https://github.com/restsharp/RestSharp/issues/742)

<a name="installation"></a>
## Installation

Run the following commands to generate the DLL
```
cd src/IO.Swagger
dotnet restore
dotnet build
```

Then include the DLL (under the `bin` folder) in the C# project, and use the namespaces:
```csharp
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;
```

<a name="packaging"></a>
## Packaging

A `.nuspec` is included with the project. You can follow the Nuget quickstart to [create](https://docs.microsoft.com/en-us/nuget/quickstart/create-and-publish-a-package#create-the-package) and [publish](https://docs.microsoft.com/en-us/nuget/quickstart/create-and-publish-a-package#publish-the-package) packages.

This `.nuspec` uses placeholders from the `.csproj`, so build the `.csproj` directly:

```
nuget pack -Build -OutputDirectory out IO.Swagger.csproj
```

Then, publish to a [local feed](https://docs.microsoft.com/en-us/nuget/hosting-packages/local-feeds) or [other host](https://docs.microsoft.com/en-us/nuget/hosting-packages/overview) and consume the new package via Nuget as usual.


<a name="getting-started"></a>
## Getting Started

```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class Example
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CarrierMGApi();
            var op = op_example;  // string | The value must be 'new'
            var param = param_example;  // string | Specify optional parameters that will be used during entity creation
            var environment = environment_example;  // string | 
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)

            try
            {
                // Get new
                CarrierMGDTO result = apiInstance.ApiV1EnvironmentMGCarrierMGGet(op, param, environment, authorizationScope, company, user, acceptLanguage, acceptTerritory);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CarrierMGApi.ApiV1EnvironmentMGCarrierMGGet: " + e.Message );
            }
        }
    }
}
```

<a name="documentation-for-api-endpoints"></a>
## Documentation for API Endpoints

All URIs are relative to *https://apicsdemo.teamsystem.io*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CarrierMGApi* | [**ApiV1EnvironmentMGCarrierMGGet**](docs/CarrierMGApi.md#apiv1environmentmgcarriermgget) | **GET** /api/v1/{environment}/MG/CarrierMG | Get new
*CarrierMGApi* | [**ApiV1EnvironmentMGCarrierMGIdDelete**](docs/CarrierMGApi.md#apiv1environmentmgcarriermgiddelete) | **DELETE** /api/v1/{environment}/MG/CarrierMG/{id} | Delete
*CarrierMGApi* | [**ApiV1EnvironmentMGCarrierMGIdGet**](docs/CarrierMGApi.md#apiv1environmentmgcarriermgidget) | **GET** /api/v1/{environment}/MG/CarrierMG/{id} | Get by ID
*CarrierMGApi* | [**ApiV1EnvironmentMGCarrierMGIdPatch**](docs/CarrierMGApi.md#apiv1environmentmgcarriermgidpatch) | **PATCH** /api/v1/{environment}/MG/CarrierMG/{id} | Update partial
*CarrierMGApi* | [**ApiV1EnvironmentMGCarrierMGIdPut**](docs/CarrierMGApi.md#apiv1environmentmgcarriermgidput) | **PUT** /api/v1/{environment}/MG/CarrierMG/{id} | Update
*CarrierMGApi* | [**ApiV1EnvironmentMGCarrierMGPost**](docs/CarrierMGApi.md#apiv1environmentmgcarriermgpost) | **POST** /api/v1/{environment}/MG/CarrierMG | Create
*CarrierMGApi* | [**ApiV1EnvironmentMGCarrierMGValidatePost**](docs/CarrierMGApi.md#apiv1environmentmgcarriermgvalidatepost) | **POST** /api/v1/{environment}/MG/CarrierMG/validate | Validate
*CarrierMGApi* | [**ApiV1EnvironmentMGCarrierMGValidatePropertiesPost**](docs/CarrierMGApi.md#apiv1environmentmgcarriermgvalidatepropertiespost) | **POST** /api/v1/{environment}/MG/CarrierMG/validateProperties | Validation of one on more properties of Type
*CompanyDocumentMasterDataMGApi* | [**ApiV1EnvironmentMGCompanyDocumentMasterDataMGGet**](docs/CompanyDocumentMasterDataMGApi.md#apiv1environmentmgcompanydocumentmasterdatamgget) | **GET** /api/v1/{environment}/MG/CompanyDocumentMasterDataMG | Get new
*CompanyDocumentMasterDataMGApi* | [**ApiV1EnvironmentMGCompanyDocumentMasterDataMGIdEnablementwizardGet**](docs/CompanyDocumentMasterDataMGApi.md#apiv1environmentmgcompanydocumentmasterdatamgidenablementwizardget) | **GET** /api/v1/{environment}/MG/CompanyDocumentMasterDataMG/{id}/enablementwizard | Service to view the guided authorizations based on the Document Wizard.
*CompanyDocumentMasterDataMGApi* | [**ApiV1EnvironmentMGCompanyDocumentMasterDataMGIdGet**](docs/CompanyDocumentMasterDataMGApi.md#apiv1environmentmgcompanydocumentmasterdatamgidget) | **GET** /api/v1/{environment}/MG/CompanyDocumentMasterDataMG/{id} | Get by ID
*CompanyDocumentMasterDataMGApi* | [**ApiV1EnvironmentMGCompanyDocumentMasterDataMGValidatePost**](docs/CompanyDocumentMasterDataMGApi.md#apiv1environmentmgcompanydocumentmasterdatamgvalidatepost) | **POST** /api/v1/{environment}/MG/CompanyDocumentMasterDataMG/validate | Validate
*CompanyDocumentMasterDataMGApi* | [**ApiV1EnvironmentMGCompanyDocumentMasterDataMGValidatePropertiesPost**](docs/CompanyDocumentMasterDataMGApi.md#apiv1environmentmgcompanydocumentmasterdatamgvalidatepropertiespost) | **POST** /api/v1/{environment}/MG/CompanyDocumentMasterDataMG/validateProperties | Validation of one on more properties of Type
*CustomerSupplierExtensionMGApi* | [**ApiV1EnvironmentMGCustomerSupplierExtensionMGIdGet**](docs/CustomerSupplierExtensionMGApi.md#apiv1environmentmgcustomersupplierextensionmgidget) | **GET** /api/v1/{environment}/MG/CustomerSupplierExtensionMG/{id} | Get by ID
*CustomerSupplierExtensionMGApi* | [**ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPatch**](docs/CustomerSupplierExtensionMGApi.md#apiv1environmentmgcustomersupplierextensionmgidpatch) | **PATCH** /api/v1/{environment}/MG/CustomerSupplierExtensionMG/{id} | Update partial
*CustomerSupplierExtensionMGApi* | [**ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPut**](docs/CustomerSupplierExtensionMGApi.md#apiv1environmentmgcustomersupplierextensionmgidput) | **PUT** /api/v1/{environment}/MG/CustomerSupplierExtensionMG/{id} | Update
*CustomerSupplierExtensionMGApi* | [**ApiV1EnvironmentMGCustomerSupplierExtensionMGValidatePost**](docs/CustomerSupplierExtensionMGApi.md#apiv1environmentmgcustomersupplierextensionmgvalidatepost) | **POST** /api/v1/{environment}/MG/CustomerSupplierExtensionMG/validate | Validate
*CustomerSupplierMGApi* | [**ApiV1EnvironmentMGCustomerSupplierMGGet**](docs/CustomerSupplierMGApi.md#apiv1environmentmgcustomersuppliermgget) | **GET** /api/v1/{environment}/MG/CustomerSupplierMG | Get new
*CustomerSupplierMGApi* | [**ApiV1EnvironmentMGCustomerSupplierMGIdGet**](docs/CustomerSupplierMGApi.md#apiv1environmentmgcustomersuppliermgidget) | **GET** /api/v1/{environment}/MG/CustomerSupplierMG/{id} | Get by ID
*CustomerSupplierMGApi* | [**ApiV1EnvironmentMGCustomerSupplierMGValidatePost**](docs/CustomerSupplierMGApi.md#apiv1environmentmgcustomersuppliermgvalidatepost) | **POST** /api/v1/{environment}/MG/CustomerSupplierMG/validate | Validate
*CustomerSupplierMGApi* | [**ApiV1EnvironmentMGCustomerSupplierMGValidatePropertiesPost**](docs/CustomerSupplierMGApi.md#apiv1environmentmgcustomersuppliermgvalidatepropertiespost) | **POST** /api/v1/{environment}/MG/CustomerSupplierMG/validateProperties | Validation of one on more properties of Type
*DocumentServiceApi* | [**ApiV1EnvironmentMGDocumentServiceDocprocessingstatusPost**](docs/DocumentServiceApi.md#apiv1environmentmgdocumentservicedocprocessingstatuspost) | **POST** /api/v1/{environment}/MG/DocumentService/docprocessingstatus | Return Document processing status
*DocumentServiceApi* | [**ApiV1EnvironmentMGDocumentServiceMultiplecreatePost**](docs/DocumentServiceApi.md#apiv1environmentmgdocumentservicemultiplecreatepost) | **POST** /api/v1/{environment}/MG/DocumentService/multiplecreate | Insert Multiple Documents for async process
*DocumentServiceApi* | [**ApiV1EnvironmentMGDocumentServiceMultiplecreatehistoryIdDelete**](docs/DocumentServiceApi.md#apiv1environmentmgdocumentservicemultiplecreatehistoryiddelete) | **DELETE** /api/v1/{environment}/MG/DocumentService/multiplecreatehistory/{id} | Delete records for multiple insert documents by guid
*DocumentServiceApi* | [**ApiV1EnvironmentMGDocumentServiceMultiplecreatereprocessGuidPost**](docs/DocumentServiceApi.md#apiv1environmentmgdocumentservicemultiplecreatereprocessguidpost) | **POST** /api/v1/{environment}/MG/DocumentService/multiplecreatereprocess/{guid} | Multiple Documents reprocess operations for async insert by guid
*DocumentServiceApi* | [**ApiV1EnvironmentMGDocumentServiceOrderavailabilityIdDelete**](docs/DocumentServiceApi.md#apiv1environmentmgdocumentserviceorderavailabilityiddelete) | **DELETE** /api/v1/{environment}/MG/DocumentService/orderavailability/{id} | Delete record for async process portfolio orders
*DocumentServiceApi* | [**ApiV1EnvironmentMGDocumentServiceOrderavailabilityPost**](docs/DocumentServiceApi.md#apiv1environmentmgdocumentserviceorderavailabilitypost) | **POST** /api/v1/{environment}/MG/DocumentService/orderavailability | Return Documents Order Portfolio
*DocumentServiceApi* | [**ApiV1EnvironmentMGDocumentServiceTransformPost**](docs/DocumentServiceApi.md#apiv1environmentmgdocumentservicetransformpost) | **POST** /api/v1/{environment}/MG/DocumentService/transform | Document transformation based on the required parameters
*DocumentoApi* | [**ApiV1EnvironmentMGDocumentoGet**](docs/DocumentoApi.md#apiv1environmentmgdocumentoget) | **GET** /api/v1/{environment}/MG/Documento | Get new
*DocumentoApi* | [**ApiV1EnvironmentMGDocumentoIdCheckcustomercreditGet**](docs/DocumentoApi.md#apiv1environmentmgdocumentoidcheckcustomercreditget) | **GET** /api/v1/{environment}/MG/Documento/{id}/checkcustomercredit | Check the Customer Credit
*DocumentoApi* | [**ApiV1EnvironmentMGDocumentoIdDelete**](docs/DocumentoApi.md#apiv1environmentmgdocumentoiddelete) | **DELETE** /api/v1/{environment}/MG/Documento/{id} | Delete the document having Numreg equals to {ID}
*DocumentoApi* | [**ApiV1EnvironmentMGDocumentoIdGet**](docs/DocumentoApi.md#apiv1environmentmgdocumentoidget) | **GET** /api/v1/{environment}/MG/Documento/{id} | Get the document having Numreg equals to {ID}
*DocumentoApi* | [**ApiV1EnvironmentMGDocumentoIdPrintGet**](docs/DocumentoApi.md#apiv1environmentmgdocumentoidprintget) | **GET** /api/v1/{environment}/MG/Documento/{id}/print | Get by ID with print document
*DocumentoApi* | [**ApiV1EnvironmentMGDocumentoIdPrintReportnameGet**](docs/DocumentoApi.md#apiv1environmentmgdocumentoidprintreportnameget) | **GET** /api/v1/{environment}/MG/Documento/{id}/print/reportname | Get list of report names usable for the document
*DocumentoApi* | [**ApiV1EnvironmentMGDocumentoIdPut**](docs/DocumentoApi.md#apiv1environmentmgdocumentoidput) | **PUT** /api/v1/{environment}/MG/Documento/{id} | Update the document having Numreg equals to {ID}
*DocumentoApi* | [**ApiV1EnvironmentMGDocumentoPost**](docs/DocumentoApi.md#apiv1environmentmgdocumentopost) | **POST** /api/v1/{environment}/MG/Documento | Create
*GiacenzaMGApi* | [**ApiV1EnvironmentMGGiacenzaMGDisponibilitaPost**](docs/GiacenzaMGApi.md#apiv1environmentmggiacenzamgdisponibilitapost) | **POST** /api/v1/{environment}/MG/GiacenzaMG/disponibilita | Calculate stock availability based on the required parameters
*GiacenzaMGApi* | [**ApiV1EnvironmentMGGiacenzaMGRicalcologiacenzaPost**](docs/GiacenzaMGApi.md#apiv1environmentmggiacenzamgricalcologiacenzapost) | **POST** /api/v1/{environment}/MG/GiacenzaMG/ricalcologiacenza | Recalculate the stock based on the required parameters
*GiacenzaMGApi* | [**ApiV1EnvironmentMGGiacenzaMGValidatePost**](docs/GiacenzaMGApi.md#apiv1environmentmggiacenzamgvalidatepost) | **POST** /api/v1/{environment}/MG/GiacenzaMG/validate | Validate
*IEExportMGApi* | [**ApiV1EnvironmentMGIEExportMGDocumentPost**](docs/IEExportMGApi.md#apiv1environmentmgieexportmgdocumentpost) | **POST** /api/v1/{environment}/MG/IEExportMG/document | Export Documents based on the required parameters
*IEImportMGApi* | [**ApiV1EnvironmentMGIEImportMGDocumentPost**](docs/IEImportMGApi.md#apiv1environmentmgieimportmgdocumentpost) | **POST** /api/v1/{environment}/MG/IEImportMG/document | Import Documents based on the required parameters
*KitDocumentServiceApi* | [**ApiV1EnvironmentMGKitDocumentServiceLoadkitPost**](docs/KitDocumentServiceApi.md#apiv1environmentmgkitdocumentserviceloadkitpost) | **POST** /api/v1/{environment}/MG/KitDocumentService/loadkit | Creation of component unloading documents from loading documents based on the required parameters
*KitDocumentServiceApi* | [**ApiV1EnvironmentMGKitDocumentServiceUnloadcompPost**](docs/KitDocumentServiceApi.md#apiv1environmentmgkitdocumentserviceunloadcomppost) | **POST** /api/v1/{environment}/MG/KitDocumentService/unloadcomp | Creation of component unloading documents from loading documents based on the required parameters
*RecipientMGApi* | [**ApiV1EnvironmentMGRecipientMGGet**](docs/RecipientMGApi.md#apiv1environmentmgrecipientmgget) | **GET** /api/v1/{environment}/MG/RecipientMG | Get new
*RecipientMGApi* | [**ApiV1EnvironmentMGRecipientMGIdDelete**](docs/RecipientMGApi.md#apiv1environmentmgrecipientmgiddelete) | **DELETE** /api/v1/{environment}/MG/RecipientMG/{id} | Delete
*RecipientMGApi* | [**ApiV1EnvironmentMGRecipientMGIdGet**](docs/RecipientMGApi.md#apiv1environmentmgrecipientmgidget) | **GET** /api/v1/{environment}/MG/RecipientMG/{id} | Get by ID
*RecipientMGApi* | [**ApiV1EnvironmentMGRecipientMGIdPatch**](docs/RecipientMGApi.md#apiv1environmentmgrecipientmgidpatch) | **PATCH** /api/v1/{environment}/MG/RecipientMG/{id} | Update partial
*RecipientMGApi* | [**ApiV1EnvironmentMGRecipientMGIdPut**](docs/RecipientMGApi.md#apiv1environmentmgrecipientmgidput) | **PUT** /api/v1/{environment}/MG/RecipientMG/{id} | Update
*RecipientMGApi* | [**ApiV1EnvironmentMGRecipientMGPost**](docs/RecipientMGApi.md#apiv1environmentmgrecipientmgpost) | **POST** /api/v1/{environment}/MG/RecipientMG | Create
*RecipientMGApi* | [**ApiV1EnvironmentMGRecipientMGValidatePost**](docs/RecipientMGApi.md#apiv1environmentmgrecipientmgvalidatepost) | **POST** /api/v1/{environment}/MG/RecipientMG/validate | Validate
*RecipientMGApi* | [**ApiV1EnvironmentMGRecipientMGValidatePropertiesPost**](docs/RecipientMGApi.md#apiv1environmentmgrecipientmgvalidatepropertiespost) | **POST** /api/v1/{environment}/MG/RecipientMG/validateProperties | Validation of one on more properties of Type
*SpesaVariaMGApi* | [**ApiV1EnvironmentMGSpesaVariaMGGet**](docs/SpesaVariaMGApi.md#apiv1environmentmgspesavariamgget) | **GET** /api/v1/{environment}/MG/SpesaVariaMG | Get new
*SpesaVariaMGApi* | [**ApiV1EnvironmentMGSpesaVariaMGIdDelete**](docs/SpesaVariaMGApi.md#apiv1environmentmgspesavariamgiddelete) | **DELETE** /api/v1/{environment}/MG/SpesaVariaMG/{id} | Delete
*SpesaVariaMGApi* | [**ApiV1EnvironmentMGSpesaVariaMGIdGet**](docs/SpesaVariaMGApi.md#apiv1environmentmgspesavariamgidget) | **GET** /api/v1/{environment}/MG/SpesaVariaMG/{id} | Get by ID
*SpesaVariaMGApi* | [**ApiV1EnvironmentMGSpesaVariaMGIdPatch**](docs/SpesaVariaMGApi.md#apiv1environmentmgspesavariamgidpatch) | **PATCH** /api/v1/{environment}/MG/SpesaVariaMG/{id} | Update partial
*SpesaVariaMGApi* | [**ApiV1EnvironmentMGSpesaVariaMGIdPut**](docs/SpesaVariaMGApi.md#apiv1environmentmgspesavariamgidput) | **PUT** /api/v1/{environment}/MG/SpesaVariaMG/{id} | Update
*SpesaVariaMGApi* | [**ApiV1EnvironmentMGSpesaVariaMGPost**](docs/SpesaVariaMGApi.md#apiv1environmentmgspesavariamgpost) | **POST** /api/v1/{environment}/MG/SpesaVariaMG | Create
*SpesaVariaMGApi* | [**ApiV1EnvironmentMGSpesaVariaMGValidatePost**](docs/SpesaVariaMGApi.md#apiv1environmentmgspesavariamgvalidatepost) | **POST** /api/v1/{environment}/MG/SpesaVariaMG/validate | Validate
*SpesaVariaMGApi* | [**ApiV1EnvironmentMGSpesaVariaMGValidatePropertiesPost**](docs/SpesaVariaMGApi.md#apiv1environmentmgspesavariamgvalidatepropertiespost) | **POST** /api/v1/{environment}/MG/SpesaVariaMG/validateProperties | Validation of one on more properties of Type
*TransportReasonMGApi* | [**ApiV1EnvironmentMGTransportReasonMGGet**](docs/TransportReasonMGApi.md#apiv1environmentmgtransportreasonmgget) | **GET** /api/v1/{environment}/MG/TransportReasonMG | Get new
*TransportReasonMGApi* | [**ApiV1EnvironmentMGTransportReasonMGIdGet**](docs/TransportReasonMGApi.md#apiv1environmentmgtransportreasonmgidget) | **GET** /api/v1/{environment}/MG/TransportReasonMG/{id} | Get by ID
*TransportReasonMGApi* | [**ApiV1EnvironmentMGTransportReasonMGValidatePost**](docs/TransportReasonMGApi.md#apiv1environmentmgtransportreasonmgvalidatepost) | **POST** /api/v1/{environment}/MG/TransportReasonMG/validate | Validate
*TransportReasonMGApi* | [**ApiV1EnvironmentMGTransportReasonMGValidatePropertiesPost**](docs/TransportReasonMGApi.md#apiv1environmentmgtransportreasonmgvalidatepropertiespost) | **POST** /api/v1/{environment}/MG/TransportReasonMG/validateProperties | Validation of one on more properties of Type

<a name="documentation-for-models"></a>
## Documentation for Models

 - [Model.AddressCODTO](docs/AddressCODTO.md)
 - [Model.AddressTypeCODTO](docs/AddressTypeCODTO.md)
 - [Model.AreaCODTO](docs/AreaCODTO.md)
 - [Model.BatchDataWHDTO](docs/BatchDataWHDTO.md)
 - [Model.BlockLevelCODTO](docs/BlockLevelCODTO.md)
 - [Model.COAAccountCustomizationFIDTO](docs/COAAccountCustomizationFIDTO.md)
 - [Model.COAAccountFIDTO](docs/COAAccountFIDTO.md)
 - [Model.COAAccountProposalFIDTO](docs/COAAccountProposalFIDTO.md)
 - [Model.COAAccountStateFIDTO](docs/COAAccountStateFIDTO.md)
 - [Model.COAGroupCodeFIDTO](docs/COAGroupCodeFIDTO.md)
 - [Model.COAInternationalCustomizationFIDTO](docs/COAInternationalCustomizationFIDTO.md)
 - [Model.CalcolaDisponibilitaParams](docs/CalcolaDisponibilitaParams.md)
 - [Model.CarrierMGDTO](docs/CarrierMGDTO.md)
 - [Model.CategoryCODTO](docs/CategoryCODTO.md)
 - [Model.CliForDatiAccompagnamentoMGDTO](docs/CliForDatiAccompagnamentoMGDTO.md)
 - [Model.CliForNotaMGDTO](docs/CliForNotaMGDTO.md)
 - [Model.CompanyDocumentMasterDataMGDTO](docs/CompanyDocumentMasterDataMGDTO.md)
 - [Model.CurrencyCODTO](docs/CurrencyCODTO.md)
 - [Model.CustSuppClassificationMGDTO](docs/CustSuppClassificationMGDTO.md)
 - [Model.CustomerCreditResultDTO](docs/CustomerCreditResultDTO.md)
 - [Model.CustomerSupplierExtensionMGDTO](docs/CustomerSupplierExtensionMGDTO.md)
 - [Model.CustomerSupplierMGDTO](docs/CustomerSupplierMGDTO.md)
 - [Model.DMSPublishedEntityFWDTO](docs/DMSPublishedEntityFWDTO.md)
 - [Model.DocumPortfolioEvaMGDTO](docs/DocumPortfolioEvaMGDTO.md)
 - [Model.DocumentEnablementWizardResultDTO](docs/DocumentEnablementWizardResultDTO.md)
 - [Model.DocumentHeaderCallOptionsDTO](docs/DocumentHeaderCallOptionsDTO.md)
 - [Model.DocumentMasterCODTO](docs/DocumentMasterCODTO.md)
 - [Model.DocumentReportDTO](docs/DocumentReportDTO.md)
 - [Model.DocumentReportListResultDTO](docs/DocumentReportListResultDTO.md)
 - [Model.DocumentTransfomationDocDestParamsDTO](docs/DocumentTransfomationDocDestParamsDTO.md)
 - [Model.DocumentTransformationGeneralDataDTO](docs/DocumentTransformationGeneralDataDTO.md)
 - [Model.DocumentTransformationParameterDTO](docs/DocumentTransformationParameterDTO.md)
 - [Model.DocumentTransformationPartialEvadContainerGeneralDataDTO](docs/DocumentTransformationPartialEvadContainerGeneralDataDTO.md)
 - [Model.DocumentTransformationProcessExtremLimitDTO](docs/DocumentTransformationProcessExtremLimitDTO.md)
 - [Model.DocumentoDatiAccompagnamentoMGDTO](docs/DocumentoDatiAccompagnamentoMGDTO.md)
 - [Model.DocumentoPortfolioEvadInMGDTO](docs/DocumentoPortfolioEvadInMGDTO.md)
 - [Model.DocumentoPortfolioEvadOrdineOutMGSetDTO](docs/DocumentoPortfolioEvadOrdineOutMGSetDTO.md)
 - [Model.DocumentoRigaCOINMGDTO](docs/DocumentoRigaCOINMGDTO.md)
 - [Model.DocumentoRigaConfMGDTO](docs/DocumentoRigaConfMGDTO.md)
 - [Model.DocumentoRigaEstesaMGDTO](docs/DocumentoRigaEstesaMGDTO.md)
 - [Model.DocumentoRigaIntraMGDTO](docs/DocumentoRigaIntraMGDTO.md)
 - [Model.DocumentoRigaLottoMGDTO](docs/DocumentoRigaLottoMGDTO.md)
 - [Model.DocumentoRigaMGDTO](docs/DocumentoRigaMGDTO.md)
 - [Model.DocumentoRigaOrdineMGDTO](docs/DocumentoRigaOrdineMGDTO.md)
 - [Model.DocumentoRigaPersonalizzataMGDTO](docs/DocumentoRigaPersonalizzataMGDTO.md)
 - [Model.DocumentoRigaProgettiMGDTO](docs/DocumentoRigaProgettiMGDTO.md)
 - [Model.DocumentoRigaProvvigioniMGDTO](docs/DocumentoRigaProvvigioniMGDTO.md)
 - [Model.DocumentoRigaRateiMGDTO](docs/DocumentoRigaRateiMGDTO.md)
 - [Model.DocumentoRigaRiferimentoMGDTO](docs/DocumentoRigaRiferimentoMGDTO.md)
 - [Model.DocumentoStatoEvasoCorpoRifMGDTO](docs/DocumentoStatoEvasoCorpoRifMGDTO.md)
 - [Model.DocumentoStatoEvasoMGDTO](docs/DocumentoStatoEvasoMGDTO.md)
 - [Model.DocumentoTestataAgentiMGDTO](docs/DocumentoTestataAgentiMGDTO.md)
 - [Model.DocumentoTestataEstesaMGDTO](docs/DocumentoTestataEstesaMGDTO.md)
 - [Model.DocumentoTestataMGDTO](docs/DocumentoTestataMGDTO.md)
 - [Model.DocumentoTestataOrdiniMGDTO](docs/DocumentoTestataOrdiniMGDTO.md)
 - [Model.DocumentoTestataOutMGDTO](docs/DocumentoTestataOutMGDTO.md)
 - [Model.DocumentoTestataPersonalizzataMGDTO](docs/DocumentoTestataPersonalizzataMGDTO.md)
 - [Model.DocumentoTestataProgettiMGDTO](docs/DocumentoTestataProgettiMGDTO.md)
 - [Model.DocumentoTestataProvvigioniMGDTO](docs/DocumentoTestataProvvigioniMGDTO.md)
 - [Model.DocumentoTestataRateiMGDTO](docs/DocumentoTestataRateiMGDTO.md)
 - [Model.ExchangeRateCODTO](docs/ExchangeRateCODTO.md)
 - [Model.ExportDocumentMGAddParameterDTO](docs/ExportDocumentMGAddParameterDTO.md)
 - [Model.ExportDocumentMGParameterDTO](docs/ExportDocumentMGParameterDTO.md)
 - [Model.FederalStateViewCODTO](docs/FederalStateViewCODTO.md)
 - [Model.FiltroDispArticolo](docs/FiltroDispArticolo.md)
 - [Model.ForeignPaymentCodeCODTO](docs/ForeignPaymentCodeCODTO.md)
 - [Model.GLReverseTypeFIDTO](docs/GLReverseTypeFIDTO.md)
 - [Model.GeneralMasterDataCODTO](docs/GeneralMasterDataCODTO.md)
 - [Model.GiacenzaMGDTO](docs/GiacenzaMGDTO.md)
 - [Model.GroupDocumentoTestataMGDTO](docs/GroupDocumentoTestataMGDTO.md)
 - [Model.Grouping1CODTO](docs/Grouping1CODTO.md)
 - [Model.Grouping2CODTO](docs/Grouping2CODTO.md)
 - [Model.Grouping3CODTO](docs/Grouping3CODTO.md)
 - [Model.HeadingReferenceDocumentMGDTO](docs/HeadingReferenceDocumentMGDTO.md)
 - [Model.ImportDocumentMGAddParameterDTO](docs/ImportDocumentMGAddParameterDTO.md)
 - [Model.ImportDocumentMGParameterDTO](docs/ImportDocumentMGParameterDTO.md)
 - [Model.ImportExportHeadResultDTO](docs/ImportExportHeadResultDTO.md)
 - [Model.ImportExportResultDTO](docs/ImportExportResultDTO.md)
 - [Model.ImportExportRowResultDTO](docs/ImportExportRowResultDTO.md)
 - [Model.IntragroupStructureCODTO](docs/IntragroupStructureCODTO.md)
 - [Model.KitDocumentResultDTO](docs/KitDocumentResultDTO.md)
 - [Model.KitLoadProductParameterDTO](docs/KitLoadProductParameterDTO.md)
 - [Model.KitUnloadComponentParameterDTO](docs/KitUnloadComponentParameterDTO.md)
 - [Model.LanguageCODTO](docs/LanguageCODTO.md)
 - [Model.LoadProductKitParameterDTO](docs/LoadProductKitParameterDTO.md)
 - [Model.LocationWHDTO](docs/LocationWHDTO.md)
 - [Model.LotMovParameterWHDTO](docs/LotMovParameterWHDTO.md)
 - [Model.MacroAreaCODTO](docs/MacroAreaCODTO.md)
 - [Model.MacroCategoryCODTO](docs/MacroCategoryCODTO.md)
 - [Model.NationCODTO](docs/NationCODTO.md)
 - [Model.NatureAssCODTO](docs/NatureAssCODTO.md)
 - [Model.NatureEsCODTO](docs/NatureEsCODTO.md)
 - [Model.OfficeCODTO](docs/OfficeCODTO.md)
 - [Model.OneOfSearchGroupDTOItemsItems](docs/OneOfSearchGroupDTOItemsItems.md)
 - [Model.PaymentTermCODTO](docs/PaymentTermCODTO.md)
 - [Model.PaymentTermDetailCODTO](docs/PaymentTermDetailCODTO.md)
 - [Model.PriceListWithMultipleItemsMGDTO](docs/PriceListWithMultipleItemsMGDTO.md)
 - [Model.RaggruppamentoCliForMGDTO](docs/RaggruppamentoCliForMGDTO.md)
 - [Model.RecipientMGDTO](docs/RecipientMGDTO.md)
 - [Model.RicalcoloGiacenzaParams](docs/RicalcoloGiacenzaParams.md)
 - [Model.RiskMGDTO](docs/RiskMGDTO.md)
 - [Model.SalePurchasePriceListCodeMGDTO](docs/SalePurchasePriceListCodeMGDTO.md)
 - [Model.SearchDTO](docs/SearchDTO.md)
 - [Model.SearchElementDTO](docs/SearchElementDTO.md)
 - [Model.SearchGroupDTO](docs/SearchGroupDTO.md)
 - [Model.SearchNodeDTO](docs/SearchNodeDTO.md)
 - [Model.SearchNodeValueDTO](docs/SearchNodeValueDTO.md)
 - [Model.SpesaVariaMGDTO](docs/SpesaVariaMGDTO.md)
 - [Model.StatoAttualeDTO](docs/StatoAttualeDTO.md)
 - [Model.StatoDTO](docs/StatoDTO.md)
 - [Model.StorageWHDTO](docs/StorageWHDTO.md)
 - [Model.StringObjectKeyValuePair](docs/StringObjectKeyValuePair.md)
 - [Model.SubCategoryCODTO](docs/SubCategoryCODTO.md)
 - [Model.SubTypeCODTO](docs/SubTypeCODTO.md)
 - [Model.TestoFissoMGDTO](docs/TestoFissoMGDTO.md)
 - [Model.TotaleDocumentoMGDTO](docs/TotaleDocumentoMGDTO.md)
 - [Model.TransportReasonMGDTO](docs/TransportReasonMGDTO.md)
 - [Model.UnloadComponentKitParameterDTO](docs/UnloadComponentKitParameterDTO.md)
 - [Model.VATTypeFIDTO](docs/VATTypeFIDTO.md)
 - [Model.ValidateDTO](docs/ValidateDTO.md)
 - [Model.ValidationResultDTO](docs/ValidationResultDTO.md)
 - [Model.VatCodeCODTO](docs/VatCodeCODTO.md)
 - [Model.WTCodeCODTO](docs/WTCodeCODTO.md)
 - [Model.ZoneCODTO](docs/ZoneCODTO.md)

<a name="documentation-for-authorization"></a>
## Documentation for Authorization

<a name="Basic"></a>
### Basic

- **Type**: HTTP basic authentication

<a name="Bearer"></a>
### Bearer


