'use strict';


/**
 * Get new
 * Get an empty object of type corresponding
 *
 * _op String The value must be 'new'
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Example for multilanguage (optional)
 * returns OfficeCODTO
 **/
exports.apiV1EnvironmentCOOfficeCOGET = function(_op,environment,authorizationScope,company,user,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "indIrizzo" : "indIrizzo",
  "idmediaCg99" : 6.607129449620165,
  "codice" : 8.036294790673514,
  "indDimcentrocomm" : 7.886583288201395,
  "extensionData" : [ null, null ],
  "cap" : "cap",
  "dittaCg18" : 8.310924482277276,
  "progRea" : 1.4793631642421967,
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "prov" : "prov",
  "numerorea" : "numerorea",
  "citta" : "citta",
  "rowversion" : ""
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Delete
 * Deleting object of type 
 *
 * id String 
 * environment String 
 * dittaCg18 String DittaCg18 Mandatory to execute current action
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Example for multilanguage (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOOfficeCOIdDELETE = function(id,environment,dittaCg18,authorizationScope,company,user,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Get by ID
 * Get an object of type corresponding the requested id
 *
 * id String Id to get the object
 * environment String 
 * dittaCg18 String DittaCg18 Mandatory to execute current action
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * dlevel String Serialization level (optional)
 * dlevelkey String Serialization level key (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Example for multilanguage (optional)
 * returns OfficeCODTO
 **/
exports.apiV1EnvironmentCOOfficeCOIdGET = function(id,environment,dittaCg18,authorizationScope,dlevel,dlevelkey,company,user,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "indIrizzo" : "indIrizzo",
  "idmediaCg99" : 6.607129449620165,
  "codice" : 8.036294790673514,
  "indDimcentrocomm" : 7.886583288201395,
  "extensionData" : [ null, null ],
  "cap" : "cap",
  "dittaCg18" : 8.310924482277276,
  "progRea" : 1.4793631642421967,
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "prov" : "prov",
  "numerorea" : "numerorea",
  "citta" : "citta",
  "rowversion" : ""
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Update partial
 * Patching an object of type
 *
 * body  Object of type to patch
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request (optional)
 * dittaCg18 String DittaCg18 Mandatory to execute current action
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOOfficeCOIdPATCH = function(body,force,_op,dittaCg18,company,user,id,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Update
 * Updating an object of type
 *
 * body OfficeCODTO Object of type to update
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request, otherwise will be returned null value (optional)
 * dittaCg18 String DittaCg18 Mandatory to execute current action
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * returns OfficeCODTO
 **/
exports.apiV1EnvironmentCOOfficeCOIdPUT = function(body,force,_op,dittaCg18,company,user,id,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "indIrizzo" : "indIrizzo",
  "idmediaCg99" : 6.607129449620165,
  "codice" : 8.036294790673514,
  "indDimcentrocomm" : 7.886583288201395,
  "extensionData" : [ null, null ],
  "cap" : "cap",
  "dittaCg18" : 8.310924482277276,
  "progRea" : 1.4793631642421967,
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "prov" : "prov",
  "numerorea" : "numerorea",
  "citta" : "citta",
  "rowversion" : ""
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Create
 * Creating new object of type
 *
 * body OfficeCODTO Object of type to create
 * dittaCg18 String DittaCg18 Mandatory to execute current action
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * returns OfficeCODTO
 **/
exports.apiV1EnvironmentCOOfficeCOPOST = function(body,dittaCg18,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "indIrizzo" : "indIrizzo",
  "idmediaCg99" : 6.607129449620165,
  "codice" : 8.036294790673514,
  "indDimcentrocomm" : 7.886583288201395,
  "extensionData" : [ null, null ],
  "cap" : "cap",
  "dittaCg18" : 8.310924482277276,
  "progRea" : 1.4793631642421967,
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "prov" : "prov",
  "numerorea" : "numerorea",
  "citta" : "citta",
  "rowversion" : ""
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Validate
 * Validation of object of type
 *
 * body OfficeCODTO Object of type to validate
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOOfficeCOValidatePOST = function(body,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Validation of one on more properties of Type
 * Validation of object of type
 *
 * body String  - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED<br> - The id of an existing object to validate properties, or '' if the object does not exist yet <br> (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * returns ValidateDTO
 **/
exports.apiV1EnvironmentCOOfficeCOValidatePropertiesPOST = function(body,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "items" : [ {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  }, {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  } ],
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ]
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}

