'use strict';


/**
 * Calculate the sum of the percentages
 * Calculate the sum of the percentages
 *
 * body PaymentTermDetailCOParametersDTO Parameters of the request
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns PaymentTermDetailCalculationResultCODTO
 **/
exports.apiV1EnvironmentCOPaymentTermCOCalculate_sumPOST = function(body,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "sumImp" : 0.8008281904610115,
  "sumIva" : 6.027456183070403,
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  }
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Get new
 * Get an empty object of type corresponding
 *
 * _op String The value must be 'new'
 * param String Specify optional parameters that will be used during entity creation
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns PaymentTermCODTO
 **/
exports.apiV1EnvironmentCOPaymentTermCOGET = function(_op,param,environment,authorizationScope,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "flgDesc" : 0.4833312865174044,
  "paymentTermDetailCO" : [ {
    "indImpfix" : 2.9805393113464476,
    "daggfix1" : 5.6644160867523485,
    "daggfix2" : 1.5970080735609526,
    "ggmmfix" : 7.3718573971919445,
    "ggdecor" : 9.785002165136461,
    "idCg64" : 4,
    "imporfix" : 3.209082285545927,
    "flgFrperciva" : 3.2841216543560217,
    "idCg62" : 1,
    "pluginData" : {
      "key" : ""
    },
    "id" : 9,
    "additionalData" : {
      "key" : ""
    },
    "el2friva" : 3.8008573585058016,
    "indTipocalend" : 9,
    "indTipodecor" : 4.010300976654761,
    "aggfix2" : 3.812761638325517,
    "aggfix1" : 1.2555055362323109,
    "perciva" : 6.458262756685686,
    "el2frimp" : 5.974942028545841,
    "ggscadfix2" : 7.92839742024475,
    "tipoeff" : 8.910869026866926,
    "flgFrpercimp" : 1.0639121808530916,
    "percimp" : 8.276461147928103,
    "prog" : 4.141296055235948,
    "el1frimp" : 4.372688051310086,
    "codPagCg62" : "codPagCg62",
    "ggscadfix1" : 7.726998920545485,
    "subTypeCO" : {
      "ggoffset" : 2.9679475177256287,
      "codiceCg07" : 2.058822123984536,
      "tipoeff" : 7.3842318535314,
      "codPaguc" : "codPaguc",
      "descstipo" : "descstipo",
      "codStipoeff" : 6.4280627569296165,
      "flgAssegno" : 0,
      "indModfatturapa" : 0,
      "foreignPaymentCodeCO" : {
        "flgIbanobbl" : 6,
        "descrpag" : "descrpag",
        "codIso" : "codIso",
        "codice" : "codice",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 5,
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "el1friva" : 5.7911894223693885,
    "indDatarif" : 8.262795412896967,
    "rowversion" : ""
  }, {
    "indImpfix" : 2.9805393113464476,
    "daggfix1" : 5.6644160867523485,
    "daggfix2" : 1.5970080735609526,
    "ggmmfix" : 7.3718573971919445,
    "ggdecor" : 9.785002165136461,
    "idCg64" : 4,
    "imporfix" : 3.209082285545927,
    "flgFrperciva" : 3.2841216543560217,
    "idCg62" : 1,
    "pluginData" : {
      "key" : ""
    },
    "id" : 9,
    "additionalData" : {
      "key" : ""
    },
    "el2friva" : 3.8008573585058016,
    "indTipocalend" : 9,
    "indTipodecor" : 4.010300976654761,
    "aggfix2" : 3.812761638325517,
    "aggfix1" : 1.2555055362323109,
    "perciva" : 6.458262756685686,
    "el2frimp" : 5.974942028545841,
    "ggscadfix2" : 7.92839742024475,
    "tipoeff" : 8.910869026866926,
    "flgFrpercimp" : 1.0639121808530916,
    "percimp" : 8.276461147928103,
    "prog" : 4.141296055235948,
    "el1frimp" : 4.372688051310086,
    "codPagCg62" : "codPagCg62",
    "ggscadfix1" : 7.726998920545485,
    "subTypeCO" : {
      "ggoffset" : 2.9679475177256287,
      "codiceCg07" : 2.058822123984536,
      "tipoeff" : 7.3842318535314,
      "codPaguc" : "codPaguc",
      "descstipo" : "descstipo",
      "codStipoeff" : 6.4280627569296165,
      "flgAssegno" : 0,
      "indModfatturapa" : 0,
      "foreignPaymentCodeCO" : {
        "flgIbanobbl" : 6,
        "descrpag" : "descrpag",
        "codIso" : "codIso",
        "codice" : "codice",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 5,
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "el1friva" : 5.7911894223693885,
    "indDatarif" : 8.262795412896967,
    "rowversion" : ""
  } ],
  "codPag" : "codPag",
  "desPagAnal" : "desPagAnal",
  "flgDisgg" : 0.35262192099236644,
  "flgPrefpass" : 4,
  "idExtendedAttributeSubEntity" : 1,
  "flgPrefatt" : 7,
  "flgStornoiva" : 2.7977867356748476,
  "descPag" : "descPag",
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ],
  "scpermer2" : 6.966044574347761,
  "pluginData" : {
    "key" : ""
  },
  "id" : 9,
  "scpercas" : 6.173804034172511,
  "scpermer1" : 4.8789878742268815,
  "additionalData" : {
    "key" : ""
  },
  "scpercart26" : 2.535258963197524,
  "idExtendedAttributeEntity" : 9,
  "rowversion" : "",
  "scart26" : 0.58919091925136
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Retrieve the payment term from code
 * Retrieve the payment term from code
 *
 * body CodePaymentTermCOParametersDTO Input parameters
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns PaymentTermCODTO
 **/
exports.apiV1EnvironmentCOPaymentTermCOGet_from_codePOST = function(body,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "flgDesc" : 0.4833312865174044,
  "paymentTermDetailCO" : [ {
    "indImpfix" : 2.9805393113464476,
    "daggfix1" : 5.6644160867523485,
    "daggfix2" : 1.5970080735609526,
    "ggmmfix" : 7.3718573971919445,
    "ggdecor" : 9.785002165136461,
    "idCg64" : 4,
    "imporfix" : 3.209082285545927,
    "flgFrperciva" : 3.2841216543560217,
    "idCg62" : 1,
    "pluginData" : {
      "key" : ""
    },
    "id" : 9,
    "additionalData" : {
      "key" : ""
    },
    "el2friva" : 3.8008573585058016,
    "indTipocalend" : 9,
    "indTipodecor" : 4.010300976654761,
    "aggfix2" : 3.812761638325517,
    "aggfix1" : 1.2555055362323109,
    "perciva" : 6.458262756685686,
    "el2frimp" : 5.974942028545841,
    "ggscadfix2" : 7.92839742024475,
    "tipoeff" : 8.910869026866926,
    "flgFrpercimp" : 1.0639121808530916,
    "percimp" : 8.276461147928103,
    "prog" : 4.141296055235948,
    "el1frimp" : 4.372688051310086,
    "codPagCg62" : "codPagCg62",
    "ggscadfix1" : 7.726998920545485,
    "subTypeCO" : {
      "ggoffset" : 2.9679475177256287,
      "codiceCg07" : 2.058822123984536,
      "tipoeff" : 7.3842318535314,
      "codPaguc" : "codPaguc",
      "descstipo" : "descstipo",
      "codStipoeff" : 6.4280627569296165,
      "flgAssegno" : 0,
      "indModfatturapa" : 0,
      "foreignPaymentCodeCO" : {
        "flgIbanobbl" : 6,
        "descrpag" : "descrpag",
        "codIso" : "codIso",
        "codice" : "codice",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 5,
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "el1friva" : 5.7911894223693885,
    "indDatarif" : 8.262795412896967,
    "rowversion" : ""
  }, {
    "indImpfix" : 2.9805393113464476,
    "daggfix1" : 5.6644160867523485,
    "daggfix2" : 1.5970080735609526,
    "ggmmfix" : 7.3718573971919445,
    "ggdecor" : 9.785002165136461,
    "idCg64" : 4,
    "imporfix" : 3.209082285545927,
    "flgFrperciva" : 3.2841216543560217,
    "idCg62" : 1,
    "pluginData" : {
      "key" : ""
    },
    "id" : 9,
    "additionalData" : {
      "key" : ""
    },
    "el2friva" : 3.8008573585058016,
    "indTipocalend" : 9,
    "indTipodecor" : 4.010300976654761,
    "aggfix2" : 3.812761638325517,
    "aggfix1" : 1.2555055362323109,
    "perciva" : 6.458262756685686,
    "el2frimp" : 5.974942028545841,
    "ggscadfix2" : 7.92839742024475,
    "tipoeff" : 8.910869026866926,
    "flgFrpercimp" : 1.0639121808530916,
    "percimp" : 8.276461147928103,
    "prog" : 4.141296055235948,
    "el1frimp" : 4.372688051310086,
    "codPagCg62" : "codPagCg62",
    "ggscadfix1" : 7.726998920545485,
    "subTypeCO" : {
      "ggoffset" : 2.9679475177256287,
      "codiceCg07" : 2.058822123984536,
      "tipoeff" : 7.3842318535314,
      "codPaguc" : "codPaguc",
      "descstipo" : "descstipo",
      "codStipoeff" : 6.4280627569296165,
      "flgAssegno" : 0,
      "indModfatturapa" : 0,
      "foreignPaymentCodeCO" : {
        "flgIbanobbl" : 6,
        "descrpag" : "descrpag",
        "codIso" : "codIso",
        "codice" : "codice",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 5,
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "el1friva" : 5.7911894223693885,
    "indDatarif" : 8.262795412896967,
    "rowversion" : ""
  } ],
  "codPag" : "codPag",
  "desPagAnal" : "desPagAnal",
  "flgDisgg" : 0.35262192099236644,
  "flgPrefpass" : 4,
  "idExtendedAttributeSubEntity" : 1,
  "flgPrefatt" : 7,
  "flgStornoiva" : 2.7977867356748476,
  "descPag" : "descPag",
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ],
  "scpermer2" : 6.966044574347761,
  "pluginData" : {
    "key" : ""
  },
  "id" : 9,
  "scpercas" : 6.173804034172511,
  "scpermer1" : 4.8789878742268815,
  "additionalData" : {
    "key" : ""
  },
  "scpercart26" : 2.535258963197524,
  "idExtendedAttributeEntity" : 9,
  "rowversion" : "",
  "scart26" : 0.58919091925136
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Delete
 * Deleting object of type 
 *
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOPaymentTermCOIdDELETE = function(id,environment,authorizationScope,force,ignoreCompanyPolicyFilter,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Get by ID
 * Get an object of type corresponding the requested id
 *
 * id String Id to get the object
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * dlevel String Serialization level (optional)
 * dlevelkey String Serialization level key (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns PaymentTermCODTO
 **/
exports.apiV1EnvironmentCOPaymentTermCOIdGET = function(id,environment,authorizationScope,ignoreCompanyPolicyFilter,dlevel,dlevelkey,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "flgDesc" : 0.4833312865174044,
  "paymentTermDetailCO" : [ {
    "indImpfix" : 2.9805393113464476,
    "daggfix1" : 5.6644160867523485,
    "daggfix2" : 1.5970080735609526,
    "ggmmfix" : 7.3718573971919445,
    "ggdecor" : 9.785002165136461,
    "idCg64" : 4,
    "imporfix" : 3.209082285545927,
    "flgFrperciva" : 3.2841216543560217,
    "idCg62" : 1,
    "pluginData" : {
      "key" : ""
    },
    "id" : 9,
    "additionalData" : {
      "key" : ""
    },
    "el2friva" : 3.8008573585058016,
    "indTipocalend" : 9,
    "indTipodecor" : 4.010300976654761,
    "aggfix2" : 3.812761638325517,
    "aggfix1" : 1.2555055362323109,
    "perciva" : 6.458262756685686,
    "el2frimp" : 5.974942028545841,
    "ggscadfix2" : 7.92839742024475,
    "tipoeff" : 8.910869026866926,
    "flgFrpercimp" : 1.0639121808530916,
    "percimp" : 8.276461147928103,
    "prog" : 4.141296055235948,
    "el1frimp" : 4.372688051310086,
    "codPagCg62" : "codPagCg62",
    "ggscadfix1" : 7.726998920545485,
    "subTypeCO" : {
      "ggoffset" : 2.9679475177256287,
      "codiceCg07" : 2.058822123984536,
      "tipoeff" : 7.3842318535314,
      "codPaguc" : "codPaguc",
      "descstipo" : "descstipo",
      "codStipoeff" : 6.4280627569296165,
      "flgAssegno" : 0,
      "indModfatturapa" : 0,
      "foreignPaymentCodeCO" : {
        "flgIbanobbl" : 6,
        "descrpag" : "descrpag",
        "codIso" : "codIso",
        "codice" : "codice",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 5,
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "el1friva" : 5.7911894223693885,
    "indDatarif" : 8.262795412896967,
    "rowversion" : ""
  }, {
    "indImpfix" : 2.9805393113464476,
    "daggfix1" : 5.6644160867523485,
    "daggfix2" : 1.5970080735609526,
    "ggmmfix" : 7.3718573971919445,
    "ggdecor" : 9.785002165136461,
    "idCg64" : 4,
    "imporfix" : 3.209082285545927,
    "flgFrperciva" : 3.2841216543560217,
    "idCg62" : 1,
    "pluginData" : {
      "key" : ""
    },
    "id" : 9,
    "additionalData" : {
      "key" : ""
    },
    "el2friva" : 3.8008573585058016,
    "indTipocalend" : 9,
    "indTipodecor" : 4.010300976654761,
    "aggfix2" : 3.812761638325517,
    "aggfix1" : 1.2555055362323109,
    "perciva" : 6.458262756685686,
    "el2frimp" : 5.974942028545841,
    "ggscadfix2" : 7.92839742024475,
    "tipoeff" : 8.910869026866926,
    "flgFrpercimp" : 1.0639121808530916,
    "percimp" : 8.276461147928103,
    "prog" : 4.141296055235948,
    "el1frimp" : 4.372688051310086,
    "codPagCg62" : "codPagCg62",
    "ggscadfix1" : 7.726998920545485,
    "subTypeCO" : {
      "ggoffset" : 2.9679475177256287,
      "codiceCg07" : 2.058822123984536,
      "tipoeff" : 7.3842318535314,
      "codPaguc" : "codPaguc",
      "descstipo" : "descstipo",
      "codStipoeff" : 6.4280627569296165,
      "flgAssegno" : 0,
      "indModfatturapa" : 0,
      "foreignPaymentCodeCO" : {
        "flgIbanobbl" : 6,
        "descrpag" : "descrpag",
        "codIso" : "codIso",
        "codice" : "codice",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 5,
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "el1friva" : 5.7911894223693885,
    "indDatarif" : 8.262795412896967,
    "rowversion" : ""
  } ],
  "codPag" : "codPag",
  "desPagAnal" : "desPagAnal",
  "flgDisgg" : 0.35262192099236644,
  "flgPrefpass" : 4,
  "idExtendedAttributeSubEntity" : 1,
  "flgPrefatt" : 7,
  "flgStornoiva" : 2.7977867356748476,
  "descPag" : "descPag",
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ],
  "scpermer2" : 6.966044574347761,
  "pluginData" : {
    "key" : ""
  },
  "id" : 9,
  "scpercas" : 6.173804034172511,
  "scpermer1" : 4.8789878742268815,
  "additionalData" : {
    "key" : ""
  },
  "scpercart26" : 2.535258963197524,
  "idExtendedAttributeEntity" : 9,
  "rowversion" : "",
  "scart26" : 0.58919091925136
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Update partial
 * Patching an object of type
 *
 * body  Object of type to patch
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOPaymentTermCOIdPATCH = function(body,ignoreCompanyPolicyFilter,force,_op,company,user,id,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Update
 * Updating an object of type
 *
 * body PaymentTermCODTO Object of type to update
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns PaymentTermCODTO
 **/
exports.apiV1EnvironmentCOPaymentTermCOIdPUT = function(body,force,ignoreCompanyPolicyFilter,_op,company,user,id,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "flgDesc" : 0.4833312865174044,
  "paymentTermDetailCO" : [ {
    "indImpfix" : 2.9805393113464476,
    "daggfix1" : 5.6644160867523485,
    "daggfix2" : 1.5970080735609526,
    "ggmmfix" : 7.3718573971919445,
    "ggdecor" : 9.785002165136461,
    "idCg64" : 4,
    "imporfix" : 3.209082285545927,
    "flgFrperciva" : 3.2841216543560217,
    "idCg62" : 1,
    "pluginData" : {
      "key" : ""
    },
    "id" : 9,
    "additionalData" : {
      "key" : ""
    },
    "el2friva" : 3.8008573585058016,
    "indTipocalend" : 9,
    "indTipodecor" : 4.010300976654761,
    "aggfix2" : 3.812761638325517,
    "aggfix1" : 1.2555055362323109,
    "perciva" : 6.458262756685686,
    "el2frimp" : 5.974942028545841,
    "ggscadfix2" : 7.92839742024475,
    "tipoeff" : 8.910869026866926,
    "flgFrpercimp" : 1.0639121808530916,
    "percimp" : 8.276461147928103,
    "prog" : 4.141296055235948,
    "el1frimp" : 4.372688051310086,
    "codPagCg62" : "codPagCg62",
    "ggscadfix1" : 7.726998920545485,
    "subTypeCO" : {
      "ggoffset" : 2.9679475177256287,
      "codiceCg07" : 2.058822123984536,
      "tipoeff" : 7.3842318535314,
      "codPaguc" : "codPaguc",
      "descstipo" : "descstipo",
      "codStipoeff" : 6.4280627569296165,
      "flgAssegno" : 0,
      "indModfatturapa" : 0,
      "foreignPaymentCodeCO" : {
        "flgIbanobbl" : 6,
        "descrpag" : "descrpag",
        "codIso" : "codIso",
        "codice" : "codice",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 5,
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "el1friva" : 5.7911894223693885,
    "indDatarif" : 8.262795412896967,
    "rowversion" : ""
  }, {
    "indImpfix" : 2.9805393113464476,
    "daggfix1" : 5.6644160867523485,
    "daggfix2" : 1.5970080735609526,
    "ggmmfix" : 7.3718573971919445,
    "ggdecor" : 9.785002165136461,
    "idCg64" : 4,
    "imporfix" : 3.209082285545927,
    "flgFrperciva" : 3.2841216543560217,
    "idCg62" : 1,
    "pluginData" : {
      "key" : ""
    },
    "id" : 9,
    "additionalData" : {
      "key" : ""
    },
    "el2friva" : 3.8008573585058016,
    "indTipocalend" : 9,
    "indTipodecor" : 4.010300976654761,
    "aggfix2" : 3.812761638325517,
    "aggfix1" : 1.2555055362323109,
    "perciva" : 6.458262756685686,
    "el2frimp" : 5.974942028545841,
    "ggscadfix2" : 7.92839742024475,
    "tipoeff" : 8.910869026866926,
    "flgFrpercimp" : 1.0639121808530916,
    "percimp" : 8.276461147928103,
    "prog" : 4.141296055235948,
    "el1frimp" : 4.372688051310086,
    "codPagCg62" : "codPagCg62",
    "ggscadfix1" : 7.726998920545485,
    "subTypeCO" : {
      "ggoffset" : 2.9679475177256287,
      "codiceCg07" : 2.058822123984536,
      "tipoeff" : 7.3842318535314,
      "codPaguc" : "codPaguc",
      "descstipo" : "descstipo",
      "codStipoeff" : 6.4280627569296165,
      "flgAssegno" : 0,
      "indModfatturapa" : 0,
      "foreignPaymentCodeCO" : {
        "flgIbanobbl" : 6,
        "descrpag" : "descrpag",
        "codIso" : "codIso",
        "codice" : "codice",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 5,
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "el1friva" : 5.7911894223693885,
    "indDatarif" : 8.262795412896967,
    "rowversion" : ""
  } ],
  "codPag" : "codPag",
  "desPagAnal" : "desPagAnal",
  "flgDisgg" : 0.35262192099236644,
  "flgPrefpass" : 4,
  "idExtendedAttributeSubEntity" : 1,
  "flgPrefatt" : 7,
  "flgStornoiva" : 2.7977867356748476,
  "descPag" : "descPag",
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ],
  "scpermer2" : 6.966044574347761,
  "pluginData" : {
    "key" : ""
  },
  "id" : 9,
  "scpercas" : 6.173804034172511,
  "scpermer1" : 4.8789878742268815,
  "additionalData" : {
    "key" : ""
  },
  "scpercart26" : 2.535258963197524,
  "idExtendedAttributeEntity" : 9,
  "rowversion" : "",
  "scart26" : 0.58919091925136
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Create
 * Creating new object of type
 *
 * body PaymentTermCODTO Object of type to create
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request (optional)
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns PaymentTermCODTO
 **/
exports.apiV1EnvironmentCOPaymentTermCOPOST = function(body,ignoreCompanyPolicyFilter,_op,force,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "flgDesc" : 0.4833312865174044,
  "paymentTermDetailCO" : [ {
    "indImpfix" : 2.9805393113464476,
    "daggfix1" : 5.6644160867523485,
    "daggfix2" : 1.5970080735609526,
    "ggmmfix" : 7.3718573971919445,
    "ggdecor" : 9.785002165136461,
    "idCg64" : 4,
    "imporfix" : 3.209082285545927,
    "flgFrperciva" : 3.2841216543560217,
    "idCg62" : 1,
    "pluginData" : {
      "key" : ""
    },
    "id" : 9,
    "additionalData" : {
      "key" : ""
    },
    "el2friva" : 3.8008573585058016,
    "indTipocalend" : 9,
    "indTipodecor" : 4.010300976654761,
    "aggfix2" : 3.812761638325517,
    "aggfix1" : 1.2555055362323109,
    "perciva" : 6.458262756685686,
    "el2frimp" : 5.974942028545841,
    "ggscadfix2" : 7.92839742024475,
    "tipoeff" : 8.910869026866926,
    "flgFrpercimp" : 1.0639121808530916,
    "percimp" : 8.276461147928103,
    "prog" : 4.141296055235948,
    "el1frimp" : 4.372688051310086,
    "codPagCg62" : "codPagCg62",
    "ggscadfix1" : 7.726998920545485,
    "subTypeCO" : {
      "ggoffset" : 2.9679475177256287,
      "codiceCg07" : 2.058822123984536,
      "tipoeff" : 7.3842318535314,
      "codPaguc" : "codPaguc",
      "descstipo" : "descstipo",
      "codStipoeff" : 6.4280627569296165,
      "flgAssegno" : 0,
      "indModfatturapa" : 0,
      "foreignPaymentCodeCO" : {
        "flgIbanobbl" : 6,
        "descrpag" : "descrpag",
        "codIso" : "codIso",
        "codice" : "codice",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 5,
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "el1friva" : 5.7911894223693885,
    "indDatarif" : 8.262795412896967,
    "rowversion" : ""
  }, {
    "indImpfix" : 2.9805393113464476,
    "daggfix1" : 5.6644160867523485,
    "daggfix2" : 1.5970080735609526,
    "ggmmfix" : 7.3718573971919445,
    "ggdecor" : 9.785002165136461,
    "idCg64" : 4,
    "imporfix" : 3.209082285545927,
    "flgFrperciva" : 3.2841216543560217,
    "idCg62" : 1,
    "pluginData" : {
      "key" : ""
    },
    "id" : 9,
    "additionalData" : {
      "key" : ""
    },
    "el2friva" : 3.8008573585058016,
    "indTipocalend" : 9,
    "indTipodecor" : 4.010300976654761,
    "aggfix2" : 3.812761638325517,
    "aggfix1" : 1.2555055362323109,
    "perciva" : 6.458262756685686,
    "el2frimp" : 5.974942028545841,
    "ggscadfix2" : 7.92839742024475,
    "tipoeff" : 8.910869026866926,
    "flgFrpercimp" : 1.0639121808530916,
    "percimp" : 8.276461147928103,
    "prog" : 4.141296055235948,
    "el1frimp" : 4.372688051310086,
    "codPagCg62" : "codPagCg62",
    "ggscadfix1" : 7.726998920545485,
    "subTypeCO" : {
      "ggoffset" : 2.9679475177256287,
      "codiceCg07" : 2.058822123984536,
      "tipoeff" : 7.3842318535314,
      "codPaguc" : "codPaguc",
      "descstipo" : "descstipo",
      "codStipoeff" : 6.4280627569296165,
      "flgAssegno" : 0,
      "indModfatturapa" : 0,
      "foreignPaymentCodeCO" : {
        "flgIbanobbl" : 6,
        "descrpag" : "descrpag",
        "codIso" : "codIso",
        "codice" : "codice",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 5,
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "el1friva" : 5.7911894223693885,
    "indDatarif" : 8.262795412896967,
    "rowversion" : ""
  } ],
  "codPag" : "codPag",
  "desPagAnal" : "desPagAnal",
  "flgDisgg" : 0.35262192099236644,
  "flgPrefpass" : 4,
  "idExtendedAttributeSubEntity" : 1,
  "flgPrefatt" : 7,
  "flgStornoiva" : 2.7977867356748476,
  "descPag" : "descPag",
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ],
  "scpermer2" : 6.966044574347761,
  "pluginData" : {
    "key" : ""
  },
  "id" : 9,
  "scpercas" : 6.173804034172511,
  "scpermer1" : 4.8789878742268815,
  "additionalData" : {
    "key" : ""
  },
  "scpercart26" : 2.535258963197524,
  "idExtendedAttributeEntity" : 9,
  "rowversion" : "",
  "scart26" : 0.58919091925136
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Duplication of Payment Term
 * Duplication of Payment Term
 *
 * body PaymentTermDuplicationParametersCODTO Parameters for duplication
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOPaymentTermCOPaymentTermDuplicationPOST = function(body,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Validate
 * Validation of object of type
 *
 * body PaymentTermCODTO Object of type to validate
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOPaymentTermCOValidatePOST = function(body,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Validation of one on more properties of Type
 * Validation of object of type
 *
 * body String  - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED<br> - The id of an existing object to validate properties, or '' if the object does not exist yet <br> (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns ValidateDTO
 **/
exports.apiV1EnvironmentCOPaymentTermCOValidatePropertiesPOST = function(body,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "items" : [ {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  }, {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  } ]
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}

