'use strict';


/**
 * Get new
 * Get an empty object of type corresponding
 *
 * _op String The value must be 'new'
 * param String Specify optional parameters that will be used during entity creation
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns GeneralMasterDataCODTO
 **/
exports.apiV1EnvironmentCOGeneralMasterDataCOGET = function(_op,param,environment,authorizationScope,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "datavalid" : "2000-01-23T04:56:07.000+00:00",
  "ragsofiscex" : "ragsofiscex",
  "addresses" : [ {
    "indirizzocomp2" : "indirizzocomp2",
    "addressesType" : [ {
      "tipo" : 7,
      "idCG1J" : 4,
      "pluginData" : {
        "key" : ""
      },
      "id" : 1,
      "additionalData" : {
        "key" : ""
      }
    }, {
      "tipo" : 7,
      "idCG1J" : 4,
      "pluginData" : {
        "key" : ""
      },
      "id" : 1,
      "additionalData" : {
        "key" : ""
      }
    } ],
    "risstato" : "risstato",
    "riszip" : "riszip",
    "pv" : "pv",
    "precisione" : "precisione",
    "codlinguaMg52" : "codlinguaMg52",
    "frazione" : "frazione",
    "emailPec" : "emailPec",
    "tipologia" : "tipologia",
    "via" : "via",
    "idTeamportal" : 4,
    "numciv" : "numciv",
    "cap" : "cap",
    "latitudine" : 0.2025324113236393,
    "statoCg07" : 4.258773108174356,
    "presso" : "presso",
    "federalStateViewCO" : {
      "descr" : "descr",
      "iso3166statofed" : "iso3166statofed",
      "a2iso3166Cg07" : "a2iso3166Cg07",
      "pluginData" : {
        "key" : ""
      },
      "codiceCg07" : 9.132027271330688,
      "additionalData" : {
        "key" : ""
      },
      "statofed" : "statofed"
    },
    "pluginData" : {
      "key" : ""
    },
    "id" : 3,
    "additionalData" : {
      "key" : ""
    },
    "fax" : "fax",
    "statofed" : "statofed",
    "telefono" : "telefono",
    "datamod" : "2000-01-23T04:56:07.000+00:00",
    "email" : "email",
    "citta" : "citta",
    "ragsoc" : "ragsoc",
    "cellnum" : "cellnum",
    "comanaCg01" : "comanaCg01",
    "codiceCg16" : 5,
    "datacre" : "2000-01-23T04:56:07.000+00:00",
    "ragsocex" : "ragsocex",
    "rifindirizzo" : "rifindirizzo",
    "codicesfed" : "codicesfed",
    "contea" : "contea",
    "indirizzocomp" : "indirizzocomp",
    "riswarning" : "riswarning",
    "indirizzoex" : "indirizzoex",
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "risregione" : "risregione",
    "edificio" : "edificio",
    "statoEst" : {
      "codSian" : 9.702963800023566,
      "crtpiva" : "crtpiva",
      "leniban" : 6,
      "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
      "desiso3166" : "desiso3166",
      "idmediaCg99" : 5.507386964179881,
      "codice" : 0.8774076871421566,
      "numiso3166" : "numiso3166",
      "codiceCg08" : "codiceCg08",
      "currencyCO" : {
        "sigla" : "sigla",
        "dataattuem" : "2000-01-23T04:56:07.000+00:00",
        "numdec" : 8.28965939814297,
        "exchangeRateCO" : [ {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        }, {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        } ],
        "idmediaCg99" : 3.901545264248647,
        "codice" : "codice",
        "indCertoincerto" : 0,
        "cambiofisso" : 8.251625748923757,
        "descr" : "descr",
        "flgValuem" : 4.459605034958679,
        "indValuem" : 1.7325933120207193,
        "indSepmigl" : 2.9409642974827896,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "descr" : "descr",
      "flgIban" : 0,
      "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
      "codIso" : "codIso",
      "a3iso3166" : "a3iso3166",
      "indTipostato" : 4.86315908102884,
      "a2iso3166" : "a2iso3166",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datacee" : "2000-01-23T04:56:07.000+00:00",
      "flgSepa" : 7
    },
    "longitudine" : 6.628464275087742,
    "indweb" : "indweb"
  }, {
    "indirizzocomp2" : "indirizzocomp2",
    "addressesType" : [ {
      "tipo" : 7,
      "idCG1J" : 4,
      "pluginData" : {
        "key" : ""
      },
      "id" : 1,
      "additionalData" : {
        "key" : ""
      }
    }, {
      "tipo" : 7,
      "idCG1J" : 4,
      "pluginData" : {
        "key" : ""
      },
      "id" : 1,
      "additionalData" : {
        "key" : ""
      }
    } ],
    "risstato" : "risstato",
    "riszip" : "riszip",
    "pv" : "pv",
    "precisione" : "precisione",
    "codlinguaMg52" : "codlinguaMg52",
    "frazione" : "frazione",
    "emailPec" : "emailPec",
    "tipologia" : "tipologia",
    "via" : "via",
    "idTeamportal" : 4,
    "numciv" : "numciv",
    "cap" : "cap",
    "latitudine" : 0.2025324113236393,
    "statoCg07" : 4.258773108174356,
    "presso" : "presso",
    "federalStateViewCO" : {
      "descr" : "descr",
      "iso3166statofed" : "iso3166statofed",
      "a2iso3166Cg07" : "a2iso3166Cg07",
      "pluginData" : {
        "key" : ""
      },
      "codiceCg07" : 9.132027271330688,
      "additionalData" : {
        "key" : ""
      },
      "statofed" : "statofed"
    },
    "pluginData" : {
      "key" : ""
    },
    "id" : 3,
    "additionalData" : {
      "key" : ""
    },
    "fax" : "fax",
    "statofed" : "statofed",
    "telefono" : "telefono",
    "datamod" : "2000-01-23T04:56:07.000+00:00",
    "email" : "email",
    "citta" : "citta",
    "ragsoc" : "ragsoc",
    "cellnum" : "cellnum",
    "comanaCg01" : "comanaCg01",
    "codiceCg16" : 5,
    "datacre" : "2000-01-23T04:56:07.000+00:00",
    "ragsocex" : "ragsocex",
    "rifindirizzo" : "rifindirizzo",
    "codicesfed" : "codicesfed",
    "contea" : "contea",
    "indirizzocomp" : "indirizzocomp",
    "riswarning" : "riswarning",
    "indirizzoex" : "indirizzoex",
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "risregione" : "risregione",
    "edificio" : "edificio",
    "statoEst" : {
      "codSian" : 9.702963800023566,
      "crtpiva" : "crtpiva",
      "leniban" : 6,
      "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
      "desiso3166" : "desiso3166",
      "idmediaCg99" : 5.507386964179881,
      "codice" : 0.8774076871421566,
      "numiso3166" : "numiso3166",
      "codiceCg08" : "codiceCg08",
      "currencyCO" : {
        "sigla" : "sigla",
        "dataattuem" : "2000-01-23T04:56:07.000+00:00",
        "numdec" : 8.28965939814297,
        "exchangeRateCO" : [ {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        }, {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        } ],
        "idmediaCg99" : 3.901545264248647,
        "codice" : "codice",
        "indCertoincerto" : 0,
        "cambiofisso" : 8.251625748923757,
        "descr" : "descr",
        "flgValuem" : 4.459605034958679,
        "indValuem" : 1.7325933120207193,
        "indSepmigl" : 2.9409642974827896,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "descr" : "descr",
      "flgIban" : 0,
      "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
      "codIso" : "codIso",
      "a3iso3166" : "a3iso3166",
      "indTipostato" : 4.86315908102884,
      "a2iso3166" : "a2iso3166",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datacee" : "2000-01-23T04:56:07.000+00:00",
      "flgSepa" : 7
    },
    "longitudine" : 6.628464275087742,
    "indweb" : "indweb"
  } ],
  "codiceident" : "codiceident",
  "indirCorEX" : "indirCorEX",
  "flgFattpa" : 3,
  "indirizzo" : "indirizzo",
  "ragsoanagex" : "ragsoanagex",
  "codiceCg07" : 6.778324963048013,
  "indsoggrit" : 0.10263654006109402,
  "ragSoAnag" : "ragSoAnag",
  "capcor" : "capcor",
  "cittafisc" : "cittafisc",
  "intragroupStructureCO" : {
    "descr" : "descr",
    "codice" : 0.4182561061793122,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "codAnagGen" : 8,
    "codIntercompany" : 5
  },
  "statofiscCg07" : 7.740351818741173,
  "tel2num" : "tel2num",
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "codfiscale" : "codfiscale",
  "statofed" : "statofed",
  "codrichiamo" : 6,
  "provfisc" : "provfisc",
  "idExtendedAttributeEntity" : 3,
  "citta" : "citta",
  "statonascitaCg07" : 3.0205796992916243,
  "codice" : 2,
  "indFiscale" : "indFiscale",
  "nome" : "nome",
  "comnascitaCg01" : "comnascitaCg01",
  "codiceCg15" : "codiceCg15",
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ],
  "ragsofisc" : "ragsofisc",
  "indemail" : "indemail",
  "indirizzoEX" : "indirizzoEX",
  "comfisCg01" : "comfisCg01",
  "comnascita" : "comnascita",
  "partiva" : "partiva",
  "flgNoblacklist" : 7.143538047012306,
  "partivaEst" : "partivaEst",
  "cognome" : "cognome",
  "idmediaCg99" : 6.519180951018382,
  "wtCodeCO" : {
    "causdd1" : "causdd1",
    "codNonsog" : 5.312489704336296,
    "flgRegagevo" : 9.897492629215506,
    "idmediaCg99" : 3.1497903714250555,
    "percRipPerc" : 2.7977867356748476,
    "flgRitImposta" : 5.877124706116695,
    "codPrev" : "codPrev",
    "tiporapporto" : "tiporapporto",
    "percripaz" : 4.332304821875894,
    "pluginData" : {
      "key" : ""
    },
    "flgPignTerzi" : 3.7814124730767915,
    "flgProteo360" : 3.111202833403195,
    "additionalData" : {
      "key" : ""
    },
    "flgGlad" : 8.37823741034869,
    "codFiscPrev" : "codFiscPrev",
    "gcprev" : 0,
    "idprov" : 2.380090174313445,
    "codice" : "codice",
    "percci" : 0.35262192099236644,
    "flgSosprit" : 7,
    "descr" : "descr",
    "flgMinimi" : 7,
    "codTributo" : "codTributo",
    "indCodattglad" : 3.804112695731078,
    "indTipocassa" : 8,
    "percra" : 7.203794749804894,
    "percbaseimp" : 0.4833312865174044,
    "codTribrp" : "codTribrp",
    "inpsivs" : 4.518309517874243,
    "rowversion" : ""
  },
  "dtiniziopec" : "2000-01-23T04:56:07.000+00:00",
  "capfisc" : "capfisc",
  "codicecorCg07" : 5.944895607614016,
  "codiceCgc0" : 6.878052220127876,
  "cap" : "cap",
  "faxnum" : "faxnum",
  "alias" : "alias",
  "flgOmonimo" : 0.8851374739011653,
  "provnascita" : "provnascita",
  "ragsocor" : "ragsocor",
  "prov" : "prov",
  "flgAnagval" : 3.353193347011243,
  "rapazestCg16" : 4,
  "cellnum" : "cellnum",
  "flgPrsfis" : 7.058770351582356,
  "tel1num" : "tel1num",
  "idExtendedAttributeSubEntity" : 7,
  "provcor" : "provcor",
  "dtfinepec" : "2000-01-23T04:56:07.000+00:00",
  "cittacor" : "cittacor",
  "codicesfed" : "codicesfed",
  "statofedfisc" : "statofedfisc",
  "indFiscaleEX" : "indFiscaleEX",
  "partitaIVA" : "partitaIVA",
  "indirCor" : "indirCor",
  "sesso" : 8.969578798196912,
  "lastchange" : "2000-01-23T04:56:07.000+00:00",
  "ragsocorex" : "ragsocorex",
  "datanascita" : "2000-01-23T04:56:07.000+00:00",
  "auidAu04" : 1,
  "indweb" : "indweb"
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * GetFromCerved
 * It allows the creation or simple mapping of a Cerved registry into a general registry
 *
 * body GetFromCervedParametersDTO Information for mapping and / writing the Cerved registry -> General registry
 * force String The warning/s code to bypass (separated by ',') during the execution (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns GeneralMasterDataCODTO
 **/
exports.apiV1EnvironmentCOGeneralMasterDataCOGetfromcervedPOST = function(body,force,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "datavalid" : "2000-01-23T04:56:07.000+00:00",
  "ragsofiscex" : "ragsofiscex",
  "addresses" : [ {
    "indirizzocomp2" : "indirizzocomp2",
    "addressesType" : [ {
      "tipo" : 7,
      "idCG1J" : 4,
      "pluginData" : {
        "key" : ""
      },
      "id" : 1,
      "additionalData" : {
        "key" : ""
      }
    }, {
      "tipo" : 7,
      "idCG1J" : 4,
      "pluginData" : {
        "key" : ""
      },
      "id" : 1,
      "additionalData" : {
        "key" : ""
      }
    } ],
    "risstato" : "risstato",
    "riszip" : "riszip",
    "pv" : "pv",
    "precisione" : "precisione",
    "codlinguaMg52" : "codlinguaMg52",
    "frazione" : "frazione",
    "emailPec" : "emailPec",
    "tipologia" : "tipologia",
    "via" : "via",
    "idTeamportal" : 4,
    "numciv" : "numciv",
    "cap" : "cap",
    "latitudine" : 0.2025324113236393,
    "statoCg07" : 4.258773108174356,
    "presso" : "presso",
    "federalStateViewCO" : {
      "descr" : "descr",
      "iso3166statofed" : "iso3166statofed",
      "a2iso3166Cg07" : "a2iso3166Cg07",
      "pluginData" : {
        "key" : ""
      },
      "codiceCg07" : 9.132027271330688,
      "additionalData" : {
        "key" : ""
      },
      "statofed" : "statofed"
    },
    "pluginData" : {
      "key" : ""
    },
    "id" : 3,
    "additionalData" : {
      "key" : ""
    },
    "fax" : "fax",
    "statofed" : "statofed",
    "telefono" : "telefono",
    "datamod" : "2000-01-23T04:56:07.000+00:00",
    "email" : "email",
    "citta" : "citta",
    "ragsoc" : "ragsoc",
    "cellnum" : "cellnum",
    "comanaCg01" : "comanaCg01",
    "codiceCg16" : 5,
    "datacre" : "2000-01-23T04:56:07.000+00:00",
    "ragsocex" : "ragsocex",
    "rifindirizzo" : "rifindirizzo",
    "codicesfed" : "codicesfed",
    "contea" : "contea",
    "indirizzocomp" : "indirizzocomp",
    "riswarning" : "riswarning",
    "indirizzoex" : "indirizzoex",
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "risregione" : "risregione",
    "edificio" : "edificio",
    "statoEst" : {
      "codSian" : 9.702963800023566,
      "crtpiva" : "crtpiva",
      "leniban" : 6,
      "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
      "desiso3166" : "desiso3166",
      "idmediaCg99" : 5.507386964179881,
      "codice" : 0.8774076871421566,
      "numiso3166" : "numiso3166",
      "codiceCg08" : "codiceCg08",
      "currencyCO" : {
        "sigla" : "sigla",
        "dataattuem" : "2000-01-23T04:56:07.000+00:00",
        "numdec" : 8.28965939814297,
        "exchangeRateCO" : [ {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        }, {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        } ],
        "idmediaCg99" : 3.901545264248647,
        "codice" : "codice",
        "indCertoincerto" : 0,
        "cambiofisso" : 8.251625748923757,
        "descr" : "descr",
        "flgValuem" : 4.459605034958679,
        "indValuem" : 1.7325933120207193,
        "indSepmigl" : 2.9409642974827896,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "descr" : "descr",
      "flgIban" : 0,
      "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
      "codIso" : "codIso",
      "a3iso3166" : "a3iso3166",
      "indTipostato" : 4.86315908102884,
      "a2iso3166" : "a2iso3166",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datacee" : "2000-01-23T04:56:07.000+00:00",
      "flgSepa" : 7
    },
    "longitudine" : 6.628464275087742,
    "indweb" : "indweb"
  }, {
    "indirizzocomp2" : "indirizzocomp2",
    "addressesType" : [ {
      "tipo" : 7,
      "idCG1J" : 4,
      "pluginData" : {
        "key" : ""
      },
      "id" : 1,
      "additionalData" : {
        "key" : ""
      }
    }, {
      "tipo" : 7,
      "idCG1J" : 4,
      "pluginData" : {
        "key" : ""
      },
      "id" : 1,
      "additionalData" : {
        "key" : ""
      }
    } ],
    "risstato" : "risstato",
    "riszip" : "riszip",
    "pv" : "pv",
    "precisione" : "precisione",
    "codlinguaMg52" : "codlinguaMg52",
    "frazione" : "frazione",
    "emailPec" : "emailPec",
    "tipologia" : "tipologia",
    "via" : "via",
    "idTeamportal" : 4,
    "numciv" : "numciv",
    "cap" : "cap",
    "latitudine" : 0.2025324113236393,
    "statoCg07" : 4.258773108174356,
    "presso" : "presso",
    "federalStateViewCO" : {
      "descr" : "descr",
      "iso3166statofed" : "iso3166statofed",
      "a2iso3166Cg07" : "a2iso3166Cg07",
      "pluginData" : {
        "key" : ""
      },
      "codiceCg07" : 9.132027271330688,
      "additionalData" : {
        "key" : ""
      },
      "statofed" : "statofed"
    },
    "pluginData" : {
      "key" : ""
    },
    "id" : 3,
    "additionalData" : {
      "key" : ""
    },
    "fax" : "fax",
    "statofed" : "statofed",
    "telefono" : "telefono",
    "datamod" : "2000-01-23T04:56:07.000+00:00",
    "email" : "email",
    "citta" : "citta",
    "ragsoc" : "ragsoc",
    "cellnum" : "cellnum",
    "comanaCg01" : "comanaCg01",
    "codiceCg16" : 5,
    "datacre" : "2000-01-23T04:56:07.000+00:00",
    "ragsocex" : "ragsocex",
    "rifindirizzo" : "rifindirizzo",
    "codicesfed" : "codicesfed",
    "contea" : "contea",
    "indirizzocomp" : "indirizzocomp",
    "riswarning" : "riswarning",
    "indirizzoex" : "indirizzoex",
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "risregione" : "risregione",
    "edificio" : "edificio",
    "statoEst" : {
      "codSian" : 9.702963800023566,
      "crtpiva" : "crtpiva",
      "leniban" : 6,
      "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
      "desiso3166" : "desiso3166",
      "idmediaCg99" : 5.507386964179881,
      "codice" : 0.8774076871421566,
      "numiso3166" : "numiso3166",
      "codiceCg08" : "codiceCg08",
      "currencyCO" : {
        "sigla" : "sigla",
        "dataattuem" : "2000-01-23T04:56:07.000+00:00",
        "numdec" : 8.28965939814297,
        "exchangeRateCO" : [ {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        }, {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        } ],
        "idmediaCg99" : 3.901545264248647,
        "codice" : "codice",
        "indCertoincerto" : 0,
        "cambiofisso" : 8.251625748923757,
        "descr" : "descr",
        "flgValuem" : 4.459605034958679,
        "indValuem" : 1.7325933120207193,
        "indSepmigl" : 2.9409642974827896,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "descr" : "descr",
      "flgIban" : 0,
      "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
      "codIso" : "codIso",
      "a3iso3166" : "a3iso3166",
      "indTipostato" : 4.86315908102884,
      "a2iso3166" : "a2iso3166",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datacee" : "2000-01-23T04:56:07.000+00:00",
      "flgSepa" : 7
    },
    "longitudine" : 6.628464275087742,
    "indweb" : "indweb"
  } ],
  "codiceident" : "codiceident",
  "indirCorEX" : "indirCorEX",
  "flgFattpa" : 3,
  "indirizzo" : "indirizzo",
  "ragsoanagex" : "ragsoanagex",
  "codiceCg07" : 6.778324963048013,
  "indsoggrit" : 0.10263654006109402,
  "ragSoAnag" : "ragSoAnag",
  "capcor" : "capcor",
  "cittafisc" : "cittafisc",
  "intragroupStructureCO" : {
    "descr" : "descr",
    "codice" : 0.4182561061793122,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "codAnagGen" : 8,
    "codIntercompany" : 5
  },
  "statofiscCg07" : 7.740351818741173,
  "tel2num" : "tel2num",
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "codfiscale" : "codfiscale",
  "statofed" : "statofed",
  "codrichiamo" : 6,
  "provfisc" : "provfisc",
  "idExtendedAttributeEntity" : 3,
  "citta" : "citta",
  "statonascitaCg07" : 3.0205796992916243,
  "codice" : 2,
  "indFiscale" : "indFiscale",
  "nome" : "nome",
  "comnascitaCg01" : "comnascitaCg01",
  "codiceCg15" : "codiceCg15",
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ],
  "ragsofisc" : "ragsofisc",
  "indemail" : "indemail",
  "indirizzoEX" : "indirizzoEX",
  "comfisCg01" : "comfisCg01",
  "comnascita" : "comnascita",
  "partiva" : "partiva",
  "flgNoblacklist" : 7.143538047012306,
  "partivaEst" : "partivaEst",
  "cognome" : "cognome",
  "idmediaCg99" : 6.519180951018382,
  "wtCodeCO" : {
    "causdd1" : "causdd1",
    "codNonsog" : 5.312489704336296,
    "flgRegagevo" : 9.897492629215506,
    "idmediaCg99" : 3.1497903714250555,
    "percRipPerc" : 2.7977867356748476,
    "flgRitImposta" : 5.877124706116695,
    "codPrev" : "codPrev",
    "tiporapporto" : "tiporapporto",
    "percripaz" : 4.332304821875894,
    "pluginData" : {
      "key" : ""
    },
    "flgPignTerzi" : 3.7814124730767915,
    "flgProteo360" : 3.111202833403195,
    "additionalData" : {
      "key" : ""
    },
    "flgGlad" : 8.37823741034869,
    "codFiscPrev" : "codFiscPrev",
    "gcprev" : 0,
    "idprov" : 2.380090174313445,
    "codice" : "codice",
    "percci" : 0.35262192099236644,
    "flgSosprit" : 7,
    "descr" : "descr",
    "flgMinimi" : 7,
    "codTributo" : "codTributo",
    "indCodattglad" : 3.804112695731078,
    "indTipocassa" : 8,
    "percra" : 7.203794749804894,
    "percbaseimp" : 0.4833312865174044,
    "codTribrp" : "codTribrp",
    "inpsivs" : 4.518309517874243,
    "rowversion" : ""
  },
  "dtiniziopec" : "2000-01-23T04:56:07.000+00:00",
  "capfisc" : "capfisc",
  "codicecorCg07" : 5.944895607614016,
  "codiceCgc0" : 6.878052220127876,
  "cap" : "cap",
  "faxnum" : "faxnum",
  "alias" : "alias",
  "flgOmonimo" : 0.8851374739011653,
  "provnascita" : "provnascita",
  "ragsocor" : "ragsocor",
  "prov" : "prov",
  "flgAnagval" : 3.353193347011243,
  "rapazestCg16" : 4,
  "cellnum" : "cellnum",
  "flgPrsfis" : 7.058770351582356,
  "tel1num" : "tel1num",
  "idExtendedAttributeSubEntity" : 7,
  "provcor" : "provcor",
  "dtfinepec" : "2000-01-23T04:56:07.000+00:00",
  "cittacor" : "cittacor",
  "codicesfed" : "codicesfed",
  "statofedfisc" : "statofedfisc",
  "indFiscaleEX" : "indFiscaleEX",
  "partitaIVA" : "partitaIVA",
  "indirCor" : "indirCor",
  "sesso" : 8.969578798196912,
  "lastchange" : "2000-01-23T04:56:07.000+00:00",
  "ragsocorex" : "ragsocorex",
  "datanascita" : "2000-01-23T04:56:07.000+00:00",
  "auidAu04" : 1,
  "indweb" : "indweb"
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Delete
 * Deleting object of type 
 *
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOGeneralMasterDataCOIdDELETE = function(id,environment,authorizationScope,force,ignoreCompanyPolicyFilter,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Get by ID
 * Get an object of type corresponding the requested id
 *
 * id String Id to get the object
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * dlevel String Serialization level (optional)
 * dlevelkey String Serialization level key (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns GeneralMasterDataCODTO
 **/
exports.apiV1EnvironmentCOGeneralMasterDataCOIdGET = function(id,environment,authorizationScope,ignoreCompanyPolicyFilter,dlevel,dlevelkey,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "datavalid" : "2000-01-23T04:56:07.000+00:00",
  "ragsofiscex" : "ragsofiscex",
  "addresses" : [ {
    "indirizzocomp2" : "indirizzocomp2",
    "addressesType" : [ {
      "tipo" : 7,
      "idCG1J" : 4,
      "pluginData" : {
        "key" : ""
      },
      "id" : 1,
      "additionalData" : {
        "key" : ""
      }
    }, {
      "tipo" : 7,
      "idCG1J" : 4,
      "pluginData" : {
        "key" : ""
      },
      "id" : 1,
      "additionalData" : {
        "key" : ""
      }
    } ],
    "risstato" : "risstato",
    "riszip" : "riszip",
    "pv" : "pv",
    "precisione" : "precisione",
    "codlinguaMg52" : "codlinguaMg52",
    "frazione" : "frazione",
    "emailPec" : "emailPec",
    "tipologia" : "tipologia",
    "via" : "via",
    "idTeamportal" : 4,
    "numciv" : "numciv",
    "cap" : "cap",
    "latitudine" : 0.2025324113236393,
    "statoCg07" : 4.258773108174356,
    "presso" : "presso",
    "federalStateViewCO" : {
      "descr" : "descr",
      "iso3166statofed" : "iso3166statofed",
      "a2iso3166Cg07" : "a2iso3166Cg07",
      "pluginData" : {
        "key" : ""
      },
      "codiceCg07" : 9.132027271330688,
      "additionalData" : {
        "key" : ""
      },
      "statofed" : "statofed"
    },
    "pluginData" : {
      "key" : ""
    },
    "id" : 3,
    "additionalData" : {
      "key" : ""
    },
    "fax" : "fax",
    "statofed" : "statofed",
    "telefono" : "telefono",
    "datamod" : "2000-01-23T04:56:07.000+00:00",
    "email" : "email",
    "citta" : "citta",
    "ragsoc" : "ragsoc",
    "cellnum" : "cellnum",
    "comanaCg01" : "comanaCg01",
    "codiceCg16" : 5,
    "datacre" : "2000-01-23T04:56:07.000+00:00",
    "ragsocex" : "ragsocex",
    "rifindirizzo" : "rifindirizzo",
    "codicesfed" : "codicesfed",
    "contea" : "contea",
    "indirizzocomp" : "indirizzocomp",
    "riswarning" : "riswarning",
    "indirizzoex" : "indirizzoex",
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "risregione" : "risregione",
    "edificio" : "edificio",
    "statoEst" : {
      "codSian" : 9.702963800023566,
      "crtpiva" : "crtpiva",
      "leniban" : 6,
      "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
      "desiso3166" : "desiso3166",
      "idmediaCg99" : 5.507386964179881,
      "codice" : 0.8774076871421566,
      "numiso3166" : "numiso3166",
      "codiceCg08" : "codiceCg08",
      "currencyCO" : {
        "sigla" : "sigla",
        "dataattuem" : "2000-01-23T04:56:07.000+00:00",
        "numdec" : 8.28965939814297,
        "exchangeRateCO" : [ {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        }, {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        } ],
        "idmediaCg99" : 3.901545264248647,
        "codice" : "codice",
        "indCertoincerto" : 0,
        "cambiofisso" : 8.251625748923757,
        "descr" : "descr",
        "flgValuem" : 4.459605034958679,
        "indValuem" : 1.7325933120207193,
        "indSepmigl" : 2.9409642974827896,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "descr" : "descr",
      "flgIban" : 0,
      "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
      "codIso" : "codIso",
      "a3iso3166" : "a3iso3166",
      "indTipostato" : 4.86315908102884,
      "a2iso3166" : "a2iso3166",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datacee" : "2000-01-23T04:56:07.000+00:00",
      "flgSepa" : 7
    },
    "longitudine" : 6.628464275087742,
    "indweb" : "indweb"
  }, {
    "indirizzocomp2" : "indirizzocomp2",
    "addressesType" : [ {
      "tipo" : 7,
      "idCG1J" : 4,
      "pluginData" : {
        "key" : ""
      },
      "id" : 1,
      "additionalData" : {
        "key" : ""
      }
    }, {
      "tipo" : 7,
      "idCG1J" : 4,
      "pluginData" : {
        "key" : ""
      },
      "id" : 1,
      "additionalData" : {
        "key" : ""
      }
    } ],
    "risstato" : "risstato",
    "riszip" : "riszip",
    "pv" : "pv",
    "precisione" : "precisione",
    "codlinguaMg52" : "codlinguaMg52",
    "frazione" : "frazione",
    "emailPec" : "emailPec",
    "tipologia" : "tipologia",
    "via" : "via",
    "idTeamportal" : 4,
    "numciv" : "numciv",
    "cap" : "cap",
    "latitudine" : 0.2025324113236393,
    "statoCg07" : 4.258773108174356,
    "presso" : "presso",
    "federalStateViewCO" : {
      "descr" : "descr",
      "iso3166statofed" : "iso3166statofed",
      "a2iso3166Cg07" : "a2iso3166Cg07",
      "pluginData" : {
        "key" : ""
      },
      "codiceCg07" : 9.132027271330688,
      "additionalData" : {
        "key" : ""
      },
      "statofed" : "statofed"
    },
    "pluginData" : {
      "key" : ""
    },
    "id" : 3,
    "additionalData" : {
      "key" : ""
    },
    "fax" : "fax",
    "statofed" : "statofed",
    "telefono" : "telefono",
    "datamod" : "2000-01-23T04:56:07.000+00:00",
    "email" : "email",
    "citta" : "citta",
    "ragsoc" : "ragsoc",
    "cellnum" : "cellnum",
    "comanaCg01" : "comanaCg01",
    "codiceCg16" : 5,
    "datacre" : "2000-01-23T04:56:07.000+00:00",
    "ragsocex" : "ragsocex",
    "rifindirizzo" : "rifindirizzo",
    "codicesfed" : "codicesfed",
    "contea" : "contea",
    "indirizzocomp" : "indirizzocomp",
    "riswarning" : "riswarning",
    "indirizzoex" : "indirizzoex",
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "risregione" : "risregione",
    "edificio" : "edificio",
    "statoEst" : {
      "codSian" : 9.702963800023566,
      "crtpiva" : "crtpiva",
      "leniban" : 6,
      "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
      "desiso3166" : "desiso3166",
      "idmediaCg99" : 5.507386964179881,
      "codice" : 0.8774076871421566,
      "numiso3166" : "numiso3166",
      "codiceCg08" : "codiceCg08",
      "currencyCO" : {
        "sigla" : "sigla",
        "dataattuem" : "2000-01-23T04:56:07.000+00:00",
        "numdec" : 8.28965939814297,
        "exchangeRateCO" : [ {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        }, {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        } ],
        "idmediaCg99" : 3.901545264248647,
        "codice" : "codice",
        "indCertoincerto" : 0,
        "cambiofisso" : 8.251625748923757,
        "descr" : "descr",
        "flgValuem" : 4.459605034958679,
        "indValuem" : 1.7325933120207193,
        "indSepmigl" : 2.9409642974827896,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "descr" : "descr",
      "flgIban" : 0,
      "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
      "codIso" : "codIso",
      "a3iso3166" : "a3iso3166",
      "indTipostato" : 4.86315908102884,
      "a2iso3166" : "a2iso3166",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datacee" : "2000-01-23T04:56:07.000+00:00",
      "flgSepa" : 7
    },
    "longitudine" : 6.628464275087742,
    "indweb" : "indweb"
  } ],
  "codiceident" : "codiceident",
  "indirCorEX" : "indirCorEX",
  "flgFattpa" : 3,
  "indirizzo" : "indirizzo",
  "ragsoanagex" : "ragsoanagex",
  "codiceCg07" : 6.778324963048013,
  "indsoggrit" : 0.10263654006109402,
  "ragSoAnag" : "ragSoAnag",
  "capcor" : "capcor",
  "cittafisc" : "cittafisc",
  "intragroupStructureCO" : {
    "descr" : "descr",
    "codice" : 0.4182561061793122,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "codAnagGen" : 8,
    "codIntercompany" : 5
  },
  "statofiscCg07" : 7.740351818741173,
  "tel2num" : "tel2num",
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "codfiscale" : "codfiscale",
  "statofed" : "statofed",
  "codrichiamo" : 6,
  "provfisc" : "provfisc",
  "idExtendedAttributeEntity" : 3,
  "citta" : "citta",
  "statonascitaCg07" : 3.0205796992916243,
  "codice" : 2,
  "indFiscale" : "indFiscale",
  "nome" : "nome",
  "comnascitaCg01" : "comnascitaCg01",
  "codiceCg15" : "codiceCg15",
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ],
  "ragsofisc" : "ragsofisc",
  "indemail" : "indemail",
  "indirizzoEX" : "indirizzoEX",
  "comfisCg01" : "comfisCg01",
  "comnascita" : "comnascita",
  "partiva" : "partiva",
  "flgNoblacklist" : 7.143538047012306,
  "partivaEst" : "partivaEst",
  "cognome" : "cognome",
  "idmediaCg99" : 6.519180951018382,
  "wtCodeCO" : {
    "causdd1" : "causdd1",
    "codNonsog" : 5.312489704336296,
    "flgRegagevo" : 9.897492629215506,
    "idmediaCg99" : 3.1497903714250555,
    "percRipPerc" : 2.7977867356748476,
    "flgRitImposta" : 5.877124706116695,
    "codPrev" : "codPrev",
    "tiporapporto" : "tiporapporto",
    "percripaz" : 4.332304821875894,
    "pluginData" : {
      "key" : ""
    },
    "flgPignTerzi" : 3.7814124730767915,
    "flgProteo360" : 3.111202833403195,
    "additionalData" : {
      "key" : ""
    },
    "flgGlad" : 8.37823741034869,
    "codFiscPrev" : "codFiscPrev",
    "gcprev" : 0,
    "idprov" : 2.380090174313445,
    "codice" : "codice",
    "percci" : 0.35262192099236644,
    "flgSosprit" : 7,
    "descr" : "descr",
    "flgMinimi" : 7,
    "codTributo" : "codTributo",
    "indCodattglad" : 3.804112695731078,
    "indTipocassa" : 8,
    "percra" : 7.203794749804894,
    "percbaseimp" : 0.4833312865174044,
    "codTribrp" : "codTribrp",
    "inpsivs" : 4.518309517874243,
    "rowversion" : ""
  },
  "dtiniziopec" : "2000-01-23T04:56:07.000+00:00",
  "capfisc" : "capfisc",
  "codicecorCg07" : 5.944895607614016,
  "codiceCgc0" : 6.878052220127876,
  "cap" : "cap",
  "faxnum" : "faxnum",
  "alias" : "alias",
  "flgOmonimo" : 0.8851374739011653,
  "provnascita" : "provnascita",
  "ragsocor" : "ragsocor",
  "prov" : "prov",
  "flgAnagval" : 3.353193347011243,
  "rapazestCg16" : 4,
  "cellnum" : "cellnum",
  "flgPrsfis" : 7.058770351582356,
  "tel1num" : "tel1num",
  "idExtendedAttributeSubEntity" : 7,
  "provcor" : "provcor",
  "dtfinepec" : "2000-01-23T04:56:07.000+00:00",
  "cittacor" : "cittacor",
  "codicesfed" : "codicesfed",
  "statofedfisc" : "statofedfisc",
  "indFiscaleEX" : "indFiscaleEX",
  "partitaIVA" : "partitaIVA",
  "indirCor" : "indirCor",
  "sesso" : 8.969578798196912,
  "lastchange" : "2000-01-23T04:56:07.000+00:00",
  "ragsocorex" : "ragsocorex",
  "datanascita" : "2000-01-23T04:56:07.000+00:00",
  "auidAu04" : 1,
  "indweb" : "indweb"
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Update partial
 * Patching an object of type
 *
 * body  Object of type to patch
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request (optional)
 * warnoverwriteinconsistentvalues String If 'true', inconsistent values will be overwritten during creation or update (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOGeneralMasterDataCOIdPATCH = function(body,ignoreCompanyPolicyFilter,force,_op,warnoverwriteinconsistentvalues,company,user,id,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Update
 * Updating an object of type
 *
 * body GeneralMasterDataCODTO Object of type to update
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request (optional)
 * warnoverwriteinconsistentvalues String If 'true', inconsistent values will be overwritten during creation or update (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns GeneralMasterDataCODTO
 **/
exports.apiV1EnvironmentCOGeneralMasterDataCOIdPUT = function(body,force,ignoreCompanyPolicyFilter,_op,warnoverwriteinconsistentvalues,company,user,id,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "datavalid" : "2000-01-23T04:56:07.000+00:00",
  "ragsofiscex" : "ragsofiscex",
  "addresses" : [ {
    "indirizzocomp2" : "indirizzocomp2",
    "addressesType" : [ {
      "tipo" : 7,
      "idCG1J" : 4,
      "pluginData" : {
        "key" : ""
      },
      "id" : 1,
      "additionalData" : {
        "key" : ""
      }
    }, {
      "tipo" : 7,
      "idCG1J" : 4,
      "pluginData" : {
        "key" : ""
      },
      "id" : 1,
      "additionalData" : {
        "key" : ""
      }
    } ],
    "risstato" : "risstato",
    "riszip" : "riszip",
    "pv" : "pv",
    "precisione" : "precisione",
    "codlinguaMg52" : "codlinguaMg52",
    "frazione" : "frazione",
    "emailPec" : "emailPec",
    "tipologia" : "tipologia",
    "via" : "via",
    "idTeamportal" : 4,
    "numciv" : "numciv",
    "cap" : "cap",
    "latitudine" : 0.2025324113236393,
    "statoCg07" : 4.258773108174356,
    "presso" : "presso",
    "federalStateViewCO" : {
      "descr" : "descr",
      "iso3166statofed" : "iso3166statofed",
      "a2iso3166Cg07" : "a2iso3166Cg07",
      "pluginData" : {
        "key" : ""
      },
      "codiceCg07" : 9.132027271330688,
      "additionalData" : {
        "key" : ""
      },
      "statofed" : "statofed"
    },
    "pluginData" : {
      "key" : ""
    },
    "id" : 3,
    "additionalData" : {
      "key" : ""
    },
    "fax" : "fax",
    "statofed" : "statofed",
    "telefono" : "telefono",
    "datamod" : "2000-01-23T04:56:07.000+00:00",
    "email" : "email",
    "citta" : "citta",
    "ragsoc" : "ragsoc",
    "cellnum" : "cellnum",
    "comanaCg01" : "comanaCg01",
    "codiceCg16" : 5,
    "datacre" : "2000-01-23T04:56:07.000+00:00",
    "ragsocex" : "ragsocex",
    "rifindirizzo" : "rifindirizzo",
    "codicesfed" : "codicesfed",
    "contea" : "contea",
    "indirizzocomp" : "indirizzocomp",
    "riswarning" : "riswarning",
    "indirizzoex" : "indirizzoex",
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "risregione" : "risregione",
    "edificio" : "edificio",
    "statoEst" : {
      "codSian" : 9.702963800023566,
      "crtpiva" : "crtpiva",
      "leniban" : 6,
      "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
      "desiso3166" : "desiso3166",
      "idmediaCg99" : 5.507386964179881,
      "codice" : 0.8774076871421566,
      "numiso3166" : "numiso3166",
      "codiceCg08" : "codiceCg08",
      "currencyCO" : {
        "sigla" : "sigla",
        "dataattuem" : "2000-01-23T04:56:07.000+00:00",
        "numdec" : 8.28965939814297,
        "exchangeRateCO" : [ {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        }, {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        } ],
        "idmediaCg99" : 3.901545264248647,
        "codice" : "codice",
        "indCertoincerto" : 0,
        "cambiofisso" : 8.251625748923757,
        "descr" : "descr",
        "flgValuem" : 4.459605034958679,
        "indValuem" : 1.7325933120207193,
        "indSepmigl" : 2.9409642974827896,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "descr" : "descr",
      "flgIban" : 0,
      "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
      "codIso" : "codIso",
      "a3iso3166" : "a3iso3166",
      "indTipostato" : 4.86315908102884,
      "a2iso3166" : "a2iso3166",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datacee" : "2000-01-23T04:56:07.000+00:00",
      "flgSepa" : 7
    },
    "longitudine" : 6.628464275087742,
    "indweb" : "indweb"
  }, {
    "indirizzocomp2" : "indirizzocomp2",
    "addressesType" : [ {
      "tipo" : 7,
      "idCG1J" : 4,
      "pluginData" : {
        "key" : ""
      },
      "id" : 1,
      "additionalData" : {
        "key" : ""
      }
    }, {
      "tipo" : 7,
      "idCG1J" : 4,
      "pluginData" : {
        "key" : ""
      },
      "id" : 1,
      "additionalData" : {
        "key" : ""
      }
    } ],
    "risstato" : "risstato",
    "riszip" : "riszip",
    "pv" : "pv",
    "precisione" : "precisione",
    "codlinguaMg52" : "codlinguaMg52",
    "frazione" : "frazione",
    "emailPec" : "emailPec",
    "tipologia" : "tipologia",
    "via" : "via",
    "idTeamportal" : 4,
    "numciv" : "numciv",
    "cap" : "cap",
    "latitudine" : 0.2025324113236393,
    "statoCg07" : 4.258773108174356,
    "presso" : "presso",
    "federalStateViewCO" : {
      "descr" : "descr",
      "iso3166statofed" : "iso3166statofed",
      "a2iso3166Cg07" : "a2iso3166Cg07",
      "pluginData" : {
        "key" : ""
      },
      "codiceCg07" : 9.132027271330688,
      "additionalData" : {
        "key" : ""
      },
      "statofed" : "statofed"
    },
    "pluginData" : {
      "key" : ""
    },
    "id" : 3,
    "additionalData" : {
      "key" : ""
    },
    "fax" : "fax",
    "statofed" : "statofed",
    "telefono" : "telefono",
    "datamod" : "2000-01-23T04:56:07.000+00:00",
    "email" : "email",
    "citta" : "citta",
    "ragsoc" : "ragsoc",
    "cellnum" : "cellnum",
    "comanaCg01" : "comanaCg01",
    "codiceCg16" : 5,
    "datacre" : "2000-01-23T04:56:07.000+00:00",
    "ragsocex" : "ragsocex",
    "rifindirizzo" : "rifindirizzo",
    "codicesfed" : "codicesfed",
    "contea" : "contea",
    "indirizzocomp" : "indirizzocomp",
    "riswarning" : "riswarning",
    "indirizzoex" : "indirizzoex",
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "risregione" : "risregione",
    "edificio" : "edificio",
    "statoEst" : {
      "codSian" : 9.702963800023566,
      "crtpiva" : "crtpiva",
      "leniban" : 6,
      "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
      "desiso3166" : "desiso3166",
      "idmediaCg99" : 5.507386964179881,
      "codice" : 0.8774076871421566,
      "numiso3166" : "numiso3166",
      "codiceCg08" : "codiceCg08",
      "currencyCO" : {
        "sigla" : "sigla",
        "dataattuem" : "2000-01-23T04:56:07.000+00:00",
        "numdec" : 8.28965939814297,
        "exchangeRateCO" : [ {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        }, {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        } ],
        "idmediaCg99" : 3.901545264248647,
        "codice" : "codice",
        "indCertoincerto" : 0,
        "cambiofisso" : 8.251625748923757,
        "descr" : "descr",
        "flgValuem" : 4.459605034958679,
        "indValuem" : 1.7325933120207193,
        "indSepmigl" : 2.9409642974827896,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "descr" : "descr",
      "flgIban" : 0,
      "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
      "codIso" : "codIso",
      "a3iso3166" : "a3iso3166",
      "indTipostato" : 4.86315908102884,
      "a2iso3166" : "a2iso3166",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datacee" : "2000-01-23T04:56:07.000+00:00",
      "flgSepa" : 7
    },
    "longitudine" : 6.628464275087742,
    "indweb" : "indweb"
  } ],
  "codiceident" : "codiceident",
  "indirCorEX" : "indirCorEX",
  "flgFattpa" : 3,
  "indirizzo" : "indirizzo",
  "ragsoanagex" : "ragsoanagex",
  "codiceCg07" : 6.778324963048013,
  "indsoggrit" : 0.10263654006109402,
  "ragSoAnag" : "ragSoAnag",
  "capcor" : "capcor",
  "cittafisc" : "cittafisc",
  "intragroupStructureCO" : {
    "descr" : "descr",
    "codice" : 0.4182561061793122,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "codAnagGen" : 8,
    "codIntercompany" : 5
  },
  "statofiscCg07" : 7.740351818741173,
  "tel2num" : "tel2num",
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "codfiscale" : "codfiscale",
  "statofed" : "statofed",
  "codrichiamo" : 6,
  "provfisc" : "provfisc",
  "idExtendedAttributeEntity" : 3,
  "citta" : "citta",
  "statonascitaCg07" : 3.0205796992916243,
  "codice" : 2,
  "indFiscale" : "indFiscale",
  "nome" : "nome",
  "comnascitaCg01" : "comnascitaCg01",
  "codiceCg15" : "codiceCg15",
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ],
  "ragsofisc" : "ragsofisc",
  "indemail" : "indemail",
  "indirizzoEX" : "indirizzoEX",
  "comfisCg01" : "comfisCg01",
  "comnascita" : "comnascita",
  "partiva" : "partiva",
  "flgNoblacklist" : 7.143538047012306,
  "partivaEst" : "partivaEst",
  "cognome" : "cognome",
  "idmediaCg99" : 6.519180951018382,
  "wtCodeCO" : {
    "causdd1" : "causdd1",
    "codNonsog" : 5.312489704336296,
    "flgRegagevo" : 9.897492629215506,
    "idmediaCg99" : 3.1497903714250555,
    "percRipPerc" : 2.7977867356748476,
    "flgRitImposta" : 5.877124706116695,
    "codPrev" : "codPrev",
    "tiporapporto" : "tiporapporto",
    "percripaz" : 4.332304821875894,
    "pluginData" : {
      "key" : ""
    },
    "flgPignTerzi" : 3.7814124730767915,
    "flgProteo360" : 3.111202833403195,
    "additionalData" : {
      "key" : ""
    },
    "flgGlad" : 8.37823741034869,
    "codFiscPrev" : "codFiscPrev",
    "gcprev" : 0,
    "idprov" : 2.380090174313445,
    "codice" : "codice",
    "percci" : 0.35262192099236644,
    "flgSosprit" : 7,
    "descr" : "descr",
    "flgMinimi" : 7,
    "codTributo" : "codTributo",
    "indCodattglad" : 3.804112695731078,
    "indTipocassa" : 8,
    "percra" : 7.203794749804894,
    "percbaseimp" : 0.4833312865174044,
    "codTribrp" : "codTribrp",
    "inpsivs" : 4.518309517874243,
    "rowversion" : ""
  },
  "dtiniziopec" : "2000-01-23T04:56:07.000+00:00",
  "capfisc" : "capfisc",
  "codicecorCg07" : 5.944895607614016,
  "codiceCgc0" : 6.878052220127876,
  "cap" : "cap",
  "faxnum" : "faxnum",
  "alias" : "alias",
  "flgOmonimo" : 0.8851374739011653,
  "provnascita" : "provnascita",
  "ragsocor" : "ragsocor",
  "prov" : "prov",
  "flgAnagval" : 3.353193347011243,
  "rapazestCg16" : 4,
  "cellnum" : "cellnum",
  "flgPrsfis" : 7.058770351582356,
  "tel1num" : "tel1num",
  "idExtendedAttributeSubEntity" : 7,
  "provcor" : "provcor",
  "dtfinepec" : "2000-01-23T04:56:07.000+00:00",
  "cittacor" : "cittacor",
  "codicesfed" : "codicesfed",
  "statofedfisc" : "statofedfisc",
  "indFiscaleEX" : "indFiscaleEX",
  "partitaIVA" : "partitaIVA",
  "indirCor" : "indirCor",
  "sesso" : 8.969578798196912,
  "lastchange" : "2000-01-23T04:56:07.000+00:00",
  "ragsocorex" : "ragsocorex",
  "datanascita" : "2000-01-23T04:56:07.000+00:00",
  "auidAu04" : 1,
  "indweb" : "indweb"
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Create
 * Creating new object of type
 *
 * body GeneralMasterDataCODTO Object of type to create
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request (optional)
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * warnoverwriteinconsistentvalues String If 'true', inconsistent values will be overwritten during creation or update (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns GeneralMasterDataCODTO
 **/
exports.apiV1EnvironmentCOGeneralMasterDataCOPOST = function(body,ignoreCompanyPolicyFilter,_op,force,warnoverwriteinconsistentvalues,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "datavalid" : "2000-01-23T04:56:07.000+00:00",
  "ragsofiscex" : "ragsofiscex",
  "addresses" : [ {
    "indirizzocomp2" : "indirizzocomp2",
    "addressesType" : [ {
      "tipo" : 7,
      "idCG1J" : 4,
      "pluginData" : {
        "key" : ""
      },
      "id" : 1,
      "additionalData" : {
        "key" : ""
      }
    }, {
      "tipo" : 7,
      "idCG1J" : 4,
      "pluginData" : {
        "key" : ""
      },
      "id" : 1,
      "additionalData" : {
        "key" : ""
      }
    } ],
    "risstato" : "risstato",
    "riszip" : "riszip",
    "pv" : "pv",
    "precisione" : "precisione",
    "codlinguaMg52" : "codlinguaMg52",
    "frazione" : "frazione",
    "emailPec" : "emailPec",
    "tipologia" : "tipologia",
    "via" : "via",
    "idTeamportal" : 4,
    "numciv" : "numciv",
    "cap" : "cap",
    "latitudine" : 0.2025324113236393,
    "statoCg07" : 4.258773108174356,
    "presso" : "presso",
    "federalStateViewCO" : {
      "descr" : "descr",
      "iso3166statofed" : "iso3166statofed",
      "a2iso3166Cg07" : "a2iso3166Cg07",
      "pluginData" : {
        "key" : ""
      },
      "codiceCg07" : 9.132027271330688,
      "additionalData" : {
        "key" : ""
      },
      "statofed" : "statofed"
    },
    "pluginData" : {
      "key" : ""
    },
    "id" : 3,
    "additionalData" : {
      "key" : ""
    },
    "fax" : "fax",
    "statofed" : "statofed",
    "telefono" : "telefono",
    "datamod" : "2000-01-23T04:56:07.000+00:00",
    "email" : "email",
    "citta" : "citta",
    "ragsoc" : "ragsoc",
    "cellnum" : "cellnum",
    "comanaCg01" : "comanaCg01",
    "codiceCg16" : 5,
    "datacre" : "2000-01-23T04:56:07.000+00:00",
    "ragsocex" : "ragsocex",
    "rifindirizzo" : "rifindirizzo",
    "codicesfed" : "codicesfed",
    "contea" : "contea",
    "indirizzocomp" : "indirizzocomp",
    "riswarning" : "riswarning",
    "indirizzoex" : "indirizzoex",
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "risregione" : "risregione",
    "edificio" : "edificio",
    "statoEst" : {
      "codSian" : 9.702963800023566,
      "crtpiva" : "crtpiva",
      "leniban" : 6,
      "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
      "desiso3166" : "desiso3166",
      "idmediaCg99" : 5.507386964179881,
      "codice" : 0.8774076871421566,
      "numiso3166" : "numiso3166",
      "codiceCg08" : "codiceCg08",
      "currencyCO" : {
        "sigla" : "sigla",
        "dataattuem" : "2000-01-23T04:56:07.000+00:00",
        "numdec" : 8.28965939814297,
        "exchangeRateCO" : [ {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        }, {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        } ],
        "idmediaCg99" : 3.901545264248647,
        "codice" : "codice",
        "indCertoincerto" : 0,
        "cambiofisso" : 8.251625748923757,
        "descr" : "descr",
        "flgValuem" : 4.459605034958679,
        "indValuem" : 1.7325933120207193,
        "indSepmigl" : 2.9409642974827896,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "descr" : "descr",
      "flgIban" : 0,
      "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
      "codIso" : "codIso",
      "a3iso3166" : "a3iso3166",
      "indTipostato" : 4.86315908102884,
      "a2iso3166" : "a2iso3166",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datacee" : "2000-01-23T04:56:07.000+00:00",
      "flgSepa" : 7
    },
    "longitudine" : 6.628464275087742,
    "indweb" : "indweb"
  }, {
    "indirizzocomp2" : "indirizzocomp2",
    "addressesType" : [ {
      "tipo" : 7,
      "idCG1J" : 4,
      "pluginData" : {
        "key" : ""
      },
      "id" : 1,
      "additionalData" : {
        "key" : ""
      }
    }, {
      "tipo" : 7,
      "idCG1J" : 4,
      "pluginData" : {
        "key" : ""
      },
      "id" : 1,
      "additionalData" : {
        "key" : ""
      }
    } ],
    "risstato" : "risstato",
    "riszip" : "riszip",
    "pv" : "pv",
    "precisione" : "precisione",
    "codlinguaMg52" : "codlinguaMg52",
    "frazione" : "frazione",
    "emailPec" : "emailPec",
    "tipologia" : "tipologia",
    "via" : "via",
    "idTeamportal" : 4,
    "numciv" : "numciv",
    "cap" : "cap",
    "latitudine" : 0.2025324113236393,
    "statoCg07" : 4.258773108174356,
    "presso" : "presso",
    "federalStateViewCO" : {
      "descr" : "descr",
      "iso3166statofed" : "iso3166statofed",
      "a2iso3166Cg07" : "a2iso3166Cg07",
      "pluginData" : {
        "key" : ""
      },
      "codiceCg07" : 9.132027271330688,
      "additionalData" : {
        "key" : ""
      },
      "statofed" : "statofed"
    },
    "pluginData" : {
      "key" : ""
    },
    "id" : 3,
    "additionalData" : {
      "key" : ""
    },
    "fax" : "fax",
    "statofed" : "statofed",
    "telefono" : "telefono",
    "datamod" : "2000-01-23T04:56:07.000+00:00",
    "email" : "email",
    "citta" : "citta",
    "ragsoc" : "ragsoc",
    "cellnum" : "cellnum",
    "comanaCg01" : "comanaCg01",
    "codiceCg16" : 5,
    "datacre" : "2000-01-23T04:56:07.000+00:00",
    "ragsocex" : "ragsocex",
    "rifindirizzo" : "rifindirizzo",
    "codicesfed" : "codicesfed",
    "contea" : "contea",
    "indirizzocomp" : "indirizzocomp",
    "riswarning" : "riswarning",
    "indirizzoex" : "indirizzoex",
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "risregione" : "risregione",
    "edificio" : "edificio",
    "statoEst" : {
      "codSian" : 9.702963800023566,
      "crtpiva" : "crtpiva",
      "leniban" : 6,
      "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
      "desiso3166" : "desiso3166",
      "idmediaCg99" : 5.507386964179881,
      "codice" : 0.8774076871421566,
      "numiso3166" : "numiso3166",
      "codiceCg08" : "codiceCg08",
      "currencyCO" : {
        "sigla" : "sigla",
        "dataattuem" : "2000-01-23T04:56:07.000+00:00",
        "numdec" : 8.28965939814297,
        "exchangeRateCO" : [ {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        }, {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        } ],
        "idmediaCg99" : 3.901545264248647,
        "codice" : "codice",
        "indCertoincerto" : 0,
        "cambiofisso" : 8.251625748923757,
        "descr" : "descr",
        "flgValuem" : 4.459605034958679,
        "indValuem" : 1.7325933120207193,
        "indSepmigl" : 2.9409642974827896,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "descr" : "descr",
      "flgIban" : 0,
      "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
      "codIso" : "codIso",
      "a3iso3166" : "a3iso3166",
      "indTipostato" : 4.86315908102884,
      "a2iso3166" : "a2iso3166",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datacee" : "2000-01-23T04:56:07.000+00:00",
      "flgSepa" : 7
    },
    "longitudine" : 6.628464275087742,
    "indweb" : "indweb"
  } ],
  "codiceident" : "codiceident",
  "indirCorEX" : "indirCorEX",
  "flgFattpa" : 3,
  "indirizzo" : "indirizzo",
  "ragsoanagex" : "ragsoanagex",
  "codiceCg07" : 6.778324963048013,
  "indsoggrit" : 0.10263654006109402,
  "ragSoAnag" : "ragSoAnag",
  "capcor" : "capcor",
  "cittafisc" : "cittafisc",
  "intragroupStructureCO" : {
    "descr" : "descr",
    "codice" : 0.4182561061793122,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "codAnagGen" : 8,
    "codIntercompany" : 5
  },
  "statofiscCg07" : 7.740351818741173,
  "tel2num" : "tel2num",
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "codfiscale" : "codfiscale",
  "statofed" : "statofed",
  "codrichiamo" : 6,
  "provfisc" : "provfisc",
  "idExtendedAttributeEntity" : 3,
  "citta" : "citta",
  "statonascitaCg07" : 3.0205796992916243,
  "codice" : 2,
  "indFiscale" : "indFiscale",
  "nome" : "nome",
  "comnascitaCg01" : "comnascitaCg01",
  "codiceCg15" : "codiceCg15",
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ],
  "ragsofisc" : "ragsofisc",
  "indemail" : "indemail",
  "indirizzoEX" : "indirizzoEX",
  "comfisCg01" : "comfisCg01",
  "comnascita" : "comnascita",
  "partiva" : "partiva",
  "flgNoblacklist" : 7.143538047012306,
  "partivaEst" : "partivaEst",
  "cognome" : "cognome",
  "idmediaCg99" : 6.519180951018382,
  "wtCodeCO" : {
    "causdd1" : "causdd1",
    "codNonsog" : 5.312489704336296,
    "flgRegagevo" : 9.897492629215506,
    "idmediaCg99" : 3.1497903714250555,
    "percRipPerc" : 2.7977867356748476,
    "flgRitImposta" : 5.877124706116695,
    "codPrev" : "codPrev",
    "tiporapporto" : "tiporapporto",
    "percripaz" : 4.332304821875894,
    "pluginData" : {
      "key" : ""
    },
    "flgPignTerzi" : 3.7814124730767915,
    "flgProteo360" : 3.111202833403195,
    "additionalData" : {
      "key" : ""
    },
    "flgGlad" : 8.37823741034869,
    "codFiscPrev" : "codFiscPrev",
    "gcprev" : 0,
    "idprov" : 2.380090174313445,
    "codice" : "codice",
    "percci" : 0.35262192099236644,
    "flgSosprit" : 7,
    "descr" : "descr",
    "flgMinimi" : 7,
    "codTributo" : "codTributo",
    "indCodattglad" : 3.804112695731078,
    "indTipocassa" : 8,
    "percra" : 7.203794749804894,
    "percbaseimp" : 0.4833312865174044,
    "codTribrp" : "codTribrp",
    "inpsivs" : 4.518309517874243,
    "rowversion" : ""
  },
  "dtiniziopec" : "2000-01-23T04:56:07.000+00:00",
  "capfisc" : "capfisc",
  "codicecorCg07" : 5.944895607614016,
  "codiceCgc0" : 6.878052220127876,
  "cap" : "cap",
  "faxnum" : "faxnum",
  "alias" : "alias",
  "flgOmonimo" : 0.8851374739011653,
  "provnascita" : "provnascita",
  "ragsocor" : "ragsocor",
  "prov" : "prov",
  "flgAnagval" : 3.353193347011243,
  "rapazestCg16" : 4,
  "cellnum" : "cellnum",
  "flgPrsfis" : 7.058770351582356,
  "tel1num" : "tel1num",
  "idExtendedAttributeSubEntity" : 7,
  "provcor" : "provcor",
  "dtfinepec" : "2000-01-23T04:56:07.000+00:00",
  "cittacor" : "cittacor",
  "codicesfed" : "codicesfed",
  "statofedfisc" : "statofedfisc",
  "indFiscaleEX" : "indFiscaleEX",
  "partitaIVA" : "partitaIVA",
  "indirCor" : "indirCor",
  "sesso" : 8.969578798196912,
  "lastchange" : "2000-01-23T04:56:07.000+00:00",
  "ragsocorex" : "ragsocorex",
  "datanascita" : "2000-01-23T04:56:07.000+00:00",
  "auidAu04" : 1,
  "indweb" : "indweb"
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Validate
 * Validation of object of type
 *
 * body GeneralMasterDataCODTO Object of type to validate
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOGeneralMasterDataCOValidatePOST = function(body,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Validation of one on more properties of Type
 * Validation of object of type
 *
 * body String  - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED<br> - The id of an existing object to validate properties, or '' if the object does not exist yet <br> (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns ValidateDTO
 **/
exports.apiV1EnvironmentCOGeneralMasterDataCOValidatePropertiesPOST = function(body,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "items" : [ {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  }, {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  } ]
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}

