'use strict';


/**
 * Get new
 * Get an empty object of type corresponding
 *
 * _op String The value must be 'new'
 * param String Specify optional parameters that will be used during entity creation
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns CategoryCODTO
 **/
exports.apiV1EnvironmentCOCategoryCOGET = function(_op,param,environment,authorizationScope,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "macrocatMg10" : "macrocatMg10",
  "tipocfMg10" : 6.027456183070403,
  "descrcat" : "descrcat",
  "dittaCg18" : 0.8008281904610115,
  "categ" : "categ",
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  }
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Delete
 * Deleting object of type 
 *
 * id String 
 * environment String 
 * tipocfMg10 String TipocfMg10 Mandatory to execute current action
 * macrocatMg10 String MacrocatMg10 Mandatory to execute current action
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOCategoryCOIdDELETE = function(id,environment,tipocfMg10,macrocatMg10,authorizationScope,force,ignoreCompanyPolicyFilter,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Get by ID
 * Get an object of type corresponding the requested id
 *
 * id String Id to get the object
 * environment String 
 * tipocfMg10 String TipocfMg10 Mandatory to execute current action
 * macrocatMg10 String MacrocatMg10 Mandatory to execute current action
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * dlevel String Serialization level (optional)
 * dlevelkey String Serialization level key (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns CategoryCODTO
 **/
exports.apiV1EnvironmentCOCategoryCOIdGET = function(id,environment,tipocfMg10,macrocatMg10,authorizationScope,ignoreCompanyPolicyFilter,dlevel,dlevelkey,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "macrocatMg10" : "macrocatMg10",
  "tipocfMg10" : 6.027456183070403,
  "descrcat" : "descrcat",
  "dittaCg18" : 0.8008281904610115,
  "categ" : "categ",
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  }
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Update partial
 * Patching an object of type
 *
 * body  Object of type to patch
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request (optional)
 * tipocfMg10 String TipocfMg10 Mandatory to execute current action
 * macrocatMg10 String MacrocatMg10 Mandatory to execute current action
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOCategoryCOIdPATCH = function(body,ignoreCompanyPolicyFilter,force,_op,tipocfMg10,macrocatMg10,company,user,id,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Update
 * Updating an object of type
 *
 * body CategoryCODTO Object of type to update
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request (optional)
 * tipocfMg10 String TipocfMg10 Mandatory to execute current action
 * macrocatMg10 String MacrocatMg10 Mandatory to execute current action
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns CategoryCODTO
 **/
exports.apiV1EnvironmentCOCategoryCOIdPUT = function(body,force,ignoreCompanyPolicyFilter,_op,tipocfMg10,macrocatMg10,company,user,id,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "macrocatMg10" : "macrocatMg10",
  "tipocfMg10" : 6.027456183070403,
  "descrcat" : "descrcat",
  "dittaCg18" : 0.8008281904610115,
  "categ" : "categ",
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  }
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Create
 * Creating new object of type
 *
 * body CategoryCODTO Object of type to create
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request (optional)
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns CategoryCODTO
 **/
exports.apiV1EnvironmentCOCategoryCOPOST = function(body,ignoreCompanyPolicyFilter,_op,force,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "macrocatMg10" : "macrocatMg10",
  "tipocfMg10" : 6.027456183070403,
  "descrcat" : "descrcat",
  "dittaCg18" : 0.8008281904610115,
  "categ" : "categ",
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  }
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Validate
 * Validation of object of type
 *
 * body CategoryCODTO Object of type to validate
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOCategoryCOValidatePOST = function(body,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Validation of one on more properties of Type
 * Validation of object of type
 *
 * body String  - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED<br> - The id of an existing object to validate properties, or '' if the object does not exist yet <br> (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns ValidateDTO
 **/
exports.apiV1EnvironmentCOCategoryCOValidatePropertiesPOST = function(body,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "items" : [ {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  }, {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  } ]
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}

