/* 
 * TSE Cloud - CO
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.3000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// PgmExecDTO
    /// </summary>
    [DataContract]
        public partial class PgmExecDTO :  IEquatable<PgmExecDTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="PgmExecDTO" /> class.
        /// </summary>
        /// <param name="idTaskScheduled">Id for Scheduled Task (required).</param>
        /// <param name="timeoutSeconds">Timeout in seconds for Scheduled Task (default to 90).</param>
        /// <param name="skipIfRunning">Skip if a task with same id is running (default to true).</param>
        public PgmExecDTO(string idTaskScheduled = default(string), int? timeoutSeconds = 90, bool? skipIfRunning = true)
        {
            // to ensure "idTaskScheduled" is required (not null)
            if (idTaskScheduled == null)
            {
                throw new InvalidDataException("idTaskScheduled is a required property for PgmExecDTO and cannot be null");
            }
            else
            {
                this.IdTaskScheduled = idTaskScheduled;
            }
            // use default value if no "timeoutSeconds" provided
            if (timeoutSeconds == null)
            {
                this.TimeoutSeconds = 90;
            }
            else
            {
                this.TimeoutSeconds = timeoutSeconds;
            }
            // use default value if no "skipIfRunning" provided
            if (skipIfRunning == null)
            {
                this.SkipIfRunning = true;
            }
            else
            {
                this.SkipIfRunning = skipIfRunning;
            }
        }
        
        /// <summary>
        /// Id for Scheduled Task
        /// </summary>
        /// <value>Id for Scheduled Task</value>
        [DataMember(Name="idTaskScheduled", EmitDefaultValue=false)]
        public string IdTaskScheduled { get; set; }

        /// <summary>
        /// Timeout in seconds for Scheduled Task
        /// </summary>
        /// <value>Timeout in seconds for Scheduled Task</value>
        [DataMember(Name="timeoutSeconds", EmitDefaultValue=false)]
        public int? TimeoutSeconds { get; set; }

        /// <summary>
        /// Skip if a task with same id is running
        /// </summary>
        /// <value>Skip if a task with same id is running</value>
        [DataMember(Name="skipIfRunning", EmitDefaultValue=false)]
        public bool? SkipIfRunning { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class PgmExecDTO {\n");
            sb.Append("  IdTaskScheduled: ").Append(IdTaskScheduled).Append("\n");
            sb.Append("  TimeoutSeconds: ").Append(TimeoutSeconds).Append("\n");
            sb.Append("  SkipIfRunning: ").Append(SkipIfRunning).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as PgmExecDTO);
        }

        /// <summary>
        /// Returns true if PgmExecDTO instances are equal
        /// </summary>
        /// <param name="input">Instance of PgmExecDTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(PgmExecDTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.IdTaskScheduled == input.IdTaskScheduled ||
                    (this.IdTaskScheduled != null &&
                    this.IdTaskScheduled.Equals(input.IdTaskScheduled))
                ) && 
                (
                    this.TimeoutSeconds == input.TimeoutSeconds ||
                    (this.TimeoutSeconds != null &&
                    this.TimeoutSeconds.Equals(input.TimeoutSeconds))
                ) && 
                (
                    this.SkipIfRunning == input.SkipIfRunning ||
                    (this.SkipIfRunning != null &&
                    this.SkipIfRunning.Equals(input.SkipIfRunning))
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.IdTaskScheduled != null)
                    hashCode = hashCode * 59 + this.IdTaskScheduled.GetHashCode();
                if (this.TimeoutSeconds != null)
                    hashCode = hashCode * 59 + this.TimeoutSeconds.GetHashCode();
                if (this.SkipIfRunning != null)
                    hashCode = hashCode * 59 + this.SkipIfRunning.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
