/* 
 * TSE Cloud - CO
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.3000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// CG44_CLIFOR - Cliente fornitore&lt;br&gt;Proprietà chiave:&lt;ul&gt;&lt;li&gt;&lt;b&gt;Idclifor&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;
    /// </summary>
    [DataContract]
        public partial class CustomerSupplierCODTO :  IEquatable<CustomerSupplierCODTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="CustomerSupplierCODTO" /> class.
        /// </summary>
        /// <param name="gmdUpdateAdditionalParams">gmdUpdateAdditionalParams.</param>
        /// <param name="clifor">CG44_CLIFOR - Codice cli/for (required).</param>
        /// <param name="codAbiCg12">CG44_CODABI_CG12 - Codice banca.</param>
        /// <param name="codCabCg13">CG44_CODCAB_CG13 - Codice agenzia.</param>
        /// <param name="codiceCg28">CG44_CODICE_CG28 - Codice aliquota IVA.</param>
        /// <param name="contoCg24">CG44_CONTO_CG24 - Conto merci.</param>
        /// <param name="contorCg24">CG44_CONTOR_CG24 - Conto merci reso.</param>
        /// <param name="contratto">CG44_CONTRATTO - Codice contratto.</param>
        /// <param name="datavaliva">CG44_DATAVALIVA - Fine validità codice IVA.</param>
        /// <param name="dittaCg18">CG44_DITTA_CG18 - Ditta (required).</param>
        /// <param name="flgArt62">CG44_FLGART62 - Flag Art. 62 (default to 0).</param>
        /// <param name="flgAttivo">CG44_FLGATTIVO - Attivo (default to 1).</param>
        /// <param name="flgCointestati">CG44_FLGCOINTESTATI - Cointestati (default to 0).</param>
        /// <param name="flgIntercompany">CG44_FLGINTERCOMPANY - Gest. Intercompany (default to 0).</param>
        /// <param name="ggscadfix">CG44_GGSCADFIX - GG scad. fix.</param>
        /// <param name="gruppoCg10">CG44_GRUPPO_CG10 - Codice Pdc.</param>
        /// <param name="guid">CG44_GUID - GUID.</param>
        /// <param name="idclifor">CG44_IDCLIFOR - ID cliente (Required only in PUT/PATCH).</param>
        /// <param name="idmediaCg99">CG44_IDMEDIA_CG99 - ID HyperMedia.</param>
        /// <param name="indElenchimov3000">CG44_INDELENCHIMOV3000 - Ind. gestione elenchi mov. 3.000€&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;99&lt;/i&gt; - Come da anag. generale&lt;/li&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Contratto &gt;&#x3D; 3.000€&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Contratto corrisp. periodici&lt;/li&gt;&lt;/ul&gt; (default to 99).</param>
        /// <param name="intermedioCg40">CG44_INTERMEDIO_CG40 - Codice intermedio.</param>
        /// <param name="lastchange">CG44_LASTCHANGE - Data ultima variazione.</param>
        /// <param name="progREf08">CG44_PROGR_EF08 - Codice banca aziendale.</param>
        /// <param name="tipocf">CG44_TIPOCF - Tipo Cliente / Fornitore&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; -  Cliente&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; -  Fornitore&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="idExtendedAttributeEntity">idExtendedAttributeEntity.</param>
        /// <param name="idExtendedAttributeSubEntity">idExtendedAttributeSubEntity.</param>
        /// <param name="agentCO">agentCO.</param>
        /// <param name="blackListGeneralMasterData">blackListGeneralMasterData.</param>
        /// <param name="csAccountingIndexCO">csAccountingIndexCO.</param>
        /// <param name="csBankCO">csBankCO.</param>
        /// <param name="csCompanyBankCO">csCompanyBankCO.</param>
        /// <param name="csInfoCO">csInfoCO.</param>
        /// <param name="csJointlyHeldCO">csJointlyHeldCO.</param>
        /// <param name="csPaymentRangeCO">csPaymentRangeCO.</param>
        /// <param name="csPostponementPeriodCO">csPostponementPeriodCO.</param>
        /// <param name="csSddCO">csSddCO.</param>
        /// <param name="currencyCO">currencyCO.</param>
        /// <param name="customerSupplierCIGCUPCO">customerSupplierCIGCUPCO.</param>
        /// <param name="custSupplDataInvoicePACO">custSupplDataInvoicePACO.</param>
        /// <param name="dmsPublishedEntityFW">dmsPublishedEntityFW.</param>
        /// <param name="generalMasterDataCO">generalMasterDataCO (required).</param>
        /// <param name="officeCO">officeCO.</param>
        /// <param name="officePACO">officePACO.</param>
        /// <param name="paymentTermCO">paymentTermCO.</param>
        /// <param name="statoAttualeCO">statoAttualeCO.</param>
        /// <param name="vatCodeCO">vatCodeCO.</param>
        /// <param name="extensionData">extensionData.</param>
        /// <param name="additionalData">additionalData.</param>
        /// <param name="pluginData">pluginData.</param>
        public CustomerSupplierCODTO(GMDUpdateAdditionalParametersDTO gmdUpdateAdditionalParams = default(GMDUpdateAdditionalParametersDTO), double? clifor = default(double?), double? codAbiCg12 = default(double?), double? codCabCg13 = default(double?), string codiceCg28 = default(string), string contoCg24 = default(string), string contorCg24 = default(string), string contratto = default(string), DateTime? datavaliva = default(DateTime?), double? dittaCg18 = default(double?), int? flgArt62 = 0, double? flgAttivo = 1, double? flgCointestati = 0, double? flgIntercompany = 0, double? ggscadfix = default(double?), double? gruppoCg10 = default(double?), Guid? guid = default(Guid?), int? idclifor = default(int?), double? idmediaCg99 = default(double?), int? indElenchimov3000 = 99, double? intermedioCg40 = default(double?), DateTime? lastchange = default(DateTime?), double? progREf08 = default(double?), double? tipocf = default(double?), int? idExtendedAttributeEntity = default(int?), int? idExtendedAttributeSubEntity = default(int?), AgentCODTO agentCO = default(AgentCODTO), GeneralMasterDataCODTO blackListGeneralMasterData = default(GeneralMasterDataCODTO), CSAccountingIndexCODTO csAccountingIndexCO = default(CSAccountingIndexCODTO), List<CSBankCODTO> csBankCO = default(List<CSBankCODTO>), List<CSCompanyBankCODTO> csCompanyBankCO = default(List<CSCompanyBankCODTO>), CSInfoCODTO csInfoCO = default(CSInfoCODTO), List<CSJointlyHeldCODTO> csJointlyHeldCO = default(List<CSJointlyHeldCODTO>), List<CSPaymentRangeCODTO> csPaymentRangeCO = default(List<CSPaymentRangeCODTO>), List<CSPostponementPeriodCODTO> csPostponementPeriodCO = default(List<CSPostponementPeriodCODTO>), List<CSSddCODTO> csSddCO = default(List<CSSddCODTO>), CurrencyCODTO currencyCO = default(CurrencyCODTO), List<CustomerSupplierCIGCUPCODTO> customerSupplierCIGCUPCO = default(List<CustomerSupplierCIGCUPCODTO>), CustSupplDataInvoicePACODTO custSupplDataInvoicePACO = default(CustSupplDataInvoicePACODTO), DMSPublishedEntityFWDTO dmsPublishedEntityFW = default(DMSPublishedEntityFWDTO), GeneralMasterDataCODTO generalMasterDataCO = default(GeneralMasterDataCODTO), OfficeCODTO officeCO = default(OfficeCODTO), List<OfficePACODTO> officePACO = default(List<OfficePACODTO>), PaymentTermCODTO paymentTermCO = default(PaymentTermCODTO), StatoAttualeDTO statoAttualeCO = default(StatoAttualeDTO), VatCodeCODTO vatCodeCO = default(VatCodeCODTO), List<StringObjectKeyValuePair> extensionData = default(List<StringObjectKeyValuePair>), Dictionary<string, Object> additionalData = default(Dictionary<string, Object>), Dictionary<string, Object> pluginData = default(Dictionary<string, Object>))
        {
            // to ensure "clifor" is required (not null)
            if (clifor == null)
            {
                throw new InvalidDataException("clifor is a required property for CustomerSupplierCODTO and cannot be null");
            }
            else
            {
                this.Clifor = clifor;
            }
            // to ensure "dittaCg18" is required (not null)
            if (dittaCg18 == null)
            {
                throw new InvalidDataException("dittaCg18 is a required property for CustomerSupplierCODTO and cannot be null");
            }
            else
            {
                this.DittaCg18 = dittaCg18;
            }
            // to ensure "generalMasterDataCO" is required (not null)
            if (generalMasterDataCO == null)
            {
                throw new InvalidDataException("generalMasterDataCO is a required property for CustomerSupplierCODTO and cannot be null");
            }
            else
            {
                this.GeneralMasterDataCO = generalMasterDataCO;
            }
            this.GmdUpdateAdditionalParams = gmdUpdateAdditionalParams;
            this.CodAbiCg12 = codAbiCg12;
            this.CodCabCg13 = codCabCg13;
            this.CodiceCg28 = codiceCg28;
            this.ContoCg24 = contoCg24;
            this.ContorCg24 = contorCg24;
            this.Contratto = contratto;
            this.Datavaliva = datavaliva;
            // use default value if no "flgArt62" provided
            if (flgArt62 == null)
            {
                this.FlgArt62 = 0;
            }
            else
            {
                this.FlgArt62 = flgArt62;
            }
            // use default value if no "flgAttivo" provided
            if (flgAttivo == null)
            {
                this.FlgAttivo = 1;
            }
            else
            {
                this.FlgAttivo = flgAttivo;
            }
            // use default value if no "flgCointestati" provided
            if (flgCointestati == null)
            {
                this.FlgCointestati = 0;
            }
            else
            {
                this.FlgCointestati = flgCointestati;
            }
            // use default value if no "flgIntercompany" provided
            if (flgIntercompany == null)
            {
                this.FlgIntercompany = 0;
            }
            else
            {
                this.FlgIntercompany = flgIntercompany;
            }
            this.Ggscadfix = ggscadfix;
            this.GruppoCg10 = gruppoCg10;
            this.Guid = guid;
            this.Idclifor = idclifor;
            this.IdmediaCg99 = idmediaCg99;
            // use default value if no "indElenchimov3000" provided
            if (indElenchimov3000 == null)
            {
                this.IndElenchimov3000 = 99;
            }
            else
            {
                this.IndElenchimov3000 = indElenchimov3000;
            }
            this.IntermedioCg40 = intermedioCg40;
            this.Lastchange = lastchange;
            this.ProgREf08 = progREf08;
            this.Tipocf = tipocf;
            this.IdExtendedAttributeEntity = idExtendedAttributeEntity;
            this.IdExtendedAttributeSubEntity = idExtendedAttributeSubEntity;
            this.AgentCO = agentCO;
            this.BlackListGeneralMasterData = blackListGeneralMasterData;
            this.CsAccountingIndexCO = csAccountingIndexCO;
            this.CsBankCO = csBankCO;
            this.CsCompanyBankCO = csCompanyBankCO;
            this.CsInfoCO = csInfoCO;
            this.CsJointlyHeldCO = csJointlyHeldCO;
            this.CsPaymentRangeCO = csPaymentRangeCO;
            this.CsPostponementPeriodCO = csPostponementPeriodCO;
            this.CsSddCO = csSddCO;
            this.CurrencyCO = currencyCO;
            this.CustomerSupplierCIGCUPCO = customerSupplierCIGCUPCO;
            this.CustSupplDataInvoicePACO = custSupplDataInvoicePACO;
            this.DmsPublishedEntityFW = dmsPublishedEntityFW;
            this.OfficeCO = officeCO;
            this.OfficePACO = officePACO;
            this.PaymentTermCO = paymentTermCO;
            this.StatoAttualeCO = statoAttualeCO;
            this.VatCodeCO = vatCodeCO;
            this.ExtensionData = extensionData;
            this.AdditionalData = additionalData;
            this.PluginData = pluginData;
        }
        
        /// <summary>
        /// Gets or Sets GmdUpdateAdditionalParams
        /// </summary>
        [DataMember(Name="gmdUpdateAdditionalParams", EmitDefaultValue=false)]
        public GMDUpdateAdditionalParametersDTO GmdUpdateAdditionalParams { get; set; }

        /// <summary>
        /// CG44_CLIFOR - Codice cli/for
        /// </summary>
        /// <value>CG44_CLIFOR - Codice cli/for</value>
        [DataMember(Name="clifor", EmitDefaultValue=false)]
        public double? Clifor { get; set; }

        /// <summary>
        /// CG44_CODABI_CG12 - Codice banca
        /// </summary>
        /// <value>CG44_CODABI_CG12 - Codice banca</value>
        [DataMember(Name="codAbiCg12", EmitDefaultValue=false)]
        public double? CodAbiCg12 { get; set; }

        /// <summary>
        /// CG44_CODCAB_CG13 - Codice agenzia
        /// </summary>
        /// <value>CG44_CODCAB_CG13 - Codice agenzia</value>
        [DataMember(Name="codCabCg13", EmitDefaultValue=false)]
        public double? CodCabCg13 { get; set; }

        /// <summary>
        /// CG44_CODICE_CG28 - Codice aliquota IVA
        /// </summary>
        /// <value>CG44_CODICE_CG28 - Codice aliquota IVA</value>
        [DataMember(Name="codiceCg28", EmitDefaultValue=false)]
        public string CodiceCg28 { get; set; }

        /// <summary>
        /// CG44_CONTO_CG24 - Conto merci
        /// </summary>
        /// <value>CG44_CONTO_CG24 - Conto merci</value>
        [DataMember(Name="contoCg24", EmitDefaultValue=false)]
        public string ContoCg24 { get; set; }

        /// <summary>
        /// CG44_CONTOR_CG24 - Conto merci reso
        /// </summary>
        /// <value>CG44_CONTOR_CG24 - Conto merci reso</value>
        [DataMember(Name="contorCg24", EmitDefaultValue=false)]
        public string ContorCg24 { get; set; }

        /// <summary>
        /// CG44_CONTRATTO - Codice contratto
        /// </summary>
        /// <value>CG44_CONTRATTO - Codice contratto</value>
        [DataMember(Name="contratto", EmitDefaultValue=false)]
        public string Contratto { get; set; }

        /// <summary>
        /// CG44_DATAVALIVA - Fine validità codice IVA
        /// </summary>
        /// <value>CG44_DATAVALIVA - Fine validità codice IVA</value>
        [DataMember(Name="datavaliva", EmitDefaultValue=false)]
        public DateTime? Datavaliva { get; set; }

        /// <summary>
        /// CG44_DITTA_CG18 - Ditta
        /// </summary>
        /// <value>CG44_DITTA_CG18 - Ditta</value>
        [DataMember(Name="dittaCg18", EmitDefaultValue=false)]
        public double? DittaCg18 { get; set; }

        /// <summary>
        /// CG44_FLGART62 - Flag Art. 62
        /// </summary>
        /// <value>CG44_FLGART62 - Flag Art. 62</value>
        [DataMember(Name="flgArt62", EmitDefaultValue=false)]
        public int? FlgArt62 { get; set; }

        /// <summary>
        /// CG44_FLGATTIVO - Attivo
        /// </summary>
        /// <value>CG44_FLGATTIVO - Attivo</value>
        [DataMember(Name="flgAttivo", EmitDefaultValue=false)]
        public double? FlgAttivo { get; set; }

        /// <summary>
        /// CG44_FLGCOINTESTATI - Cointestati
        /// </summary>
        /// <value>CG44_FLGCOINTESTATI - Cointestati</value>
        [DataMember(Name="flgCointestati", EmitDefaultValue=false)]
        public double? FlgCointestati { get; set; }

        /// <summary>
        /// CG44_FLGINTERCOMPANY - Gest. Intercompany
        /// </summary>
        /// <value>CG44_FLGINTERCOMPANY - Gest. Intercompany</value>
        [DataMember(Name="flgIntercompany", EmitDefaultValue=false)]
        public double? FlgIntercompany { get; set; }

        /// <summary>
        /// CG44_GGSCADFIX - GG scad. fix
        /// </summary>
        /// <value>CG44_GGSCADFIX - GG scad. fix</value>
        [DataMember(Name="ggscadfix", EmitDefaultValue=false)]
        public double? Ggscadfix { get; set; }

        /// <summary>
        /// CG44_GRUPPO_CG10 - Codice Pdc
        /// </summary>
        /// <value>CG44_GRUPPO_CG10 - Codice Pdc</value>
        [DataMember(Name="gruppoCg10", EmitDefaultValue=false)]
        public double? GruppoCg10 { get; set; }

        /// <summary>
        /// CG44_GUID - GUID
        /// </summary>
        /// <value>CG44_GUID - GUID</value>
        [DataMember(Name="guid", EmitDefaultValue=false)]
        public Guid? Guid { get; set; }

        /// <summary>
        /// CG44_IDCLIFOR - ID cliente (Required only in PUT/PATCH)
        /// </summary>
        /// <value>CG44_IDCLIFOR - ID cliente (Required only in PUT/PATCH)</value>
        [DataMember(Name="idclifor", EmitDefaultValue=false)]
        public int? Idclifor { get; set; }

        /// <summary>
        /// CG44_IDMEDIA_CG99 - ID HyperMedia
        /// </summary>
        /// <value>CG44_IDMEDIA_CG99 - ID HyperMedia</value>
        [DataMember(Name="idmediaCg99", EmitDefaultValue=false)]
        public double? IdmediaCg99 { get; set; }

        /// <summary>
        /// CG44_INDELENCHIMOV3000 - Ind. gestione elenchi mov. 3.000€&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;99&lt;/i&gt; - Come da anag. generale&lt;/li&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Contratto &gt;&#x3D; 3.000€&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Contratto corrisp. periodici&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG44_INDELENCHIMOV3000 - Ind. gestione elenchi mov. 3.000€&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;99&lt;/i&gt; - Come da anag. generale&lt;/li&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Contratto &gt;&#x3D; 3.000€&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Contratto corrisp. periodici&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indElenchimov3000", EmitDefaultValue=false)]
        public int? IndElenchimov3000 { get; set; }

        /// <summary>
        /// CG44_INTERMEDIO_CG40 - Codice intermedio
        /// </summary>
        /// <value>CG44_INTERMEDIO_CG40 - Codice intermedio</value>
        [DataMember(Name="intermedioCg40", EmitDefaultValue=false)]
        public double? IntermedioCg40 { get; set; }

        /// <summary>
        /// CG44_LASTCHANGE - Data ultima variazione
        /// </summary>
        /// <value>CG44_LASTCHANGE - Data ultima variazione</value>
        [DataMember(Name="lastchange", EmitDefaultValue=false)]
        public DateTime? Lastchange { get; set; }

        /// <summary>
        /// CG44_PROGR_EF08 - Codice banca aziendale
        /// </summary>
        /// <value>CG44_PROGR_EF08 - Codice banca aziendale</value>
        [DataMember(Name="progREf08", EmitDefaultValue=false)]
        public double? ProgREf08 { get; set; }

        /// <summary>
        /// CG44_TIPOCF - Tipo Cliente / Fornitore&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; -  Cliente&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; -  Fornitore&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG44_TIPOCF - Tipo Cliente / Fornitore&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; -  Cliente&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; -  Fornitore&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="tipocf", EmitDefaultValue=false)]
        public double? Tipocf { get; set; }

        /// <summary>
        /// Gets or Sets IdExtendedAttributeEntity
        /// </summary>
        [DataMember(Name="idExtendedAttributeEntity", EmitDefaultValue=false)]
        public int? IdExtendedAttributeEntity { get; set; }

        /// <summary>
        /// Gets or Sets IdExtendedAttributeSubEntity
        /// </summary>
        [DataMember(Name="idExtendedAttributeSubEntity", EmitDefaultValue=false)]
        public int? IdExtendedAttributeSubEntity { get; set; }

        /// <summary>
        /// Gets or Sets AgentCO
        /// </summary>
        [DataMember(Name="agentCO", EmitDefaultValue=false)]
        public AgentCODTO AgentCO { get; set; }

        /// <summary>
        /// Gets or Sets BlackListGeneralMasterData
        /// </summary>
        [DataMember(Name="blackListGeneralMasterData", EmitDefaultValue=false)]
        public GeneralMasterDataCODTO BlackListGeneralMasterData { get; set; }

        /// <summary>
        /// Gets or Sets CsAccountingIndexCO
        /// </summary>
        [DataMember(Name="csAccountingIndexCO", EmitDefaultValue=false)]
        public CSAccountingIndexCODTO CsAccountingIndexCO { get; set; }

        /// <summary>
        /// Gets or Sets CsBankCO
        /// </summary>
        [DataMember(Name="csBankCO", EmitDefaultValue=false)]
        public List<CSBankCODTO> CsBankCO { get; set; }

        /// <summary>
        /// Gets or Sets CsCompanyBankCO
        /// </summary>
        [DataMember(Name="csCompanyBankCO", EmitDefaultValue=false)]
        public List<CSCompanyBankCODTO> CsCompanyBankCO { get; set; }

        /// <summary>
        /// Gets or Sets CsInfoCO
        /// </summary>
        [DataMember(Name="csInfoCO", EmitDefaultValue=false)]
        public CSInfoCODTO CsInfoCO { get; set; }

        /// <summary>
        /// Gets or Sets CsJointlyHeldCO
        /// </summary>
        [DataMember(Name="csJointlyHeldCO", EmitDefaultValue=false)]
        public List<CSJointlyHeldCODTO> CsJointlyHeldCO { get; set; }

        /// <summary>
        /// Gets or Sets CsPaymentRangeCO
        /// </summary>
        [DataMember(Name="csPaymentRangeCO", EmitDefaultValue=false)]
        public List<CSPaymentRangeCODTO> CsPaymentRangeCO { get; set; }

        /// <summary>
        /// Gets or Sets CsPostponementPeriodCO
        /// </summary>
        [DataMember(Name="csPostponementPeriodCO", EmitDefaultValue=false)]
        public List<CSPostponementPeriodCODTO> CsPostponementPeriodCO { get; set; }

        /// <summary>
        /// Gets or Sets CsSddCO
        /// </summary>
        [DataMember(Name="csSddCO", EmitDefaultValue=false)]
        public List<CSSddCODTO> CsSddCO { get; set; }

        /// <summary>
        /// Gets or Sets CurrencyCO
        /// </summary>
        [DataMember(Name="currencyCO", EmitDefaultValue=false)]
        public CurrencyCODTO CurrencyCO { get; set; }

        /// <summary>
        /// Gets or Sets CustomerSupplierCIGCUPCO
        /// </summary>
        [DataMember(Name="customerSupplierCIGCUPCO", EmitDefaultValue=false)]
        public List<CustomerSupplierCIGCUPCODTO> CustomerSupplierCIGCUPCO { get; set; }

        /// <summary>
        /// Gets or Sets CustSupplDataInvoicePACO
        /// </summary>
        [DataMember(Name="custSupplDataInvoicePACO", EmitDefaultValue=false)]
        public CustSupplDataInvoicePACODTO CustSupplDataInvoicePACO { get; set; }

        /// <summary>
        /// Gets or Sets DmsPublishedEntityFW
        /// </summary>
        [DataMember(Name="dmsPublishedEntityFW", EmitDefaultValue=false)]
        public DMSPublishedEntityFWDTO DmsPublishedEntityFW { get; set; }

        /// <summary>
        /// Gets or Sets GeneralMasterDataCO
        /// </summary>
        [DataMember(Name="generalMasterDataCO", EmitDefaultValue=false)]
        public GeneralMasterDataCODTO GeneralMasterDataCO { get; set; }

        /// <summary>
        /// Gets or Sets OfficeCO
        /// </summary>
        [DataMember(Name="officeCO", EmitDefaultValue=false)]
        public OfficeCODTO OfficeCO { get; set; }

        /// <summary>
        /// Gets or Sets OfficePACO
        /// </summary>
        [DataMember(Name="officePACO", EmitDefaultValue=false)]
        public List<OfficePACODTO> OfficePACO { get; set; }

        /// <summary>
        /// Gets or Sets PaymentTermCO
        /// </summary>
        [DataMember(Name="paymentTermCO", EmitDefaultValue=false)]
        public PaymentTermCODTO PaymentTermCO { get; set; }

        /// <summary>
        /// Gets or Sets StatoAttualeCO
        /// </summary>
        [DataMember(Name="statoAttualeCO", EmitDefaultValue=false)]
        public StatoAttualeDTO StatoAttualeCO { get; set; }

        /// <summary>
        /// Gets or Sets VatCodeCO
        /// </summary>
        [DataMember(Name="vatCodeCO", EmitDefaultValue=false)]
        public VatCodeCODTO VatCodeCO { get; set; }

        /// <summary>
        /// Gets or Sets ExtensionData
        /// </summary>
        [DataMember(Name="extensionData", EmitDefaultValue=false)]
        public List<StringObjectKeyValuePair> ExtensionData { get; set; }

        /// <summary>
        /// Gets or Sets AdditionalData
        /// </summary>
        [DataMember(Name="additionalData", EmitDefaultValue=false)]
        public Dictionary<string, Object> AdditionalData { get; set; }

        /// <summary>
        /// Gets or Sets PluginData
        /// </summary>
        [DataMember(Name="pluginData", EmitDefaultValue=false)]
        public Dictionary<string, Object> PluginData { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class CustomerSupplierCODTO {\n");
            sb.Append("  GmdUpdateAdditionalParams: ").Append(GmdUpdateAdditionalParams).Append("\n");
            sb.Append("  Clifor: ").Append(Clifor).Append("\n");
            sb.Append("  CodAbiCg12: ").Append(CodAbiCg12).Append("\n");
            sb.Append("  CodCabCg13: ").Append(CodCabCg13).Append("\n");
            sb.Append("  CodiceCg28: ").Append(CodiceCg28).Append("\n");
            sb.Append("  ContoCg24: ").Append(ContoCg24).Append("\n");
            sb.Append("  ContorCg24: ").Append(ContorCg24).Append("\n");
            sb.Append("  Contratto: ").Append(Contratto).Append("\n");
            sb.Append("  Datavaliva: ").Append(Datavaliva).Append("\n");
            sb.Append("  DittaCg18: ").Append(DittaCg18).Append("\n");
            sb.Append("  FlgArt62: ").Append(FlgArt62).Append("\n");
            sb.Append("  FlgAttivo: ").Append(FlgAttivo).Append("\n");
            sb.Append("  FlgCointestati: ").Append(FlgCointestati).Append("\n");
            sb.Append("  FlgIntercompany: ").Append(FlgIntercompany).Append("\n");
            sb.Append("  Ggscadfix: ").Append(Ggscadfix).Append("\n");
            sb.Append("  GruppoCg10: ").Append(GruppoCg10).Append("\n");
            sb.Append("  Guid: ").Append(Guid).Append("\n");
            sb.Append("  Idclifor: ").Append(Idclifor).Append("\n");
            sb.Append("  IdmediaCg99: ").Append(IdmediaCg99).Append("\n");
            sb.Append("  IndElenchimov3000: ").Append(IndElenchimov3000).Append("\n");
            sb.Append("  IntermedioCg40: ").Append(IntermedioCg40).Append("\n");
            sb.Append("  Lastchange: ").Append(Lastchange).Append("\n");
            sb.Append("  ProgREf08: ").Append(ProgREf08).Append("\n");
            sb.Append("  Tipocf: ").Append(Tipocf).Append("\n");
            sb.Append("  IdExtendedAttributeEntity: ").Append(IdExtendedAttributeEntity).Append("\n");
            sb.Append("  IdExtendedAttributeSubEntity: ").Append(IdExtendedAttributeSubEntity).Append("\n");
            sb.Append("  AgentCO: ").Append(AgentCO).Append("\n");
            sb.Append("  BlackListGeneralMasterData: ").Append(BlackListGeneralMasterData).Append("\n");
            sb.Append("  CsAccountingIndexCO: ").Append(CsAccountingIndexCO).Append("\n");
            sb.Append("  CsBankCO: ").Append(CsBankCO).Append("\n");
            sb.Append("  CsCompanyBankCO: ").Append(CsCompanyBankCO).Append("\n");
            sb.Append("  CsInfoCO: ").Append(CsInfoCO).Append("\n");
            sb.Append("  CsJointlyHeldCO: ").Append(CsJointlyHeldCO).Append("\n");
            sb.Append("  CsPaymentRangeCO: ").Append(CsPaymentRangeCO).Append("\n");
            sb.Append("  CsPostponementPeriodCO: ").Append(CsPostponementPeriodCO).Append("\n");
            sb.Append("  CsSddCO: ").Append(CsSddCO).Append("\n");
            sb.Append("  CurrencyCO: ").Append(CurrencyCO).Append("\n");
            sb.Append("  CustomerSupplierCIGCUPCO: ").Append(CustomerSupplierCIGCUPCO).Append("\n");
            sb.Append("  CustSupplDataInvoicePACO: ").Append(CustSupplDataInvoicePACO).Append("\n");
            sb.Append("  DmsPublishedEntityFW: ").Append(DmsPublishedEntityFW).Append("\n");
            sb.Append("  GeneralMasterDataCO: ").Append(GeneralMasterDataCO).Append("\n");
            sb.Append("  OfficeCO: ").Append(OfficeCO).Append("\n");
            sb.Append("  OfficePACO: ").Append(OfficePACO).Append("\n");
            sb.Append("  PaymentTermCO: ").Append(PaymentTermCO).Append("\n");
            sb.Append("  StatoAttualeCO: ").Append(StatoAttualeCO).Append("\n");
            sb.Append("  VatCodeCO: ").Append(VatCodeCO).Append("\n");
            sb.Append("  ExtensionData: ").Append(ExtensionData).Append("\n");
            sb.Append("  AdditionalData: ").Append(AdditionalData).Append("\n");
            sb.Append("  PluginData: ").Append(PluginData).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as CustomerSupplierCODTO);
        }

        /// <summary>
        /// Returns true if CustomerSupplierCODTO instances are equal
        /// </summary>
        /// <param name="input">Instance of CustomerSupplierCODTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(CustomerSupplierCODTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.GmdUpdateAdditionalParams == input.GmdUpdateAdditionalParams ||
                    (this.GmdUpdateAdditionalParams != null &&
                    this.GmdUpdateAdditionalParams.Equals(input.GmdUpdateAdditionalParams))
                ) && 
                (
                    this.Clifor == input.Clifor ||
                    (this.Clifor != null &&
                    this.Clifor.Equals(input.Clifor))
                ) && 
                (
                    this.CodAbiCg12 == input.CodAbiCg12 ||
                    (this.CodAbiCg12 != null &&
                    this.CodAbiCg12.Equals(input.CodAbiCg12))
                ) && 
                (
                    this.CodCabCg13 == input.CodCabCg13 ||
                    (this.CodCabCg13 != null &&
                    this.CodCabCg13.Equals(input.CodCabCg13))
                ) && 
                (
                    this.CodiceCg28 == input.CodiceCg28 ||
                    (this.CodiceCg28 != null &&
                    this.CodiceCg28.Equals(input.CodiceCg28))
                ) && 
                (
                    this.ContoCg24 == input.ContoCg24 ||
                    (this.ContoCg24 != null &&
                    this.ContoCg24.Equals(input.ContoCg24))
                ) && 
                (
                    this.ContorCg24 == input.ContorCg24 ||
                    (this.ContorCg24 != null &&
                    this.ContorCg24.Equals(input.ContorCg24))
                ) && 
                (
                    this.Contratto == input.Contratto ||
                    (this.Contratto != null &&
                    this.Contratto.Equals(input.Contratto))
                ) && 
                (
                    this.Datavaliva == input.Datavaliva ||
                    (this.Datavaliva != null &&
                    this.Datavaliva.Equals(input.Datavaliva))
                ) && 
                (
                    this.DittaCg18 == input.DittaCg18 ||
                    (this.DittaCg18 != null &&
                    this.DittaCg18.Equals(input.DittaCg18))
                ) && 
                (
                    this.FlgArt62 == input.FlgArt62 ||
                    (this.FlgArt62 != null &&
                    this.FlgArt62.Equals(input.FlgArt62))
                ) && 
                (
                    this.FlgAttivo == input.FlgAttivo ||
                    (this.FlgAttivo != null &&
                    this.FlgAttivo.Equals(input.FlgAttivo))
                ) && 
                (
                    this.FlgCointestati == input.FlgCointestati ||
                    (this.FlgCointestati != null &&
                    this.FlgCointestati.Equals(input.FlgCointestati))
                ) && 
                (
                    this.FlgIntercompany == input.FlgIntercompany ||
                    (this.FlgIntercompany != null &&
                    this.FlgIntercompany.Equals(input.FlgIntercompany))
                ) && 
                (
                    this.Ggscadfix == input.Ggscadfix ||
                    (this.Ggscadfix != null &&
                    this.Ggscadfix.Equals(input.Ggscadfix))
                ) && 
                (
                    this.GruppoCg10 == input.GruppoCg10 ||
                    (this.GruppoCg10 != null &&
                    this.GruppoCg10.Equals(input.GruppoCg10))
                ) && 
                (
                    this.Guid == input.Guid ||
                    (this.Guid != null &&
                    this.Guid.Equals(input.Guid))
                ) && 
                (
                    this.Idclifor == input.Idclifor ||
                    (this.Idclifor != null &&
                    this.Idclifor.Equals(input.Idclifor))
                ) && 
                (
                    this.IdmediaCg99 == input.IdmediaCg99 ||
                    (this.IdmediaCg99 != null &&
                    this.IdmediaCg99.Equals(input.IdmediaCg99))
                ) && 
                (
                    this.IndElenchimov3000 == input.IndElenchimov3000 ||
                    (this.IndElenchimov3000 != null &&
                    this.IndElenchimov3000.Equals(input.IndElenchimov3000))
                ) && 
                (
                    this.IntermedioCg40 == input.IntermedioCg40 ||
                    (this.IntermedioCg40 != null &&
                    this.IntermedioCg40.Equals(input.IntermedioCg40))
                ) && 
                (
                    this.Lastchange == input.Lastchange ||
                    (this.Lastchange != null &&
                    this.Lastchange.Equals(input.Lastchange))
                ) && 
                (
                    this.ProgREf08 == input.ProgREf08 ||
                    (this.ProgREf08 != null &&
                    this.ProgREf08.Equals(input.ProgREf08))
                ) && 
                (
                    this.Tipocf == input.Tipocf ||
                    (this.Tipocf != null &&
                    this.Tipocf.Equals(input.Tipocf))
                ) && 
                (
                    this.IdExtendedAttributeEntity == input.IdExtendedAttributeEntity ||
                    (this.IdExtendedAttributeEntity != null &&
                    this.IdExtendedAttributeEntity.Equals(input.IdExtendedAttributeEntity))
                ) && 
                (
                    this.IdExtendedAttributeSubEntity == input.IdExtendedAttributeSubEntity ||
                    (this.IdExtendedAttributeSubEntity != null &&
                    this.IdExtendedAttributeSubEntity.Equals(input.IdExtendedAttributeSubEntity))
                ) && 
                (
                    this.AgentCO == input.AgentCO ||
                    (this.AgentCO != null &&
                    this.AgentCO.Equals(input.AgentCO))
                ) && 
                (
                    this.BlackListGeneralMasterData == input.BlackListGeneralMasterData ||
                    (this.BlackListGeneralMasterData != null &&
                    this.BlackListGeneralMasterData.Equals(input.BlackListGeneralMasterData))
                ) && 
                (
                    this.CsAccountingIndexCO == input.CsAccountingIndexCO ||
                    (this.CsAccountingIndexCO != null &&
                    this.CsAccountingIndexCO.Equals(input.CsAccountingIndexCO))
                ) && 
                (
                    this.CsBankCO == input.CsBankCO ||
                    this.CsBankCO != null &&
                    input.CsBankCO != null &&
                    this.CsBankCO.SequenceEqual(input.CsBankCO)
                ) && 
                (
                    this.CsCompanyBankCO == input.CsCompanyBankCO ||
                    this.CsCompanyBankCO != null &&
                    input.CsCompanyBankCO != null &&
                    this.CsCompanyBankCO.SequenceEqual(input.CsCompanyBankCO)
                ) && 
                (
                    this.CsInfoCO == input.CsInfoCO ||
                    (this.CsInfoCO != null &&
                    this.CsInfoCO.Equals(input.CsInfoCO))
                ) && 
                (
                    this.CsJointlyHeldCO == input.CsJointlyHeldCO ||
                    this.CsJointlyHeldCO != null &&
                    input.CsJointlyHeldCO != null &&
                    this.CsJointlyHeldCO.SequenceEqual(input.CsJointlyHeldCO)
                ) && 
                (
                    this.CsPaymentRangeCO == input.CsPaymentRangeCO ||
                    this.CsPaymentRangeCO != null &&
                    input.CsPaymentRangeCO != null &&
                    this.CsPaymentRangeCO.SequenceEqual(input.CsPaymentRangeCO)
                ) && 
                (
                    this.CsPostponementPeriodCO == input.CsPostponementPeriodCO ||
                    this.CsPostponementPeriodCO != null &&
                    input.CsPostponementPeriodCO != null &&
                    this.CsPostponementPeriodCO.SequenceEqual(input.CsPostponementPeriodCO)
                ) && 
                (
                    this.CsSddCO == input.CsSddCO ||
                    this.CsSddCO != null &&
                    input.CsSddCO != null &&
                    this.CsSddCO.SequenceEqual(input.CsSddCO)
                ) && 
                (
                    this.CurrencyCO == input.CurrencyCO ||
                    (this.CurrencyCO != null &&
                    this.CurrencyCO.Equals(input.CurrencyCO))
                ) && 
                (
                    this.CustomerSupplierCIGCUPCO == input.CustomerSupplierCIGCUPCO ||
                    this.CustomerSupplierCIGCUPCO != null &&
                    input.CustomerSupplierCIGCUPCO != null &&
                    this.CustomerSupplierCIGCUPCO.SequenceEqual(input.CustomerSupplierCIGCUPCO)
                ) && 
                (
                    this.CustSupplDataInvoicePACO == input.CustSupplDataInvoicePACO ||
                    (this.CustSupplDataInvoicePACO != null &&
                    this.CustSupplDataInvoicePACO.Equals(input.CustSupplDataInvoicePACO))
                ) && 
                (
                    this.DmsPublishedEntityFW == input.DmsPublishedEntityFW ||
                    (this.DmsPublishedEntityFW != null &&
                    this.DmsPublishedEntityFW.Equals(input.DmsPublishedEntityFW))
                ) && 
                (
                    this.GeneralMasterDataCO == input.GeneralMasterDataCO ||
                    (this.GeneralMasterDataCO != null &&
                    this.GeneralMasterDataCO.Equals(input.GeneralMasterDataCO))
                ) && 
                (
                    this.OfficeCO == input.OfficeCO ||
                    (this.OfficeCO != null &&
                    this.OfficeCO.Equals(input.OfficeCO))
                ) && 
                (
                    this.OfficePACO == input.OfficePACO ||
                    this.OfficePACO != null &&
                    input.OfficePACO != null &&
                    this.OfficePACO.SequenceEqual(input.OfficePACO)
                ) && 
                (
                    this.PaymentTermCO == input.PaymentTermCO ||
                    (this.PaymentTermCO != null &&
                    this.PaymentTermCO.Equals(input.PaymentTermCO))
                ) && 
                (
                    this.StatoAttualeCO == input.StatoAttualeCO ||
                    (this.StatoAttualeCO != null &&
                    this.StatoAttualeCO.Equals(input.StatoAttualeCO))
                ) && 
                (
                    this.VatCodeCO == input.VatCodeCO ||
                    (this.VatCodeCO != null &&
                    this.VatCodeCO.Equals(input.VatCodeCO))
                ) && 
                (
                    this.ExtensionData == input.ExtensionData ||
                    this.ExtensionData != null &&
                    input.ExtensionData != null &&
                    this.ExtensionData.SequenceEqual(input.ExtensionData)
                ) && 
                (
                    this.AdditionalData == input.AdditionalData ||
                    this.AdditionalData != null &&
                    input.AdditionalData != null &&
                    this.AdditionalData.SequenceEqual(input.AdditionalData)
                ) && 
                (
                    this.PluginData == input.PluginData ||
                    this.PluginData != null &&
                    input.PluginData != null &&
                    this.PluginData.SequenceEqual(input.PluginData)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.GmdUpdateAdditionalParams != null)
                    hashCode = hashCode * 59 + this.GmdUpdateAdditionalParams.GetHashCode();
                if (this.Clifor != null)
                    hashCode = hashCode * 59 + this.Clifor.GetHashCode();
                if (this.CodAbiCg12 != null)
                    hashCode = hashCode * 59 + this.CodAbiCg12.GetHashCode();
                if (this.CodCabCg13 != null)
                    hashCode = hashCode * 59 + this.CodCabCg13.GetHashCode();
                if (this.CodiceCg28 != null)
                    hashCode = hashCode * 59 + this.CodiceCg28.GetHashCode();
                if (this.ContoCg24 != null)
                    hashCode = hashCode * 59 + this.ContoCg24.GetHashCode();
                if (this.ContorCg24 != null)
                    hashCode = hashCode * 59 + this.ContorCg24.GetHashCode();
                if (this.Contratto != null)
                    hashCode = hashCode * 59 + this.Contratto.GetHashCode();
                if (this.Datavaliva != null)
                    hashCode = hashCode * 59 + this.Datavaliva.GetHashCode();
                if (this.DittaCg18 != null)
                    hashCode = hashCode * 59 + this.DittaCg18.GetHashCode();
                if (this.FlgArt62 != null)
                    hashCode = hashCode * 59 + this.FlgArt62.GetHashCode();
                if (this.FlgAttivo != null)
                    hashCode = hashCode * 59 + this.FlgAttivo.GetHashCode();
                if (this.FlgCointestati != null)
                    hashCode = hashCode * 59 + this.FlgCointestati.GetHashCode();
                if (this.FlgIntercompany != null)
                    hashCode = hashCode * 59 + this.FlgIntercompany.GetHashCode();
                if (this.Ggscadfix != null)
                    hashCode = hashCode * 59 + this.Ggscadfix.GetHashCode();
                if (this.GruppoCg10 != null)
                    hashCode = hashCode * 59 + this.GruppoCg10.GetHashCode();
                if (this.Guid != null)
                    hashCode = hashCode * 59 + this.Guid.GetHashCode();
                if (this.Idclifor != null)
                    hashCode = hashCode * 59 + this.Idclifor.GetHashCode();
                if (this.IdmediaCg99 != null)
                    hashCode = hashCode * 59 + this.IdmediaCg99.GetHashCode();
                if (this.IndElenchimov3000 != null)
                    hashCode = hashCode * 59 + this.IndElenchimov3000.GetHashCode();
                if (this.IntermedioCg40 != null)
                    hashCode = hashCode * 59 + this.IntermedioCg40.GetHashCode();
                if (this.Lastchange != null)
                    hashCode = hashCode * 59 + this.Lastchange.GetHashCode();
                if (this.ProgREf08 != null)
                    hashCode = hashCode * 59 + this.ProgREf08.GetHashCode();
                if (this.Tipocf != null)
                    hashCode = hashCode * 59 + this.Tipocf.GetHashCode();
                if (this.IdExtendedAttributeEntity != null)
                    hashCode = hashCode * 59 + this.IdExtendedAttributeEntity.GetHashCode();
                if (this.IdExtendedAttributeSubEntity != null)
                    hashCode = hashCode * 59 + this.IdExtendedAttributeSubEntity.GetHashCode();
                if (this.AgentCO != null)
                    hashCode = hashCode * 59 + this.AgentCO.GetHashCode();
                if (this.BlackListGeneralMasterData != null)
                    hashCode = hashCode * 59 + this.BlackListGeneralMasterData.GetHashCode();
                if (this.CsAccountingIndexCO != null)
                    hashCode = hashCode * 59 + this.CsAccountingIndexCO.GetHashCode();
                if (this.CsBankCO != null)
                    hashCode = hashCode * 59 + this.CsBankCO.GetHashCode();
                if (this.CsCompanyBankCO != null)
                    hashCode = hashCode * 59 + this.CsCompanyBankCO.GetHashCode();
                if (this.CsInfoCO != null)
                    hashCode = hashCode * 59 + this.CsInfoCO.GetHashCode();
                if (this.CsJointlyHeldCO != null)
                    hashCode = hashCode * 59 + this.CsJointlyHeldCO.GetHashCode();
                if (this.CsPaymentRangeCO != null)
                    hashCode = hashCode * 59 + this.CsPaymentRangeCO.GetHashCode();
                if (this.CsPostponementPeriodCO != null)
                    hashCode = hashCode * 59 + this.CsPostponementPeriodCO.GetHashCode();
                if (this.CsSddCO != null)
                    hashCode = hashCode * 59 + this.CsSddCO.GetHashCode();
                if (this.CurrencyCO != null)
                    hashCode = hashCode * 59 + this.CurrencyCO.GetHashCode();
                if (this.CustomerSupplierCIGCUPCO != null)
                    hashCode = hashCode * 59 + this.CustomerSupplierCIGCUPCO.GetHashCode();
                if (this.CustSupplDataInvoicePACO != null)
                    hashCode = hashCode * 59 + this.CustSupplDataInvoicePACO.GetHashCode();
                if (this.DmsPublishedEntityFW != null)
                    hashCode = hashCode * 59 + this.DmsPublishedEntityFW.GetHashCode();
                if (this.GeneralMasterDataCO != null)
                    hashCode = hashCode * 59 + this.GeneralMasterDataCO.GetHashCode();
                if (this.OfficeCO != null)
                    hashCode = hashCode * 59 + this.OfficeCO.GetHashCode();
                if (this.OfficePACO != null)
                    hashCode = hashCode * 59 + this.OfficePACO.GetHashCode();
                if (this.PaymentTermCO != null)
                    hashCode = hashCode * 59 + this.PaymentTermCO.GetHashCode();
                if (this.StatoAttualeCO != null)
                    hashCode = hashCode * 59 + this.StatoAttualeCO.GetHashCode();
                if (this.VatCodeCO != null)
                    hashCode = hashCode * 59 + this.VatCodeCO.GetHashCode();
                if (this.ExtensionData != null)
                    hashCode = hashCode * 59 + this.ExtensionData.GetHashCode();
                if (this.AdditionalData != null)
                    hashCode = hashCode * 59 + this.AdditionalData.GetHashCode();
                if (this.PluginData != null)
                    hashCode = hashCode * 59 + this.PluginData.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
