/* 
 * TSE Cloud - CO
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.3000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// MG17_AGENTI - Agente&lt;br&gt;Proprietà chiave:&lt;ul&gt;&lt;li&gt;&lt;b&gt;Idagente&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;
    /// </summary>
    [DataContract]
        public partial class AgentCODTO :  IEquatable<AgentCODTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="AgentCODTO" /> class.
        /// </summary>
        /// <param name="agente">MG17_AGENTE - Agente (required).</param>
        /// <param name="anagenCg16">MG17_ANAGEN_CG16 - Codice anagrafica generale (required).</param>
        /// <param name="datafineman">MG17_DATAFINEMAN - Data fine mandato.</param>
        /// <param name="datainman">MG17_DATAINMAN - Data inizio mandato.</param>
        /// <param name="datainrapp">MG17_DATAINRAPP - Data inizio rapporto.</param>
        /// <param name="dittaCg18">MG17_DITTA_CG18 - Ditta (required).</param>
        /// <param name="flgAdegdelta">MG17_FLGADEGDELTA - Adeguamento provvigioni in funzione del delta della riga documento&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="flgAdeguamscmag">MG17_FLGADEGUAMSCMAG - Adeguamento provvigioni per sconti/maggiorazioni&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="flgRegimeart">MG17_FLGREGIMEART - Reg. provv. dell&#x27;articolo&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="flgRegimecl">MG17_FLGREGIMECL - Reg. provv. del cliente&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="guid">MG17_GUID - GUID.</param>
        /// <param name="idagente">MG17_IDAGENTE - ID (Required only in PUT/PATCH).</param>
        /// <param name="idcapoareaMg17">MG17_IDCAPOAREA_MG17 - Capo area dell&#x27;agente.</param>
        /// <param name="idcapozonaMg17">MG17_IDCAPOZONA_MG17 - Capo zona dell&#x27;agente.</param>
        /// <param name="idmediaCg99">MG17_IDMEDIA_CG99 - ID HyperMedia.</param>
        /// <param name="indBaseimpmag">MG17_INDBASEIMPMAG - Base impon. provv. mag.&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Imponibile provvigione&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Imponib. provv. - Importo provv. gia&#x27; calcolato&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Diff. pr. determinato per il calcolo dello sconto&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Impor. provv. calcolato prima dell&#x27;adeguamento&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="indBaseimpsc">MG17_INDBASEIMPSC - Base impon. provv. sc.&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Imponibile provvigione&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Imponib. provv. - Importo provv. gia&#x27; calcolato&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Diff. pr. determinato per il calcolo dello sconto&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Impor. provv. calcolato prima dell&#x27;adeguamento&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="indCalcscmag">MG17_INDCALCSCMAG - Calcolo sconto/magg.&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Pr. ven./acq. calcolato da priorita&#x27; prezzi-Pr. doc.&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Pr. di list. anag. art. indicato sul cli./for-Pr. doc.&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Sconti o magg. effettivi indicati sul documento&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="indPrefstdoc">MG17_INDPREFSTDOC - Stampa pref. documento&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Stampa&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Fax&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Mail&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - PEC&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Pdf&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Nessuna preferenza&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="indStdistenas">MG17_INDSTDISTENAS - Flag stampata distinta enasarco&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Si stampa distinta&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - No stampa distinta&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="indTipoage">MG17_INDTIPOAGE - Tipo agente&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Agente&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Capo zona&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Capo area&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="indTipoliq">MG17_INDTIPOLIQ - Tipo liquidazione&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuna scelta&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Per importo&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Per scaduto&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Per pagato&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="perprov">MG17_PERPROV - % Provvigioni (default to 0).</param>
        /// <param name="regimeprov">MG17_REGIMEPROV - Regime&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No calcolo provvigioni&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - % dall&#x27;agente&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - % dal cliente&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - % dall&#x27;anagrafica articolo&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - % dall&#x27;anagrafica articolo/agente&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - % da listino fisso&lt;/li&gt;&lt;li&gt;&lt;i&gt;6&lt;/i&gt; - % da listino anag. su cli./for.&lt;/li&gt;&lt;li&gt;&lt;i&gt;7&lt;/i&gt; - % da listino fisso e scagl. sc./magg.&lt;/li&gt;&lt;li&gt;&lt;i&gt;8&lt;/i&gt; - % da listino utilizzato&lt;/li&gt;&lt;li&gt;&lt;i&gt;9&lt;/i&gt; - % da listino utilizzato: solo gest. scagl. di sc./magg.&lt;/li&gt;&lt;li&gt;&lt;i&gt;10&lt;/i&gt; - % da listino utilizzato: provv. list. + scagl. di sc./magg.&lt;/li&gt;&lt;li&gt;&lt;i&gt;11&lt;/i&gt; - % da tabella composta a due livelli&lt;/li&gt;&lt;li&gt;&lt;i&gt;12&lt;/i&gt; - % da tabella composta a tre livelli&lt;/li&gt;&lt;li&gt;&lt;i&gt;13&lt;/i&gt; - % da scaglioni di fatturato&lt;/li&gt;&lt;li&gt;&lt;i&gt;14&lt;/i&gt; - % da condizioni multiple&lt;/li&gt;&lt;li&gt;&lt;i&gt;15&lt;/i&gt; - % da listini parametrici&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="tipomand">MG17_TIPOMAND - Tipo mandato&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Monomandatario&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Plurimandatario&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="tiporappor">MG17_TIPORAPPOR - Tipo rapporto&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Procacciatore&lt;/li&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Generale&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Ispettore&lt;/li&gt;&lt;/ul&gt; (default to 1).</param>
        /// <param name="tiposoc">MG17_TIPOSOC - Tipo di società&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; -  Persona fisica&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Società di capitale&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Società di persona&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="idExtendedAttributeEntity">idExtendedAttributeEntity.</param>
        /// <param name="idExtendedAttributeSubEntity">idExtendedAttributeSubEntity.</param>
        /// <param name="dmsPublishedEntityFW">dmsPublishedEntityFW.</param>
        /// <param name="generalMasterDataCO">generalMasterDataCO (required).</param>
        /// <param name="extensionData">extensionData.</param>
        /// <param name="additionalData">additionalData.</param>
        /// <param name="pluginData">pluginData.</param>
        public AgentCODTO(string agente = default(string), int? anagenCg16 = default(int?), DateTime? datafineman = default(DateTime?), DateTime? datainman = default(DateTime?), DateTime? datainrapp = default(DateTime?), double? dittaCg18 = default(double?), double? flgAdegdelta = default(double?), double? flgAdeguamscmag = default(double?), double? flgRegimeart = 0, double? flgRegimecl = 0, Guid? guid = default(Guid?), int? idagente = default(int?), int? idcapoareaMg17 = default(int?), int? idcapozonaMg17 = default(int?), double? idmediaCg99 = default(double?), double? indBaseimpmag = default(double?), double? indBaseimpsc = default(double?), double? indCalcscmag = default(double?), double? indPrefstdoc = 0, double? indStdistenas = default(double?), double? indTipoage = 0, double? indTipoliq = 0, double? perprov = 0, double? regimeprov = 0, double? tipomand = 0, double? tiporappor = 1, double? tiposoc = default(double?), int? idExtendedAttributeEntity = default(int?), int? idExtendedAttributeSubEntity = default(int?), DMSPublishedEntityFWDTO dmsPublishedEntityFW = default(DMSPublishedEntityFWDTO), GeneralMasterDataCODTO generalMasterDataCO = default(GeneralMasterDataCODTO), List<StringObjectKeyValuePair> extensionData = default(List<StringObjectKeyValuePair>), Dictionary<string, Object> additionalData = default(Dictionary<string, Object>), Dictionary<string, Object> pluginData = default(Dictionary<string, Object>))
        {
            // to ensure "agente" is required (not null)
            if (agente == null)
            {
                throw new InvalidDataException("agente is a required property for AgentCODTO and cannot be null");
            }
            else
            {
                this.Agente = agente;
            }
            // to ensure "anagenCg16" is required (not null)
            if (anagenCg16 == null)
            {
                throw new InvalidDataException("anagenCg16 is a required property for AgentCODTO and cannot be null");
            }
            else
            {
                this.AnagenCg16 = anagenCg16;
            }
            // to ensure "dittaCg18" is required (not null)
            if (dittaCg18 == null)
            {
                throw new InvalidDataException("dittaCg18 is a required property for AgentCODTO and cannot be null");
            }
            else
            {
                this.DittaCg18 = dittaCg18;
            }
            // to ensure "generalMasterDataCO" is required (not null)
            if (generalMasterDataCO == null)
            {
                throw new InvalidDataException("generalMasterDataCO is a required property for AgentCODTO and cannot be null");
            }
            else
            {
                this.GeneralMasterDataCO = generalMasterDataCO;
            }
            this.Datafineman = datafineman;
            this.Datainman = datainman;
            this.Datainrapp = datainrapp;
            this.FlgAdegdelta = flgAdegdelta;
            this.FlgAdeguamscmag = flgAdeguamscmag;
            // use default value if no "flgRegimeart" provided
            if (flgRegimeart == null)
            {
                this.FlgRegimeart = 0;
            }
            else
            {
                this.FlgRegimeart = flgRegimeart;
            }
            // use default value if no "flgRegimecl" provided
            if (flgRegimecl == null)
            {
                this.FlgRegimecl = 0;
            }
            else
            {
                this.FlgRegimecl = flgRegimecl;
            }
            this.Guid = guid;
            this.Idagente = idagente;
            this.IdcapoareaMg17 = idcapoareaMg17;
            this.IdcapozonaMg17 = idcapozonaMg17;
            this.IdmediaCg99 = idmediaCg99;
            this.IndBaseimpmag = indBaseimpmag;
            this.IndBaseimpsc = indBaseimpsc;
            this.IndCalcscmag = indCalcscmag;
            // use default value if no "indPrefstdoc" provided
            if (indPrefstdoc == null)
            {
                this.IndPrefstdoc = 0;
            }
            else
            {
                this.IndPrefstdoc = indPrefstdoc;
            }
            this.IndStdistenas = indStdistenas;
            // use default value if no "indTipoage" provided
            if (indTipoage == null)
            {
                this.IndTipoage = 0;
            }
            else
            {
                this.IndTipoage = indTipoage;
            }
            // use default value if no "indTipoliq" provided
            if (indTipoliq == null)
            {
                this.IndTipoliq = 0;
            }
            else
            {
                this.IndTipoliq = indTipoliq;
            }
            // use default value if no "perprov" provided
            if (perprov == null)
            {
                this.Perprov = 0;
            }
            else
            {
                this.Perprov = perprov;
            }
            // use default value if no "regimeprov" provided
            if (regimeprov == null)
            {
                this.Regimeprov = 0;
            }
            else
            {
                this.Regimeprov = regimeprov;
            }
            // use default value if no "tipomand" provided
            if (tipomand == null)
            {
                this.Tipomand = 0;
            }
            else
            {
                this.Tipomand = tipomand;
            }
            // use default value if no "tiporappor" provided
            if (tiporappor == null)
            {
                this.Tiporappor = 1;
            }
            else
            {
                this.Tiporappor = tiporappor;
            }
            this.Tiposoc = tiposoc;
            this.IdExtendedAttributeEntity = idExtendedAttributeEntity;
            this.IdExtendedAttributeSubEntity = idExtendedAttributeSubEntity;
            this.DmsPublishedEntityFW = dmsPublishedEntityFW;
            this.ExtensionData = extensionData;
            this.AdditionalData = additionalData;
            this.PluginData = pluginData;
        }
        
        /// <summary>
        /// MG17_AGENTE - Agente
        /// </summary>
        /// <value>MG17_AGENTE - Agente</value>
        [DataMember(Name="agente", EmitDefaultValue=false)]
        public string Agente { get; set; }

        /// <summary>
        /// MG17_ANAGEN_CG16 - Codice anagrafica generale
        /// </summary>
        /// <value>MG17_ANAGEN_CG16 - Codice anagrafica generale</value>
        [DataMember(Name="anagenCg16", EmitDefaultValue=false)]
        public int? AnagenCg16 { get; set; }

        /// <summary>
        /// MG17_DATAFINEMAN - Data fine mandato
        /// </summary>
        /// <value>MG17_DATAFINEMAN - Data fine mandato</value>
        [DataMember(Name="datafineman", EmitDefaultValue=false)]
        public DateTime? Datafineman { get; set; }

        /// <summary>
        /// MG17_DATAINMAN - Data inizio mandato
        /// </summary>
        /// <value>MG17_DATAINMAN - Data inizio mandato</value>
        [DataMember(Name="datainman", EmitDefaultValue=false)]
        public DateTime? Datainman { get; set; }

        /// <summary>
        /// MG17_DATAINRAPP - Data inizio rapporto
        /// </summary>
        /// <value>MG17_DATAINRAPP - Data inizio rapporto</value>
        [DataMember(Name="datainrapp", EmitDefaultValue=false)]
        public DateTime? Datainrapp { get; set; }

        /// <summary>
        /// MG17_DITTA_CG18 - Ditta
        /// </summary>
        /// <value>MG17_DITTA_CG18 - Ditta</value>
        [DataMember(Name="dittaCg18", EmitDefaultValue=false)]
        public double? DittaCg18 { get; set; }

        /// <summary>
        /// MG17_FLGADEGDELTA - Adeguamento provvigioni in funzione del delta della riga documento&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG17_FLGADEGDELTA - Adeguamento provvigioni in funzione del delta della riga documento&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgAdegdelta", EmitDefaultValue=false)]
        public double? FlgAdegdelta { get; set; }

        /// <summary>
        /// MG17_FLGADEGUAMSCMAG - Adeguamento provvigioni per sconti/maggiorazioni&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG17_FLGADEGUAMSCMAG - Adeguamento provvigioni per sconti/maggiorazioni&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgAdeguamscmag", EmitDefaultValue=false)]
        public double? FlgAdeguamscmag { get; set; }

        /// <summary>
        /// MG17_FLGREGIMEART - Reg. provv. dell&#x27;articolo&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG17_FLGREGIMEART - Reg. provv. dell&#x27;articolo&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgRegimeart", EmitDefaultValue=false)]
        public double? FlgRegimeart { get; set; }

        /// <summary>
        /// MG17_FLGREGIMECL - Reg. provv. del cliente&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG17_FLGREGIMECL - Reg. provv. del cliente&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgRegimecl", EmitDefaultValue=false)]
        public double? FlgRegimecl { get; set; }

        /// <summary>
        /// MG17_GUID - GUID
        /// </summary>
        /// <value>MG17_GUID - GUID</value>
        [DataMember(Name="guid", EmitDefaultValue=false)]
        public Guid? Guid { get; set; }

        /// <summary>
        /// MG17_IDAGENTE - ID (Required only in PUT/PATCH)
        /// </summary>
        /// <value>MG17_IDAGENTE - ID (Required only in PUT/PATCH)</value>
        [DataMember(Name="idagente", EmitDefaultValue=false)]
        public int? Idagente { get; set; }

        /// <summary>
        /// MG17_IDCAPOAREA_MG17 - Capo area dell&#x27;agente
        /// </summary>
        /// <value>MG17_IDCAPOAREA_MG17 - Capo area dell&#x27;agente</value>
        [DataMember(Name="idcapoareaMg17", EmitDefaultValue=false)]
        public int? IdcapoareaMg17 { get; set; }

        /// <summary>
        /// MG17_IDCAPOZONA_MG17 - Capo zona dell&#x27;agente
        /// </summary>
        /// <value>MG17_IDCAPOZONA_MG17 - Capo zona dell&#x27;agente</value>
        [DataMember(Name="idcapozonaMg17", EmitDefaultValue=false)]
        public int? IdcapozonaMg17 { get; set; }

        /// <summary>
        /// MG17_IDMEDIA_CG99 - ID HyperMedia
        /// </summary>
        /// <value>MG17_IDMEDIA_CG99 - ID HyperMedia</value>
        [DataMember(Name="idmediaCg99", EmitDefaultValue=false)]
        public double? IdmediaCg99 { get; set; }

        /// <summary>
        /// MG17_INDBASEIMPMAG - Base impon. provv. mag.&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Imponibile provvigione&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Imponib. provv. - Importo provv. gia&#x27; calcolato&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Diff. pr. determinato per il calcolo dello sconto&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Impor. provv. calcolato prima dell&#x27;adeguamento&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG17_INDBASEIMPMAG - Base impon. provv. mag.&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Imponibile provvigione&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Imponib. provv. - Importo provv. gia&#x27; calcolato&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Diff. pr. determinato per il calcolo dello sconto&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Impor. provv. calcolato prima dell&#x27;adeguamento&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indBaseimpmag", EmitDefaultValue=false)]
        public double? IndBaseimpmag { get; set; }

        /// <summary>
        /// MG17_INDBASEIMPSC - Base impon. provv. sc.&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Imponibile provvigione&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Imponib. provv. - Importo provv. gia&#x27; calcolato&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Diff. pr. determinato per il calcolo dello sconto&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Impor. provv. calcolato prima dell&#x27;adeguamento&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG17_INDBASEIMPSC - Base impon. provv. sc.&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Imponibile provvigione&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Imponib. provv. - Importo provv. gia&#x27; calcolato&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Diff. pr. determinato per il calcolo dello sconto&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Impor. provv. calcolato prima dell&#x27;adeguamento&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indBaseimpsc", EmitDefaultValue=false)]
        public double? IndBaseimpsc { get; set; }

        /// <summary>
        /// MG17_INDCALCSCMAG - Calcolo sconto/magg.&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Pr. ven./acq. calcolato da priorita&#x27; prezzi-Pr. doc.&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Pr. di list. anag. art. indicato sul cli./for-Pr. doc.&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Sconti o magg. effettivi indicati sul documento&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG17_INDCALCSCMAG - Calcolo sconto/magg.&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Pr. ven./acq. calcolato da priorita&#x27; prezzi-Pr. doc.&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Pr. di list. anag. art. indicato sul cli./for-Pr. doc.&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Sconti o magg. effettivi indicati sul documento&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indCalcscmag", EmitDefaultValue=false)]
        public double? IndCalcscmag { get; set; }

        /// <summary>
        /// MG17_INDPREFSTDOC - Stampa pref. documento&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Stampa&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Fax&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Mail&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - PEC&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Pdf&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Nessuna preferenza&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG17_INDPREFSTDOC - Stampa pref. documento&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Stampa&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Fax&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Mail&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - PEC&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Pdf&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Nessuna preferenza&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indPrefstdoc", EmitDefaultValue=false)]
        public double? IndPrefstdoc { get; set; }

        /// <summary>
        /// MG17_INDSTDISTENAS - Flag stampata distinta enasarco&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Si stampa distinta&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - No stampa distinta&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG17_INDSTDISTENAS - Flag stampata distinta enasarco&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Si stampa distinta&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - No stampa distinta&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indStdistenas", EmitDefaultValue=false)]
        public double? IndStdistenas { get; set; }

        /// <summary>
        /// MG17_INDTIPOAGE - Tipo agente&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Agente&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Capo zona&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Capo area&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG17_INDTIPOAGE - Tipo agente&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Agente&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Capo zona&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Capo area&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indTipoage", EmitDefaultValue=false)]
        public double? IndTipoage { get; set; }

        /// <summary>
        /// MG17_INDTIPOLIQ - Tipo liquidazione&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuna scelta&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Per importo&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Per scaduto&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Per pagato&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG17_INDTIPOLIQ - Tipo liquidazione&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuna scelta&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Per importo&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Per scaduto&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Per pagato&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indTipoliq", EmitDefaultValue=false)]
        public double? IndTipoliq { get; set; }

        /// <summary>
        /// MG17_PERPROV - % Provvigioni
        /// </summary>
        /// <value>MG17_PERPROV - % Provvigioni</value>
        [DataMember(Name="perprov", EmitDefaultValue=false)]
        public double? Perprov { get; set; }

        /// <summary>
        /// MG17_REGIMEPROV - Regime&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No calcolo provvigioni&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - % dall&#x27;agente&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - % dal cliente&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - % dall&#x27;anagrafica articolo&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - % dall&#x27;anagrafica articolo/agente&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - % da listino fisso&lt;/li&gt;&lt;li&gt;&lt;i&gt;6&lt;/i&gt; - % da listino anag. su cli./for.&lt;/li&gt;&lt;li&gt;&lt;i&gt;7&lt;/i&gt; - % da listino fisso e scagl. sc./magg.&lt;/li&gt;&lt;li&gt;&lt;i&gt;8&lt;/i&gt; - % da listino utilizzato&lt;/li&gt;&lt;li&gt;&lt;i&gt;9&lt;/i&gt; - % da listino utilizzato: solo gest. scagl. di sc./magg.&lt;/li&gt;&lt;li&gt;&lt;i&gt;10&lt;/i&gt; - % da listino utilizzato: provv. list. + scagl. di sc./magg.&lt;/li&gt;&lt;li&gt;&lt;i&gt;11&lt;/i&gt; - % da tabella composta a due livelli&lt;/li&gt;&lt;li&gt;&lt;i&gt;12&lt;/i&gt; - % da tabella composta a tre livelli&lt;/li&gt;&lt;li&gt;&lt;i&gt;13&lt;/i&gt; - % da scaglioni di fatturato&lt;/li&gt;&lt;li&gt;&lt;i&gt;14&lt;/i&gt; - % da condizioni multiple&lt;/li&gt;&lt;li&gt;&lt;i&gt;15&lt;/i&gt; - % da listini parametrici&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG17_REGIMEPROV - Regime&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No calcolo provvigioni&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - % dall&#x27;agente&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - % dal cliente&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - % dall&#x27;anagrafica articolo&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - % dall&#x27;anagrafica articolo/agente&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - % da listino fisso&lt;/li&gt;&lt;li&gt;&lt;i&gt;6&lt;/i&gt; - % da listino anag. su cli./for.&lt;/li&gt;&lt;li&gt;&lt;i&gt;7&lt;/i&gt; - % da listino fisso e scagl. sc./magg.&lt;/li&gt;&lt;li&gt;&lt;i&gt;8&lt;/i&gt; - % da listino utilizzato&lt;/li&gt;&lt;li&gt;&lt;i&gt;9&lt;/i&gt; - % da listino utilizzato: solo gest. scagl. di sc./magg.&lt;/li&gt;&lt;li&gt;&lt;i&gt;10&lt;/i&gt; - % da listino utilizzato: provv. list. + scagl. di sc./magg.&lt;/li&gt;&lt;li&gt;&lt;i&gt;11&lt;/i&gt; - % da tabella composta a due livelli&lt;/li&gt;&lt;li&gt;&lt;i&gt;12&lt;/i&gt; - % da tabella composta a tre livelli&lt;/li&gt;&lt;li&gt;&lt;i&gt;13&lt;/i&gt; - % da scaglioni di fatturato&lt;/li&gt;&lt;li&gt;&lt;i&gt;14&lt;/i&gt; - % da condizioni multiple&lt;/li&gt;&lt;li&gt;&lt;i&gt;15&lt;/i&gt; - % da listini parametrici&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="regimeprov", EmitDefaultValue=false)]
        public double? Regimeprov { get; set; }

        /// <summary>
        /// MG17_TIPOMAND - Tipo mandato&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Monomandatario&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Plurimandatario&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG17_TIPOMAND - Tipo mandato&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Monomandatario&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Plurimandatario&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="tipomand", EmitDefaultValue=false)]
        public double? Tipomand { get; set; }

        /// <summary>
        /// MG17_TIPORAPPOR - Tipo rapporto&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Procacciatore&lt;/li&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Generale&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Ispettore&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG17_TIPORAPPOR - Tipo rapporto&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Procacciatore&lt;/li&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Generale&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Ispettore&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="tiporappor", EmitDefaultValue=false)]
        public double? Tiporappor { get; set; }

        /// <summary>
        /// MG17_TIPOSOC - Tipo di società&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; -  Persona fisica&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Società di capitale&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Società di persona&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG17_TIPOSOC - Tipo di società&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; -  Persona fisica&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Società di capitale&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Società di persona&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="tiposoc", EmitDefaultValue=false)]
        public double? Tiposoc { get; set; }

        /// <summary>
        /// Gets or Sets IdExtendedAttributeEntity
        /// </summary>
        [DataMember(Name="idExtendedAttributeEntity", EmitDefaultValue=false)]
        public int? IdExtendedAttributeEntity { get; set; }

        /// <summary>
        /// Gets or Sets IdExtendedAttributeSubEntity
        /// </summary>
        [DataMember(Name="idExtendedAttributeSubEntity", EmitDefaultValue=false)]
        public int? IdExtendedAttributeSubEntity { get; set; }

        /// <summary>
        /// Gets or Sets DmsPublishedEntityFW
        /// </summary>
        [DataMember(Name="dmsPublishedEntityFW", EmitDefaultValue=false)]
        public DMSPublishedEntityFWDTO DmsPublishedEntityFW { get; set; }

        /// <summary>
        /// Gets or Sets GeneralMasterDataCO
        /// </summary>
        [DataMember(Name="generalMasterDataCO", EmitDefaultValue=false)]
        public GeneralMasterDataCODTO GeneralMasterDataCO { get; set; }

        /// <summary>
        /// Gets or Sets ExtensionData
        /// </summary>
        [DataMember(Name="extensionData", EmitDefaultValue=false)]
        public List<StringObjectKeyValuePair> ExtensionData { get; set; }

        /// <summary>
        /// Gets or Sets AdditionalData
        /// </summary>
        [DataMember(Name="additionalData", EmitDefaultValue=false)]
        public Dictionary<string, Object> AdditionalData { get; set; }

        /// <summary>
        /// Gets or Sets PluginData
        /// </summary>
        [DataMember(Name="pluginData", EmitDefaultValue=false)]
        public Dictionary<string, Object> PluginData { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class AgentCODTO {\n");
            sb.Append("  Agente: ").Append(Agente).Append("\n");
            sb.Append("  AnagenCg16: ").Append(AnagenCg16).Append("\n");
            sb.Append("  Datafineman: ").Append(Datafineman).Append("\n");
            sb.Append("  Datainman: ").Append(Datainman).Append("\n");
            sb.Append("  Datainrapp: ").Append(Datainrapp).Append("\n");
            sb.Append("  DittaCg18: ").Append(DittaCg18).Append("\n");
            sb.Append("  FlgAdegdelta: ").Append(FlgAdegdelta).Append("\n");
            sb.Append("  FlgAdeguamscmag: ").Append(FlgAdeguamscmag).Append("\n");
            sb.Append("  FlgRegimeart: ").Append(FlgRegimeart).Append("\n");
            sb.Append("  FlgRegimecl: ").Append(FlgRegimecl).Append("\n");
            sb.Append("  Guid: ").Append(Guid).Append("\n");
            sb.Append("  Idagente: ").Append(Idagente).Append("\n");
            sb.Append("  IdcapoareaMg17: ").Append(IdcapoareaMg17).Append("\n");
            sb.Append("  IdcapozonaMg17: ").Append(IdcapozonaMg17).Append("\n");
            sb.Append("  IdmediaCg99: ").Append(IdmediaCg99).Append("\n");
            sb.Append("  IndBaseimpmag: ").Append(IndBaseimpmag).Append("\n");
            sb.Append("  IndBaseimpsc: ").Append(IndBaseimpsc).Append("\n");
            sb.Append("  IndCalcscmag: ").Append(IndCalcscmag).Append("\n");
            sb.Append("  IndPrefstdoc: ").Append(IndPrefstdoc).Append("\n");
            sb.Append("  IndStdistenas: ").Append(IndStdistenas).Append("\n");
            sb.Append("  IndTipoage: ").Append(IndTipoage).Append("\n");
            sb.Append("  IndTipoliq: ").Append(IndTipoliq).Append("\n");
            sb.Append("  Perprov: ").Append(Perprov).Append("\n");
            sb.Append("  Regimeprov: ").Append(Regimeprov).Append("\n");
            sb.Append("  Tipomand: ").Append(Tipomand).Append("\n");
            sb.Append("  Tiporappor: ").Append(Tiporappor).Append("\n");
            sb.Append("  Tiposoc: ").Append(Tiposoc).Append("\n");
            sb.Append("  IdExtendedAttributeEntity: ").Append(IdExtendedAttributeEntity).Append("\n");
            sb.Append("  IdExtendedAttributeSubEntity: ").Append(IdExtendedAttributeSubEntity).Append("\n");
            sb.Append("  DmsPublishedEntityFW: ").Append(DmsPublishedEntityFW).Append("\n");
            sb.Append("  GeneralMasterDataCO: ").Append(GeneralMasterDataCO).Append("\n");
            sb.Append("  ExtensionData: ").Append(ExtensionData).Append("\n");
            sb.Append("  AdditionalData: ").Append(AdditionalData).Append("\n");
            sb.Append("  PluginData: ").Append(PluginData).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as AgentCODTO);
        }

        /// <summary>
        /// Returns true if AgentCODTO instances are equal
        /// </summary>
        /// <param name="input">Instance of AgentCODTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(AgentCODTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.Agente == input.Agente ||
                    (this.Agente != null &&
                    this.Agente.Equals(input.Agente))
                ) && 
                (
                    this.AnagenCg16 == input.AnagenCg16 ||
                    (this.AnagenCg16 != null &&
                    this.AnagenCg16.Equals(input.AnagenCg16))
                ) && 
                (
                    this.Datafineman == input.Datafineman ||
                    (this.Datafineman != null &&
                    this.Datafineman.Equals(input.Datafineman))
                ) && 
                (
                    this.Datainman == input.Datainman ||
                    (this.Datainman != null &&
                    this.Datainman.Equals(input.Datainman))
                ) && 
                (
                    this.Datainrapp == input.Datainrapp ||
                    (this.Datainrapp != null &&
                    this.Datainrapp.Equals(input.Datainrapp))
                ) && 
                (
                    this.DittaCg18 == input.DittaCg18 ||
                    (this.DittaCg18 != null &&
                    this.DittaCg18.Equals(input.DittaCg18))
                ) && 
                (
                    this.FlgAdegdelta == input.FlgAdegdelta ||
                    (this.FlgAdegdelta != null &&
                    this.FlgAdegdelta.Equals(input.FlgAdegdelta))
                ) && 
                (
                    this.FlgAdeguamscmag == input.FlgAdeguamscmag ||
                    (this.FlgAdeguamscmag != null &&
                    this.FlgAdeguamscmag.Equals(input.FlgAdeguamscmag))
                ) && 
                (
                    this.FlgRegimeart == input.FlgRegimeart ||
                    (this.FlgRegimeart != null &&
                    this.FlgRegimeart.Equals(input.FlgRegimeart))
                ) && 
                (
                    this.FlgRegimecl == input.FlgRegimecl ||
                    (this.FlgRegimecl != null &&
                    this.FlgRegimecl.Equals(input.FlgRegimecl))
                ) && 
                (
                    this.Guid == input.Guid ||
                    (this.Guid != null &&
                    this.Guid.Equals(input.Guid))
                ) && 
                (
                    this.Idagente == input.Idagente ||
                    (this.Idagente != null &&
                    this.Idagente.Equals(input.Idagente))
                ) && 
                (
                    this.IdcapoareaMg17 == input.IdcapoareaMg17 ||
                    (this.IdcapoareaMg17 != null &&
                    this.IdcapoareaMg17.Equals(input.IdcapoareaMg17))
                ) && 
                (
                    this.IdcapozonaMg17 == input.IdcapozonaMg17 ||
                    (this.IdcapozonaMg17 != null &&
                    this.IdcapozonaMg17.Equals(input.IdcapozonaMg17))
                ) && 
                (
                    this.IdmediaCg99 == input.IdmediaCg99 ||
                    (this.IdmediaCg99 != null &&
                    this.IdmediaCg99.Equals(input.IdmediaCg99))
                ) && 
                (
                    this.IndBaseimpmag == input.IndBaseimpmag ||
                    (this.IndBaseimpmag != null &&
                    this.IndBaseimpmag.Equals(input.IndBaseimpmag))
                ) && 
                (
                    this.IndBaseimpsc == input.IndBaseimpsc ||
                    (this.IndBaseimpsc != null &&
                    this.IndBaseimpsc.Equals(input.IndBaseimpsc))
                ) && 
                (
                    this.IndCalcscmag == input.IndCalcscmag ||
                    (this.IndCalcscmag != null &&
                    this.IndCalcscmag.Equals(input.IndCalcscmag))
                ) && 
                (
                    this.IndPrefstdoc == input.IndPrefstdoc ||
                    (this.IndPrefstdoc != null &&
                    this.IndPrefstdoc.Equals(input.IndPrefstdoc))
                ) && 
                (
                    this.IndStdistenas == input.IndStdistenas ||
                    (this.IndStdistenas != null &&
                    this.IndStdistenas.Equals(input.IndStdistenas))
                ) && 
                (
                    this.IndTipoage == input.IndTipoage ||
                    (this.IndTipoage != null &&
                    this.IndTipoage.Equals(input.IndTipoage))
                ) && 
                (
                    this.IndTipoliq == input.IndTipoliq ||
                    (this.IndTipoliq != null &&
                    this.IndTipoliq.Equals(input.IndTipoliq))
                ) && 
                (
                    this.Perprov == input.Perprov ||
                    (this.Perprov != null &&
                    this.Perprov.Equals(input.Perprov))
                ) && 
                (
                    this.Regimeprov == input.Regimeprov ||
                    (this.Regimeprov != null &&
                    this.Regimeprov.Equals(input.Regimeprov))
                ) && 
                (
                    this.Tipomand == input.Tipomand ||
                    (this.Tipomand != null &&
                    this.Tipomand.Equals(input.Tipomand))
                ) && 
                (
                    this.Tiporappor == input.Tiporappor ||
                    (this.Tiporappor != null &&
                    this.Tiporappor.Equals(input.Tiporappor))
                ) && 
                (
                    this.Tiposoc == input.Tiposoc ||
                    (this.Tiposoc != null &&
                    this.Tiposoc.Equals(input.Tiposoc))
                ) && 
                (
                    this.IdExtendedAttributeEntity == input.IdExtendedAttributeEntity ||
                    (this.IdExtendedAttributeEntity != null &&
                    this.IdExtendedAttributeEntity.Equals(input.IdExtendedAttributeEntity))
                ) && 
                (
                    this.IdExtendedAttributeSubEntity == input.IdExtendedAttributeSubEntity ||
                    (this.IdExtendedAttributeSubEntity != null &&
                    this.IdExtendedAttributeSubEntity.Equals(input.IdExtendedAttributeSubEntity))
                ) && 
                (
                    this.DmsPublishedEntityFW == input.DmsPublishedEntityFW ||
                    (this.DmsPublishedEntityFW != null &&
                    this.DmsPublishedEntityFW.Equals(input.DmsPublishedEntityFW))
                ) && 
                (
                    this.GeneralMasterDataCO == input.GeneralMasterDataCO ||
                    (this.GeneralMasterDataCO != null &&
                    this.GeneralMasterDataCO.Equals(input.GeneralMasterDataCO))
                ) && 
                (
                    this.ExtensionData == input.ExtensionData ||
                    this.ExtensionData != null &&
                    input.ExtensionData != null &&
                    this.ExtensionData.SequenceEqual(input.ExtensionData)
                ) && 
                (
                    this.AdditionalData == input.AdditionalData ||
                    this.AdditionalData != null &&
                    input.AdditionalData != null &&
                    this.AdditionalData.SequenceEqual(input.AdditionalData)
                ) && 
                (
                    this.PluginData == input.PluginData ||
                    this.PluginData != null &&
                    input.PluginData != null &&
                    this.PluginData.SequenceEqual(input.PluginData)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.Agente != null)
                    hashCode = hashCode * 59 + this.Agente.GetHashCode();
                if (this.AnagenCg16 != null)
                    hashCode = hashCode * 59 + this.AnagenCg16.GetHashCode();
                if (this.Datafineman != null)
                    hashCode = hashCode * 59 + this.Datafineman.GetHashCode();
                if (this.Datainman != null)
                    hashCode = hashCode * 59 + this.Datainman.GetHashCode();
                if (this.Datainrapp != null)
                    hashCode = hashCode * 59 + this.Datainrapp.GetHashCode();
                if (this.DittaCg18 != null)
                    hashCode = hashCode * 59 + this.DittaCg18.GetHashCode();
                if (this.FlgAdegdelta != null)
                    hashCode = hashCode * 59 + this.FlgAdegdelta.GetHashCode();
                if (this.FlgAdeguamscmag != null)
                    hashCode = hashCode * 59 + this.FlgAdeguamscmag.GetHashCode();
                if (this.FlgRegimeart != null)
                    hashCode = hashCode * 59 + this.FlgRegimeart.GetHashCode();
                if (this.FlgRegimecl != null)
                    hashCode = hashCode * 59 + this.FlgRegimecl.GetHashCode();
                if (this.Guid != null)
                    hashCode = hashCode * 59 + this.Guid.GetHashCode();
                if (this.Idagente != null)
                    hashCode = hashCode * 59 + this.Idagente.GetHashCode();
                if (this.IdcapoareaMg17 != null)
                    hashCode = hashCode * 59 + this.IdcapoareaMg17.GetHashCode();
                if (this.IdcapozonaMg17 != null)
                    hashCode = hashCode * 59 + this.IdcapozonaMg17.GetHashCode();
                if (this.IdmediaCg99 != null)
                    hashCode = hashCode * 59 + this.IdmediaCg99.GetHashCode();
                if (this.IndBaseimpmag != null)
                    hashCode = hashCode * 59 + this.IndBaseimpmag.GetHashCode();
                if (this.IndBaseimpsc != null)
                    hashCode = hashCode * 59 + this.IndBaseimpsc.GetHashCode();
                if (this.IndCalcscmag != null)
                    hashCode = hashCode * 59 + this.IndCalcscmag.GetHashCode();
                if (this.IndPrefstdoc != null)
                    hashCode = hashCode * 59 + this.IndPrefstdoc.GetHashCode();
                if (this.IndStdistenas != null)
                    hashCode = hashCode * 59 + this.IndStdistenas.GetHashCode();
                if (this.IndTipoage != null)
                    hashCode = hashCode * 59 + this.IndTipoage.GetHashCode();
                if (this.IndTipoliq != null)
                    hashCode = hashCode * 59 + this.IndTipoliq.GetHashCode();
                if (this.Perprov != null)
                    hashCode = hashCode * 59 + this.Perprov.GetHashCode();
                if (this.Regimeprov != null)
                    hashCode = hashCode * 59 + this.Regimeprov.GetHashCode();
                if (this.Tipomand != null)
                    hashCode = hashCode * 59 + this.Tipomand.GetHashCode();
                if (this.Tiporappor != null)
                    hashCode = hashCode * 59 + this.Tiporappor.GetHashCode();
                if (this.Tiposoc != null)
                    hashCode = hashCode * 59 + this.Tiposoc.GetHashCode();
                if (this.IdExtendedAttributeEntity != null)
                    hashCode = hashCode * 59 + this.IdExtendedAttributeEntity.GetHashCode();
                if (this.IdExtendedAttributeSubEntity != null)
                    hashCode = hashCode * 59 + this.IdExtendedAttributeSubEntity.GetHashCode();
                if (this.DmsPublishedEntityFW != null)
                    hashCode = hashCode * 59 + this.DmsPublishedEntityFW.GetHashCode();
                if (this.GeneralMasterDataCO != null)
                    hashCode = hashCode * 59 + this.GeneralMasterDataCO.GetHashCode();
                if (this.ExtensionData != null)
                    hashCode = hashCode * 59 + this.ExtensionData.GetHashCode();
                if (this.AdditionalData != null)
                    hashCode = hashCode * 59 + this.AdditionalData.GetHashCode();
                if (this.PluginData != null)
                    hashCode = hashCode * 59 + this.PluginData.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
