/* 
 * TSE Cloud - CO
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.3000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// CG33_TABCAU - Causale contabile&lt;br&gt;Proprietà chiave:&lt;ul&gt;&lt;li&gt;&lt;b&gt;Codice&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;
    /// </summary>
    [DataContract]
        public partial class AccountingReasonCodeCODTO :  IEquatable<AccountingReasonCodeCODTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="AccountingReasonCodeCODTO" /> class.
        /// </summary>
        /// <param name="caualias">CG33_CAUALIAS - Alias per ricerca causale contabile (required).</param>
        /// <param name="causalecoll">CG33_CAUSALECOLL - Causale collegata.</param>
        /// <param name="causalecolltype">CG33_CAUSALECOLLTYPE -  Tipo movimento&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Iva&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Contabile&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Scadenze&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="causaleiva">CG33_CAUSALEIVA - Causale IVA.</param>
        /// <param name="codice">CG33_CODICE - Codice causale (required).</param>
        /// <param name="descr">CG33_DESCR - Descrizione.</param>
        /// <param name="flgAcconto">CG33_FLGACCONTO - Causale acconto&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="flgAgviag">CG33_FLGAGVIAG - Agenzie viaggio&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="flgAutofatt">CG33_FLGAUTOFATT - Autofattura&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="flgCaufissa">CG33_FLGCAUFISSA - Causale fissa&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="flgComp">CG33_FLGCOMP - Competenza esercizio precedente&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="flgDatiassegno">CG33_FLGDATIASSEGNO - Richiesta riferimenti assegno&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="flgEconto">CG33_FLGECONTO - Gest. E/Conto&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="flgFattdiff">CG33_FLGFATTDIFF - Rich. data comp. IVA.</param>
        /// <param name="flgGestsez">CG33_FLGGESTSEZ - Protocolla movimento&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="flgInsoluti">CG33_FLGINSOLUTI - Insoluti&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="flgIvaedit">CG33_FLGIVAEDIT - IVA editoria&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="flgPortaf">CG33_FLGPORTAF - Gest. portafoglio&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="flgProtsemp">CG33_FLGPROTSEMP - Nr. docum. semplificata.</param>
        /// <param name="flgSubforni">CG33_FLGSUBFORNI - Subfornitura&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="idCg0z">CG33_ID_CG0Z - IdCg0z.</param>
        /// <param name="idCgd1">CG33_ID_CGD1 - Classificazione causale.</param>
        /// <param name="idmediaCg99">CG33_IDMEDIA_CG99 - ID HyperMedia.</param>
        /// <param name="idprov">CG33_IDPROV - IdProv (Required only in PUT/PATCH).</param>
        /// <param name="indCaubenius">CG33_INDCAUBENIUS - Regime del margine&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuno&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Analitico&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Globale&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Forfetario&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Normale&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="indDaav">CG33_INDDAAV - Segno&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuno&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Dare&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Avere&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="indGestec">CG33_INDGESTEC - Gest. E/Conto&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Apertura&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Chiusura&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Apertura/chiusura&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="indGestfattproforma">CG33_INDGESTFATTPROFORMA - Gestione fatture proforma (default to 0).</param>
        /// <param name="indMonofasersm">CG33_INDMONOFASERSM - Operazioni monofase RSM (default to 0).</param>
        /// <param name="indProteo360">CG33_INDPROTEO360 - Aggancio alla procedura Proteo 360 (default to 0).</param>
        /// <param name="indScadfattproforma">CG33_INDSCADFATTPROFORMA - Scadenze in fatture proforma (default to 0).</param>
        /// <param name="indTipomov">CG33_INDTIPOMOV - Tipo operazione&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - criterio Gestionale      &lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - criterio di Cassa        &lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Gestionale/Cassa         &lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Gestionale/Cassa sospeso &lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Gestionale/Cassa speciale&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Gestionale/Cassa esteso  &lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="indTipooper">CG33_INDTIPOOPER - IndTipooper (default to 0).</param>
        /// <param name="indTiporeg">CG33_INDTIPOREG - Tipo registro&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuno&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Acquisti&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Vendite&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Corrispettivi&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="rowversion">CG33_ROWVERSION - RowVersion.</param>
        /// <param name="tipoeff">CG33_TIPOEFF - Tipo effetti&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Tutti&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Contanti&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Ricevuta bancaria&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Tratta&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Tratta accettata&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Cessione&lt;/li&gt;&lt;li&gt;&lt;i&gt;6&lt;/i&gt; - Cambiale&lt;/li&gt;&lt;li&gt;&lt;i&gt;7&lt;/i&gt; - Carta di credito&lt;/li&gt;&lt;li&gt;&lt;i&gt;8&lt;/i&gt; - Bancomat&lt;/li&gt;&lt;li&gt;&lt;i&gt;9&lt;/i&gt; - Contrassegno&lt;/li&gt;&lt;li&gt;&lt;i&gt;10&lt;/i&gt; - Lettera di credito&lt;/li&gt;&lt;li&gt;&lt;i&gt;11&lt;/i&gt; - RID&lt;/li&gt;&lt;li&gt;&lt;i&gt;12&lt;/i&gt; - Leasing&lt;/li&gt;&lt;li&gt;&lt;i&gt;13&lt;/i&gt; - Rimessa diretta&lt;/li&gt;&lt;li&gt;&lt;i&gt;14&lt;/i&gt; - Bonifico&lt;/li&gt;&lt;li&gt;&lt;i&gt;15&lt;/i&gt; - C/C postale&lt;/li&gt;&lt;li&gt;&lt;i&gt;16&lt;/i&gt; - MAV&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="classification">classification.</param>
        /// <param name="vatCodeReason">vatCodeReason.</param>
        /// <param name="vatCodeReasonConnect">vatCodeReasonConnect.</param>
        /// <param name="additionalData">additionalData.</param>
        /// <param name="pluginData">pluginData.</param>
        public AccountingReasonCodeCODTO(string caualias = default(string), string causalecoll = default(string), double? causalecolltype = default(double?), string causaleiva = default(string), string codice = default(string), string descr = default(string), double? flgAcconto = 0, double? flgAgviag = default(double?), double? flgAutofatt = 0, double? flgCaufissa = 0, double? flgComp = 0, double? flgDatiassegno = 0, double? flgEconto = 0, double? flgFattdiff = default(double?), double? flgGestsez = 0, double? flgInsoluti = 0, double? flgIvaedit = 0, double? flgPortaf = 0, double? flgProtsemp = default(double?), double? flgSubforni = 0, long? idCg0z = default(long?), double? idCgd1 = default(double?), double? idmediaCg99 = default(double?), double? idprov = default(double?), double? indCaubenius = default(double?), int? indDaav = default(int?), double? indGestec = 0, int? indGestfattproforma = 0, double? indMonofasersm = 0, double? indProteo360 = 0, int? indScadfattproforma = 0, int? indTipomov = 0, double? indTipooper = 0, int? indTiporeg = 0, byte[] rowversion = default(byte[]), int? tipoeff = 0, AccountingReasonCodeClassificationCODTO classification = default(AccountingReasonCodeClassificationCODTO), AccountingReasonCodeCODTO vatCodeReason = default(AccountingReasonCodeCODTO), AccountingReasonCodeCODTO vatCodeReasonConnect = default(AccountingReasonCodeCODTO), Dictionary<string, Object> additionalData = default(Dictionary<string, Object>), Dictionary<string, Object> pluginData = default(Dictionary<string, Object>))
        {
            // to ensure "caualias" is required (not null)
            if (caualias == null)
            {
                throw new InvalidDataException("caualias is a required property for AccountingReasonCodeCODTO and cannot be null");
            }
            else
            {
                this.Caualias = caualias;
            }
            // to ensure "codice" is required (not null)
            if (codice == null)
            {
                throw new InvalidDataException("codice is a required property for AccountingReasonCodeCODTO and cannot be null");
            }
            else
            {
                this.Codice = codice;
            }
            this.Causalecoll = causalecoll;
            this.Causalecolltype = causalecolltype;
            this.Causaleiva = causaleiva;
            this.Descr = descr;
            // use default value if no "flgAcconto" provided
            if (flgAcconto == null)
            {
                this.FlgAcconto = 0;
            }
            else
            {
                this.FlgAcconto = flgAcconto;
            }
            this.FlgAgviag = flgAgviag;
            // use default value if no "flgAutofatt" provided
            if (flgAutofatt == null)
            {
                this.FlgAutofatt = 0;
            }
            else
            {
                this.FlgAutofatt = flgAutofatt;
            }
            // use default value if no "flgCaufissa" provided
            if (flgCaufissa == null)
            {
                this.FlgCaufissa = 0;
            }
            else
            {
                this.FlgCaufissa = flgCaufissa;
            }
            // use default value if no "flgComp" provided
            if (flgComp == null)
            {
                this.FlgComp = 0;
            }
            else
            {
                this.FlgComp = flgComp;
            }
            // use default value if no "flgDatiassegno" provided
            if (flgDatiassegno == null)
            {
                this.FlgDatiassegno = 0;
            }
            else
            {
                this.FlgDatiassegno = flgDatiassegno;
            }
            // use default value if no "flgEconto" provided
            if (flgEconto == null)
            {
                this.FlgEconto = 0;
            }
            else
            {
                this.FlgEconto = flgEconto;
            }
            this.FlgFattdiff = flgFattdiff;
            // use default value if no "flgGestsez" provided
            if (flgGestsez == null)
            {
                this.FlgGestsez = 0;
            }
            else
            {
                this.FlgGestsez = flgGestsez;
            }
            // use default value if no "flgInsoluti" provided
            if (flgInsoluti == null)
            {
                this.FlgInsoluti = 0;
            }
            else
            {
                this.FlgInsoluti = flgInsoluti;
            }
            // use default value if no "flgIvaedit" provided
            if (flgIvaedit == null)
            {
                this.FlgIvaedit = 0;
            }
            else
            {
                this.FlgIvaedit = flgIvaedit;
            }
            // use default value if no "flgPortaf" provided
            if (flgPortaf == null)
            {
                this.FlgPortaf = 0;
            }
            else
            {
                this.FlgPortaf = flgPortaf;
            }
            this.FlgProtsemp = flgProtsemp;
            // use default value if no "flgSubforni" provided
            if (flgSubforni == null)
            {
                this.FlgSubforni = 0;
            }
            else
            {
                this.FlgSubforni = flgSubforni;
            }
            this.IdCg0z = idCg0z;
            this.IdCgd1 = idCgd1;
            this.IdmediaCg99 = idmediaCg99;
            this.Idprov = idprov;
            this.IndCaubenius = indCaubenius;
            this.IndDaav = indDaav;
            // use default value if no "indGestec" provided
            if (indGestec == null)
            {
                this.IndGestec = 0;
            }
            else
            {
                this.IndGestec = indGestec;
            }
            // use default value if no "indGestfattproforma" provided
            if (indGestfattproforma == null)
            {
                this.IndGestfattproforma = 0;
            }
            else
            {
                this.IndGestfattproforma = indGestfattproforma;
            }
            // use default value if no "indMonofasersm" provided
            if (indMonofasersm == null)
            {
                this.IndMonofasersm = 0;
            }
            else
            {
                this.IndMonofasersm = indMonofasersm;
            }
            // use default value if no "indProteo360" provided
            if (indProteo360 == null)
            {
                this.IndProteo360 = 0;
            }
            else
            {
                this.IndProteo360 = indProteo360;
            }
            // use default value if no "indScadfattproforma" provided
            if (indScadfattproforma == null)
            {
                this.IndScadfattproforma = 0;
            }
            else
            {
                this.IndScadfattproforma = indScadfattproforma;
            }
            // use default value if no "indTipomov" provided
            if (indTipomov == null)
            {
                this.IndTipomov = 0;
            }
            else
            {
                this.IndTipomov = indTipomov;
            }
            // use default value if no "indTipooper" provided
            if (indTipooper == null)
            {
                this.IndTipooper = 0;
            }
            else
            {
                this.IndTipooper = indTipooper;
            }
            // use default value if no "indTiporeg" provided
            if (indTiporeg == null)
            {
                this.IndTiporeg = 0;
            }
            else
            {
                this.IndTiporeg = indTiporeg;
            }
            this.Rowversion = rowversion;
            // use default value if no "tipoeff" provided
            if (tipoeff == null)
            {
                this.Tipoeff = 0;
            }
            else
            {
                this.Tipoeff = tipoeff;
            }
            this.Classification = classification;
            this.VatCodeReason = vatCodeReason;
            this.VatCodeReasonConnect = vatCodeReasonConnect;
            this.AdditionalData = additionalData;
            this.PluginData = pluginData;
        }
        
        /// <summary>
        /// CG33_CAUALIAS - Alias per ricerca causale contabile
        /// </summary>
        /// <value>CG33_CAUALIAS - Alias per ricerca causale contabile</value>
        [DataMember(Name="caualias", EmitDefaultValue=false)]
        public string Caualias { get; set; }

        /// <summary>
        /// CG33_CAUSALECOLL - Causale collegata
        /// </summary>
        /// <value>CG33_CAUSALECOLL - Causale collegata</value>
        [DataMember(Name="causalecoll", EmitDefaultValue=false)]
        public string Causalecoll { get; set; }

        /// <summary>
        /// CG33_CAUSALECOLLTYPE -  Tipo movimento&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Iva&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Contabile&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Scadenze&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG33_CAUSALECOLLTYPE -  Tipo movimento&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Iva&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Contabile&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Scadenze&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="causalecolltype", EmitDefaultValue=false)]
        public double? Causalecolltype { get; set; }

        /// <summary>
        /// CG33_CAUSALEIVA - Causale IVA
        /// </summary>
        /// <value>CG33_CAUSALEIVA - Causale IVA</value>
        [DataMember(Name="causaleiva", EmitDefaultValue=false)]
        public string Causaleiva { get; set; }

        /// <summary>
        /// CG33_CODICE - Codice causale
        /// </summary>
        /// <value>CG33_CODICE - Codice causale</value>
        [DataMember(Name="codice", EmitDefaultValue=false)]
        public string Codice { get; set; }

        /// <summary>
        /// CG33_DESCR - Descrizione
        /// </summary>
        /// <value>CG33_DESCR - Descrizione</value>
        [DataMember(Name="descr", EmitDefaultValue=false)]
        public string Descr { get; set; }

        /// <summary>
        /// CG33_FLGACCONTO - Causale acconto&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG33_FLGACCONTO - Causale acconto&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgAcconto", EmitDefaultValue=false)]
        public double? FlgAcconto { get; set; }

        /// <summary>
        /// CG33_FLGAGVIAG - Agenzie viaggio&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG33_FLGAGVIAG - Agenzie viaggio&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgAgviag", EmitDefaultValue=false)]
        public double? FlgAgviag { get; set; }

        /// <summary>
        /// CG33_FLGAUTOFATT - Autofattura&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG33_FLGAUTOFATT - Autofattura&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgAutofatt", EmitDefaultValue=false)]
        public double? FlgAutofatt { get; set; }

        /// <summary>
        /// CG33_FLGCAUFISSA - Causale fissa&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG33_FLGCAUFISSA - Causale fissa&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgCaufissa", EmitDefaultValue=false)]
        public double? FlgCaufissa { get; set; }

        /// <summary>
        /// CG33_FLGCOMP - Competenza esercizio precedente&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG33_FLGCOMP - Competenza esercizio precedente&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgComp", EmitDefaultValue=false)]
        public double? FlgComp { get; set; }

        /// <summary>
        /// CG33_FLGDATIASSEGNO - Richiesta riferimenti assegno&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG33_FLGDATIASSEGNO - Richiesta riferimenti assegno&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgDatiassegno", EmitDefaultValue=false)]
        public double? FlgDatiassegno { get; set; }

        /// <summary>
        /// CG33_FLGECONTO - Gest. E/Conto&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG33_FLGECONTO - Gest. E/Conto&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgEconto", EmitDefaultValue=false)]
        public double? FlgEconto { get; set; }

        /// <summary>
        /// CG33_FLGFATTDIFF - Rich. data comp. IVA
        /// </summary>
        /// <value>CG33_FLGFATTDIFF - Rich. data comp. IVA</value>
        [DataMember(Name="flgFattdiff", EmitDefaultValue=false)]
        public double? FlgFattdiff { get; set; }

        /// <summary>
        /// CG33_FLGGESTSEZ - Protocolla movimento&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG33_FLGGESTSEZ - Protocolla movimento&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgGestsez", EmitDefaultValue=false)]
        public double? FlgGestsez { get; set; }

        /// <summary>
        /// CG33_FLGINSOLUTI - Insoluti&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG33_FLGINSOLUTI - Insoluti&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgInsoluti", EmitDefaultValue=false)]
        public double? FlgInsoluti { get; set; }

        /// <summary>
        /// CG33_FLGIVAEDIT - IVA editoria&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG33_FLGIVAEDIT - IVA editoria&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgIvaedit", EmitDefaultValue=false)]
        public double? FlgIvaedit { get; set; }

        /// <summary>
        /// CG33_FLGPORTAF - Gest. portafoglio&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG33_FLGPORTAF - Gest. portafoglio&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgPortaf", EmitDefaultValue=false)]
        public double? FlgPortaf { get; set; }

        /// <summary>
        /// CG33_FLGPROTSEMP - Nr. docum. semplificata
        /// </summary>
        /// <value>CG33_FLGPROTSEMP - Nr. docum. semplificata</value>
        [DataMember(Name="flgProtsemp", EmitDefaultValue=false)]
        public double? FlgProtsemp { get; set; }

        /// <summary>
        /// CG33_FLGSUBFORNI - Subfornitura&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG33_FLGSUBFORNI - Subfornitura&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgSubforni", EmitDefaultValue=false)]
        public double? FlgSubforni { get; set; }

        /// <summary>
        /// CG33_ID_CG0Z - IdCg0z
        /// </summary>
        /// <value>CG33_ID_CG0Z - IdCg0z</value>
        [DataMember(Name="idCg0z", EmitDefaultValue=false)]
        public long? IdCg0z { get; set; }

        /// <summary>
        /// CG33_ID_CGD1 - Classificazione causale
        /// </summary>
        /// <value>CG33_ID_CGD1 - Classificazione causale</value>
        [DataMember(Name="idCgd1", EmitDefaultValue=false)]
        public double? IdCgd1 { get; set; }

        /// <summary>
        /// CG33_IDMEDIA_CG99 - ID HyperMedia
        /// </summary>
        /// <value>CG33_IDMEDIA_CG99 - ID HyperMedia</value>
        [DataMember(Name="idmediaCg99", EmitDefaultValue=false)]
        public double? IdmediaCg99 { get; set; }

        /// <summary>
        /// CG33_IDPROV - IdProv (Required only in PUT/PATCH)
        /// </summary>
        /// <value>CG33_IDPROV - IdProv (Required only in PUT/PATCH)</value>
        [DataMember(Name="idprov", EmitDefaultValue=false)]
        public double? Idprov { get; set; }

        /// <summary>
        /// CG33_INDCAUBENIUS - Regime del margine&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuno&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Analitico&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Globale&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Forfetario&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Normale&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG33_INDCAUBENIUS - Regime del margine&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuno&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Analitico&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Globale&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Forfetario&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Normale&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indCaubenius", EmitDefaultValue=false)]
        public double? IndCaubenius { get; set; }

        /// <summary>
        /// CG33_INDDAAV - Segno&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuno&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Dare&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Avere&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG33_INDDAAV - Segno&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuno&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Dare&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Avere&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indDaav", EmitDefaultValue=false)]
        public int? IndDaav { get; set; }

        /// <summary>
        /// CG33_INDGESTEC - Gest. E/Conto&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Apertura&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Chiusura&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Apertura/chiusura&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG33_INDGESTEC - Gest. E/Conto&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Apertura&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Chiusura&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Apertura/chiusura&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indGestec", EmitDefaultValue=false)]
        public double? IndGestec { get; set; }

        /// <summary>
        /// CG33_INDGESTFATTPROFORMA - Gestione fatture proforma
        /// </summary>
        /// <value>CG33_INDGESTFATTPROFORMA - Gestione fatture proforma</value>
        [DataMember(Name="indGestfattproforma", EmitDefaultValue=false)]
        public int? IndGestfattproforma { get; set; }

        /// <summary>
        /// CG33_INDMONOFASERSM - Operazioni monofase RSM
        /// </summary>
        /// <value>CG33_INDMONOFASERSM - Operazioni monofase RSM</value>
        [DataMember(Name="indMonofasersm", EmitDefaultValue=false)]
        public double? IndMonofasersm { get; set; }

        /// <summary>
        /// CG33_INDPROTEO360 - Aggancio alla procedura Proteo 360
        /// </summary>
        /// <value>CG33_INDPROTEO360 - Aggancio alla procedura Proteo 360</value>
        [DataMember(Name="indProteo360", EmitDefaultValue=false)]
        public double? IndProteo360 { get; set; }

        /// <summary>
        /// CG33_INDSCADFATTPROFORMA - Scadenze in fatture proforma
        /// </summary>
        /// <value>CG33_INDSCADFATTPROFORMA - Scadenze in fatture proforma</value>
        [DataMember(Name="indScadfattproforma", EmitDefaultValue=false)]
        public int? IndScadfattproforma { get; set; }

        /// <summary>
        /// CG33_INDTIPOMOV - Tipo operazione&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - criterio Gestionale      &lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - criterio di Cassa        &lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Gestionale/Cassa         &lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Gestionale/Cassa sospeso &lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Gestionale/Cassa speciale&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Gestionale/Cassa esteso  &lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG33_INDTIPOMOV - Tipo operazione&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - criterio Gestionale      &lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - criterio di Cassa        &lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Gestionale/Cassa         &lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Gestionale/Cassa sospeso &lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Gestionale/Cassa speciale&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Gestionale/Cassa esteso  &lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indTipomov", EmitDefaultValue=false)]
        public int? IndTipomov { get; set; }

        /// <summary>
        /// CG33_INDTIPOOPER - IndTipooper
        /// </summary>
        /// <value>CG33_INDTIPOOPER - IndTipooper</value>
        [DataMember(Name="indTipooper", EmitDefaultValue=false)]
        public double? IndTipooper { get; set; }

        /// <summary>
        /// CG33_INDTIPOREG - Tipo registro&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuno&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Acquisti&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Vendite&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Corrispettivi&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG33_INDTIPOREG - Tipo registro&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuno&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Acquisti&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Vendite&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Corrispettivi&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indTiporeg", EmitDefaultValue=false)]
        public int? IndTiporeg { get; set; }

        /// <summary>
        /// CG33_ROWVERSION - RowVersion
        /// </summary>
        /// <value>CG33_ROWVERSION - RowVersion</value>
        [DataMember(Name="rowversion", EmitDefaultValue=false)]
        public byte[] Rowversion { get; set; }

        /// <summary>
        /// CG33_TIPOEFF - Tipo effetti&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Tutti&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Contanti&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Ricevuta bancaria&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Tratta&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Tratta accettata&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Cessione&lt;/li&gt;&lt;li&gt;&lt;i&gt;6&lt;/i&gt; - Cambiale&lt;/li&gt;&lt;li&gt;&lt;i&gt;7&lt;/i&gt; - Carta di credito&lt;/li&gt;&lt;li&gt;&lt;i&gt;8&lt;/i&gt; - Bancomat&lt;/li&gt;&lt;li&gt;&lt;i&gt;9&lt;/i&gt; - Contrassegno&lt;/li&gt;&lt;li&gt;&lt;i&gt;10&lt;/i&gt; - Lettera di credito&lt;/li&gt;&lt;li&gt;&lt;i&gt;11&lt;/i&gt; - RID&lt;/li&gt;&lt;li&gt;&lt;i&gt;12&lt;/i&gt; - Leasing&lt;/li&gt;&lt;li&gt;&lt;i&gt;13&lt;/i&gt; - Rimessa diretta&lt;/li&gt;&lt;li&gt;&lt;i&gt;14&lt;/i&gt; - Bonifico&lt;/li&gt;&lt;li&gt;&lt;i&gt;15&lt;/i&gt; - C/C postale&lt;/li&gt;&lt;li&gt;&lt;i&gt;16&lt;/i&gt; - MAV&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG33_TIPOEFF - Tipo effetti&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Tutti&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Contanti&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Ricevuta bancaria&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Tratta&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Tratta accettata&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Cessione&lt;/li&gt;&lt;li&gt;&lt;i&gt;6&lt;/i&gt; - Cambiale&lt;/li&gt;&lt;li&gt;&lt;i&gt;7&lt;/i&gt; - Carta di credito&lt;/li&gt;&lt;li&gt;&lt;i&gt;8&lt;/i&gt; - Bancomat&lt;/li&gt;&lt;li&gt;&lt;i&gt;9&lt;/i&gt; - Contrassegno&lt;/li&gt;&lt;li&gt;&lt;i&gt;10&lt;/i&gt; - Lettera di credito&lt;/li&gt;&lt;li&gt;&lt;i&gt;11&lt;/i&gt; - RID&lt;/li&gt;&lt;li&gt;&lt;i&gt;12&lt;/i&gt; - Leasing&lt;/li&gt;&lt;li&gt;&lt;i&gt;13&lt;/i&gt; - Rimessa diretta&lt;/li&gt;&lt;li&gt;&lt;i&gt;14&lt;/i&gt; - Bonifico&lt;/li&gt;&lt;li&gt;&lt;i&gt;15&lt;/i&gt; - C/C postale&lt;/li&gt;&lt;li&gt;&lt;i&gt;16&lt;/i&gt; - MAV&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="tipoeff", EmitDefaultValue=false)]
        public int? Tipoeff { get; set; }

        /// <summary>
        /// Gets or Sets Classification
        /// </summary>
        [DataMember(Name="classification", EmitDefaultValue=false)]
        public AccountingReasonCodeClassificationCODTO Classification { get; set; }

        /// <summary>
        /// Gets or Sets VatCodeReason
        /// </summary>
        [DataMember(Name="vatCodeReason", EmitDefaultValue=false)]
        public AccountingReasonCodeCODTO VatCodeReason { get; set; }

        /// <summary>
        /// Gets or Sets VatCodeReasonConnect
        /// </summary>
        [DataMember(Name="vatCodeReasonConnect", EmitDefaultValue=false)]
        public AccountingReasonCodeCODTO VatCodeReasonConnect { get; set; }

        /// <summary>
        /// Gets or Sets AdditionalData
        /// </summary>
        [DataMember(Name="additionalData", EmitDefaultValue=false)]
        public Dictionary<string, Object> AdditionalData { get; set; }

        /// <summary>
        /// Gets or Sets PluginData
        /// </summary>
        [DataMember(Name="pluginData", EmitDefaultValue=false)]
        public Dictionary<string, Object> PluginData { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class AccountingReasonCodeCODTO {\n");
            sb.Append("  Caualias: ").Append(Caualias).Append("\n");
            sb.Append("  Causalecoll: ").Append(Causalecoll).Append("\n");
            sb.Append("  Causalecolltype: ").Append(Causalecolltype).Append("\n");
            sb.Append("  Causaleiva: ").Append(Causaleiva).Append("\n");
            sb.Append("  Codice: ").Append(Codice).Append("\n");
            sb.Append("  Descr: ").Append(Descr).Append("\n");
            sb.Append("  FlgAcconto: ").Append(FlgAcconto).Append("\n");
            sb.Append("  FlgAgviag: ").Append(FlgAgviag).Append("\n");
            sb.Append("  FlgAutofatt: ").Append(FlgAutofatt).Append("\n");
            sb.Append("  FlgCaufissa: ").Append(FlgCaufissa).Append("\n");
            sb.Append("  FlgComp: ").Append(FlgComp).Append("\n");
            sb.Append("  FlgDatiassegno: ").Append(FlgDatiassegno).Append("\n");
            sb.Append("  FlgEconto: ").Append(FlgEconto).Append("\n");
            sb.Append("  FlgFattdiff: ").Append(FlgFattdiff).Append("\n");
            sb.Append("  FlgGestsez: ").Append(FlgGestsez).Append("\n");
            sb.Append("  FlgInsoluti: ").Append(FlgInsoluti).Append("\n");
            sb.Append("  FlgIvaedit: ").Append(FlgIvaedit).Append("\n");
            sb.Append("  FlgPortaf: ").Append(FlgPortaf).Append("\n");
            sb.Append("  FlgProtsemp: ").Append(FlgProtsemp).Append("\n");
            sb.Append("  FlgSubforni: ").Append(FlgSubforni).Append("\n");
            sb.Append("  IdCg0z: ").Append(IdCg0z).Append("\n");
            sb.Append("  IdCgd1: ").Append(IdCgd1).Append("\n");
            sb.Append("  IdmediaCg99: ").Append(IdmediaCg99).Append("\n");
            sb.Append("  Idprov: ").Append(Idprov).Append("\n");
            sb.Append("  IndCaubenius: ").Append(IndCaubenius).Append("\n");
            sb.Append("  IndDaav: ").Append(IndDaav).Append("\n");
            sb.Append("  IndGestec: ").Append(IndGestec).Append("\n");
            sb.Append("  IndGestfattproforma: ").Append(IndGestfattproforma).Append("\n");
            sb.Append("  IndMonofasersm: ").Append(IndMonofasersm).Append("\n");
            sb.Append("  IndProteo360: ").Append(IndProteo360).Append("\n");
            sb.Append("  IndScadfattproforma: ").Append(IndScadfattproforma).Append("\n");
            sb.Append("  IndTipomov: ").Append(IndTipomov).Append("\n");
            sb.Append("  IndTipooper: ").Append(IndTipooper).Append("\n");
            sb.Append("  IndTiporeg: ").Append(IndTiporeg).Append("\n");
            sb.Append("  Rowversion: ").Append(Rowversion).Append("\n");
            sb.Append("  Tipoeff: ").Append(Tipoeff).Append("\n");
            sb.Append("  Classification: ").Append(Classification).Append("\n");
            sb.Append("  VatCodeReason: ").Append(VatCodeReason).Append("\n");
            sb.Append("  VatCodeReasonConnect: ").Append(VatCodeReasonConnect).Append("\n");
            sb.Append("  AdditionalData: ").Append(AdditionalData).Append("\n");
            sb.Append("  PluginData: ").Append(PluginData).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as AccountingReasonCodeCODTO);
        }

        /// <summary>
        /// Returns true if AccountingReasonCodeCODTO instances are equal
        /// </summary>
        /// <param name="input">Instance of AccountingReasonCodeCODTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(AccountingReasonCodeCODTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.Caualias == input.Caualias ||
                    (this.Caualias != null &&
                    this.Caualias.Equals(input.Caualias))
                ) && 
                (
                    this.Causalecoll == input.Causalecoll ||
                    (this.Causalecoll != null &&
                    this.Causalecoll.Equals(input.Causalecoll))
                ) && 
                (
                    this.Causalecolltype == input.Causalecolltype ||
                    (this.Causalecolltype != null &&
                    this.Causalecolltype.Equals(input.Causalecolltype))
                ) && 
                (
                    this.Causaleiva == input.Causaleiva ||
                    (this.Causaleiva != null &&
                    this.Causaleiva.Equals(input.Causaleiva))
                ) && 
                (
                    this.Codice == input.Codice ||
                    (this.Codice != null &&
                    this.Codice.Equals(input.Codice))
                ) && 
                (
                    this.Descr == input.Descr ||
                    (this.Descr != null &&
                    this.Descr.Equals(input.Descr))
                ) && 
                (
                    this.FlgAcconto == input.FlgAcconto ||
                    (this.FlgAcconto != null &&
                    this.FlgAcconto.Equals(input.FlgAcconto))
                ) && 
                (
                    this.FlgAgviag == input.FlgAgviag ||
                    (this.FlgAgviag != null &&
                    this.FlgAgviag.Equals(input.FlgAgviag))
                ) && 
                (
                    this.FlgAutofatt == input.FlgAutofatt ||
                    (this.FlgAutofatt != null &&
                    this.FlgAutofatt.Equals(input.FlgAutofatt))
                ) && 
                (
                    this.FlgCaufissa == input.FlgCaufissa ||
                    (this.FlgCaufissa != null &&
                    this.FlgCaufissa.Equals(input.FlgCaufissa))
                ) && 
                (
                    this.FlgComp == input.FlgComp ||
                    (this.FlgComp != null &&
                    this.FlgComp.Equals(input.FlgComp))
                ) && 
                (
                    this.FlgDatiassegno == input.FlgDatiassegno ||
                    (this.FlgDatiassegno != null &&
                    this.FlgDatiassegno.Equals(input.FlgDatiassegno))
                ) && 
                (
                    this.FlgEconto == input.FlgEconto ||
                    (this.FlgEconto != null &&
                    this.FlgEconto.Equals(input.FlgEconto))
                ) && 
                (
                    this.FlgFattdiff == input.FlgFattdiff ||
                    (this.FlgFattdiff != null &&
                    this.FlgFattdiff.Equals(input.FlgFattdiff))
                ) && 
                (
                    this.FlgGestsez == input.FlgGestsez ||
                    (this.FlgGestsez != null &&
                    this.FlgGestsez.Equals(input.FlgGestsez))
                ) && 
                (
                    this.FlgInsoluti == input.FlgInsoluti ||
                    (this.FlgInsoluti != null &&
                    this.FlgInsoluti.Equals(input.FlgInsoluti))
                ) && 
                (
                    this.FlgIvaedit == input.FlgIvaedit ||
                    (this.FlgIvaedit != null &&
                    this.FlgIvaedit.Equals(input.FlgIvaedit))
                ) && 
                (
                    this.FlgPortaf == input.FlgPortaf ||
                    (this.FlgPortaf != null &&
                    this.FlgPortaf.Equals(input.FlgPortaf))
                ) && 
                (
                    this.FlgProtsemp == input.FlgProtsemp ||
                    (this.FlgProtsemp != null &&
                    this.FlgProtsemp.Equals(input.FlgProtsemp))
                ) && 
                (
                    this.FlgSubforni == input.FlgSubforni ||
                    (this.FlgSubforni != null &&
                    this.FlgSubforni.Equals(input.FlgSubforni))
                ) && 
                (
                    this.IdCg0z == input.IdCg0z ||
                    (this.IdCg0z != null &&
                    this.IdCg0z.Equals(input.IdCg0z))
                ) && 
                (
                    this.IdCgd1 == input.IdCgd1 ||
                    (this.IdCgd1 != null &&
                    this.IdCgd1.Equals(input.IdCgd1))
                ) && 
                (
                    this.IdmediaCg99 == input.IdmediaCg99 ||
                    (this.IdmediaCg99 != null &&
                    this.IdmediaCg99.Equals(input.IdmediaCg99))
                ) && 
                (
                    this.Idprov == input.Idprov ||
                    (this.Idprov != null &&
                    this.Idprov.Equals(input.Idprov))
                ) && 
                (
                    this.IndCaubenius == input.IndCaubenius ||
                    (this.IndCaubenius != null &&
                    this.IndCaubenius.Equals(input.IndCaubenius))
                ) && 
                (
                    this.IndDaav == input.IndDaav ||
                    (this.IndDaav != null &&
                    this.IndDaav.Equals(input.IndDaav))
                ) && 
                (
                    this.IndGestec == input.IndGestec ||
                    (this.IndGestec != null &&
                    this.IndGestec.Equals(input.IndGestec))
                ) && 
                (
                    this.IndGestfattproforma == input.IndGestfattproforma ||
                    (this.IndGestfattproforma != null &&
                    this.IndGestfattproforma.Equals(input.IndGestfattproforma))
                ) && 
                (
                    this.IndMonofasersm == input.IndMonofasersm ||
                    (this.IndMonofasersm != null &&
                    this.IndMonofasersm.Equals(input.IndMonofasersm))
                ) && 
                (
                    this.IndProteo360 == input.IndProteo360 ||
                    (this.IndProteo360 != null &&
                    this.IndProteo360.Equals(input.IndProteo360))
                ) && 
                (
                    this.IndScadfattproforma == input.IndScadfattproforma ||
                    (this.IndScadfattproforma != null &&
                    this.IndScadfattproforma.Equals(input.IndScadfattproforma))
                ) && 
                (
                    this.IndTipomov == input.IndTipomov ||
                    (this.IndTipomov != null &&
                    this.IndTipomov.Equals(input.IndTipomov))
                ) && 
                (
                    this.IndTipooper == input.IndTipooper ||
                    (this.IndTipooper != null &&
                    this.IndTipooper.Equals(input.IndTipooper))
                ) && 
                (
                    this.IndTiporeg == input.IndTiporeg ||
                    (this.IndTiporeg != null &&
                    this.IndTiporeg.Equals(input.IndTiporeg))
                ) && 
                (
                    this.Rowversion == input.Rowversion ||
                    (this.Rowversion != null &&
                    this.Rowversion.Equals(input.Rowversion))
                ) && 
                (
                    this.Tipoeff == input.Tipoeff ||
                    (this.Tipoeff != null &&
                    this.Tipoeff.Equals(input.Tipoeff))
                ) && 
                (
                    this.Classification == input.Classification ||
                    (this.Classification != null &&
                    this.Classification.Equals(input.Classification))
                ) && 
                (
                    this.VatCodeReason == input.VatCodeReason ||
                    (this.VatCodeReason != null &&
                    this.VatCodeReason.Equals(input.VatCodeReason))
                ) && 
                (
                    this.VatCodeReasonConnect == input.VatCodeReasonConnect ||
                    (this.VatCodeReasonConnect != null &&
                    this.VatCodeReasonConnect.Equals(input.VatCodeReasonConnect))
                ) && 
                (
                    this.AdditionalData == input.AdditionalData ||
                    this.AdditionalData != null &&
                    input.AdditionalData != null &&
                    this.AdditionalData.SequenceEqual(input.AdditionalData)
                ) && 
                (
                    this.PluginData == input.PluginData ||
                    this.PluginData != null &&
                    input.PluginData != null &&
                    this.PluginData.SequenceEqual(input.PluginData)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.Caualias != null)
                    hashCode = hashCode * 59 + this.Caualias.GetHashCode();
                if (this.Causalecoll != null)
                    hashCode = hashCode * 59 + this.Causalecoll.GetHashCode();
                if (this.Causalecolltype != null)
                    hashCode = hashCode * 59 + this.Causalecolltype.GetHashCode();
                if (this.Causaleiva != null)
                    hashCode = hashCode * 59 + this.Causaleiva.GetHashCode();
                if (this.Codice != null)
                    hashCode = hashCode * 59 + this.Codice.GetHashCode();
                if (this.Descr != null)
                    hashCode = hashCode * 59 + this.Descr.GetHashCode();
                if (this.FlgAcconto != null)
                    hashCode = hashCode * 59 + this.FlgAcconto.GetHashCode();
                if (this.FlgAgviag != null)
                    hashCode = hashCode * 59 + this.FlgAgviag.GetHashCode();
                if (this.FlgAutofatt != null)
                    hashCode = hashCode * 59 + this.FlgAutofatt.GetHashCode();
                if (this.FlgCaufissa != null)
                    hashCode = hashCode * 59 + this.FlgCaufissa.GetHashCode();
                if (this.FlgComp != null)
                    hashCode = hashCode * 59 + this.FlgComp.GetHashCode();
                if (this.FlgDatiassegno != null)
                    hashCode = hashCode * 59 + this.FlgDatiassegno.GetHashCode();
                if (this.FlgEconto != null)
                    hashCode = hashCode * 59 + this.FlgEconto.GetHashCode();
                if (this.FlgFattdiff != null)
                    hashCode = hashCode * 59 + this.FlgFattdiff.GetHashCode();
                if (this.FlgGestsez != null)
                    hashCode = hashCode * 59 + this.FlgGestsez.GetHashCode();
                if (this.FlgInsoluti != null)
                    hashCode = hashCode * 59 + this.FlgInsoluti.GetHashCode();
                if (this.FlgIvaedit != null)
                    hashCode = hashCode * 59 + this.FlgIvaedit.GetHashCode();
                if (this.FlgPortaf != null)
                    hashCode = hashCode * 59 + this.FlgPortaf.GetHashCode();
                if (this.FlgProtsemp != null)
                    hashCode = hashCode * 59 + this.FlgProtsemp.GetHashCode();
                if (this.FlgSubforni != null)
                    hashCode = hashCode * 59 + this.FlgSubforni.GetHashCode();
                if (this.IdCg0z != null)
                    hashCode = hashCode * 59 + this.IdCg0z.GetHashCode();
                if (this.IdCgd1 != null)
                    hashCode = hashCode * 59 + this.IdCgd1.GetHashCode();
                if (this.IdmediaCg99 != null)
                    hashCode = hashCode * 59 + this.IdmediaCg99.GetHashCode();
                if (this.Idprov != null)
                    hashCode = hashCode * 59 + this.Idprov.GetHashCode();
                if (this.IndCaubenius != null)
                    hashCode = hashCode * 59 + this.IndCaubenius.GetHashCode();
                if (this.IndDaav != null)
                    hashCode = hashCode * 59 + this.IndDaav.GetHashCode();
                if (this.IndGestec != null)
                    hashCode = hashCode * 59 + this.IndGestec.GetHashCode();
                if (this.IndGestfattproforma != null)
                    hashCode = hashCode * 59 + this.IndGestfattproforma.GetHashCode();
                if (this.IndMonofasersm != null)
                    hashCode = hashCode * 59 + this.IndMonofasersm.GetHashCode();
                if (this.IndProteo360 != null)
                    hashCode = hashCode * 59 + this.IndProteo360.GetHashCode();
                if (this.IndScadfattproforma != null)
                    hashCode = hashCode * 59 + this.IndScadfattproforma.GetHashCode();
                if (this.IndTipomov != null)
                    hashCode = hashCode * 59 + this.IndTipomov.GetHashCode();
                if (this.IndTipooper != null)
                    hashCode = hashCode * 59 + this.IndTipooper.GetHashCode();
                if (this.IndTiporeg != null)
                    hashCode = hashCode * 59 + this.IndTiporeg.GetHashCode();
                if (this.Rowversion != null)
                    hashCode = hashCode * 59 + this.Rowversion.GetHashCode();
                if (this.Tipoeff != null)
                    hashCode = hashCode * 59 + this.Tipoeff.GetHashCode();
                if (this.Classification != null)
                    hashCode = hashCode * 59 + this.Classification.GetHashCode();
                if (this.VatCodeReason != null)
                    hashCode = hashCode * 59 + this.VatCodeReason.GetHashCode();
                if (this.VatCodeReasonConnect != null)
                    hashCode = hashCode * 59 + this.VatCodeReasonConnect.GetHashCode();
                if (this.AdditionalData != null)
                    hashCode = hashCode * 59 + this.AdditionalData.GetHashCode();
                if (this.PluginData != null)
                    hashCode = hashCode * 59 + this.PluginData.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
