/* 
 * TSE Cloud - CO
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.3000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using RestSharp;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace IO.Swagger.Api
{
    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
        public interface INatureAssCOApi : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// Get new
        /// </summary>
        /// <remarks>
        /// Get an empty object of type corresponding
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="param">Specify optional parameters that will be used during entity creation</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>NatureAssCODTO</returns>
        NatureAssCODTO ApiV1EnvironmentCONatureAssCOGet (string op, string param, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null);

        /// <summary>
        /// Get new
        /// </summary>
        /// <remarks>
        /// Get an empty object of type corresponding
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="param">Specify optional parameters that will be used during entity creation</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>ApiResponse of NatureAssCODTO</returns>
        ApiResponse<NatureAssCODTO> ApiV1EnvironmentCONatureAssCOGetWithHttpInfo (string op, string param, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null);
        /// <summary>
        /// Get by ID
        /// </summary>
        /// <remarks>
        /// Get an object of type corresponding the requested id
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>NatureAssCODTO</returns>
        NatureAssCODTO ApiV1EnvironmentCONatureAssCOIdGet (string id, string environment, string authorizationScope, bool? ignoreCompanyPolicyFilter = null, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null);

        /// <summary>
        /// Get by ID
        /// </summary>
        /// <remarks>
        /// Get an object of type corresponding the requested id
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>ApiResponse of NatureAssCODTO</returns>
        ApiResponse<NatureAssCODTO> ApiV1EnvironmentCONatureAssCOIdGetWithHttpInfo (string id, string environment, string authorizationScope, bool? ignoreCompanyPolicyFilter = null, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null);
        /// <summary>
        /// Validate
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns></returns>
        void ApiV1EnvironmentCONatureAssCOValidatePost (NatureAssCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null);

        /// <summary>
        /// Validate
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> ApiV1EnvironmentCONatureAssCOValidatePostWithHttpInfo (NatureAssCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null);
        /// <summary>
        /// Validation of one on more properties of Type
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ValidateDTO</returns>
        ValidateDTO ApiV1EnvironmentCONatureAssCOValidatePropertiesPost (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null);

        /// <summary>
        /// Validation of one on more properties of Type
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of ValidateDTO</returns>
        ApiResponse<ValidateDTO> ApiV1EnvironmentCONatureAssCOValidatePropertiesPostWithHttpInfo (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null);
        #endregion Synchronous Operations
        #region Asynchronous Operations
        /// <summary>
        /// Get new
        /// </summary>
        /// <remarks>
        /// Get an empty object of type corresponding
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="param">Specify optional parameters that will be used during entity creation</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>Task of NatureAssCODTO</returns>
        System.Threading.Tasks.Task<NatureAssCODTO> ApiV1EnvironmentCONatureAssCOGetAsync (string op, string param, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null);

        /// <summary>
        /// Get new
        /// </summary>
        /// <remarks>
        /// Get an empty object of type corresponding
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="param">Specify optional parameters that will be used during entity creation</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse (NatureAssCODTO)</returns>
        System.Threading.Tasks.Task<ApiResponse<NatureAssCODTO>> ApiV1EnvironmentCONatureAssCOGetAsyncWithHttpInfo (string op, string param, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null);
        /// <summary>
        /// Get by ID
        /// </summary>
        /// <remarks>
        /// Get an object of type corresponding the requested id
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>Task of NatureAssCODTO</returns>
        System.Threading.Tasks.Task<NatureAssCODTO> ApiV1EnvironmentCONatureAssCOIdGetAsync (string id, string environment, string authorizationScope, bool? ignoreCompanyPolicyFilter = null, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null);

        /// <summary>
        /// Get by ID
        /// </summary>
        /// <remarks>
        /// Get an object of type corresponding the requested id
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse (NatureAssCODTO)</returns>
        System.Threading.Tasks.Task<ApiResponse<NatureAssCODTO>> ApiV1EnvironmentCONatureAssCOIdGetAsyncWithHttpInfo (string id, string environment, string authorizationScope, bool? ignoreCompanyPolicyFilter = null, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null);
        /// <summary>
        /// Validate
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task ApiV1EnvironmentCONatureAssCOValidatePostAsync (NatureAssCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null);

        /// <summary>
        /// Validate
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentCONatureAssCOValidatePostAsyncWithHttpInfo (NatureAssCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null);
        /// <summary>
        /// Validation of one on more properties of Type
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ValidateDTO</returns>
        System.Threading.Tasks.Task<ValidateDTO> ApiV1EnvironmentCONatureAssCOValidatePropertiesPostAsync (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null);

        /// <summary>
        /// Validation of one on more properties of Type
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (ValidateDTO)</returns>
        System.Threading.Tasks.Task<ApiResponse<ValidateDTO>> ApiV1EnvironmentCONatureAssCOValidatePropertiesPostAsyncWithHttpInfo (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null);
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
        public partial class NatureAssCOApi : INatureAssCOApi
    {
        private IO.Swagger.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="NatureAssCOApi"/> class.
        /// </summary>
        /// <returns></returns>
        public NatureAssCOApi(String basePath)
        {
            this.Configuration = new IO.Swagger.Client.Configuration { BasePath = basePath };

            ExceptionFactory = IO.Swagger.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="NatureAssCOApi"/> class
        /// </summary>
        /// <returns></returns>
        public NatureAssCOApi()
        {
            this.Configuration = IO.Swagger.Client.Configuration.Default;

            ExceptionFactory = IO.Swagger.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="NatureAssCOApi"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public NatureAssCOApi(IO.Swagger.Client.Configuration configuration = null)
        {
            if (configuration == null) // use the default one in Configuration
                this.Configuration = IO.Swagger.Client.Configuration.Default;
            else
                this.Configuration = configuration;

            ExceptionFactory = IO.Swagger.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public String GetBasePath()
        {
            return this.Configuration.ApiClient.RestClient.Options.BaseUrl.ToString();
        }

        /// <summary>
        /// Sets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        [Obsolete("SetBasePath is deprecated, please do 'Configuration.ApiClient = new ApiClient(\"http://new-path\")' instead.")]
        public void SetBasePath(String basePath)
        {
            // do nothing
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public IO.Swagger.Client.Configuration Configuration {get; set;}

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public IO.Swagger.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// Gets the default header.
        /// </summary>
        /// <returns>Dictionary of HTTP header</returns>
        [Obsolete("DefaultHeader is deprecated, please use Configuration.DefaultHeader instead.")]
        public IDictionary<String, String> DefaultHeader()
        {
            return new ReadOnlyDictionary<string, string>(this.Configuration.DefaultHeader);
        }

        /// <summary>
        /// Add default header.
        /// </summary>
        /// <param name="key">Header field name.</param>
        /// <param name="value">Header field value.</param>
        /// <returns></returns>
        [Obsolete("AddDefaultHeader is deprecated, please use Configuration.AddDefaultHeader instead.")]
        public void AddDefaultHeader(string key, string value)
        {
            this.Configuration.AddDefaultHeader(key, value);
        }

        /// <summary>
        /// Get new Get an empty object of type corresponding
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="param">Specify optional parameters that will be used during entity creation</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>NatureAssCODTO</returns>
        public NatureAssCODTO ApiV1EnvironmentCONatureAssCOGet (string op, string param, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)
        {
             ApiResponse<NatureAssCODTO> localVarResponse = ApiV1EnvironmentCONatureAssCOGetWithHttpInfo(op, param, environment, authorizationScope, company, user, acceptLanguage, acceptTerritory);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Get new Get an empty object of type corresponding
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="param">Specify optional parameters that will be used during entity creation</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>ApiResponse of NatureAssCODTO</returns>
        public ApiResponse< NatureAssCODTO > ApiV1EnvironmentCONatureAssCOGetWithHttpInfo (string op, string param, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)
        {
            // verify the required parameter 'op' is set
            if (op == null)
                throw new ApiException(400, "Missing required parameter 'op' when calling NatureAssCOApi->ApiV1EnvironmentCONatureAssCOGet");
            // verify the required parameter 'param' is set
            if (param == null)
                throw new ApiException(400, "Missing required parameter 'param' when calling NatureAssCOApi->ApiV1EnvironmentCONatureAssCOGet");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling NatureAssCOApi->ApiV1EnvironmentCONatureAssCOGet");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling NatureAssCOApi->ApiV1EnvironmentCONatureAssCOGet");

            var localVarPath = "/api/v1/{environment}/CO/NatureAssCO";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (param != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "param", param)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Get, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCONatureAssCOGet", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<NatureAssCODTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (NatureAssCODTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(NatureAssCODTO)));
        }

        /// <summary>
        /// Get new Get an empty object of type corresponding
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="param">Specify optional parameters that will be used during entity creation</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>Task of NatureAssCODTO</returns>
        public async System.Threading.Tasks.Task<NatureAssCODTO> ApiV1EnvironmentCONatureAssCOGetAsync (string op, string param, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)
        {
             ApiResponse<NatureAssCODTO> localVarResponse = await ApiV1EnvironmentCONatureAssCOGetAsyncWithHttpInfo(op, param, environment, authorizationScope, company, user, acceptLanguage, acceptTerritory);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Get new Get an empty object of type corresponding
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="param">Specify optional parameters that will be used during entity creation</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse (NatureAssCODTO)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<NatureAssCODTO>> ApiV1EnvironmentCONatureAssCOGetAsyncWithHttpInfo (string op, string param, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)
        {
            // verify the required parameter 'op' is set
            if (op == null)
                throw new ApiException(400, "Missing required parameter 'op' when calling NatureAssCOApi->ApiV1EnvironmentCONatureAssCOGet");
            // verify the required parameter 'param' is set
            if (param == null)
                throw new ApiException(400, "Missing required parameter 'param' when calling NatureAssCOApi->ApiV1EnvironmentCONatureAssCOGet");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling NatureAssCOApi->ApiV1EnvironmentCONatureAssCOGet");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling NatureAssCOApi->ApiV1EnvironmentCONatureAssCOGet");

            var localVarPath = "/api/v1/{environment}/CO/NatureAssCO";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (param != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "param", param)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Get, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCONatureAssCOGet", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<NatureAssCODTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (NatureAssCODTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(NatureAssCODTO)));
        }

        /// <summary>
        /// Get by ID Get an object of type corresponding the requested id
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>NatureAssCODTO</returns>
        public NatureAssCODTO ApiV1EnvironmentCONatureAssCOIdGet (string id, string environment, string authorizationScope, bool? ignoreCompanyPolicyFilter = null, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)
        {
             ApiResponse<NatureAssCODTO> localVarResponse = ApiV1EnvironmentCONatureAssCOIdGetWithHttpInfo(id, environment, authorizationScope, ignoreCompanyPolicyFilter, dlevel, dlevelkey, company, user, acceptLanguage, acceptTerritory);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Get by ID Get an object of type corresponding the requested id
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>ApiResponse of NatureAssCODTO</returns>
        public ApiResponse< NatureAssCODTO > ApiV1EnvironmentCONatureAssCOIdGetWithHttpInfo (string id, string environment, string authorizationScope, bool? ignoreCompanyPolicyFilter = null, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)
        {
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling NatureAssCOApi->ApiV1EnvironmentCONatureAssCOIdGet");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling NatureAssCOApi->ApiV1EnvironmentCONatureAssCOIdGet");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling NatureAssCOApi->ApiV1EnvironmentCONatureAssCOIdGet");

            var localVarPath = "/api/v1/{environment}/CO/NatureAssCO/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (ignoreCompanyPolicyFilter != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "ignoreCompanyPolicyFilter", ignoreCompanyPolicyFilter)); // query parameter
            if (dlevel != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "dlevel", dlevel)); // query parameter
            if (dlevelkey != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "dlevelkey", dlevelkey)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Get, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCONatureAssCOIdGet", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<NatureAssCODTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (NatureAssCODTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(NatureAssCODTO)));
        }

        /// <summary>
        /// Get by ID Get an object of type corresponding the requested id
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>Task of NatureAssCODTO</returns>
        public async System.Threading.Tasks.Task<NatureAssCODTO> ApiV1EnvironmentCONatureAssCOIdGetAsync (string id, string environment, string authorizationScope, bool? ignoreCompanyPolicyFilter = null, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)
        {
             ApiResponse<NatureAssCODTO> localVarResponse = await ApiV1EnvironmentCONatureAssCOIdGetAsyncWithHttpInfo(id, environment, authorizationScope, ignoreCompanyPolicyFilter, dlevel, dlevelkey, company, user, acceptLanguage, acceptTerritory);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Get by ID Get an object of type corresponding the requested id
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse (NatureAssCODTO)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<NatureAssCODTO>> ApiV1EnvironmentCONatureAssCOIdGetAsyncWithHttpInfo (string id, string environment, string authorizationScope, bool? ignoreCompanyPolicyFilter = null, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)
        {
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling NatureAssCOApi->ApiV1EnvironmentCONatureAssCOIdGet");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling NatureAssCOApi->ApiV1EnvironmentCONatureAssCOIdGet");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling NatureAssCOApi->ApiV1EnvironmentCONatureAssCOIdGet");

            var localVarPath = "/api/v1/{environment}/CO/NatureAssCO/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (ignoreCompanyPolicyFilter != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "ignoreCompanyPolicyFilter", ignoreCompanyPolicyFilter)); // query parameter
            if (dlevel != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "dlevel", dlevel)); // query parameter
            if (dlevelkey != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "dlevelkey", dlevelkey)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Get, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCONatureAssCOIdGet", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<NatureAssCODTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (NatureAssCODTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(NatureAssCODTO)));
        }

        /// <summary>
        /// Validate Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns></returns>
        public void ApiV1EnvironmentCONatureAssCOValidatePost (NatureAssCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)
        {
             ApiV1EnvironmentCONatureAssCOValidatePostWithHttpInfo(body, authorizationScope, environment, acceptLanguage, acceptTerritory, company, user);
        }

        /// <summary>
        /// Validate Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public ApiResponse<Object> ApiV1EnvironmentCONatureAssCOValidatePostWithHttpInfo (NatureAssCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling NatureAssCOApi->ApiV1EnvironmentCONatureAssCOValidatePost");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling NatureAssCOApi->ApiV1EnvironmentCONatureAssCOValidatePost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling NatureAssCOApi->ApiV1EnvironmentCONatureAssCOValidatePost");

            var localVarPath = "/api/v1/{environment}/CO/NatureAssCO/validate";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCONatureAssCOValidatePost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Validate Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task ApiV1EnvironmentCONatureAssCOValidatePostAsync (NatureAssCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)
        {
             await ApiV1EnvironmentCONatureAssCOValidatePostAsyncWithHttpInfo(body, authorizationScope, environment, acceptLanguage, acceptTerritory, company, user);

        }

        /// <summary>
        /// Validate Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentCONatureAssCOValidatePostAsyncWithHttpInfo (NatureAssCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling NatureAssCOApi->ApiV1EnvironmentCONatureAssCOValidatePost");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling NatureAssCOApi->ApiV1EnvironmentCONatureAssCOValidatePost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling NatureAssCOApi->ApiV1EnvironmentCONatureAssCOValidatePost");

            var localVarPath = "/api/v1/{environment}/CO/NatureAssCO/validate";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCONatureAssCOValidatePost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Validation of one on more properties of Type Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ValidateDTO</returns>
        public ValidateDTO ApiV1EnvironmentCONatureAssCOValidatePropertiesPost (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)
        {
             ApiResponse<ValidateDTO> localVarResponse = ApiV1EnvironmentCONatureAssCOValidatePropertiesPostWithHttpInfo(authorizationScope, environment, body, acceptLanguage, acceptTerritory, company, user);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Validation of one on more properties of Type Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of ValidateDTO</returns>
        public ApiResponse< ValidateDTO > ApiV1EnvironmentCONatureAssCOValidatePropertiesPostWithHttpInfo (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)
        {
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling NatureAssCOApi->ApiV1EnvironmentCONatureAssCOValidatePropertiesPost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling NatureAssCOApi->ApiV1EnvironmentCONatureAssCOValidatePropertiesPost");

            var localVarPath = "/api/v1/{environment}/CO/NatureAssCO/validateProperties";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCONatureAssCOValidatePropertiesPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<ValidateDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (ValidateDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(ValidateDTO)));
        }

        /// <summary>
        /// Validation of one on more properties of Type Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ValidateDTO</returns>
        public async System.Threading.Tasks.Task<ValidateDTO> ApiV1EnvironmentCONatureAssCOValidatePropertiesPostAsync (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)
        {
             ApiResponse<ValidateDTO> localVarResponse = await ApiV1EnvironmentCONatureAssCOValidatePropertiesPostAsyncWithHttpInfo(authorizationScope, environment, body, acceptLanguage, acceptTerritory, company, user);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Validation of one on more properties of Type Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (ValidateDTO)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<ValidateDTO>> ApiV1EnvironmentCONatureAssCOValidatePropertiesPostAsyncWithHttpInfo (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)
        {
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling NatureAssCOApi->ApiV1EnvironmentCONatureAssCOValidatePropertiesPost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling NatureAssCOApi->ApiV1EnvironmentCONatureAssCOValidatePropertiesPost");

            var localVarPath = "/api/v1/{environment}/CO/NatureAssCO/validateProperties";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCONatureAssCOValidatePropertiesPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<ValidateDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (ValidateDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(ValidateDTO)));
        }

    }
}
