# IO.Swagger.Api.BankCOApi

All URIs are relative to *https://apicsdemo.teamsystem.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**ApiV1EnvironmentCOBankCOGet**](BankCOApi.md#apiv1environmentcobankcoget) | **GET** /api/v1/{environment}/CO/BankCO | Get new
[**ApiV1EnvironmentCOBankCOIdDelete**](BankCOApi.md#apiv1environmentcobankcoiddelete) | **DELETE** /api/v1/{environment}/CO/BankCO/{id} | Delete
[**ApiV1EnvironmentCOBankCOIdGet**](BankCOApi.md#apiv1environmentcobankcoidget) | **GET** /api/v1/{environment}/CO/BankCO/{id} | Get by ID
[**ApiV1EnvironmentCOBankCOIdPatch**](BankCOApi.md#apiv1environmentcobankcoidpatch) | **PATCH** /api/v1/{environment}/CO/BankCO/{id} | Update partial
[**ApiV1EnvironmentCOBankCOIdPut**](BankCOApi.md#apiv1environmentcobankcoidput) | **PUT** /api/v1/{environment}/CO/BankCO/{id} | Update
[**ApiV1EnvironmentCOBankCOPost**](BankCOApi.md#apiv1environmentcobankcopost) | **POST** /api/v1/{environment}/CO/BankCO | Create
[**ApiV1EnvironmentCOBankCOValidatePost**](BankCOApi.md#apiv1environmentcobankcovalidatepost) | **POST** /api/v1/{environment}/CO/BankCO/validate | Validate
[**ApiV1EnvironmentCOBankCOValidatePropertiesPost**](BankCOApi.md#apiv1environmentcobankcovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/BankCO/validateProperties | Validation of one on more properties of Type

<a name="apiv1environmentcobankcoget"></a>
# **ApiV1EnvironmentCOBankCOGet**
> BankCODTO ApiV1EnvironmentCOBankCOGet (string op, string param, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)

Get new

Get an empty object of type corresponding

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOBankCOGetExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new BankCOApi();
            var op = op_example;  // string | The value must be 'new'
            var param = param_example;  // string | Specify optional parameters that will be used during entity creation
            var environment = environment_example;  // string | 
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)

            try
            {
                // Get new
                BankCODTO result = apiInstance.ApiV1EnvironmentCOBankCOGet(op, param, environment, authorizationScope, company, user, acceptLanguage, acceptTerritory);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling BankCOApi.ApiV1EnvironmentCOBankCOGet: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **op** | **string**| The value must be &#x27;new&#x27; | 
 **param** | **string**| Specify optional parameters that will be used during entity creation | 
 **environment** | **string**|  | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]

### Return type

[**BankCODTO**](BankCODTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcobankcoiddelete"></a>
# **ApiV1EnvironmentCOBankCOIdDelete**
> void ApiV1EnvironmentCOBankCOIdDelete (string id, string environment, string authorizationScope, string force = null, bool? ignoreCompanyPolicyFilter = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)

Delete

Deleting object of type 

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOBankCOIdDeleteExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new BankCOApi();
            var id = id_example;  // string | 
            var environment = environment_example;  // string | 
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var force = force_example;  // string | The warning/s code to bypass (separated by ‘,’) during the execution (optional) 
            var ignoreCompanyPolicyFilter = true;  // bool? | Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)

            try
            {
                // Delete
                apiInstance.ApiV1EnvironmentCOBankCOIdDelete(id, environment, authorizationScope, force, ignoreCompanyPolicyFilter, company, user, acceptLanguage, acceptTerritory);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling BankCOApi.ApiV1EnvironmentCOBankCOIdDelete: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**|  | 
 **environment** | **string**|  | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **force** | **string**| The warning/s code to bypass (separated by ‘,’) during the execution | [optional] 
 **ignoreCompanyPolicyFilter** | **bool?**| Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]

### Return type

void (empty response body)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcobankcoidget"></a>
# **ApiV1EnvironmentCOBankCOIdGet**
> BankCODTO ApiV1EnvironmentCOBankCOIdGet (string id, string environment, string authorizationScope, bool? ignoreCompanyPolicyFilter = null, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)

Get by ID

Get an object of type corresponding the requested id

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOBankCOIdGetExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new BankCOApi();
            var id = id_example;  // string | Id to get the object
            var environment = environment_example;  // string | 
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var ignoreCompanyPolicyFilter = true;  // bool? | Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional) 
            var dlevel = dlevel_example;  // string | Serialization level (optional) 
            var dlevelkey = dlevelkey_example;  // string | Serialization level key (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)

            try
            {
                // Get by ID
                BankCODTO result = apiInstance.ApiV1EnvironmentCOBankCOIdGet(id, environment, authorizationScope, ignoreCompanyPolicyFilter, dlevel, dlevelkey, company, user, acceptLanguage, acceptTerritory);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling BankCOApi.ApiV1EnvironmentCOBankCOIdGet: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**| Id to get the object | 
 **environment** | **string**|  | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **ignoreCompanyPolicyFilter** | **bool?**| Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter | [optional] 
 **dlevel** | **string**| Serialization level | [optional] 
 **dlevelkey** | **string**| Serialization level key | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]

### Return type

[**BankCODTO**](BankCODTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcobankcoidpatch"></a>
# **ApiV1EnvironmentCOBankCOIdPatch**
> void ApiV1EnvironmentCOBankCOIdPatch (Object body, string authorizationScope, string id, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? ignoreCompanyPolicyFilter = null, string force = null, string op = null, string company = null, string user = null)

Update partial

Patching an object of type

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOBankCOIdPatchExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new BankCOApi();
            var body = new Object(); // Object | Object of type to patch
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var id = id_example;  // string | 
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)
            var ignoreCompanyPolicyFilter = true;  // bool? | Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional) 
            var force = force_example;  // string | The warning/s code to bypass (separated by ‘,’) during the execution (optional) 
            var op = op_example;  // string | Set 'reload', if you want the DTO updated in the response request (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Update partial
                apiInstance.ApiV1EnvironmentCOBankCOIdPatch(body, authorizationScope, id, environment, acceptLanguage, acceptTerritory, ignoreCompanyPolicyFilter, force, op, company, user);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling BankCOApi.ApiV1EnvironmentCOBankCOIdPatch: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**Object**](Object.md)| Object of type to patch | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **id** | **string**|  | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]
 **ignoreCompanyPolicyFilter** | **bool?**| Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter | [optional] 
 **force** | **string**| The warning/s code to bypass (separated by ‘,’) during the execution | [optional] 
 **op** | **string**| Set &#x27;reload&#x27;, if you want the DTO updated in the response request | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

void (empty response body)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcobankcoidput"></a>
# **ApiV1EnvironmentCOBankCOIdPut**
> BankCODTO ApiV1EnvironmentCOBankCOIdPut (BankCODTO body, string authorizationScope, string id, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, bool? ignoreCompanyPolicyFilter = null, string op = null, string company = null, string user = null)

Update

Updating an object of type

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOBankCOIdPutExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new BankCOApi();
            var body = new BankCODTO(); // BankCODTO | Object of type to update
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var id = id_example;  // string | 
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)
            var force = force_example;  // string | The warning/s code to bypass (separated by ‘,’) during the execution (optional) 
            var ignoreCompanyPolicyFilter = true;  // bool? | Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional) 
            var op = op_example;  // string | Set 'reload', if you want the DTO updated in the response request (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Update
                BankCODTO result = apiInstance.ApiV1EnvironmentCOBankCOIdPut(body, authorizationScope, id, environment, acceptLanguage, acceptTerritory, force, ignoreCompanyPolicyFilter, op, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling BankCOApi.ApiV1EnvironmentCOBankCOIdPut: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**BankCODTO**](BankCODTO.md)| Object of type to update | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **id** | **string**|  | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]
 **force** | **string**| The warning/s code to bypass (separated by ‘,’) during the execution | [optional] 
 **ignoreCompanyPolicyFilter** | **bool?**| Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter | [optional] 
 **op** | **string**| Set &#x27;reload&#x27;, if you want the DTO updated in the response request | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**BankCODTO**](BankCODTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcobankcopost"></a>
# **ApiV1EnvironmentCOBankCOPost**
> BankCODTO ApiV1EnvironmentCOBankCOPost (BankCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? ignoreCompanyPolicyFilter = null, string op = null, string force = null, string company = null, string user = null)

Create

Creating new object of type

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOBankCOPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new BankCOApi();
            var body = new BankCODTO(); // BankCODTO | Object of type to create
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)
            var ignoreCompanyPolicyFilter = true;  // bool? | Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional) 
            var op = op_example;  // string | Set 'reload', if you want the DTO updated in the response request (optional) 
            var force = force_example;  // string | The warning/s code to bypass (separated by ‘,’) during the execution (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Create
                BankCODTO result = apiInstance.ApiV1EnvironmentCOBankCOPost(body, authorizationScope, environment, acceptLanguage, acceptTerritory, ignoreCompanyPolicyFilter, op, force, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling BankCOApi.ApiV1EnvironmentCOBankCOPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**BankCODTO**](BankCODTO.md)| Object of type to create | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]
 **ignoreCompanyPolicyFilter** | **bool?**| Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter | [optional] 
 **op** | **string**| Set &#x27;reload&#x27;, if you want the DTO updated in the response request | [optional] 
 **force** | **string**| The warning/s code to bypass (separated by ‘,’) during the execution | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**BankCODTO**](BankCODTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcobankcovalidatepost"></a>
# **ApiV1EnvironmentCOBankCOValidatePost**
> void ApiV1EnvironmentCOBankCOValidatePost (BankCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)

Validate

Validation of object of type

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOBankCOValidatePostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new BankCOApi();
            var body = new BankCODTO(); // BankCODTO | Object of type to validate
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Validate
                apiInstance.ApiV1EnvironmentCOBankCOValidatePost(body, authorizationScope, environment, acceptLanguage, acceptTerritory, company, user);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling BankCOApi.ApiV1EnvironmentCOBankCOValidatePost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**BankCODTO**](BankCODTO.md)| Object of type to validate | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

void (empty response body)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcobankcovalidatepropertiespost"></a>
# **ApiV1EnvironmentCOBankCOValidatePropertiesPost**
> ValidateDTO ApiV1EnvironmentCOBankCOValidatePropertiesPost (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)

Validation of one on more properties of Type

Validation of object of type

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOBankCOValidatePropertiesPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new BankCOApi();
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var body = new string(); // string |  - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED<br> - The id of an existing object to validate properties, or '' if the object does not exist yet <br> (optional) 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Validation of one on more properties of Type
                ValidateDTO result = apiInstance.ApiV1EnvironmentCOBankCOValidatePropertiesPost(authorizationScope, environment, body, acceptLanguage, acceptTerritory, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling BankCOApi.ApiV1EnvironmentCOBankCOValidatePropertiesPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **body** | [**string**](string.md)|  - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; | [optional] 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**ValidateDTO**](ValidateDTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
