/* 
 * TSE Cloud - CO
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.1000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// DTO that contains the filter criteria
    /// </summary>
    [DataContract]
        public partial class SearchDTO :  IEquatable<SearchDTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="SearchDTO" /> class.
        /// </summary>
        /// <param name="filters">filters.</param>
        /// <param name="parameters">List of key value filters that will be applied to the query (example: {&#x27;param1&#x27;: Value}\&quot;).</param>
        /// <param name="orderingProperties">\&quot;Order by\&quot; properties list.</param>
        /// <param name="pageSize">Page number to retun.</param>
        /// <param name="pageNumber">Number of elements per page to return.</param>
        /// <param name="selectList">selectList.</param>
        /// <param name="visibleColumns">visibleColumns.</param>
        /// <param name="idRow">idRow.</param>
        public SearchDTO(SearchGroupDTO filters = default(SearchGroupDTO), Dictionary<string, Object> parameters = default(Dictionary<string, Object>), Dictionary<string, Object> orderingProperties = default(Dictionary<string, Object>), int? pageSize = default(int?), int? pageNumber = default(int?), string selectList = default(string), string visibleColumns = default(string), string idRow = default(string))
        {
            this.Filters = filters;
            this.Parameters = parameters;
            this.OrderingProperties = orderingProperties;
            this.PageSize = pageSize;
            this.PageNumber = pageNumber;
            this.SelectList = selectList;
            this.VisibleColumns = visibleColumns;
            this.IdRow = idRow;
        }
        
        /// <summary>
        /// Gets or Sets Filters
        /// </summary>
        [DataMember(Name="filters", EmitDefaultValue=false)]
        public SearchGroupDTO Filters { get; set; }

        /// <summary>
        /// List of key value filters that will be applied to the query (example: {&#x27;param1&#x27;: Value}\&quot;)
        /// </summary>
        /// <value>List of key value filters that will be applied to the query (example: {&#x27;param1&#x27;: Value}\&quot;)</value>
        [DataMember(Name="parameters", EmitDefaultValue=false)]
        public Dictionary<string, Object> Parameters { get; set; }

        /// <summary>
        /// \&quot;Order by\&quot; properties list
        /// </summary>
        /// <value>\&quot;Order by\&quot; properties list</value>
        [DataMember(Name="orderingProperties", EmitDefaultValue=false)]
        public Dictionary<string, Object> OrderingProperties { get; set; }

        /// <summary>
        /// Page number to retun
        /// </summary>
        /// <value>Page number to retun</value>
        [DataMember(Name="pageSize", EmitDefaultValue=false)]
        public int? PageSize { get; set; }

        /// <summary>
        /// Number of elements per page to return
        /// </summary>
        /// <value>Number of elements per page to return</value>
        [DataMember(Name="pageNumber", EmitDefaultValue=false)]
        public int? PageNumber { get; set; }

        /// <summary>
        /// Gets or Sets SelectList
        /// </summary>
        [DataMember(Name="selectList", EmitDefaultValue=false)]
        public string SelectList { get; set; }

        /// <summary>
        /// Gets or Sets VisibleColumns
        /// </summary>
        [DataMember(Name="visibleColumns", EmitDefaultValue=false)]
        public string VisibleColumns { get; set; }

        /// <summary>
        /// Gets or Sets IdRow
        /// </summary>
        [DataMember(Name="idRow", EmitDefaultValue=false)]
        public string IdRow { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class SearchDTO {\n");
            sb.Append("  Filters: ").Append(Filters).Append("\n");
            sb.Append("  Parameters: ").Append(Parameters).Append("\n");
            sb.Append("  OrderingProperties: ").Append(OrderingProperties).Append("\n");
            sb.Append("  PageSize: ").Append(PageSize).Append("\n");
            sb.Append("  PageNumber: ").Append(PageNumber).Append("\n");
            sb.Append("  SelectList: ").Append(SelectList).Append("\n");
            sb.Append("  VisibleColumns: ").Append(VisibleColumns).Append("\n");
            sb.Append("  IdRow: ").Append(IdRow).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as SearchDTO);
        }

        /// <summary>
        /// Returns true if SearchDTO instances are equal
        /// </summary>
        /// <param name="input">Instance of SearchDTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(SearchDTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.Filters == input.Filters ||
                    (this.Filters != null &&
                    this.Filters.Equals(input.Filters))
                ) && 
                (
                    this.Parameters == input.Parameters ||
                    this.Parameters != null &&
                    input.Parameters != null &&
                    this.Parameters.SequenceEqual(input.Parameters)
                ) && 
                (
                    this.OrderingProperties == input.OrderingProperties ||
                    this.OrderingProperties != null &&
                    input.OrderingProperties != null &&
                    this.OrderingProperties.SequenceEqual(input.OrderingProperties)
                ) && 
                (
                    this.PageSize == input.PageSize ||
                    (this.PageSize != null &&
                    this.PageSize.Equals(input.PageSize))
                ) && 
                (
                    this.PageNumber == input.PageNumber ||
                    (this.PageNumber != null &&
                    this.PageNumber.Equals(input.PageNumber))
                ) && 
                (
                    this.SelectList == input.SelectList ||
                    (this.SelectList != null &&
                    this.SelectList.Equals(input.SelectList))
                ) && 
                (
                    this.VisibleColumns == input.VisibleColumns ||
                    (this.VisibleColumns != null &&
                    this.VisibleColumns.Equals(input.VisibleColumns))
                ) && 
                (
                    this.IdRow == input.IdRow ||
                    (this.IdRow != null &&
                    this.IdRow.Equals(input.IdRow))
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.Filters != null)
                    hashCode = hashCode * 59 + this.Filters.GetHashCode();
                if (this.Parameters != null)
                    hashCode = hashCode * 59 + this.Parameters.GetHashCode();
                if (this.OrderingProperties != null)
                    hashCode = hashCode * 59 + this.OrderingProperties.GetHashCode();
                if (this.PageSize != null)
                    hashCode = hashCode * 59 + this.PageSize.GetHashCode();
                if (this.PageNumber != null)
                    hashCode = hashCode * 59 + this.PageNumber.GetHashCode();
                if (this.SelectList != null)
                    hashCode = hashCode * 59 + this.SelectList.GetHashCode();
                if (this.VisibleColumns != null)
                    hashCode = hashCode * 59 + this.VisibleColumns.GetHashCode();
                if (this.IdRow != null)
                    hashCode = hashCode * 59 + this.IdRow.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
