/* 
 * TSE Cloud - CO
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.1000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// MG10_MACROCAT - Macrocategoria cli/for&lt;br&gt;Proprietà chiave:&lt;ul&gt;&lt;li&gt;&lt;b&gt;DittaCg18&lt;/b&gt;&lt;/li&gt;&lt;li&gt;&lt;b&gt;Macrocat&lt;/b&gt;&lt;/li&gt;&lt;li&gt;&lt;b&gt;Tipocf&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;
    /// </summary>
    [DataContract]
        public partial class MacroCategoryCODTO :  IEquatable<MacroCategoryCODTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="MacroCategoryCODTO" /> class.
        /// </summary>
        /// <param name="descrmacrocat">MG10_DESCRMACROCAT - Descrizione.</param>
        /// <param name="dittaCg18">MG10_DITTA_CG18 - Ditta (default to 0).</param>
        /// <param name="macrocat">MG10_MACROCAT - Macrocategoria (required).</param>
        /// <param name="tipocf">MG10_TIPOCF - Tipo Cli/For&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; -  Cliente&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; -  Fornitore&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="categorie">categorie.</param>
        /// <param name="extensionData">extensionData.</param>
        /// <param name="additionalData">additionalData.</param>
        /// <param name="pluginData">pluginData.</param>
        public MacroCategoryCODTO(string descrmacrocat = default(string), double? dittaCg18 = 0, string macrocat = default(string), double? tipocf = 0, List<CategoryCODTO> categorie = default(List<CategoryCODTO>), List<StringObjectKeyValuePair> extensionData = default(List<StringObjectKeyValuePair>), Dictionary<string, Object> additionalData = default(Dictionary<string, Object>), Dictionary<string, Object> pluginData = default(Dictionary<string, Object>))
        {
            // to ensure "macrocat" is required (not null)
            if (macrocat == null)
            {
                throw new InvalidDataException("macrocat is a required property for MacroCategoryCODTO and cannot be null");
            }
            else
            {
                this.Macrocat = macrocat;
            }
            this.Descrmacrocat = descrmacrocat;
            // use default value if no "dittaCg18" provided
            if (dittaCg18 == null)
            {
                this.DittaCg18 = 0;
            }
            else
            {
                this.DittaCg18 = dittaCg18;
            }
            // use default value if no "tipocf" provided
            if (tipocf == null)
            {
                this.Tipocf = 0;
            }
            else
            {
                this.Tipocf = tipocf;
            }
            this.Categorie = categorie;
            this.ExtensionData = extensionData;
            this.AdditionalData = additionalData;
            this.PluginData = pluginData;
        }
        
        /// <summary>
        /// MG10_DESCRMACROCAT - Descrizione
        /// </summary>
        /// <value>MG10_DESCRMACROCAT - Descrizione</value>
        [DataMember(Name="descrmacrocat", EmitDefaultValue=false)]
        public string Descrmacrocat { get; set; }

        /// <summary>
        /// MG10_DITTA_CG18 - Ditta
        /// </summary>
        /// <value>MG10_DITTA_CG18 - Ditta</value>
        [DataMember(Name="dittaCg18", EmitDefaultValue=false)]
        public double? DittaCg18 { get; set; }

        /// <summary>
        /// MG10_MACROCAT - Macrocategoria
        /// </summary>
        /// <value>MG10_MACROCAT - Macrocategoria</value>
        [DataMember(Name="macrocat", EmitDefaultValue=false)]
        public string Macrocat { get; set; }

        /// <summary>
        /// MG10_TIPOCF - Tipo Cli/For&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; -  Cliente&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; -  Fornitore&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG10_TIPOCF - Tipo Cli/For&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; -  Cliente&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; -  Fornitore&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="tipocf", EmitDefaultValue=false)]
        public double? Tipocf { get; set; }

        /// <summary>
        /// Gets or Sets Categorie
        /// </summary>
        [DataMember(Name="categorie", EmitDefaultValue=false)]
        public List<CategoryCODTO> Categorie { get; set; }

        /// <summary>
        /// Gets or Sets ExtensionData
        /// </summary>
        [DataMember(Name="extensionData", EmitDefaultValue=false)]
        public List<StringObjectKeyValuePair> ExtensionData { get; set; }

        /// <summary>
        /// Gets or Sets AdditionalData
        /// </summary>
        [DataMember(Name="additionalData", EmitDefaultValue=false)]
        public Dictionary<string, Object> AdditionalData { get; set; }

        /// <summary>
        /// Gets or Sets PluginData
        /// </summary>
        [DataMember(Name="pluginData", EmitDefaultValue=false)]
        public Dictionary<string, Object> PluginData { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class MacroCategoryCODTO {\n");
            sb.Append("  Descrmacrocat: ").Append(Descrmacrocat).Append("\n");
            sb.Append("  DittaCg18: ").Append(DittaCg18).Append("\n");
            sb.Append("  Macrocat: ").Append(Macrocat).Append("\n");
            sb.Append("  Tipocf: ").Append(Tipocf).Append("\n");
            sb.Append("  Categorie: ").Append(Categorie).Append("\n");
            sb.Append("  ExtensionData: ").Append(ExtensionData).Append("\n");
            sb.Append("  AdditionalData: ").Append(AdditionalData).Append("\n");
            sb.Append("  PluginData: ").Append(PluginData).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as MacroCategoryCODTO);
        }

        /// <summary>
        /// Returns true if MacroCategoryCODTO instances are equal
        /// </summary>
        /// <param name="input">Instance of MacroCategoryCODTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(MacroCategoryCODTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.Descrmacrocat == input.Descrmacrocat ||
                    (this.Descrmacrocat != null &&
                    this.Descrmacrocat.Equals(input.Descrmacrocat))
                ) && 
                (
                    this.DittaCg18 == input.DittaCg18 ||
                    (this.DittaCg18 != null &&
                    this.DittaCg18.Equals(input.DittaCg18))
                ) && 
                (
                    this.Macrocat == input.Macrocat ||
                    (this.Macrocat != null &&
                    this.Macrocat.Equals(input.Macrocat))
                ) && 
                (
                    this.Tipocf == input.Tipocf ||
                    (this.Tipocf != null &&
                    this.Tipocf.Equals(input.Tipocf))
                ) && 
                (
                    this.Categorie == input.Categorie ||
                    this.Categorie != null &&
                    input.Categorie != null &&
                    this.Categorie.SequenceEqual(input.Categorie)
                ) && 
                (
                    this.ExtensionData == input.ExtensionData ||
                    this.ExtensionData != null &&
                    input.ExtensionData != null &&
                    this.ExtensionData.SequenceEqual(input.ExtensionData)
                ) && 
                (
                    this.AdditionalData == input.AdditionalData ||
                    this.AdditionalData != null &&
                    input.AdditionalData != null &&
                    this.AdditionalData.SequenceEqual(input.AdditionalData)
                ) && 
                (
                    this.PluginData == input.PluginData ||
                    this.PluginData != null &&
                    input.PluginData != null &&
                    this.PluginData.SequenceEqual(input.PluginData)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.Descrmacrocat != null)
                    hashCode = hashCode * 59 + this.Descrmacrocat.GetHashCode();
                if (this.DittaCg18 != null)
                    hashCode = hashCode * 59 + this.DittaCg18.GetHashCode();
                if (this.Macrocat != null)
                    hashCode = hashCode * 59 + this.Macrocat.GetHashCode();
                if (this.Tipocf != null)
                    hashCode = hashCode * 59 + this.Tipocf.GetHashCode();
                if (this.Categorie != null)
                    hashCode = hashCode * 59 + this.Categorie.GetHashCode();
                if (this.ExtensionData != null)
                    hashCode = hashCode * 59 + this.ExtensionData.GetHashCode();
                if (this.AdditionalData != null)
                    hashCode = hashCode * 59 + this.AdditionalData.GetHashCode();
                if (this.PluginData != null)
                    hashCode = hashCode * 59 + this.PluginData.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
