/* 
 * TSE Cloud - CO
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.1000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// MG29_CLIFORRID - Dati RID&lt;br&gt;Proprietà chiave:&lt;ul&gt;&lt;li&gt;&lt;b&gt;Id&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;
    /// </summary>
    [DataContract]
        public partial class CSSddCODTO :  IEquatable<CSSddCODTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="CSSddCODTO" /> class.
        /// </summary>
        /// <param name="bancaallineam">MG29_BANCAALLINEAM - Codice ABI Banca Allineamento.</param>
        /// <param name="causrich">MG29_CAUSRICH - Causale richiesta Azienda.</param>
        /// <param name="causrisp">MG29_CAUSRISP - Causale Banca Allineamento.</param>
        /// <param name="cfiscsottoscr">MG29_CFISCSOTTOSCR - Codice fiscale sottoscrittore.</param>
        /// <param name="cliforCg44">MG29_CLIFOR_CG44 - Codice Cliente / Fornitore (required).</param>
        /// <param name="codAutoriz">MG29_CODAUTORIZ - Codice autorizzazione (Acquisizione PagoBancomat).</param>
        /// <param name="codBicswift">MG29_CODBICSWIFT - Codice BIC SWIFT.</param>
        /// <param name="codClideb">MG29_CODCLIDEB - Codice debitore.</param>
        /// <param name="codClidebprec">MG29_CODCLIDEBPREC - Codice debitore precedente.</param>
        /// <param name="codIndiv">MG29_CODINDIV - Codice individuale&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuno&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Utenza&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Matricola&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Codice fiscale&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Codice cliente&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Codice fornitore&lt;/li&gt;&lt;li&gt;&lt;i&gt;6&lt;/i&gt; - Portafoglio commerciale&lt;/li&gt;&lt;li&gt;&lt;i&gt;9&lt;/i&gt; - Altro&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="codIndivprec">MG29_CODINDIVPREC - Codice individuale precedente.</param>
        /// <param name="codRif">MG29_CODRIF - Codice riferimento.</param>
        /// <param name="contocorr">MG29_CONTOCORR - Conto corrente.</param>
        /// <param name="contocorrprec">MG29_CONTOCORRPREC - Conto corrente precedente.</param>
        /// <param name="datamandato">MG29_DATAMANDATO - Data mandato RID.</param>
        /// <param name="dataprimascad">MG29_DATAPRIMASCAD - Data prima scadenza.</param>
        /// <param name="datarich">MG29_DATARICH - Data richiesta.</param>
        /// <param name="datarisp">MG29_DATARISP - Data causale Banca Allineamento.</param>
        /// <param name="dataultimascad">MG29_DATAULTIMASCAD - Data ultima scadenza.</param>
        /// <param name="descrizione">MG29_DESCRIZIONE - Descrizione.</param>
        /// <param name="diniego">MG29_DINIEGO - Diniego.</param>
        /// <param name="dittaCg18">MG29_DITTA_CG18 - Ditta (required).</param>
        /// <param name="flgAllineam">MG29_FLGALLINEAM - Allineamento SEDA non gestito.</param>
        /// <param name="flgDisattivato">MG29_FLGDISATTIVATO - Dati disattivati.</param>
        /// <param name="flgVariato">MG29_FLGVARIATO - Variato (required).</param>
        /// <param name="id">MG29_ID - ID (Required only in PUT/PATCH).</param>
        /// <param name="idmediaCg99">MG29_IDMEDIA_CG99 - ID HyperMedia.</param>
        /// <param name="impmaxrata">MG29_IMPMAXRATA - Importo massimo/prefissato.</param>
        /// <param name="indIrsottoscr">MG29_INDIRSOTTOSCR - Indirizzo sottoscrittore.</param>
        /// <param name="indStorno">MG29_INDSTORNO - Facoltà di storno&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuno&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Facoltà di storno dopo la scadenza (D+5)&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Facoltà di storno alla scadenza&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Nessuna facoltà di storno per contestazione&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Nessuna facoltà di storno per la banca domiciliataria&lt;/li&gt;&lt;li&gt;&lt;i&gt;8&lt;/i&gt; - Esiste diritto al rimborso (D+8 settimane)&lt;/li&gt;&lt;li&gt;&lt;i&gt;9&lt;/i&gt; - Nessuna facoltà di storno per le caratteristiche del mandato&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="indStornoprec">MG29_INDSTORNOPREC - Facoltà di storno precedente.</param>
        /// <param name="indTipoinc">MG29_INDTIPOINC - Sequenza&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - First&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Recurrent&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Final&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - One-Off&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="indTiposdd">MG29_INDTIPOSDD - Tipo SDD&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Core&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - B2B&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="locsottoscr">MG29_LOCSOTTOSCR - Località sottoscrittore.</param>
        /// <param name="nrrate">MG29_NRRATE - Numero rate.</param>
        /// <param name="nuovabanca">MG29_NUOVABANCA - Nuovabanca.</param>
        /// <param name="progR">MG29_PROGR - Progr. (required).</param>
        /// <param name="ragsosottoscr">MG29_RAGSOSOTTOSCR - Ragione sociale sottoscrittore.</param>
        /// <param name="ridabi">MG29_RIDABI - Codice ABI.</param>
        /// <param name="ridabiprec">MG29_RIDABIPREC - Codice ABI precedente.</param>
        /// <param name="ridcab">MG29_RIDCAB - Codice CAB.</param>
        /// <param name="ridcabprec">MG29_RIDCABPREC - Codice CAB precedente.</param>
        /// <param name="ridiban">MG29_RIDIBAN - IBAN.</param>
        /// <param name="ridibanprec">MG29_RIDIBANPREC - IBAN (International Bank Account Number).</param>
        /// <param name="soggtitibanCg16">MG29_SOGGTITIBAN_CG16 - Soggetto titolare IBAN.</param>
        /// <param name="tipocfCg44">MG29_TIPOCF_CG44 - Tipo Cliente / Fornitore (required).</param>
        /// <param name="tipoinclocked">MG29_TIPOINCLOCKED - Tipo seq. incasso bloccato.</param>
        /// <param name="tipologia">MG29_TIPOLOGIA - Tipologia&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Consumatore&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Non Consumatore&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Microimpresa&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="tipologiaprec">MG29_TIPOLOGIAPREC - Tipologiaprec.</param>
        /// <param name="csHistorySddCO">csHistorySddCO.</param>
        /// <param name="nationCO">nationCO.</param>
        /// <param name="soggtitiban">soggtitiban.</param>
        /// <param name="extensionData">extensionData.</param>
        /// <param name="additionalData">additionalData.</param>
        /// <param name="pluginData">pluginData.</param>
        public CSSddCODTO(double? bancaallineam = default(double?), double? causrich = default(double?), double? causrisp = default(double?), string cfiscsottoscr = default(string), double? cliforCg44 = default(double?), string codAutoriz = default(string), string codBicswift = default(string), string codClideb = default(string), string codClidebprec = default(string), double? codIndiv = default(double?), double? codIndivprec = default(double?), string codRif = default(string), string contocorr = default(string), string contocorrprec = default(string), DateTime? datamandato = default(DateTime?), DateTime? dataprimascad = default(DateTime?), DateTime? datarich = default(DateTime?), DateTime? datarisp = default(DateTime?), DateTime? dataultimascad = default(DateTime?), string descrizione = default(string), int? diniego = default(int?), double? dittaCg18 = default(double?), double? flgAllineam = default(double?), int? flgDisattivato = default(int?), double? flgVariato = default(double?), int? id = default(int?), double? idmediaCg99 = default(double?), double? impmaxrata = default(double?), string indIrsottoscr = default(string), double? indStorno = default(double?), double? indStornoprec = default(double?), int? indTipoinc = default(int?), double? indTiposdd = default(double?), string locsottoscr = default(string), double? nrrate = default(double?), double? nuovabanca = default(double?), int? progR = default(int?), string ragsosottoscr = default(string), double? ridabi = default(double?), double? ridabiprec = default(double?), double? ridcab = default(double?), double? ridcabprec = default(double?), string ridiban = default(string), string ridibanprec = default(string), int? soggtitibanCg16 = default(int?), double? tipocfCg44 = default(double?), double? tipoinclocked = default(double?), double? tipologia = default(double?), double? tipologiaprec = default(double?), List<CSHistorySddCODTO> csHistorySddCO = default(List<CSHistorySddCODTO>), NationCODTO nationCO = default(NationCODTO), GeneralMasterDataCODTO soggtitiban = default(GeneralMasterDataCODTO), List<StringObjectKeyValuePair> extensionData = default(List<StringObjectKeyValuePair>), Dictionary<string, Object> additionalData = default(Dictionary<string, Object>), Dictionary<string, Object> pluginData = default(Dictionary<string, Object>))
        {
            // to ensure "cliforCg44" is required (not null)
            if (cliforCg44 == null)
            {
                throw new InvalidDataException("cliforCg44 is a required property for CSSddCODTO and cannot be null");
            }
            else
            {
                this.CliforCg44 = cliforCg44;
            }
            // to ensure "dittaCg18" is required (not null)
            if (dittaCg18 == null)
            {
                throw new InvalidDataException("dittaCg18 is a required property for CSSddCODTO and cannot be null");
            }
            else
            {
                this.DittaCg18 = dittaCg18;
            }
            // to ensure "flgVariato" is required (not null)
            if (flgVariato == null)
            {
                throw new InvalidDataException("flgVariato is a required property for CSSddCODTO and cannot be null");
            }
            else
            {
                this.FlgVariato = flgVariato;
            }
            // to ensure "progR" is required (not null)
            if (progR == null)
            {
                throw new InvalidDataException("progR is a required property for CSSddCODTO and cannot be null");
            }
            else
            {
                this.ProgR = progR;
            }
            // to ensure "tipocfCg44" is required (not null)
            if (tipocfCg44 == null)
            {
                throw new InvalidDataException("tipocfCg44 is a required property for CSSddCODTO and cannot be null");
            }
            else
            {
                this.TipocfCg44 = tipocfCg44;
            }
            this.Bancaallineam = bancaallineam;
            this.Causrich = causrich;
            this.Causrisp = causrisp;
            this.Cfiscsottoscr = cfiscsottoscr;
            this.CodAutoriz = codAutoriz;
            this.CodBicswift = codBicswift;
            this.CodClideb = codClideb;
            this.CodClidebprec = codClidebprec;
            this.CodIndiv = codIndiv;
            this.CodIndivprec = codIndivprec;
            this.CodRif = codRif;
            this.Contocorr = contocorr;
            this.Contocorrprec = contocorrprec;
            this.Datamandato = datamandato;
            this.Dataprimascad = dataprimascad;
            this.Datarich = datarich;
            this.Datarisp = datarisp;
            this.Dataultimascad = dataultimascad;
            this.Descrizione = descrizione;
            this.Diniego = diniego;
            this.FlgAllineam = flgAllineam;
            this.FlgDisattivato = flgDisattivato;
            this.Id = id;
            this.IdmediaCg99 = idmediaCg99;
            this.Impmaxrata = impmaxrata;
            this.IndIrsottoscr = indIrsottoscr;
            this.IndStorno = indStorno;
            this.IndStornoprec = indStornoprec;
            this.IndTipoinc = indTipoinc;
            this.IndTiposdd = indTiposdd;
            this.Locsottoscr = locsottoscr;
            this.Nrrate = nrrate;
            this.Nuovabanca = nuovabanca;
            this.Ragsosottoscr = ragsosottoscr;
            this.Ridabi = ridabi;
            this.Ridabiprec = ridabiprec;
            this.Ridcab = ridcab;
            this.Ridcabprec = ridcabprec;
            this.Ridiban = ridiban;
            this.Ridibanprec = ridibanprec;
            this.SoggtitibanCg16 = soggtitibanCg16;
            this.Tipoinclocked = tipoinclocked;
            this.Tipologia = tipologia;
            this.Tipologiaprec = tipologiaprec;
            this.CsHistorySddCO = csHistorySddCO;
            this.NationCO = nationCO;
            this.Soggtitiban = soggtitiban;
            this.ExtensionData = extensionData;
            this.AdditionalData = additionalData;
            this.PluginData = pluginData;
        }
        
        /// <summary>
        /// MG29_BANCAALLINEAM - Codice ABI Banca Allineamento
        /// </summary>
        /// <value>MG29_BANCAALLINEAM - Codice ABI Banca Allineamento</value>
        [DataMember(Name="bancaallineam", EmitDefaultValue=false)]
        public double? Bancaallineam { get; set; }

        /// <summary>
        /// MG29_CAUSRICH - Causale richiesta Azienda
        /// </summary>
        /// <value>MG29_CAUSRICH - Causale richiesta Azienda</value>
        [DataMember(Name="causrich", EmitDefaultValue=false)]
        public double? Causrich { get; set; }

        /// <summary>
        /// MG29_CAUSRISP - Causale Banca Allineamento
        /// </summary>
        /// <value>MG29_CAUSRISP - Causale Banca Allineamento</value>
        [DataMember(Name="causrisp", EmitDefaultValue=false)]
        public double? Causrisp { get; set; }

        /// <summary>
        /// MG29_CFISCSOTTOSCR - Codice fiscale sottoscrittore
        /// </summary>
        /// <value>MG29_CFISCSOTTOSCR - Codice fiscale sottoscrittore</value>
        [DataMember(Name="cfiscsottoscr", EmitDefaultValue=false)]
        public string Cfiscsottoscr { get; set; }

        /// <summary>
        /// MG29_CLIFOR_CG44 - Codice Cliente / Fornitore
        /// </summary>
        /// <value>MG29_CLIFOR_CG44 - Codice Cliente / Fornitore</value>
        [DataMember(Name="cliforCg44", EmitDefaultValue=false)]
        public double? CliforCg44 { get; set; }

        /// <summary>
        /// MG29_CODAUTORIZ - Codice autorizzazione (Acquisizione PagoBancomat)
        /// </summary>
        /// <value>MG29_CODAUTORIZ - Codice autorizzazione (Acquisizione PagoBancomat)</value>
        [DataMember(Name="codAutoriz", EmitDefaultValue=false)]
        public string CodAutoriz { get; set; }

        /// <summary>
        /// MG29_CODBICSWIFT - Codice BIC SWIFT
        /// </summary>
        /// <value>MG29_CODBICSWIFT - Codice BIC SWIFT</value>
        [DataMember(Name="codBicswift", EmitDefaultValue=false)]
        public string CodBicswift { get; set; }

        /// <summary>
        /// MG29_CODCLIDEB - Codice debitore
        /// </summary>
        /// <value>MG29_CODCLIDEB - Codice debitore</value>
        [DataMember(Name="codClideb", EmitDefaultValue=false)]
        public string CodClideb { get; set; }

        /// <summary>
        /// MG29_CODCLIDEBPREC - Codice debitore precedente
        /// </summary>
        /// <value>MG29_CODCLIDEBPREC - Codice debitore precedente</value>
        [DataMember(Name="codClidebprec", EmitDefaultValue=false)]
        public string CodClidebprec { get; set; }

        /// <summary>
        /// MG29_CODINDIV - Codice individuale&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuno&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Utenza&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Matricola&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Codice fiscale&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Codice cliente&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Codice fornitore&lt;/li&gt;&lt;li&gt;&lt;i&gt;6&lt;/i&gt; - Portafoglio commerciale&lt;/li&gt;&lt;li&gt;&lt;i&gt;9&lt;/i&gt; - Altro&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG29_CODINDIV - Codice individuale&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuno&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Utenza&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Matricola&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Codice fiscale&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Codice cliente&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Codice fornitore&lt;/li&gt;&lt;li&gt;&lt;i&gt;6&lt;/i&gt; - Portafoglio commerciale&lt;/li&gt;&lt;li&gt;&lt;i&gt;9&lt;/i&gt; - Altro&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="codIndiv", EmitDefaultValue=false)]
        public double? CodIndiv { get; set; }

        /// <summary>
        /// MG29_CODINDIVPREC - Codice individuale precedente
        /// </summary>
        /// <value>MG29_CODINDIVPREC - Codice individuale precedente</value>
        [DataMember(Name="codIndivprec", EmitDefaultValue=false)]
        public double? CodIndivprec { get; set; }

        /// <summary>
        /// MG29_CODRIF - Codice riferimento
        /// </summary>
        /// <value>MG29_CODRIF - Codice riferimento</value>
        [DataMember(Name="codRif", EmitDefaultValue=false)]
        public string CodRif { get; set; }

        /// <summary>
        /// MG29_CONTOCORR - Conto corrente
        /// </summary>
        /// <value>MG29_CONTOCORR - Conto corrente</value>
        [DataMember(Name="contocorr", EmitDefaultValue=false)]
        public string Contocorr { get; set; }

        /// <summary>
        /// MG29_CONTOCORRPREC - Conto corrente precedente
        /// </summary>
        /// <value>MG29_CONTOCORRPREC - Conto corrente precedente</value>
        [DataMember(Name="contocorrprec", EmitDefaultValue=false)]
        public string Contocorrprec { get; set; }

        /// <summary>
        /// MG29_DATAMANDATO - Data mandato RID
        /// </summary>
        /// <value>MG29_DATAMANDATO - Data mandato RID</value>
        [DataMember(Name="datamandato", EmitDefaultValue=false)]
        public DateTime? Datamandato { get; set; }

        /// <summary>
        /// MG29_DATAPRIMASCAD - Data prima scadenza
        /// </summary>
        /// <value>MG29_DATAPRIMASCAD - Data prima scadenza</value>
        [DataMember(Name="dataprimascad", EmitDefaultValue=false)]
        public DateTime? Dataprimascad { get; set; }

        /// <summary>
        /// MG29_DATARICH - Data richiesta
        /// </summary>
        /// <value>MG29_DATARICH - Data richiesta</value>
        [DataMember(Name="datarich", EmitDefaultValue=false)]
        public DateTime? Datarich { get; set; }

        /// <summary>
        /// MG29_DATARISP - Data causale Banca Allineamento
        /// </summary>
        /// <value>MG29_DATARISP - Data causale Banca Allineamento</value>
        [DataMember(Name="datarisp", EmitDefaultValue=false)]
        public DateTime? Datarisp { get; set; }

        /// <summary>
        /// MG29_DATAULTIMASCAD - Data ultima scadenza
        /// </summary>
        /// <value>MG29_DATAULTIMASCAD - Data ultima scadenza</value>
        [DataMember(Name="dataultimascad", EmitDefaultValue=false)]
        public DateTime? Dataultimascad { get; set; }

        /// <summary>
        /// MG29_DESCRIZIONE - Descrizione
        /// </summary>
        /// <value>MG29_DESCRIZIONE - Descrizione</value>
        [DataMember(Name="descrizione", EmitDefaultValue=false)]
        public string Descrizione { get; set; }

        /// <summary>
        /// MG29_DINIEGO - Diniego
        /// </summary>
        /// <value>MG29_DINIEGO - Diniego</value>
        [DataMember(Name="diniego", EmitDefaultValue=false)]
        public int? Diniego { get; set; }

        /// <summary>
        /// MG29_DITTA_CG18 - Ditta
        /// </summary>
        /// <value>MG29_DITTA_CG18 - Ditta</value>
        [DataMember(Name="dittaCg18", EmitDefaultValue=false)]
        public double? DittaCg18 { get; set; }

        /// <summary>
        /// MG29_FLGALLINEAM - Allineamento SEDA non gestito
        /// </summary>
        /// <value>MG29_FLGALLINEAM - Allineamento SEDA non gestito</value>
        [DataMember(Name="flgAllineam", EmitDefaultValue=false)]
        public double? FlgAllineam { get; set; }

        /// <summary>
        /// MG29_FLGDISATTIVATO - Dati disattivati
        /// </summary>
        /// <value>MG29_FLGDISATTIVATO - Dati disattivati</value>
        [DataMember(Name="flgDisattivato", EmitDefaultValue=false)]
        public int? FlgDisattivato { get; set; }

        /// <summary>
        /// MG29_FLGVARIATO - Variato
        /// </summary>
        /// <value>MG29_FLGVARIATO - Variato</value>
        [DataMember(Name="flgVariato", EmitDefaultValue=false)]
        public double? FlgVariato { get; set; }

        /// <summary>
        /// MG29_ID - ID (Required only in PUT/PATCH)
        /// </summary>
        /// <value>MG29_ID - ID (Required only in PUT/PATCH)</value>
        [DataMember(Name="id", EmitDefaultValue=false)]
        public int? Id { get; set; }

        /// <summary>
        /// MG29_IDMEDIA_CG99 - ID HyperMedia
        /// </summary>
        /// <value>MG29_IDMEDIA_CG99 - ID HyperMedia</value>
        [DataMember(Name="idmediaCg99", EmitDefaultValue=false)]
        public double? IdmediaCg99 { get; set; }

        /// <summary>
        /// MG29_IMPMAXRATA - Importo massimo/prefissato
        /// </summary>
        /// <value>MG29_IMPMAXRATA - Importo massimo/prefissato</value>
        [DataMember(Name="impmaxrata", EmitDefaultValue=false)]
        public double? Impmaxrata { get; set; }

        /// <summary>
        /// MG29_INDIRSOTTOSCR - Indirizzo sottoscrittore
        /// </summary>
        /// <value>MG29_INDIRSOTTOSCR - Indirizzo sottoscrittore</value>
        [DataMember(Name="indIrsottoscr", EmitDefaultValue=false)]
        public string IndIrsottoscr { get; set; }

        /// <summary>
        /// MG29_INDSTORNO - Facoltà di storno&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuno&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Facoltà di storno dopo la scadenza (D+5)&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Facoltà di storno alla scadenza&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Nessuna facoltà di storno per contestazione&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Nessuna facoltà di storno per la banca domiciliataria&lt;/li&gt;&lt;li&gt;&lt;i&gt;8&lt;/i&gt; - Esiste diritto al rimborso (D+8 settimane)&lt;/li&gt;&lt;li&gt;&lt;i&gt;9&lt;/i&gt; - Nessuna facoltà di storno per le caratteristiche del mandato&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG29_INDSTORNO - Facoltà di storno&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuno&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Facoltà di storno dopo la scadenza (D+5)&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Facoltà di storno alla scadenza&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Nessuna facoltà di storno per contestazione&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Nessuna facoltà di storno per la banca domiciliataria&lt;/li&gt;&lt;li&gt;&lt;i&gt;8&lt;/i&gt; - Esiste diritto al rimborso (D+8 settimane)&lt;/li&gt;&lt;li&gt;&lt;i&gt;9&lt;/i&gt; - Nessuna facoltà di storno per le caratteristiche del mandato&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indStorno", EmitDefaultValue=false)]
        public double? IndStorno { get; set; }

        /// <summary>
        /// MG29_INDSTORNOPREC - Facoltà di storno precedente
        /// </summary>
        /// <value>MG29_INDSTORNOPREC - Facoltà di storno precedente</value>
        [DataMember(Name="indStornoprec", EmitDefaultValue=false)]
        public double? IndStornoprec { get; set; }

        /// <summary>
        /// MG29_INDTIPOINC - Sequenza&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - First&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Recurrent&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Final&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - One-Off&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG29_INDTIPOINC - Sequenza&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - First&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Recurrent&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Final&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - One-Off&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indTipoinc", EmitDefaultValue=false)]
        public int? IndTipoinc { get; set; }

        /// <summary>
        /// MG29_INDTIPOSDD - Tipo SDD&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Core&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - B2B&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG29_INDTIPOSDD - Tipo SDD&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Core&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - B2B&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indTiposdd", EmitDefaultValue=false)]
        public double? IndTiposdd { get; set; }

        /// <summary>
        /// MG29_LOCSOTTOSCR - Località sottoscrittore
        /// </summary>
        /// <value>MG29_LOCSOTTOSCR - Località sottoscrittore</value>
        [DataMember(Name="locsottoscr", EmitDefaultValue=false)]
        public string Locsottoscr { get; set; }

        /// <summary>
        /// MG29_NRRATE - Numero rate
        /// </summary>
        /// <value>MG29_NRRATE - Numero rate</value>
        [DataMember(Name="nrrate", EmitDefaultValue=false)]
        public double? Nrrate { get; set; }

        /// <summary>
        /// MG29_NUOVABANCA - Nuovabanca
        /// </summary>
        /// <value>MG29_NUOVABANCA - Nuovabanca</value>
        [DataMember(Name="nuovabanca", EmitDefaultValue=false)]
        public double? Nuovabanca { get; set; }

        /// <summary>
        /// MG29_PROGR - Progr.
        /// </summary>
        /// <value>MG29_PROGR - Progr.</value>
        [DataMember(Name="progR", EmitDefaultValue=false)]
        public int? ProgR { get; set; }

        /// <summary>
        /// MG29_RAGSOSOTTOSCR - Ragione sociale sottoscrittore
        /// </summary>
        /// <value>MG29_RAGSOSOTTOSCR - Ragione sociale sottoscrittore</value>
        [DataMember(Name="ragsosottoscr", EmitDefaultValue=false)]
        public string Ragsosottoscr { get; set; }

        /// <summary>
        /// MG29_RIDABI - Codice ABI
        /// </summary>
        /// <value>MG29_RIDABI - Codice ABI</value>
        [DataMember(Name="ridabi", EmitDefaultValue=false)]
        public double? Ridabi { get; set; }

        /// <summary>
        /// MG29_RIDABIPREC - Codice ABI precedente
        /// </summary>
        /// <value>MG29_RIDABIPREC - Codice ABI precedente</value>
        [DataMember(Name="ridabiprec", EmitDefaultValue=false)]
        public double? Ridabiprec { get; set; }

        /// <summary>
        /// MG29_RIDCAB - Codice CAB
        /// </summary>
        /// <value>MG29_RIDCAB - Codice CAB</value>
        [DataMember(Name="ridcab", EmitDefaultValue=false)]
        public double? Ridcab { get; set; }

        /// <summary>
        /// MG29_RIDCABPREC - Codice CAB precedente
        /// </summary>
        /// <value>MG29_RIDCABPREC - Codice CAB precedente</value>
        [DataMember(Name="ridcabprec", EmitDefaultValue=false)]
        public double? Ridcabprec { get; set; }

        /// <summary>
        /// MG29_RIDIBAN - IBAN
        /// </summary>
        /// <value>MG29_RIDIBAN - IBAN</value>
        [DataMember(Name="ridiban", EmitDefaultValue=false)]
        public string Ridiban { get; set; }

        /// <summary>
        /// MG29_RIDIBANPREC - IBAN (International Bank Account Number)
        /// </summary>
        /// <value>MG29_RIDIBANPREC - IBAN (International Bank Account Number)</value>
        [DataMember(Name="ridibanprec", EmitDefaultValue=false)]
        public string Ridibanprec { get; set; }

        /// <summary>
        /// MG29_SOGGTITIBAN_CG16 - Soggetto titolare IBAN
        /// </summary>
        /// <value>MG29_SOGGTITIBAN_CG16 - Soggetto titolare IBAN</value>
        [DataMember(Name="soggtitibanCg16", EmitDefaultValue=false)]
        public int? SoggtitibanCg16 { get; set; }

        /// <summary>
        /// MG29_TIPOCF_CG44 - Tipo Cliente / Fornitore
        /// </summary>
        /// <value>MG29_TIPOCF_CG44 - Tipo Cliente / Fornitore</value>
        [DataMember(Name="tipocfCg44", EmitDefaultValue=false)]
        public double? TipocfCg44 { get; set; }

        /// <summary>
        /// MG29_TIPOINCLOCKED - Tipo seq. incasso bloccato
        /// </summary>
        /// <value>MG29_TIPOINCLOCKED - Tipo seq. incasso bloccato</value>
        [DataMember(Name="tipoinclocked", EmitDefaultValue=false)]
        public double? Tipoinclocked { get; set; }

        /// <summary>
        /// MG29_TIPOLOGIA - Tipologia&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Consumatore&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Non Consumatore&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Microimpresa&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG29_TIPOLOGIA - Tipologia&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Consumatore&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Non Consumatore&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Microimpresa&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="tipologia", EmitDefaultValue=false)]
        public double? Tipologia { get; set; }

        /// <summary>
        /// MG29_TIPOLOGIAPREC - Tipologiaprec
        /// </summary>
        /// <value>MG29_TIPOLOGIAPREC - Tipologiaprec</value>
        [DataMember(Name="tipologiaprec", EmitDefaultValue=false)]
        public double? Tipologiaprec { get; set; }

        /// <summary>
        /// Gets or Sets CsHistorySddCO
        /// </summary>
        [DataMember(Name="csHistorySddCO", EmitDefaultValue=false)]
        public List<CSHistorySddCODTO> CsHistorySddCO { get; set; }

        /// <summary>
        /// Gets or Sets NationCO
        /// </summary>
        [DataMember(Name="nationCO", EmitDefaultValue=false)]
        public NationCODTO NationCO { get; set; }

        /// <summary>
        /// Gets or Sets Soggtitiban
        /// </summary>
        [DataMember(Name="soggtitiban", EmitDefaultValue=false)]
        public GeneralMasterDataCODTO Soggtitiban { get; set; }

        /// <summary>
        /// Gets or Sets ExtensionData
        /// </summary>
        [DataMember(Name="extensionData", EmitDefaultValue=false)]
        public List<StringObjectKeyValuePair> ExtensionData { get; set; }

        /// <summary>
        /// Gets or Sets AdditionalData
        /// </summary>
        [DataMember(Name="additionalData", EmitDefaultValue=false)]
        public Dictionary<string, Object> AdditionalData { get; set; }

        /// <summary>
        /// Gets or Sets PluginData
        /// </summary>
        [DataMember(Name="pluginData", EmitDefaultValue=false)]
        public Dictionary<string, Object> PluginData { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class CSSddCODTO {\n");
            sb.Append("  Bancaallineam: ").Append(Bancaallineam).Append("\n");
            sb.Append("  Causrich: ").Append(Causrich).Append("\n");
            sb.Append("  Causrisp: ").Append(Causrisp).Append("\n");
            sb.Append("  Cfiscsottoscr: ").Append(Cfiscsottoscr).Append("\n");
            sb.Append("  CliforCg44: ").Append(CliforCg44).Append("\n");
            sb.Append("  CodAutoriz: ").Append(CodAutoriz).Append("\n");
            sb.Append("  CodBicswift: ").Append(CodBicswift).Append("\n");
            sb.Append("  CodClideb: ").Append(CodClideb).Append("\n");
            sb.Append("  CodClidebprec: ").Append(CodClidebprec).Append("\n");
            sb.Append("  CodIndiv: ").Append(CodIndiv).Append("\n");
            sb.Append("  CodIndivprec: ").Append(CodIndivprec).Append("\n");
            sb.Append("  CodRif: ").Append(CodRif).Append("\n");
            sb.Append("  Contocorr: ").Append(Contocorr).Append("\n");
            sb.Append("  Contocorrprec: ").Append(Contocorrprec).Append("\n");
            sb.Append("  Datamandato: ").Append(Datamandato).Append("\n");
            sb.Append("  Dataprimascad: ").Append(Dataprimascad).Append("\n");
            sb.Append("  Datarich: ").Append(Datarich).Append("\n");
            sb.Append("  Datarisp: ").Append(Datarisp).Append("\n");
            sb.Append("  Dataultimascad: ").Append(Dataultimascad).Append("\n");
            sb.Append("  Descrizione: ").Append(Descrizione).Append("\n");
            sb.Append("  Diniego: ").Append(Diniego).Append("\n");
            sb.Append("  DittaCg18: ").Append(DittaCg18).Append("\n");
            sb.Append("  FlgAllineam: ").Append(FlgAllineam).Append("\n");
            sb.Append("  FlgDisattivato: ").Append(FlgDisattivato).Append("\n");
            sb.Append("  FlgVariato: ").Append(FlgVariato).Append("\n");
            sb.Append("  Id: ").Append(Id).Append("\n");
            sb.Append("  IdmediaCg99: ").Append(IdmediaCg99).Append("\n");
            sb.Append("  Impmaxrata: ").Append(Impmaxrata).Append("\n");
            sb.Append("  IndIrsottoscr: ").Append(IndIrsottoscr).Append("\n");
            sb.Append("  IndStorno: ").Append(IndStorno).Append("\n");
            sb.Append("  IndStornoprec: ").Append(IndStornoprec).Append("\n");
            sb.Append("  IndTipoinc: ").Append(IndTipoinc).Append("\n");
            sb.Append("  IndTiposdd: ").Append(IndTiposdd).Append("\n");
            sb.Append("  Locsottoscr: ").Append(Locsottoscr).Append("\n");
            sb.Append("  Nrrate: ").Append(Nrrate).Append("\n");
            sb.Append("  Nuovabanca: ").Append(Nuovabanca).Append("\n");
            sb.Append("  ProgR: ").Append(ProgR).Append("\n");
            sb.Append("  Ragsosottoscr: ").Append(Ragsosottoscr).Append("\n");
            sb.Append("  Ridabi: ").Append(Ridabi).Append("\n");
            sb.Append("  Ridabiprec: ").Append(Ridabiprec).Append("\n");
            sb.Append("  Ridcab: ").Append(Ridcab).Append("\n");
            sb.Append("  Ridcabprec: ").Append(Ridcabprec).Append("\n");
            sb.Append("  Ridiban: ").Append(Ridiban).Append("\n");
            sb.Append("  Ridibanprec: ").Append(Ridibanprec).Append("\n");
            sb.Append("  SoggtitibanCg16: ").Append(SoggtitibanCg16).Append("\n");
            sb.Append("  TipocfCg44: ").Append(TipocfCg44).Append("\n");
            sb.Append("  Tipoinclocked: ").Append(Tipoinclocked).Append("\n");
            sb.Append("  Tipologia: ").Append(Tipologia).Append("\n");
            sb.Append("  Tipologiaprec: ").Append(Tipologiaprec).Append("\n");
            sb.Append("  CsHistorySddCO: ").Append(CsHistorySddCO).Append("\n");
            sb.Append("  NationCO: ").Append(NationCO).Append("\n");
            sb.Append("  Soggtitiban: ").Append(Soggtitiban).Append("\n");
            sb.Append("  ExtensionData: ").Append(ExtensionData).Append("\n");
            sb.Append("  AdditionalData: ").Append(AdditionalData).Append("\n");
            sb.Append("  PluginData: ").Append(PluginData).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as CSSddCODTO);
        }

        /// <summary>
        /// Returns true if CSSddCODTO instances are equal
        /// </summary>
        /// <param name="input">Instance of CSSddCODTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(CSSddCODTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.Bancaallineam == input.Bancaallineam ||
                    (this.Bancaallineam != null &&
                    this.Bancaallineam.Equals(input.Bancaallineam))
                ) && 
                (
                    this.Causrich == input.Causrich ||
                    (this.Causrich != null &&
                    this.Causrich.Equals(input.Causrich))
                ) && 
                (
                    this.Causrisp == input.Causrisp ||
                    (this.Causrisp != null &&
                    this.Causrisp.Equals(input.Causrisp))
                ) && 
                (
                    this.Cfiscsottoscr == input.Cfiscsottoscr ||
                    (this.Cfiscsottoscr != null &&
                    this.Cfiscsottoscr.Equals(input.Cfiscsottoscr))
                ) && 
                (
                    this.CliforCg44 == input.CliforCg44 ||
                    (this.CliforCg44 != null &&
                    this.CliforCg44.Equals(input.CliforCg44))
                ) && 
                (
                    this.CodAutoriz == input.CodAutoriz ||
                    (this.CodAutoriz != null &&
                    this.CodAutoriz.Equals(input.CodAutoriz))
                ) && 
                (
                    this.CodBicswift == input.CodBicswift ||
                    (this.CodBicswift != null &&
                    this.CodBicswift.Equals(input.CodBicswift))
                ) && 
                (
                    this.CodClideb == input.CodClideb ||
                    (this.CodClideb != null &&
                    this.CodClideb.Equals(input.CodClideb))
                ) && 
                (
                    this.CodClidebprec == input.CodClidebprec ||
                    (this.CodClidebprec != null &&
                    this.CodClidebprec.Equals(input.CodClidebprec))
                ) && 
                (
                    this.CodIndiv == input.CodIndiv ||
                    (this.CodIndiv != null &&
                    this.CodIndiv.Equals(input.CodIndiv))
                ) && 
                (
                    this.CodIndivprec == input.CodIndivprec ||
                    (this.CodIndivprec != null &&
                    this.CodIndivprec.Equals(input.CodIndivprec))
                ) && 
                (
                    this.CodRif == input.CodRif ||
                    (this.CodRif != null &&
                    this.CodRif.Equals(input.CodRif))
                ) && 
                (
                    this.Contocorr == input.Contocorr ||
                    (this.Contocorr != null &&
                    this.Contocorr.Equals(input.Contocorr))
                ) && 
                (
                    this.Contocorrprec == input.Contocorrprec ||
                    (this.Contocorrprec != null &&
                    this.Contocorrprec.Equals(input.Contocorrprec))
                ) && 
                (
                    this.Datamandato == input.Datamandato ||
                    (this.Datamandato != null &&
                    this.Datamandato.Equals(input.Datamandato))
                ) && 
                (
                    this.Dataprimascad == input.Dataprimascad ||
                    (this.Dataprimascad != null &&
                    this.Dataprimascad.Equals(input.Dataprimascad))
                ) && 
                (
                    this.Datarich == input.Datarich ||
                    (this.Datarich != null &&
                    this.Datarich.Equals(input.Datarich))
                ) && 
                (
                    this.Datarisp == input.Datarisp ||
                    (this.Datarisp != null &&
                    this.Datarisp.Equals(input.Datarisp))
                ) && 
                (
                    this.Dataultimascad == input.Dataultimascad ||
                    (this.Dataultimascad != null &&
                    this.Dataultimascad.Equals(input.Dataultimascad))
                ) && 
                (
                    this.Descrizione == input.Descrizione ||
                    (this.Descrizione != null &&
                    this.Descrizione.Equals(input.Descrizione))
                ) && 
                (
                    this.Diniego == input.Diniego ||
                    (this.Diniego != null &&
                    this.Diniego.Equals(input.Diniego))
                ) && 
                (
                    this.DittaCg18 == input.DittaCg18 ||
                    (this.DittaCg18 != null &&
                    this.DittaCg18.Equals(input.DittaCg18))
                ) && 
                (
                    this.FlgAllineam == input.FlgAllineam ||
                    (this.FlgAllineam != null &&
                    this.FlgAllineam.Equals(input.FlgAllineam))
                ) && 
                (
                    this.FlgDisattivato == input.FlgDisattivato ||
                    (this.FlgDisattivato != null &&
                    this.FlgDisattivato.Equals(input.FlgDisattivato))
                ) && 
                (
                    this.FlgVariato == input.FlgVariato ||
                    (this.FlgVariato != null &&
                    this.FlgVariato.Equals(input.FlgVariato))
                ) && 
                (
                    this.Id == input.Id ||
                    (this.Id != null &&
                    this.Id.Equals(input.Id))
                ) && 
                (
                    this.IdmediaCg99 == input.IdmediaCg99 ||
                    (this.IdmediaCg99 != null &&
                    this.IdmediaCg99.Equals(input.IdmediaCg99))
                ) && 
                (
                    this.Impmaxrata == input.Impmaxrata ||
                    (this.Impmaxrata != null &&
                    this.Impmaxrata.Equals(input.Impmaxrata))
                ) && 
                (
                    this.IndIrsottoscr == input.IndIrsottoscr ||
                    (this.IndIrsottoscr != null &&
                    this.IndIrsottoscr.Equals(input.IndIrsottoscr))
                ) && 
                (
                    this.IndStorno == input.IndStorno ||
                    (this.IndStorno != null &&
                    this.IndStorno.Equals(input.IndStorno))
                ) && 
                (
                    this.IndStornoprec == input.IndStornoprec ||
                    (this.IndStornoprec != null &&
                    this.IndStornoprec.Equals(input.IndStornoprec))
                ) && 
                (
                    this.IndTipoinc == input.IndTipoinc ||
                    (this.IndTipoinc != null &&
                    this.IndTipoinc.Equals(input.IndTipoinc))
                ) && 
                (
                    this.IndTiposdd == input.IndTiposdd ||
                    (this.IndTiposdd != null &&
                    this.IndTiposdd.Equals(input.IndTiposdd))
                ) && 
                (
                    this.Locsottoscr == input.Locsottoscr ||
                    (this.Locsottoscr != null &&
                    this.Locsottoscr.Equals(input.Locsottoscr))
                ) && 
                (
                    this.Nrrate == input.Nrrate ||
                    (this.Nrrate != null &&
                    this.Nrrate.Equals(input.Nrrate))
                ) && 
                (
                    this.Nuovabanca == input.Nuovabanca ||
                    (this.Nuovabanca != null &&
                    this.Nuovabanca.Equals(input.Nuovabanca))
                ) && 
                (
                    this.ProgR == input.ProgR ||
                    (this.ProgR != null &&
                    this.ProgR.Equals(input.ProgR))
                ) && 
                (
                    this.Ragsosottoscr == input.Ragsosottoscr ||
                    (this.Ragsosottoscr != null &&
                    this.Ragsosottoscr.Equals(input.Ragsosottoscr))
                ) && 
                (
                    this.Ridabi == input.Ridabi ||
                    (this.Ridabi != null &&
                    this.Ridabi.Equals(input.Ridabi))
                ) && 
                (
                    this.Ridabiprec == input.Ridabiprec ||
                    (this.Ridabiprec != null &&
                    this.Ridabiprec.Equals(input.Ridabiprec))
                ) && 
                (
                    this.Ridcab == input.Ridcab ||
                    (this.Ridcab != null &&
                    this.Ridcab.Equals(input.Ridcab))
                ) && 
                (
                    this.Ridcabprec == input.Ridcabprec ||
                    (this.Ridcabprec != null &&
                    this.Ridcabprec.Equals(input.Ridcabprec))
                ) && 
                (
                    this.Ridiban == input.Ridiban ||
                    (this.Ridiban != null &&
                    this.Ridiban.Equals(input.Ridiban))
                ) && 
                (
                    this.Ridibanprec == input.Ridibanprec ||
                    (this.Ridibanprec != null &&
                    this.Ridibanprec.Equals(input.Ridibanprec))
                ) && 
                (
                    this.SoggtitibanCg16 == input.SoggtitibanCg16 ||
                    (this.SoggtitibanCg16 != null &&
                    this.SoggtitibanCg16.Equals(input.SoggtitibanCg16))
                ) && 
                (
                    this.TipocfCg44 == input.TipocfCg44 ||
                    (this.TipocfCg44 != null &&
                    this.TipocfCg44.Equals(input.TipocfCg44))
                ) && 
                (
                    this.Tipoinclocked == input.Tipoinclocked ||
                    (this.Tipoinclocked != null &&
                    this.Tipoinclocked.Equals(input.Tipoinclocked))
                ) && 
                (
                    this.Tipologia == input.Tipologia ||
                    (this.Tipologia != null &&
                    this.Tipologia.Equals(input.Tipologia))
                ) && 
                (
                    this.Tipologiaprec == input.Tipologiaprec ||
                    (this.Tipologiaprec != null &&
                    this.Tipologiaprec.Equals(input.Tipologiaprec))
                ) && 
                (
                    this.CsHistorySddCO == input.CsHistorySddCO ||
                    this.CsHistorySddCO != null &&
                    input.CsHistorySddCO != null &&
                    this.CsHistorySddCO.SequenceEqual(input.CsHistorySddCO)
                ) && 
                (
                    this.NationCO == input.NationCO ||
                    (this.NationCO != null &&
                    this.NationCO.Equals(input.NationCO))
                ) && 
                (
                    this.Soggtitiban == input.Soggtitiban ||
                    (this.Soggtitiban != null &&
                    this.Soggtitiban.Equals(input.Soggtitiban))
                ) && 
                (
                    this.ExtensionData == input.ExtensionData ||
                    this.ExtensionData != null &&
                    input.ExtensionData != null &&
                    this.ExtensionData.SequenceEqual(input.ExtensionData)
                ) && 
                (
                    this.AdditionalData == input.AdditionalData ||
                    this.AdditionalData != null &&
                    input.AdditionalData != null &&
                    this.AdditionalData.SequenceEqual(input.AdditionalData)
                ) && 
                (
                    this.PluginData == input.PluginData ||
                    this.PluginData != null &&
                    input.PluginData != null &&
                    this.PluginData.SequenceEqual(input.PluginData)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.Bancaallineam != null)
                    hashCode = hashCode * 59 + this.Bancaallineam.GetHashCode();
                if (this.Causrich != null)
                    hashCode = hashCode * 59 + this.Causrich.GetHashCode();
                if (this.Causrisp != null)
                    hashCode = hashCode * 59 + this.Causrisp.GetHashCode();
                if (this.Cfiscsottoscr != null)
                    hashCode = hashCode * 59 + this.Cfiscsottoscr.GetHashCode();
                if (this.CliforCg44 != null)
                    hashCode = hashCode * 59 + this.CliforCg44.GetHashCode();
                if (this.CodAutoriz != null)
                    hashCode = hashCode * 59 + this.CodAutoriz.GetHashCode();
                if (this.CodBicswift != null)
                    hashCode = hashCode * 59 + this.CodBicswift.GetHashCode();
                if (this.CodClideb != null)
                    hashCode = hashCode * 59 + this.CodClideb.GetHashCode();
                if (this.CodClidebprec != null)
                    hashCode = hashCode * 59 + this.CodClidebprec.GetHashCode();
                if (this.CodIndiv != null)
                    hashCode = hashCode * 59 + this.CodIndiv.GetHashCode();
                if (this.CodIndivprec != null)
                    hashCode = hashCode * 59 + this.CodIndivprec.GetHashCode();
                if (this.CodRif != null)
                    hashCode = hashCode * 59 + this.CodRif.GetHashCode();
                if (this.Contocorr != null)
                    hashCode = hashCode * 59 + this.Contocorr.GetHashCode();
                if (this.Contocorrprec != null)
                    hashCode = hashCode * 59 + this.Contocorrprec.GetHashCode();
                if (this.Datamandato != null)
                    hashCode = hashCode * 59 + this.Datamandato.GetHashCode();
                if (this.Dataprimascad != null)
                    hashCode = hashCode * 59 + this.Dataprimascad.GetHashCode();
                if (this.Datarich != null)
                    hashCode = hashCode * 59 + this.Datarich.GetHashCode();
                if (this.Datarisp != null)
                    hashCode = hashCode * 59 + this.Datarisp.GetHashCode();
                if (this.Dataultimascad != null)
                    hashCode = hashCode * 59 + this.Dataultimascad.GetHashCode();
                if (this.Descrizione != null)
                    hashCode = hashCode * 59 + this.Descrizione.GetHashCode();
                if (this.Diniego != null)
                    hashCode = hashCode * 59 + this.Diniego.GetHashCode();
                if (this.DittaCg18 != null)
                    hashCode = hashCode * 59 + this.DittaCg18.GetHashCode();
                if (this.FlgAllineam != null)
                    hashCode = hashCode * 59 + this.FlgAllineam.GetHashCode();
                if (this.FlgDisattivato != null)
                    hashCode = hashCode * 59 + this.FlgDisattivato.GetHashCode();
                if (this.FlgVariato != null)
                    hashCode = hashCode * 59 + this.FlgVariato.GetHashCode();
                if (this.Id != null)
                    hashCode = hashCode * 59 + this.Id.GetHashCode();
                if (this.IdmediaCg99 != null)
                    hashCode = hashCode * 59 + this.IdmediaCg99.GetHashCode();
                if (this.Impmaxrata != null)
                    hashCode = hashCode * 59 + this.Impmaxrata.GetHashCode();
                if (this.IndIrsottoscr != null)
                    hashCode = hashCode * 59 + this.IndIrsottoscr.GetHashCode();
                if (this.IndStorno != null)
                    hashCode = hashCode * 59 + this.IndStorno.GetHashCode();
                if (this.IndStornoprec != null)
                    hashCode = hashCode * 59 + this.IndStornoprec.GetHashCode();
                if (this.IndTipoinc != null)
                    hashCode = hashCode * 59 + this.IndTipoinc.GetHashCode();
                if (this.IndTiposdd != null)
                    hashCode = hashCode * 59 + this.IndTiposdd.GetHashCode();
                if (this.Locsottoscr != null)
                    hashCode = hashCode * 59 + this.Locsottoscr.GetHashCode();
                if (this.Nrrate != null)
                    hashCode = hashCode * 59 + this.Nrrate.GetHashCode();
                if (this.Nuovabanca != null)
                    hashCode = hashCode * 59 + this.Nuovabanca.GetHashCode();
                if (this.ProgR != null)
                    hashCode = hashCode * 59 + this.ProgR.GetHashCode();
                if (this.Ragsosottoscr != null)
                    hashCode = hashCode * 59 + this.Ragsosottoscr.GetHashCode();
                if (this.Ridabi != null)
                    hashCode = hashCode * 59 + this.Ridabi.GetHashCode();
                if (this.Ridabiprec != null)
                    hashCode = hashCode * 59 + this.Ridabiprec.GetHashCode();
                if (this.Ridcab != null)
                    hashCode = hashCode * 59 + this.Ridcab.GetHashCode();
                if (this.Ridcabprec != null)
                    hashCode = hashCode * 59 + this.Ridcabprec.GetHashCode();
                if (this.Ridiban != null)
                    hashCode = hashCode * 59 + this.Ridiban.GetHashCode();
                if (this.Ridibanprec != null)
                    hashCode = hashCode * 59 + this.Ridibanprec.GetHashCode();
                if (this.SoggtitibanCg16 != null)
                    hashCode = hashCode * 59 + this.SoggtitibanCg16.GetHashCode();
                if (this.TipocfCg44 != null)
                    hashCode = hashCode * 59 + this.TipocfCg44.GetHashCode();
                if (this.Tipoinclocked != null)
                    hashCode = hashCode * 59 + this.Tipoinclocked.GetHashCode();
                if (this.Tipologia != null)
                    hashCode = hashCode * 59 + this.Tipologia.GetHashCode();
                if (this.Tipologiaprec != null)
                    hashCode = hashCode * 59 + this.Tipologiaprec.GetHashCode();
                if (this.CsHistorySddCO != null)
                    hashCode = hashCode * 59 + this.CsHistorySddCO.GetHashCode();
                if (this.NationCO != null)
                    hashCode = hashCode * 59 + this.NationCO.GetHashCode();
                if (this.Soggtitiban != null)
                    hashCode = hashCode * 59 + this.Soggtitiban.GetHashCode();
                if (this.ExtensionData != null)
                    hashCode = hashCode * 59 + this.ExtensionData.GetHashCode();
                if (this.AdditionalData != null)
                    hashCode = hashCode * 59 + this.AdditionalData.GetHashCode();
                if (this.PluginData != null)
                    hashCode = hashCode * 59 + this.PluginData.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
