/* 
 * TSE Cloud - CO
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.1000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using RestSharp;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace IO.Swagger.Api
{
    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
        public interface IAgencyCOApi : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// Get new
        /// </summary>
        /// <remarks>
        /// Get an empty object of type corresponding
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>AgencyCODTO</returns>
        AgencyCODTO ApiV1EnvironmentCOAgencyCOGet (string op, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null);

        /// <summary>
        /// Get new
        /// </summary>
        /// <remarks>
        /// Get an empty object of type corresponding
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>ApiResponse of AgencyCODTO</returns>
        ApiResponse<AgencyCODTO> ApiV1EnvironmentCOAgencyCOGetWithHttpInfo (string op, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null);
        /// <summary>
        /// Delete
        /// </summary>
        /// <remarks>
        /// Deleting object of type 
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns></returns>
        void ApiV1EnvironmentCOAgencyCOIdDelete (string id, string environment, string codBanca, string authorizationScope, string company = null, string user = null, string acceptLanguage = null);

        /// <summary>
        /// Delete
        /// </summary>
        /// <remarks>
        /// Deleting object of type 
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> ApiV1EnvironmentCOAgencyCOIdDeleteWithHttpInfo (string id, string environment, string codBanca, string authorizationScope, string company = null, string user = null, string acceptLanguage = null);
        /// <summary>
        /// Get by ID
        /// </summary>
        /// <remarks>
        /// Get an object of type corresponding the requested id
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>AgencyCODTO</returns>
        AgencyCODTO ApiV1EnvironmentCOAgencyCOIdGet (string id, string environment, string codBanca, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null);

        /// <summary>
        /// Get by ID
        /// </summary>
        /// <remarks>
        /// Get an object of type corresponding the requested id
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>ApiResponse of AgencyCODTO</returns>
        ApiResponse<AgencyCODTO> ApiV1EnvironmentCOAgencyCOIdGetWithHttpInfo (string id, string environment, string codBanca, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null);
        /// <summary>
        /// Update partial
        /// </summary>
        /// <remarks>
        /// Patching an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns></returns>
        void ApiV1EnvironmentCOAgencyCOIdPatch (Object body, string authorizationScope, string codBanca, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);

        /// <summary>
        /// Update partial
        /// </summary>
        /// <remarks>
        /// Patching an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> ApiV1EnvironmentCOAgencyCOIdPatchWithHttpInfo (Object body, string authorizationScope, string codBanca, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);
        /// <summary>
        /// Update
        /// </summary>
        /// <remarks>
        /// Updating an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>AgencyCODTO</returns>
        AgencyCODTO ApiV1EnvironmentCOAgencyCOIdPut (AgencyCODTO body, string authorizationScope, string codBanca, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);

        /// <summary>
        /// Update
        /// </summary>
        /// <remarks>
        /// Updating an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of AgencyCODTO</returns>
        ApiResponse<AgencyCODTO> ApiV1EnvironmentCOAgencyCOIdPutWithHttpInfo (AgencyCODTO body, string authorizationScope, string codBanca, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);
        /// <summary>
        /// Create
        /// </summary>
        /// <remarks>
        /// Creating new object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>AgencyCODTO</returns>
        AgencyCODTO ApiV1EnvironmentCOAgencyCOPost (AgencyCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null);

        /// <summary>
        /// Create
        /// </summary>
        /// <remarks>
        /// Creating new object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of AgencyCODTO</returns>
        ApiResponse<AgencyCODTO> ApiV1EnvironmentCOAgencyCOPostWithHttpInfo (AgencyCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null);
        /// <summary>
        /// Validate
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns></returns>
        void ApiV1EnvironmentCOAgencyCOValidatePost (AgencyCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null);

        /// <summary>
        /// Validate
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> ApiV1EnvironmentCOAgencyCOValidatePostWithHttpInfo (AgencyCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null);
        /// <summary>
        /// Validation of one on more properties of Type
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ValidateDTO</returns>
        ValidateDTO ApiV1EnvironmentCOAgencyCOValidatePropertiesPost (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string company = null, string user = null);

        /// <summary>
        /// Validation of one on more properties of Type
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of ValidateDTO</returns>
        ApiResponse<ValidateDTO> ApiV1EnvironmentCOAgencyCOValidatePropertiesPostWithHttpInfo (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string company = null, string user = null);
        #endregion Synchronous Operations
        #region Asynchronous Operations
        /// <summary>
        /// Get new
        /// </summary>
        /// <remarks>
        /// Get an empty object of type corresponding
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of AgencyCODTO</returns>
        System.Threading.Tasks.Task<AgencyCODTO> ApiV1EnvironmentCOAgencyCOGetAsync (string op, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null);

        /// <summary>
        /// Get new
        /// </summary>
        /// <remarks>
        /// Get an empty object of type corresponding
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse (AgencyCODTO)</returns>
        System.Threading.Tasks.Task<ApiResponse<AgencyCODTO>> ApiV1EnvironmentCOAgencyCOGetAsyncWithHttpInfo (string op, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null);
        /// <summary>
        /// Delete
        /// </summary>
        /// <remarks>
        /// Deleting object of type 
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task ApiV1EnvironmentCOAgencyCOIdDeleteAsync (string id, string environment, string codBanca, string authorizationScope, string company = null, string user = null, string acceptLanguage = null);

        /// <summary>
        /// Delete
        /// </summary>
        /// <remarks>
        /// Deleting object of type 
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentCOAgencyCOIdDeleteAsyncWithHttpInfo (string id, string environment, string codBanca, string authorizationScope, string company = null, string user = null, string acceptLanguage = null);
        /// <summary>
        /// Get by ID
        /// </summary>
        /// <remarks>
        /// Get an object of type corresponding the requested id
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of AgencyCODTO</returns>
        System.Threading.Tasks.Task<AgencyCODTO> ApiV1EnvironmentCOAgencyCOIdGetAsync (string id, string environment, string codBanca, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null);

        /// <summary>
        /// Get by ID
        /// </summary>
        /// <remarks>
        /// Get an object of type corresponding the requested id
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse (AgencyCODTO)</returns>
        System.Threading.Tasks.Task<ApiResponse<AgencyCODTO>> ApiV1EnvironmentCOAgencyCOIdGetAsyncWithHttpInfo (string id, string environment, string codBanca, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null);
        /// <summary>
        /// Update partial
        /// </summary>
        /// <remarks>
        /// Patching an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task ApiV1EnvironmentCOAgencyCOIdPatchAsync (Object body, string authorizationScope, string codBanca, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);

        /// <summary>
        /// Update partial
        /// </summary>
        /// <remarks>
        /// Patching an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentCOAgencyCOIdPatchAsyncWithHttpInfo (Object body, string authorizationScope, string codBanca, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);
        /// <summary>
        /// Update
        /// </summary>
        /// <remarks>
        /// Updating an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of AgencyCODTO</returns>
        System.Threading.Tasks.Task<AgencyCODTO> ApiV1EnvironmentCOAgencyCOIdPutAsync (AgencyCODTO body, string authorizationScope, string codBanca, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);

        /// <summary>
        /// Update
        /// </summary>
        /// <remarks>
        /// Updating an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (AgencyCODTO)</returns>
        System.Threading.Tasks.Task<ApiResponse<AgencyCODTO>> ApiV1EnvironmentCOAgencyCOIdPutAsyncWithHttpInfo (AgencyCODTO body, string authorizationScope, string codBanca, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);
        /// <summary>
        /// Create
        /// </summary>
        /// <remarks>
        /// Creating new object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of AgencyCODTO</returns>
        System.Threading.Tasks.Task<AgencyCODTO> ApiV1EnvironmentCOAgencyCOPostAsync (AgencyCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null);

        /// <summary>
        /// Create
        /// </summary>
        /// <remarks>
        /// Creating new object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (AgencyCODTO)</returns>
        System.Threading.Tasks.Task<ApiResponse<AgencyCODTO>> ApiV1EnvironmentCOAgencyCOPostAsyncWithHttpInfo (AgencyCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null);
        /// <summary>
        /// Validate
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task ApiV1EnvironmentCOAgencyCOValidatePostAsync (AgencyCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null);

        /// <summary>
        /// Validate
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentCOAgencyCOValidatePostAsyncWithHttpInfo (AgencyCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null);
        /// <summary>
        /// Validation of one on more properties of Type
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ValidateDTO</returns>
        System.Threading.Tasks.Task<ValidateDTO> ApiV1EnvironmentCOAgencyCOValidatePropertiesPostAsync (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string company = null, string user = null);

        /// <summary>
        /// Validation of one on more properties of Type
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (ValidateDTO)</returns>
        System.Threading.Tasks.Task<ApiResponse<ValidateDTO>> ApiV1EnvironmentCOAgencyCOValidatePropertiesPostAsyncWithHttpInfo (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string company = null, string user = null);
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
        public partial class AgencyCOApi : IAgencyCOApi
    {
        private IO.Swagger.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="AgencyCOApi"/> class.
        /// </summary>
        /// <returns></returns>
        public AgencyCOApi(String basePath)
        {
            this.Configuration = new IO.Swagger.Client.Configuration { BasePath = basePath };

            ExceptionFactory = IO.Swagger.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="AgencyCOApi"/> class
        /// </summary>
        /// <returns></returns>
        public AgencyCOApi()
        {
            this.Configuration = IO.Swagger.Client.Configuration.Default;

            ExceptionFactory = IO.Swagger.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="AgencyCOApi"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public AgencyCOApi(IO.Swagger.Client.Configuration configuration = null)
        {
            if (configuration == null) // use the default one in Configuration
                this.Configuration = IO.Swagger.Client.Configuration.Default;
            else
                this.Configuration = configuration;

            ExceptionFactory = IO.Swagger.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public String GetBasePath()
        {
            return this.Configuration.ApiClient.RestClient.Options.BaseUrl.ToString();
        }

        /// <summary>
        /// Sets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        [Obsolete("SetBasePath is deprecated, please do 'Configuration.ApiClient = new ApiClient(\"http://new-path\")' instead.")]
        public void SetBasePath(String basePath)
        {
            // do nothing
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public IO.Swagger.Client.Configuration Configuration {get; set;}

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public IO.Swagger.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// Gets the default header.
        /// </summary>
        /// <returns>Dictionary of HTTP header</returns>
        [Obsolete("DefaultHeader is deprecated, please use Configuration.DefaultHeader instead.")]
        public IDictionary<String, String> DefaultHeader()
        {
            return new ReadOnlyDictionary<string, string>(this.Configuration.DefaultHeader);
        }

        /// <summary>
        /// Add default header.
        /// </summary>
        /// <param name="key">Header field name.</param>
        /// <param name="value">Header field value.</param>
        /// <returns></returns>
        [Obsolete("AddDefaultHeader is deprecated, please use Configuration.AddDefaultHeader instead.")]
        public void AddDefaultHeader(string key, string value)
        {
            this.Configuration.AddDefaultHeader(key, value);
        }

        /// <summary>
        /// Get new Get an empty object of type corresponding
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>AgencyCODTO</returns>
        public AgencyCODTO ApiV1EnvironmentCOAgencyCOGet (string op, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null)
        {
             ApiResponse<AgencyCODTO> localVarResponse = ApiV1EnvironmentCOAgencyCOGetWithHttpInfo(op, environment, authorizationScope, company, user, acceptLanguage);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Get new Get an empty object of type corresponding
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>ApiResponse of AgencyCODTO</returns>
        public ApiResponse< AgencyCODTO > ApiV1EnvironmentCOAgencyCOGetWithHttpInfo (string op, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null)
        {
            // verify the required parameter 'op' is set
            if (op == null)
                throw new ApiException(400, "Missing required parameter 'op' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOGet");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOGet");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOGet");

            var localVarPath = "/api/v1/{environment}/CO/AgencyCO";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Get, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOAgencyCOGet", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<AgencyCODTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (AgencyCODTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(AgencyCODTO)));
        }

        /// <summary>
        /// Get new Get an empty object of type corresponding
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of AgencyCODTO</returns>
        public async System.Threading.Tasks.Task<AgencyCODTO> ApiV1EnvironmentCOAgencyCOGetAsync (string op, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null)
        {
             ApiResponse<AgencyCODTO> localVarResponse = await ApiV1EnvironmentCOAgencyCOGetAsyncWithHttpInfo(op, environment, authorizationScope, company, user, acceptLanguage);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Get new Get an empty object of type corresponding
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse (AgencyCODTO)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<AgencyCODTO>> ApiV1EnvironmentCOAgencyCOGetAsyncWithHttpInfo (string op, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null)
        {
            // verify the required parameter 'op' is set
            if (op == null)
                throw new ApiException(400, "Missing required parameter 'op' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOGet");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOGet");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOGet");

            var localVarPath = "/api/v1/{environment}/CO/AgencyCO";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Get, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOAgencyCOGet", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<AgencyCODTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (AgencyCODTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(AgencyCODTO)));
        }

        /// <summary>
        /// Delete Deleting object of type 
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns></returns>
        public void ApiV1EnvironmentCOAgencyCOIdDelete (string id, string environment, string codBanca, string authorizationScope, string company = null, string user = null, string acceptLanguage = null)
        {
             ApiV1EnvironmentCOAgencyCOIdDeleteWithHttpInfo(id, environment, codBanca, authorizationScope, company, user, acceptLanguage);
        }

        /// <summary>
        /// Delete Deleting object of type 
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public ApiResponse<Object> ApiV1EnvironmentCOAgencyCOIdDeleteWithHttpInfo (string id, string environment, string codBanca, string authorizationScope, string company = null, string user = null, string acceptLanguage = null)
        {
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdDelete");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdDelete");
            // verify the required parameter 'codBanca' is set
            if (codBanca == null)
                throw new ApiException(400, "Missing required parameter 'codBanca' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdDelete");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdDelete");

            var localVarPath = "/api/v1/{environment}/CO/AgencyCO/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (codBanca != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "CodBanca", codBanca)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Delete, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOAgencyCOIdDelete", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Delete Deleting object of type 
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task ApiV1EnvironmentCOAgencyCOIdDeleteAsync (string id, string environment, string codBanca, string authorizationScope, string company = null, string user = null, string acceptLanguage = null)
        {
             await ApiV1EnvironmentCOAgencyCOIdDeleteAsyncWithHttpInfo(id, environment, codBanca, authorizationScope, company, user, acceptLanguage);

        }

        /// <summary>
        /// Delete Deleting object of type 
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentCOAgencyCOIdDeleteAsyncWithHttpInfo (string id, string environment, string codBanca, string authorizationScope, string company = null, string user = null, string acceptLanguage = null)
        {
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdDelete");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdDelete");
            // verify the required parameter 'codBanca' is set
            if (codBanca == null)
                throw new ApiException(400, "Missing required parameter 'codBanca' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdDelete");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdDelete");

            var localVarPath = "/api/v1/{environment}/CO/AgencyCO/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (codBanca != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "CodBanca", codBanca)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Delete, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOAgencyCOIdDelete", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Get by ID Get an object of type corresponding the requested id
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>AgencyCODTO</returns>
        public AgencyCODTO ApiV1EnvironmentCOAgencyCOIdGet (string id, string environment, string codBanca, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null)
        {
             ApiResponse<AgencyCODTO> localVarResponse = ApiV1EnvironmentCOAgencyCOIdGetWithHttpInfo(id, environment, codBanca, authorizationScope, dlevel, dlevelkey, company, user, acceptLanguage);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Get by ID Get an object of type corresponding the requested id
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>ApiResponse of AgencyCODTO</returns>
        public ApiResponse< AgencyCODTO > ApiV1EnvironmentCOAgencyCOIdGetWithHttpInfo (string id, string environment, string codBanca, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null)
        {
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdGet");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdGet");
            // verify the required parameter 'codBanca' is set
            if (codBanca == null)
                throw new ApiException(400, "Missing required parameter 'codBanca' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdGet");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdGet");

            var localVarPath = "/api/v1/{environment}/CO/AgencyCO/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (dlevel != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "dlevel", dlevel)); // query parameter
            if (dlevelkey != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "dlevelkey", dlevelkey)); // query parameter
            if (codBanca != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "CodBanca", codBanca)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Get, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOAgencyCOIdGet", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<AgencyCODTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (AgencyCODTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(AgencyCODTO)));
        }

        /// <summary>
        /// Get by ID Get an object of type corresponding the requested id
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of AgencyCODTO</returns>
        public async System.Threading.Tasks.Task<AgencyCODTO> ApiV1EnvironmentCOAgencyCOIdGetAsync (string id, string environment, string codBanca, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null)
        {
             ApiResponse<AgencyCODTO> localVarResponse = await ApiV1EnvironmentCOAgencyCOIdGetAsyncWithHttpInfo(id, environment, codBanca, authorizationScope, dlevel, dlevelkey, company, user, acceptLanguage);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Get by ID Get an object of type corresponding the requested id
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse (AgencyCODTO)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<AgencyCODTO>> ApiV1EnvironmentCOAgencyCOIdGetAsyncWithHttpInfo (string id, string environment, string codBanca, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null)
        {
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdGet");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdGet");
            // verify the required parameter 'codBanca' is set
            if (codBanca == null)
                throw new ApiException(400, "Missing required parameter 'codBanca' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdGet");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdGet");

            var localVarPath = "/api/v1/{environment}/CO/AgencyCO/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (dlevel != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "dlevel", dlevel)); // query parameter
            if (dlevelkey != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "dlevelkey", dlevelkey)); // query parameter
            if (codBanca != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "CodBanca", codBanca)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Get, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOAgencyCOIdGet", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<AgencyCODTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (AgencyCODTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(AgencyCODTO)));
        }

        /// <summary>
        /// Update partial Patching an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns></returns>
        public void ApiV1EnvironmentCOAgencyCOIdPatch (Object body, string authorizationScope, string codBanca, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
             ApiV1EnvironmentCOAgencyCOIdPatchWithHttpInfo(body, authorizationScope, codBanca, id, environment, acceptLanguage, force, op, company, user);
        }

        /// <summary>
        /// Update partial Patching an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public ApiResponse<Object> ApiV1EnvironmentCOAgencyCOIdPatchWithHttpInfo (Object body, string authorizationScope, string codBanca, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdPatch");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdPatch");
            // verify the required parameter 'codBanca' is set
            if (codBanca == null)
                throw new ApiException(400, "Missing required parameter 'codBanca' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdPatch");
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdPatch");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdPatch");

            var localVarPath = "/api/v1/{environment}/CO/AgencyCO/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (codBanca != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "CodBanca", codBanca)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Patch, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOAgencyCOIdPatch", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Update partial Patching an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task ApiV1EnvironmentCOAgencyCOIdPatchAsync (Object body, string authorizationScope, string codBanca, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
             await ApiV1EnvironmentCOAgencyCOIdPatchAsyncWithHttpInfo(body, authorizationScope, codBanca, id, environment, acceptLanguage, force, op, company, user);

        }

        /// <summary>
        /// Update partial Patching an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentCOAgencyCOIdPatchAsyncWithHttpInfo (Object body, string authorizationScope, string codBanca, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdPatch");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdPatch");
            // verify the required parameter 'codBanca' is set
            if (codBanca == null)
                throw new ApiException(400, "Missing required parameter 'codBanca' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdPatch");
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdPatch");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdPatch");

            var localVarPath = "/api/v1/{environment}/CO/AgencyCO/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (codBanca != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "CodBanca", codBanca)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Patch, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOAgencyCOIdPatch", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Update Updating an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>AgencyCODTO</returns>
        public AgencyCODTO ApiV1EnvironmentCOAgencyCOIdPut (AgencyCODTO body, string authorizationScope, string codBanca, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
             ApiResponse<AgencyCODTO> localVarResponse = ApiV1EnvironmentCOAgencyCOIdPutWithHttpInfo(body, authorizationScope, codBanca, id, environment, acceptLanguage, force, op, company, user);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Update Updating an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of AgencyCODTO</returns>
        public ApiResponse< AgencyCODTO > ApiV1EnvironmentCOAgencyCOIdPutWithHttpInfo (AgencyCODTO body, string authorizationScope, string codBanca, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdPut");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdPut");
            // verify the required parameter 'codBanca' is set
            if (codBanca == null)
                throw new ApiException(400, "Missing required parameter 'codBanca' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdPut");
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdPut");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdPut");

            var localVarPath = "/api/v1/{environment}/CO/AgencyCO/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (codBanca != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "CodBanca", codBanca)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Put, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOAgencyCOIdPut", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<AgencyCODTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (AgencyCODTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(AgencyCODTO)));
        }

        /// <summary>
        /// Update Updating an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of AgencyCODTO</returns>
        public async System.Threading.Tasks.Task<AgencyCODTO> ApiV1EnvironmentCOAgencyCOIdPutAsync (AgencyCODTO body, string authorizationScope, string codBanca, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
             ApiResponse<AgencyCODTO> localVarResponse = await ApiV1EnvironmentCOAgencyCOIdPutAsyncWithHttpInfo(body, authorizationScope, codBanca, id, environment, acceptLanguage, force, op, company, user);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Update Updating an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="codBanca">CodBanca Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (AgencyCODTO)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<AgencyCODTO>> ApiV1EnvironmentCOAgencyCOIdPutAsyncWithHttpInfo (AgencyCODTO body, string authorizationScope, string codBanca, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdPut");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdPut");
            // verify the required parameter 'codBanca' is set
            if (codBanca == null)
                throw new ApiException(400, "Missing required parameter 'codBanca' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdPut");
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdPut");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOIdPut");

            var localVarPath = "/api/v1/{environment}/CO/AgencyCO/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (codBanca != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "CodBanca", codBanca)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Put, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOAgencyCOIdPut", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<AgencyCODTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (AgencyCODTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(AgencyCODTO)));
        }

        /// <summary>
        /// Create Creating new object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>AgencyCODTO</returns>
        public AgencyCODTO ApiV1EnvironmentCOAgencyCOPost (AgencyCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)
        {
             ApiResponse<AgencyCODTO> localVarResponse = ApiV1EnvironmentCOAgencyCOPostWithHttpInfo(body, authorizationScope, environment, acceptLanguage, company, user);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Create Creating new object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of AgencyCODTO</returns>
        public ApiResponse< AgencyCODTO > ApiV1EnvironmentCOAgencyCOPostWithHttpInfo (AgencyCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOPost");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOPost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOPost");

            var localVarPath = "/api/v1/{environment}/CO/AgencyCO";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOAgencyCOPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<AgencyCODTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (AgencyCODTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(AgencyCODTO)));
        }

        /// <summary>
        /// Create Creating new object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of AgencyCODTO</returns>
        public async System.Threading.Tasks.Task<AgencyCODTO> ApiV1EnvironmentCOAgencyCOPostAsync (AgencyCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)
        {
             ApiResponse<AgencyCODTO> localVarResponse = await ApiV1EnvironmentCOAgencyCOPostAsyncWithHttpInfo(body, authorizationScope, environment, acceptLanguage, company, user);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Create Creating new object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (AgencyCODTO)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<AgencyCODTO>> ApiV1EnvironmentCOAgencyCOPostAsyncWithHttpInfo (AgencyCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOPost");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOPost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOPost");

            var localVarPath = "/api/v1/{environment}/CO/AgencyCO";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOAgencyCOPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<AgencyCODTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (AgencyCODTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(AgencyCODTO)));
        }

        /// <summary>
        /// Validate Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns></returns>
        public void ApiV1EnvironmentCOAgencyCOValidatePost (AgencyCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)
        {
             ApiV1EnvironmentCOAgencyCOValidatePostWithHttpInfo(body, authorizationScope, environment, acceptLanguage, company, user);
        }

        /// <summary>
        /// Validate Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public ApiResponse<Object> ApiV1EnvironmentCOAgencyCOValidatePostWithHttpInfo (AgencyCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOValidatePost");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOValidatePost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOValidatePost");

            var localVarPath = "/api/v1/{environment}/CO/AgencyCO/validate";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOAgencyCOValidatePost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Validate Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task ApiV1EnvironmentCOAgencyCOValidatePostAsync (AgencyCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)
        {
             await ApiV1EnvironmentCOAgencyCOValidatePostAsyncWithHttpInfo(body, authorizationScope, environment, acceptLanguage, company, user);

        }

        /// <summary>
        /// Validate Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentCOAgencyCOValidatePostAsyncWithHttpInfo (AgencyCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOValidatePost");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOValidatePost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOValidatePost");

            var localVarPath = "/api/v1/{environment}/CO/AgencyCO/validate";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOAgencyCOValidatePost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Validation of one on more properties of Type Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ValidateDTO</returns>
        public ValidateDTO ApiV1EnvironmentCOAgencyCOValidatePropertiesPost (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string company = null, string user = null)
        {
             ApiResponse<ValidateDTO> localVarResponse = ApiV1EnvironmentCOAgencyCOValidatePropertiesPostWithHttpInfo(authorizationScope, environment, body, acceptLanguage, company, user);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Validation of one on more properties of Type Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of ValidateDTO</returns>
        public ApiResponse< ValidateDTO > ApiV1EnvironmentCOAgencyCOValidatePropertiesPostWithHttpInfo (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string company = null, string user = null)
        {
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOValidatePropertiesPost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOValidatePropertiesPost");

            var localVarPath = "/api/v1/{environment}/CO/AgencyCO/validateProperties";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOAgencyCOValidatePropertiesPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<ValidateDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (ValidateDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(ValidateDTO)));
        }

        /// <summary>
        /// Validation of one on more properties of Type Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ValidateDTO</returns>
        public async System.Threading.Tasks.Task<ValidateDTO> ApiV1EnvironmentCOAgencyCOValidatePropertiesPostAsync (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string company = null, string user = null)
        {
             ApiResponse<ValidateDTO> localVarResponse = await ApiV1EnvironmentCOAgencyCOValidatePropertiesPostAsyncWithHttpInfo(authorizationScope, environment, body, acceptLanguage, company, user);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Validation of one on more properties of Type Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (ValidateDTO)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<ValidateDTO>> ApiV1EnvironmentCOAgencyCOValidatePropertiesPostAsyncWithHttpInfo (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string company = null, string user = null)
        {
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOValidatePropertiesPost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling AgencyCOApi->ApiV1EnvironmentCOAgencyCOValidatePropertiesPost");

            var localVarPath = "/api/v1/{environment}/CO/AgencyCO/validateProperties";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOAgencyCOValidatePropertiesPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<ValidateDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (ValidateDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(ValidateDTO)));
        }

    }
}
